/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.AnimatedFragment;
import de.tuttas.GameAPI.AnimatedFragmentListener;
import de.tuttas.GameAPI.Winkel;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.ExplosionListener;

public class Explosion
implements AnimatedFragmentListener {
    public static final int SMALL = 1;
    public static final int LARGE = 2;
    public static final int AIR_LARGE = 3;
    int type;
    boolean visible;
    ExplosionListener listener;
    static Image image;
    public AnimatedFragment af1;
    int w;
    int x1Pos;
    int x2Pos;
    int x3Pos;
    int y1Pos;
    int y2Pos;
    int y3Pos;
    static int wOffset;
    int delay;
    int delayCounter;

    public Explosion(int t, int d) {
        this.type = t;
        this.delay = d;
        this.delayCounter = 0;
        if (image == null) {
            try {
                image = Image.createImage((String)"/explode.png");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.af1 = new AnimatedFragment(image, 16, 1, 1, 10, 10);
        wOffset = 180 / (image.getWidth() / 16);
        this.af1.setListener(this);
        this.visible = false;
    }

    public void start(int t, int x, int y) {
        this.type = t;
        this.af1.reset();
        this.x1Pos = x;
        this.x2Pos = x;
        this.x3Pos = x;
        this.y1Pos = y;
        this.y2Pos = y;
        this.y3Pos = y;
        if (t == 3) {
            this.w = 0;
            wOffset = 90 / (image.getWidth() / 16);
        } else {
            this.w = 0;
            wOffset = 180 / (image.getWidth() / 16);
        }
        this.visible = true;
        this.delayCounter = this.delay;
    }

    public void setListener(ExplosionListener l) {
        this.listener = l;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void tick(int d) {
        this.x1Pos -= d;
        this.x2Pos -= d;
        this.x3Pos -= d;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        this.w += wOffset;
        this.x2Pos -= 2;
        this.x3Pos += 2;
        if (this.type == 3) {
            if (this.w > 90) {
                this.w = 90;
            }
        } else if (this.w >= 180) {
            this.w = 180;
        }
        switch (this.type) {
            case 2: {
                this.af1.xPos = this.x2Pos;
                this.af1.yPos = this.y2Pos - Winkel.sin(this.w) * 16 / 1000;
                this.af1.paint(g);
                this.af1.xPos = this.x3Pos;
                this.af1.yPos = this.y3Pos - Winkel.sin(this.w) * 16 / 1000;
                this.af1.paint(g);
                if (this.w >= 180 && this.listener != null) {
                    this.listener.explosionFinished(this);
                }
            }
            case 1: {
                this.af1.xPos = this.x1Pos;
                this.af1.yPos = this.y1Pos;
                this.af1.paint(g);
                break;
            }
            case 3: {
                if (this.w >= 90) {
                    this.y1Pos += 2;
                    ++this.y2Pos;
                    ++this.y3Pos;
                }
                this.af1.xPos = this.x2Pos;
                this.af1.yPos = this.y2Pos + Winkel.sin(this.w) * 2 * 16 / 1000;
                this.af1.paint(g);
                this.af1.xPos = this.x3Pos;
                this.af1.yPos = this.y3Pos + Winkel.sin(this.w) * 2 * 16 / 1000;
                this.af1.paint(g);
                this.af1.xPos = this.x1Pos;
                this.af1.yPos = this.y1Pos + Winkel.sin(this.w) * 16 / 1000;
                this.af1.paint(g);
            }
        }
        --this.delayCounter;
        if (this.delayCounter <= 0) {
            this.delayCounter = this.delay;
            this.af1.next();
        }
    }

    public void disappear(AnimatedFragment af) {
        if (this.listener != null) {
            this.listener.explosionFinished(this);
        }
        this.visible = false;
    }

    public void animationFinished(AnimatedFragment af) {
        this.setVisible(false);
        if (this.listener != null) {
            this.listener.explosionFinished(this);
        }
        this.visible = false;
    }

    static {
        SMALL = 1;
        LARGE = 2;
        AIR_LARGE = 3;
    }
}

