/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.Sprite;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.ConfigSound;
import vscroller.Displayable;
import vscroller.Explosion;
import vscroller.ExplosionListener;

public class Bomb
extends Sprite
implements ExplosionListener {
    Explosion explode;

    public Bomb() {
        try {
            this.image = Image.createImage((String)"/bomb.png");
            this.setImage(this.image);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.explode = new Explosion(2, 2);
        this.explode.setListener(this);
    }

    public void move(int dx, int dy) {
        if (!this.explode.visible) {
            super.move(dx, dy);
            if (this.y - this.height > 84) {
                this.explode.start(2, this.x + this.width / 2, this.y);
                ConfigSound.soundExplode();
                Displayable.wall.setID(2, this.x + this.width / 2);
            }
        }
    }

    public void paint(Graphics g) {
        if (!this.explode.visible) {
            super.paint(g);
        } else {
            this.explode.paint(g);
        }
    }

    public void reset() {
        this.visible = false;
        this.x = 0;
        this.y = 0;
    }

    public void tick(int w) {
        if (this.explode.visible) {
            this.explode.tick(w);
        }
    }

    public void explosionFinished(Explosion ex) {
        this.setVisible(false);
        this.setPos(0, 0);
    }
}

