/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI.Score;

import de.tuttas.GameAPI.Score.GlobalListListener;
import de.tuttas.GameAPI.Score.Score;
import de.tuttas.GameAPI.Score.ScoreList;
import de.tuttas.GameAPI.Score.ScoreListManager;
import java.io.IOException;
import java.util.NoSuchElementException;

public abstract class GlobalScoreListManager
extends ScoreListManager
implements Runnable {
    public static int SUBMIT = 1;
    public static int GET = 2;
    public static int GET_TODAY = 3;
    public static int GET_LAST = 4;
    int state;
    public static String CONNECT = "Connect";
    public static String OPEN = "Open";
    public static String CLOSE = "Close";
    public static String ABBORT = "Abbort";
    public static String PARSING = "Parse";
    public static String FAILED = "Failed";
    public static String FINISHED = "Finished";
    public static String FORBIDDEN = "Forbidden";
    public static String LIST_EMPTY = "List Empty";
    public static String SCORE_USED = "TopScrore used";
    public static String RECEIVE = "Receive";
    String server;
    ScoreList scoreList;
    Thread runner;
    GlobalListListener listener;
    private boolean stop = false;
    String gameName;
    int numbers;

    public GlobalScoreListManager(ScoreList sl, String ip) {
        this.server = ip;
        this.scoreList = sl;
    }

    public void setListener(GlobalListListener l) {
        this.listener = l;
    }

    public void submit(String game) {
        this.gameName = game;
        this.state = SUBMIT;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void get(String name, int num) {
        this.gameName = name;
        this.numbers = num;
        this.state = GET;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.setPriority(1);
        this.runner.start();
    }

    public void getToday(String name, int num) {
        this.gameName = name;
        this.numbers = num;
        this.state = GET_TODAY;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void getLast(String name, int num) {
        this.gameName = name;
        this.numbers = num;
        this.state = GET_LAST;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void stop() {
        this.stop = true;
        this.listener.globalMessage(ABBORT);
        this.listener.setPercent(100);
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            if (this.state == SUBMIT) {
                try {
                    Score tmpScore = (Score)this.scoreList.scoreVector.firstElement();
                    this.submitScore(tmpScore);
                }
                catch (NoSuchElementException ne) {
                    this.listener.globalMessage(LIST_EMPTY);
                    this.listener.submitFinished(-1);
                }
            } else if (this.state == GET) {
                this.getGlobal(this.numbers);
            } else if (this.state == GET_TODAY) {
                this.getToday(this.numbers);
            } else if (this.state == GET_LAST) {
                this.getLast(this.numbers);
            }
            this.runner = null;
        }
    }

    private void getToday(int num) {
        try {
            String s = this.getViaHttpConnection(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.server))).append("gettoday.php?game=").append(this.gameName).append("&num=").append(num).append("&type=plain"))));
            if (this.stop) {
                this.listener.globalList(null, GET_TODAY);
            } else {
                this.listener.globalMessage(PARSING);
                this.listener.globalList(this.parseString(s), GET_TODAY);
            }
        }
        catch (IOException iox) {
            this.listener.globalMessage(FAILED);
            this.listener.globalList(null, -1);
        }
    }

    private void getLast(int num) {
        try {
            String s = this.getViaHttpConnection(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.server))).append("getlast.php?game=").append(this.gameName).append("&num=").append(num).append("&type=plain"))));
            if (this.stop) {
                this.listener.globalList(null, GET_LAST);
            } else {
                this.listener.globalMessage(PARSING);
                this.listener.globalList(this.parseString(s), GET_LAST);
            }
        }
        catch (IOException iox) {
            this.listener.globalMessage(FAILED);
            this.listener.globalList(null, -1);
        }
    }

    private void getGlobal(int num) {
        try {
            String s = this.getViaHttpConnection(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.server))).append("get.php?game=").append(this.gameName).append("&num=").append(num).append("&type=plain"))));
            if (this.stop) {
                this.listener.globalList(null, GET);
            } else {
                this.listener.globalMessage(PARSING);
                this.listener.globalList(this.parseString(s), GET);
            }
        }
        catch (IOException iox) {
            this.listener.globalMessage(FAILED);
            this.listener.globalList(null, -1);
        }
    }

    private ScoreList parseString(String s) {
        if (s == null) {
            return null;
        }
        int lines = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++lines;
        }
        ScoreList sl = new ScoreList();
        this.listener.setPercent(0);
        int j = 0;
        while (s.indexOf("\n") != -1) {
            Score tmpScore = new Score(s.substring(0, s.indexOf("\n")));
            sl.scoreVector.addElement(tmpScore);
            if (this.stop) {
                return null;
            }
            s = s.substring(s.indexOf("\n") + 1);
            this.listener.setPercent(++j * 100 / lines);
        }
        this.listener.setPercent(100);
        this.listener.globalMessage(FINISHED);
        return sl;
    }

    private void submitScore(Score tmpScore) {
        if (!tmpScore.sync) {
            try {
                System.out.println("Top Score:".concat(String.valueOf(String.valueOf(tmpScore.toString()))));
                if (tmpScore.location == null) {
                    System.out.println("Ohne LOcation !");
                }
                String g = "";
                g = tmpScore.location != null ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.server))).append("add.php?game=").append(this.gameName).append("&name=").append(GlobalScoreListManager.encode(tmpScore.name)).append("&score=").append(tmpScore.value).append("&location=").append(GlobalScoreListManager.encode(tmpScore.location)))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.server))).append("add.php?game=").append(this.gameName).append("&name=").append(GlobalScoreListManager.encode(tmpScore.name)).append("&score=").append(tmpScore.value)));
                String s = this.getViaHttpConnection(g);
                try {
                    int rank = Integer.parseInt(s);
                    this.listener.submitFinished(rank);
                    this.scoreList.use(tmpScore);
                }
                catch (IllegalArgumentException io) {
                    this.listener.globalMessage(s);
                    this.listener.submitFinished(-1);
                }
            }
            catch (IOException iox) {
                this.listener.globalMessage(FAILED);
                this.listener.submitFinished(-1);
            }
            catch (NoSuchElementException ne) {
                this.listener.globalMessage(LIST_EMPTY);
                this.listener.submitFinished(-1);
            }
        } else {
            this.listener.globalMessage(SCORE_USED);
            this.listener.submitFinished(-1);
        }
    }

    /*
     * Exception decompiling
     */
    private String getViaHttpConnection(String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String encode(String in) {
        byte[] src = in.getBytes();
        if (src == null) {
            return "";
        }
        int sl = src.length;
        StringBuffer dst = new StringBuffer(3 * sl);
        for (int i = 0; i < sl; ++i) {
            char c = (char)(src[i] & 0xFF);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '.') {
                dst.append(c);
                continue;
            }
            if (c == ' ') {
                dst.append('+');
                continue;
            }
            String hex = "00".concat(String.valueOf(String.valueOf(Integer.toString(c & 0xFF, 16))));
            dst.append('%');
            dst.append(hex.substring(hex.length() - 2).toUpperCase());
        }
        return dst.toString();
    }
}

