/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.FragmentImage;
import de.tuttas.GameAPI.Scroll;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.ConfigGeneric;
import vscroller.Enemy;
import vscroller.Explosion;
import vscroller.ExplosionListener;
import vscroller.FireListener;
import vscroller.VScroller;

public class Fire
implements ExplosionListener {
    public static final int NORMAL = 1;
    public static final int EXPLODE = 2;
    public int state;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public int index;
    public static FragmentImage fi;
    public Explosion explode;
    FireListener listener;
    int xPos;
    int yPos;
    int width;
    int height;
    boolean visible;

    public Fire(int i) {
        this.index = i;
        if (fi == null) {
            try {
                fi = new FragmentImage(Image.createImage((String)"/shot.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.explode = new Explosion(1, 2);
        this.explode.setListener(this);
        this.width = Fire.fi.largeImage.getWidth() / 2;
        this.height = Fire.fi.largeImage.getHeight();
        this.state = 1;
    }

    public void setPos(int x, int y) {
        this.xPos = x;
        this.yPos = y;
        this.state = 1;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics g) {
        if (this.visible) {
            if (this.state == 1) {
                fi.paint(g, this.xPos, this.yPos, this.index, 0, this.width, this.height);
            } else if (this.state == 2) {
                g.setClip(0, 0, 128, 128);
                this.explode.paint(g);
            }
        }
    }

    public void setListener(FireListener l) {
        this.listener = l;
    }

    public boolean hit(Enemy en) {
        if (this.visible && en.dotInSprite(this.xPos + this.width / 2, this.yPos + this.height / 2)) {
            this.setVisible(false);
            return true;
        }
        return false;
    }

    public boolean hitObstacle(Scroll sc) {
        int i;
        if (!this.visible) {
            return false;
        }
        if (this.yPos < 84) {
            return false;
        }
        if (this.state != 1) {
            return false;
        }
        for (i = 0; i < ConfigGeneric.EXPLOSIVE_OBSTACLES.length; ++i) {
            if (ConfigGeneric.EXPLOSIVE_OBSTACLES[i] != sc.getID(this.xPos - sc.width / 2)) continue;
            this.state = 2;
            this.explode.start(2, this.xPos - 16, this.yPos - 8);
            sc.setID(2, this.xPos);
            VScroller.displayable.addScore(10);
            return true;
        }
        for (i = 0; i < ConfigGeneric.NORMAL_OBSTACLES.length; ++i) {
            if (ConfigGeneric.NORMAL_OBSTACLES[i] != sc.getID(this.xPos - sc.width / 2)) continue;
            this.state = 2;
            this.explode.start(1, this.xPos, this.yPos + this.height / 2);
            sc.setID(0, this.xPos);
            VScroller.displayable.addScore(5);
            return true;
        }
        for (i = 0; i < ConfigGeneric.BONUS_ELEMENTS.length; ++i) {
            if (ConfigGeneric.BONUS_ELEMENTS[i] != sc.getID(this.xPos - sc.width / 2)) continue;
            this.state = 2;
            this.explode.start(1, this.xPos, this.yPos + this.height / 2);
            sc.setID(0, this.xPos);
            return true;
        }
        return false;
    }

    public void tick(int d) {
        this.explode.tick(d);
    }

    public void move(int dx) {
        if (this.state == 1) {
            if (this.index == 0) {
                this.xPos += dx;
                if (this.xPos > 128) {
                    this.listener.disappear(this);
                }
            } else {
                this.yPos -= dx;
                if (this.yPos < -this.height) {
                    this.listener.disappear(this);
                }
            }
        }
    }

    public void explosionFinished(Explosion af) {
        this.state = 1;
        this.visible = false;
        af.setVisible(false);
        this.listener.disappear(this);
    }

    static {
        NORMAL = 1;
        EXPLODE = 2;
        HORIZONTAL = 0;
        VERTICAL = 1;
    }
}

