/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.Sprite;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.Bomb;
import vscroller.ConfigSound;
import vscroller.Explosion;
import vscroller.ExplosionListener;
import vscroller.VScroller;

public class Enemy
extends Sprite
implements ExplosionListener {
    Explosion explode;
    Bomb bomb;

    public Enemy() {
        try {
            this.image = Image.createImage((String)"/enemy.png");
            this.setImage(this.image);
            this.setBoundaryBox(7, 9, 32, 33);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bomb = new Bomb();
        this.bomb.setVisible(false);
        this.explode = new Explosion(2, 1);
        this.explode.setListener(this);
        this.reset();
        this.visible = false;
    }

    public void explode() {
        this.explode.start(3, this.x + this.width / 2 - 16, this.y);
        this.visible = false;
        VScroller.displayable.addScore(50);
        ConfigSound.soundExplode();
    }

    public void reset() {
        this.visible = false;
        this.x = 128;
        this.y = 20;
        this.bomb.reset();
    }

    public void paint(Graphics g) {
        if (this.visible) {
            g.drawImage(this.image, this.x, this.y, 20);
        } else {
            this.explode.paint(g);
        }
        if (this.bomb.isVisible()) {
            this.bomb.paint(g);
            this.bomb.move(0, 75);
        }
    }

    public void tick(int w) {
        this.bomb.tick(w);
    }

    public void move(int dx) {
        super.move(dx, 0);
        if (this.x < -this.image.getWidth()) {
            this.visible = false;
        }
    }

    public void explosionFinished(Explosion ex) {
        this.reset();
    }

    public void throwBomb() {
        if (!this.bomb.isVisible()) {
            this.bomb.setPos(this.x + this.width / 2 - this.bomb.width / 2, this.y + this.height - this.bomb.height);
            this.bomb.setVisible(true);
            ConfigSound.soundThrowBomb();
        }
    }
}

