/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI.Score;

import de.tuttas.GameAPI.DBManager;
import de.tuttas.GameAPI.Score.Score;
import java.util.Vector;

public class ScoreList {
    public String name;
    public Vector scoreVector = new Vector();
    private DBManager dbm;
    public static final int SIZE = 10;
    private Score tmpScore;

    public ScoreList(String n) {
        this.name = n;
        this.dbm = new DBManager(n);
        Vector v = this.dbm.read();
        for (int i = 0; i < v.size(); ++i) {
            Score tmpScore = new Score((String)v.elementAt(i));
            Integer in = (Integer)this.dbm.getIdVector().elementAt(i);
            tmpScore.id = in;
            this.scoreVector.addElement(tmpScore);
        }
        this.sort();
    }

    public ScoreList() {
    }

    public int inList(int sc) {
        if (sc == 0) {
            return -1;
        }
        if (this.scoreVector.size() == 0) {
            return 1;
        }
        for (int i = 0; i < this.scoreVector.size(); ++i) {
            Score tmpScore = (Score)this.scoreVector.elementAt(i);
            if (tmpScore.value > (long)sc) continue;
            return i + 1;
        }
        if (this.scoreVector.size() < 10) {
            return this.scoreVector.size() + 1;
        }
        return -1;
    }

    public void sort() {
        for (int i = 0; i <= this.scoreVector.size(); ++i) {
            for (int j = 0; j < this.scoreVector.size() - 1; ++j) {
                Score tmpScore1 = (Score)this.scoreVector.elementAt(j);
                Score tmpScore2 = (Score)this.scoreVector.elementAt(j + 1);
                if (tmpScore2.value <= tmpScore1.value && (tmpScore2.value != tmpScore1.value || tmpScore2.id <= tmpScore1.id)) continue;
                this.scoreVector.setElementAt(tmpScore2, j);
                this.scoreVector.setElementAt(tmpScore1, j + 1);
            }
        }
    }

    public int add(Score s) {
        for (int i = 0; i < this.scoreVector.size(); ++i) {
            Score tmpScore = (Score)this.scoreVector.elementAt(i);
            if (tmpScore.value > s.value) continue;
            this.scoreVector.insertElementAt(s, i);
            if (this.scoreVector.size() > 10) {
                this.scoreVector.removeElementAt(this.scoreVector.size() - 1);
            }
            if (this.dbm != null) {
                this.writeVector(this.scoreVector);
            }
            return i + 1;
        }
        if (this.scoreVector.size() < 10) {
            this.scoreVector.addElement(s);
            if (this.dbm != null) {
                int id;
                s.id = id = this.dbm.append(s.toString());
            }
            return this.scoreVector.size();
        }
        return -1;
    }

    public void use(Score s) {
        s.sync = true;
        this.set(s);
    }

    private void writeVector(Vector v) {
        this.dbm.delete();
        this.dbm = new DBManager(this.name);
        for (int k = 0; k < v.size(); ++k) {
            int id;
            Score tScore = (Score)v.elementAt(k);
            tScore.id = id = this.dbm.write(tScore.toString());
        }
    }

    public void set(Score s) {
        this.dbm.set(s.id, s.toString());
    }

    static {
        SIZE = 10;
    }
}

