/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.FragmentImage;
import de.tuttas.GameAPI.ScrollListener;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Scroll {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public int mode;
    int[] order;
    FragmentImage fi;
    public int width;
    int height;
    Image image;
    int xPos;
    int index;
    int rest;
    int screenwidth;
    ScrollListener listener;

    public Scroll(String picName, int sd, int w, int[] or, int m, boolean direct) {
        this.width = w;
        this.mode = m;
        this.screenwidth = sd;
        try {
            this.fi = new FragmentImage(Image.createImage((String)picName));
            this.height = this.fi.largeImage.getHeight();
            if (!direct) {
                this.image = this.mode == 1 ? Image.createImage((int)(sd + this.width), (int)this.height) : Image.createImage((int)this.width, (int)(sd + this.height));
            }
            this.reset(or);
            this.index = this.image != null ? this.buildImage(this.image.getGraphics(), this.index, 0) : this.calcIndex(this.index, 0);
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
    }

    public void setListener(ScrollListener l) {
        this.listener = l;
    }

    public void set(int[] w) {
        this.order = new int[w.length];
        for (int i = 0; i < w.length; ++i) {
            this.order[i] = w[i];
        }
    }

    public void paint(Graphics g, int y) {
        if (this.image != null) {
            if (this.mode == 1) {
                g.drawImage(this.image, this.xPos, y, 20);
            } else {
                g.drawImage(this.image, y, this.xPos, 20);
            }
        } else {
            int i = this.index;
            for (int x = this.xPos; x < this.screenwidth; x += this.width) {
                try {
                    if (this.mode == 1) {
                        this.fi.paint(g, x, y, this.order[i], 0, this.width, this.height);
                    } else {
                        this.fi.paint(g, y, x, this.order[i], 0, this.width, this.height);
                    }
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ab) {
                    i = 0;
                    if (this.mode == 1) {
                        this.fi.paint(g, x, y, this.order[i], 0, this.width, this.height);
                    } else {
                        this.fi.paint(g, y, x, this.order[i], 0, this.width, this.height);
                    }
                    if (this.listener == null) continue;
                    this.listener.finished(this);
                }
            }
        }
    }

    public int getID(int xp) {
        try {
            int n = this.order[this.index + (xp - this.xPos) / this.width];
            return n;
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            int n = this.order[(xp - this.xPos) / this.width];
            return n;
        }
    }

    public void setID(int id, int xp) {
        this.order[this.index + (xp - this.xPos) / this.width] = id;
    }

    public void move(int v) {
        int ganz = v / 100;
        this.rest += Math.abs(v % 100);
        if (v > 0) {
            this.xPos -= ganz + this.rest / 100;
            if (this.listener != null && ganz + this.rest / 100 > 0) {
                this.listener.moved(ganz + this.rest / 100);
            }
        } else {
            this.xPos += -ganz + this.rest / 100;
            if (this.listener != null && -ganz + this.rest / 100 > 0) {
                this.listener.moved(ganz - this.rest / 100);
            }
        }
        if (this.rest / 100 > 0) {
            this.rest -= 100;
        }
        if (this.mode == 1) {
            if (v > 0 && -this.xPos >= this.width) {
                this.xPos = 0;
                this.index = this.image != null ? this.buildImage(this.image.getGraphics(), this.index, v) : this.calcIndex(this.index, v);
            } else if (v < 0 && this.xPos >= 0) {
                this.xPos = -this.width;
                this.index = this.image != null ? this.buildImage(this.image.getGraphics(), this.index, v) : this.calcIndex(this.index, v);
            }
        } else if (v > 0 && -this.xPos >= this.height) {
            this.xPos = 0;
            this.index = this.image != null ? this.buildImage(this.image.getGraphics(), this.index, v) : this.calcIndex(this.index, v);
        } else if (v < 0 && this.xPos >= 0) {
            this.xPos = -this.height;
            this.index = this.image != null ? this.buildImage(this.image.getGraphics(), this.index, v) : this.calcIndex(this.index, v);
        }
    }

    public void reset(int[] o) {
        this.xPos = 0;
        this.index = 0;
        this.rest = 0;
        this.set(o);
    }

    private int buildImage(Graphics g, int i, int v) {
        int j = i = this.calcIndex(i, v);
        if (this.mode == 1) {
            for (int x = 0; x <= this.image.getWidth(); x += this.width) {
                try {
                    this.fi.paint(g, x, 0, this.order[i], 0, this.width, this.height);
                }
                catch (ArrayIndexOutOfBoundsException aob) {
                    i = 0;
                    this.fi.paint(g, x, 0, this.order[i], 0, this.width, this.height);
                }
                ++i;
            }
        } else {
            for (int x = 0; x <= this.image.getHeight(); x += this.height) {
                try {
                    this.fi.paint(g, 0, x, this.order[i], 0, this.width, this.height);
                }
                catch (ArrayIndexOutOfBoundsException aob) {
                    i = 0;
                    this.fi.paint(g, 0, x, this.order[i], 0, this.width, this.height);
                }
                ++i;
            }
        }
        return j;
    }

    private int calcIndex(int i, int v) {
        if (v > 0) {
            if (++i >= this.order.length) {
                i = -1;
                if (this.listener != null) {
                    this.listener.finished(this);
                }
            }
        } else if (v < 0 && --i < 0) {
            i = this.order.length - 1;
            if (this.listener != null) {
                this.listener.finished(this);
            }
        }
        return i;
    }

    static {
        HORIZONTAL = 1;
        VERTICAL = 2;
    }
}

