/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.spritehandler;

import com.funfil.midp.games.spritehandler.LayerSprite;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextSprite
implements LayerSprite {
    public static final int LEFT_ALIGN = 0;
    public static final int RIGHT_ALIGN = 1;
    public static final int CENTER_ALIGN = 2;
    public static final int JUSTIFIED_ALIGN = 3;
    public static final int PLAIN = 4;
    private int x;
    private int y;
    private int lineWidth;
    private int lineSpacing;
    private int lineNo = 0;
    private int noOfLines = 1;
    private int size = 1;
    private int align;
    private Font font;
    private String string;
    Vector lines;
    private int rgb;
    private boolean flag = true;
    private Image image;

    public TextSprite(String string, int x, int y, int lineWidth) {
        this.string = string;
        this.x = x;
        this.y = y;
        this.lineWidth = lineWidth;
        this.lines = new Vector();
        this.align = 0;
        this.font = Font.getFont((int)64, (int)0, (int)8);
        this.lineSpacing = this.font.getHeight();
    }

    public void down() {
        if (this.lineNo + 1 + this.noOfLines <= this.size) {
            ++this.lineNo;
        }
    }

    public void up() {
        if (this.lineNo - 1 >= 0) {
            --this.lineNo;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getNoOfLines() {
        return this.noOfLines;
    }

    public void setNoOfLines(int noOfLines) {
        this.noOfLines = noOfLines;
        this.flag = true;
    }

    public synchronized Image getImage() {
        Image image = Image.createImage((int)this.lineWidth, (int)(this.lineSpacing * this.size));
        Graphics graphics = image.getGraphics();
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setFont(this.font);
        graphics.setColor(this.rgb);
        this.drawString(graphics);
        int[] data = new int[image.getWidth() * image.getHeight()];
        image.getRGB(data, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int first = data[0];
        for (int i = 0; i < data.length; ++i) {
            data[i] = first == data[i] ? 0 : this.rgb;
        }
        this.flag = false;
        return Image.createRGBImage((int[])data, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }

    public void paint(Graphics graphics) {
        if (this.flag || this.image == null) {
            this.image = this.getImage();
        }
        if (this.noOfLines * this.lineSpacing > this.image.getHeight() || this.noOfLines > this.size) {
            this.image = this.getImage();
        }
        graphics.drawRegion(this.image, 0, this.lineNo * this.lineSpacing, this.lineWidth, Math.min(this.noOfLines, this.size) * this.lineSpacing, 0, this.x, this.y, 0);
        if (this.size > this.noOfLines) {
            double slot = 1.0 * (double)this.noOfLines * (double)this.lineSpacing / (double)(this.size - this.noOfLines + 1);
            graphics.setColor(0);
            graphics.drawRect(this.x + this.lineWidth, this.y, 2, (int)((double)(this.size - this.noOfLines + 1) * slot));
            graphics.setColor(65280);
            graphics.drawRect(this.x + this.lineWidth, this.y + (int)((double)this.lineNo * slot), 2, (int)slot);
        }
    }

    private void drawString(Graphics graphics) {
        if (this.align == 3) {
            this.wrapJustified(graphics);
        } else if (this.align == 4) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < this.string.length() && this.font.stringWidth(str.toString() + this.string.charAt(i)) < this.lineWidth; ++i) {
                str.append(this.string.charAt(i));
            }
            graphics.drawString(str.toString(), 0, 0, 20);
        } else {
            this.wrap(graphics);
        }
    }

    private void wrapJustified(Graphics graphics) {
        StringBuffer str = new StringBuffer(this.string);
        StringBuffer word = new StringBuffer();
        this.size = 0;
        StringBuffer line = new StringBuffer();
        int wordCounter = 0;
        while (str.length() != 0) {
            char ch = str.charAt(0);
            word.append(ch);
            str.deleteCharAt(0);
            if (ch == '\n') {
                line.append((Object)word);
                while (line.length() != 0 && (line.charAt(line.length() - 1) == ' ' || line.charAt(line.length() - 1) == '\n')) {
                    line.deleteCharAt(line.length() - 1);
                }
                graphics.drawString(line.toString(), 0, this.size * this.lineSpacing, 20);
                ++this.size;
                line = new StringBuffer();
                word = new StringBuffer();
                wordCounter = 1;
                continue;
            }
            if (ch != ' ') continue;
            ++wordCounter;
            int stringWidth = this.font.stringWidth(line.toString() + word.toString());
            if (this.lineWidth < stringWidth) {
                line.deleteCharAt(line.length() - 1);
                String[] words = this.split(line.toString(), " ");
                stringWidth = this.font.stringWidth(line.toString());
                int xplus = 0;
                for (int j = 0; j < words.length; ++j) {
                    graphics.drawString(words[j], xplus, this.size * this.lineSpacing, 20);
                    xplus += this.font.stringWidth(words[j]) + (this.lineWidth - stringWidth) / (wordCounter - 2);
                }
                ++this.size;
                line = new StringBuffer();
                wordCounter = 1;
            }
            line.append((Object)word);
            if (word.length() == 0) continue;
            word = new StringBuffer();
        }
        graphics.drawString(line.toString() + word.toString(), 0, this.size * this.lineSpacing, 20);
        ++this.size;
    }

    private String[] split(String str, String seperator) {
        Vector<String> words = new Vector<String>();
        while (str.length() != 0) {
            String word = "";
            if (str.indexOf(seperator) != -1) {
                word = str.substring(0, str.indexOf(seperator) + 1);
                str = str.substring(str.indexOf(seperator) + 1);
            } else {
                word = str;
                str = "";
            }
            if (word.charAt(word.length() - 1) == '\n') {
                word = word.substring(0, word.length() - 1);
            }
            words.addElement(word);
        }
        String[] strWords = new String[words.size()];
        int i = 0;
        Enumeration enu = words.elements();
        while (enu.hasMoreElements()) {
            strWords[i++] = (String)enu.nextElement();
        }
        return strWords;
    }

    private void wrap(Graphics graphics) {
        int xCord;
        String[] lines = this.split(this.string, "\n");
        this.size = 0;
        int n = this.align == 0 ? 0 : (xCord = this.align == 1 ? this.lineWidth : this.lineWidth / 2);
        int align = 0x10 | (this.align == 0 ? 4 : (this.align == 1 ? 8 : 1));
        for (int i = 0; i < lines.length; ++i) {
            String[] words = this.split(lines[i], " ");
            String line = "";
            for (int j = 0; j < words.length; ++j) {
                int stringWidth = this.font.stringWidth(line.toString() + words[j]);
                if (this.lineWidth < stringWidth) {
                    graphics.drawString(line, xCord, this.size * this.lineSpacing, align);
                    line = "";
                    ++this.size;
                }
                line = line + words[j];
            }
            graphics.drawString(line, xCord, this.size * this.lineSpacing, align);
            ++this.size;
        }
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align;
        this.flag = true;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
            this.lineSpacing = font.getHeight();
            this.flag = true;
        }
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.flag = true;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.flag = true;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        if (string != null) {
            this.string = string;
            this.flag = true;
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setColor(int rgb) {
        this.rgb = rgb;
        this.flag = true;
    }

    public int getColor() {
        return this.rgb;
    }
}

