/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.screen;

import com.funfil.midp.games.mplayer.FunPlayer;
import com.funfil.midp.games.screen.SettingMenu;
import com.funfil.midp.games.spritehandler.ChildScreen;
import com.funfil.midp.games.spritehandler.FunPainter;
import com.funfil.midp.games.spritehandler.MainScreen;
import com.funfil.midp.games.spritehandler.Screen;
import com.funfil.midp.games.spritehandler.TextSprite;
import javax.microedition.lcdui.Font;

public class SettingScreen
extends ChildScreen {
    private SettingMenu menu;
    private TextSprite titleSprite;
    private FunPlayer funPlayer;

    public SettingScreen(Screen parentScreen, MainScreen mainScreen, int x, int y, int verticleSpacing) {
        super(parentScreen, mainScreen);
        try {
            this.setBackPng("/images/back.png");
            this.funPlayer = mainScreen.getSoundTools();
            this.menu = new SettingMenu();
            String s = this.getMainScreen().getRecorder().get("SOUND");
            if (s != null && s.equals("true")) {
                this.menu.setSelectedOption(0);
            } else {
                this.menu.setSelectedOption(1);
            }
            this.menu.setX(x + 25);
            this.menu.setY(y + verticleSpacing);
            this.menu.setvPadding(verticleSpacing);
            this.titleSprite = new TextSprite("Sound", x, y, 150);
            this.titleSprite.setFont(Font.getFont((int)64, (int)1, (int)16));
            this.titleSprite.setColor(9699437);
            this.titleSprite.setAlign(4);
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void init(FunPainter funPainter) {
        funPainter.add(this.menu);
        funPainter.add(this.titleSprite);
    }

    public void upArrowPressed() {
        if (this.menu.getSelectedOption() == 1) {
            this.menu.setSelectedOption(0);
        } else {
            this.menu.setSelectedOption(1);
        }
        this.changeSound();
    }

    public void downArrowPressed() {
        this.upArrowPressed();
    }

    public void firePressed() {
        this.getMainScreen().getRecorder().add("SOUND", "" + (0 == this.menu.getSelectedOption()));
        this.changeSound();
        this.back();
    }

    void changeSound() {
        switch (this.menu.getSelectedOption()) {
            case 0: {
                this.funPlayer.setSoundOn();
                break;
            }
            case 1: {
                this.funPlayer.setSoundOff();
            }
        }
    }

    public TextSprite getTitleSprite() {
        return this.titleSprite;
    }

    public void setTitleSprite(TextSprite titleSprite) {
        this.titleSprite = titleSprite;
    }
}

