/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.imager;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

final class PngEncoder {
    private static final int BLOCK_SIZE = 32000;
    private int[] crcTable = null;
    private Image image;
    int s1 = 1;
    int s2 = 0;

    PngEncoder(Image image) {
        this.image = image;
    }

    void encode(OutputStream os) throws IOException {
        System.out.println("encode");
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        os.write(signature);
        this.writeHeaderChunk(os);
        this.writeDataChunk(os);
        this.writeTrailerChunk(os);
    }

    private void writeHeaderChunk(OutputStream os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(this.image.getWidth());
        chunk.writeInt(this.image.getHeight());
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        this.writeChunk(os, "IHDR", baos.toByteArray());
    }

    private void writeDataChunk(OutputStream os) throws IOException {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int scanLength = this.image.getWidth();
        int[] rgb = new int[width];
        byte[] raw = new byte[4 * width + 1];
        this.writeChunk(os, "IDAT", this.toZLIB(new byte[0], true, false));
        for (int i = 0; i < height; ++i) {
            this.image.getRGB(rgb, 0, scanLength, 0, i, width, 1);
            for (int j = 0; j < width; ++j) {
                raw[1 + 4 * j + 0] = this.getRed(rgb[j]);
                raw[1 + 4 * j + 1] = this.getGreen(rgb[j]);
                raw[1 + 4 * j + 2] = this.getBlue(rgb[j]);
                raw[1 + 4 * j + 3] = this.getAlpha(rgb[j]);
            }
            raw[0] = 0;
            this.writeChunk(os, "IDAT", this.toZLIB(raw, false, false));
        }
        this.writeChunk(os, "IDAT", this.toZLIB(new byte[0], false, true));
    }

    private void writeTrailerChunk(OutputStream os) throws IOException {
        this.writeChunk(os, "IEND", new byte[0]);
    }

    private void writeChunk(OutputStream os, String id, byte[] raw) throws IOException {
        byte[] bid = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bid[i] = (byte)id.charAt(i);
        }
        int crc = -1;
        crc = this.updateCRC(crc, bid);
        crc = this.updateCRC(crc, raw);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        chunk.write(bid);
        chunk.write(raw);
        chunk.writeInt(~crc);
        os.write(baos.toByteArray());
    }

    private void createCRCTable() {
        this.crcTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            this.crcTable[i] = c;
        }
    }

    private int updateCRC(int crc, byte[] raw) {
        if (this.crcTable == null) {
            this.createCRCTable();
        }
        for (int i = 0; i < raw.length; ++i) {
            crc = this.crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    private byte[] toZLIB(byte[] raw, boolean isFirst, boolean isLast) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 6 + raw.length / 32000 * 5);
        DataOutputStream dao = new DataOutputStream(baos);
        if (isFirst) {
            int tmp = 8;
            dao.writeByte(tmp);
            dao.writeByte((31 - (tmp << 8) % 31) % 31);
        }
        int pos = 0;
        while (raw.length - pos > 32000) {
            this.writeUncompressedDeflateBlock(dao, false, raw, pos, '\u7d00');
            pos += 32000;
        }
        int adler = this.updateADLER32(raw);
        if (isLast) {
            this.writeUncompressedDeflateBlock(dao, true, raw, pos, (char)(raw.length - pos));
            dao.writeInt(adler);
        } else if (raw.length > pos) {
            this.writeUncompressedDeflateBlock(dao, false, raw, pos, (char)(raw.length - pos));
        }
        return baos.toByteArray();
    }

    private void writeUncompressedDeflateBlock(DataOutputStream dao, boolean last, byte[] raw, int off, char len) throws IOException {
        dao.writeByte((byte)(last ? 1 : 0));
        dao.writeByte((byte)(len & 0xFF));
        dao.writeByte((byte)((len & 0xFF00) >> 8));
        dao.writeByte((byte)(~len & 0xFF));
        dao.writeByte((byte)((~len & 0xFF00) >> 8));
        dao.write(raw, off, len);
    }

    private int updateADLER32(byte[] raw) {
        for (int i = 0; i < raw.length; ++i) {
            int abs = raw[i] >= 0 ? raw[i] : raw[i] + 256;
            this.s1 = (this.s1 + abs) % 65521;
            this.s2 = (this.s2 + this.s1) % 65521;
        }
        return (this.s2 << 16) + this.s1;
    }

    private byte getAlpha(int color) {
        return (byte)(color >>> 24 & 0xFF);
    }

    private byte getRed(int color) {
        return (byte)(color >>> 16 & 0xFF);
    }

    private byte getGreen(int color) {
        return (byte)(color >>> 8 & 0xFF);
    }

    private byte getBlue(int color) {
        return (byte)(color & 0xFF);
    }
}

