/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.spritehandler;

import com.funfil.midp.games.spritehandler.LayerSprite;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FunSprite
implements LayerSprite {
    private byte[] sequence;
    private byte currentSequence;
    private int x;
    private int y;
    private int height;
    private int width;
    private String imageFile;
    private int[] rgbData;
    private int colisionPointX;
    private int colisionPointY;
    private int colisionWidth;
    private int colisionHeight;

    public FunSprite(String imageFile, int x, int y, int width, int height, byte[] sequence) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
        this.imageFile = imageFile;
        this.sequence = sequence;
        this.currentSequence = 0;
        this.rgbData = new int[width * height];
        this.colisionHeight = height;
        this.colisionWidth = width;
        this.colisionPointX = 0;
        this.colisionPointY = 0;
        this.changeFrame();
    }

    public void nextFrame() {
        this.currentSequence = (byte)(this.currentSequence + 1);
        if (this.currentSequence == this.sequence.length) {
            this.currentSequence = 0;
        }
        this.changeFrame();
    }

    private void changeFrame() {
        for (int i = 0; i < this.rgbData.length; ++i) {
            this.rgbData[i] = 0;
        }
        if (this.sequence[this.currentSequence] != -1) {
            try {
                Image image = Image.createImage((String)this.imageFile);
                image.getRGB(this.rgbData, 0, this.width, this.sequence[this.currentSequence] * this.width, 0, this.width, this.height);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void prevFrame() {
        this.currentSequence = this.currentSequence <= 0 ? (byte)(this.sequence.length - 1) : (byte)(this.currentSequence - 1);
        this.changeFrame();
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public byte getCurrentSequence() {
        return this.currentSequence;
    }

    public void setCurrentSequence(byte currentSequence) {
        this.currentSequence = currentSequence;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
        this.changeFrame();
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    public void setSequence(byte[] sequence) {
        if (sequence.length == 0) {
            throw new IllegalArgumentException("Array size : 0");
        }
        this.sequence = sequence;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void paint(Graphics g) {
        g.drawRGB(this.rgbData, 0, this.width, this.x, this.y, this.width, this.height, true);
    }

    public int getColisionHeight() {
        return this.colisionHeight;
    }

    public void setColisionHeight(int colisionHeight) {
        this.colisionHeight = colisionHeight;
    }

    public int getColisionPointX() {
        return this.colisionPointX;
    }

    public void setColisionPointX(int colisionPointX) {
        this.colisionPointX = colisionPointX;
    }

    public int getColisionPointY() {
        return this.colisionPointY;
    }

    public void setColisionPointY(int colisionPointY) {
        this.colisionPointY = colisionPointY;
    }

    public int getColisionWidth() {
        return this.colisionWidth;
    }

    public void setColisionWidth(int colisionWidth) {
        this.colisionWidth = colisionWidth;
    }

    public void setColision(int x, int y, int width, int height) {
        this.setColisionHeight(height);
        this.setColisionPointX(x);
        this.setColisionPointY(y);
        this.setColisionWidth(width);
    }

    public boolean colidesWith(FunSprite area) {
        int tw = this.colisionWidth;
        int th = this.colisionHeight;
        int rw = area.colisionWidth;
        int rh = area.colisionHeight;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.colisionPointX + this.getX();
        int ty = this.colisionPointY + this.getY();
        int rx = area.colisionPointX + area.getX();
        int ry = area.colisionPointY + area.getY();
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    public void setFrame(byte b) {
        this.currentSequence = b;
        this.changeFrame();
    }
}

