/*
 * Decompiled with CFR 0.152.
 */
package mypackage;

import com.funfil.midp.games.record.Recorder;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Scorer {
    Recorder recorder;
    Winner[] winner = new Winner[3];
    Image bgImage;
    Image menuImage;

    Scorer(Recorder recorder) {
        this.recorder = recorder;
        for (int i = 1; i <= 3; ++i) {
            String key = "name" + i;
            if (recorder.containsKey(key)) {
                this.winner[i - 1] = new Winner(key, recorder.get(key));
                continue;
            }
            this.winner[i - 1] = new Winner(key, "Player", 0);
            this.winner[i - 1].storeData();
        }
    }

    public void paintTopScorer(Graphics graphics) {
        graphics.setFont(Font.getFont((int)32, (int)1, (int)16));
        graphics.setColor(252, 255, 0);
        graphics.drawString(" High Scores ", 55, 50, 0);
        graphics.setColor(18, 230, 243);
        int x = 55;
        int y = 80;
        int i = 0;
        while (i < this.winner.length) {
            graphics.drawString(i + 1 + ")" + this.winner[i].name, x, y, 0);
            graphics.drawString(this.winner[i].run + "", x + 110, y, 0);
            ++i;
            y += 30;
        }
    }

    public void paintWinningScreen(Graphics graphics) {
        graphics.drawImage(this.bgImage, 0, 0, 0);
        graphics.drawImage(this.menuImage, 35, 16, 0);
    }

    public boolean isTopperScore(int run) {
        for (int i = 0; i < this.winner.length; ++i) {
            if (this.winner[i].run >= run) continue;
            return true;
        }
        return false;
    }

    public void saveRecord(String name, int run) {
        System.out.println(this.winner[0] + ":" + 0);
        System.out.println(this.winner[1] + ":" + 1);
        System.out.println(this.winner[2] + ":" + 2);
        if (run > this.winner[0].run) {
            this.winner[2].run = this.winner[1].run;
            this.winner[2].name = this.winner[1].name;
            this.winner[1].run = this.winner[0].run;
            this.winner[1].name = this.winner[0].name;
            this.winner[0].run = run;
            this.winner[0].name = name;
        } else if (run > this.winner[1].run) {
            this.winner[2].run = this.winner[1].run;
            this.winner[2].name = this.winner[1].name;
            this.winner[1].run = run;
            this.winner[1].name = name;
        } else if (run > this.winner[2].run) {
            this.winner[2].run = run;
            this.winner[2].name = name;
        }
        for (int i = 0; i < 3; ++i) {
            this.winner[i].storeData();
        }
    }

    class Winner {
        String key;
        String name;
        int run;

        public Winner(String key, String name, int run) {
            this.key = key;
            this.name = name;
            this.run = run;
        }

        public Winner(String key, String data) {
            this.key = key;
            if (data != null && data.indexOf(";") >= 0) {
                this.name = data.substring(0, data.indexOf(";"));
                this.run = Integer.parseInt(data.substring(data.indexOf(";") + 1));
            }
        }

        public String toString() {
            return this.name + ";" + this.run;
        }

        public void storeData() {
            try {
                Scorer.this.recorder.add(this.key, this.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

