/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.spritehandler;

import com.funfil.midp.games.mplayer.FunPlayer;
import com.funfil.midp.games.record.Recorder;
import com.funfil.midp.games.screen.FunMidlet;
import com.funfil.midp.games.spritehandler.Animator;
import com.funfil.midp.games.spritehandler.ChildScreen;
import com.funfil.midp.games.spritehandler.Screen;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStoreException;

public class MainScreen
extends Canvas
implements Runnable,
Animator {
    private int interrupt;
    private Screen screen;
    private Screen background;
    private Thread thread;
    private FunMidlet midlet;
    private Recorder recorder;
    private FunPlayer soundTools;
    private static String done = "Funfil Technologies";
    public static final Random RANDOM = new Random();
    private String originalDisplaySize;

    private static byte[] encode(String str) {
        return MainScreen.change(str.getBytes());
    }

    private static byte[] change(byte[] data) {
        byte[] converted = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            converted[converted.length - 1 - i] = ~data[i];
        }
        return converted;
    }

    private static String decode(byte[] data) {
        return new String(MainScreen.change(data));
    }

    public MainScreen(FunMidlet midlet) {
        this.midlet = midlet;
        this.originalDisplaySize = midlet.getAppProperty("Midlet-Original-Display-Size");
        this.setFullScreenMode(true);
        try {
            this.recorder = new Recorder(midlet);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this.recorder.add("ID", "");
        String value = this.recorder.get("SOUND");
        if (value == null) {
            this.recorder.add("SOUND", "true");
        }
        value = "true";
        try {
            this.soundTools = new FunPlayer(value.equals("true"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        if (this.originalDisplaySize.equals(this.getWidth() + "," + this.getHeight())) {
            if (this.background != null) {
                this.background.paint(g);
            }
            if (this.screen != null) {
                this.screen.paint(g);
            }
        } else {
            g.setColor(0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setFont(Font.getFont((int)64, (int)1, (int)16));
            g.setColor(RANDOM.nextInt());
            g.drawString("Best Viewed in Portrait mode", this.getWidth() / 2, this.getHeight() / 2, 65);
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.setInterrupt(0);
        this.thread.setPriority(10);
        this.thread.start();
        if (this.background != null) {
            this.background.start();
        }
        if (this.screen != null) {
            this.screen.start();
        }
        if (this.soundTools != null) {
            this.soundTools.start();
        }
    }

    public void stop() {
        this.recorder.add("SOUND", "true");
        this.setInterrupt(1);
        this.soundTools.stop();
        this.recorder.close();
        this.midlet.destroyApp(true);
        this.midlet.notifyDestroyed();
    }

    public void pause() {
        this.setInterrupt(2);
    }

    public void release() {
        this.setInterrupt(0);
    }

    public void setInterrupt(int interrupt) {
        this.interrupt = interrupt;
    }

    public void run() {
        while (this.interrupt != 1) {
            this.repaint();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.screen != null) {
            this.screen.keyPressed(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.screen != null) {
            this.screen.keyRepeated(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.screen != null) {
            this.screen.keyReleased(keyCode);
        }
    }

    public void setBackgroundScreen(Screen background) {
        this.background = background;
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    public Screen getBackground() {
        return this.background;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public int getInterrupt() {
        return this.interrupt;
    }

    public Recorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(Recorder recorder) {
        this.recorder = recorder;
    }

    public FunPlayer getSoundTools() {
        return this.soundTools;
    }

    public FunMidlet getMidlet() {
        return this.midlet;
    }

    protected void hideNotify() {
        this.midlet.pauseApp();
        this.midlet.notifyPaused();
    }

    protected void showNotify() {
        this.midlet.resumeRequest();
    }

    protected void sizeChanged(int w, int h) {
        boolean sizeMatch = this.originalDisplaySize.equals(this.getWidth() + "," + this.getHeight());
        if (this.getInterrupt() == 2 && sizeMatch) {
            this.release();
        } else if (this.getInterrupt() == 0 && !sizeMatch) {
            this.pause();
            if (this.screen != null && this.screen instanceof ChildScreen) {
                this.screen.back();
            }
        }
        this.repaint();
    }
}

