/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.X;
import sk.inlogic.game.T;
import sk.inlogic.mini.Button;
import sk.inlogic.mini.Layout;
import sk.inlogic.mini.P;
import sk.inlogic.mini.Text;
import sk.inlogic.screen.Exit;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.OknoAbout;
import sk.inlogic.screen.OknoGame;
import sk.inlogic.screen.OknoInstructions;
import sk.inlogic.screen.OknoIntro;
import sk.inlogic.screen.OknoLanguage2;
import sk.inlogic.screen.OknoMenu;
import sk.inlogic.screen.OknoMusic;
import sk.inlogic.util.Keys;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    public static int onePixel;
    boolean isLoaded = false;
    public static boolean BoloObnovene;
    public static int SelectedLanguage;
    private static String[] langCodes;
    static OknoIntro oknoIntro;
    static OknoLanguage2 oknoLanguage;
    static OknoMusic oknoMusic;
    static OknoMenu oknoMenu;
    static OknoGame oknoGame;
    static OknoInstructions oknoInstructions;
    static OknoAbout oknoAbout;
    static Exit oknoExit;
    static final int ID_INTRO = 0;
    static final int ID_LANGUAGE = 1;
    static final int ID_MUSIC = 2;
    static final int ID_MENU = 3;
    static final int ID_GAME = 4;
    static final int ID_INSTRUCTION = 5;
    static final int ID_ABOUT = 6;
    static final int ID_EXIT = 7;
    public static int VybraneOkno;
    public static int PosledneVybraneOkno;
    public static String[] NazvyHier;
    public static int TypHry;
    Button buttonYes;
    Button buttonNo;
    Layout ramcek;
    Text otazka;

    public ScreenMain(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.setOnePixel();
    }

    private void setOnePixel() {
        onePixel = MainCanvas.WIDTH < 240 || MainCanvas.HEIGHT < 320 ? 1 : (MainCanvas.WIDTH < 480 ? 2 : (MainCanvas.WIDTH < 720 ? 3 : 4));
    }

    public void beforeShow() {
        Profile.load();
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (VybraneOkno == 4) {
            oknoGame.PoObnove();
        }
        BoloObnovene = false;
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Stop();
        if (!BoloObnovene) {
            this.showContinue();
        }
    }

    public void quit() {
        X.quitApp();
    }

    public static void QuitApp() {
        X.quitApp();
    }

    public static void SelectLanguage(int index) {
        T.LoadTexts(langCodes[index]);
        SelectedLanguage = index;
        ScreenMain.VybratOkno(2);
    }

    private void showContinue() {
        this.buttonYes = new Button(0, 0, Resources.resSprs[1].getWidth(), Resources.resSprs[1].getHeight());
        this.buttonYes.SetLeft(5);
        this.buttonYes.SetBottom(P.HEIGHT - 5);
        this.buttonNo = new Button(0, 0, Resources.resSprs[1].getWidth(), Resources.resSprs[1].getHeight());
        this.buttonNo.SetRight(P.WIDTH - 5);
        this.buttonNo.SetBottom(P.HEIGHT - 5);
        this.ramcek = new Layout(P.CENTER_WIDTH, P.CENTER_HEIGHT, P.WIDTH - P.OFF10w, P.OFF20);
        this.otazka = new Text(this.ramcek.x, this.ramcek.y);
        this.otazka.SetText(T.Continue, Resources.resGFonts[3], 3);
        BoloObnovene = true;
    }

    private void drawContinue(Graphics g) {
        g.drawImage(Resources.resImgs[4], 0, 0, 20);
        this.ramcek.DrawTable(g, Resources.resSprs[11]);
        this.otazka.DrawRiadok(g, Resources.resGFonts[3]);
        this.buttonYes.Draw(g, Resources.resSprs[1], 2);
        this.buttonNo.Draw(g, Resources.resSprs[1], 3);
    }

    private void hideContinue() {
        BoloObnovene = false;
        if (Profile.bMusic && (VybraneOkno != 0 || VybraneOkno != 1 || VybraneOkno != 2)) {
            ScreenMain.PlaySound(0);
        }
    }

    public void initGraphics() {
        this.isLoaded = false;
        Resources.loadImages(new int[]{1, 2, 3, 4, 5});
        Resources.loadSprites(new int[]{0, 1, 2, 4, 5, 6, 11, 3, 7, 8, 9, 10, 12});
        Resources.loadGFonts(new int[]{0, 1, 2, 3, 4, 5});
        P.Load();
        Resources.setYPos(P.WIDTH, P.HEIGHT);
        oknoIntro = new OknoIntro(0);
        T.LoadTexts(langCodes[0]);
        SelectedLanguage = 0;
        this.isLoaded = true;
        ScreenMain.VybratOkno(0);
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (BoloObnovene) {
            this.mainCanvas.repaint();
            return;
        }
        if (!this.isLoaded) {
            this.initGraphics();
            return;
        }
        switch (VybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.update(lTick);
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.update(lTick);
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.update(lTick);
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.update(lTick);
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.update(lTick);
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.update(lTick);
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.update(lTick);
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.update(lTick);
                break;
            }
        }
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (BoloObnovene) {
            this.drawContinue(g);
            return;
        }
        if (!this.isLoaded) {
            return;
        }
        switch (VybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.draw(g);
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.draw(g);
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.draw(g);
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.draw(g);
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.draw(g);
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.draw(g);
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.draw(g);
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.draw(g);
                break;
            }
        }
    }

    public static void soundOn() {
        Profile.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public static void soundOff() {
        Profile.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public static void changeSound(int music) {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            ScreenMain.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(music, -1);
        } else {
            ScreenMain.soundOff();
        }
    }

    public static void PlaySound(int music) {
        if (Profile.bMusic) {
            ScreenMain.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(music, -1);
        }
    }

    public static void PlaySoundOne(int music) {
        if (Profile.bMusic) {
            ScreenMain.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(music, 1);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (BoloObnovene) {
            return;
        }
        switch (VybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.keyPressed(keyCode);
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.keyPressed(keyCode);
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.keyPressed(keyCode);
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.keyPressed(keyCode);
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.keyPressed(keyCode);
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.keyPressed(keyCode);
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.keyPressed(keyCode);
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.keyPressed(keyCode);
                break;
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (BoloObnovene) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.hideContinue();
                return;
            }
            if (Keys.isFKRightCode(keyCode)) {
                this.quit();
                return;
            }
            return;
        }
        switch (VybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.keyReleased(keyCode);
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.keyReleased(keyCode);
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.keyReleased(keyCode);
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.keyReleased(keyCode);
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.keyReleased(keyCode);
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.keyReleased(keyCode);
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.keyReleased(keyCode);
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.keyReleased(keyCode);
                break;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (BoloObnovene) {
            return;
        }
        switch (VybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.pointerPressed(x, y);
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.pointerPressed(x, y);
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.pointerPressed(x, y);
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.pointerPressed(x, y);
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.pointerPressed(x, y);
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.pointerPressed(x, y);
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.pointerPressed(x, y);
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.pointerPressed(x, y);
                break;
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (BoloObnovene) {
            return;
        }
        switch (VybraneOkno) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 7: {
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.pointerMoved(x, y);
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.pointerMoved(x, y);
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (BoloObnovene) {
            if (this.buttonYes.click(x, y)) {
                this.hideContinue();
                return;
            }
            if (this.buttonNo.click(x, y)) {
                this.quit();
                return;
            }
            return;
        }
        switch (VybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.pointerReleased(x, y);
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.pointerReleased(x, y);
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.pointerReleased(x, y);
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.pointerReleased(x, y);
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.pointerReleased(x, y);
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.pointerReleased(x, y);
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.pointerReleased(x, y);
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.pointerReleased(x, y);
                break;
            }
        }
    }

    public static void VybratOkno(int index) {
        PosledneVybraneOkno = VybraneOkno;
        VybraneOkno = index;
        ScreenMain.vybrat();
        ScreenMain.Hide();
    }

    public static void Hide() {
        switch (PosledneVybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.Hide();
                oknoIntro = null;
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.Hide();
                oknoLanguage = null;
                System.gc();
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.Hide();
                oknoMusic = null;
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.Hide();
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.Hide();
                oknoExit = null;
                System.gc();
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.Hide();
                oknoGame = null;
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.Hide();
                oknoInstructions = null;
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.Hide();
                oknoAbout = null;
                break;
            }
        }
    }

    public static void Hide(boolean skryt) {
        switch (PosledneVybraneOkno) {
            case 0: {
                if (oknoIntro == null) break;
                oknoIntro.Hide();
                break;
            }
            case 1: {
                if (oknoLanguage == null) break;
                oknoLanguage.Hide();
                break;
            }
            case 2: {
                if (oknoMusic == null) break;
                oknoMusic.Hide();
                break;
            }
            case 3: {
                if (oknoMenu == null) break;
                oknoMenu.Hide();
                break;
            }
            case 7: {
                if (oknoExit == null) break;
                oknoExit.Hide();
                break;
            }
            case 4: {
                if (oknoGame == null) break;
                oknoGame.Hide();
                break;
            }
            case 5: {
                if (oknoInstructions == null) break;
                oknoInstructions.Hide();
                break;
            }
            case 6: {
                if (oknoAbout == null) break;
                oknoAbout.Hide();
                break;
            }
        }
    }

    static void vybrat() {
        switch (VybraneOkno) {
            case 0: {
                if (oknoIntro == null) {
                    oknoIntro = new OknoIntro(0);
                }
                if (oknoIntro == null) break;
                if (!oknoIntro.IsLoaded()) {
                    oknoIntro.loadContent();
                }
                oknoIntro.Show();
                break;
            }
            case 1: {
                if (oknoLanguage == null) {
                    oknoLanguage = new OknoLanguage2(1);
                }
                if (oknoLanguage == null) break;
                if (!oknoLanguage.IsLoaded()) {
                    oknoLanguage.loadContent();
                }
                oknoLanguage.Show();
                break;
            }
            case 2: {
                if (oknoMusic == null) {
                    oknoMusic = new OknoMusic(2);
                }
                if (oknoMusic == null) break;
                if (!oknoMusic.IsLoaded()) {
                    oknoMusic.loadContent();
                }
                oknoMusic.Show();
                break;
            }
            case 3: {
                if (oknoMenu == null) {
                    oknoMenu = new OknoMenu(3);
                }
                if (oknoMenu == null) break;
                if (!oknoMenu.IsLoaded()) {
                    oknoMenu.loadContent();
                }
                oknoMenu.Show();
                break;
            }
            case 7: {
                if (oknoExit == null) {
                    oknoExit = new Exit(7);
                }
                if (oknoExit == null) break;
                if (!oknoExit.IsLoaded()) {
                    oknoExit.loadContent();
                }
                oknoExit.Show();
                break;
            }
            case 4: {
                if (oknoGame == null) {
                    oknoGame = new OknoGame(4);
                }
                if (oknoGame == null) break;
                if (!oknoGame.IsLoaded()) {
                    oknoGame.loadContent();
                }
                oknoGame.Show();
                break;
            }
            case 5: {
                if (oknoInstructions == null) {
                    oknoInstructions = new OknoInstructions(5);
                }
                if (oknoInstructions == null) break;
                if (!oknoInstructions.IsLoaded()) {
                    oknoInstructions.loadContent();
                }
                oknoInstructions.Show();
                break;
            }
            case 6: {
                if (oknoAbout == null) {
                    oknoAbout = new OknoAbout(6);
                }
                if (oknoAbout == null) break;
                if (!oknoAbout.IsLoaded()) {
                    oknoAbout.loadContent();
                }
                oknoAbout.Show();
                break;
            }
        }
    }

    public static void VybratOkno(int index, boolean skryt) {
        PosledneVybraneOkno = VybraneOkno;
        VybraneOkno = index;
        ScreenMain.vybrat();
    }

    public static void SkrytPosledneOkno() {
    }

    public static void StartGame(int typ) {
        TypHry = typ;
        ScreenMain.VybratOkno(4);
    }

    static {
        BoloObnovene = false;
        SelectedLanguage = 0;
        langCodes = new String[]{"en", "de", "fr", "es", "br", "it"};
        VybraneOkno = -1;
        PosledneVybraneOkno = 0;
        NazvyHier = new String[]{"KLONDIKE", "SCORPION", "RUSSIAN", "PYRAMID", "FREECELL", "SPIDERETTE", "YUKON", "CANFIELD", "GOLF"};
        TypHry = 0;
    }
}

