/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int IMG_ROTATE = 0;
    public static final int IMG_SPLASH = 1;
    public static final int IMG_LOGO_INLOGIC_ABOUT = 2;
    public static final int IMG_LOGO = 3;
    public static final int IMG_BACKGROUND = 4;
    public static final int IMG_BACKGROUND_GAME = 5;
    public static final int TOTAL_IMGS = 6;
    public static Image[] resImgs = new Image[6];
    public static final int SPR_LANGUAGE = 0;
    public static final int SPR_BUTTONS_SMALL = 1;
    public static final int SPR_SYMBOLY = 2;
    public static final int SPR_MODY = 3;
    public static final int SPR_KARTY = 4;
    public static final int SPR_KARTA_BACK = 5;
    public static final int SPR_KARTA_RAMCEK = 6;
    public static final int SPR_BUTTON = 7;
    public static final int SPR_BUTTON_PLAY = 8;
    public static final int SPR_RUCKA = 9;
    public static final int SPR_RUCKA_MENU = 10;
    public static final int SPR_DIALOG_BAR = 11;
    public static final int SPR_ARROW = 12;
    public static final int TOTAL_SPRS = 13;
    public static Sprite[] resSprs = new Sprite[13];
    public static final int GFONT_MALY = 0;
    public static final int GFONT_MALY_Z = 1;
    public static final int GFONT_STREDNY = 2;
    public static final int GFONT_STREDNY_Z = 3;
    public static final int GFONT_VELKY = 4;
    public static final int GFONT_VELKY_Z = 5;
    public static final int TOTAL_GFONTS = 6;
    public static GFont[] resGFonts = new GFont[6];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    private static String langDir = "/";
    public static String langCode = "";
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static boolean sysFont;
    public static int yColPos;
    public static int yPackPos;

    public static void initGraphicsDirs(int width, int height) {
        graphicsBaseDir = "/";
        graphicsDisplayDir = "/";
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            System.out.println(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (image == null) {
            System.out.println("null");
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "I3.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "about.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "logo.png";
                break;
            }
            case 4: {
                imgPath = graphicsDisplayDir + "bg.png";
                break;
            }
            case 5: {
                imgPath = graphicsDisplayDir + "bg1.png";
                break;
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void LoadContent() {
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "raster.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "bt_male.png";
                slicesX = 16;
                slicesY = 1;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "symboly.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "mody.png";
                slicesX = 9;
                slicesY = 1;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "cards.png";
                slicesX = 13;
                slicesY = 4;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "cardBg.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "ramcek.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "Tlacitka.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "play.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "hand.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "sipka.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "Tabulka.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "arrow.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFont(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c3', '\u00c1', '\u00c0', '\u00c2', '\u00c4', '\u00c7', '\u010c', '\u010e', '\u00ca', '\u00cb', '\u00c9', '\u00c8', '\u00cf', '\u00cd', '\u00cc', '\u013d', '\u00d1', '\u0147', '\u00d4', '\u00d5', '\u00d6', '\u00d3', '\u00d2', '\u00dc', '\u00da', '\u00d9', '\u0158', '\u0160', '\u015a', '\u0164', '\u00dd', '\u017d', '$', '#', '*', '@', '\\', '[', '(', '{', '}', ')', ']', '|', '\u2014', '\u00f7', '%', '<', '>', '+', '-', '=', ';', ',', '.', ':', '\"', '\'', '!', '?', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0110', '\u2044', '\u00a1', '\u00bf'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 8: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{5, 3, 4, 4, 3, 3, 4, 4, 3, 3, 4, 4, 5, 4, 5, 4, 5, 4, 3, 5, 4, 4, 5, 5, 5, 4, 5, 5, 5, 5, 5, 4, 4, 4, 3, 5, 4, 4, 5, 4, 4, 4, 5, 4, 5, 5, 5, 5, 5, 5, 5, 5, 4, 3, 4, 5, 5, 4, 3, 5, 3, 5, 4, 2, 4, 3, 3, 4, 2, 1, 5, 3, 5, 4, 4, 3, 3, 4, 2, 2, 1, 1, 3, 1, 1, 4, 4, 3, 3, 3, 4, 3, 4, 4, 4, 4, 5, 5, 1, 3};
                break;
            }
            case 10: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{6, 5, 5, 6, 6, 5, 6, 6, 4, 5, 7, 5, 8, 7, 6, 5, 6, 6, 5, 5, 7, 6, 8, 6, 6, 5, 6, 6, 6, 6, 6, 5, 5, 6, 5, 5, 5, 5, 3, 3, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 6, 5, 5, 6, 6, 5, 5, 5, 4, 7, 4, 3, 3, 3, 3, 2, 2, 1, 8, 4, 6, 4, 4, 5, 3, 4, 2, 2, 2, 2, 3, 1, 2, 4, 5, 4, 4, 4, 5, 4, 4, 4, 5, 5, 6, 5, 2, 4};
                break;
            }
            case 11: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{7, 6, 6, 7, 6, 6, 7, 7, 4, 5, 8, 6, 9, 7, 7, 6, 7, 6, 6, 6, 8, 7, 9, 7, 7, 6, 7, 7, 7, 7, 7, 6, 6, 6, 5, 6, 5, 6, 4, 4, 4, 6, 7, 7, 7, 7, 7, 7, 6, 8, 8, 7, 6, 5, 5, 6, 7, 6, 5, 6, 4, 7, 5, 3, 3, 3, 3, 3, 2, 2, 9, 5, 7, 6, 5, 5, 3, 5, 3, 3, 2, 2, 3, 2, 2, 4, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 7, 5, 2, 4};
                break;
            }
            case 12: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{8, 7, 7, 8, 7, 6, 7, 8, 4, 6, 9, 6, 8, 8, 8, 6, 8, 8, 6, 6, 8, 7, 10, 7, 7, 6, 8, 7, 8, 8, 8, 7, 7, 7, 6, 7, 7, 7, 4, 4, 4, 7, 9, 9, 8, 7, 8, 8, 7, 9, 9, 8, 8, 6, 6, 7, 8, 6, 6, 5, 5, 8, 6, 3, 3, 3, 3, 3, 3, 2, 11, 6, 8, 6, 6, 6, 3, 5, 3, 2, 2, 2, 4, 2, 2, 5, 5, 5, 5, 5, 5, 6, 5, 6, 5, 6, 7, 6, 3, 5};
                break;
            }
            case 13: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{9, 8, 7, 8, 7, 7, 9, 9, 4, 7, 9, 8, 10, 9, 8, 7, 9, 8, 6, 7, 8, 8, 11, 9, 9, 7, 9, 8, 8, 9, 8, 7, 7, 8, 7, 8, 8, 7, 4, 5, 5, 8, 9, 10, 8, 8, 8, 9, 7, 10, 9, 9, 8, 6, 7, 7, 9, 7, 6, 6, 5, 8, 6, 3, 4, 3, 4, 3, 3, 2, 11, 7, 8, 6, 7, 6, 3, 7, 2, 2, 2, 2, 3, 2, 2, 5, 6, 5, 6, 5, 6, 6, 6, 5, 6, 6, 8, 6, 2, 5};
                break;
            }
            case 14: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{9, 9, 8, 9, 7, 8, 9, 10, 5, 8, 9, 8, 11, 9, 9, 8, 9, 8, 7, 8, 10, 9, 12, 10, 9, 7, 10, 9, 9, 9, 9, 8, 8, 9, 8, 9, 9, 8, 5, 5, 5, 9, 11, 11, 9, 9, 9, 9, 9, 11, 11, 11, 9, 7, 7, 8, 9, 8, 6, 7, 5, 10, 7, 3, 4, 3, 4, 4, 3, 2, 12, 7, 9, 7, 6, 7, 4, 7, 3, 3, 2, 2, 4, 2, 3, 5, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 9, 7, 2, 6};
                break;
            }
            case 15: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{11, 10, 10, 11, 9, 9, 11, 12, 5, 8, 11, 9, 13, 11, 10, 9, 11, 10, 8, 9, 11, 10, 14, 11, 10, 8, 10, 11, 11, 10, 11, 10, 10, 10, 9, 9, 9, 9, 5, 6, 5, 10, 11, 11, 10, 11, 10, 11, 11, 11, 11, 11, 10, 9, 9, 9, 11, 9, 7, 8, 6, 11, 8, 4, 5, 4, 4, 4, 3, 2, 15, 7, 11, 8, 8, 8, 5, 8, 2, 3, 2, 2, 5, 2, 3, 6, 7, 6, 7, 7, 7, 7, 7, 7, 8, 7, 11, 8, 3, 6};
                break;
            }
            case 18: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{12, 11, 11, 13, 10, 10, 12, 13, 6, 9, 13, 10, 15, 13, 12, 11, 11, 11, 9, 10, 13, 13, 17, 12, 12, 9, 13, 13, 13, 13, 12, 10, 10, 11, 10, 11, 11, 11, 6, 7, 6, 10, 13, 13, 11, 11, 11, 12, 11, 13, 13, 12, 12, 9, 9, 10, 12, 9, 8, 8, 6, 12, 8, 4, 4, 4, 4, 4, 4, 2, 16, 9, 13, 8, 9, 9, 5, 9, 3, 3, 3, 3, 5, 3, 3, 7, 8, 7, 8, 8, 8, 8, 8, 7, 8, 8, 12, 9, 3, 7};
                break;
            }
            case 20: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{14, 12, 12, 14, 12, 12, 14, 14, 7, 10, 15, 11, 17, 14, 13, 12, 13, 13, 10, 12, 14, 14, 18, 13, 14, 10, 13, 14, 14, 14, 13, 12, 11, 13, 12, 12, 12, 12, 7, 7, 7, 12, 14, 14, 12, 13, 13, 13, 13, 14, 15, 15, 13, 10, 10, 11, 13, 11, 9, 9, 8, 14, 6, 4, 5, 5, 5, 5, 4, 3, 19, 9, 14, 10, 10, 10, 5, 10, 3, 3, 3, 3, 6, 2, 3, 8, 10, 8, 9, 9, 9, 9, 9, 9, 9, 9, 13, 10, 3, 8};
                break;
            }
            case 22: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{15, 13, 12, 13, 12, 12, 14, 16, 7, 11, 16, 13, 18, 15, 14, 12, 14, 13, 11, 12, 16, 14, 18, 14, 14, 11, 15, 15, 14, 15, 15, 12, 12, 14, 13, 12, 13, 13, 7, 8, 8, 12, 15, 15, 13, 13, 13, 14, 14, 16, 16, 16, 14, 10, 10, 13, 14, 11, 10, 10, 7, 15, 7, 4, 5, 5, 5, 5, 5, 2, 19, 10, 15, 11, 10, 10, 5, 10, 3, 3, 3, 3, 6, 3, 4, 8, 9, 8, 10, 10, 10, 9, 10, 9, 10, 10, 13, 11, 3, 8};
                break;
            }
            case 23: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{16, 14, 13, 16, 14, 13, 16, 16, 8, 12, 16, 13, 19, 17, 14, 14, 15, 14, 12, 14, 17, 16, 21, 15, 16, 13, 16, 16, 16, 16, 16, 14, 13, 15, 14, 14, 14, 15, 8, 9, 9, 14, 16, 16, 15, 15, 15, 15, 15, 17, 18, 17, 14, 12, 12, 14, 16, 12, 10, 11, 9, 16, 8, 5, 6, 5, 5, 6, 5, 3, 21, 12, 16, 11, 12, 11, 6, 12, 4, 4, 4, 4, 6, 3, 3, 9, 10, 9, 10, 10, 11, 10, 11, 10, 11, 10, 15, 11, 3, 9};
                break;
            }
            case 28: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{18, 15, 14, 17, 15, 14, 18, 18, 9, 13, 18, 14, 21, 18, 16, 14, 17, 16, 13, 15, 19, 17, 22, 17, 17, 13, 17, 18, 18, 17, 18, 15, 15, 16, 15, 15, 15, 15, 8, 8, 10, 14, 18, 18, 17, 16, 16, 17, 16, 19, 19, 18, 17, 13, 13, 15, 17, 14, 11, 13, 10, 17, 8, 5, 6, 6, 7, 7, 5, 3, 23, 12, 18, 12, 12, 12, 6, 13, 4, 4, 4, 3, 7, 2, 4, 9, 12, 9, 12, 11, 12, 12, 12, 11, 11, 11, 17, 13, 4, 10};
                break;
            }
            case 32: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{20, 17, 17, 19, 18, 17, 20, 21, 9, 14, 21, 17, 24, 20, 18, 17, 19, 19, 15, 17, 22, 20, 26, 20, 20, 15, 20, 20, 20, 20, 20, 17, 17, 19, 17, 18, 18, 17, 9, 10, 10, 17, 21, 20, 19, 19, 19, 18, 18, 21, 21, 22, 18, 15, 15, 17, 20, 15, 13, 14, 11, 20, 9, 6, 7, 7, 7, 7, 5, 3, 26, 14, 20, 14, 14, 14, 7, 14, 5, 5, 4, 4, 8, 3, 4, 11, 13, 11, 13, 13, 14, 12, 13, 13, 13, 13, 19, 15, 4, 11};
                break;
            }
            case 34: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{22, 19, 19, 21, 19, 18, 21, 23, 10, 16, 22, 18, 26, 22, 20, 18, 20, 20, 16, 19, 23, 22, 28, 21, 21, 16, 21, 22, 22, 21, 22, 18, 19, 21, 19, 19, 19, 19, 10, 10, 10, 18, 23, 23, 20, 20, 20, 20, 20, 23, 23, 23, 20, 16, 16, 19, 21, 16, 14, 15, 12, 22, 11, 6, 8, 7, 7, 7, 6, 2, 29, 16, 22, 15, 15, 16, 8, 15, 5, 5, 5, 5, 8, 3, 4, 12, 14, 12, 14, 13, 15, 14, 14, 14, 14, 14, 21, 16, 5, 12};
                break;
            }
            case 35: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{23, 21, 21, 23, 21, 20, 24, 25, 13, 19, 24, 20, 29, 24, 23, 21, 23, 24, 17, 21, 24, 25, 29, 23, 23, 19, 24, 24, 24, 24, 24, 20, 21, 23, 20, 20, 20, 20, 12, 12, 12, 20, 25, 24, 22, 23, 23, 22, 22, 25, 25, 24, 24, 18, 18, 20, 22, 19, 16, 15, 12, 22, 11, 8, 8, 9, 9, 8, 9, 4, 30, 16, 24, 16, 16, 16, 8, 16, 6, 6, 6, 7, 11, 5, 6, 14, 16, 13, 16, 15, 16, 16, 16, 16, 16, 16, 23, 15, 6, 14};
                break;
            }
            case 44: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{28, 23, 23, 26, 23, 22, 27, 28, 13, 20, 29, 23, 32, 29, 26, 23, 26, 25, 20, 24, 29, 28, 36, 27, 27, 21, 28, 28, 28, 28, 28, 23, 23, 26, 23, 23, 23, 23, 13, 13, 13, 23, 29, 29, 26, 26, 26, 26, 26, 29, 29, 29, 25, 20, 20, 24, 27, 21, 18, 18, 14, 28, 13, 8, 9, 9, 9, 10, 8, 4, 36, 19, 28, 19, 19, 19, 10, 19, 6, 6, 6, 6, 10, 4, 5, 14, 18, 15, 18, 17, 18, 18, 18, 17, 18, 18, 26, 20, 5, 14};
                break;
            }
            case 62: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{40, 37, 35, 40, 36, 35, 39, 43, 20, 33, 42, 36, 49, 42, 38, 36, 39, 41, 30, 36, 42, 40, 49, 38, 38, 32, 40, 40, 40, 40, 40, 35, 35, 40, 36, 36, 36, 36, 20, 20, 20, 36, 42, 42, 38, 38, 38, 38, 38, 42, 42, 42, 41, 30, 30, 36, 38, 32, 27, 26, 21, 39, 19, 13, 15, 15, 15, 14, 14, 6, 50, 26, 41, 26, 26, 26, 13, 26, 10, 10, 10, 10, 17, 8, 11, 23, 27, 21, 27, 26, 27, 26, 27, 26, 27, 27, 40, 26, 11, 23};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "3c.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "3z.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 2: {
                gFontImg = Resources.createImage(graphicsBaseDir + "2c.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 3: {
                gFontImg = Resources.createImage(graphicsBaseDir + "2z.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 4: {
                gFontImg = Resources.createImage(graphicsBaseDir + "1c.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 5: {
                gFontImg = Resources.createImage(graphicsBaseDir + "1z.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        Resources.langCode = langCode;
        langDir = "/lang/" + langCode + "/";
        sysFont = langCode == "ru";
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    public static void freeAllResources() {
        int i;
        for (i = 0; i < resImgs.length; ++i) {
            Resources.resImgs[i] = null;
        }
        for (i = 0; i < resSprs.length; ++i) {
            Resources.resSprs[i] = null;
        }
        for (i = 0; i < resGFonts.length; ++i) {
            Resources.resGFonts[i] = null;
        }
    }

    public static void setYPos(int width, int height) {
        yColPos = resSprs[4].getHeight() + (resSprs[4].getHeight() >> 1);
        yPackPos = resSprs[4].getHeight() >> 3;
        if (height == 800 || width == 352 && height == 416) {
            yColPos += yPackPos;
            yPackPos += yPackPos;
        } else if (width == 640 && height == 480) {
            yColPos += (yPackPos << 1) + yPackPos;
            yPackPos += yPackPos;
        } else if (width == 360 && height == 640) {
            yColPos += yPackPos << 1;
            yPackPos += yPackPos;
        } else if (height == 287) {
            yColPos += (yPackPos << 2) + yPackPos;
            yPackPos += yPackPos << 1;
        }
    }

    static {
        yColPos = 0;
        yPackPos = 0;
    }
}

