/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.game.Game;
import sk.inlogic.game.Game1;
import sk.inlogic.game.Game2;
import sk.inlogic.game.Game3;
import sk.inlogic.game.Game4;
import sk.inlogic.game.Game5;
import sk.inlogic.game.Game6;
import sk.inlogic.game.Game7;
import sk.inlogic.game.GameGolf;
import sk.inlogic.game.IGame;
import sk.inlogic.game.T;
import sk.inlogic.graphics.GFont;
import sk.inlogic.mini.Bod;
import sk.inlogic.mini.Button;
import sk.inlogic.mini.Farba;
import sk.inlogic.mini.IOkno;
import sk.inlogic.mini.Layout;
import sk.inlogic.mini.P;
import sk.inlogic.mini.ScrollText;
import sk.inlogic.mini.Text;
import sk.inlogic.mini.Vyberac;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.screen.Vysledok;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class OknoGame
implements IOkno {
    public int Id;
    public boolean JeZobrazene;
    public boolean lostProgressQuestion;
    public boolean noMoves;
    boolean isLoaded = false;
    Image pozadie;
    GFont fontStrednyZ;
    GFont fontMaly;
    GFont fontMalyZ;
    Button butBack;
    Button butPausa;
    IGame game;
    Layout lostProgressLayout;
    Layout noMovesLayout;
    private final int EXIT_LOST_PROGRESS;
    private final int LOST_PROGRESS;
    private final int BACK_TO_MODES;
    private final int RESTART;
    private PreparedText prepLostProgress;
    private PreparedText prepNoMoves;
    private Rectangle rectLostProgress;
    private Rectangle rectNoMoves;
    boolean JePausa = false;
    Sprite sprButton;
    Sprite rucka;
    Button butPausaMenu;
    Button butPausaMusic;
    Button butPausaInstruction;
    Button butPausaRestart;
    Button butPausaContinue;
    Bod polohaRucka;
    Vyberac vyberac;
    int pozadiePausa;
    int iPozadie;
    int jPozadie;
    boolean JeInstruction = false;
    Layout ramcekInstruction;
    Text textInstruction;
    Layout ramcek;
    ScrollText scrollText;
    Farba farba;
    String text;
    boolean JeVysledok = false;
    Vysledok vysledok;
    boolean poObnove = false;
    boolean bDoubleTouch = false;
    int iDoubleTouchTime = 0;
    int iX1 = -1;
    int iY1 = -1;

    public OknoGame(int id) {
        this.EXIT_LOST_PROGRESS = 0;
        this.LOST_PROGRESS = 1;
        this.BACK_TO_MODES = 2;
        this.RESTART = 3;
        this.Id = id;
    }

    public int GetId() {
        return this.Id;
    }

    public void Show() {
        this.JeZobrazene = true;
    }

    public void Hide() {
        this.JeZobrazene = false;
    }

    public boolean IsVisible() {
        return this.JeZobrazene;
    }

    public boolean IsLoaded() {
        return this.isLoaded;
    }

    public void loadContent() {
        this.pozadie = Resources.resImgs[5];
        this.fontStrednyZ = Resources.resGFonts[3];
        this.fontMaly = Resources.resGFonts[0];
        this.fontMalyZ = Resources.resGFonts[1];
        int x = Resources.resSprs[1].getWidth() / 10;
        int y = Resources.resSprs[1].getHeight() / 10;
        this.butBack = new Button(0, 0, Resources.resSprs[1].getWidth(), Resources.resSprs[1].getHeight());
        this.butBack.SetLeft(x);
        this.butBack.SetBottom(P.HEIGHT - y);
        this.butPausa = new Button(0, 0, Resources.resSprs[1].getWidth(), Resources.resSprs[1].getHeight());
        this.butPausa.SetRight(P.WIDTH - x);
        this.butPausa.SetBottom(P.HEIGHT - y);
        this.vybratInstruciton();
        this.initNoMoves();
        switch (ScreenMain.TypHry) {
            case 0: {
                this.game = new Game();
                break;
            }
            case 1: {
                this.game = new Game1();
                break;
            }
            case 2: {
                this.game = new Game3();
                break;
            }
            case 3: {
                this.game = new Game6();
                break;
            }
            case 4: {
                this.game = new Game4();
                break;
            }
            case 5: {
                this.game = new Game5();
                break;
            }
            case 6: {
                this.game = new Game2();
                break;
            }
            case 7: {
                this.game = new Game7();
                break;
            }
            case 8: {
                this.game = new GameGolf();
                break;
            }
            default: {
                this.game = new Game();
            }
        }
        this.game.loadContent();
        this.game.Play();
        this.isLoaded = true;
    }

    public void unloadContent() {
        this.isLoaded = false;
    }

    public void update(long lTick) {
        if (!this.isLoaded || !this.JeZobrazene) {
            return;
        }
        this.updateDoubleTouch((int)lTick);
        this.game.update(lTick);
        if (this.game.JeVitazstvo()) {
            this.game.Vysledok();
            this.showVysledok();
        }
        if (this.JeInstruction) {
            if (this.scrollText != null) {
                this.scrollText.Update();
            }
            return;
        }
        if (this.JeVysledok) {
            if (this.vysledok != null) {
                this.vysledok.update(lTick);
            }
            return;
        }
    }

    public void draw(Graphics g) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        g.drawImage(this.pozadie, 0, 0, 20);
        if (!this.JePausa && !this.JeInstruction) {
            this.drawInfo(g);
        }
        this.game.draw(g);
        if (this.JePausa) {
            this.drawPausa(g);
            return;
        }
        if (this.JeInstruction) {
            this.drawInstruction(g);
            return;
        }
        if (this.JeVysledok) {
            if (this.vysledok != null) {
                this.paintShadow(g);
                this.vysledok.draw(g);
            }
            return;
        }
        this.drawSpodok(g);
        if (this.noMoves) {
            this.paintShadow(g);
            this.paintNoMoves(g);
        }
    }

    void drawInfo(Graphics g) {
        String s = T.Score + ":" + this.game.Skore();
        int sirka = this.fontMaly.stringWidth(s.toCharArray()) >> 1;
        this.fontMaly.drawString(g, s.toCharArray(), P.CENTER_WIDTH - sirka - P.OFF5w, this.butBack.Poloha.Y, 3);
        s = T.Time + ":" + this.game.Time();
        sirka = this.fontMaly.stringWidth(s.toCharArray()) >> 1;
        this.fontMaly.drawString(g, s.toCharArray(), P.CENTER_WIDTH + sirka + P.OFF5w, this.butBack.Poloha.Y, 3);
    }

    void drawSpodok(Graphics g) {
        if (this.game != null) {
            if (this.game.Kroky() > 1 && !this.game.JeVybranaKarta()) {
                this.butBack.Draw(g, Resources.resSprs[1], 4);
            } else {
                this.butBack.Draw(g, Resources.resSprs[1], 5);
            }
        } else {
            this.butBack.Draw(g, Resources.resSprs[1], 5);
        }
        this.butPausa.Draw(g, Resources.resSprs[1], 7);
    }

    public void keyPressed(int keyCode) {
        if (!this.isLoaded || !this.JeZobrazene || this.JePausa || this.JeVysledok) {
            return;
        }
        if (this.JeInstruction) {
            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                this.scrollText.keyHore = true;
                return;
            }
            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                this.scrollText.keyDole = true;
                return;
            }
            return;
        }
    }

    public void keyReleased(int keyCode) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.JePausa) {
            this.relaseKeyPausa(keyCode);
            return;
        }
        if (this.JeInstruction) {
            this.relaseKeyInstruction(keyCode);
            return;
        }
        if (this.JeVysledok) {
            this.relaseKeyVysledok();
            return;
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.showPausa();
            return;
        }
        if (this.noMoves) {
            if (Keys.isFKRightCode(keyCode)) {
                this.executeAction(2);
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.executeAction(3);
            }
            return;
        }
        if (this.game.Kroky() > 1 && Keys.isFKLeftCode(keyCode)) {
            this.game.Spat();
            return;
        }
        if (this.game.JeStart()) {
            Bod hand;
            if ((Keys.isKeyPressed(53) || Keys.isActionPressed(5)) && this.iX1 > -1 && this.iY1 > -1) {
                if (this.bDoubleTouch) {
                    this.bDoubleTouch = false;
                    this.iDoubleTouchTime = 0;
                    this.game.doubleTouch(this.iX1, this.iY1);
                    this.iY1 = -1;
                    this.iX1 = -1;
                } else {
                    this.bDoubleTouch = false;
                    this.iDoubleTouchTime = 0;
                    this.iY1 = -1;
                    this.iX1 = -1;
                }
            }
            this.game.keyReleased(keyCode);
            if ((Keys.isKeyPressed(53) || Keys.isActionPressed(5)) && (hand = this.game.getPoint()) != null) {
                this.bDoubleTouch = true;
                this.iDoubleTouchTime = 333;
                this.iX1 = hand.X + 1;
                this.iY1 = hand.Y + 1;
            }
            if (this.game.isReleased()) {
                this.noMoves = this.game.checkNoMoves();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.JePausa || this.JeVysledok) {
            return;
        }
        if (this.JeInstruction) {
            if (this.scrollText != null) {
                this.scrollText.poinertPressed(x, y);
            }
            return;
        }
        if (this.game.JeStart()) {
            this.game.pointerPressed(x, y);
            if (this.bDoubleTouch) {
                if (Math.abs(x - this.iX1) < Resources.resImgs[4].getWidth() && Math.abs(y - this.iY1) < Resources.resImgs[4].getHeight()) {
                    this.bDoubleTouch = false;
                    this.iDoubleTouchTime = 0;
                    this.game.doubleTouch(x, y);
                } else {
                    this.bDoubleTouch = false;
                    this.iDoubleTouchTime = 0;
                }
            } else {
                this.bDoubleTouch = true;
                this.iDoubleTouchTime = 333;
                this.iX1 = x;
                this.iY1 = y;
            }
        }
    }

    public void pointerMoved(int x, int y) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.JePausa || this.JeVysledok) {
            return;
        }
        if (this.JeInstruction) {
            if (this.scrollText != null) {
                this.scrollText.pointerDragged(x, y);
            }
            return;
        }
        if (this.game.JeStart()) {
            this.game.pointerMoved(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.JePausa) {
            this.clickPausa(x, y);
            return;
        }
        if (this.JeInstruction) {
            this.clickInstruction(x, y);
            return;
        }
        if (this.JeVysledok) {
            this.clickVysledok(x, y);
            return;
        }
        if (this.noMoves) {
            if (this.butPausaContinue.click(x, y)) {
                this.executeAction(2);
            } else if (this.butPausaMenu.click(x, y)) {
                this.executeAction(3);
            }
            return;
        }
        if (this.game.Kroky() > 1 && this.butBack.click(x, y) && !this.game.JeVybranaKarta()) {
            this.game.Spat();
            return;
        }
        if (this.butPausa.click(x, y) && !this.game.JeVybranaKarta()) {
            this.showPausa();
            return;
        }
        if (this.game.JeStart()) {
            this.game.pointerReleased(x, y);
            this.noMoves = this.game.checkNoMoves();
        }
    }

    void showPausa() {
        this.game.Pause(true);
        ScreenMain.PlaySound(0);
        this.sprButton = Resources.resSprs[1];
        this.rucka = Resources.resSprs[10];
        int x = this.sprButton.getWidth() / 10;
        int y = this.sprButton.getHeight() / 10;
        this.butPausaMenu = new Button(0, 0, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.butPausaMenu.SetLeft(x);
        this.butPausaMenu.SetBottom(P.HEIGHT - y);
        this.butPausaContinue = new Button(0, 0, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.butPausaContinue.SetRight(P.WIDTH - x);
        this.butPausaContinue.SetBottom(P.HEIGHT - y);
        int sirka = this.butPausaContinue.GetLeft() - this.butPausaMenu.GetRight();
        int o = (sirka - this.sprButton.getWidth() * 3) / 4;
        this.butPausaMusic = new Button(0, 0, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.butPausaMusic.SetLeft(this.butPausaMenu.GetRight() + o);
        this.butPausaMusic.SetBottom(P.HEIGHT - y);
        this.butPausaInstruction = new Button(0, 0, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.butPausaInstruction.SetLeft(this.butPausaMusic.GetRight() + o);
        this.butPausaInstruction.SetBottom(P.HEIGHT - y);
        this.butPausaRestart = new Button(0, 0, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.butPausaRestart.SetLeft(this.butPausaInstruction.GetRight() + o);
        this.butPausaRestart.SetBottom(P.HEIGHT - y);
        this.vyberac = new Vyberac(new Bod[]{this.butPausaMenu.Poloha, this.butPausaMusic.Poloha, this.butPausaInstruction.Poloha, this.butPausaRestart.Poloha, this.butPausaContinue.Poloha});
        this.vyberac.SetVyberac(5, 1, false, false);
        this.polohaRucka = this.vyberac.Vybrat(4, 0);
        this.pozadiePausa = P.HEIGHT - 30 - Resources.resSprs[8].getHeight() - (Resources.resSprs[8].getHeight() >> 3);
        this.iPozadie = P.HEIGHT / 30 + 1;
        this.jPozadie = P.WIDTH / 30 + 1;
        this.JePausa = true;
    }

    void clickPausa(int x, int y) {
        if (this.lostProgressQuestion) {
            if (this.butPausaMenu.click(x, y)) {
                this.executeAction(2);
            } else if (this.butPausaContinue.click(x, y)) {
                this.executeAction(0);
            }
            return;
        }
        if (this.butPausaMenu.click(x, y)) {
            this.executeAction(1);
            return;
        }
        if (this.butPausaMusic.click(x, y)) {
            ScreenMain.changeSound(0);
            return;
        }
        if (this.butPausaInstruction.click(x, y)) {
            this.showInstruction();
            return;
        }
        if (this.butPausaRestart.click(x, y)) {
            this.executeAction(3);
            this.hidePausa();
            return;
        }
        if (this.butPausaContinue.click(x, y)) {
            this.hidePausa();
            this.game.Pause(false);
            return;
        }
    }

    void relaseKeyPausa(int keyCode) {
        if (this.lostProgressQuestion) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.executeAction(2);
            } else if (Keys.isFKRightCode(keyCode)) {
                this.executeAction(0);
            }
            return;
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.hidePausa();
            this.game.Pause(false);
            return;
        }
        if (Keys.isFKLeftCode(keyCode)) {
            this.executeAction(1);
            return;
        }
        if (Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
            if (this.vyberac.VybranyObjekt == 0) {
                this.executeAction(1);
                return;
            }
            if (this.vyberac.VybranyObjekt == 1) {
                ScreenMain.changeSound(0);
                return;
            }
            if (this.vyberac.VybranyObjekt == 2) {
                this.showInstruction();
                return;
            }
            if (this.vyberac.VybranyObjekt == 3) {
                this.executeAction(3);
                this.hidePausa();
                return;
            }
            if (this.vyberac.VybranyObjekt == 4) {
                this.hidePausa();
                this.game.Pause(false);
                return;
            }
        }
        if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
            this.polohaRucka = this.vyberac.VybratVPravo();
            return;
        }
        if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
            this.polohaRucka = this.vyberac.VybratVLavo();
            return;
        }
    }

    void hidePausa() {
        this.JePausa = false;
        ScreenMain.PlaySound(1);
    }

    void drawPausa(Graphics g) {
        this.paintShadow(g);
        if (this.lostProgressQuestion) {
            this.paintLostProgressQuestion(g);
        } else {
            this.butPausaMenu.Draw(g, this.sprButton, 10);
            if (Profile.bMusic) {
                this.butPausaMusic.Draw(g, this.sprButton, 0);
            } else {
                this.butPausaMusic.Draw(g, this.sprButton, 1);
            }
            this.butPausaInstruction.Draw(g, this.sprButton, 9);
            this.butPausaRestart.Draw(g, this.sprButton, 12);
            this.butPausaContinue.Draw(g, this.sprButton, 11);
        }
    }

    void showInstruction() {
        this.hidePausa();
        int vyska = this.fontStrednyZ.getHeight() * 2;
        int sirka = Resources.resImgs[3].getWidth();
        int vyska1 = MainCanvas.HEIGHT - MainCanvas.HEIGHT / 2;
        int vyskaCeleho = vyska + vyska1;
        int y = P.CENTER_HEIGHT - vyskaCeleho / 2;
        this.ramcekInstruction = new Layout(P.CENTER_WIDTH, y, sirka, vyska);
        this.textInstruction = new Text(this.ramcekInstruction.x, this.ramcekInstruction.y);
        this.textInstruction.SetText(T.Instructions, this.fontStrednyZ, 3);
        this.ramcekInstruction.Width = sirka = this.fontStrednyZ.stringWidth("NAVIGATIONSTASTE".toCharArray());
        this.ramcek = new Layout(P.CENTER_WIDTH, 0, sirka, vyska1);
        this.ramcek.y = this.ramcekInstruction.getBottom() + (vyska1 >> 1) + (vyska >> 1);
        this.scrollText = new ScrollText(this.ramcek.x, this.ramcek.y, this.ramcek.Width - P.OFF10w, this.ramcek.Height - P.OFF10);
        this.scrollText.SetPosuvnik(4, 10, 5);
        this.scrollText.SetText(this.text, this.fontMalyZ, 10, true);
        this.farba = new Farba(254, 231, 194);
        this.JeInstruction = true;
    }

    void clickInstruction(int x, int y) {
        if (this.butBack.click(x, y)) {
            this.hideInstruction();
            return;
        }
        if (this.scrollText != null) {
            this.scrollText.poinertReleased();
        }
    }

    void relaseKeyInstruction(int keyCode) {
        if (Keys.isFKLeftCode(keyCode)) {
            this.hideInstruction();
            return;
        }
        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
            this.scrollText.keyHore = false;
            return;
        }
        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
            this.scrollText.keyDole = false;
            return;
        }
    }

    void hideInstruction() {
        this.JeInstruction = false;
        this.showPausa();
    }

    void drawInstruction(Graphics g) {
        this.paintShadow(g);
        this.ramcekInstruction.DrawTable(g, Resources.resSprs[11]);
        this.textInstruction.DrawRiadok(g, this.fontStrednyZ);
        this.ramcek.DrawTable(g, Resources.resSprs[11]);
        if (this.scrollText != null) {
            this.scrollText.Draw(g, this.fontMalyZ, this.farba);
        }
        this.butBack.Draw(g, Resources.resSprs[1], 3);
    }

    void vybratInstruciton() {
        this.text = T.InstructionsText[ScreenMain.TypHry];
    }

    void showVysledok() {
        this.vysledok = new Vysledok(10);
        this.vysledok.loadContent();
        this.vysledok.Show();
        ScreenMain.PlaySound(2);
        this.JeVysledok = true;
    }

    void hideVysledok() {
        this.vysledok.unloadContent();
        this.vysledok.Hide();
        this.JeVysledok = false;
    }

    void clickVysledok(int x, int y) {
        if (this.vysledok != null) {
            if (this.vysledok.ButPlay.click(x, y)) {
                ScreenMain.PlaySound(1);
                this.hideVysledok();
                this.executeAction(3);
                return;
            }
            if (this.vysledok.ButMenu.click(x, y)) {
                ScreenMain.PlaySound(0);
                this.hideVysledok();
                this.unloadContent();
                ScreenMain.VybratOkno(3);
                return;
            }
        }
    }

    void relaseKeyVysledok() {
        if (this.vysledok != null) {
            if (Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                if (this.vysledok.vyberac.VybranyObjekt == 0) {
                    ScreenMain.PlaySound(1);
                    this.hideVysledok();
                    this.executeAction(3);
                    return;
                }
                if (this.vysledok.vyberac.VybranyObjekt == 1) {
                    ScreenMain.PlaySound(0);
                    this.hideVysledok();
                    this.unloadContent();
                    ScreenMain.VybratOkno(3);
                    return;
                }
            }
            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                this.vysledok.PolohaRucka = this.vysledok.vyberac.VybratHore();
                return;
            }
            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                this.vysledok.PolohaRucka = this.vysledok.vyberac.VybratDole();
                return;
            }
        }
    }

    public void PoObnove() {
        this.poObnove = true;
        this.showPausa();
    }

    private void executeAction(int action) {
        switch (action) {
            case 0: {
                this.lostProgressQuestion = false;
                break;
            }
            case 1: {
                this.lostProgressQuestion = true;
                this.initLostProgressQuestion();
                break;
            }
            case 2: {
                this.unloadContent();
                ScreenMain.VybratOkno(3);
                this.noMoves = false;
                break;
            }
            case 3: {
                this.game.Restart();
                this.noMoves = false;
                break;
            }
        }
    }

    private void initLostProgressQuestion() {
        String text = T.LostProgress;
        int width = P.WIDTH >> 1;
        int x = P.CENTER_WIDTH - (width >> 1);
        this.prepLostProgress = new PreparedText(this.fontMalyZ);
        this.prepLostProgress.prepareText(text, P.WIDTH >> 1);
        int height = this.prepLostProgress.getTextHeight();
        int y = P.CENTER_HEIGHT - (height >> 1);
        this.rectLostProgress = new Rectangle(x, y, width, height);
        Sprite layout = Resources.resSprs[11];
        width = (this.rectLostProgress.width / layout.getWidth() + 2) * layout.getWidth();
        height = (this.rectLostProgress.height / layout.getHeight() + 1) * layout.getHeight() << 1;
        this.lostProgressLayout = new Layout(this.rectLostProgress.getCenterX(), this.rectLostProgress.getCenterY(), width, height);
    }

    private void paintLostProgressQuestion(Graphics g) {
        this.lostProgressLayout.DrawTable(g, Resources.resSprs[11]);
        this.prepLostProgress.drawText(g, this.rectLostProgress, 17);
        this.butPausaMenu.Draw(g, this.sprButton, 2);
        this.butPausaContinue.Draw(g, this.sprButton, 3);
    }

    private void initNoMoves() {
        System.out.println("init no moves");
        String text = T.NoMoves;
        int width = P.WIDTH >> 1;
        int x = P.CENTER_WIDTH - (width >> 1);
        this.prepNoMoves = new PreparedText(this.fontMalyZ);
        this.prepNoMoves.prepareText(text, P.WIDTH >> 1);
        int height = this.prepNoMoves.getTextHeight();
        int y = P.CENTER_HEIGHT - (height >> 1);
        this.rectNoMoves = new Rectangle(x, y, width, height);
        this.sprButton = Resources.resSprs[1];
        x = this.sprButton.getWidth() / 10;
        y = this.sprButton.getHeight() / 10;
        this.butPausaMenu = new Button(0, 0, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.butPausaMenu.SetLeft(x);
        this.butPausaMenu.SetBottom(P.HEIGHT - y);
        this.butPausaContinue = new Button(0, 0, this.sprButton.getWidth(), this.sprButton.getHeight());
        this.butPausaContinue.SetRight(P.WIDTH - x);
        this.butPausaContinue.SetBottom(P.HEIGHT - y);
        Sprite layout = Resources.resSprs[11];
        width = (this.rectNoMoves.width / layout.getWidth() + 2) * layout.getWidth();
        height = (this.rectNoMoves.height / layout.getHeight() + 1) * layout.getHeight() << 1;
        this.noMovesLayout = new Layout(this.rectNoMoves.getCenterX(), this.rectNoMoves.getCenterY(), width, height);
    }

    private void paintNoMoves(Graphics g) {
        this.noMovesLayout.DrawTable(g, Resources.resSprs[11]);
        this.prepNoMoves.drawText(g, this.rectNoMoves, 17);
        this.butPausaMenu.Draw(g, this.sprButton, 12);
        this.butPausaContinue.Draw(g, this.sprButton, 10);
    }

    public void updateDoubleTouch(int tick) {
        if (!this.bDoubleTouch) {
            return;
        }
        if (this.iDoubleTouchTime < 0) {
            return;
        }
        this.iDoubleTouchTime -= tick;
        if (this.iDoubleTouchTime <= 0) {
            this.iDoubleTouchTime = 0;
            this.bDoubleTouch = false;
        }
    }

    private void paintShadow(Graphics g) {
        Sprite shadow = Resources.resSprs[0];
        for (int x = 0; x < P.WIDTH; x += shadow.getWidth()) {
            for (int y = 0; y < P.HEIGHT; y += shadow.getHeight()) {
                shadow.setPosition(x, y);
                shadow.paint(g);
            }
        }
    }
}

