/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.game.T;
import sk.inlogic.graphics.GFont;
import sk.inlogic.mini.Bod;
import sk.inlogic.mini.Button;
import sk.inlogic.mini.Farba;
import sk.inlogic.mini.IOkno;
import sk.inlogic.mini.Layout;
import sk.inlogic.mini.P;
import sk.inlogic.mini.ScrollText;
import sk.inlogic.mini.Text;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.util.Keys;

public class OknoInstructions
implements IOkno {
    public int Id;
    public boolean JeZobrazene;
    boolean isLoaded = false;
    Sprite sipky;
    GFont fontStrednyZ;
    GFont fontMalyZ;
    Layout ramcekInstruction;
    Text textInstruction;
    Layout ramcek;
    ScrollText scrollText;
    Farba farba;
    Bod polohaLogo;
    Button butSipky;
    Button buttonBack;

    public OknoInstructions(int id) {
        this.Id = id;
    }

    public int GetId() {
        return this.Id;
    }

    public void Show() {
        this.JeZobrazene = true;
    }

    public void Hide() {
        this.JeZobrazene = false;
    }

    public boolean IsVisible() {
        return this.JeZobrazene;
    }

    public boolean IsLoaded() {
        return this.isLoaded;
    }

    public void loadContent() {
        this.sipky = Resources.resSprs[1];
        this.fontStrednyZ = Resources.resGFonts[3];
        this.fontMalyZ = Resources.resGFonts[1];
        this.polohaLogo = new Bod(P.CENTER_WIDTH, Resources.resImgs[3].getHeight() / 6);
        int vyska = this.fontStrednyZ.getHeight() * 2;
        int sirka = Resources.resImgs[3].getWidth();
        this.ramcekInstruction = new Layout(P.CENTER_WIDTH, this.polohaLogo.Y + Resources.resImgs[3].getHeight() + vyska - vyska / 3, sirka, vyska);
        this.textInstruction = new Text(this.ramcekInstruction.x, this.ramcekInstruction.y);
        this.textInstruction.SetText(T.Instructions, this.fontStrednyZ, 3);
        this.ramcekInstruction.Width = sirka = this.fontStrednyZ.stringWidth("NAVIGATIONSTASTE".toCharArray());
        int x = Resources.resSprs[1].getWidth() / 10;
        int y = Resources.resSprs[1].getHeight() / 10;
        this.buttonBack = new Button(0, 0, Resources.resSprs[1].getWidth(), Resources.resSprs[1].getHeight());
        this.buttonBack.SetLeft(x);
        this.buttonBack.SetBottom(MainCanvas.HEIGHT - y);
        int vyska1 = this.buttonBack.GetTop() - this.ramcekInstruction.getBottom() - Resources.resSprs[1].getHeight();
        y = this.buttonBack.GetTop() - this.ramcekInstruction.getBottom();
        this.ramcek = new Layout(P.CENTER_WIDTH, this.ramcekInstruction.getBottom() + (y >> 1), sirka, vyska1);
        this.scrollText = new ScrollText(this.ramcek.x, this.ramcek.y, this.ramcek.Width - P.OFF10w, this.ramcek.Height - P.OFF10);
        if (P.WIDTH < 220) {
            this.scrollText.SetPosuvnik(3, 10, 4);
        } else {
            this.scrollText.SetPosuvnik(4, 10, 5);
        }
        this.scrollText.SetText(T.InstructionsText[ScreenMain.TypHry], this.fontMalyZ, 10, true);
        this.farba = new Farba(254, 231, 194);
        this.butSipky = new Button(P.CENTER_WIDTH, this.ramcek.y, Resources.resSprs[1].getWidth(), Resources.resSprs[1].getHeight());
        this.butSipky.SetTop(this.ramcek.getBottom());
        this.isLoaded = true;
    }

    public void unloadContent() {
        this.isLoaded = false;
    }

    public void update(long lTick) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.scrollText != null) {
            this.scrollText.Update();
        }
    }

    public void draw(Graphics g) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        g.drawImage(Resources.resImgs[4], 0, 0, 20);
        g.drawImage(Resources.resImgs[3], this.polohaLogo.X, this.polohaLogo.Y, 17);
        this.ramcekInstruction.DrawTable(g, Resources.resSprs[11]);
        this.textInstruction.DrawRiadok(g, this.fontStrednyZ);
        this.ramcek.DrawTable(g, Resources.resSprs[11]);
        if (this.scrollText != null) {
            this.scrollText.Draw(g, this.fontMalyZ, this.farba);
        }
        this.buttonBack.Draw(g, Resources.resSprs[1], 3);
    }

    public void keyPressed(int keyCode) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
            this.scrollText.keyHore = true;
            return;
        }
        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
            this.scrollText.keyDole = true;
            return;
        }
    }

    public void keyReleased(int keyCode) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (Keys.isFKLeftCode(keyCode)) {
            ScreenMain.VybratOkno(3);
            this.unloadContent();
            return;
        }
        if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
            this.scrollText.keyHore = false;
            return;
        }
        if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
            this.scrollText.keyDole = false;
            return;
        }
    }

    public void pointerPressed(int x, int y) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.scrollText != null) {
            this.scrollText.poinertPressed(x, y);
        }
    }

    public void pointerMoved(int x, int y) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.scrollText != null) {
            this.scrollText.pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.JeZobrazene) {
            return;
        }
        if (this.buttonBack.click(x, y)) {
            ScreenMain.VybratOkno(3);
            this.unloadContent();
            return;
        }
        if (this.scrollText != null) {
            this.scrollText.poinertReleased();
        }
    }
}

