/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.mini;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.graphics.GFont;
import sk.inlogic.mini.Farba;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Rectangle;

public class ScrollText {
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;
    public boolean keyHore = false;
    public boolean keyDole = false;
    public boolean jeClick = false;
    Rectangle posuvnik;
    int posuvnikPosunY = 0;
    int posuvnikRychlost = 4;
    int textRychlost = 4;
    int posuvnikZaoblenie;
    float posuvnikRozdiel = 0.0f;
    PreparedText prepText;
    int TextLines;
    int ShiftY = 0;
    int MaxShiftY = 0;
    int startPolohaY = 0;
    int poslednaPolohaY = 0;

    public ScrollText() {
    }

    public ScrollText(int x, int y, int width, int height) {
        this.x = x - (width >> 1);
        this.y = y - (height >> 1);
        this.width = width;
        this.height = height;
    }

    public int getRight() {
        return this.x + this.width;
    }

    public int getBottom() {
        return this.y + this.height;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    public void SetText(String text, GFont font, int medzera, boolean poRiadkoch) {
        int sirkaTextu = this.width - this.posuvnik.width - medzera;
        this.prepText = new PreparedText(font);
        this.prepText.prepareText(text, sirkaTextu);
        this.TextLines = this.prepText.getTextHeight() / font.getHeight();
        this.ShiftY = 0;
        this.posuvnik.x = this.getRight() - this.posuvnik.width;
        this.posuvnik.y = this.y;
        float vyskaTextu = font.getHeight() * this.TextLines;
        float index = vyskaTextu / (float)this.height;
        this.posuvnik.height = (int)((float)this.height / index);
        this.MaxShiftY = (int)vyskaTextu - this.height;
        this.posuvnikRozdiel = index;
        if (poRiadkoch) {
            this.posuvnikRychlost = font.getHeight();
        }
    }

    public void SetPosuvnik(int sirka, int vyska, int zaoblenie) {
        this.posuvnik = new Rectangle(0, 0, sirka, vyska);
        this.posuvnikZaoblenie = zaoblenie;
    }

    public void Update() {
        if (this.keyHore && this.ShiftY > 0) {
            this.ShiftY -= this.posuvnikRychlost;
            if (this.ShiftY < 0) {
                this.ShiftY = 0;
            }
            if (this.posuvnikRozdiel > 0.0f) {
                this.posuvnikPosunY = (int)((float)this.ShiftY / this.posuvnikRozdiel);
            }
        }
        if (this.keyDole && this.ShiftY < this.MaxShiftY) {
            this.ShiftY += this.posuvnikRychlost;
            if (this.ShiftY > this.MaxShiftY) {
                this.ShiftY = this.MaxShiftY;
            }
            if (this.posuvnikRozdiel > 0.0f) {
                this.posuvnikPosunY = (int)((float)this.ShiftY / this.posuvnikRozdiel);
            }
        }
    }

    public void Draw(Graphics g, GFont font) {
        int iTextYUp = this.y;
        g.setClip(this.x, iTextYUp, this.width, this.height);
        int lineY = 0;
        for (int i = 0; i < this.TextLines; ++i) {
            lineY = iTextYUp + i * font.getHeight() - this.ShiftY;
            font.drawString(g, this.prepText.getText(i).toCharArray(), this.getCenterX(), lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.height <= this.prepText.getTextHeight()) {
            g.setColor(255, 255, 255);
            g.fillRoundRect(this.posuvnik.x, this.posuvnik.y + this.posuvnikPosunY, this.posuvnik.width, this.posuvnik.height, this.posuvnikZaoblenie, this.posuvnikZaoblenie);
        }
    }

    public void Draw(Graphics g, GFont font, Farba f) {
        int iTextYUp = this.y;
        g.setClip(this.x, iTextYUp, this.width, this.height);
        int lineY = 0;
        for (int i = 0; i < this.TextLines; ++i) {
            lineY = iTextYUp + i * font.getHeight() - this.ShiftY;
            font.drawString(g, this.prepText.getText(i).toCharArray(), this.getCenterX(), lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.height <= this.prepText.getTextHeight()) {
            g.setColor(f.R, f.G, f.B);
            g.fillRoundRect(this.posuvnik.x, this.posuvnik.y + this.posuvnikPosunY, this.posuvnik.width, this.posuvnik.height, this.posuvnikZaoblenie, this.posuvnikZaoblenie);
        }
    }

    public void scrollUp() {
        if (this.ShiftY > 0) {
            this.ShiftY -= this.posuvnikRychlost;
            if (this.ShiftY < 0) {
                this.ShiftY = 0;
            }
            if (this.posuvnikRozdiel > 0.0f) {
                this.posuvnikPosunY = (int)((float)this.ShiftY / this.posuvnikRozdiel);
            }
        }
    }

    public void scrollDown() {
        if (this.ShiftY < this.prepText.getTextHeight()) {
            this.ShiftY += this.posuvnikRychlost;
            if (this.ShiftY > this.MaxShiftY) {
                this.ShiftY = this.MaxShiftY;
            }
            if (this.posuvnikRozdiel > 0.0f) {
                this.posuvnikPosunY = (int)((float)this.ShiftY / this.posuvnikRozdiel);
            }
        }
    }

    public void poinertPressed(int px, int py) {
        if (this.height <= this.prepText.getTextHeight() && px >= this.x && px <= this.getRight() && py >= this.y && py <= this.getBottom()) {
            this.jeClick = true;
            this.startPolohaY = py;
        }
    }

    public void poinertReleased() {
        if (this.height <= this.prepText.getTextHeight()) {
            this.jeClick = false;
            this.poslednaPolohaY = this.ShiftY;
        }
    }

    public void pointerDragged(int px, int py) {
        if (this.jeClick) {
            int rozdiel = this.startPolohaY - py;
            this.ShiftY = rozdiel + this.poslednaPolohaY;
            if (this.ShiftY < 0) {
                this.ShiftY = 0;
            }
            if (this.ShiftY > this.MaxShiftY) {
                this.ShiftY = this.MaxShiftY;
            }
            if (this.posuvnikRozdiel > 0.0f) {
                this.posuvnikPosunY = (int)((float)this.ShiftY / this.posuvnikRozdiel);
            }
        }
    }

    public int getShiftY() {
        return this.ShiftY;
    }

    public int getMaxShiftY() {
        return this.MaxShiftY;
    }
}

