/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.HolsterListener;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.system.TrackwheelListener;
import net.rim.device.api.ui.Keypad;

public final class AALDevice
extends GameCanvas
implements KeyListener,
GlobalEventListener,
HolsterListener,
TrackwheelListener {
    public static AALDevice s_instance;
    public static Graphics s_activeGraphics;
    public static int s_width;
    public static int s_height;
    public int navigationKeyPressed = 0;
    private static final int SOUND_LEVEL_SFX = 100;
    private static final int SOUND_LEVEL_MUSIC = 100;
    private static final String SOUND_CONTENT_TYPE_SFX = "audio/x-wav";
    private static final String SOUND_CONTENT_TYPE_MUSIC = "audio/midi";
    private static final int SOUND_MAX_PLAYERS = 32;
    private static boolean s_soundIsSoundEnabled;
    private static int[] s_soundFileIds;
    private static Player s_soundPlayer;
    private static int s_soundId;
    private static int s_soundSfxBits;
    private static boolean s_vibrationEnabled;
    public static final boolean REQUIRES_COMMAND_LABELS = false;
    public static final byte COMMAND_TYPE_OK = 0;
    public static final byte COMMAND_TYPE_BACK = 1;
    public static final byte COMMAND_TYPE_NOT_OK = 2;
    public static final byte COMMAND_TYPE_MENU = 3;
    public static final int SOFTKEY_LEFT = 0;
    public static final int SOFTKEY_RIGHT = 1;
    public static final int SOFTKEY_CLEAR = 2;
    private static byte[] s_commandTypes;
    private static int s_leftSoftkeyCommandIndex;
    private static int s_rightSoftkeyCommandIndex;
    private static int s_clearSoftkeyCommandIndex;
    public static int s_commandReceivedIndex;
    private static int s_commandReceivedIndexAsync;
    public static final int SOFTKEY_CODE_LEFT = 113;
    public static final int SOFTKEY_CODE_RIGHT = 112;
    public static final int SOFTKEY_CODE_CLEAR = 0;
    private static final int KEY_CODE_HANG_UP = 0;
    private static final int KEY_CODE_PICK_UP = 0;
    public static final int VK_INVALID = 0;
    public static final int VK_NUM0 = 2;
    public static final int VK_NUM1 = 4;
    public static final int VK_NUM2 = 8;
    public static final int VK_NUM3 = 16;
    public static final int VK_NUM4 = 32;
    public static final int VK_NUM5 = 64;
    public static final int VK_NUM6 = 128;
    public static final int VK_NUM7 = 256;
    public static final int VK_NUM8 = 512;
    public static final int VK_NUM9 = 1024;
    public static final int VK_POUND = 2048;
    public static final int VK_STAR = 4096;
    public static final int VK_LEFT = 8192;
    public static final int VK_RIGHT = 16384;
    public static final int VK_UP = 32768;
    public static final int VK_DOWN = 65536;
    public static final int VK_FIRE = 131072;
    private static final int VK_SOFTKEY_LEFT = 262144;
    private static final int VK_SOFTKEY_RIGHT = 524288;
    public static final int VK_SOFTKEY_CLEAR = 0x100000;
    public static int s_virtualKeysPressed;
    public static int s_virtualKeysReleased;
    public static int s_virtualKeysDown;
    public static boolean s_anyKeyPressed;
    private static int s_virtualKeysPressedAsync;
    private static int s_virtualKeysReleasedAsync;
    private static int s_virtualKeysDownAsync;
    public static boolean s_anyKeyPressedAsync;
    public static int iCountSOFT1;
    public static boolean bTooMuchSOFT1;
    public static boolean ignoreKeys;
    public static final int TRACKBALL_RELEASE_TIME_MAX = 10;
    public static final int TRACKBALL_RELEASE_TIME_INCREMENT = 25;
    long trackballReleaseTime;
    long trackballTimer;
    long START_TIME;
    public static int s_viewportWidth;
    public static int s_viewportHeight;
    public static final int RECORDSTORE_CACHE_INDEX_START = 0;
    public static final int RECORDSTORE_CACHE_INDEX_END = 2;
    public static final int RECORDSTORE_STATUS_SAVE_TO_FILE_SYSTEM_ENABLED = 1;
    public static final int RECORDSTORE_STATUS_SAVE_TO_CACHE_ENABLED = 2;
    public static final int RECORDSTORE_STATUS_LOAD_FROM_FILE_SYSTEM_ENABLED = 4;
    public static final int RECORDSTORE_STATUS_LOAD_FROM_CACHE_ENABLED = 8;
    private static final byte[][] s_rmsCache;
    public static int s_rmsStatus;
    static final int VOLUME_TYPE_FILESYSTEM = 0;
    static final int VOLUME_TYPE_BIGFILE = 1;
    private static final int FILEREF_CHUNK_TYPE_UTF8 = 0;
    private static final int FILEREF_CHUNK_TYPE_UBYTE = 1;
    private static final int FILEREF_CHUNK_TYPE_USHORT = 2;
    private static final int FILEREF_CHUNK_TYPE_UINT = 4;
    private static String[] s_volumeNamesArray;
    static int[] s_volumeTypesArray;
    static byte[][] s_volumeBufferArray;
    static String[] s_systemFileNamesArray;
    private static int[] s_systemFileSizeArray;
    public static byte[] s_colorRemapSource;
    public static byte[] s_colorRemapDestination;
    private static int[] s_crc32Table;
    private static final byte[] PNG_SIGNATURE;
    private static final byte[] PNG_CHUNK_IEND;
    private static final byte[] PNG_CHUNK_tRNS;
    private static int[] s_fillLineBuffer;
    private static int s_fillColor;

    public AALDevice() {
        super(false);
        this.setFullScreenMode(true);
        Application.getApplication().addKeyListener((KeyListener)this);
        Application.getApplication().addHolsterListener((HolsterListener)this);
        Application.getApplication().enableKeyUpEvents(true);
        Application.getApplication().addGlobalEventListener((GlobalEventListener)this);
        Application.getApplication().addTrackwheelListener((TrackwheelListener)this);
        Application.getApplication().setAcceptEvents(true);
        s_instance = this;
        s_activeGraphics = this.getGraphics();
        s_width = this.getWidth();
        s_height = this.getHeight();
    }

    protected void sizeChanged(int n, int n2) {
        s_width = n;
        s_height = n2;
        AALMidlet.notifyExternalEvent(4);
    }

    protected void showNotify() {
        if (!Application.getApplication().isForeground()) {
            Application.getApplication().requestForeground();
        }
        this.repaint();
        this.serviceRepaints();
        if (AALMidlet.noInterruptAtReturnToMenu || AALMidlet.noInterruptAtSettings && BSC4Midlet.s_isHourGlassSet) {
            return;
        }
        AALMidlet.notifyExternalEvent(3);
    }

    protected void hideNotify() {
        if (AALMidlet.noInterruptAtReturnToMenu || AALMidlet.noInterruptAtSettings && BSC4Midlet.s_isHourGlassSet) {
            return;
        }
        AALMidlet.notifyExternalEvent(1);
    }

    public void inHolster() {
        this.hideNotify();
    }

    public void outOfHolster() {
        this.showNotify();
    }

    public boolean keyUp(int n, int n2) {
        this.keyReleased(this.toCanvasKey(n));
        return true;
    }

    public boolean keyDown(int n, int n2) {
        if (Keypad.key((int)n) == 18) {
            AALMidlet.notifyExternalEvent(4);
            System.out.println("called end key");
            return false;
        }
        this.keyPressed(this.toCanvasKey(n));
        return true;
    }

    public boolean keyStatus(int n, int n2) {
        return true;
    }

    public boolean keyRepeat(int n, int n2) {
        return true;
    }

    public boolean keyChar(char c, int n, int n2) {
        return false;
    }

    public int toCanvasKey(int n) {
        int n2 = Keypad.key((int)n);
        switch (n2) {
            case 10: {
                return -5;
            }
            case 81: {
                return 113;
            }
            case 27: {
                return 112;
            }
            case 80: {
                return 112;
            }
        }
        switch (n2) {
            case 87: {
                return 49;
            }
            case 69: {
                return 50;
            }
            case 82: {
                return 51;
            }
            case 83: {
                return 52;
            }
            case 68: {
                return 53;
            }
            case 70: {
                return 54;
            }
            case 90: {
                return 55;
            }
            case 88: {
                return 56;
            }
            case 67: {
                return 57;
            }
            case 65: {
                return 42;
            }
            case 261: {
                return 35;
            }
        }
        return n2;
    }

    public synchronized boolean trackwheelClick(int n, int n2) {
        this.keyPressed(53);
        return true;
    }

    public boolean trackwheelRoll(int n, int n2, int n3) {
        return false;
    }

    public void eventOccurred(long l, int n, int n2, Object object, Object object2) {
        if (l == 5961289116197897667L) {
            if (n == 1) {
                Application.getApplication().requestBackground();
            } else if (n == 2) {
                // empty if block
            }
        }
    }

    public boolean trackwheelUnclick(int n, int n2) {
        System.out.println("trackwheelUNClick::");
        this.keyPressed(53);
        return true;
    }

    private static void soundCloseCurrentPlayer() {
        if (s_soundPlayer != null) {
            try {
                s_soundPlayer.close();
                s_soundPlayer = null;
                s_soundId = -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean soundIsSupported() {
        try {
            String[] stringArray = Manager.getSupportedContentTypes(null);
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(SOUND_CONTENT_TYPE_MUSIC)) {
                    bl = true;
                    continue;
                }
                if (!stringArray[i].equals(SOUND_CONTENT_TYPE_SFX)) continue;
                bl2 = true;
            }
            return bl2 && bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean soundIsEnabled() {
        return s_soundIsSoundEnabled;
    }

    public static void soundSetEnabled(boolean bl) {
        s_soundIsSoundEnabled = bl;
        if (!bl) {
            AALDevice.soundCloseCurrentPlayer();
        }
    }

    public static int soundCreate(int n, boolean bl) {
        int n2;
        if (s_soundFileIds == null) {
            s_soundFileIds = new int[32];
            for (n2 = 0; n2 < 32; ++n2) {
                AALDevice.s_soundFileIds[n2] = -1;
            }
        }
        n2 = -1;
        for (int i = 0; i < 32; ++i) {
            if (s_soundFileIds[i] != -1) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            if (bl) {
                AALDevice.s_soundFileIds[n2] = n;
                s_soundSfxBits |= 1 << n2;
            } else {
                AALDevice.s_soundFileIds[n2] = n;
                s_soundSfxBits &= ~(1 << n2);
            }
        }
        return n2;
    }

    public static void soundPlay(int n, int n2) {
        if (n < 0 || n >= 32 || !s_soundIsSoundEnabled || s_soundFileIds[n] == -1) {
            return;
        }
        if (s_soundPlayer != null && s_soundId == n) {
            try {
                s_soundPlayer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s_soundPlayer.setLoopCount(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s_soundPlayer.start();
            }
            catch (Exception exception) {}
        } else {
            AALDevice.soundCloseCurrentPlayer();
            String string = SOUND_CONTENT_TYPE_MUSIC;
            int n3 = 100;
            if ((s_soundSfxBits & 1 << n) != 0) {
                string = SOUND_CONTENT_TYPE_SFX;
                n3 = 100;
            }
            try {
                byte[] byArray = AALDevice.openFileAsByteArray(s_soundFileIds[n]);
                s_soundPlayer = Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), (String)string);
                s_soundPlayer.realize();
                s_soundPlayer.prefetch();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                VolumeControl volumeControl = (VolumeControl)s_soundPlayer.getControl("VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel(n3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s_soundPlayer.setLoopCount(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s_soundPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void soundStop(int n) {
        if (n < 0 || n >= 32 || s_soundFileIds[n] == -1) {
            return;
        }
        if (s_soundId == n) {
            AALDevice.soundCloseCurrentPlayer();
        }
    }

    public static void soundRelease(int n) {
        if (n < 0 || n >= 32 || s_soundFileIds[n] == -1) {
            return;
        }
        if (s_soundPlayer != null && n == s_soundId) {
            AALDevice.soundCloseCurrentPlayer();
        }
        AALDevice.s_soundFileIds[n] = -1;
    }

    public static void soundUpdate() {
    }

    public static boolean vibrationIsSupported() {
        boolean bl = false;
        try {
            bl = AALMidlet.s_display.vibrate(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean vibrationIsEnabled() {
        return s_vibrationEnabled;
    }

    public static void vibrationSetEnabled(boolean bl) {
        try {
            s_vibrationEnabled = bl;
            if (!bl) {
                AALMidlet.s_display.vibrate(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrationStart(int n) {
        try {
            if (s_vibrationEnabled) {
                AALMidlet.s_display.vibrate(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrationUpdate(int n) {
    }

    public static void setCommands(byte[] byArray, String[] stringArray) {
        AALDevice.removeAllCommands();
        s_commandTypes = byArray;
    }

    public static void addCommand(int n) {
        switch (s_commandTypes[n]) {
            case 0: {
                s_leftSoftkeyCommandIndex = n;
                break;
            }
            case 1: {
                s_clearSoftkeyCommandIndex = n;
            }
            case 2: {
                s_rightSoftkeyCommandIndex = n;
                break;
            }
            case 3: {
                s_rightSoftkeyCommandIndex = n;
            }
        }
    }

    public static void removeAllCommands() {
        s_leftSoftkeyCommandIndex = -1;
        s_rightSoftkeyCommandIndex = -1;
        s_clearSoftkeyCommandIndex = -1;
        s_commandReceivedIndex = -1;
        s_commandReceivedIndexAsync = -1;
    }

    public static void updateCommandHandler() {
        s_commandReceivedIndex = s_commandReceivedIndexAsync;
        s_commandReceivedIndexAsync = -1;
    }

    public static int getCommandIndexFromSoftkey(int n) {
        if (n == 0) {
            return s_leftSoftkeyCommandIndex;
        }
        if (n == 2) {
            return s_clearSoftkeyCommandIndex;
        }
        return s_rightSoftkeyCommandIndex;
    }

    public static void onSoftkeyPressed(int n) {
        if (n == 0 && s_leftSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_leftSoftkeyCommandIndex;
        } else if (n == 1 && s_rightSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_rightSoftkeyCommandIndex;
        } else if (n == 2 && s_clearSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_clearSoftkeyCommandIndex;
        }
    }

    void p(String string) {
        System.out.println(string);
    }

    public static void clearKeyStates() {
        s_virtualKeysPressed = 0;
        s_virtualKeysReleased = 0;
        s_virtualKeysDown = 0;
        s_anyKeyPressed = false;
        s_virtualKeysPressedAsync = 0;
        s_virtualKeysReleasedAsync = 0;
        s_virtualKeysDownAsync = 0;
        s_anyKeyPressedAsync = false;
    }

    public void keyPressed(int n) {
        int n2;
        if (n == 85 || n == 78 || n == 76 || n == 75 || n == 74 || n == 71 || n == 8 || n == 32 || n == 72) {
            return;
        }
        System.out.println("p_keyCode  " + n);
        AALMidlet.s_instance.onKeyPressed(n);
        if (n != 0 && n != 0) {
            s_anyKeyPressedAsync = true;
        }
        if (((n2 = AALDevice.getVirtualKeyCodeFromRawKeyCode(n)) & 0x40000) != 0) {
            AALDevice.onSoftkeyPressed(0);
        } else if ((n2 & 0x80000) != 0) {
            AALDevice.onSoftkeyPressed(1);
        } else if ((n2 & 0x100000) != 0) {
            AALDevice.onSoftkeyPressed(2);
        }
        if (s_virtualKeysDownAsync == 0 && s_virtualKeysReleasedAsync == 0) {
            s_virtualKeysPressedAsync = n2;
            s_virtualKeysDownAsync = n2;
        }
    }

    public void keyReleased(int n) {
        int n2;
        if (n == 1 || n == 6 || n == 2 || n == 5 || n == 8) {
            if (this.trackballTimer > -1L && this.trackballReleaseTime < 10L) {
                this.trackballReleaseTime += 25L;
            }
            this.trackballTimer = System.currentTimeMillis();
            this.keyPressed(n);
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        s_virtualKeysReleasedAsync = n2 = AALDevice.getVirtualKeyCodeFromRawKeyCode(n);
        s_virtualKeysDownAsync = 0;
        s_virtualKeysPressedAsync = 0;
    }

    public void keyRepeated(int n) {
        int n2 = AALDevice.getVirtualKeyCodeFromRawKeyCode(n);
        if (n != 0 && n != 0) {
            s_anyKeyPressedAsync = true;
        }
        if (s_virtualKeysDownAsync == 0 && s_virtualKeysReleasedAsync == 0) {
            s_virtualKeysPressedAsync = n2;
            s_virtualKeysDownAsync = n2;
        }
    }

    public static void updateKeyboardHandler() {
        s_virtualKeysPressed = s_virtualKeysPressedAsync;
        s_virtualKeysReleased = s_virtualKeysReleasedAsync;
        s_virtualKeysDown = s_virtualKeysDownAsync;
        s_anyKeyPressed = s_anyKeyPressedAsync;
        s_virtualKeysPressedAsync = 0;
        s_virtualKeysReleasedAsync = 0;
        s_virtualKeysDownAsync &= ~s_virtualKeysReleased;
        s_anyKeyPressedAsync = false;
    }

    private static int getVirtualKeyCodeFromRawKeyCode(int n) {
        if (n == 0 || n == 0 || n == 0) {
            return 0;
        }
        if (n == 113 || n == -113) {
            return 262144;
        }
        if (n == 112 || n == -112) {
            return 524288;
        }
        if (n == 0 || n == 0) {
            return 0x100000;
        }
        int n2 = 0;
        switch (n) {
            case 48: {
                n2 = 2;
                break;
            }
            case 49: {
                n2 = 4;
                break;
            }
            case 50: {
                n2 = 8;
                break;
            }
            case 51: {
                n2 = 16;
                break;
            }
            case 52: {
                n2 = 32;
                break;
            }
            case 53: {
                n2 = 64;
                break;
            }
            case 54: {
                n2 = 128;
                break;
            }
            case 55: {
                n2 = 256;
                break;
            }
            case 56: {
                n2 = 512;
                break;
            }
            case 57: {
                n2 = 1024;
                break;
            }
            case 35: {
                n2 = 2048;
                break;
            }
            case 42: {
                n2 = 4096;
            }
        }
        if (n2 == 0) {
            try {
                int n3 = s_instance.getGameAction(n);
                switch (n3) {
                    case 2: {
                        n2 = 8192;
                        break;
                    }
                    case 5: {
                        n2 = 16384;
                        break;
                    }
                    case 1: {
                        n2 = 32768;
                        break;
                    }
                    case 6: {
                        n2 = 65536;
                        break;
                    }
                    case 8: {
                        n2 = 131072;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n2 = 0;
            }
        }
        return n2;
    }

    private static String keyCodeToGameActionString(int n) {
        String string = "unknown";
        try {
            switch (s_instance.getGameAction(n)) {
                case 2: {
                    string = "LEFT";
                    break;
                }
                case 5: {
                    string = "RIGHT";
                    break;
                }
                case 1: {
                    string = "UP";
                    break;
                }
                case 6: {
                    string = "DOWN";
                    break;
                }
                case 8: {
                    string = "FIRE";
                    break;
                }
                case 9: {
                    string = "GAME_A";
                    break;
                }
                case 10: {
                    string = "GAME_B";
                    break;
                }
                case 11: {
                    string = "GAME_C";
                    break;
                }
                case 12: {
                    string = "GAME_D";
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return string;
    }

    public static void viewportSetBounds(int n, int n2, int n3, int n4) {
        s_viewportWidth = n3;
        s_viewportHeight = n4;
        if (s_activeGraphics != null) {
            s_activeGraphics.translate(-s_activeGraphics.getTranslateX() + n, -s_activeGraphics.getTranslateY() + n2);
            s_activeGraphics.setClip(0, 0, n3, n4);
        }
    }

    public static void rmsSaveData(String string, int n, byte[] byArray) throws RecordStoreException {
        if ((s_rmsStatus & 2) != 0) {
            AALDevice.s_rmsCache[n] = byArray;
        }
        if ((s_rmsStatus & 1) == 0) {
            return;
        }
        if (byArray == null) {
            try {
                RecordStore.deleteRecordStore((String)string);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {}
        } else {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                int n2 = recordStore.getNextRecordID();
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.deleteRecord(n2 - 1);
            }
            recordStore.closeRecordStore();
        }
    }

    public static byte[] rmsLoadData(String string, int n) throws RecordStoreException {
        Object object;
        if ((s_rmsStatus & 8) != 0 && (object = s_rmsCache[n]) != null) {
            return object;
        }
        if ((s_rmsStatus & 4) == 0) {
            return null;
        }
        object = RecordStore.openRecordStore((String)string, (boolean)false);
        int n2 = object.getNextRecordID();
        if (n2 == 1) {
            return null;
        }
        byte[] byArray = object.getRecord(--n2);
        object.closeRecordStore();
        if ((s_rmsStatus & 2) != 0) {
            AALDevice.s_rmsCache[n] = byArray;
        }
        return byArray;
    }

    public static void initialize(String[] stringArray, int[] nArray, String[] stringArray2, int[] nArray2) {
        s_volumeNamesArray = stringArray;
        s_volumeTypesArray = nArray;
        s_volumeBufferArray = new byte[stringArray.length][];
        s_systemFileNamesArray = stringArray2;
        s_systemFileSizeArray = nArray2;
    }

    public static void cleanup() {
        for (int i = 0; i < s_volumeBufferArray.length; ++i) {
            AALDevice.s_volumeBufferArray[i] = null;
        }
        AALMidlet.callGarbageCollector();
    }

    static int getVolumeId(int n) {
        return n >>> 24;
    }

    static int getFileIndex(int n) {
        return n & 0xFFFFFF;
    }

    static void openVolume(int n) throws IOException {
        int n2 = s_volumeTypesArray[n];
        if (n2 != 0 && n2 == 1 && s_volumeBufferArray[n] == null) {
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)s_instance)).getClass().getResourceAsStream(s_volumeNamesArray[n]));
            int n3 = dataInputStream.readInt();
            AALDevice.s_volumeBufferArray[n] = new byte[n3];
            dataInputStream.readFully(s_volumeBufferArray[n]);
            dataInputStream.close();
            dataInputStream = null;
        }
    }

    public static DataInputStream openFileAsStream(int n) throws IOException {
        int n2 = AALDevice.getFileIndex(n);
        int n3 = AALDevice.getVolumeId(n);
        int n4 = s_volumeTypesArray[n3];
        AALDevice.openVolume(n3);
        DataInputStream dataInputStream = null;
        if (n4 == 0) {
            String string = s_systemFileNamesArray[n2];
            dataInputStream = AALDevice.openFileAsStream(string);
        } else if (n4 == 1) {
            dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n3]));
            int n5 = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n2 << 3);
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            dataInputStream.reset();
            dataInputStream.skipBytes(4 + n5 + 4 + n7);
        }
        return dataInputStream;
    }

    public static DataInputStream openFileAsStream(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        if (string.indexOf(47) != 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string);
        InputStream inputStream = ((Object)((Object)s_instance)).getClass().getResourceAsStream(stringBuffer.toString());
        return new DataInputStream(inputStream);
    }

    public static byte[] openFileAsByteArray(int n) throws IOException {
        int n2 = AALDevice.getFileLength(n);
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray, 0, n2);
        dataInputStream.close();
        return byArray;
    }

    public static int getVolumeTypeFromFile(int n) {
        return s_volumeTypesArray[AALDevice.getVolumeId(n)];
    }

    public static int getFileLength(int n) throws IOException {
        int n2 = -1;
        int n3 = AALDevice.getFileIndex(n);
        int n4 = AALDevice.getVolumeId(n);
        int n5 = s_volumeTypesArray[n4];
        AALDevice.openVolume(n4);
        if (n5 == 0) {
            n2 = s_systemFileSizeArray[n3];
        } else if (n5 == 1) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n4]));
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n3 << 3);
            n2 = dataInputStream.readInt();
            dataInputStream.close();
        }
        return n2;
    }

    public static int readFilerefChunkIntegerValue(DataInputStream dataInputStream) throws IOException {
        int n = -1;
        int n2 = dataInputStream.readUnsignedByte();
        switch (n2) {
            case 1: {
                n = dataInputStream.readUnsignedByte();
                n = (n & 0xC0) << 18 | n & 0x3F;
                break;
            }
            case 2: {
                n = dataInputStream.readUnsignedShort();
                n = (n & 0xF000) << 12 | n & 0xFFF;
                break;
            }
            case 4: {
                n = dataInputStream.readInt();
            }
        }
        return n;
    }

    public static Image createImage(int n) throws IOException {
        try {
            return AALDevice.createPngImage(n);
        }
        catch (Exception exception) {
            return AALDevice.createPaletteExtractedImage(n);
        }
    }

    public static Image createPngImage(int n) throws IOException {
        int n2 = AALDevice.getFileIndex(n);
        int n3 = AALDevice.getVolumeId(n);
        int n4 = s_volumeTypesArray[n3];
        Image image = null;
        AALDevice.openVolume(n3);
        if (n4 == 0) {
            String string = s_systemFileNamesArray[n2];
            image = Image.createImage((String)("/" + string));
        } else {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n3]));
            int n5 = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n2 << 3);
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            dataInputStream.close();
            dataInputStream = null;
            image = Image.createImage((byte[])s_volumeBufferArray[n3], (int)(4 + n5 + 4 + n7), (int)n6);
        }
        return image;
    }

    public static Image createPaletteExtractedImage(int n) throws IOException {
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readUnsignedShort();
        byte[] byArray = AALDevice.openFileAsByteArray(n2);
        dataInputStream.readFully(byArray, 41, n3);
        dataInputStream.close();
        dataInputStream = null;
        int n4 = AALDevice.getCrc32(byArray, 37, n3 + 4);
        AALDevice.writeInt(byArray, 41 + n3, n4);
        return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Image createCustomImage(int n, boolean bl) throws IOException {
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        if (dataInputStream == null) {
            return null;
        }
        int n2 = dataInputStream.readInt();
        n2 += 32;
        if (bl) {
            n2 += 13;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(PNG_SIGNATURE, 0, byArray, 0, 8);
        dataInputStream.readFully(byArray, 8, 4);
        AALDevice.writeInt(byArray, 12, 1229472850);
        dataInputStream.readFully(byArray, 16, 17);
        int n3 = dataInputStream.readInt();
        AALDevice.writeInt(byArray, 33, n3);
        AALDevice.writeInt(byArray, 37, 1347179589);
        dataInputStream.readFully(byArray, 41, n3 + 4);
        int n4 = n3;
        n4 += 45;
        if (bl) {
            System.arraycopy(PNG_CHUNK_tRNS, 0, byArray, n4, 13);
            n4 += 13;
        }
        int n5 = dataInputStream.readInt();
        n4 = AALDevice.writeInt(byArray, n4, n5);
        n4 = AALDevice.writeInt(byArray, n4, 1229209940);
        dataInputStream.readFully(byArray, n4, n5 + 4);
        dataInputStream.close();
        System.arraycopy(PNG_CHUNK_IEND, 0, byArray, n4 += n5 + 4, 12);
        if (s_colorRemapSource != null) {
            AALDevice.remapColorsInPLTE(byArray, n3);
        }
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        byArray = null;
        return image;
    }

    private static void remapColorsInPLTE(byte[] byArray, int n) {
        int n2;
        int n3 = n / 3;
        int n4 = 41;
        boolean bl = false;
        while (--n3 >= 0) {
            n2 = byArray[n4];
            byte by = byArray[n4 + 1];
            byte by2 = byArray[n4 + 2];
            int n5 = s_colorRemapSource.length;
            while ((n5 -= 3) >= 0) {
                if (n2 != s_colorRemapSource[n5] || by != s_colorRemapSource[n5 + 1] || by2 != s_colorRemapSource[n5 + 2]) continue;
                byArray[n4] = s_colorRemapDestination[n5];
                byArray[n4 + 1] = s_colorRemapDestination[n5 + 1];
                byArray[n4 + 2] = s_colorRemapDestination[n5 + 2];
                bl = true;
                break;
            }
            n4 += 3;
        }
        if (bl) {
            n2 = AALDevice.getCrc32(byArray, 37, n + 4);
            AALDevice.writeInt(byArray, n4, n2);
        }
    }

    private static int getCrc32(byte[] byArray, int n, int n2) {
        int n3;
        if (s_crc32Table == null) {
            s_crc32Table = new int[256];
            n3 = 256;
            while (--n3 >= 0) {
                int n4 = n3;
                int n5 = 8;
                while (--n5 >= 0) {
                    if ((n4 & 1) != 0) {
                        n4 = 0xEDB88320 ^ n4 >>> 1;
                        continue;
                    }
                    n4 >>>= 1;
                }
                AALDevice.s_crc32Table[n3] = n4;
            }
        }
        n3 = -1;
        while (--n2 >= 0) {
            n3 = s_crc32Table[(n3 ^ byArray[n]) & 0xFF] ^ n3 >>> 8;
            ++n;
        }
        return ~n3;
    }

    private static int writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        return n;
    }

    public static AALTileset createTileset(int n, boolean bl) throws IOException {
        int n2;
        AALMidlet.checkLargeElapsedTime();
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        int n3 = AALDevice.readFilerefChunkIntegerValue(dataInputStream);
        int n4 = dataInputStream.readUnsignedByte();
        long[] lArray = new long[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            lArray[n2] = dataInputStream.readLong();
        }
        n2 = dataInputStream.readUnsignedByte();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)dataInputStream.readUnsignedByte();
            byArray2[i] = (byte)dataInputStream.readUnsignedByte();
        }
        dataInputStream.close();
        dataInputStream = null;
        AALMidlet.checkLargeElapsedTime();
        AALTileset aALTileset = AALTileset.createTileset(n3, lArray, byArray, byArray2, bl);
        AALMidlet.checkLargeElapsedTime();
        return aALTileset;
    }

    public static void initFill() {
        s_fillLineBuffer = new int[s_width];
    }

    public static void cleanupFill() {
        s_fillLineBuffer = null;
        s_fillColor = 0;
    }

    public static void setFillColor(int n) {
        if (s_fillColor != n) {
            s_fillColor = n;
            if ((n & 0xFF000000) == -16777216) {
                return;
            }
            int[] nArray = s_fillLineBuffer;
            for (int i = nArray.length - 1; i >= 0; --i) {
                nArray[i] = n;
            }
        }
    }

    public static void fillRect(int n, int n2, int n3, int n4) {
        if ((s_fillColor & 0xFF000000) == -16777216) {
            s_activeGraphics.setColor(s_fillColor);
            s_activeGraphics.fillRect(n, n2, n3, n4);
            return;
        }
        while (--n4 >= 0) {
            s_activeGraphics.drawRGB(s_fillLineBuffer, 0, s_fillLineBuffer.length, n, n2 + n4, n3, 1, true);
        }
    }

    public static void fillLine(int n, int n2, int n3) {
        if ((s_fillColor & 0xFF000000) == -16777216) {
            s_activeGraphics.setColor(s_fillColor);
            s_activeGraphics.fillRect(n, n2, n3, 1);
            return;
        }
        s_activeGraphics.drawRGB(s_fillLineBuffer, 0, s_fillLineBuffer.length, n, n2, n3, 1, true);
    }

    static {
        s_soundIsSoundEnabled = true;
        s_soundFileIds = null;
        s_soundId = -1;
        s_vibrationEnabled = true;
        s_leftSoftkeyCommandIndex = -1;
        s_rightSoftkeyCommandIndex = -1;
        s_clearSoftkeyCommandIndex = -1;
        s_commandReceivedIndex = -1;
        s_commandReceivedIndexAsync = -1;
        iCountSOFT1 = 0;
        bTooMuchSOFT1 = false;
        ignoreKeys = false;
        s_rmsCache = new byte[2][];
        s_rmsStatus = 15;
        PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        PNG_CHUNK_IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        PNG_CHUNK_tRNS = new byte[]{0, 0, 0, 1, 116, 82, 78, 83, 0, 64, -26, -40, 102};
    }
}

