/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public final class GTKAnim {
    public static final int BEHAVIOR_LOOP_ONCE = 0;
    public static final int BEHAVIOR_LOOP_RESTART = 1;
    public static final int BEHAVIOR_LOOP_PING = 2;
    private static final int BEHAVIOR_LOOP_MASK = 3;
    private static final int BEHAVIOR_POSSIBLE_TRANSFORMATIONS_MASK = 65280;
    private static final int BEHAVIOR_POSSIBLE_TRANSFORMATIONS_BITSHIFT = 8;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_FORWARD = 1;
    public static final int STATE_BACKWARD = 2;
    private static final int INSTANCE_TIME_BIT_SHIFT = 16;
    private static final int INSTANCE_FRAME_BIT_SHIFT = 2;
    private static final int INSTANCE_STATE_BIT_SHIFT = 0;
    private static final int INSTANCE_TIME_BIT_MASK = -65536;
    private static final int INSTANCE_FRAME_BIT_MASK = 65532;
    private static final int INSTANCE_STATE_BIT_MASK = 3;
    private static final int TEMP_BUFFER_OFFSET_HOT_SPOT = 0;
    private static final int TEMP_BUFFER_OFFSET_FRAME_BOUNDING_BOX = 2;
    private static final int SIZEOF_TEMP_BUFFER = 6;
    private static final int[] s_tempBuffer = new int[6];
    private short[] m_modelLayerDataArrayShort;
    private byte[] m_modelFrameToLayerIndices;
    private short[] m_modelFrameTimeLimit;
    private int m_modelBehaviour;
    private int m_modelTotalDuration;

    public GTKAnim(int n, int n2, int n3, int n4) {
        this.m_modelLayerDataArrayShort = new short[n2 * 3];
        if (n != n2) {
            this.m_modelFrameToLayerIndices = new byte[n];
        }
        this.m_modelFrameTimeLimit = new short[n];
        this.m_modelBehaviour = n3 | n4 << 8;
    }

    public void addFrameLayer(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 * 3;
        this.m_modelLayerDataArrayShort[n7++] = (short)n3;
        this.m_modelLayerDataArrayShort[n7++] = (short)n5;
        this.m_modelLayerDataArrayShort[n7] = (short)n6;
        if (this.m_modelFrameToLayerIndices != null) {
            this.m_modelFrameToLayerIndices[n] = (byte)n2;
        }
        if (this.m_modelFrameTimeLimit[n] == 0) {
            this.m_modelFrameTimeLimit[n] = (short)(n == 0 ? n4 : this.m_modelFrameTimeLimit[n - 1] + n4);
            this.m_modelTotalDuration += n4;
        }
    }

    public void setLoopMode(int n) {
        this.m_modelBehaviour = this.m_modelBehaviour & 0xFFFFFFFC | n;
    }

    public int getLoopMode() {
        return this.m_modelBehaviour & 3;
    }

    private boolean isComposite() {
        return this.m_modelFrameToLayerIndices != null;
    }

    public int getPossibleTransformations() {
        return (this.m_modelBehaviour & 0xFF00) >>> 8;
    }

    public int getNbFrames() {
        return this.m_modelFrameTimeLimit.length;
    }

    public int getTotalDuration() {
        return this.m_modelTotalDuration;
    }

    public int getNbTotalLayers() {
        int n = this.m_modelLayerDataArrayShort.length / 3;
        return n;
    }

    public int getNbLayersAtFrame(int n) {
        int n2 = this.getFirstLayerIndexAtFrame(n);
        int n3 = this.getLastLayerIndexAtFrame(n);
        return n3 - n2 + 1;
    }

    private int getFirstLayerIndexAtFrame(int n) {
        int n2 = n;
        if (this.isComposite() && n != 0) {
            n2 = (this.m_modelFrameToLayerIndices[n - 1] & 0xFF) + 1;
        }
        return n2;
    }

    private int getLastLayerIndexAtFrame(int n) {
        int n2 = n;
        if (this.isComposite()) {
            n2 = this.m_modelFrameToLayerIndices[n] & 0xFF;
        }
        return n2;
    }

    private int getLayerTileIndex(int n) {
        short s = this.m_modelLayerDataArrayShort[n];
        return s;
    }

    private int getLayerHotspotX(int n) {
        short s = this.m_modelLayerDataArrayShort[n + 1];
        return s;
    }

    private int getLayerHotspotY(int n) {
        short s = this.m_modelLayerDataArrayShort[n + 2];
        return s;
    }

    public void computeGlobalBoundingBox(AALTileset aALTileset, int n, int[] nArray, int n2) {
        int n3 = this.m_modelFrameTimeLimit.length;
        int[] nArray2 = s_tempBuffer;
        this.computeFrameBoundingBox(0, aALTileset, n, nArray2, 2);
        int n4 = nArray2[2];
        int n5 = nArray2[3];
        int n6 = nArray2[4];
        int n7 = nArray2[5];
        for (int i = 0; i < n3; ++i) {
            this.computeFrameBoundingBox(i, aALTileset, n, nArray2, 2);
            n4 = Math.min(n4, nArray2[2]);
            n5 = Math.min(n5, nArray2[3]);
            n6 = Math.max(n6, nArray2[4]);
            n7 = Math.max(n7, nArray2[5]);
        }
        nArray[n2++] = n4;
        nArray[n2++] = n5;
        nArray[n2++] = n6;
        nArray[n2++] = n7;
    }

    public void computeFrameBoundingBox(int n, AALTileset aALTileset, int n2, int[] nArray, int n3) {
        int n4;
        int n5 = this.getLastLayerIndexAtFrame(n) * 3;
        int[] nArray2 = s_tempBuffer;
        this.computeTransformedHotspot(n4, aALTileset, n2, nArray2, 0);
        int n6 = -nArray2[0];
        int n7 = -nArray2[1];
        int n8 = n6;
        int n9 = n7;
        for (n4 = this.getFirstLayerIndexAtFrame(n) * 3; n4 <= n5; n4 += 3) {
            int n10 = this.getLayerTileIndex(n4);
            this.computeTransformedHotspot(n4, aALTileset, n2, nArray2, 0);
            int n11 = -nArray2[0];
            int n12 = -nArray2[1];
            int n13 = n11 + aALTileset.getTileWidth(n10, n2);
            int n14 = n12 + aALTileset.getTileHeight(n10, n2);
            n6 = Math.min(n6, n11);
            n7 = Math.min(n7, n12);
            n8 = Math.max(n8, n13);
            n9 = Math.max(n9, n14);
        }
        nArray[n3++] = n6;
        nArray[n3++] = n7;
        nArray[n3++] = n8;
        nArray[n3++] = n9;
    }

    public void computeTransformedHotspot(int n, AALTileset aALTileset, int n2, int[] nArray, int n3) {
        int n4 = this.getLayerHotspotX(n);
        int n5 = this.getLayerHotspotY(n);
        int n6 = n4;
        int n7 = n5;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n6 = n5;
                n7 = aALTileset.getTileWidth(this.getLayerTileIndex(n)) - n4;
                break;
            }
            case 2: {
                n6 = aALTileset.getTileWidth(this.getLayerTileIndex(n)) - n4;
                n7 = aALTileset.getTileHeight(this.getLayerTileIndex(n)) - n5;
                break;
            }
            case 3: {
                n6 = aALTileset.getTileHeight(this.getLayerTileIndex(n)) - n5;
                n7 = n4;
                break;
            }
            case 4: {
                n6 = aALTileset.getTileWidth(this.getLayerTileIndex(n)) - n4;
                n7 = n5;
                break;
            }
            case 5: {
                n6 = n5;
                n7 = n4;
                break;
            }
            case 6: {
                n6 = n4;
                n7 = aALTileset.getTileHeight(this.getLayerTileIndex(n)) - n5;
                break;
            }
            case 7: {
                n6 = aALTileset.getTileHeight(this.getLayerTileIndex(n)) - n5;
                n7 = aALTileset.getTileWidth(this.getLayerTileIndex(n)) - n4;
            }
        }
        nArray[n3 + 0] = n6;
        nArray[n3 + 1] = n7;
    }

    private static void checkInstanceFieldLengths(int n, int n2) {
    }

    private int createInstance(int n, int n2, int n3) {
        return n << 16 | n2 << 2 | n3;
    }

    public int startInstanceAtFrame(int n) {
        short s = n == 0 ? (short)0 : this.m_modelFrameTimeLimit[n - 1];
        return this.createInstance(s, n, 1);
    }

    public int startInstanceFromEnd() {
        return this.createInstance(this.m_modelTotalDuration, this.m_modelFrameTimeLimit.length - 1, 2);
    }

    public static int getInstanceCurrentTime(int n) {
        return (n & 0xFFFF0000) >>> 16;
    }

    public static int getInstanceCurrentFrame(int n) {
        return (n & 0xFFFC) >>> 2;
    }

    public static int getInstanceCurrentState(int n) {
        return n & 3;
    }

    public int updateInstance(int n, int n2) {
        int n3 = GTKAnim.getInstanceCurrentState(n);
        int n4 = GTKAnim.getInstanceCurrentFrame(n);
        int n5 = GTKAnim.getInstanceCurrentTime(n);
        switch (n3) {
            case 1: {
                n5 += n2;
                break;
            }
            case 2: {
                n5 -= n2;
            }
        }
        switch (this.m_modelBehaviour & 3) {
            case 0: {
                if (n5 < this.m_modelTotalDuration && n5 > 0) break;
                n3 = 0;
                break;
            }
            case 1: {
                if (n5 < this.m_modelTotalDuration) break;
                n5 -= this.m_modelTotalDuration;
                n4 = 0;
                break;
            }
            case 2: {
                if (n5 < 0) {
                    n3 = 1;
                    break;
                }
                if (n5 < this.m_modelTotalDuration) break;
                n3 = 2;
            }
        }
        switch (n3) {
            case 1: {
                int n6 = this.m_modelFrameTimeLimit.length - 1;
                while (n4 < n6 && n5 >= this.m_modelFrameTimeLimit[n4]) {
                    ++n4;
                }
                break;
            }
            case 2: {
                while (n4 > 0 && n5 < this.m_modelFrameTimeLimit[n4 - 1]) {
                    --n4;
                }
                break;
            }
        }
        GTKAnim.checkInstanceFieldLengths(n5, n4);
        return this.createInstance(n5, n4, n3);
    }

    public void drawInstance(int n, AALTileset aALTileset, int n2, int n3, int n4) {
        this.checkPossibleTransformation(n4);
        int n5 = GTKAnim.getInstanceCurrentFrame(n);
        int n6 = this.getFirstLayerIndexAtFrame(n5);
        int n7 = this.getLastLayerIndexAtFrame(n5);
        n6 += n6 << 1;
        n7 += n7 << 1;
        int[] nArray = s_tempBuffer;
        while (n6 <= n7) {
            this.computeTransformedHotspot(n6, aALTileset, n4, nArray, 0);
            aALTileset.drawTile(this.getLayerTileIndex(n6), n4, n2 - nArray[0], n3 - nArray[1]);
            n6 += 3;
        }
    }

    public void drawInstance(int n, AALTileset aALTileset, int[] nArray, int n2, int n3, int n4, int n5, int n6) {
        this.checkPossibleTransformation(n6);
        int n7 = GTKAnim.getInstanceCurrentFrame(n);
        int n8 = this.getFirstLayerIndexAtFrame(n7);
        int n9 = this.getLastLayerIndexAtFrame(n7);
        n8 += n8 << 1;
        n9 += n9 << 1;
        int[] nArray2 = s_tempBuffer;
        while (n8 <= n9) {
            this.computeTransformedHotspot(n8, aALTileset, n6, nArray2, 0);
            int n10 = this.getLayerTileIndex(n8);
            for (int i = 0; i < n3; ++i) {
                if (nArray[i + n2] != n10) continue;
                n10 = -1;
                break;
            }
            if (n10 >= 0) {
                aALTileset.drawTile(n10, n6, n4 - nArray2[0], n5 - nArray2[1]);
            }
            n8 += 3;
        }
    }

    public void drawInstance(int n, AALTileset aALTileset, int n2, int n3, int n4, int n5) {
        this.checkPossibleTransformation(n5);
        int n6 = GTKAnim.getInstanceCurrentFrame(n);
        int n7 = this.getFirstLayerIndexAtFrame(n6);
        n7 += n2;
        n7 += n7 << 1;
        int[] nArray = s_tempBuffer;
        this.computeTransformedHotspot(n7, aALTileset, n5, nArray, 0);
        aALTileset.drawTile(this.getLayerTileIndex(n7), n5, n3 - nArray[0], n4 - nArray[1]);
    }

    private void checkPossibleTransformation(int n) {
    }

    public static GTKAnim loadAnimation(int n, int n2) throws IOException {
        AALMidlet.checkLargeElapsedTime();
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        int n3 = dataInputStream.readUnsignedByte();
        int n4 = dataInputStream.readUnsignedByte();
        int n5 = dataInputStream.readUnsignedByte();
        GTKAnim gTKAnim = new GTKAnim(n4, n5, n2, n3);
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            short s = dataInputStream.readShort();
            int n7 = dataInputStream.readUnsignedByte();
            for (int j = 0; j < n7; ++j) {
                int n8 = dataInputStream.readUnsignedByte();
                short s2 = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                gTKAnim.addFrameLayer(i, n6, n8, s, s2, s3);
                ++n6;
            }
        }
        dataInputStream.close();
        AALMidlet.checkLargeElapsedTime();
        return gTKAnim;
    }
}

