/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class AALTileset {
    private static final int[] AAL_TO_MIDP_TRANSFORMATION_TABLE = new int[]{0, 6, 3, 5, 2, 4, 1, 7};
    private static final int[] MIDP_TO_AAL_TRANSFORMATION_TABLE = new int[]{0, 6, 4, 2, 5, 3, 1, 7};
    public static final boolean PALETTE_REMAP_SUPPORTED = false;
    private Image m_image;
    private int[] m_midpTransMap;
    private byte[] m_indexMap;
    private int m_numTiles;
    private long[] m_rectsLong;

    public static AALTileset createTileset(int n, int[] nArray, byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
        AALTileset aALTileset = new AALTileset();
        return aALTileset;
    }

    public static AALTileset createTileset(int n, long[] lArray, byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
        AALTileset aALTileset = new AALTileset();
        aALTileset.m_image = AALDevice.createImage(n);
        aALTileset.m_indexMap = byArray;
        aALTileset.m_numTiles = byArray.length;
        aALTileset.m_rectsLong = lArray;
        aALTileset.m_midpTransMap = new int[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            aALTileset.m_midpTransMap[i] = AAL_TO_MIDP_TRANSFORMATION_TABLE[byArray2[i]];
        }
        return aALTileset;
    }

    public static void setPaletteRemap(int[] nArray) {
    }

    public int getNbTiles() {
        return this.m_numTiles;
    }

    public int getTileWidth(int n) {
        long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
        if ((this.m_midpTransMap[n] & 4) != 0) {
            return (int)(l & 0xFFFFL);
        }
        int n2 = (int)(l >>> 16 & 0xFFFFL);
        return n2;
    }

    public int getTileHeight(int n) {
        long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
        if ((this.m_midpTransMap[n] & 4) != 0) {
            return (int)(l >>> 16 & 0xFFFFL);
        }
        int n2 = (int)(l & 0xFFFFL);
        return n2;
    }

    public void drawTile(int n, int n2, int n3) {
        long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
        int n4 = (int)l & 0xFFFF;
        int n5 = (int)(l >>> 16 & 0xFFFFL);
        int n6 = (int)(l >>> 32 & 0xFFFFL);
        int n7 = (int)(l >>> 48 & 0xFFFFL);
        AALDevice.s_activeGraphics.drawRegion(this.m_image, n7, n6, n5, n4, this.m_midpTransMap[n], n2, n3, 20);
    }

    public int getTileWidth(int n, int n2) {
        if ((n2 & 1) != 0) {
            return this.getTileHeight(n);
        }
        return this.getTileWidth(n);
    }

    public int getTileHeight(int n, int n2) {
        if ((n2 & 1) != 0) {
            return this.getTileWidth(n);
        }
        return this.getTileHeight(n);
    }

    public void drawTile(int n, int n2, int n3, int n4) {
        long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
        int n5 = (int)l & 0xFFFF;
        int n6 = (int)(l >>> 16 & 0xFFFFL);
        int n7 = (int)(l >>> 32 & 0xFFFFL);
        int n8 = (int)(l >>> 48 & 0xFFFFL);
        int n9 = MIDP_TO_AAL_TRANSFORMATION_TABLE[this.m_midpTransMap[n]];
        int n10 = AALTileTransformation.TRANSFORMATION_TABLE[(n2 << 3) + n9];
        AALDevice.s_activeGraphics.drawRegion(this.m_image, n8, n7, n6, n5, AAL_TO_MIDP_TRANSFORMATION_TABLE[n10], n3, n4, 20);
    }
}

