/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class AALDevice
extends GameCanvas {
    public static AALDevice s_instance;
    public static Graphics s_activeGraphics;
    public static Image backbuffer;
    public static Graphics zoom;
    public static int s_width;
    public static int s_height;
    public static Image s_pauseImage;
    public static final short SCREEN_WIDTH = 180;
    public static final short SCREEN_HEIGHT = 320;
    private static final int FULL_WIDTH = 360;
    private static final int[] s_rgbImage;
    private static final int[] s_rgbScan2;
    public static final short SCREEN_WIDTH_L = 320;
    public static final short SCREEN_HEIGHT_L = 180;
    private static final int FULL_WIDTH_L = 640;
    private static final int[] s_rgbImage_l;
    private static final int[] s_rgbScan2_l;
    private static final int SOUND_LEVEL_SFX = 100;
    private static final int SOUND_LEVEL_MUSIC = 100;
    private static final String SOUND_CONTENT_TYPE_SFX = "audio/midi";
    private static final String SOUND_CONTENT_TYPE_MUSIC = "audio/midi";
    private static final int SOUND_MAX_PLAYERS = 32;
    private static boolean s_soundIsSoundEnabled;
    private static int[] s_soundLevels;
    private static String[] s_soundContentTypes;
    private static byte[][] s_soundBuffers;
    private static Player s_soundPlayer;
    private static int s_soundId;
    private static int s_soundLoopCount;
    private static long s_soundMediaTime;
    private static AALSoundThread s_soundThread;
    private static boolean s_vibrationEnabled;
    public static final boolean REQUIRES_COMMAND_LABELS = false;
    public static final byte COMMAND_TYPE_OK = 0;
    public static final byte COMMAND_TYPE_BACK = 1;
    public static final byte COMMAND_TYPE_NOT_OK = 2;
    public static final byte COMMAND_TYPE_MENU = 3;
    public static final int SOFTKEY_LEFT = 0;
    public static final int SOFTKEY_RIGHT = 1;
    public static final int SOFTKEY_CLEAR = 2;
    public static final int MIDLE_KEY = 3;
    private static byte[] s_commandTypes;
    private static int s_leftSoftkeyCommandIndex;
    private static int s_rightSoftkeyCommandIndex;
    private static int s_clearSoftkeyCommandIndex;
    private static int s_midleSoftkeyCommandIndex;
    public static int s_commandReceivedIndex;
    private static int s_commandReceivedIndexAsync;
    public static final int SOFTKEY_CODE_LEFT = -6;
    public static final int SOFTKEY_CODE_RIGHT = -7;
    public static final int SOFTKEY_CODE_CLEAR = 0;
    public static final int SOFTKEY_CODE_MIDLE = 0;
    private static final int KEY_CODE_HANG_UP = 0;
    private static final int KEY_CODE_PICK_UP = 0;
    public static final int VK_INVALID = 0;
    public static final int VK_NUM0 = 2;
    public static final int VK_NUM1 = 4;
    public static final int VK_NUM2 = 8;
    public static final int VK_NUM3 = 16;
    public static final int VK_NUM4 = 32;
    public static final int VK_NUM5 = 64;
    public static final int VK_NUM6 = 128;
    public static final int VK_NUM7 = 256;
    public static final int VK_NUM8 = 512;
    public static final int VK_NUM9 = 1024;
    public static final int VK_POUND = 2048;
    public static final int VK_STAR = 4096;
    public static final int VK_LEFT = 8192;
    public static final int VK_RIGHT = 16384;
    public static final int VK_UP = 32768;
    public static final int VK_DOWN = 65536;
    public static final int VK_FIRE = 131072;
    private static final int VK_SOFTKEY_LEFT = 262144;
    private static final int VK_SOFTKEY_RIGHT = 524288;
    public static final int VK_SOFTKEY_CLEAR = 0x100000;
    public static final int VK_SOFTKEY_MIDLE = 0x200000;
    public static int s_virtualKeysPressed;
    public static int s_virtualKeysReleased;
    public static int s_virtualKeysDown;
    public static boolean s_anyKeyPressed;
    private static int s_virtualKeysPressedAsync;
    private static int s_virtualKeysReleasedAsync;
    private static int s_virtualKeysDownAsync;
    public static boolean s_anyKeyPressedAsync;
    public static int s_viewportWidth;
    public static int s_viewportHeight;
    public static final int RECORDSTORE_CACHE_INDEX_START = 0;
    public static final int RECORDSTORE_CACHE_INDEX_END = 2;
    public static final int RECORDSTORE_STATUS_SAVE_TO_FILE_SYSTEM_ENABLED = 1;
    public static final int RECORDSTORE_STATUS_SAVE_TO_CACHE_ENABLED = 2;
    public static final int RECORDSTORE_STATUS_LOAD_FROM_FILE_SYSTEM_ENABLED = 4;
    public static final int RECORDSTORE_STATUS_LOAD_FROM_CACHE_ENABLED = 8;
    private static final byte[][] s_rmsCache;
    public static int s_rmsStatus;
    static final int VOLUME_TYPE_FILESYSTEM = 0;
    static final int VOLUME_TYPE_BIGFILE = 1;
    private static final int FILEREF_CHUNK_TYPE_UTF8 = 0;
    private static final int FILEREF_CHUNK_TYPE_UBYTE = 1;
    private static final int FILEREF_CHUNK_TYPE_USHORT = 2;
    private static final int FILEREF_CHUNK_TYPE_UINT = 4;
    private static String[] s_volumeNamesArray;
    static int[] s_volumeTypesArray;
    static byte[][] s_volumeBufferArray;
    static String[] s_systemFileNamesArray;
    private static int[] s_systemFileSizeArray;
    public static byte[] s_colorRemapSource;
    public static byte[] s_colorRemapDestination;
    private static int[] s_crc32Table;
    private static final byte[] PNG_SIGNATURE;
    private static final byte[] PNG_CHUNK_IEND;
    private static final byte[] PNG_CHUNK_tRNS;
    private static int[] s_fillLineBuffer;
    private static int s_fillColor;
    private static final int TOUCHRECT_ENABLED = 0;
    private static final int TOUCHRECT_KEYCODE1 = 1;
    private static final int TOUCHRECT_KEYCODE2 = 2;
    private static final int TOUCHRECT_KEYPRESSED = 3;
    private static final int TOUCHRECT_KEYPRESSED_ELAPSEDTIME = 4;
    private static final int TOUCHRECT_LEFT = 5;
    private static final int TOUCHRECT_TOP = 6;
    private static final int TOUCHRECT_WIDTH = 7;
    private static final int TOUCHRECT_HEIGHT = 8;
    public static final int SIZEOF_TOUCHRECT = 9;
    private static final int TOUCH_MAX_ELAPSED_TIME_KEY_PRESSED = 200;
    public static int[] s_touchRectList;
    private static int[] s_touchRectListSaved;
    public static int targetX_new;
    public static int targetY_new;

    public AALDevice() {
        super(false);
        this.setFullScreenMode(true);
        s_instance = this;
        s_activeGraphics = this.getGraphics();
        s_width = this.getWidth() / 2;
        s_height = this.getHeight() / 2;
        backbuffer = Image.createImage((int)1000, (int)1000);
        zoom = backbuffer.getGraphics();
        s_pauseImage = Image.createImage((int)640, (int)360);
    }

    public static void renderDoubleSize(Image image, Graphics graphics) {
        int[] nArray = s_rgbScan2;
        int[] nArray2 = s_rgbImage;
        graphics.setClip(0, 0, 360, 640);
        image.getRGB(nArray2, 0, 180, 0, 0, 180, 320);
        int n = 638;
        int n2 = 57420;
        int n3 = 319;
        while (n3 >= 0) {
            int n4 = 359;
            int n5 = 179;
            while (n5 >= 0) {
                int n6;
                nArray[n4] = n6 = nArray2[n2 + n5];
                nArray[n4 - 1] = n6;
                nArray[360 + n4] = n6;
                nArray[360 + n4 - 1] = n6;
                --n5;
                n4 -= 2;
            }
            graphics.drawRGB(nArray, 0, 360, 0, n, 360, 2, false);
            --n3;
            n2 -= 180;
            n -= 2;
        }
    }

    public static void renderDoubleSizeLandscape(Image image, Graphics graphics) {
        int[] nArray = s_rgbScan2_l;
        int[] nArray2 = s_rgbImage_l;
        graphics.setClip(0, 0, 640, 360);
        image.getRGB(nArray2, 0, 320, 0, 0, 320, 180);
        int n = 358;
        int n2 = 57280;
        int n3 = 179;
        while (n3 >= 0) {
            int n4 = 639;
            int n5 = 319;
            while (n5 >= 0) {
                int n6;
                nArray[n4] = n6 = nArray2[n2 + n5];
                nArray[n4 - 1] = n6;
                nArray[640 + n4] = n6;
                nArray[640 + n4 - 1] = n6;
                --n5;
                n4 -= 2;
            }
            graphics.drawRGB(nArray, 0, 640, 0, n, 640, 2, false);
            --n3;
            n2 -= 320;
            n -= 2;
        }
    }

    public void paintDoubleBuffer() {
        Graphics graphics = this.getGraphics();
        if (BSC4Midlet.s_pauseState != 1) {
            AALDevice.renderDoubleSize(backbuffer, graphics);
        } else {
            System.out.println("render landscape");
            AALDevice.renderDoubleSizeLandscape(backbuffer, graphics);
        }
    }

    public void paintDoubleBufferLandscape() {
        Graphics graphics = this.getGraphics();
        AALDevice.renderDoubleSize(s_pauseImage, graphics);
    }

    protected void sizeChanged(int n, int n2) {
        s_width = n / 2;
        s_height = n2 / 2;
        zoom.setClip(0, 0, s_width, s_height);
        s_activeGraphics.setClip(0, 0, s_width, s_height);
        AALMidlet.notifyExternalEvent(4);
    }

    protected void showNotify() {
        AALMidlet.notifyExternalEvent(3);
    }

    protected void hideNotify() {
        AALMidlet.notifyExternalEvent(1);
    }

    private static void soundCloseCurrentPlayer() {
        if (s_soundPlayer != null) {
            try {
                s_soundPlayer.close();
                s_soundPlayer = null;
                s_soundId = -1;
                s_soundLoopCount = 0;
                s_soundMediaTime = 0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean soundIsSupported() {
        try {
            String[] stringArray = Manager.getSupportedContentTypes(null);
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("audio/midi")) {
                    bl = true;
                }
                if (!stringArray[i].equals("audio/midi")) continue;
                bl2 = true;
            }
            return bl2 && bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean soundIsEnabled() {
        return s_soundIsSoundEnabled;
    }

    public static void soundSetEnabled(boolean bl) {
        s_soundIsSoundEnabled = bl;
        if (!bl) {
            AALDevice.soundCloseCurrentPlayer();
        }
    }

    public static int soundCreate(int n, boolean bl) {
        if (s_soundThread == null) {
            s_soundThread = new AALSoundThread();
            s_soundThread.start();
        }
        int n2 = -1;
        for (int i = 0; i < 32; ++i) {
            if (s_soundBuffers[i] != null) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            if (bl) {
                AALDevice.s_soundLevels[n2] = 100;
                AALDevice.s_soundContentTypes[n2] = "audio/midi";
            } else {
                AALDevice.s_soundLevels[n2] = 100;
                AALDevice.s_soundContentTypes[n2] = "audio/midi";
            }
            try {
                AALDevice.s_soundBuffers[n2] = AALDevice.openFileAsByteArray(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static void soundPlay(int n, int n2) {
        if (n < 0 || n >= 32 || !s_soundIsSoundEnabled || s_soundBuffers[n] == null) {
            return;
        }
        s_soundThread.playSound(n, n2);
    }

    public static void soundPlayAsync(int n, int n2) {
        if (n < 0 || n >= 32 || !s_soundIsSoundEnabled || s_soundBuffers[n] == null) {
            return;
        }
        AALDevice.soundCloseCurrentPlayer();
        Player player = null;
        try {
            player = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_soundBuffers[n]), (String)s_soundContentTypes[n]);
            player.prefetch();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(s_soundLevels[n]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_soundId = n;
        s_soundLoopCount = n2;
        s_soundMediaTime = 0L;
        s_soundPlayer = player;
    }

    public static void soundRelease(int n) {
        if (n < 0 || n >= 32 || s_soundBuffers[n] == null) {
            return;
        }
        if (s_soundPlayer != null && n == s_soundId) {
            AALDevice.soundCloseCurrentPlayer();
        }
        AALDevice.s_soundBuffers[n] = null;
    }

    public static void soundStop(int n) {
        if (n == s_soundId) {
            AALDevice.soundCloseCurrentPlayer();
        }
    }

    public static void soundUpdate() {
        if (s_soundPlayer != null && (s_soundLoopCount < 0 || s_soundLoopCount > 1)) {
            try {
                long l = s_soundPlayer.getMediaTime();
                if (l - s_soundMediaTime < 0L) {
                    s_soundMediaTime = 0L;
                    if (s_soundLoopCount > 1) {
                        --s_soundLoopCount;
                    }
                    AALDevice.soundPlay(s_soundId, s_soundLoopCount);
                } else {
                    s_soundMediaTime = l;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean vibrationIsSupported() {
        boolean bl = false;
        try {
            bl = AALMidlet.s_display.vibrate(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean vibrationIsEnabled() {
        return s_vibrationEnabled;
    }

    public static void vibrationSetEnabled(boolean bl) {
        try {
            s_vibrationEnabled = bl;
            if (!bl) {
                AALMidlet.s_display.vibrate(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrationStart(int n) {
        try {
            if (s_vibrationEnabled) {
                AALMidlet.s_display.vibrate(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrationUpdate(int n) {
    }

    public static void setCommands(byte[] byArray, String[] stringArray) {
        AALDevice.removeAllCommands();
        s_commandTypes = byArray;
    }

    public static void addCommand(int n) {
        switch (s_commandTypes[n]) {
            case 0: {
                s_midleSoftkeyCommandIndex = n;
                s_leftSoftkeyCommandIndex = n;
                break;
            }
            case 1: {
                s_clearSoftkeyCommandIndex = n;
            }
            case 2: {
                s_rightSoftkeyCommandIndex = n;
                break;
            }
            case 3: {
                s_rightSoftkeyCommandIndex = n;
            }
        }
    }

    public static void removeAllCommands() {
        s_leftSoftkeyCommandIndex = -1;
        s_rightSoftkeyCommandIndex = -1;
        s_clearSoftkeyCommandIndex = -1;
        s_commandReceivedIndex = -1;
        s_commandReceivedIndexAsync = -1;
    }

    public static void updateCommandHandler() {
        s_commandReceivedIndex = s_commandReceivedIndexAsync;
        s_commandReceivedIndexAsync = -1;
    }

    public static int getCommandIndexFromSoftkey(int n) {
        if (n == 0) {
            return s_leftSoftkeyCommandIndex;
        }
        if (n == 2) {
            return s_clearSoftkeyCommandIndex;
        }
        if (n == 3) {
            return s_midleSoftkeyCommandIndex;
        }
        return s_rightSoftkeyCommandIndex;
    }

    public static void onSoftkeyPressed(int n) {
        if (n == 0 && s_leftSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_leftSoftkeyCommandIndex;
        } else if (n == 1 && s_rightSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_rightSoftkeyCommandIndex;
        } else if (n == 2 && s_clearSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_clearSoftkeyCommandIndex;
        } else if (n == 3 && s_midleSoftkeyCommandIndex >= 0) {
            s_commandReceivedIndexAsync = s_midleSoftkeyCommandIndex;
        }
    }

    public static void clearKeyStates() {
        s_virtualKeysPressed = 0;
        s_virtualKeysReleased = 0;
        s_virtualKeysDown = 0;
        s_anyKeyPressed = false;
        s_virtualKeysPressedAsync = 0;
        s_virtualKeysReleasedAsync = 0;
        s_virtualKeysDownAsync = 0;
        s_anyKeyPressedAsync = false;
    }

    public void keyPressed(int n) {
        int n2;
        AALMidlet.s_instance.onKeyPressed(n);
        if (n != 0 && n != 0) {
            s_anyKeyPressedAsync = true;
        }
        if (((n2 = AALDevice.getVirtualKeyCodeFromRawKeyCode(n)) & 0x40000) != 0) {
            AALDevice.onSoftkeyPressed(0);
        } else if ((n2 & 0x80000) != 0) {
            AALDevice.onSoftkeyPressed(1);
        } else if ((n2 & 0x100000) != 0) {
            AALDevice.onSoftkeyPressed(2);
        }
        s_virtualKeysPressedAsync |= n2;
        s_virtualKeysDownAsync |= n2;
    }

    public void keyReleased(int n) {
        int n2 = AALDevice.getVirtualKeyCodeFromRawKeyCode(n);
        s_virtualKeysReleasedAsync |= n2;
    }

    public void keyRepeated(int n) {
        int n2 = AALDevice.getVirtualKeyCodeFromRawKeyCode(n);
        if (n != 0) {
            s_anyKeyPressedAsync = true;
        }
        s_virtualKeysDownAsync |= n2;
        s_virtualKeysPressedAsync &= ~n2;
    }

    public static void updateKeyboardHandler() {
        s_virtualKeysPressed = s_virtualKeysPressedAsync;
        s_virtualKeysReleased = s_virtualKeysReleasedAsync;
        s_virtualKeysDown = s_virtualKeysDownAsync;
        s_anyKeyPressed = s_anyKeyPressedAsync;
        s_virtualKeysPressedAsync = 0;
        s_virtualKeysReleasedAsync = 0;
        s_virtualKeysDownAsync &= ~s_virtualKeysReleased;
        s_anyKeyPressedAsync = false;
    }

    private static int getVirtualKeyCodeFromRawKeyCode(int n) {
        if (n == 0 || n == 0 || n == 0) {
            return 0;
        }
        if (n == -6 || n == 6) {
            return 262144;
        }
        if (n == -7 || n == 7) {
            return 524288;
        }
        if (n == 0 || n == 0) {
            return 0x100000;
        }
        if (n == 0 || n == 0) {
            return 0x200000;
        }
        int n2 = 0;
        switch (n) {
            case 48: {
                n2 = 2;
                break;
            }
            case 49: {
                n2 = 4;
                break;
            }
            case 50: {
                n2 = 8;
                break;
            }
            case 51: {
                n2 = 16;
                break;
            }
            case 52: {
                n2 = 32;
                break;
            }
            case 53: {
                n2 = 64;
                break;
            }
            case 54: {
                n2 = 128;
                break;
            }
            case 55: {
                n2 = 256;
                break;
            }
            case 56: {
                n2 = 512;
                break;
            }
            case 57: {
                n2 = 1024;
                break;
            }
            case 35: {
                n2 = 2048;
                break;
            }
            case 42: {
                n2 = 4096;
            }
        }
        if (n2 == 0) {
            try {
                int n3 = s_instance.getGameAction(n);
                switch (n3) {
                    case 2: {
                        n2 = 8192;
                        break;
                    }
                    case 5: {
                        n2 = 16384;
                        break;
                    }
                    case 1: {
                        n2 = 32768;
                        break;
                    }
                    case 6: {
                        n2 = 65536;
                        break;
                    }
                    case 8: {
                        n2 = 131072;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n2 = 0;
            }
        }
        return n2;
    }

    private static String keyCodeToGameActionString(int n) {
        String string = "unknown";
        try {
            switch (s_instance.getGameAction(n)) {
                case 2: {
                    string = "LEFT";
                    break;
                }
                case 5: {
                    string = "RIGHT";
                    break;
                }
                case 1: {
                    string = "UP";
                    break;
                }
                case 6: {
                    string = "DOWN";
                    break;
                }
                case 8: {
                    string = "FIRE";
                    break;
                }
                case 9: {
                    string = "GAME_A";
                    break;
                }
                case 10: {
                    string = "GAME_B";
                    break;
                }
                case 11: {
                    string = "GAME_C";
                    break;
                }
                case 12: {
                    string = "GAME_D";
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return string;
    }

    public static void viewportSetBounds(int n, int n2, int n3, int n4) {
        s_viewportWidth = n3;
        s_viewportHeight = n4;
        if (s_activeGraphics != null) {
            s_activeGraphics.translate(-s_activeGraphics.getTranslateX() + n, -s_activeGraphics.getTranslateY() + n2);
            s_activeGraphics.setClip(0, 0, n3, n4);
        }
    }

    public static void rmsSaveData(String string, int n, byte[] byArray) throws RecordStoreException {
        if ((s_rmsStatus & 2) != 0) {
            AALDevice.s_rmsCache[n] = byArray;
        }
        if ((s_rmsStatus & 1) == 0) {
            return;
        }
        if (byArray == null) {
            try {
                RecordStore.deleteRecordStore((String)string);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {}
        } else {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
    }

    public static byte[] rmsLoadData(String string, int n) throws RecordStoreException {
        Object object;
        if ((s_rmsStatus & 8) != 0 && (object = s_rmsCache[n]) != null) {
            return object;
        }
        if ((s_rmsStatus & 4) == 0) {
            return null;
        }
        object = RecordStore.openRecordStore((String)string, (boolean)false);
        byte[] byArray = object.getRecord(1);
        object.closeRecordStore();
        if ((s_rmsStatus & 2) != 0) {
            AALDevice.s_rmsCache[n] = byArray;
        }
        return byArray;
    }

    public static void initialize(String[] stringArray, int[] nArray, String[] stringArray2, int[] nArray2) {
        s_volumeNamesArray = stringArray;
        s_volumeTypesArray = nArray;
        s_volumeBufferArray = new byte[stringArray.length][];
        s_systemFileNamesArray = stringArray2;
        s_systemFileSizeArray = nArray2;
    }

    public static void cleanup() {
        for (int i = 0; i < s_volumeBufferArray.length; ++i) {
            AALDevice.s_volumeBufferArray[i] = null;
        }
        AALMidlet.callGarbageCollector();
    }

    static int getVolumeId(int n) {
        return n >>> 24;
    }

    static int getFileIndex(int n) {
        return n & 0xFFFFFF;
    }

    static void openVolume(int n) throws IOException {
        int n2 = s_volumeTypesArray[n];
        if (n2 != 0 && n2 == 1 && s_volumeBufferArray[n] == null) {
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)s_instance)).getClass().getResourceAsStream(s_volumeNamesArray[n]));
            int n3 = dataInputStream.readInt();
            AALDevice.s_volumeBufferArray[n] = new byte[n3];
            dataInputStream.readFully(s_volumeBufferArray[n]);
            dataInputStream.close();
            dataInputStream = null;
        }
    }

    public static DataInputStream openFileAsStream(int n) throws IOException {
        int n2 = AALDevice.getFileIndex(n);
        int n3 = AALDevice.getVolumeId(n);
        int n4 = s_volumeTypesArray[n3];
        AALDevice.openVolume(n3);
        DataInputStream dataInputStream = null;
        if (n4 == 0) {
            String string = s_systemFileNamesArray[n2];
            dataInputStream = AALDevice.openFileAsStream(string);
        } else if (n4 == 1) {
            dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n3]));
            int n5 = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n2 << 3);
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            dataInputStream.reset();
            dataInputStream.skipBytes(4 + n5 + 4 + n7);
        }
        return dataInputStream;
    }

    public static DataInputStream openFileAsStream(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        if (string.indexOf(47) != 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string);
        InputStream inputStream = ((Object)((Object)s_instance)).getClass().getResourceAsStream(stringBuffer.toString());
        return new DataInputStream(inputStream);
    }

    public static byte[] openFileAsByteArray(int n) throws IOException {
        int n2 = AALDevice.getFileLength(n);
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray, 0, n2);
        dataInputStream.close();
        return byArray;
    }

    public static int getVolumeTypeFromFile(int n) {
        return s_volumeTypesArray[AALDevice.getVolumeId(n)];
    }

    public static int getFileLength(int n) throws IOException {
        int n2 = -1;
        int n3 = AALDevice.getFileIndex(n);
        int n4 = AALDevice.getVolumeId(n);
        int n5 = s_volumeTypesArray[n4];
        AALDevice.openVolume(n4);
        if (n5 == 0) {
            n2 = s_systemFileSizeArray[n3];
        } else if (n5 == 1) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n4]));
            dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n3 << 3);
            n2 = dataInputStream.readInt();
            dataInputStream.close();
        }
        return n2;
    }

    public static int readFilerefChunkIntegerValue(DataInputStream dataInputStream) throws IOException {
        int n = -1;
        int n2 = dataInputStream.readUnsignedByte();
        switch (n2) {
            case 1: {
                n = dataInputStream.readUnsignedByte();
                n = (n & 0xC0) << 18 | n & 0x3F;
                break;
            }
            case 2: {
                n = dataInputStream.readUnsignedShort();
                n = (n & 0xF000) << 12 | n & 0xFFF;
                break;
            }
            case 4: {
                n = dataInputStream.readInt();
            }
        }
        return n;
    }

    public static Image createImage(int n) throws IOException {
        try {
            return AALDevice.createPngImage(n);
        }
        catch (Exception exception) {
            return AALDevice.createPaletteExtractedImage(n);
        }
    }

    public static Image createPngImage(int n) throws IOException {
        int n2 = AALDevice.getFileIndex(n);
        int n3 = AALDevice.getVolumeId(n);
        int n4 = s_volumeTypesArray[n3];
        Image image = null;
        AALDevice.openVolume(n3);
        if (n4 == 0) {
            String string = s_systemFileNamesArray[n2];
            image = Image.createImage((String)("/" + string));
        } else {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(s_volumeBufferArray[n3]));
            int n5 = dataInputStream.readInt();
            dataInputStream.readInt();
            dataInputStream.skipBytes(n2 << 3);
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            dataInputStream.close();
            dataInputStream = null;
            image = Image.createImage((byte[])s_volumeBufferArray[n3], (int)(4 + n5 + 4 + n7), (int)n6);
        }
        return image;
    }

    public static Image createPaletteExtractedImage(int n) throws IOException {
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readUnsignedShort();
        byte[] byArray = AALDevice.openFileAsByteArray(n2);
        dataInputStream.readFully(byArray, 41, n3);
        dataInputStream.close();
        dataInputStream = null;
        int n4 = AALDevice.getCrc32(byArray, 37, n3 + 4);
        AALDevice.writeInt(byArray, 41 + n3, n4);
        return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Image createCustomImage(int n, boolean bl) throws IOException {
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        if (dataInputStream == null) {
            return null;
        }
        int n2 = dataInputStream.readInt();
        n2 += 32;
        if (bl) {
            n2 += 13;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(PNG_SIGNATURE, 0, byArray, 0, 8);
        dataInputStream.readFully(byArray, 8, 4);
        AALDevice.writeInt(byArray, 12, 1229472850);
        dataInputStream.readFully(byArray, 16, 17);
        int n3 = dataInputStream.readInt();
        AALDevice.writeInt(byArray, 33, n3);
        AALDevice.writeInt(byArray, 37, 1347179589);
        dataInputStream.readFully(byArray, 41, n3 + 4);
        int n4 = n3;
        n4 += 45;
        if (bl) {
            System.arraycopy(PNG_CHUNK_tRNS, 0, byArray, n4, 13);
            n4 += 13;
        }
        int n5 = dataInputStream.readInt();
        n4 = AALDevice.writeInt(byArray, n4, n5);
        n4 = AALDevice.writeInt(byArray, n4, 1229209940);
        dataInputStream.readFully(byArray, n4, n5 + 4);
        dataInputStream.close();
        System.arraycopy(PNG_CHUNK_IEND, 0, byArray, n4 += n5 + 4, 12);
        if (s_colorRemapSource != null) {
            AALDevice.remapColorsInPLTE(byArray, n3);
        }
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        byArray = null;
        return image;
    }

    private static void remapColorsInPLTE(byte[] byArray, int n) {
        int n2;
        int n3 = n / 3;
        int n4 = 41;
        boolean bl = false;
        while (--n3 >= 0) {
            n2 = byArray[n4];
            byte by = byArray[n4 + 1];
            byte by2 = byArray[n4 + 2];
            int n5 = s_colorRemapSource.length;
            while ((n5 -= 3) >= 0) {
                if (n2 != s_colorRemapSource[n5] || by != s_colorRemapSource[n5 + 1] || by2 != s_colorRemapSource[n5 + 2]) continue;
                byArray[n4] = s_colorRemapDestination[n5];
                byArray[n4 + 1] = s_colorRemapDestination[n5 + 1];
                byArray[n4 + 2] = s_colorRemapDestination[n5 + 2];
                bl = true;
                break;
            }
            n4 += 3;
        }
        if (bl) {
            n2 = AALDevice.getCrc32(byArray, 37, n + 4);
            AALDevice.writeInt(byArray, n4, n2);
        }
    }

    private static int getCrc32(byte[] byArray, int n, int n2) {
        int n3;
        if (s_crc32Table == null) {
            s_crc32Table = new int[256];
            n3 = 256;
            while (--n3 >= 0) {
                int n4 = n3;
                int n5 = 8;
                while (--n5 >= 0) {
                    if ((n4 & 1) != 0) {
                        n4 = 0xEDB88320 ^ n4 >>> 1;
                        continue;
                    }
                    n4 >>>= 1;
                }
                AALDevice.s_crc32Table[n3] = n4;
            }
        }
        n3 = -1;
        while (--n2 >= 0) {
            n3 = s_crc32Table[(n3 ^ byArray[n]) & 0xFF] ^ n3 >>> 8;
            ++n;
        }
        return ~n3;
    }

    private static int writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        return n;
    }

    public static AALTileset createTileset(int n, boolean bl) throws IOException {
        int n2;
        AALMidlet.checkLargeElapsedTime();
        DataInputStream dataInputStream = AALDevice.openFileAsStream(n);
        int n3 = AALDevice.readFilerefChunkIntegerValue(dataInputStream);
        int n4 = dataInputStream.readUnsignedByte();
        long[] lArray = new long[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            lArray[n2] = dataInputStream.readLong();
        }
        n2 = dataInputStream.readUnsignedByte();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)dataInputStream.readUnsignedByte();
            byArray2[i] = (byte)dataInputStream.readUnsignedByte();
        }
        dataInputStream.close();
        dataInputStream = null;
        AALMidlet.checkLargeElapsedTime();
        AALTileset aALTileset = AALTileset.createTileset(n3, lArray, byArray, byArray2, bl);
        AALMidlet.checkLargeElapsedTime();
        return aALTileset;
    }

    public static void initFill() {
        s_fillLineBuffer = new int[Math.max(s_width, s_height)];
    }

    public static void cleanupFill() {
        s_fillLineBuffer = null;
        s_fillColor = 0;
    }

    public static void setFillColor(int n) {
        if (s_fillColor != n) {
            s_fillColor = n;
            if ((n & 0xFF000000) == -16777216) {
                return;
            }
            int[] nArray = s_fillLineBuffer;
            for (int i = nArray.length - 1; i >= 0; --i) {
                nArray[i] = n;
            }
        }
    }

    public static void fillRect(int n, int n2, int n3, int n4) {
        if ((s_fillColor & 0xFF000000) == -16777216) {
            s_activeGraphics.setColor(s_fillColor);
            s_activeGraphics.fillRect(n, n2, n3, n4);
            return;
        }
        while (--n4 >= 0) {
            s_activeGraphics.drawRGB(s_fillLineBuffer, 0, s_fillLineBuffer.length, n, n2 + n4, n3, 1, true);
        }
    }

    public static void fillLine(int n, int n2, int n3) {
        if ((s_fillColor & 0xFF000000) == -16777216) {
            s_activeGraphics.setColor(s_fillColor);
            s_activeGraphics.fillRect(n, n2, n3, 1);
            return;
        }
        s_activeGraphics.drawRGB(s_fillLineBuffer, 0, s_fillLineBuffer.length, n, n2, n3, 1, true);
    }

    public static void saveCurrentTouchRectList() {
        s_touchRectListSaved = s_touchRectList;
    }

    public static void restoreCurrentTouchRectList() {
        s_touchRectList = s_touchRectListSaved;
    }

    public static boolean isTouchSupported() {
        return s_instance.hasPointerEvents() && s_instance.hasPointerMotionEvents();
    }

    public static void updateTouchRectList() {
        if (s_touchRectList != null) {
            for (int i = 0; i < s_touchRectList.length; i += 9) {
                if (s_touchRectList[i + 0] == 0 || s_touchRectList[i + 3] != 1 || s_touchRectList[i + 2] == 0) continue;
                int n = i + 4;
                s_touchRectList[n] = s_touchRectList[n] + AALMidlet.s_elapsedTimeReal;
                if (s_touchRectList[i + 4] < 200) continue;
                s_instance.keyPressed(s_touchRectList[i + 1]);
                s_instance.keyReleased(s_touchRectList[i + 1]);
                AALDevice.s_touchRectList[i + 3] = 0;
                AALDevice.s_touchRectList[i + 4] = 0;
            }
        }
    }

    public static void setTouchRectList(int[] nArray) {
        s_touchRectList = nArray;
        AALDevice.clearKeyStates();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; i += 9) {
                nArray[i + 3] = 0;
            }
        }
    }

    public static void setTouchRectEnabled(int[] nArray, int n, boolean bl) {
        nArray[n * 9 + 0] = bl ? 1 : 0;
    }

    public static boolean getTouchRectEnabled(int[] nArray, int n) {
        return nArray[n * 9 + 0] != 0;
    }

    public static void setTouchRect(int[] nArray, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        AALDevice.setTouchRect(nArray, n, bl, n2, 0, n3, n4, n5, n6);
    }

    public static void setTouchRect(int[] nArray, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n * 9;
        nArray[n8 + 0] = bl ? 1 : 0;
        nArray[n8 + 1] = n2;
        nArray[n8 + 2] = n3;
        nArray[n8 + 3] = 0;
        nArray[n8 + 4] = 0;
        nArray[n8 + 5] = n4;
        nArray[n8 + 6] = n5;
        nArray[n8 + 7] = n6;
        nArray[n8 + 8] = n7;
    }

    protected void pointerPressed(int n, int n2) {
        if (BSC4Midlet.s_gameDataOpponentBattleship == 1 && BSC4Midlet.s_menuScreen == 3 && n > 15 && n < 130 && n2 > 290 && n2 < 330) {
            return;
        }
        if (BSC4Midlet.s_gameDataRulesConnect4 == 0 && BSC4Midlet.s_menuScreen == 4 && n > 20 && n < 260 && n2 > 255 && n2 < 290) {
            return;
        }
        n /= 2;
        n2 /= 2;
        int n3 = s_height / 10;
        int n4 = s_height - n3;
        int n5 = s_height / 5;
        int n6 = s_width / 3;
        int n7 = (s_height - n3 - n5) / 3;
        int n8 = s_width / 3;
        int n9 = s_width;
        int n10 = s_height * 43 / 100;
        int n11 = s_height * 36 / 100;
        BSC4Midlet.virtual_x = n;
        BSC4Midlet.virtual_y = n2;
        boolean bl = false;
        if (BSC4Midlet.virtual_x < n6 && BSC4Midlet.virtual_y > n4) {
            System.out.println("stanga");
            s_instance.keyPressed(s_touchRectList[1]);
        }
        if (BSC4Midlet.virtual_x > s_width - n6 && BSC4Midlet.virtual_y > n4) {
            System.out.println("dramba");
            s_instance.keyPressed(s_touchRectList[10]);
        }
        if (BSC4Midlet.s_pauseState == 0 || BSC4Midlet.s_gameState == 2) {
            int n12;
            System.out.println("ajungem");
            if (BSC4Midlet.s_menuScreen == 6 || BSC4Midlet.s_menuScreen == 7 || BSC4Midlet.s_menuScreen == 8) {
                if (BSC4Midlet.virtual_y < 50 && BSC4Midlet.virtual_x < s_height / 2) {
                    s_instance.keyPressed(s_touchRectList[46]);
                    bl = true;
                }
                if (BSC4Midlet.virtual_y < 50 && BSC4Midlet.virtual_x > s_height / 2) {
                    s_instance.keyPressed(s_touchRectList[55]);
                    bl = true;
                }
                if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_up_y && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_up_x && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_up_y + BSC4Midlet.arrow_up_height && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_up_x + BSC4Midlet.arrow_up_width) {
                    s_instance.keyPressed(s_touchRectList[19]);
                    bl = true;
                }
                if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_down_y && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_down_x && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_down_y + BSC4Midlet.arrow_down_height && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_down_x + BSC4Midlet.arrow_down_width) {
                    s_instance.keyPressed(s_touchRectList[37]);
                    bl = true;
                }
            }
            for (n12 = 0; n12 < 20; ++n12) {
                if (BSC4Midlet.touchmenu_x[n12][0] < BSC4Midlet.virtual_x && BSC4Midlet.touchmenu_x[n12][0] + BSC4Midlet.touchmenu_width[n12][0] > BSC4Midlet.virtual_x && BSC4Midlet.touchmenu_y[n12][0] < BSC4Midlet.virtual_y && BSC4Midlet.touchmenu_y[n12][0] + BSC4Midlet.touchmenu_height[n12][0] > BSC4Midlet.virtual_y && !bl) {
                    bl = true;
                    BSC4Midlet.virtual_x = -1;
                    BSC4Midlet.virtual_y = -1;
                    if (BSC4Midlet.s_menuItemIndex != n12) {
                        BSC4Midlet.s_menuItemIndex = n12;
                    } else {
                        s_instance.keyPressed(s_touchRectList[28]);
                    }
                }
                BSC4Midlet.touchmenu_x[n12][0] = 0;
                BSC4Midlet.touchmenu_x[n12][0] = 0;
                BSC4Midlet.touchmenu_width[n12][0] = 0;
                BSC4Midlet.touchmenu_height[n12][0] = 0;
            }
            for (n12 = 0; n12 < 20; ++n12) {
                if (BSC4Midlet.touchmenu_x[n12][2] < BSC4Midlet.virtual_x && BSC4Midlet.touchmenu_x[n12][2] + BSC4Midlet.touchmenu_width[n12][2] > BSC4Midlet.virtual_x && BSC4Midlet.touchmenu_y[n12][2] < BSC4Midlet.virtual_y && BSC4Midlet.touchmenu_y[n12][2] + BSC4Midlet.touchmenu_height[n12][2] > BSC4Midlet.virtual_y && !bl) {
                    bl = true;
                    if (BSC4Midlet.s_menuItemIndex != n12) {
                        BSC4Midlet.s_menuItemIndex = n12;
                    }
                }
                BSC4Midlet.touchmenu_x[n12][2] = 0;
                BSC4Midlet.touchmenu_x[n12][2] = 0;
                BSC4Midlet.touchmenu_width[n12][2] = 0;
                BSC4Midlet.touchmenu_height[n12][2] = 0;
            }
            if (BSC4Midlet.touchmenu_x[BSC4Midlet.s_menuItemIndex][1] < BSC4Midlet.virtual_x && BSC4Midlet.touchmenu_x[BSC4Midlet.s_menuItemIndex][1] + BSC4Midlet.touchmenu_width[BSC4Midlet.s_menuItemIndex][1] > BSC4Midlet.virtual_x && BSC4Midlet.touchmenu_y[BSC4Midlet.s_menuItemIndex][1] < BSC4Midlet.virtual_y && BSC4Midlet.touchmenu_y[BSC4Midlet.s_menuItemIndex][1] + BSC4Midlet.touchmenu_height[BSC4Midlet.s_menuItemIndex][1] > BSC4Midlet.virtual_y && !bl) {
                if (BSC4Midlet.virtual_x < BSC4Midlet.touchmenu_x[BSC4Midlet.s_menuItemIndex][1] + 20) {
                    s_instance.keyPressed(s_touchRectList[46]);
                    s_instance.keyReleased(s_touchRectList[46]);
                } else if (BSC4Midlet.touchmenu_x[BSC4Midlet.s_menuItemIndex][1] + BSC4Midlet.touchmenu_width[BSC4Midlet.s_menuItemIndex][1] - 20 < BSC4Midlet.virtual_x) {
                    s_instance.keyPressed(s_touchRectList[55]);
                    s_instance.keyReleased(s_touchRectList[55]);
                }
                System.out.println("facem -1");
            }
        }
        if (BSC4Midlet.s_textboxCurrentState != -1) {
            if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_up_y_tut && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_up_x_tut && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_up_y_tut + BSC4Midlet.arrow_up_height_tut && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_up_x_tut + BSC4Midlet.arrow_up_width_tut) {
                s_instance.keyPressed(s_touchRectList[19]);
                bl = true;
                System.out.println("sus");
                System.out.println("x_cacat= " + BSC4Midlet.virtual_x + " y_cacat: " + BSC4Midlet.virtual_y);
            }
            if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_down_y_tut && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_down_x_tut && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_down_y_tut + BSC4Midlet.arrow_down_height_tut && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_down_x_tut + BSC4Midlet.arrow_down_width_tut) {
                s_instance.keyPressed(s_touchRectList[37]);
                bl = true;
            }
        }
        if (BSC4Midlet.s_menuScreen == 15) {
            if (BSC4Midlet.virtual_y < s_height / 2 && BSC4Midlet.virtual_x < s_width / 3) {
                s_instance.keyPressed(s_touchRectList[46]);
            }
            if (BSC4Midlet.virtual_y < s_height / 2 && BSC4Midlet.virtual_x > 2 * s_width / 3) {
                s_instance.keyPressed(s_touchRectList[55]);
            }
            if (BSC4Midlet.virtual_y > 2 * s_height / 3 && BSC4Midlet.virtual_y < s_height - 30) {
                s_instance.keyPressed(s_touchRectList[19]);
            }
        }
        if (BSC4Midlet.virtual_y < s_height / 4 && BSC4Midlet.virtual_x < 2 * s_width / 3 && BSC4Midlet.virtual_x > s_width / 3) {
            s_instance.keyPressed(s_touchRectList[100]);
        }
    }

    protected void pointerDragged(int n, int n2) {
    }

    protected void pointerReleased(int n, int n2) {
        n /= 2;
        n2 /= 2;
        if (BSC4Midlet.s_menuScreen == 6 || BSC4Midlet.s_menuScreen == 7 || BSC4Midlet.s_menuScreen == 8) {
            if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_up_y && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_up_x && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_up_y + BSC4Midlet.arrow_up_height && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_up_x + BSC4Midlet.arrow_up_width) {
                s_instance.keyReleased(s_touchRectList[19]);
                System.out.println("sus");
                System.out.println("x_cacat= " + BSC4Midlet.virtual_x + " y_cacat: " + BSC4Midlet.virtual_y);
            }
            if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_down_y && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_down_x && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_down_y + BSC4Midlet.arrow_down_height && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_down_x + BSC4Midlet.arrow_down_width) {
                s_instance.keyReleased(s_touchRectList[37]);
                System.out.println("jos");
                System.out.println("x_cacat= " + BSC4Midlet.virtual_x + " y_cacat: " + BSC4Midlet.virtual_y);
            }
            s_instance.keyReleased(s_touchRectList[19]);
            s_instance.keyReleased(s_touchRectList[37]);
        }
        if (BSC4Midlet.s_textboxCurrentState != -1) {
            if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_up_y_tut && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_up_x_tut && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_up_y_tut + BSC4Midlet.arrow_up_height_tut && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_up_x_tut + BSC4Midlet.arrow_up_width_tut) {
                s_instance.keyReleased(s_touchRectList[19]);
                System.out.println("sus");
                System.out.println("x_cacat= " + BSC4Midlet.virtual_x + " y_cacat: " + BSC4Midlet.virtual_y);
            }
            if (BSC4Midlet.virtual_y >= BSC4Midlet.arrow_down_y_tut && BSC4Midlet.virtual_x >= BSC4Midlet.arrow_down_x_tut && BSC4Midlet.virtual_y <= BSC4Midlet.arrow_down_y_tut + BSC4Midlet.arrow_down_height_tut && BSC4Midlet.virtual_x <= BSC4Midlet.arrow_down_x_tut + BSC4Midlet.arrow_down_width_tut) {
                s_instance.keyReleased(s_touchRectList[37]);
                System.out.println("jos");
                System.out.println("x_cacat= " + BSC4Midlet.virtual_x + " y_cacat: " + BSC4Midlet.virtual_y);
            }
        }
        BSC4Midlet.released = true;
        BSC4Midlet.virtualx_r = BSC4Midlet.virtual_x;
        BSC4Midlet.virtualy_r = BSC4Midlet.virtual_y;
        if (s_touchRectList != null) {
            for (int i = 0; i < s_touchRectList.length; i += 9) {
                if (s_touchRectList[i + 0] == 0 || s_touchRectList[i + 3] == 0 || s_touchRectList[i + 2] != 0) continue;
                s_instance.keyReleased(s_touchRectList[i + 1]);
                AALDevice.s_touchRectList[i + 3] = 0;
            }
        }
    }

    static {
        backbuffer = null;
        zoom = null;
        s_rgbImage = new int[57600];
        s_rgbScan2 = new int[720];
        s_rgbImage_l = new int[57600];
        s_rgbScan2_l = new int[1280];
        s_soundIsSoundEnabled = true;
        s_soundLevels = new int[32];
        s_soundContentTypes = new String[32];
        s_soundBuffers = new byte[32][];
        s_soundId = -1;
        s_vibrationEnabled = true;
        s_leftSoftkeyCommandIndex = -1;
        s_rightSoftkeyCommandIndex = -1;
        s_clearSoftkeyCommandIndex = -1;
        s_midleSoftkeyCommandIndex = -1;
        s_commandReceivedIndex = -1;
        s_commandReceivedIndexAsync = -1;
        s_rmsCache = new byte[2][];
        s_rmsStatus = 15;
        PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        PNG_CHUNK_IEND = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        PNG_CHUNK_tRNS = new byte[]{0, 0, 0, 1, 116, 82, 78, 83, 0, 64, -26, -40, 102};
        targetX_new = 0;
        targetY_new = 0;
    }
}

