/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.GameDefines;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.graphics.GFont;

public class Player {
    GFont fontBlack;
    GFont fontGold;
    GFont fontBlackBig;
    GFont fontGoldBig;
    String strName;
    String strAction;
    int id;
    int x;
    int y;
    int orientation;
    int betX;
    int betY;
    int cardWidth;
    int cardHeight;
    int cardPlaceholderWidth;
    int cardPlaceholderHeight;
    int cardSpace;
    int profileWidth;
    int profileHeight;
    int userShiftY = 0;
    int contextArrowsY;
    int contextArrowsX1;
    int contextArrowsX2;
    boolean bShowSelector = true;
    boolean bDarkenLabel = false;
    Image imgCardPlaceholder;
    Image imgBoxBig;
    Image imgBoxBigSelected;
    Image imgBoxLong;
    Image imgBoxLongSelected;
    Image imgPlayerBoxSelector;
    Image imgBoxShort;
    Image imgBoxShortSelected;
    Image imgFace;
    Image imgFaceSelector;
    Image imgBoxSlimSelected;
    Sprite sprArrows;
    Sprite sprArrowsInactive;
    Sprite sprChips;
    String strRaise = Resources.resTexts[0].getHashedString(54);
    String strBet = Resources.resTexts[0].getHashedString(52);
    String strCall = Resources.resTexts[0].getHashedString(53);

    public Player(int id, byte playersFace, int x, int y, int orientation, int betX, int betY) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.orientation = orientation;
        this.betX = betX;
        this.betY = betY;
        this.fontBlack = Resources.resGFonts[0];
        this.fontGold = Resources.resGFonts[1];
        this.fontBlackBig = Resources.resGFonts[2];
        this.fontGoldBig = Resources.resGFonts[3];
        Resources.loadSprite(5);
        this.cardWidth = Resources.resSprs[5].getWidth();
        this.cardHeight = Resources.resSprs[5].getHeight();
        Resources.loadImage(17);
        this.cardPlaceholderWidth = Resources.resImgs[17].getWidth();
        this.cardPlaceholderHeight = Resources.resImgs[17].getHeight();
        Resources.loadImage(17);
        this.imgCardPlaceholder = Resources.resImgs[17];
        if (id == 0) {
            Resources.loadImages(new int[]{10, 11, 6, 7, 28});
            this.imgBoxBig = Resources.resImgs[10];
            this.imgBoxBigSelected = Resources.resImgs[11];
            this.imgBoxLong = Resources.resImgs[6];
            this.imgBoxLongSelected = Resources.resImgs[7];
            this.imgPlayerBoxSelector = Resources.resImgs[28];
            Resources.loadSprites(new int[]{3, 4, 6});
            this.sprArrows = Resources.resSprs[3];
            this.sprArrowsInactive = Resources.resSprs[4];
            this.sprChips = Resources.resSprs[6];
            this.strName = Resources.resTexts[0].getHashedString(33);
        } else {
            Resources.loadImages(new int[]{8, 9, 27});
            this.imgBoxShort = Resources.resImgs[8];
            this.imgBoxShortSelected = Resources.resImgs[9];
            this.imgFaceSelector = Resources.resImgs[27];
            switch (playersFace) {
                case 0: {
                    Resources.loadImage(19);
                    this.imgFace = Resources.resImgs[19];
                    break;
                }
                case 1: {
                    Resources.loadImage(20);
                    this.imgFace = Resources.resImgs[20];
                    break;
                }
                case 2: {
                    Resources.loadImage(21);
                    this.imgFace = Resources.resImgs[21];
                    break;
                }
                case 3: {
                    Resources.loadImage(22);
                    this.imgFace = Resources.resImgs[22];
                    break;
                }
                case 4: {
                    Resources.loadImage(23);
                    this.imgFace = Resources.resImgs[23];
                    break;
                }
                case 5: {
                    Resources.loadImage(24);
                    this.imgFace = Resources.resImgs[24];
                    break;
                }
                case 6: {
                    Resources.loadImage(25);
                    this.imgFace = Resources.resImgs[25];
                    break;
                }
                case 7: {
                    Resources.loadImage(26);
                    this.imgFace = Resources.resImgs[26];
                    break;
                }
            }
            this.strName = GameDefines.STR_FACE[playersFace];
        }
        Resources.loadImages(new int[]{13});
        this.imgBoxSlimSelected = Resources.resImgs[13];
        this.cardSpace = this.cardWidth >> 4;
        if (this.cardSpace < 1) {
            this.cardSpace = 1;
        }
        if (id == 0) {
            this.profileWidth = this.imgBoxLong.getWidth();
            this.profileHeight = this.imgBoxLong.getHeight() + this.cardSpace + this.cardPlaceholderHeight;
            this.contextArrowsY = this.getLabelLongY() + (this.imgBoxLong.getHeight() >> 1) - (this.sprArrows.getHeight() >> 1) - this.userShiftY;
            this.contextArrowsX1 = this.getLabelLongX();
            this.contextArrowsX2 = this.getLabelLongX() + this.imgBoxLong.getWidth() - this.sprArrows.getWidth();
        } else {
            this.profileWidth = this.imgFace.getWidth() + (this.cardSpace << 1) + (this.cardPlaceholderWidth << 1);
            this.profileHeight = this.imgBoxShort.getHeight() + this.cardSpace + this.cardPlaceholderHeight;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.profileWidth;
    }

    public int getHeight() {
        return this.profileHeight;
    }

    public int getRight() {
        return this.x + this.profileWidth;
    }

    public int getLeft() {
        return this.x;
    }

    public int getCenterX() {
        return this.x + (this.profileWidth >> 1);
    }

    public int getCenterY() {
        return this.y + (this.profileHeight >> 1);
    }

    public int getTop() {
        return this.y;
    }

    public int getBottom() {
        return this.y + this.profileHeight;
    }

    public int getCard1X() {
        if (this.id == 0) {
            int pomWidth = (this.cardPlaceholderWidth << 1) + (this.cardSpace << 1) + this.imgBoxBig.getWidth();
            return this.x + (this.profileWidth >> 1) - (pomWidth >> 1) + (this.cardPlaceholderWidth >> 1) - (this.cardWidth >> 1);
        }
        if (this.orientation == 0) {
            return this.x + this.imgFace.getWidth() + this.cardSpace + (this.cardPlaceholderWidth >> 1) - (this.cardWidth >> 1);
        }
        return this.x + (this.cardPlaceholderWidth >> 1) - (this.cardWidth >> 1);
    }

    public int getCard2X() {
        if (this.id == 0) {
            int pomWidth = (this.cardPlaceholderWidth << 1) + (this.cardSpace << 1) + this.imgBoxBig.getWidth();
            return this.x + (this.profileWidth >> 1) - (pomWidth >> 1) + this.cardPlaceholderWidth + this.cardSpace + (this.cardPlaceholderWidth >> 1) - (this.cardWidth >> 1);
        }
        if (this.orientation == 0) {
            return this.x + this.imgFace.getWidth() + (this.cardSpace << 1) + this.cardPlaceholderWidth + (this.cardPlaceholderWidth >> 1) - (this.cardWidth >> 1);
        }
        return this.x + this.cardPlaceholderWidth + this.cardSpace + (this.cardPlaceholderWidth >> 1) - (this.cardWidth >> 1);
    }

    public int getCardY() {
        return this.y + (this.cardPlaceholderHeight >> 1) - (this.cardHeight >> 1);
    }

    public int getFaceX() {
        if (this.orientation == 0) {
            return this.x;
        }
        return this.x + this.profileWidth - this.imgFace.getWidth();
    }

    public int getFaceY() {
        return this.y + (this.profileHeight >> 1) - (this.imgFace.getHeight() >> 1);
    }

    public int getFaceWidth() {
        return this.imgFace.getWidth();
    }

    public int getFaceHeight() {
        return this.imgFace.getHeight();
    }

    public int getLabelX() {
        if (this.orientation == 0) {
            return this.x + this.profileWidth - this.imgBoxShort.getWidth();
        }
        return this.x;
    }

    public int getLabelY() {
        return this.y + this.profileHeight - this.imgBoxShort.getHeight();
    }

    public int getLabelBigX() {
        int pomWidth = (this.cardPlaceholderWidth << 1) + (this.cardSpace << 1) + this.imgBoxBig.getWidth();
        return this.x + (this.profileWidth >> 1) + (pomWidth >> 1) - this.imgBoxBig.getWidth();
    }

    public int getLabelBigY() {
        return this.y + this.cardPlaceholderHeight - this.imgBoxBig.getHeight();
    }

    public int getLabelBigRight() {
        int pomWidth = (this.cardPlaceholderWidth << 1) + (this.cardSpace << 1) + this.imgBoxBig.getWidth();
        return this.x + (this.profileWidth >> 1) + (pomWidth >> 1);
    }

    public int getLabelLongX() {
        return this.x;
    }

    public int getLabelLongY() {
        return this.y + this.profileHeight - this.imgBoxLong.getHeight();
    }

    public int getChipCenterX() {
        if (this.id == 0) {
            return this.getLabelBigX() + (this.sprChips.getWidth() >> 1);
        }
        if (this.orientation == 0) {
            return this.getFaceX() + (this.getLabelX() - this.getFaceX() >> 1);
        }
        return this.getLabelX() + this.imgBoxShort.getWidth() + (this.getFaceX() + this.imgFace.getWidth() - (this.getLabelX() + this.imgBoxShort.getWidth()) >> 1);
    }

    public int getChipCenterY() {
        if (this.id == 0) {
            return this.getLabelBigY() - (this.sprChips.getHeight() >> 2);
        }
        return this.getFaceY() + this.imgFace.getHeight();
    }

    public int getChipsValueX() {
        if (this.id == 0) {
            return this.getLabelBigX() + (this.imgBoxBig.getWidth() - this.imgBoxSlimSelected.getWidth() >> 1);
        }
        return this.getLabelX() + (this.imgBoxShort.getWidth() - this.imgBoxSlimSelected.getWidth() >> 1);
    }

    public int getChipsValueY() {
        if (this.id == 0) {
            return this.getLabelBigY() + (this.imgBoxBig.getHeight() - this.imgBoxSlimSelected.getHeight() >> 1);
        }
        return this.getLabelY() + (this.imgBoxShort.getHeight() - this.imgBoxSlimSelected.getHeight() >> 1);
    }

    public int getBetX() {
        return this.betX;
    }

    public int getBetY() {
        return this.betY;
    }

    public void setUserShiftY(int shiftY) {
        if (this.id == 0) {
            this.userShiftY = shiftY;
        }
    }

    public int getContextArrowsX(int type) {
        if (type == 0) {
            return this.contextArrowsX1;
        }
        return this.contextArrowsX2;
    }

    public int getContextArrowsY() {
        return this.contextArrowsY - this.userShiftY;
    }

    public void setShowSelector(boolean bShow) {
        this.bShowSelector = bShow;
    }

    public void setDarkenLabel(boolean bDarken) {
        this.bDarkenLabel = bDarken;
    }

    public void paintUser(Graphics g, int chips, boolean bPlayersTurn, String action, String pomAction, int pomRaiseValue, boolean bWin, int pomCallValue) {
        this.paintCardPlaceholders(g);
        this.paintLabelBig(g, chips, bPlayersTurn, action, bWin);
        this.paintLabelLong(g, pomAction, pomRaiseValue, pomCallValue);
    }

    public void paintRival(Graphics g, int chips, boolean bPlayersTurn, String action, boolean bWin) {
        this.paintFace(g, bPlayersTurn);
        this.paintCardPlaceholders(g);
        this.paintLabel(g, chips, action, bWin);
    }

    private void paintCardPlaceholders(Graphics g) {
        int x1 = this.getCard1X() + (this.cardWidth >> 1) - (this.imgCardPlaceholder.getWidth() >> 1);
        int x2 = this.getCard2X() + (this.cardWidth >> 1) - (this.imgCardPlaceholder.getWidth() >> 1);
        int y1 = this.getCardY() + (this.cardHeight >> 1) - (this.imgCardPlaceholder.getHeight() >> 1);
        int y2 = this.getCardY() + (this.cardHeight >> 1) - (this.imgCardPlaceholder.getHeight() >> 1);
        if (this.id != 0 && (MainCanvas.HEIGHT <= 320 || this.isSmallAspectRatio())) {
            ++y1;
            ++y2;
        }
        g.drawImage(this.imgCardPlaceholder, x1, y1 - this.userShiftY, 20);
        g.drawImage(this.imgCardPlaceholder, x2, y2 - this.userShiftY, 20);
    }

    private void paintFace(Graphics g, boolean bPlayersTurn) {
        g.drawImage(this.imgFace, this.getFaceX(), this.getFaceY(), 20);
        if (bPlayersTurn) {
            g.drawImage(this.imgFaceSelector, this.getFaceX(), this.getFaceY(), 20);
        }
    }

    private void paintLabel(Graphics g, int chips, String action, boolean bWin) {
        if (action.compareTo("") == 0) {
            if (bWin) {
                g.drawImage(this.imgBoxShortSelected, this.getLabelX(), this.getLabelY(), 20);
            } else {
                g.drawImage(this.imgBoxShort, this.getLabelX(), this.getLabelY(), 20);
            }
            int height = this.fontGold.getHeight() + this.fontGoldBig.getHeight() - (this.fontGold.getHeight() >> 2) - (this.fontGold.getHeight() >> 3);
            if (MainCanvas.HEIGHT < 320) {
                height += this.fontGold.getHeight() >> 3;
            }
            int stringWidth = this.fontGold.stringWidth(this.strName.toCharArray());
            int x = this.getLabelX() + (this.imgBoxShort.getWidth() >> 1) - (stringWidth >> 1);
            int y = this.getLabelY() + (this.imgBoxShort.getHeight() >> 1) - (height >> 1);
            if (MainCanvas.HEIGHT < 320) {
                --y;
            }
            if (bWin) {
                this.fontBlack.drawString(g, this.strName.toCharArray(), x, y, 20);
            } else {
                this.fontGold.drawString(g, this.strName.toCharArray(), x, y, 20);
            }
            stringWidth = this.fontGoldBig.stringWidth((chips + "").toCharArray());
            x = this.getLabelX() + (this.imgBoxShort.getWidth() >> 1) - (stringWidth >> 1);
            y = this.getLabelY() + (this.imgBoxShort.getHeight() >> 1) + (height >> 1) - this.fontGoldBig.getHeight();
            if (MainCanvas.HEIGHT >= 320) {
                ++y;
            }
            if (bWin) {
                this.fontBlackBig.drawString(g, (chips + "").toCharArray(), x, y, 20);
            } else {
                this.fontGoldBig.drawString(g, (chips + "").toCharArray(), x, y, 20);
            }
        } else {
            if (this.bDarkenLabel) {
                g.drawImage(this.imgBoxShort, this.getLabelX(), this.getLabelY(), 20);
            } else {
                g.drawImage(this.imgBoxShortSelected, this.getLabelX(), this.getLabelY(), 20);
            }
            int height = this.fontBlackBig.getHeight() + this.fontBlack.getHeight() - (this.fontBlack.getHeight() >> 1);
            int stringWidth = this.fontBlackBig.stringWidth(action.toCharArray());
            int x = this.getLabelX() + (this.imgBoxShortSelected.getWidth() >> 1) - (stringWidth >> 1);
            int y = this.getLabelY() + (this.imgBoxShortSelected.getHeight() >> 1) - (height >> 1) - (this.fontBlack.getHeight() >> 2);
            this.fontBlackBig.drawString(g, action.toCharArray(), x, y, 20);
            stringWidth = this.fontBlack.stringWidth((chips + "").toCharArray());
            x = this.getLabelX() + (this.imgBoxShortSelected.getWidth() >> 1) - (stringWidth >> 1);
            y = this.getLabelY() + (this.imgBoxShortSelected.getHeight() >> 1) + (height >> 1) - this.fontBlack.getHeight();
            if (MainCanvas.HEIGHT < 320) {
                ++y;
            } else if (MainCanvas.HEIGHT >= 320) {
                --y;
            }
            this.fontBlack.drawString(g, (chips + "").toCharArray(), x, y, 20);
        }
    }

    public void paintLabelBig(Graphics g, int chips, boolean bPlayersTurn, String action, boolean bWin) {
        if (action.compareTo("") == 0) {
            if (bWin) {
                g.drawImage(this.imgBoxBigSelected, this.getLabelBigX(), this.getLabelBigY() - this.userShiftY, 20);
            } else {
                g.drawImage(this.imgBoxBig, this.getLabelBigX(), this.getLabelBigY() - this.userShiftY, 20);
            }
            int space = (this.imgBoxBig.getHeight() - this.fontGold.getHeight() - this.fontGoldBig.getHeight()) / 3;
            if (space < 1) {
                space = 1;
            }
            int height = this.fontGold.getHeight() + this.fontGoldBig.getHeight() + space;
            int stringWidth = this.fontGold.stringWidth(this.strName.toCharArray());
            int x = this.getLabelBigX() + (this.imgBoxBig.getWidth() >> 1) - (stringWidth >> 1);
            int y = this.getLabelBigY() + (this.imgBoxBig.getHeight() >> 1) - (height >> 1);
            if (bWin) {
                this.fontBlack.drawString(g, this.strName.toCharArray(), x, y - this.userShiftY, 20);
            } else {
                this.fontGold.drawString(g, this.strName.toCharArray(), x, y - this.userShiftY, 20);
            }
            stringWidth = this.fontGoldBig.stringWidth((chips + "").toCharArray());
            x = this.getLabelBigX() + (this.imgBoxBig.getWidth() >> 1) - (stringWidth >> 1);
            y = this.getLabelBigY() + (this.imgBoxBig.getHeight() >> 1) + (height >> 1) - this.fontGoldBig.getHeight();
            if (bWin) {
                this.fontBlackBig.drawString(g, (chips + "").toCharArray(), x, y - this.userShiftY, 20);
            } else {
                this.fontGoldBig.drawString(g, (chips + "").toCharArray(), x, y - this.userShiftY, 20);
            }
            if (bPlayersTurn && this.bShowSelector) {
                g.drawImage(this.imgPlayerBoxSelector, this.getLabelBigX(), this.getLabelBigY() - this.userShiftY, 20);
            }
        } else {
            if (this.bDarkenLabel) {
                g.drawImage(this.imgBoxBig, this.getLabelBigX(), this.getLabelBigY() - this.userShiftY, 20);
            } else {
                g.drawImage(this.imgBoxBigSelected, this.getLabelBigX(), this.getLabelBigY() - this.userShiftY, 20);
            }
            int space = (this.imgBoxBigSelected.getHeight() - this.fontBlackBig.getHeight() - this.fontBlack.getHeight()) / 3;
            if (space < 1) {
                space = 1;
            }
            int height = this.fontBlackBig.getHeight() + this.fontBlack.getHeight() + space;
            int stringWidth = this.fontBlackBig.stringWidth(action.toCharArray());
            int x = this.getLabelBigX() + (this.imgBoxBigSelected.getWidth() >> 1) - (stringWidth >> 1);
            int y = this.getLabelBigY() + (this.imgBoxBigSelected.getHeight() >> 1) - (height >> 1);
            this.fontBlackBig.drawString(g, action.toCharArray(), x, y - this.userShiftY, 20);
            stringWidth = this.fontBlack.stringWidth((chips + "").toCharArray());
            x = this.getLabelBigX() + (this.imgBoxBigSelected.getWidth() >> 1) - (stringWidth >> 1);
            y = this.getLabelBigY() + (this.imgBoxBigSelected.getHeight() >> 1) + (height >> 1) - this.fontBlack.getHeight();
            this.fontBlack.drawString(g, (chips + "").toCharArray(), x, y - this.userShiftY, 20);
        }
    }

    public void paintLabelLong(Graphics g, String action, int raiseValue, int callValue) {
        g.drawImage(this.imgBoxLong, this.getLabelLongX(), this.getLabelLongY() - this.userShiftY, 20);
        int pomShiftY = 0;
        if (MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640) {
            pomShiftY = this.fontGoldBig.getHeight() - this.fontGold.getHeight() >> 1;
        }
        int width = this.imgBoxLong.getWidth() - (this.sprArrows.getWidth() << 1) - (this.sprArrows.getWidth() >> 1);
        if (pomShiftY <= 0) {
            width += this.sprArrows.getWidth() >> 2;
        }
        int height = this.fontGoldBig.getHeight();
        int y = this.getLabelLongY() + (this.imgBoxLong.getHeight() >> 1) - (height >> 1);
        if (action.compareTo(this.strRaise) == 0 || action.compareTo(this.strBet) == 0 || action.compareTo(this.strCall) == 0) {
            int x = this.getLabelLongX() + (this.imgBoxLong.getWidth() >> 1) - (width >> 1);
            if (pomShiftY > 0) {
                this.fontGold.drawString(g, action.toCharArray(), x, y - this.userShiftY + pomShiftY, 20);
            } else {
                this.fontGoldBig.drawString(g, action.toCharArray(), x, y - this.userShiftY, 20);
            }
            x = this.getLabelLongX() + (this.imgBoxLong.getWidth() >> 1) + (width >> 1);
            if (action.compareTo(this.strCall) == 0) {
                if (pomShiftY > 0) {
                    this.fontGold.drawString(g, (callValue + "").toCharArray(), x, y - this.userShiftY + pomShiftY, 24);
                } else {
                    this.fontGoldBig.drawString(g, (callValue + "").toCharArray(), x, y - this.userShiftY, 24);
                }
            } else if (pomShiftY > 0) {
                this.fontGold.drawString(g, (raiseValue + "").toCharArray(), x, y - this.userShiftY + pomShiftY, 24);
            } else {
                this.fontGoldBig.drawString(g, (raiseValue + "").toCharArray(), x, y - this.userShiftY, 24);
            }
        } else {
            int stringWidth = 0;
            stringWidth = pomShiftY > 0 ? this.fontGold.stringWidth(action.toCharArray()) : this.fontGoldBig.stringWidth(action.toCharArray());
            int x = this.getLabelLongX() + (this.imgBoxLong.getWidth() >> 1) - (stringWidth >> 1);
            if (pomShiftY > 0) {
                this.fontGold.drawString(g, action.toCharArray(), x, y - this.userShiftY + pomShiftY, 20);
            } else {
                this.fontGoldBig.drawString(g, action.toCharArray(), x, y - this.userShiftY, 20);
            }
        }
        this.sprArrows.setFrame(2);
        this.sprArrows.setPosition(this.contextArrowsX1, this.contextArrowsY - this.userShiftY);
        this.sprArrows.paint(g);
        this.sprArrows.setFrame(3);
        this.sprArrows.setPosition(this.contextArrowsX2, this.contextArrowsY - this.userShiftY);
        this.sprArrows.paint(g);
    }

    public void paintRaiseArrow(Graphics g, int type, boolean bActive, int x, int y) {
        if (bActive) {
            if (type == 0) {
                this.sprArrows.setFrame(0);
            } else {
                this.sprArrows.setFrame(1);
            }
            this.sprArrows.setPosition(x, y);
            this.sprArrows.paint(g);
        } else {
            if (type == 0) {
                this.sprArrowsInactive.setFrame(0);
            } else {
                this.sprArrowsInactive.setFrame(1);
            }
            this.sprArrowsInactive.setPosition(x, y);
            this.sprArrowsInactive.paint(g);
        }
    }

    public boolean isSmallAspectRatio() {
        return MainCanvas.WIDTH * 100 / MainCanvas.HEIGHT >= 75;
    }
}

