/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.SavedGame;
import sk.inlogic.Scores;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    MainCanvas mainCanvas;
    GFont fontBlack;
    GFont fontGold;
    GFont fontBlackBig;
    GFont fontGoldBig;
    Profile pProfile;
    static final byte SCREEN_MAIN_MENU = 0;
    static final byte SCREEN_PROFILE = 1;
    static final byte SCREEN_RESET = 2;
    static final byte SCREEN_INSTRUCTIONS = 3;
    static final byte SCREEN_ABOUT = 4;
    static final byte SCREEN_MORE_GAMES = 5;
    static final byte SCREEN_QUIT = 6;
    static final byte SCREEN_CONTINUE = 8;
    static final byte SCREEN_NEW_GAME = 9;
    static final byte SCREEN_GAME = 10;
    final byte ID_PLAY;
    final byte ID_PROFILE;
    final byte ID_RESET = (byte)2;
    final byte ID_INSTRUCTIONS = (byte)3;
    final byte ID_ABOUT = (byte)4;
    final byte ID_MORE_GAMES = (byte)5;
    final byte TOTAL_MAIN_MENU = (byte)6;
    final byte ID_CONTINUE;
    final byte ID_NEW_GAME;
    final byte TOTAL_CONTINUE = (byte)2;
    Rectangle rectBtn;
    Rectangle rectInfo;
    Rectangle rectDialog;
    Rectangle[] rectMenu;
    Rectangle[] rectContinue;
    Rectangle[] rectSettings;
    Rectangle[] rectControls;
    Rectangle[] rectArrowsDialog;
    Rectangle[] rectArrowsInstructions;
    PreparedText preparedTextInfo;
    PreparedText preparedTextInfoBig;
    Image imgBg;
    Image imgLogoMenu;
    Image imgLogoInlogic;
    Image imgBoxLong;
    Image imgBoxLongSelected;
    Sprite sprIcons;
    Sprite sprIconsAchievs;
    Sprite sprArrows;
    Sprite sprArrowsInactive;
    Sprite sprDialog;
    String link;
    String buysetup;
    public static String[] STR_MAIN_MENU;
    public static String[] STR_CONTINUE;
    public static String[] STR_COMBINATION;
    int screen = 0;
    int selectedItem = 0;
    int iProfileSite = 0;
    int iBookedSpaceY = 0;
    int iLogoY = 0;
    int nextScreenStep = 0;
    int nextScreen = 0;
    int nextSelectedItem = 0;
    int iAboutHeight = 0;
    int controlsBarHeight = 0;
    private int iTotalMainMenu = 0;
    private int loadingCounter = 0;
    boolean isLoading;
    boolean bChangeSound = false;
    final int LIMIT_HEIGHT;

    public ScreenMenu(MainCanvas mainCanvas) {
        this.ID_PLAY = 0;
        this.ID_PROFILE = 1;
        this.ID_CONTINUE = 0;
        this.ID_NEW_GAME = 1;
        this.LIMIT_HEIGHT = 224;
        System.out.println("\n \nSCREEN MENU");
        this.mainCanvas = mainCanvas;
        this.screen = 0;
        this.selectedItem = 0;
        this.loadBMG();
        Scores.load();
    }

    public void update(long lastRunLenght) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (!this.isLoading && this.loadingCounter == 0) {
            this.updateNextScreen();
            if (this.screen == 3) {
                this.updateText();
            }
            this.mainCanvas.repaint();
        }
    }

    public void updateNextScreen() {
        if (this.nextScreenStep > 0) {
            --this.nextScreenStep;
            if (this.nextScreenStep <= 0) {
                this.nextScreenStep = 0;
                this.screen = this.nextScreen;
                this.selectedItem = this.nextSelectedItem;
                if (this.screen == 10) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas));
                    this.mainCanvas.repaint();
                } else {
                    this.calculatePositions();
                }
            }
        }
    }

    public void nextScreen(int nextScreen, int nextSelectedItem) {
        this.nextScreen = nextScreen;
        this.nextSelectedItem = nextSelectedItem;
        this.nextScreenStep = 3;
    }

    public void calculatePositions() {
        if (this.screen == 1 || this.screen == 3 || this.screen == 4 || this.screen == 2 || this.screen == 6 || this.screen == 5 || this.screen == 9) {
            int iY;
            int iHeight;
            if (this.screen == 1 || this.screen == 3) {
                int iY2 = this.iBookedSpaceY;
                if (MainCanvas.HEIGHT <= 224) {
                    iY2 = this.iBookedSpaceY >> 2;
                }
                iHeight = MainCanvas.HEIGHT - iY2 - this.controlsBarHeight - (this.sprIcons.getHeight() >> 2);
                if (MainCanvas.HEIGHT < 260) {
                    iHeight = MainCanvas.HEIGHT - iY2 - this.controlsBarHeight - (this.sprIcons.getHeight() >> 4);
                }
                iHeight += this.fontGold.getHeight();
                if (MainCanvas.HEIGHT <= 224) {
                    iHeight -= this.controlsBarHeight >> 1;
                }
                if (this.screen == 3 && MainCanvas.HEIGHT >= 287 && MainCanvas.HEIGHT <= 307) {
                    iHeight -= this.controlsBarHeight >> 2;
                    iY2 += this.controlsBarHeight >> 4;
                }
                int iWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 5);
                if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
                    iWidth = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 5);
                }
                int iX = (MainCanvas.WIDTH >> 1) - (iWidth >> 1);
                if (this.screen == 1) {
                    if (MainCanvas.HEIGHT <= 224) {
                        iHeight = this.fontGoldBig.getHeight() * 18;
                        int iCenterY = (this.iBookedSpaceY >> 2) + (iHeight >> 1);
                        if (MainCanvas.HEIGHT < 200) {
                            iHeight = this.fontGoldBig.getHeight() * 16;
                            iCenterY = (this.iBookedSpaceY >> 3) + (iHeight >> 1);
                        }
                        iY2 = iCenterY - (iHeight >> 1);
                    } else if (iHeight > (this.fontGoldBig.getHeight() << 2) + this.fontGold.getHeight() * 14) {
                        int iCenterY = this.iBookedSpaceY + (iHeight >> 1);
                        iHeight = (this.fontGoldBig.getHeight() << 2) + this.fontGold.getHeight() * 14;
                        iY2 = iCenterY - (iHeight >> 1);
                    }
                }
                this.rectDialog = new Rectangle(iX, iY2, iWidth, iHeight);
                if (this.screen == 3) {
                    iHeight -= (this.sprArrows.getHeight() << 1) + this.sprArrows.getHeight() - (this.sprArrows.getHeight() >> 2);
                }
                iWidth = this.rectDialog.width - (this.rectDialog.width >> 4);
                if (this.screen == 1) {
                    iWidth -= this.sprArrows.getWidth() * 3;
                }
                iX = this.rectDialog.getCenterX() - (iWidth >> 1);
                iY2 = this.rectDialog.getCenterY() - (iHeight >> 1);
                this.rectInfo = new Rectangle(iX, iY2, iWidth, iHeight);
            } else if (this.screen == 4) {
                int iY3;
                this.iAboutHeight = this.imgLogoInlogic.getHeight() + this.fontBlackBig.getHeight() * 3;
                int iMaxHeight = MainCanvas.HEIGHT - this.iBookedSpaceY - this.controlsBarHeight - this.fontBlackBig.getHeight() * 3;
                iHeight = this.iAboutHeight + this.fontBlackBig.getHeight() + (this.fontBlackBig.getHeight() >> 1);
                if (iHeight < iMaxHeight) {
                    iHeight += this.fontBlackBig.getHeight();
                }
                if ((iY3 = this.iBookedSpaceY + (MainCanvas.HEIGHT - this.iBookedSpaceY - this.controlsBarHeight >> 1) - (iHeight >> 1)) < this.iBookedSpaceY) {
                    iY3 = this.iBookedSpaceY;
                }
                int iWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 3);
                if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
                    iWidth = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 3);
                }
                int iX = (MainCanvas.WIDTH >> 1) - (iWidth >> 1);
                this.rectDialog = new Rectangle(iX, iY3, iWidth, iHeight);
                iHeight = this.fontBlackBig.getHeight() << 1;
                iWidth = this.rectDialog.width - (this.rectDialog.width >> 4);
                iX = this.rectDialog.getCenterX() - (iWidth >> 1);
                iY3 = this.rectDialog.getCenterY() + (this.iAboutHeight >> 1) - iHeight;
                this.rectInfo = new Rectangle(iX, iY3, iWidth, iHeight);
            } else if (this.screen == 2 || this.screen == 6 || this.screen == 5 || this.screen == 9) {
                int iHeight2 = MainCanvas.HEIGHT - this.iBookedSpaceY - this.sprIcons.getHeight() - (this.sprIcons.getHeight() >> 1);
                iY = this.iBookedSpaceY + (iHeight2 >> 2);
                int iWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 3);
                if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
                    iWidth = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 3);
                }
                int iX = (MainCanvas.WIDTH >> 1) - (iWidth >> 1);
                this.rectDialog = new Rectangle(iX, iY, iWidth, iHeight2);
                iWidth = this.rectDialog.width - (this.rectDialog.width >> 4);
                iX = this.rectDialog.getCenterX() - (iWidth >> 1);
                iY = this.rectDialog.getCenterY() - (iHeight2 >> 1);
                this.rectInfo = new Rectangle(iX, iY, iWidth, iHeight2);
            }
            String str = "";
            switch (this.screen) {
                case 1: {
                    if (this.pProfile == null) {
                        this.pProfile = new Profile(this.fontGold, this.fontGoldBig, STR_COMBINATION);
                    }
                    this.pProfile.initSite();
                    break;
                }
                case 3: {
                    str = Resources.resTexts[0].getHashedString(45) + "\n\n\n";
                    str = str + Resources.resTexts[0].getHashedString(47);
                    str = str + "\n\n\n" + Resources.resTexts[0].getHashedString(48);
                    break;
                }
                case 4: {
                    str = X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + "\n" + Resources.resTexts[0].getHashedString(10) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                    break;
                }
                case 2: {
                    str = Resources.resTexts[0].getHashedString(22);
                    break;
                }
                case 6: {
                    str = Resources.resTexts[0].getHashedString(4);
                    break;
                }
                case 5: {
                    str = Resources.resTexts[0].getHashedString(28);
                    break;
                }
                case 9: {
                    str = Resources.resTexts[0].getHashedString(25);
                    break;
                }
            }
            if (str != null) {
                if (this.screen == 4 || this.screen == 2 || this.screen == 6 || this.screen == 5 || this.screen == 9) {
                    this.preparedTextInfoBig.setTextOffsetY(0);
                    this.preparedTextInfoBig.prepareText(str, this.rectInfo.width);
                } else {
                    this.preparedTextInfo.setTextOffsetY(0);
                    this.preparedTextInfo.prepareText(str, this.rectInfo.width);
                }
            }
            if (this.screen == 2 || this.screen == 6 || this.screen == 5 || this.screen == 9) {
                this.rectDialog.height = this.preparedTextInfoBig.getTextHeight() + (this.fontBlackBig.getHeight() << 1);
                this.rectInfo.height = this.preparedTextInfoBig.getTextHeight();
            } else if (this.screen == 1) {
                iY = this.rectInfo.getCenterY() - (this.sprArrows.getHeight() >> 1);
                if (this.rectArrowsDialog == null) {
                    this.rectArrowsDialog = new Rectangle[2];
                }
                this.rectArrowsDialog[0] = new Rectangle(this.rectInfo.x - this.sprArrows.getWidth() - (this.sprArrows.getWidth() >> 1) + (this.sprArrows.getWidth() >> 3), iY, this.sprArrows.getWidth(), this.sprArrows.getHeight());
                this.rectArrowsDialog[1] = new Rectangle(this.rectInfo.getRight() + (this.sprArrows.getWidth() >> 1) - (this.sprArrows.getWidth() >> 3), iY, this.sprArrows.getWidth(), this.sprArrows.getHeight());
                this.pProfile.set(this.rectDialog, this.rectInfo, this.rectArrowsDialog, this.preparedTextInfo);
            } else if (this.screen == 3) {
                int iX = this.rectDialog.getCenterX() - (this.sprArrows.getWidth() >> 1);
                if (this.rectArrowsInstructions == null) {
                    this.rectArrowsInstructions = new Rectangle[2];
                }
                this.rectArrowsInstructions[0] = new Rectangle(iX, this.rectInfo.y - this.sprArrows.getHeight() - (this.sprArrows.getHeight() >> 3), this.sprArrows.getWidth(), this.sprArrows.getHeight());
                this.rectArrowsInstructions[1] = new Rectangle(iX, this.rectInfo.getBottom() + (this.sprArrows.getHeight() >> 3) + 1, this.sprArrows.getWidth(), this.sprArrows.getHeight());
            }
        }
    }

    public void paint(Graphics g) {
        this.paintBg(g);
        this.paintControls(g);
        switch (this.screen) {
            case 0: 
            case 8: {
                this.paintLogo(g);
                this.paintMenu(g);
                break;
            }
            case 1: {
                if (MainCanvas.HEIGHT > 224) {
                    this.paintLogo(g);
                }
                this.paintProfile(g);
                break;
            }
            case 3: {
                if (MainCanvas.HEIGHT > 224) {
                    this.paintLogo(g);
                }
                this.paintInstructions(g);
                break;
            }
            case 4: {
                this.paintLogo(g);
                this.paintAbout(g);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                this.paintLogo(g);
                this.paintQuestion(g);
                break;
            }
        }
    }

    public void paintBg(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(this.imgBg, MainCanvas.WIDTH >> 1, 0, 17);
    }

    public void paintLogo(Graphics g) {
        g.drawImage(this.imgLogoMenu, MainCanvas.WIDTH >> 1, this.iLogoY, 17);
    }

    public void paintMenu(Graphics g) {
        int total = 0;
        switch (this.screen) {
            case 0: {
                total = this.iTotalMainMenu;
                break;
            }
            case 8: {
                total = 2;
                break;
            }
        }
        boolean bSelected = false;
        block12: for (int i = 0; i < total; ++i) {
            bSelected = i == this.selectedItem;
            if (bSelected) {
                this.paintBtn(g, this.screen, i, true);
                switch (this.screen) {
                    case 0: {
                        if (STR_MAIN_MENU[i] == null) continue block12;
                        this.fontBlackBig.drawString(g, STR_MAIN_MENU[i].toCharArray(), this.rectMenu[i].getCenterX(), this.rectMenu[i].getCenterY() - (this.fontBlackBig.getHeight() >> 1), 17);
                        break;
                    }
                    case 8: {
                        if (STR_CONTINUE[i] == null) continue block12;
                        this.fontBlackBig.drawString(g, STR_CONTINUE[i].toCharArray(), this.rectContinue[i].getCenterX(), this.rectContinue[i].getCenterY() - (this.fontBlackBig.getHeight() >> 1), 17);
                        break;
                    }
                }
                continue;
            }
            this.paintBtn(g, this.screen, i, false);
            switch (this.screen) {
                case 0: {
                    if (STR_MAIN_MENU[i] == null) continue block12;
                    this.fontGoldBig.drawString(g, STR_MAIN_MENU[i].toCharArray(), this.rectMenu[i].getCenterX(), this.rectMenu[i].getCenterY() - (this.fontGoldBig.getHeight() >> 1), 17);
                    continue block12;
                }
                case 8: {
                    if (STR_CONTINUE[i] == null) continue block12;
                    this.fontGoldBig.drawString(g, STR_CONTINUE[i].toCharArray(), this.rectContinue[i].getCenterX(), this.rectContinue[i].getCenterY() - (this.fontGoldBig.getHeight() >> 1), 17);
                    continue block12;
                }
            }
        }
    }

    public void paintBtn(Graphics g, int iScreen, int id, boolean bSelected) {
        this.rectBtn = null;
        switch (this.screen) {
            case 0: {
                this.rectBtn = this.rectMenu[id];
                break;
            }
            case 8: {
                this.rectBtn = this.rectContinue[id];
                break;
            }
        }
        if (bSelected) {
            g.drawImage(this.imgBoxLongSelected, (MainCanvas.WIDTH >> 1) - (this.imgBoxLongSelected.getWidth() >> 1), this.rectBtn.y, 20);
        } else {
            g.drawImage(this.imgBoxLong, (MainCanvas.WIDTH >> 1) - (this.imgBoxLong.getWidth() >> 1), this.rectBtn.y, 20);
        }
    }

    public void paintDialog(Graphics g) {
        int i;
        int countX = (this.rectDialog.width - (this.sprDialog.getWidth() << 1)) / this.sprDialog.getWidth() + 1;
        int countY = (this.rectDialog.height - (this.sprDialog.getHeight() << 1)) / this.sprDialog.getHeight() + 1;
        int iX = this.rectDialog.x;
        int iY = this.rectDialog.y;
        this.sprDialog.setFrame(0);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
        for (i = 0; i < countY; ++i) {
            iY = i < countY - 1 ? (iY += this.sprDialog.getHeight()) : this.rectDialog.getBottom() - (this.sprDialog.getHeight() << 1);
            this.sprDialog.setFrame(3);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
        }
        iY = this.rectDialog.getBottom() - this.sprDialog.getHeight();
        this.sprDialog.setFrame(6);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
        for (i = 0; i < countX; ++i) {
            iX = i < countX - 1 ? (iX += this.sprDialog.getWidth()) : this.rectDialog.getRight() - (this.sprDialog.getWidth() << 1);
            iY = this.rectDialog.y;
            this.sprDialog.setFrame(1);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
            for (int j = 0; j < countY; ++j) {
                iY = j < countY - 1 ? (iY += this.sprDialog.getHeight()) : this.rectDialog.getBottom() - (this.sprDialog.getHeight() << 1);
                this.sprDialog.setFrame(4);
                this.sprDialog.setPosition(iX, iY);
                this.sprDialog.paint(g);
            }
            iY = this.rectDialog.getBottom() - this.sprDialog.getHeight();
            this.sprDialog.setFrame(7);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
        }
        iX = this.rectDialog.getRight() - this.sprDialog.getWidth();
        iY = this.rectDialog.y;
        this.sprDialog.setFrame(2);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
        for (i = 0; i < countY; ++i) {
            iY = i < countY - 1 ? (iY += this.sprDialog.getHeight()) : this.rectDialog.getBottom() - (this.sprDialog.getHeight() << 1);
            this.sprDialog.setFrame(5);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
        }
        iY = this.rectDialog.getBottom() - this.sprDialog.getHeight();
        this.sprDialog.setFrame(8);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
    }

    public void paintProfile(Graphics g) {
        this.paintDialog(g);
        this.pProfile.paint(g);
    }

    public void paintArrows(Graphics g, Rectangle rect, int iFrame, boolean bActive) {
        if (bActive) {
            this.sprArrows.setFrame(iFrame);
            this.sprArrows.setPosition(rect.x, rect.y);
            this.sprArrows.paint(g);
        } else {
            this.sprArrowsInactive.setFrame(iFrame);
            this.sprArrowsInactive.setPosition(rect.x, rect.y);
            this.sprArrowsInactive.paint(g);
        }
    }

    public void paintInstructions(Graphics g) {
        this.paintDialog(g);
        if (this.preparedTextInfo != null) {
            g.setClip(this.rectInfo.x, this.rectInfo.y, this.rectInfo.width, this.rectInfo.height);
            int iLines = this.preparedTextInfo.getTextHeight() / this.fontGold.getHeight();
            int iY = 0;
            String s = "";
            for (int i = 0; i < iLines; ++i) {
                if (this.preparedTextInfo.getTextHeight() <= this.fontGold.getHeight()) continue;
                s = this.preparedTextInfo.getText(i);
                iY = this.rectInfo.y + i * this.fontGold.getHeight() - this.preparedTextInfo.getTextOffsetY();
                if (iY + this.fontGold.getHeight() < this.rectInfo.y || iY > this.rectInfo.getBottom()) continue;
                this.fontGold.drawString(g, s.toCharArray(), MainCanvas.WIDTH >> 1, iY, 17);
            }
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            if (this.preparedTextInfo.getTextHeight() > this.rectInfo.height) {
                if (this.preparedTextInfo.getTextOffsetY() > 0) {
                    this.paintArrows(g, this.rectArrowsInstructions[0], 0, true);
                } else {
                    this.paintArrows(g, this.rectArrowsInstructions[0], 0, false);
                }
                if (this.preparedTextInfo.getTextOffsetY() < this.preparedTextInfo.getTextHeight() - this.rectInfo.height) {
                    this.paintArrows(g, this.rectArrowsInstructions[1], 1, true);
                } else {
                    this.paintArrows(g, this.rectArrowsInstructions[1], 1, false);
                }
            }
        }
    }

    public void paintQuestion(Graphics g) {
        this.paintDialog(g);
        if (this.preparedTextInfoBig != null) {
            int iHeight = this.preparedTextInfoBig.getTextHeight();
            int iLinesCount = iHeight / this.fontGoldBig.getHeight();
            int iY = this.rectDialog.getCenterY() - (iHeight >> 1);
            String str = "";
            int iStringWidth = 0;
            for (int i = 0; i < iLinesCount; ++i) {
                str = this.preparedTextInfoBig.getText(i);
                iStringWidth = this.fontGoldBig.stringWidth(str.toCharArray());
                this.fontGoldBig.drawString(g, str.toCharArray(), this.rectDialog.getCenterX() - (iStringWidth >> 1), iY, 20);
                iY += this.fontGoldBig.getHeight();
            }
        }
    }

    public void paintAbout(Graphics g) {
        this.paintDialog(g);
        g.drawImage(this.imgLogoInlogic, this.rectDialog.getCenterX() - (this.imgLogoInlogic.getWidth() >> 1), this.rectDialog.getCenterY() - (this.iAboutHeight >> 1), 20);
        if (this.preparedTextInfoBig != null) {
            int y = this.rectInfo.y;
            String s = this.preparedTextInfoBig.getText(0);
            int stringWidth = this.fontGoldBig.stringWidth(s.toCharArray());
            this.fontGoldBig.drawString(g, s.toCharArray(), (MainCanvas.WIDTH >> 1) - (stringWidth >> 1), y, 20);
            s = this.preparedTextInfoBig.getText(1);
            stringWidth = this.fontGold.stringWidth(s.toCharArray());
            this.fontGold.drawString(g, s.toCharArray(), (MainCanvas.WIDTH >> 1) - (stringWidth >> 1), y += this.fontGoldBig.getHeight() + (this.fontGoldBig.getHeight() - this.fontGold.getHeight()), 20);
        }
    }

    public void paintControls(Graphics g) {
        switch (this.screen) {
            case 0: {
                this.sprIcons.setFrame(7);
                this.sprIcons.setPosition(this.rectControls[0].x, this.rectControls[0].y);
                this.sprIcons.paint(g);
                this.sprIcons.setFrame(9);
                this.sprIcons.setPosition(this.rectControls[1].x, this.rectControls[1].y);
                this.sprIcons.paint(g);
                break;
            }
            case 8: {
                this.sprIcons.setFrame(7);
                this.sprIcons.setPosition(this.rectControls[0].x, this.rectControls[0].y);
                this.sprIcons.paint(g);
                this.sprIcons.setFrame(8);
                this.sprIcons.setPosition(this.rectControls[1].x, this.rectControls[1].y);
                this.sprIcons.paint(g);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.sprIcons.setFrame(8);
                this.sprIcons.setPosition(this.rectControls[1].x, this.rectControls[1].y);
                this.sprIcons.paint(g);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                this.sprIcons.setFrame(7);
                this.sprIcons.setPosition(this.rectControls[0].x, this.rectControls[0].y);
                this.sprIcons.paint(g);
                this.sprIcons.setFrame(6);
                this.sprIcons.setPosition(this.rectControls[1].x, this.rectControls[1].y);
                this.sprIcons.paint(g);
                break;
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (!this.isLoading && this.loadingCounter == 0 && this.nextScreenStep <= 0) {
            if (Keys.isKeyPressed(-7)) {
                this.back();
                return;
            }
            switch (this.screen) {
                case 0: 
                case 8: {
                    if (Keys.isActionPressed(2)) {
                        this.down();
                    }
                    if (Keys.isActionPressed(1)) {
                        this.up();
                    }
                    if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6)) break;
                    this.confirm();
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 9: {
                    if (!Keys.isKeyPressed(-6)) break;
                    this.confirm();
                    break;
                }
                case 1: {
                    if (Keys.isActionPressed(3)) {
                        this.pProfile.previousSite();
                    }
                    if (!Keys.isActionPressed(4)) break;
                    this.pProfile.nextSite();
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void afterHide() {
        Resources.freeAllResources();
        MainCanvas.soundManager.Stop();
    }

    public void beforeShow() {
        this.isLoading = true;
        this.initGraphics();
        this.initFonts();
        this.initTexts();
        this.initControls();
        this.initMenu();
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
        this.isLoading = false;
    }

    public void loadBMG() {
        try {
            this.link = Resources.langCode.compareTo("pt") == 0 ? X.singleton.getAppProperty("C2M-URL-pt-PT") : (Resources.langCode.compareTo("es") == 0 ? X.singleton.getAppProperty("C2M-URL-es-ES") : (Resources.langCode.compareTo("fr") == 0 ? X.singleton.getAppProperty("C2M-URL-fr-FR") : (Resources.langCode.compareTo("de") == 0 ? X.singleton.getAppProperty("C2M-URL-de-DE") : (Resources.langCode.compareTo("tr") == 0 ? X.singleton.getAppProperty("C2M-URL-tr-TR") : X.singleton.getAppProperty("C2M-URL-en-GB")))));
        }
        catch (Exception e) {
            this.link = null;
        }
        try {
            this.buysetup = X.singleton.getAppProperty("C2M-BuySetup");
        }
        catch (Exception e) {
            this.buysetup = null;
        }
        this.iTotalMainMenu = 5;
        if (this.containParam(this.buysetup, "menu") && this.link != null) {
            this.iTotalMainMenu = 6;
        }
    }

    public void initGraphics() {
        Resources.loadImages(new int[]{3, 4, 1, 6, 7});
        this.imgBg = Resources.resImgs[3];
        this.imgLogoMenu = Resources.resImgs[4];
        this.imgLogoInlogic = Resources.resImgs[1];
        this.imgBoxLong = Resources.resImgs[6];
        this.imgBoxLongSelected = Resources.resImgs[7];
        Resources.loadSprites(new int[]{1, 2, 3, 4, 7});
        this.sprIcons = Resources.resSprs[1];
        this.sprIconsAchievs = Resources.resSprs[2];
        this.sprArrows = Resources.resSprs[3];
        this.sprArrowsInactive = Resources.resSprs[4];
        this.sprDialog = Resources.resSprs[7];
        this.controlsBarHeight = this.sprIcons.getHeight() + (this.sprIcons.getHeight() >> 2);
    }

    public void initFonts() {
        Resources.loadText(0);
        Resources.loadGFonts(new int[]{0, 1, 2, 3});
        this.fontBlack = Resources.resGFonts[0];
        this.fontGold = Resources.resGFonts[1];
        this.fontBlackBig = Resources.resGFonts[2];
        this.fontGoldBig = Resources.resGFonts[3];
        this.preparedTextInfo = new PreparedText(this.fontGold);
        this.preparedTextInfoBig = new PreparedText(this.fontGoldBig);
    }

    public void initTexts() {
        STR_MAIN_MENU = new String[this.iTotalMainMenu];
        ScreenMenu.STR_MAIN_MENU[0] = Resources.resTexts[0].getHashedString(14);
        ScreenMenu.STR_MAIN_MENU[1] = Resources.resTexts[0].getHashedString(15);
        ScreenMenu.STR_MAIN_MENU[2] = Resources.resTexts[0].getHashedString(21);
        ScreenMenu.STR_MAIN_MENU[3] = Resources.resTexts[0].getHashedString(17);
        ScreenMenu.STR_MAIN_MENU[4] = Resources.resTexts[0].getHashedString(18);
        if (this.iTotalMainMenu == 6) {
            ScreenMenu.STR_MAIN_MENU[5] = Resources.resTexts[0].getHashedString(19);
        }
        STR_CONTINUE = new String[2];
        ScreenMenu.STR_CONTINUE[0] = Resources.resTexts[0].getHashedString(23);
        ScreenMenu.STR_CONTINUE[1] = Resources.resTexts[0].getHashedString(24);
        STR_COMBINATION = new String[11];
        ScreenMenu.STR_COMBINATION[0] = "";
        ScreenMenu.STR_COMBINATION[1] = Resources.resTexts[0].getHashedString(100);
        ScreenMenu.STR_COMBINATION[2] = Resources.resTexts[0].getHashedString(101);
        ScreenMenu.STR_COMBINATION[3] = Resources.resTexts[0].getHashedString(102);
        ScreenMenu.STR_COMBINATION[4] = Resources.resTexts[0].getHashedString(103);
        ScreenMenu.STR_COMBINATION[5] = Resources.resTexts[0].getHashedString(104);
        ScreenMenu.STR_COMBINATION[6] = Resources.resTexts[0].getHashedString(105);
        ScreenMenu.STR_COMBINATION[7] = Resources.resTexts[0].getHashedString(106);
        ScreenMenu.STR_COMBINATION[8] = Resources.resTexts[0].getHashedString(107);
        ScreenMenu.STR_COMBINATION[9] = Resources.resTexts[0].getHashedString(108);
        ScreenMenu.STR_COMBINATION[10] = Resources.resTexts[0].getHashedString(109);
    }

    public void initControls() {
        int y = MainCanvas.HEIGHT - this.sprIcons.getHeight();
        this.rectControls = new Rectangle[2];
        this.rectControls[0] = new Rectangle(0, y, this.sprIcons.getWidth(), this.sprIcons.getHeight());
        this.rectControls[1] = new Rectangle(MainCanvas.WIDTH - this.sprIcons.getWidth(), y, this.sprIcons.getWidth(), this.sprIcons.getHeight());
    }

    public void initMenu() {
        int i;
        this.iBookedSpaceY = this.imgLogoMenu.getHeight() + this.sprIcons.getHeight();
        this.iLogoY = this.sprIcons.getHeight() >> 1;
        if (MainCanvas.HEIGHT <= 320 || MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640 && MainCanvas.HEIGHT < 800 || this.isSmallAspectRatio()) {
            this.iBookedSpaceY = this.imgLogoMenu.getHeight() + (this.sprIcons.getHeight() >> 1);
            this.iLogoY = this.sprIcons.getHeight() >> 2;
        }
        int iWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        int iX = (MainCanvas.WIDTH >> 1) - (iWidth >> 1);
        int iMaxHeight = MainCanvas.HEIGHT - this.iBookedSpaceY - this.sprIcons.getHeight() - (this.sprIcons.getHeight() >> 1);
        int iSpaceY = (iMaxHeight - this.iTotalMainMenu * this.imgBoxLong.getHeight()) / (this.iTotalMainMenu + 3);
        if (iSpaceY < 2) {
            iSpaceY = 2;
        }
        int iY = this.iBookedSpaceY + (iSpaceY << 1);
        this.rectMenu = new Rectangle[this.iTotalMainMenu];
        for (i = 0; i < this.iTotalMainMenu; ++i) {
            this.rectMenu[i] = new Rectangle(iX, iY, iWidth, this.imgBoxLong.getHeight());
            iY += this.imgBoxLong.getHeight() + iSpaceY;
        }
        iSpaceY = (iMaxHeight - 2 * this.imgBoxLong.getHeight()) / 5;
        iY = this.iBookedSpaceY + (iSpaceY << 1);
        this.rectContinue = new Rectangle[2];
        for (i = 0; i < 2; ++i) {
            this.rectContinue[i] = new Rectangle(iX, iY, iWidth, this.imgBoxLong.getHeight());
            iY += this.imgBoxLong.getHeight() + iSpaceY;
        }
    }

    private boolean containParam(String source, String param) {
        int index;
        if (source == null) {
            return false;
        }
        do {
            if (!(source = source.trim()).startsWith(param)) continue;
            return true;
        } while ((source = (index = source.indexOf(",")) < 0 ? "" : source.substring(index + 1, source.length())) != "");
        return false;
    }

    public void down() {
        if (this.nextScreenStep <= 0) {
            switch (this.screen) {
                case 0: {
                    this.selectedItem = (this.selectedItem + 1) % this.iTotalMainMenu;
                    break;
                }
                case 8: {
                    this.selectedItem = (this.selectedItem + 1) % 2;
                    break;
                }
            }
        }
    }

    public void up() {
        if (this.nextScreenStep <= 0) {
            switch (this.screen) {
                case 0: {
                    if (this.selectedItem > 0) {
                        --this.selectedItem;
                        break;
                    }
                    this.selectedItem = this.iTotalMainMenu - 1;
                    break;
                }
                case 8: {
                    if (this.selectedItem > 0) {
                        --this.selectedItem;
                        break;
                    }
                    this.selectedItem = 1;
                    break;
                }
            }
        }
    }

    public void back() {
        if (this.nextScreenStep <= 0) {
            switch (this.screen) {
                case 0: {
                    this.nextScreen(6, this.selectedItem);
                    break;
                }
                case 1: {
                    this.nextScreen(0, 1);
                    break;
                }
                case 3: {
                    this.nextScreen(0, 3);
                    break;
                }
                case 4: {
                    this.nextScreen(0, 4);
                    break;
                }
                case 2: {
                    this.nextScreen(0, 2);
                    break;
                }
                case 5: 
                case 6: {
                    this.nextScreen(0, this.selectedItem);
                    break;
                }
                case 8: {
                    this.nextScreen(0, 0);
                    break;
                }
                case 9: {
                    this.nextScreen(8, 1);
                    break;
                }
            }
        }
    }

    public void confirm() {
        if (this.nextScreenStep <= 0) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.selectedItem) {
                        case 0: {
                            this.checkSavedGame();
                            break block0;
                        }
                        case 1: {
                            this.nextScreen(1, this.selectedItem);
                            break block0;
                        }
                        case 2: {
                            this.nextScreen(2, this.selectedItem);
                            break block0;
                        }
                        case 3: {
                            this.nextScreen(3, this.selectedItem);
                            break block0;
                        }
                        case 4: {
                            this.nextScreen(4, this.selectedItem);
                            break block0;
                        }
                        case 5: {
                            this.nextScreen(5, this.selectedItem);
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (this.selectedItem) {
                        case 0: {
                            this.nextScreen(10, this.selectedItem);
                            break block0;
                        }
                        case 1: {
                            this.nextScreen(9, this.selectedItem);
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    this.deleteSavedGame();
                    Scores.addGamesPlayed();
                    Scores.addHandsPlayed();
                    Scores.initActualHandsWonInRow();
                    Scores.initActualGamesWonInRow();
                    Scores.initWinsSum();
                    Scores.initAbsoluteWinner();
                    Scores.save();
                    this.nextScreen(10, this.selectedItem);
                    break;
                }
                case 2: {
                    this.reset();
                    break;
                }
                case 6: {
                    this.quit();
                    break;
                }
                case 5: {
                    this.moreGames();
                    break;
                }
            }
        }
    }

    public void checkSavedGame() {
        SavedGame.load();
        if (SavedGame.bSaved) {
            this.nextScreen(8, 0);
        } else {
            this.nextScreen(10, this.selectedItem);
        }
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
    }

    public void reset() {
        this.deleteAllScoresAndSaves();
        Scores.load();
        this.nextScreen(0, 2);
    }

    public void quit() {
        X.quitApp();
    }

    public void moreGames() {
        X.singleton.requestLink(this.link);
    }

    public void deleteSavedGame() {
        ++this.loadingCounter;
        RMSObjects.createRMSConnect(2);
        RMSObjects.rmsConnects[2].delete();
        RMSObjects.freeRMSConnect(2);
        --this.loadingCounter;
    }

    public void deleteScores() {
        ++this.loadingCounter;
        RMSObjects.createRMSConnect(1);
        RMSObjects.rmsConnects[1].delete();
        RMSObjects.freeRMSConnect(1);
        --this.loadingCounter;
    }

    public void deleteAllScoresAndSaves() {
        this.deleteScores();
        this.deleteSavedGame();
        System.out.println("ALL SCORES AND SAVES DELETED!!!");
    }

    public void upText() {
        int textOffsetY = this.preparedTextInfo.getTextOffsetY() - this.fontGold.getHeight();
        if (textOffsetY < 0) {
            textOffsetY = 0;
        }
        this.preparedTextInfo.setTextOffsetY(textOffsetY);
    }

    public void downText() {
        int textOffsetY = this.preparedTextInfo.getTextOffsetY() + this.fontGold.getHeight();
        int maxOffsetY = this.preparedTextInfo.getTextHeight() - this.rectInfo.height;
        if (maxOffsetY < 0) {
            maxOffsetY = 0;
        }
        if (textOffsetY > maxOffsetY) {
            textOffsetY = maxOffsetY;
        }
        this.preparedTextInfo.setTextOffsetY(textOffsetY);
    }

    public void updateText() {
        if (this.screen == 3) {
            int textShift = this.fontGold.getHeight() >> 1;
            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                this.preparedTextInfo.setTextOffsetY(this.preparedTextInfo.getTextOffsetY() - textShift);
            }
            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                int textOffsetY = this.preparedTextInfo.getTextOffsetY() + textShift;
                int maxOffsetY = this.preparedTextInfo.getTextHeight() - this.rectInfo.height;
                if (maxOffsetY < 0) {
                    maxOffsetY = 0;
                }
                if (textOffsetY > maxOffsetY) {
                    textOffsetY = maxOffsetY;
                }
                this.preparedTextInfo.setTextOffsetY(textOffsetY);
            }
            if (this.preparedTextInfo.getTextOffsetY() < 0) {
                this.preparedTextInfo.setTextOffsetY(0);
            }
        }
    }

    public boolean isSmallAspectRatio() {
        return MainCanvas.WIDTH * 100 / MainCanvas.HEIGHT >= 75;
    }
}

