/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenIntro
implements IScreen {
    private static final int MODE_LOGO_INLOGIC = 0;
    private static final int MODE_LANGUAGE = 1;
    private static final int MODE_SPLASH = 2;
    private static final int TIME = 3000;
    MainCanvas mainCanvas;
    GFont fontGold;
    private long delay;
    private int mode;
    Sprite sprLanguages;
    private static String[] langCodes = new String[]{"en", "de", "fr", "it", "es", "pt"};
    private static final int[] LANGUAGES = new int[]{5, 4, 1, 0, 3, 2};
    private static final int TOTAL_LANGUAGES = 6;
    private Rectangle[] rectItems = new Rectangle[6];
    private int selectedItem;
    int updateCounter = 0;
    Sprite sprIcons;
    Sprite sprDialog;
    Rectangle rectDialog;
    Rectangle[] rectControls = new Rectangle[2];
    Image imgSplash;
    private int iShiftDirection;
    private int iShiftX;
    private int iShiftStep;

    public ScreenIntro(MainCanvas mainCanvas) {
        System.out.println("\n \nSCREEN INTRO");
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{3, 1});
        this.initShift();
        this.mode = 0;
        this.delay = 3000L;
    }

    public void afterHide() {
        Resources.freeAllResources();
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    public void update(long lastRunLenght) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        switch (this.mode) {
            case 1: {
                this.updateShift();
                break;
            }
            default: {
                if (this.delay > 0L) {
                    this.delay -= lastRunLenght;
                    break;
                }
                this.nextScreen();
            }
        }
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                this.paintBg(g);
                this.paintLogoInlogic(g);
                break;
            }
            case 1: {
                this.paintBg(g);
                this.paintFlags(g);
                this.paintControls(g);
                break;
            }
            case 2: {
                this.paintSplash(g);
                break;
            }
        }
    }

    public void paintBg(Graphics g) {
        g.drawImage(Resources.resImgs[3], 0, 0, 20);
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(Resources.resImgs[1], MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
    }

    public void initShift() {
        this.iShiftDirection = 1;
        this.iShiftX = 0;
        this.iShiftStep = MainCanvas.WIDTH / 120;
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iShiftStep = MainCanvas.HEIGHT / 160;
        }
    }

    public void updateShift() {
        ++this.updateCounter;
        if (this.updateCounter > 1) {
            this.updateCounter = 0;
            if (this.iShiftDirection > 0) {
                this.iShiftX += this.iShiftStep;
                if (this.iShiftX >= this.iShiftStep << 1) {
                    this.iShiftDirection = -1;
                }
            } else {
                this.iShiftX -= this.iShiftStep;
                if (this.iShiftX <= -(this.iShiftStep << 1)) {
                    this.iShiftDirection = 1;
                }
            }
        }
    }

    private void paintFlags(Graphics g) {
        int pomShiftX = 0;
        for (int i = 0; i < 6; ++i) {
            pomShiftX = 0;
            if (i == this.selectedItem) {
                pomShiftX = this.iShiftX;
            }
            this.sprLanguages.setFrame(LANGUAGES[i]);
            this.sprLanguages.setPosition(this.rectItems[i].x + pomShiftX, this.rectItems[i].y);
            this.sprLanguages.paint(g);
        }
    }

    public void paintDialog(Graphics g) {
        this.paintDialog(g, this.rectDialog);
        String s = Resources.resTexts[0].getHashedString(5);
        int iStringWidth = this.fontGold.stringWidth(s.toCharArray());
        this.fontGold.drawString(g, s.toCharArray(), this.rectDialog.getCenterX() - (iStringWidth >> 1), this.rectDialog.getCenterY() - (this.fontGold.getHeight() >> 1), 20);
    }

    public void paintDialog(Graphics g, Rectangle rect) {
        int i;
        int iCountX = (rect.width - (this.sprDialog.getWidth() << 1)) / this.sprDialog.getWidth() + 1;
        int iCountY = (rect.height - (this.sprDialog.getHeight() << 1)) / this.sprDialog.getHeight() + 1;
        int iX = rect.x;
        int iY = rect.y;
        this.sprDialog.setFrame(0);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
        this.sprDialog.setFrame(1);
        for (i = 0; i < iCountX; ++i) {
            iX = i < iCountX - 1 ? (iX += this.sprDialog.getWidth()) : rect.getRight() - (this.sprDialog.getWidth() << 1);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
        }
        iX = rect.getRight() - this.sprDialog.getWidth();
        this.sprDialog.setFrame(2);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
        for (int j = 0; j < iCountY; ++j) {
            iX = rect.x;
            iY = j < iCountY - 1 ? (iY += this.sprDialog.getHeight()) : rect.getBottom() - (this.sprDialog.getHeight() << 1);
            this.sprDialog.setFrame(3);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
            this.sprDialog.setFrame(4);
            for (int i2 = 0; i2 < iCountX; ++i2) {
                iX = i2 < iCountX - 1 ? (iX += this.sprDialog.getWidth()) : rect.getRight() - (this.sprDialog.getWidth() << 1);
                this.sprDialog.setPosition(iX, iY);
                this.sprDialog.paint(g);
            }
            iX = rect.getRight() - this.sprDialog.getWidth();
            this.sprDialog.setFrame(5);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
        }
        iX = rect.x;
        iY = rect.getBottom() - this.sprDialog.getHeight();
        this.sprDialog.setFrame(6);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
        this.sprDialog.setFrame(7);
        for (i = 0; i < iCountX; ++i) {
            iX = i < iCountX - 1 ? (iX += this.sprDialog.getWidth()) : rect.getRight() - (this.sprDialog.getWidth() << 1);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
        }
        iX = rect.getRight() - this.sprDialog.getWidth();
        this.sprDialog.setFrame(8);
        this.sprDialog.setPosition(iX, iY);
        this.sprDialog.paint(g);
    }

    public void paintControls(Graphics g) {
        switch (this.mode) {
            case 1: {
                this.sprIcons.setFrame(7);
                this.sprIcons.setPosition(this.rectControls[0].x, this.rectControls[0].y);
                this.sprIcons.paint(g);
                break;
            }
        }
    }

    public void paintSplash(Graphics g) {
        g.drawImage(this.imgSplash, MainCanvas.WIDTH >> 1, 0, 17);
    }

    public void nextScreen() {
        switch (this.mode) {
            case 0: {
                Resources.loadGFont(3);
                this.fontGold = Resources.resGFonts[3];
                Resources.loadSprites(new int[]{0, 1});
                this.sprLanguages = Resources.resSprs[0];
                this.sprIcons = Resources.resSprs[1];
                this.selectedItem = 0;
                this.setFlagsPositions();
                int width = this.sprIcons.getWidth();
                int height = this.sprIcons.getHeight();
                int controlsX1 = 0;
                int controlsX2 = MainCanvas.WIDTH - width;
                int controlsY = MainCanvas.HEIGHT - height;
                this.rectControls = new Rectangle[2];
                this.rectControls[0] = new Rectangle(controlsX1, controlsY, width, height);
                this.rectControls[1] = new Rectangle(controlsX2, controlsY, width, height);
                this.mode = 1;
                break;
            }
            case 1: {
                Resources.freeSprite(0);
                Resources.initLangDirs(langCodes[this.selectedItem]);
                Resources.loadText(0);
                Resources.loadSprite(7);
                this.sprDialog = Resources.resSprs[7];
                this.selectedItem = -1;
                int fontHeight = this.fontGold.getHeight();
                int dialogWidth = MainCanvas.WIDTH < MainCanvas.HEIGHT ? MainCanvas.WIDTH - (MainCanvas.WIDTH >> 3) : MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 3);
                this.rectDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (dialogWidth >> 1), (MainCanvas.HEIGHT >> 1) - fontHeight, dialogWidth, fontHeight * 3);
                Resources.loadImage(2);
                this.imgSplash = Resources.resImgs[2];
                this.mode = 2;
                this.delay = 3000L;
                this.soundOff();
                break;
            }
            case 2: {
                Resources.freeImage(2);
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas));
                break;
            }
        }
    }

    public void keyPressed(int keyCode) {
        switch (this.mode) {
            case 1: {
                if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                    this.changeLanguage(0);
                    return;
                }
                if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                    this.changeLanguage(1);
                    return;
                }
                if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                    this.changeLanguage(2);
                    return;
                }
                if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                    this.changeLanguage(3);
                    return;
                }
                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break;
                this.nextScreen();
                return;
            }
            default: {
                if (this.delay <= 100L) break;
                this.delay = 100L;
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.selectedItem <= 1) break;
                this.selectedItem -= 2;
                break;
            }
            case 1: {
                if (this.selectedItem >= 4) break;
                this.selectedItem += 2;
                break;
            }
            case 2: {
                if (this.selectedItem <= 0 || this.selectedItem % 2 != 1) break;
                --this.selectedItem;
                break;
            }
            case 3: {
                if (this.selectedItem % 2 != 0) break;
                ++this.selectedItem;
                break;
            }
        }
        if (this.selectedItem < 0) {
            this.selectedItem = 0;
        } else if (this.selectedItem > 5) {
            this.selectedItem = 5;
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    private void setFlagsPositions() {
        int spaceY;
        int btnWidth = this.sprLanguages.getWidth();
        int btnHeight = this.sprLanguages.getHeight();
        int spaceX = (MainCanvas.WIDTH - btnWidth * 2) / 3;
        int y = spaceY = (MainCanvas.HEIGHT - btnHeight * 3) / 5;
        int id = 0;
        int yDiff = MainCanvas.HEIGHT - 3 * this.sprLanguages.getHeight() >> 2;
        for (int i = 0; i < 3; ++i) {
            y = (i + 1) * yDiff + i * this.sprLanguages.getHeight();
            this.rectItems[id] = new Rectangle(spaceX, y, btnWidth, btnHeight);
            this.rectItems[id + 1] = new Rectangle((spaceX << 1) + btnWidth, y, btnWidth, btnHeight);
            id += 2;
        }
    }

    private void soundOff() {
        Settings.soundsOn = false;
        MainCanvas.soundManager.SetSoundOn(false);
        this.nextScreen();
    }
}

