/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.GameDefines;
import sk.inlogic.MainCanvas;
import sk.inlogic.Player;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.SavedGame;
import sk.inlogic.Scores;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    MainCanvas mainCanvas;
    GFont fontBlack;
    GFont fontGold;
    GFont fontBlackBig;
    GFont fontGoldBig;
    Profile pProfile;
    Player[] pPlayer;
    Image imgBg;
    Image imgLogoMenu;
    Image imgCardBack;
    Image imgCardSelector;
    Image imgCardPlaceholderTable;
    Image imgCardPlaceholderPlayer;
    Image imgBoxShort;
    Image imgBoxShortSelected;
    Image imgBoxLong;
    Image imgBoxLongSelected;
    Image imgBoxBig;
    Image imgBoxBigSelected;
    Image imgBoxSlimSelected;
    Image imgPotBoxBlack;
    Image imgPotBoxGold;
    Image imgRaiseBox;
    Image imgShadow;
    Sprite sprIcons;
    Sprite sprIconsAchievs;
    Sprite sprArrows;
    Sprite sprArrowsInactive;
    Sprite sprDialog;
    Sprite sprCards;
    Sprite sprChips;
    Sprite sprWinChip;
    public static final byte STEP_NUMBER_OF_OPPONENTS = 0;
    public static final byte STEP_VALUE_OF_BLINDS = 1;
    public static final byte STEP_MARK_DEALER = 2;
    public static final byte STEP_MARK_SMALL_BLIND = 3;
    public static final byte STEP_MARK_BIG_BLIND = 4;
    public static final byte STEP_FORCED_BET_SMALL_BLIND = 5;
    public static final byte STEP_FORCED_BET_BIG_BLIND = 6;
    public static final byte STEP_DEAL_CARDS = 7;
    public static final byte STEP_PREFLOP = 8;
    public static final byte STEP_FLOP = 9;
    public static final byte STEP_FLOP_BETTING = 10;
    public static final byte STEP_TURN = 11;
    public static final byte STEP_TURN_BETTING = 12;
    public static final byte STEP_RIVER = 13;
    public static final byte STEP_RIVER_BETTING = 14;
    public static final byte STEP_SHOWDOWN = 15;
    public static final byte STEP_EVALUATION = 16;
    public static final byte STEP_END_OF_GAME = 17;
    public static final byte CHIP_D = 0;
    public static final byte CHIP_SB = 1;
    public static final byte CHIP_BB = 2;
    public static final byte ACTION_NONE = 0;
    public static final byte ACTION_FOLD = 1;
    public static final byte ACTION_CHECK = 2;
    public static final byte ACTION_BET = 3;
    public static final byte ACTION_CALL = 4;
    public static final byte ACTION_RAISE = 5;
    public static final byte ACTION_ALL_IN = 6;
    public static final byte ACTIVE_INACTIVE = 0;
    public static final byte ACTIVE_ACTIVE = 1;
    public static final byte SCREEN_GAME = 0;
    public static final byte SCREEN_PAUSE_MAIN = 1;
    public static final byte SCREEN_PAUSE_PROFILE = 2;
    public static final byte SCREEN_PAUSE_INSTRUCTIONS = 3;
    public static final byte SCREEN_PAUSE_QUIT_TO_MENU = 4;
    final byte ID_PAUSE_PROFILE;
    final byte ID_PAUSE_INSTRUCTIONS;
    final byte ID_PAUSE_QUIT_TO_MENU = (byte)2;
    final byte TOTAL_PAUSE = (byte)3;
    int screen = 0;
    int selectedItem = 0;
    int iBookedSpaceY = 0;
    int iLogoY = 0;
    int nextScreenStep = 0;
    int nextScreen = 0;
    int nextSelectedItem = 0;
    int time;
    int pomTime;
    long lastTime;
    int raiseValueCounter;
    int hand;
    int step;
    int value;
    int players;
    int startingPlayer;
    int actualPlayer;
    int activePlayers;
    int activePlayingPlayers;
    int dealer;
    int smallBlind;
    int bigBlind;
    int maxBlinds;
    int blindsPointer;
    int raiseBlindsCounter;
    int sbValue;
    int bbValue;
    int minRaiseValue;
    int maxRaiseValue;
    int pot;
    int cardsPointer;
    int holeCardsPointer;
    int communityCardsPointer;
    int highestBet = 0;
    int pomRaiseValue;
    int playersSelection;
    int shownCardsPlayer;
    int highlightedPlayer;
    int winnersCount;
    int movingPotValue;
    int movingPotPom;
    int endDialogPointer;
    int ddaShift;
    int statusBarHeight;
    int controlsBarHeight;
    int playgroundWidth;
    int playgroundHeight;
    int playgroundCenterY;
    int cardWidth;
    int cardHeight;
    int potX;
    int potY;
    int pomPotX;
    int pomPotY;
    int contextMenuTop;
    int contextMenuY;
    int cardStackX;
    int cardStackY;
    int cardSpace;
    int nextStepCounter;
    int dealingCardsCounter;
    int nextPlayerCounter;
    int shownCardsCounter;
    int makeChoiceCounter;
    int endOfBettingRoundCounter;
    int endDialogCounter;
    int evaluationCounter;
    int identifyWinnersCounter;
    int[] iCommunityCardsFlipCounter = new int[5];
    int raisingType = 0;
    int winChipFrame = 0;
    boolean bPause = false;
    boolean bChangeSound = false;
    boolean bNextStep;
    boolean bMovingChips;
    boolean bDealingCards;
    boolean bMovingHoleCards;
    boolean bMovingCommunityCards;
    boolean bNextPlayer;
    boolean bRaise;
    boolean bWaitingForPlayer;
    boolean bStartOfBetting;
    boolean bMovingBets;
    boolean bMovingBet;
    boolean bShownCards;
    boolean bMakeChoice;
    boolean bEndOfBettingRound;
    boolean bMovingPot;
    boolean bFoldingCards;
    boolean bDropingCards;
    boolean bEndDialog;
    boolean bEvaluation;
    boolean bIdentifyWinners;
    boolean bContextMenuIn;
    boolean bContextMenuOut;
    boolean bDialogActive = false;
    boolean bOneActivePlayer = false;
    boolean bSkip = false;
    boolean bShowSkipButton = false;
    public static int[] CHIP_X;
    public static int[] CHIP_Y;
    public static int[] CHIP_RIGHT_POS_X;
    public static int[] CHIP_RIGHT_POS_Y;
    public static byte[] CARDS;
    public static byte[] HOLE_CARDS;
    public static byte[] COMMUNITY_CARDS;
    public static byte[] ACTIVE;
    public static byte[] SHOWN_CARDS;
    public static int[] CHIPS;
    public static int[] BUY_IN;
    public static int[] BET;
    public static int[] BETS;
    public static int[] POT;
    public static byte[] POT_PLAYERS;
    public static int[] POT_WINNERS;
    public static int[] POT_TEMP;
    public static int[] INDIVIDUAL_LIMITS;
    public static int[] LIMITS;
    public static int[] CARDS_X;
    public static int[] CARDS_Y;
    public static int[] CARDS_RIGHT_POS_X;
    public static int[] CARDS_RIGHT_POS_Y;
    public static int[] COMMUNITY_CARDS_X;
    public static int[] COMMUNITY_CARDS_Y;
    public static int[] COMMUNITY_CARDS_RIGHT_POS_X;
    public static int[] COMMUNITY_CARDS_RIGHT_POS_Y;
    public static int[] BET_X;
    public static int[] BET_Y;
    public static int[] BETS_X;
    public static int[] BETS_Y;
    public static int[] BET_RIGHT_POS_X;
    public static int[] BET_RIGHT_POS_Y;
    public static int[] POT_X;
    public static int[] POT_Y;
    public static int[] POT_RIGHT_POS_X;
    public static int[] POT_RIGHT_POS_Y;
    public static byte[] ACTION;
    public static byte[] WINNER;
    public static byte[] PLAYERS_MODE;
    public static byte[] PLAYERS_FACE;
    public static String strPlayer;
    public static String strChooseNumberOfOpponents;
    public static String strChooseBlinds;
    public static String strWin;
    public static String strWins;
    public static String strWinGame;
    public static String strWinsGame;
    public static String strLosesGame;
    public static String strAnd;
    public static String[] STR_CARD_VALUE;
    public static String[] STR_ACTION;
    public static String[] STR_PAUSE_MENU;
    public static String[] STR_COMBINATION;
    public static String strLevel;
    public static String strXP;
    public static String strPot;
    public static byte[] COMBINATION_INFO;
    public static byte[] SORTED_CARDS;
    public static byte[] DIVIDED_CARDS;
    public static byte[] CARDS_SUITS_COUNT;
    public static byte[] CARDS_VALUES_COUNT;
    final int BLINK_DELAY;
    int potBlinkCounter = 0;
    int chipsBlinkCounter = 0;
    boolean bPotBlink = false;
    boolean bChipsBlink = false;
    boolean[] bChipBlink;
    Rectangle rectInfo;
    Rectangle rectDialog;
    Rectangle[] rectMenu;
    Rectangle[] rectControls;
    Rectangle[] rectArrowsDialog;
    Rectangle[] rectArrowsInstructions;
    Rectangle[] rectArrowsContext;
    Rectangle[] rectArrowsContextRaise;
    PreparedText preparedTextInfo;
    PreparedText preparedTextInfoBig;
    PreparedText prepText1;
    PreparedText prepText2;
    private int textShift = 0;
    private int pointerY = -1;
    boolean bPressed = false;
    int iUpdateSelector = 0;
    boolean bShowSelector = true;
    final int LIMIT_HEIGHT;
    int iWinChipCounter = 0;
    int iNextHandCounter = 0;
    int NEW_PROBS_TOTAL = 100;
    int[] NEW_PROBS_1 = new int[]{20, 80, 0, 50, 50};
    int[] NEW_PROBS_2 = new int[]{35, 65, 30, 45, 25};
    int[] NEW_PROBS_3 = new int[]{50, 50, 50, 40, 10};
    int[] NEW_PROBS_4 = new int[]{65, 35, 80, 15, 5};
    int[] NEW_PROBS_5 = new int[]{80, 20, 100, 0, 0};

    public ScreenGame(MainCanvas mainCanvas) {
        this.ID_PAUSE_PROFILE = 0;
        this.ID_PAUSE_INSTRUCTIONS = 1;
        this.BLINK_DELAY = 12;
        this.LIMIT_HEIGHT = 224;
        System.out.println("\n \nSCREEN GAME");
        this.mainCanvas = mainCanvas;
        this.bPause = false;
        this.screen = 0;
        this.selectedItem = 0;
        this.cardStackX = MainCanvas.WIDTH;
        this.cardStackY = (MainCanvas.HEIGHT >> 1) - MainCanvas.HEIGHT / 10;
        this.raiseValueCounter = 0;
        this.hand = 0;
        this.step = -1;
        this.players = 5;
        this.actualPlayer = 0;
        this.activePlayers = 0;
        this.activePlayingPlayers = 0;
        this.startingPlayer = 0;
        this.dealer = -1;
        this.smallBlind = -1;
        this.bigBlind = -1;
        this.maxBlinds = 0;
        this.blindsPointer = 0;
        this.raiseBlindsCounter = 0;
        this.sbValue = 0;
        this.bbValue = 0;
        this.minRaiseValue = 0;
        this.maxRaiseValue = 0;
        this.pot = 0;
        this.highestBet = 0;
        this.pomRaiseValue = 0;
        this.playersSelection = 0;
        this.shownCardsPlayer = -1;
        this.highlightedPlayer = -1;
        this.winnersCount = 0;
        this.movingPotValue = 0;
        this.movingPotPom = 0;
        this.endDialogPointer = 0;
        CHIP_X = new int[1];
        CHIP_Y = new int[1];
        CHIP_RIGHT_POS_X = new int[1];
        CHIP_RIGHT_POS_Y = new int[1];
        ScreenGame.CHIP_X[0] = -1;
        ScreenGame.CHIP_Y[0] = -1;
        ScreenGame.CHIP_RIGHT_POS_X[0] = -1;
        ScreenGame.CHIP_RIGHT_POS_Y[0] = -1;
        BET = new int[1];
        BETS = new int[1];
        CHIPS = new int[1];
        BUY_IN = new int[1];
        ScreenGame.BET[0] = -1;
        ScreenGame.BETS[0] = -1;
        ScreenGame.CHIPS[0] = -1;
        ScreenGame.BUY_IN[0] = -1;
        POT = new int[1];
        ScreenGame.POT[0] = -1;
        POT_WINNERS = new int[1];
        ScreenGame.POT_WINNERS[0] = -1;
        INDIVIDUAL_LIMITS = new int[1];
        ScreenGame.INDIVIDUAL_LIMITS[0] = -1;
        LIMITS = new int[1];
        ScreenGame.LIMITS[0] = -1;
        CARDS_X = new int[1];
        CARDS_Y = new int[1];
        CARDS_RIGHT_POS_X = new int[1];
        CARDS_RIGHT_POS_Y = new int[1];
        ScreenGame.CARDS_X[0] = -1;
        ScreenGame.CARDS_Y[0] = -1;
        ScreenGame.CARDS_RIGHT_POS_X[0] = -1;
        ScreenGame.CARDS_RIGHT_POS_Y[0] = -1;
        COMMUNITY_CARDS_X = new int[1];
        COMMUNITY_CARDS_Y = new int[1];
        COMMUNITY_CARDS_RIGHT_POS_X = new int[1];
        COMMUNITY_CARDS_RIGHT_POS_Y = new int[1];
        ScreenGame.COMMUNITY_CARDS_X[0] = -1;
        ScreenGame.COMMUNITY_CARDS_Y[0] = -1;
        ScreenGame.COMMUNITY_CARDS_RIGHT_POS_X[0] = -1;
        ScreenGame.COMMUNITY_CARDS_RIGHT_POS_Y[0] = -1;
        BET_X = new int[1];
        ScreenGame.BET_X[0] = -1;
        BET_Y = new int[1];
        ScreenGame.BET_Y[0] = -1;
        BETS_X = new int[1];
        ScreenGame.BETS_X[0] = -1;
        BETS_Y = new int[1];
        ScreenGame.BETS_Y[0] = -1;
        BET_RIGHT_POS_X = new int[1];
        ScreenGame.BET_RIGHT_POS_X[0] = -1;
        BET_RIGHT_POS_Y = new int[1];
        ScreenGame.BET_RIGHT_POS_Y[0] = -1;
        POT_X = new int[1];
        ScreenGame.POT_X[0] = -1;
        POT_Y = new int[1];
        ScreenGame.POT_Y[0] = -1;
        POT_RIGHT_POS_X = new int[1];
        ScreenGame.POT_RIGHT_POS_X[0] = -1;
        POT_RIGHT_POS_Y = new int[1];
        ScreenGame.POT_RIGHT_POS_Y[0] = -1;
        CARDS = new byte[1];
        ScreenGame.CARDS[0] = -1;
        COMMUNITY_CARDS = new byte[1];
        ScreenGame.COMMUNITY_CARDS[0] = -1;
        HOLE_CARDS = new byte[1];
        ScreenGame.HOLE_CARDS[0] = -1;
        POT_PLAYERS = new byte[1];
        ScreenGame.POT_PLAYERS[0] = -1;
        ACTIVE = new byte[1];
        SHOWN_CARDS = new byte[1];
        ACTION = new byte[1];
        WINNER = new byte[1];
        PLAYERS_MODE = new byte[1];
        ScreenGame.ACTIVE[0] = -1;
        ScreenGame.SHOWN_CARDS[0] = -1;
        ScreenGame.ACTION[0] = -1;
        ScreenGame.WINNER[0] = -1;
        ScreenGame.PLAYERS_MODE[0] = -1;
        COMBINATION_INFO = new byte[1];
        ScreenGame.COMBINATION_INFO[0] = -1;
        SORTED_CARDS = new byte[1];
        ScreenGame.SORTED_CARDS[0] = -1;
        DIVIDED_CARDS = new byte[1];
        ScreenGame.DIVIDED_CARDS[0] = -1;
        CARDS_SUITS_COUNT = new byte[1];
        ScreenGame.CARDS_SUITS_COUNT[0] = -1;
        CARDS_VALUES_COUNT = new byte[1];
        ScreenGame.CARDS_VALUES_COUNT[0] = -1;
        this.initDdaShift();
        this.initParams();
        Scores.load();
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        this.updateNextScreen();
        if (this.bPause) {
            if (this.screen == 3) {
                this.updateText();
            }
        } else {
            this.updateNextStep();
            this.updateContextMenu();
            this.updateChips();
            this.updateDealingCards();
            this.updateHoleCards();
            this.updateCommunityCards();
            this.updateCommunityCardsFlip();
            this.updateFoldingCards();
            this.updateDropingCards();
            this.updateNextPlayer();
            this.updateMakeChoice();
            this.updateBets();
            this.updateBet();
            this.updatePots();
            this.updateShowCards();
            this.updateEvaluation();
            this.updateIdentifyWinners();
            this.updateEndOfBettingRound();
            this.updateEndDialog();
            this.updateRaiseValue();
            this.updatePotBlinkCounter();
            this.updateChipsBlinkCounter();
            this.updateWinChip(lTick);
            this.updateTime();
            this.updateSelector(lTick);
            this.updateNextHand();
        }
        this.mainCanvas.repaint();
    }

    public void updateSelector(long lTick) {
        if (this.bWaitingForPlayer) {
            this.iUpdateSelector = (int)((long)this.iUpdateSelector + lTick);
            if (this.iUpdateSelector >= 500) {
                this.iUpdateSelector = 0;
                boolean bl = this.bShowSelector = !this.bShowSelector;
                if (this.pPlayer[0] != null) {
                    this.pPlayer[0].setShowSelector(this.bShowSelector);
                }
            }
        }
    }

    public void updateRaiseValue() {
        if (this.bWaitingForPlayer && this.maxRaiseValue > this.minRaiseValue && (this.playersSelection == 5 || this.playersSelection == 3) && this.pomRaiseValue > 0) {
            if (Keys.isActionPressed(1) || Keys.isActionPressed(2)) {
                ++this.raiseValueCounter;
                if (this.raiseValueCounter > 10) {
                    if (Keys.isActionPressed(1) && !Keys.isActionPressed(2)) {
                        this.raiseValueUp();
                    }
                    if (Keys.isActionPressed(2) && !Keys.isActionPressed(1)) {
                        this.raiseValueDown();
                    }
                }
            }
            if (this.raisingType != 0) {
                ++this.raiseValueCounter;
                if (this.raiseValueCounter > 10) {
                    if (this.raisingType > 0) {
                        this.raiseValueUp();
                    }
                    if (this.raisingType < 0) {
                        this.raiseValueDown();
                    }
                }
            }
        }
    }

    public void updateCommunityCardsFlip() {
        if (this.step >= 7) {
            for (int i = 0; i < 5; ++i) {
                if (this.iCommunityCardsFlipCounter[i] <= 0) continue;
                int n = i;
                this.iCommunityCardsFlipCounter[n] = this.iCommunityCardsFlipCounter[n] - 1;
                return;
            }
        }
    }

    public void updateNextScreen() {
        if (this.nextScreenStep > 0) {
            --this.nextScreenStep;
            if (this.nextScreenStep <= 0) {
                this.nextScreenStep = 0;
                if (this.bPressed) {
                    this.bPressed = false;
                }
                this.screen = this.nextScreen;
                this.selectedItem = this.nextSelectedItem;
                if (this.screen == 0) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas));
                    this.mainCanvas.repaint();
                } else {
                    this.calculatePositions();
                }
            }
        }
    }

    public void nextScreenNew(int nextScreen, int nextSelectedItem) {
        this.nextScreen = nextScreen;
        this.nextSelectedItem = nextSelectedItem;
        if (this.bPressed) {
            this.bPressed = false;
        }
        this.screen = nextScreen;
        this.selectedItem = nextSelectedItem;
        if (this.screen == 0) {
            this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas));
            this.mainCanvas.repaint();
        } else {
            this.calculatePositions();
        }
    }

    public void nextScreen(int nextScreen, int nextSelectedItem) {
        this.nextScreen = nextScreen;
        this.nextSelectedItem = nextSelectedItem;
        if (this.bPressed) {
            this.bPressed = false;
        }
        this.screen = nextScreen;
        this.selectedItem = nextSelectedItem;
        if (this.screen == 0) {
            this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas));
            this.mainCanvas.repaint();
        } else {
            this.calculatePositions();
        }
    }

    public void calculatePositions() {
        int iY;
        if (this.screen == 2 || this.screen == 3) {
            int iY2 = this.iBookedSpaceY;
            if (MainCanvas.HEIGHT <= 224) {
                iY2 = this.iBookedSpaceY >> 2;
            }
            int iHeight = MainCanvas.HEIGHT - iY2 - this.controlsBarHeight - (this.sprIcons.getHeight() >> 2);
            if (MainCanvas.HEIGHT < 260) {
                iHeight = MainCanvas.HEIGHT - iY2 - this.controlsBarHeight - (this.sprIcons.getHeight() >> 4);
            }
            iHeight += this.fontGold.getHeight();
            if (MainCanvas.HEIGHT <= 224) {
                iHeight -= this.controlsBarHeight >> 1;
            }
            if (this.screen == 3 && MainCanvas.HEIGHT >= 287 && MainCanvas.HEIGHT <= 307) {
                iHeight -= this.controlsBarHeight >> 2;
                iY2 += this.controlsBarHeight >> 4;
            }
            int iWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 5);
            if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
                iWidth = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 5);
            }
            int iX = (MainCanvas.WIDTH >> 1) - (iWidth >> 1);
            if (this.screen == 2) {
                if (MainCanvas.HEIGHT <= 224) {
                    iHeight = this.fontGoldBig.getHeight() * 18;
                    int iCenterY = (this.iBookedSpaceY >> 2) + (iHeight >> 1);
                    if (MainCanvas.HEIGHT < 200) {
                        iHeight = this.fontGoldBig.getHeight() * 16;
                        iCenterY = (this.iBookedSpaceY >> 3) + (iHeight >> 1);
                    }
                    iY2 = iCenterY - (iHeight >> 1);
                } else if (iHeight > (this.fontGoldBig.getHeight() << 2) + this.fontGold.getHeight() * 14) {
                    int iCenterY = this.iBookedSpaceY + (iHeight >> 1);
                    iHeight = (this.fontGoldBig.getHeight() << 2) + this.fontGold.getHeight() * 14;
                    iY2 = iCenterY - (iHeight >> 1);
                }
            }
            this.rectDialog = new Rectangle(iX, iY2, iWidth, iHeight);
            if (this.screen == 3) {
                iHeight -= (this.sprArrows.getHeight() << 1) + this.sprArrows.getHeight() - (this.sprArrows.getHeight() >> 2);
            }
            iWidth = this.rectDialog.width - (this.rectDialog.width >> 4);
            if (this.screen == 2) {
                iWidth -= this.sprArrows.getWidth() * 3;
            }
            iX = this.rectDialog.getCenterX() - (iWidth >> 1);
            iY2 = this.rectDialog.getCenterY() - (iHeight >> 1);
            this.rectInfo = new Rectangle(iX, iY2, iWidth, iHeight);
        } else if (this.screen == 4) {
            int iHeight = MainCanvas.HEIGHT - this.iBookedSpaceY - this.sprIcons.getHeight() - (this.sprIcons.getHeight() >> 1);
            iY = this.iBookedSpaceY + (iHeight >> 1) - this.fontBlackBig.getHeight();
            int iWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 3);
            if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
                iWidth = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 3);
            }
            int iX = (MainCanvas.WIDTH >> 1) - (iWidth >> 1);
            this.rectDialog = new Rectangle(iX, iY, iWidth, iHeight);
            iWidth = this.rectDialog.width - (this.rectDialog.width >> 4);
            iX = this.rectDialog.getCenterX() - (iWidth >> 1);
            iY = this.rectDialog.getCenterY() - (iHeight >> 1);
            this.rectInfo = new Rectangle(iX, iY, iWidth, iHeight);
        }
        String str = "";
        switch (this.screen) {
            case 2: {
                if (this.pProfile == null) {
                    this.pProfile = new Profile(this.fontGold, this.fontGoldBig, STR_COMBINATION);
                }
                this.pProfile.initSite();
                break;
            }
            case 3: {
                str = Resources.resTexts[0].getHashedString(45) + "\n\n\n";
                StringBuffer stringBuffer = new StringBuffer().append(str);
                str = str + "\n\n\n" + Resources.resTexts[0].getHashedString(48);
                str = stringBuffer.append(str).toString();
                this.pointerY = -1;
                this.textShift = 0;
                break;
            }
            case 4: {
                str = Resources.resTexts[0].getHashedString(27);
                break;
            }
        }
        if (str != null) {
            if (this.screen == 4) {
                this.preparedTextInfoBig.setTextOffsetY(0);
                this.preparedTextInfoBig.prepareText(str, this.rectInfo.width);
            } else {
                this.preparedTextInfo.setTextOffsetY(0);
                this.preparedTextInfo.prepareText(str, this.rectInfo.width);
            }
        }
        if (this.screen == 4) {
            this.rectDialog.height = this.preparedTextInfoBig.getTextHeight() + (this.fontBlackBig.getHeight() << 1);
            this.rectInfo.height = this.preparedTextInfoBig.getTextHeight();
        } else if (this.screen == 2) {
            iY = this.rectInfo.getCenterY() - (this.sprArrows.getHeight() >> 1);
            if (this.rectArrowsDialog == null) {
                this.rectArrowsDialog = new Rectangle[2];
            }
            this.rectArrowsDialog[0] = new Rectangle(this.rectInfo.x - this.sprArrows.getWidth() - (this.sprArrows.getWidth() >> 1) + (this.sprArrows.getWidth() >> 3), iY, this.sprArrows.getWidth(), this.sprArrows.getHeight());
            this.rectArrowsDialog[1] = new Rectangle(this.rectInfo.getRight() + (this.sprArrows.getWidth() >> 1) - (this.sprArrows.getWidth() >> 3), iY, this.sprArrows.getWidth(), this.sprArrows.getHeight());
            this.pProfile.set(this.rectDialog, this.rectInfo, this.rectArrowsDialog, this.preparedTextInfo);
        } else if (this.screen == 3) {
            int iX = this.rectDialog.getCenterX() - (this.sprArrows.getWidth() >> 1);
            if (this.rectArrowsInstructions == null) {
                this.rectArrowsInstructions = new Rectangle[2];
            }
            this.rectArrowsInstructions[0] = new Rectangle(iX, this.rectInfo.y - this.sprArrows.getHeight() - (this.sprArrows.getHeight() >> 3), this.sprArrows.getWidth(), this.sprArrows.getHeight());
            this.rectArrowsInstructions[1] = new Rectangle(iX, this.rectInfo.getBottom() + (this.sprArrows.getHeight() >> 3) + 1, this.sprArrows.getWidth(), this.sprArrows.getHeight());
        }
    }

    public void paint(Graphics g) {
        this.paintBg(g);
        if (this.bPause) {
            this.paintPauseMenu(g);
        } else {
            this.paintTable(g);
            this.paintStatusBar(g);
            this.paintPot(g);
            this.paintPlayers(g);
            this.paintMarkChips(g);
            this.paintBets(g);
            if (this.step >= 7) {
                this.paintHoleCards(g);
                this.paintCommunityCards(g);
                this.paintMovingHoleCards(g);
                this.paintMovingCommunityCards(g);
            }
            this.paintMovingPots(g);
            this.paintMovingBets(g);
            this.paintFoldingCards(g);
            this.paintRaiseArrows(g);
            this.paintIngameDialog(g);
            if (this.step < 0) {
                this.paintShadow(g);
            }
        }
        this.paintControls(g);
    }

    public void paintBg(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(this.imgBg, MainCanvas.WIDTH >> 1, 0, 17);
    }

    public void paintTable(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            g.drawImage(this.imgCardPlaceholderTable, COMMUNITY_CARDS_RIGHT_POS_X[i] + (this.cardWidth >> 1) - (this.imgCardPlaceholderTable.getWidth() >> 1), COMMUNITY_CARDS_RIGHT_POS_Y[i] + (this.cardHeight >> 1) - (this.imgCardPlaceholderTable.getHeight() >> 1), 20);
        }
    }

    public void paintPauseMenu(Graphics g) {
        switch (this.screen) {
            case 1: {
                this.paintLogo(g);
                this.paintPauseMain(g);
                break;
            }
            case 2: {
                if (MainCanvas.HEIGHT > 224) {
                    this.paintLogo(g);
                }
                this.paintProfile(g);
                break;
            }
            case 3: {
                if (MainCanvas.HEIGHT > 224) {
                    this.paintLogo(g);
                }
                this.paintInstructions(g);
                break;
            }
            case 4: {
                this.paintLogo(g);
                this.paintQuestion(g);
                break;
            }
        }
    }

    public void paintLogo(Graphics g) {
        g.drawImage(this.imgLogoMenu, MainCanvas.WIDTH >> 1, this.iLogoY, 17);
    }

    public void paintPauseMain(Graphics g) {
        boolean bSelected = false;
        for (int i = 0; i < 3; ++i) {
            bSelected = i == this.selectedItem && this.bPressed;
            if (bSelected) {
                this.paintBtn(g, i, true);
                if (STR_PAUSE_MENU[i] == null) continue;
                this.fontBlackBig.drawString(g, STR_PAUSE_MENU[i].toCharArray(), this.rectMenu[i].getCenterX(), this.rectMenu[i].getCenterY() - (this.fontBlackBig.getHeight() >> 1), 17);
                continue;
            }
            this.paintBtn(g, i, false);
            if (STR_PAUSE_MENU[i] == null) continue;
            this.fontGoldBig.drawString(g, STR_PAUSE_MENU[i].toCharArray(), this.rectMenu[i].getCenterX(), this.rectMenu[i].getCenterY() - (this.fontGoldBig.getHeight() >> 1), 17);
        }
    }

    public void paintBtn(Graphics g, int id, boolean bSelected) {
        if (bSelected) {
            g.drawImage(this.imgBoxLongSelected, (MainCanvas.WIDTH >> 1) - (this.imgBoxLongSelected.getWidth() >> 1), this.rectMenu[id].y, 20);
        } else {
            g.drawImage(this.imgBoxLong, (MainCanvas.WIDTH >> 1) - (this.imgBoxLong.getWidth() >> 1), this.rectMenu[id].y, 20);
        }
    }

    public void paintDialog(Graphics g) {
        if (this.rectDialog != null) {
            int i;
            int countX = (this.rectDialog.width - (this.sprDialog.getWidth() << 1)) / this.sprDialog.getWidth() + 1;
            int countY = (this.rectDialog.height - (this.sprDialog.getHeight() << 1)) / this.sprDialog.getHeight() + 1;
            int iX = this.rectDialog.x;
            int iY = this.rectDialog.y;
            this.sprDialog.setFrame(0);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
            for (i = 0; i < countY; ++i) {
                iY = i < countY - 1 ? (iY += this.sprDialog.getHeight()) : this.rectDialog.getBottom() - (this.sprDialog.getHeight() << 1);
                this.sprDialog.setFrame(3);
                this.sprDialog.setPosition(iX, iY);
                this.sprDialog.paint(g);
            }
            iY = this.rectDialog.getBottom() - this.sprDialog.getHeight();
            this.sprDialog.setFrame(6);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
            for (i = 0; i < countX; ++i) {
                iX = i < countX - 1 ? (iX += this.sprDialog.getWidth()) : this.rectDialog.getRight() - (this.sprDialog.getWidth() << 1);
                iY = this.rectDialog.y;
                this.sprDialog.setFrame(1);
                this.sprDialog.setPosition(iX, iY);
                this.sprDialog.paint(g);
                for (int j = 0; j < countY; ++j) {
                    iY = j < countY - 1 ? (iY += this.sprDialog.getHeight()) : this.rectDialog.getBottom() - (this.sprDialog.getHeight() << 1);
                    this.sprDialog.setFrame(4);
                    this.sprDialog.setPosition(iX, iY);
                    this.sprDialog.paint(g);
                }
                iY = this.rectDialog.getBottom() - this.sprDialog.getHeight();
                this.sprDialog.setFrame(7);
                this.sprDialog.setPosition(iX, iY);
                this.sprDialog.paint(g);
            }
            iX = this.rectDialog.getRight() - this.sprDialog.getWidth();
            iY = this.rectDialog.y;
            this.sprDialog.setFrame(2);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
            for (i = 0; i < countY; ++i) {
                iY = i < countY - 1 ? (iY += this.sprDialog.getHeight()) : this.rectDialog.getBottom() - (this.sprDialog.getHeight() << 1);
                this.sprDialog.setFrame(5);
                this.sprDialog.setPosition(iX, iY);
                this.sprDialog.paint(g);
            }
            iY = this.rectDialog.getBottom() - this.sprDialog.getHeight();
            this.sprDialog.setFrame(8);
            this.sprDialog.setPosition(iX, iY);
            this.sprDialog.paint(g);
        }
    }

    public void paintProfile(Graphics g) {
        this.paintDialog(g);
        this.pProfile.paint(g);
    }

    public void paintArrows(Graphics g, Rectangle rect, int iFrame, boolean bActive) {
        if (bActive) {
            this.sprArrows.setFrame(iFrame);
            this.sprArrows.setPosition(rect.x, rect.y);
            this.sprArrows.paint(g);
        } else {
            this.sprArrowsInactive.setFrame(iFrame);
            this.sprArrowsInactive.setPosition(rect.x, rect.y);
            this.sprArrowsInactive.paint(g);
        }
    }

    public void paintInstructions(Graphics g) {
        this.paintDialog(g);
        if (this.preparedTextInfo != null && this.rectInfo != null) {
            g.setClip(this.rectInfo.x, this.rectInfo.y, this.rectInfo.width, this.rectInfo.height);
            int iLines = this.preparedTextInfo.getTextHeight() / this.fontGold.getHeight();
            int iY = 0;
            String s = "";
            for (int i = 0; i < iLines; ++i) {
                if (this.preparedTextInfo.getTextHeight() <= this.fontGold.getHeight()) continue;
                s = this.preparedTextInfo.getText(i);
                iY = this.rectInfo.y + i * this.fontGold.getHeight() - this.preparedTextInfo.getTextOffsetY();
                if (iY + this.fontGold.getHeight() < this.rectInfo.y || iY > this.rectInfo.getBottom()) continue;
                this.fontGold.drawString(g, s.toCharArray(), MainCanvas.WIDTH >> 1, iY, 17);
            }
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            if (this.preparedTextInfo.getTextHeight() > this.rectInfo.height) {
                if (this.preparedTextInfo.getTextOffsetY() > 0) {
                    this.paintArrows(g, this.rectArrowsInstructions[0], 0, true);
                } else {
                    this.paintArrows(g, this.rectArrowsInstructions[0], 0, false);
                }
                if (this.preparedTextInfo.getTextOffsetY() < this.preparedTextInfo.getTextHeight() - this.rectInfo.height) {
                    this.paintArrows(g, this.rectArrowsInstructions[1], 1, true);
                } else {
                    this.paintArrows(g, this.rectArrowsInstructions[1], 1, false);
                }
            }
        }
    }

    public void paintQuestion(Graphics g) {
        this.paintDialog(g);
        if (this.preparedTextInfoBig != null && this.rectDialog != null) {
            int iHeight = this.preparedTextInfoBig.getTextHeight();
            int iLinesCount = iHeight / this.fontGoldBig.getHeight();
            int iY = this.rectDialog.getCenterY() - (iHeight >> 1);
            String str = "";
            int iStringWidth = 0;
            for (int i = 0; i < iLinesCount; ++i) {
                str = this.preparedTextInfoBig.getText(i);
                iStringWidth = this.fontGoldBig.stringWidth(str.toCharArray());
                this.fontGoldBig.drawString(g, str.toCharArray(), this.rectDialog.getCenterX() - (iStringWidth >> 1), iY, 20);
                iY += this.fontGoldBig.getHeight();
            }
        }
    }

    public void paintStatusBar(Graphics g) {
        int pomSpaceX;
        int pomBoxWidth = this.imgBoxShort.getWidth();
        if (this.imgPotBoxBlack != null) {
            pomBoxWidth = this.imgPotBoxBlack.getWidth();
        }
        int x = pomSpaceX = (MainCanvas.WIDTH - this.imgBoxLong.getWidth() - pomBoxWidth) / 3;
        if (pomSpaceX > this.statusBarHeight >> 1) {
            pomSpaceX = this.statusBarHeight >> 1;
            x = (MainCanvas.WIDTH >> 1) - (this.imgBoxLong.getWidth() + pomBoxWidth + pomSpaceX >> 1);
        }
        int y = (this.statusBarHeight >> 1) - (this.imgBoxLong.getHeight() >> 1);
        if (MainCanvas.HEIGHT <= 320 || this.isSmallAspectRatio()) {
            --y;
        }
        int shiftX = this.fontGoldBig.getSpaceWidth();
        g.drawImage(this.imgBoxLong, x, y, 20);
        this.fontGold.drawString(g, (strLevel + " " + (Scores.level + 1)).toCharArray(), x + shiftX, y + (this.imgBoxLong.getHeight() >> 1) - (this.fontGold.getHeight() >> 1), 20);
        this.fontGold.drawString(g, (Scores.xp + " " + strXP).toCharArray(), x + this.imgBoxLong.getWidth() - shiftX, y + (this.imgBoxLong.getHeight() >> 1) - (this.fontGold.getHeight() >> 1), 24);
    }

    public void paintPot(Graphics g) {
        if (this.step > 0) {
            int shiftX = this.fontGoldBig.getSpaceWidth();
            if (this.bPotBlink) {
                if (this.imgPotBoxGold != null) {
                    g.drawImage(this.imgPotBoxGold, this.potX, this.potY, 20);
                    this.fontBlack.drawString(g, strPot.toCharArray(), this.potX + shiftX, this.potY + (this.imgPotBoxGold.getHeight() >> 1) - (this.fontBlack.getHeight() >> 1), 20);
                    this.fontBlackBig.drawString(g, (this.pot + "").toCharArray(), this.potX + this.imgPotBoxGold.getWidth() - shiftX, this.potY + (this.imgPotBoxGold.getHeight() >> 1) - (this.fontBlackBig.getHeight() >> 1), 24);
                } else {
                    g.drawImage(this.imgBoxShortSelected, this.potX, this.potY, 20);
                    this.fontBlack.drawString(g, strPot.toCharArray(), this.potX + shiftX, this.potY + (this.imgBoxShortSelected.getHeight() >> 1) - (this.fontBlack.getHeight() >> 1), 20);
                    this.fontBlackBig.drawString(g, (this.pot + "").toCharArray(), this.potX + this.imgBoxShortSelected.getWidth() - shiftX, this.potY + (this.imgBoxShortSelected.getHeight() >> 1) - (this.fontBlackBig.getHeight() >> 1), 24);
                }
            } else if (this.imgPotBoxBlack != null) {
                g.drawImage(this.imgPotBoxBlack, this.potX, this.potY, 20);
                this.fontGold.drawString(g, strPot.toCharArray(), this.potX + shiftX, this.potY + (this.imgPotBoxBlack.getHeight() >> 1) - (this.fontGold.getHeight() >> 1), 20);
                this.fontGoldBig.drawString(g, (this.pot + "").toCharArray(), this.potX + this.imgPotBoxBlack.getWidth() - shiftX, this.potY + (this.imgPotBoxBlack.getHeight() >> 1) - (this.fontGoldBig.getHeight() >> 1), 24);
            } else {
                g.drawImage(this.imgBoxShort, this.potX, this.potY, 20);
                this.fontGold.drawString(g, strPot.toCharArray(), this.potX + shiftX, this.potY + (this.imgBoxShort.getHeight() >> 1) - (this.fontGold.getHeight() >> 1), 20);
                this.fontGoldBig.drawString(g, (this.pot + "").toCharArray(), this.potX + this.imgBoxShort.getWidth() - shiftX, this.potY + (this.imgBoxShort.getHeight() >> 1) - (this.fontGoldBig.getHeight() >> 1), 24);
            }
        }
    }

    public void paintMovingPots(Graphics g) {
        if (this.step >= 5 && this.bMovingPot) {
            for (int j = 0; j < this.players; ++j) {
                if (WINNER[j] != 1 || POT_X[j] == POT_RIGHT_POS_X[j] && POT_Y[j] == POT_RIGHT_POS_Y[j]) continue;
                g.drawImage(this.imgBoxSlimSelected, POT_X[j], POT_Y[j], 20);
                int stringWidth = this.fontBlack.stringWidth((this.movingPotValue + "").toCharArray());
                int x = POT_X[j] + (this.imgBoxSlimSelected.getWidth() >> 1) - (stringWidth >> 1);
                int y = POT_Y[j] + (this.imgBoxSlimSelected.getHeight() >> 1) - (this.fontBlack.getHeight() >> 1);
                this.fontBlack.drawString(g, (this.movingPotValue + "").toCharArray(), x, y, 20);
            }
        }
    }

    public void paintBets(Graphics g) {
        if (this.step >= 5 && !this.bMovingBets) {
            for (int i = 0; i < this.players; ++i) {
                if (BETS[i] <= 0) continue;
                g.drawImage(this.imgBoxSlimSelected, BETS_X[i], BETS_Y[i], 20);
                int stringWidth = this.fontBlack.stringWidth((BETS[i] + "").toCharArray());
                int x = BETS_X[i] + (this.imgBoxSlimSelected.getWidth() >> 1) - (stringWidth >> 1);
                int y = BETS_Y[i] + (this.imgBoxSlimSelected.getHeight() >> 1) - (this.fontBlack.getHeight() >> 1);
                this.fontBlack.drawString(g, (BETS[i] + "").toCharArray(), x, y, 20);
            }
        }
    }

    public void paintMovingBets(Graphics g) {
        if (this.step >= 5) {
            int y;
            int x;
            int stringWidth;
            int i;
            if (this.bMovingBets) {
                for (i = 0; i < this.players; ++i) {
                    if (BETS[i] <= 0 || BETS_X[i] == this.pomPotX && BETS_Y[i] == this.pomPotY) continue;
                    g.drawImage(this.imgBoxSlimSelected, BETS_X[i], BETS_Y[i], 20);
                    stringWidth = this.fontBlack.stringWidth((BETS[i] + "").toCharArray());
                    x = BETS_X[i] + (this.imgBoxSlimSelected.getWidth() >> 1) - (stringWidth >> 1);
                    y = BETS_Y[i] + (this.imgBoxSlimSelected.getHeight() >> 1) - (this.fontBlack.getHeight() >> 1);
                    this.fontBlack.drawString(g, (BETS[i] + "").toCharArray(), x, y, 20);
                }
            }
            if (this.bMovingBet) {
                for (i = 0; i < this.players; ++i) {
                    if (BET[i] <= 0) continue;
                    g.drawImage(this.imgBoxSlimSelected, BET_X[i], BET_Y[i], 20);
                    stringWidth = this.fontBlack.stringWidth((BET[i] + "").toCharArray());
                    x = BET_X[i] + (this.imgBoxSlimSelected.getWidth() >> 1) - (stringWidth >> 1);
                    y = BET_Y[i] + (this.imgBoxSlimSelected.getHeight() >> 1) - (this.fontBlack.getHeight() >> 1);
                    this.fontBlack.drawString(g, (BET[i] + "").toCharArray(), x, y, 20);
                }
            }
        }
    }

    public void paintIngameDialog(Graphics g) {
        if (this.bDialogActive) {
            this.paintShadow(g);
            this.paintDialog(g);
            if (this.rectDialog != null) {
                int iTotalTextHeight = 0;
                int iLines = 0;
                int iStringWidth = 0;
                if (this.step == 0 || this.step == 1) {
                    iTotalTextHeight = this.prepText1.getTextHeight() + this.fontGold.getHeight() + this.sprArrows.getHeight();
                    iLines = this.prepText1.getTextHeight() / this.fontGoldBig.getHeight();
                    String s = "";
                    int y = this.rectDialog.getCenterY() - (iTotalTextHeight >> 1);
                    for (int i = 0; i < iLines; ++i) {
                        s = this.prepText1.getText(i);
                        iStringWidth = this.fontGoldBig.stringWidth(s.toCharArray());
                        this.fontGoldBig.drawString(g, s.toCharArray(), (MainCanvas.WIDTH >> 1) - (iStringWidth >> 1), y, 20);
                        y += this.fontGoldBig.getHeight();
                    }
                    y = this.rectDialog.getCenterY() + (iTotalTextHeight >> 1) - (this.sprArrows.getHeight() >> 1) - (this.fontGoldBig.getHeight() >> 1);
                    s = this.prepText2.getText();
                    iStringWidth = this.fontGoldBig.stringWidth(s.toCharArray());
                    this.fontGoldBig.drawString(g, s.toCharArray(), (MainCanvas.WIDTH >> 1) - (iStringWidth >> 1), y, 20);
                } else {
                    iTotalTextHeight = this.prepText1.getTextHeight();
                    int y = this.rectDialog.getCenterY() - (iTotalTextHeight >> 1);
                    if (this.step == 17) {
                        int x = (MainCanvas.WIDTH >> 1) - (this.sprWinChip.getWidth() >> 1);
                        y = this.rectDialog.getCenterY() - ((iTotalTextHeight += this.sprWinChip.getHeight() + this.fontGoldBig.getHeight()) >> 1);
                        this.sprWinChip.setFrame(this.winChipFrame);
                        this.sprWinChip.setPosition(x, y);
                        this.sprWinChip.paint(g);
                        y = this.rectDialog.getCenterY() + (iTotalTextHeight >> 1) - this.prepText1.getTextHeight();
                    }
                    iLines = this.prepText1.getTextHeight() / this.fontGoldBig.getHeight();
                    String s = "";
                    for (int i = 0; i < iLines; ++i) {
                        s = this.prepText1.getText(i);
                        iStringWidth = this.fontGoldBig.stringWidth(s.toCharArray());
                        this.fontGoldBig.drawString(g, s.toCharArray(), (MainCanvas.WIDTH >> 1) - (iStringWidth >> 1), y, 20);
                        y += this.fontGoldBig.getHeight();
                    }
                }
                if (this.step == 0) {
                    if (this.players > 2) {
                        this.paintArrows(g, this.rectArrowsDialog[0], 2, true);
                    } else {
                        this.paintArrows(g, this.rectArrowsDialog[0], 2, false);
                    }
                    if (this.players < 5) {
                        this.paintArrows(g, this.rectArrowsDialog[1], 3, true);
                    } else {
                        this.paintArrows(g, this.rectArrowsDialog[1], 3, false);
                    }
                } else if (this.step == 1) {
                    if (this.blindsPointer > 0) {
                        this.paintArrows(g, this.rectArrowsDialog[0], 2, true);
                    } else {
                        this.paintArrows(g, this.rectArrowsDialog[0], 2, false);
                    }
                    if (this.blindsPointer < this.maxBlinds) {
                        this.paintArrows(g, this.rectArrowsDialog[1], 3, true);
                    } else {
                        this.paintArrows(g, this.rectArrowsDialog[1], 3, false);
                    }
                }
            }
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
    }

    public void paintShadow(Graphics g) {
        int countX = MainCanvas.WIDTH / this.imgShadow.getWidth() + 1;
        int countY = MainCanvas.HEIGHT / this.imgShadow.getHeight() + 1;
        for (int i = 0; i < countX; ++i) {
            for (int j = 0; j < countY; ++j) {
                g.drawImage(this.imgShadow, i * this.imgShadow.getWidth(), j * this.imgShadow.getHeight(), 20);
            }
        }
    }

    public void paintPlayers(Graphics g) {
        if (this.step >= 1 || this.hand > 0) {
            for (int i = 0; i < this.players; ++i) {
                if (this.pPlayer[i] == null || CHIPS[i] + BETS[i] + BET[i] < this.bbValue && ACTIVE[i] != 1) continue;
                if (i == 0) {
                    int pomCallValue = this.highestBet - BETS[this.actualPlayer] - BET[this.actualPlayer];
                    if (CHIPS[this.actualPlayer] <= pomCallValue) {
                        pomCallValue = CHIPS[this.actualPlayer];
                    }
                    if (this.highlightedPlayer == i) {
                        this.pPlayer[i].paintUser(g, CHIPS[i], true, STR_ACTION[ACTION[i]], STR_ACTION[this.playersSelection], this.pomRaiseValue, this.bChipBlink[i], pomCallValue);
                        continue;
                    }
                    if (ACTIVE[i] == 0) {
                        this.pPlayer[i].paintUser(g, CHIPS[i], false, STR_ACTION[1], STR_ACTION[this.playersSelection], this.pomRaiseValue, this.bChipBlink[i], pomCallValue);
                        continue;
                    }
                    this.pPlayer[i].paintUser(g, CHIPS[i], false, STR_ACTION[ACTION[i]], STR_ACTION[this.playersSelection], this.pomRaiseValue, this.bChipBlink[i], pomCallValue);
                    continue;
                }
                if (this.highlightedPlayer == i) {
                    this.pPlayer[i].paintRival(g, CHIPS[i], true, STR_ACTION[ACTION[i]], this.bChipBlink[i]);
                    continue;
                }
                if (ACTIVE[i] == 0) {
                    this.pPlayer[i].paintRival(g, CHIPS[i], false, STR_ACTION[1], this.bChipBlink[i]);
                    continue;
                }
                this.pPlayer[i].paintRival(g, CHIPS[i], false, STR_ACTION[ACTION[i]], this.bChipBlink[i]);
            }
        }
    }

    public void paintRaiseArrows(Graphics g) {
        if ((this.bWaitingForPlayer || this.bContextMenuIn || this.bContextMenuOut) && (this.playersSelection == 5 || this.playersSelection == 3) && this.maxRaiseValue > this.minRaiseValue && this.pomRaiseValue > 0 && this.pPlayer[0] != null) {
            int x = this.rectArrowsContextRaise[0].getCenterX() - (this.imgRaiseBox.getWidth() >> 1);
            int y = this.rectArrowsContextRaise[0].getBottom() - (this.imgRaiseBox.getHeight() >> 1);
            g.drawImage(this.imgRaiseBox, x, y, 20);
            if (this.pomRaiseValue < this.maxRaiseValue) {
                this.pPlayer[0].paintRaiseArrow(g, 0, true, this.rectArrowsContextRaise[0].x, this.rectArrowsContextRaise[0].y);
            } else {
                this.pPlayer[0].paintRaiseArrow(g, 0, false, this.rectArrowsContextRaise[0].x, this.rectArrowsContextRaise[0].y);
            }
            if (this.pomRaiseValue > this.minRaiseValue) {
                this.pPlayer[0].paintRaiseArrow(g, 1, true, this.rectArrowsContextRaise[1].x, this.rectArrowsContextRaise[1].y);
            } else {
                this.pPlayer[0].paintRaiseArrow(g, 1, false, this.rectArrowsContextRaise[1].x, this.rectArrowsContextRaise[1].y);
            }
        }
    }

    public void paintMarkChips(Graphics g) {
        if (this.step >= 2 || this.hand > 0) {
            int shiftY = 0;
            for (int i = 0; i < 3; ++i) {
                shiftY = i == 0 && this.dealer == 0 || i == 1 && this.smallBlind == 0 || i == 2 && this.bigBlind == 0 ? MainCanvas.HEIGHT - this.contextMenuY : 0;
                this.sprChips.setFrame(i);
                this.sprChips.setPosition(CHIP_X[i], CHIP_Y[i] - shiftY);
                this.sprChips.paint(g);
            }
        }
    }

    public void paintFoldingCards(Graphics g) {
        if (this.step >= 7 && this.bFoldingCards) {
            int player = 0;
            for (int i = 0; i < HOLE_CARDS.length; ++i) {
                player = i / 2;
                if (ACTIVE[player] != 1 || ACTION[player] != 1 || HOLE_CARDS[i] == -1 || CARDS_X[i] == MainCanvas.WIDTH && CARDS_Y[i] == MainCanvas.HEIGHT) continue;
                g.drawImage(this.imgCardBack, CARDS_X[i], CARDS_Y[i], 20);
            }
        }
    }

    public void paintHoleCards(Graphics g) {
        int i;
        int player = 0;
        int shiftY = 0;
        for (i = 0; i < HOLE_CARDS.length; ++i) {
            player = i / 2;
            shiftY = player == 0 ? MainCanvas.HEIGHT - this.contextMenuY : (MainCanvas.HEIGHT <= 320 || this.isSmallAspectRatio() ? -1 : 0);
            if (ACTIVE[player] != 1 || ACTION[player] == 1 || HOLE_CARDS[i] == -1 || CARDS_X[i] != CARDS_RIGHT_POS_X[i] || CARDS_Y[i] != CARDS_RIGHT_POS_Y[i]) continue;
            if (this.step != 7 && SHOWN_CARDS[player] == 1) {
                this.sprCards.setFrame((int)HOLE_CARDS[i]);
                this.sprCards.setPosition(CARDS_X[i], CARDS_Y[i] - shiftY);
                this.sprCards.paint(g);
                continue;
            }
            g.drawImage(this.imgCardBack, CARDS_X[i], CARDS_Y[i] - shiftY, 20);
        }
        if (!this.bOneActivePlayer) {
            for (i = 0; i < HOLE_CARDS.length; ++i) {
                player = i / 2;
                shiftY = player == 0 ? MainCanvas.HEIGHT - this.contextMenuY : (MainCanvas.HEIGHT <= 320 || this.isSmallAspectRatio() ? -1 : 0);
                if (ACTIVE[player] != 1 || ACTION[player] == 1 || HOLE_CARDS[i] == -1 || this.step == 7 || SHOWN_CARDS[player] != 1 || !this.bEndDialog || WINNER[player] != 1) continue;
                boolean isOK = false;
                for (int j = 0; j < 5; ++j) {
                    if (SORTED_CARDS[player * 7 + j] != HOLE_CARDS[i]) continue;
                    isOK = true;
                    break;
                }
                if (!isOK) continue;
                g.drawImage(this.imgCardSelector, CARDS_X[i] + (this.cardWidth >> 1) - (this.imgCardSelector.getWidth() >> 1), CARDS_Y[i] + (this.cardHeight >> 1) - (this.imgCardSelector.getHeight() >> 1) - shiftY, 20);
            }
        }
    }

    public void paintMovingHoleCards(Graphics g) {
        int player = 0;
        int shiftY = 0;
        for (int i = 0; i < HOLE_CARDS.length; ++i) {
            player = i / 2;
            shiftY = player == 0 ? MainCanvas.HEIGHT - this.contextMenuY : 0;
            if (ACTIVE[player] != 1 || ACTION[player] == 1 || HOLE_CARDS[i] == -1 || CARDS_X[i] == CARDS_RIGHT_POS_X[i] && CARDS_Y[i] == CARDS_RIGHT_POS_Y[i]) continue;
            if (this.step != 7 && SHOWN_CARDS[player] == 1) {
                this.sprCards.setFrame((int)HOLE_CARDS[i]);
                this.sprCards.setPosition(CARDS_X[i], CARDS_Y[i] - shiftY);
                this.sprCards.paint(g);
                continue;
            }
            g.drawImage(this.imgCardBack, CARDS_X[i], CARDS_Y[i] - shiftY, 20);
        }
    }

    public void paintCommunityCards(Graphics g) {
        int i;
        for (i = 0; i < COMMUNITY_CARDS.length; ++i) {
            if (COMMUNITY_CARDS[i] == -1 || COMMUNITY_CARDS_X[i] != COMMUNITY_CARDS_RIGHT_POS_X[i] || COMMUNITY_CARDS_Y[i] != COMMUNITY_CARDS_RIGHT_POS_Y[i]) continue;
            if (this.iCommunityCardsFlipCounter[i] > 0) {
                g.drawImage(this.imgCardBack, COMMUNITY_CARDS_X[i], COMMUNITY_CARDS_Y[i], 20);
                continue;
            }
            this.sprCards.setFrame((int)COMMUNITY_CARDS[i]);
            this.sprCards.setPosition(COMMUNITY_CARDS_X[i], COMMUNITY_CARDS_Y[i]);
            this.sprCards.paint(g);
        }
        if (!this.bOneActivePlayer) {
            for (i = 0; i < COMMUNITY_CARDS.length; ++i) {
                if (COMMUNITY_CARDS[i] == -1 || !this.bEndDialog) continue;
                for (int k = 0; k < this.players; ++k) {
                    if (WINNER[k] != 1) continue;
                    boolean isOK = false;
                    for (int j = 0; j < 5; ++j) {
                        if (SORTED_CARDS[k * 7 + j] != COMMUNITY_CARDS[i]) continue;
                        isOK = true;
                        break;
                    }
                    if (!isOK) continue;
                    g.drawImage(this.imgCardSelector, COMMUNITY_CARDS_X[i] + (this.cardWidth >> 1) - (this.imgCardSelector.getWidth() >> 1), COMMUNITY_CARDS_Y[i] + (this.cardHeight >> 1) - (this.imgCardSelector.getHeight() >> 1), 20);
                }
            }
        }
    }

    public void paintMovingCommunityCards(Graphics g) {
        for (int i = 0; i < COMMUNITY_CARDS.length; ++i) {
            if (COMMUNITY_CARDS[i] == -1 || COMMUNITY_CARDS_X[i] == COMMUNITY_CARDS_RIGHT_POS_X[i] && COMMUNITY_CARDS_Y[i] == COMMUNITY_CARDS_RIGHT_POS_Y[i]) continue;
            if (this.iCommunityCardsFlipCounter[i] > 0) {
                g.drawImage(this.imgCardBack, COMMUNITY_CARDS_X[i], COMMUNITY_CARDS_Y[i], 20);
                continue;
            }
            this.sprCards.setFrame((int)COMMUNITY_CARDS[i]);
            this.sprCards.setPosition(COMMUNITY_CARDS_X[i], COMMUNITY_CARDS_Y[i]);
            this.sprCards.paint(g);
        }
    }

    public void paintControls(Graphics g) {
        if (this.bPause) {
            switch (this.screen) {
                case 1: 
                case 2: 
                case 3: {
                    this.sprIcons.setFrame(8);
                    this.sprIcons.setPosition(this.rectControls[1].x, this.rectControls[1].y);
                    this.sprIcons.paint(g);
                    break;
                }
                case 4: {
                    this.sprIcons.setFrame(7);
                    this.sprIcons.setPosition(this.rectControls[0].x, this.rectControls[0].y);
                    this.sprIcons.paint(g);
                    this.sprIcons.setFrame(6);
                    this.sprIcons.setPosition(this.rectControls[1].x, this.rectControls[1].y);
                    this.sprIcons.paint(g);
                    break;
                }
            }
        } else {
            boolean isShowed = false;
            switch (this.step) {
                case 0: 
                case 1: {
                    if (!this.bDialogActive) break;
                    isShowed = true;
                    break;
                }
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    if (!this.bWaitingForPlayer) break;
                    isShowed = true;
                    break;
                }
            }
            if (isShowed) {
                this.sprIcons.setFrame(7);
                this.sprIcons.setPosition(this.rectControls[0].x, this.rectControls[0].y);
                this.sprIcons.paint(g);
            } else if (!this.bSkip && this.showSkipButton()) {
                this.sprIcons.setFrame(14);
                this.sprIcons.setPosition(this.rectControls[0].x, this.rectControls[0].y);
                this.sprIcons.paint(g);
            }
            if (this.step > -1 && this.step < 16) {
                this.sprIcons.setFrame(11);
                this.sprIcons.setPosition(this.rectControls[1].x, this.rectControls[1].y);
                this.sprIcons.paint(g);
            }
        }
    }

    public void paintScore(Graphics g) {
        int iSpace = this.fontBlack.getSpaceWidth() >> 1;
        this.fontBlack.drawString(g, (strLevel + " " + (Scores.level + 1)).toCharArray(), iSpace, iSpace >> 1, 20);
        this.fontBlack.drawString(g, (Scores.xp + " " + strXP).toCharArray(), MainCanvas.WIDTH - iSpace, iSpace >> 1, 24);
    }

    public boolean showSkipButton() {
        return this.bShowSkipButton && !this.bSkip && !this.bContextMenuIn && !this.bContextMenuOut && this.step >= 8 && this.step <= 15;
    }

    public void keyPressed(int keyCode) {
    }

    public void down() {
        if (this.screen == 1) {
            this.selectedItem = this.selectedItem < 2 ? ++this.selectedItem : 0;
        }
    }

    public void up() {
        if (this.screen == 1) {
            this.selectedItem = this.selectedItem > 0 ? --this.selectedItem : 2;
        }
    }

    public void confirm() {
        if (this.nextScreenStep <= 0) {
            block0 : switch (this.screen) {
                case 1: {
                    switch (this.selectedItem) {
                        case 0: {
                            this.nextScreen(2, this.selectedItem);
                            break block0;
                        }
                        case 1: {
                            this.nextScreen(3, this.selectedItem);
                            break block0;
                        }
                        case 2: {
                            this.nextScreen(4, this.selectedItem);
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas));
                    this.mainCanvas.repaint();
                    break;
                }
            }
        }
    }

    public void back() {
        if (this.nextScreenStep <= 0) {
            switch (this.screen) {
                case 0: {
                    this.pause();
                    break;
                }
                case 1: {
                    this.unpause();
                    break;
                }
                case 2: {
                    this.nextScreen(1, 0);
                    break;
                }
                case 3: {
                    this.nextScreen(1, 1);
                    break;
                }
                case 4: {
                    this.nextScreen(1, 2);
                    break;
                }
            }
        }
    }

    public void initEndDialog() {
        if (!this.bEndDialog) {
            ++this.endDialogPointer;
            this.endDialogCounter = this.endDialogPointer == 0 || this.endDialogPointer == 1 || this.endDialogPointer == 3 ? 15 : 300;
            this.bEndDialog = true;
        }
    }

    public void updateEndDialog() {
        if (this.bEndDialog) {
            if (this.endDialogCounter > 0) {
                --this.endDialogCounter;
            } else {
                this.bEndDialog = false;
                this.endDialogFinish();
            }
        }
    }

    public void endDialogFinish() {
        if (this.step == 17) {
            SavedGame.delete();
            Scores.addGamesPlayed();
            if (Scores.getAbsoluteWinner()) {
                Scores.addGamesWon();
                Scores.addXP(100);
            } else {
                Scores.initActualGamesWonInRow();
                Scores.addXP(15);
            }
            Scores.initWinsSum();
            Scores.initAbsoluteWinner();
            Scores.checkNewLevel();
            Scores.save();
            this.closeDialog();
            this.nextScreenNew(0, 0);
        } else if (this.endDialogPointer <= 1) {
            this.openDialog();
            this.initEndDialog();
        } else if (this.endDialogPointer == 2) {
            this.closeDialog();
            this.initMovePot();
        } else {
            this.initDropCards();
        }
    }

    public void initIdentifyWinners() {
        if (this.pot > 0) {
            this.identifyWinnersCounter = 15;
            this.bIdentifyWinners = true;
        } else {
            this.initEndDialog();
        }
    }

    public void updateIdentifyWinners() {
        if (this.bIdentifyWinners) {
            if (this.identifyWinnersCounter > 0) {
                --this.identifyWinnersCounter;
            } else {
                this.bIdentifyWinners = false;
                this.endDialogPointer = 0;
                this.identifyWinners(true);
            }
        }
    }

    public void setPotsPos() {
        POT_X = new int[this.players];
        POT_Y = new int[this.players];
        POT_RIGHT_POS_X = new int[this.players];
        POT_RIGHT_POS_Y = new int[this.players];
        for (int i = 0; i < this.players; ++i) {
            ScreenGame.POT_X[i] = -1;
            ScreenGame.POT_Y[i] = -1;
            ScreenGame.POT_RIGHT_POS_X[i] = this.pPlayer[i].getChipsValueX();
            ScreenGame.POT_RIGHT_POS_Y[i] = this.pPlayer[i].getChipsValueY();
        }
    }

    public void initMovePot() {
        int i;
        this.highlightedPlayer = -1;
        for (i = 0; i < this.players; ++i) {
            if (WINNER[i] != 1) continue;
            ScreenGame.POT_X[i] = this.pomPotX;
            ScreenGame.POT_Y[i] = this.pomPotY;
        }
        if (this.winnersCount <= 0) {
            this.winnersCount = 0;
            for (i = 0; i < this.players; ++i) {
                if (WINNER[i] != 1) continue;
                ++this.winnersCount;
            }
            this.movingPotPom = this.pot;
            ScreenGame.POT[0] = 0;
        }
        if (this.winnersCount >= 1) {
            this.movingPotValue = this.movingPotPom / this.winnersCount;
            this.pot -= this.movingPotPom;
            if (WINNER[0] == 1) {
                Scores.addWinsSum(this.movingPotValue);
            }
            POT_TEMP = new int[POT.length];
            for (i = 0; i < POT.length; ++i) {
                ScreenGame.POT_TEMP[i] = POT[i];
            }
            this.bMovingPot = true;
        } else {
            System.out.println("Exception> the number of winners is less than 1");
            this.initIdentifyWinners();
        }
    }

    public void updatePots() {
        if (this.bMovingPot && !this.bDialogActive) {
            int i;
            boolean isOK = true;
            for (i = 0; i < this.players; ++i) {
                if (WINNER[i] != 1 || POT_X[i] == POT_RIGHT_POS_X[i] && POT_Y[i] == POT_RIGHT_POS_Y[i]) continue;
                isOK = false;
                this.ddaPot(i);
            }
            if (isOK) {
                this.bMovingPot = false;
                for (i = 0; i < this.players; ++i) {
                    if (WINNER[i] != 1) continue;
                    int n = i;
                    CHIPS[n] = CHIPS[n] + this.movingPotValue;
                    ScreenGame.WINNER[i] = -1;
                }
                this.movingPotValue = 0;
                this.initIdentifyWinners();
            }
        }
    }

    public void confirmSelection() {
        switch (this.playersSelection) {
            case 2: {
                this.check();
                break;
            }
            case 4: {
                this.call();
                break;
            }
            case 5: {
                this.raise();
                break;
            }
            case 3: {
                this.bet();
                break;
            }
            case 1: {
                this.fold();
                break;
            }
        }
    }

    public void raiseValueDown() {
        if (this.pomRaiseValue > this.minRaiseValue) {
            int pomStep;
            int pom = this.raiseValueCounter / 10;
            int n = pomStep = pom <= 1 ? this.sbValue : this.sbValue << pom - 1;
            if (this.pomRaiseValue - pomStep > this.minRaiseValue) {
                if (this.pomRaiseValue == this.maxRaiseValue && this.pomRaiseValue % this.sbValue != 0) {
                    this.pomRaiseValue = this.pomRaiseValue / this.sbValue * this.sbValue;
                } else {
                    this.pomRaiseValue -= pomStep;
                    if (this.pomRaiseValue % this.sbValue != 0) {
                        this.pomRaiseValue = this.pomRaiseValue / this.sbValue * this.sbValue;
                    }
                }
            } else {
                this.pomRaiseValue = this.minRaiseValue;
            }
        }
    }

    public void raiseValueUp() {
        if (this.pomRaiseValue < this.maxRaiseValue) {
            int pomStep;
            int pom = this.raiseValueCounter / 10;
            int n = pomStep = pom <= 1 ? this.sbValue : this.sbValue << pom - 1;
            if (this.pomRaiseValue + pomStep < this.maxRaiseValue) {
                this.pomRaiseValue += pomStep;
                if (this.pomRaiseValue % this.sbValue != 0) {
                    this.pomRaiseValue = this.pomRaiseValue / this.sbValue * this.sbValue;
                }
            } else {
                this.pomRaiseValue = this.maxRaiseValue;
            }
        }
    }

    public int getRemainingBettingPlayers() {
        int iRemainingBettingPlayers = 0;
        for (int i = 0; i < this.players; ++i) {
            if (ACTIVE[i] != 1 || ACTION[i] == 6 || ACTION[i] == 1) continue;
            ++iRemainingBettingPlayers;
        }
        return iRemainingBettingPlayers;
    }

    public void contextMenuLeft() {
        switch (this.step) {
            case 8: {
                if (this.playersSelection == 1) {
                    if (CHIPS[0] + BETS[0] <= this.highestBet || CHIPS[0] <= 0 || this.getRemainingBettingPlayers() <= 1) {
                        if (this.bRaise) {
                            this.playersSelection = 4;
                            break;
                        }
                        this.playersSelection = 2;
                        break;
                    }
                    this.playersSelection = 5;
                    break;
                }
                if (this.playersSelection == 5) {
                    if (this.bRaise) {
                        this.playersSelection = 4;
                        break;
                    }
                    this.playersSelection = 2;
                    break;
                }
                this.playersSelection = 1;
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                if (this.playersSelection == 1) {
                    if (CHIPS[0] + BETS[0] <= this.highestBet || CHIPS[0] <= 0 || this.getRemainingBettingPlayers() <= 1) {
                        if (this.bRaise) {
                            this.playersSelection = 4;
                            break;
                        }
                        this.playersSelection = 2;
                        break;
                    }
                    if (this.bRaise || BETS[this.actualPlayer] > 0) {
                        this.playersSelection = 5;
                        break;
                    }
                    this.playersSelection = 3;
                    break;
                }
                if (this.playersSelection == 5 || this.playersSelection == 3) {
                    if (this.bRaise) {
                        this.playersSelection = 4;
                        break;
                    }
                    this.playersSelection = 2;
                    break;
                }
                this.playersSelection = 1;
                break;
            }
        }
    }

    public void contextMenuRight() {
        switch (this.step) {
            case 8: {
                if (this.playersSelection == 5) {
                    this.playersSelection = 1;
                    break;
                }
                if (this.playersSelection == 1) {
                    if (this.bRaise) {
                        this.playersSelection = 4;
                        break;
                    }
                    this.playersSelection = 2;
                    break;
                }
                if (CHIPS[0] + BETS[0] <= this.highestBet || CHIPS[0] <= 0 || this.getRemainingBettingPlayers() <= 1) {
                    this.playersSelection = 1;
                    break;
                }
                this.playersSelection = 5;
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                if (this.playersSelection == 1) {
                    if (this.bRaise) {
                        this.playersSelection = 4;
                        break;
                    }
                    this.playersSelection = 2;
                    break;
                }
                if (this.playersSelection == 2 || this.playersSelection == 4) {
                    if (CHIPS[0] + BETS[0] <= this.highestBet || CHIPS[0] <= 0 || this.getRemainingBettingPlayers() <= 1) {
                        this.playersSelection = 1;
                        break;
                    }
                    if (this.bRaise || BETS[this.actualPlayer] > 0) {
                        this.playersSelection = 5;
                        break;
                    }
                    this.playersSelection = 3;
                    break;
                }
                this.playersSelection = 1;
                break;
            }
        }
    }

    public void setRaiseValueInterval() {
        this.minRaiseValue = this.highestBet + this.sbValue;
        this.maxRaiseValue = 0;
        for (int i = 0; i < this.players; ++i) {
            int pom;
            if (i == this.actualPlayer || ACTIVE[i] != 1 || ACTION[i] == 1 || (pom = CHIPS[i] + BETS[i] + BET[i] - BETS[this.actualPlayer] - BET[this.actualPlayer]) <= this.maxRaiseValue) continue;
            this.maxRaiseValue = pom;
        }
        if (this.maxRaiseValue > CHIPS[this.actualPlayer]) {
            this.maxRaiseValue = CHIPS[this.actualPlayer];
        }
        if (this.bRaise) {
            if (this.minRaiseValue < this.sbValue + this.bbValue) {
                this.minRaiseValue = this.sbValue + this.bbValue;
            }
        } else if (this.minRaiseValue < this.bbValue) {
            this.minRaiseValue = this.bbValue;
        }
        if (this.minRaiseValue > this.maxRaiseValue) {
            this.minRaiseValue = this.maxRaiseValue;
        }
    }

    public void initContextMenu() {
        this.pomRaiseValue = this.minRaiseValue;
        this.playersSelection = this.bRaise ? 4 : 2;
        this.bWaitingForPlayer = true;
        this.openContextMenu();
    }

    public void pause() {
        if (this.step > -1) {
            if (this.step < 16) {
                Scores.addTime(this.pomTime, this.time);
                Scores.save();
                this.screen = 1;
                this.selectedItem = 0;
                this.bPause = true;
                if (this.step > 0) {
                    this.saveGame();
                }
            } else if (this.step == 16 && POT_TEMP != null) {
                this.pot = 0;
                for (int i = 0; i < POT.length; ++i) {
                    ScreenGame.POT[i] = POT_TEMP[i];
                    this.pot += POT[i];
                }
            }
        }
    }

    public void unpause() {
        this.initTime();
        this.closeDialog();
        if (!(this.step != 0 && this.step != 1 && this.step != 16 && this.step != 17 || this.bNextStep)) {
            if (this.step == 0) {
                this.initNumberOfOpponentsDialog();
            } else if (this.step == 1) {
                if (this.maxBlinds > 0) {
                    this.initBlindsValuesDialog();
                }
            } else if (this.step == 16) {
                this.initEvaluationDialog();
            } else if (this.step == 17) {
                this.initEndOfGame();
            }
        }
        this.bPause = false;
        this.screen = 0;
    }

    public void updateRectText() {
        switch (this.step) {
            case 0: {
                this.prepText2.prepareText(this.players - 1 + "", MainCanvas.WIDTH);
                break;
            }
            case 1: {
                this.sbValue = GameDefines.BLINDS[this.blindsPointer];
                this.bbValue = this.sbValue << 1;
                this.prepText2.prepareText(this.sbValue + "/" + this.bbValue, MainCanvas.WIDTH);
                break;
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!this.bPause) {
            if (this.raisingType != 0) {
                this.raisingType = 0;
            }
            if (this.raiseValueCounter > 0) {
                this.raiseValueCounter = 0;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        block34: {
            block33: {
                if (!this.bPause) break block33;
                if (this.rectControls[1].contains(x, y)) {
                    this.back();
                    return;
                }
                switch (this.screen) {
                    case 1: {
                        for (int i = 0; i < 3; ++i) {
                            if (!this.rectMenu[i].contains(x, y)) continue;
                            this.selectedItem = i;
                            this.bPressed = true;
                            this.confirm();
                            return;
                        }
                        break block34;
                    }
                    case 2: {
                        if (this.rectArrowsDialog[0].contains(x, y)) {
                            this.pProfile.previousSite();
                        }
                        if (this.rectArrowsDialog[1].contains(x, y)) {
                            this.pProfile.nextSite();
                            break;
                        }
                        break block34;
                    }
                    case 3: {
                        if (this.rectArrowsInstructions[0].contains(x, y)) {
                            this.upText();
                            return;
                        }
                        if (this.rectArrowsInstructions[1].contains(x, y)) {
                            this.downText();
                            return;
                        }
                        if (this.pointerY == -1 && y > this.rectDialog.y && y < this.rectDialog.getBottom()) {
                            this.pointerY = y;
                            break;
                        }
                        break block34;
                    }
                    case 4: {
                        if (this.rectControls[0].contains(x, y)) {
                            this.confirm();
                            break;
                        }
                        break block34;
                    }
                }
                break block34;
            }
            if (this.rectControls[1].contains(x, y)) {
                if (this.step > -1 && this.step < 16) {
                    this.pause();
                }
                return;
            }
            if (!this.bSkip) {
                if (this.showSkipButton() && this.rectControls[0].contains(x, y)) {
                    this.bSkip = true;
                    return;
                }
                if (!this.bNextStep) {
                    switch (this.step) {
                        case 0: {
                            if (this.rectArrowsDialog[0].contains(x, y) && this.players > 2) {
                                --this.players;
                                this.updateRectText();
                            }
                            if (this.rectArrowsDialog[1].contains(x, y) && this.players < 5) {
                                ++this.players;
                                this.updateRectText();
                            }
                            if (!this.rectControls[0].contains(x, y)) break;
                            this.closeDialog();
                            this.initNextStep();
                            break;
                        }
                        case 1: {
                            if (this.rectArrowsDialog[0].contains(x, y) && this.blindsPointer > 0) {
                                --this.blindsPointer;
                                this.updateRectText();
                            }
                            if (this.rectArrowsDialog[1].contains(x, y) && this.blindsPointer < this.maxBlinds) {
                                ++this.blindsPointer;
                                this.updateRectText();
                            }
                            if (!this.rectControls[0].contains(x, y)) break;
                            this.closeDialog();
                            this.initNextStep();
                            break;
                        }
                        case 8: 
                        case 10: 
                        case 12: 
                        case 14: {
                            if (!this.bWaitingForPlayer) break;
                            if (this.rectArrowsContext[0].contains(x, y)) {
                                this.contextMenuLeft();
                            }
                            if (this.rectArrowsContext[1].contains(x, y)) {
                                this.contextMenuRight();
                            }
                            if (this.rectControls[0].contains(x, y)) {
                                this.confirmSelection();
                            }
                            if (this.maxRaiseValue <= this.minRaiseValue || this.playersSelection != 5 && this.playersSelection != 3 || this.pomRaiseValue <= 0) break;
                            this.raiseValueCounter = 0;
                            if (this.rectArrowsContextRaise[0].contains(x, y)) {
                                this.raiseValueUp();
                                this.raisingType = 1;
                                return;
                            }
                            if (!this.rectArrowsContextRaise[1].contains(x, y)) break;
                            this.raiseValueDown();
                            this.raisingType = -1;
                            return;
                        }
                        case 16: 
                        case 17: {
                            if (!this.bEndDialog || this.endDialogCounter <= 5) break;
                            this.endDialogCounter = 5;
                            break;
                        }
                    }
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.bPause) {
            if (this.screen == 3 && this.pointerY > -1) {
                if (y < this.rectDialog.y || y > this.rectDialog.getBottom()) {
                    this.pointerY = -1;
                }
                this.textShift += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
        } else if (this.bWaitingForPlayer && this.raiseValueCounter > 0) {
            if (this.raisingType == 1 && !this.rectArrowsContextRaise[0].contains(x, y)) {
                this.raisingType = 0;
                this.raiseValueCounter = 0;
            }
            if (this.raisingType == -1 && !this.rectArrowsContextRaise[1].contains(x, y)) {
                this.raisingType = 0;
                this.raiseValueCounter = 0;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.bPause) {
            if (this.screen == 3 && this.pointerY != -1) {
                this.pointerY = -1;
            }
        } else {
            if (this.raisingType != 0) {
                this.raisingType = 0;
            }
            if (this.raiseValueCounter > 0) {
                this.raiseValueCounter = 0;
            }
        }
    }

    public void afterHide() {
    }

    public void beforeShow() {
        this.initGraphics();
        this.initFonts();
        this.initTexts();
        this.initControls();
        this.initMenu();
        this.initArrows();
        this.initTime();
        this.initArrays();
        this.initChipsBlink();
        if (!this.loadGame()) {
            this.initNextStep();
        }
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_GAME, -1);
        }
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
        if (!this.bPause) {
            this.pause();
        }
    }

    public void afterInteruption() {
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_GAME, -1);
        }
    }

    public void updateWinChip(long lTick) {
        if (this.bEndDialog && this.step == 17 && this.rectDialog != null && this.prepText1 != null && this.rectDialog.height > this.prepText1.getTextHeight() + (this.fontGoldBig.getHeight() << 1) && this.sprWinChip != null) {
            if (this.iWinChipCounter > 0) {
                this.iWinChipCounter = (int)((long)this.iWinChipCounter - lTick);
            } else {
                this.winChipFrame = (this.winChipFrame + 1) % this.sprWinChip.getFrameSequenceLength();
                if (this.winChipFrame == 0) {
                    this.iWinChipCounter = 750;
                }
            }
        }
    }

    public void initTime() {
        this.time = 0;
        this.pomTime = 0;
        this.lastTime = System.currentTimeMillis();
    }

    public void updateTime() {
        if (this.step > 1) {
            long currentTime = System.currentTimeMillis();
            this.time = (int)((long)this.time + (currentTime - this.lastTime));
            if (this.time > 1000000) {
                ++this.pomTime;
                this.time -= 1000000;
            }
            this.lastTime = currentTime;
        }
    }

    public void initGraphics() {
        int i;
        Resources.loadImages(new int[]{3, 4, 14, 15, 16, 17, 6, 7, 8, 9, 10, 11, 13, 30, 29});
        this.imgBg = Resources.resImgs[3];
        this.imgLogoMenu = Resources.resImgs[4];
        this.imgCardBack = Resources.resImgs[14];
        this.imgCardSelector = Resources.resImgs[15];
        this.imgCardPlaceholderTable = Resources.resImgs[16];
        this.imgCardPlaceholderPlayer = Resources.resImgs[17];
        this.imgBoxShort = Resources.resImgs[8];
        this.imgBoxShortSelected = Resources.resImgs[9];
        this.imgBoxLong = Resources.resImgs[6];
        this.imgBoxLongSelected = Resources.resImgs[7];
        this.imgBoxBig = Resources.resImgs[10];
        this.imgBoxBigSelected = Resources.resImgs[11];
        this.imgBoxSlimSelected = Resources.resImgs[13];
        this.imgRaiseBox = Resources.resImgs[30];
        this.imgShadow = Resources.resImgs[29];
        Resources.loadImages(new int[]{31, 32});
        this.imgPotBoxBlack = Resources.resImgs[31];
        this.imgPotBoxGold = Resources.resImgs[32];
        Resources.loadSprites(new int[]{1, 2, 3, 4, 7, 5, 6, 8});
        this.sprIcons = Resources.resSprs[1];
        this.sprIconsAchievs = Resources.resSprs[2];
        this.sprArrows = Resources.resSprs[3];
        this.sprArrowsInactive = Resources.resSprs[4];
        this.sprDialog = Resources.resSprs[7];
        this.sprCards = Resources.resSprs[5];
        this.sprChips = Resources.resSprs[6];
        this.sprWinChip = Resources.resSprs[8];
        this.cardWidth = this.sprCards.getWidth();
        this.cardHeight = this.sprCards.getHeight();
        this.statusBarHeight = this.imgBoxLong.getHeight() + (this.imgBoxLong.getHeight() >> 2);
        this.controlsBarHeight = this.sprIcons.getHeight() + (this.sprIcons.getHeight() >> 2);
        this.cardSpace = this.sprCards.getWidth() >> 4;
        if (this.cardSpace < 1) {
            this.cardSpace = 1;
        }
        int userHeight = this.imgBoxLong.getHeight() + (this.cardSpace << 1) + this.imgCardPlaceholderPlayer.getHeight();
        this.playgroundCenterY = this.statusBarHeight + (MainCanvas.HEIGHT - this.statusBarHeight - userHeight >> 1);
        this.playgroundCenterY = MainCanvas.HEIGHT >= 800 ? (this.playgroundCenterY -= this.sprIcons.getHeight() >> 1) : (MainCanvas.HEIGHT >= 320 ? (this.playgroundCenterY -= this.sprIcons.getHeight() >> 2) : (this.playgroundCenterY -= this.sprIcons.getHeight() >> 3));
        int pomShift = this.imgBoxShort.getHeight();
        int[] POM_WIDTH = new int[]{640, 480, 360, 352, 320, 240, 208, 176, 128};
        int[] PLAYGROUND_WIDTH = new int[]{520, 452, 338, 290, 260, 220, 180, 148, 148};
        int[] POM_HEIGHT = new int[]{800, 696, 640, 480, 432, 416, 400, 360, 348, 320, 307, 300, 287, 260, 240, 224, 220, 208, 160};
        int[] PLAYGROUND_HEIGHT = new int[]{452, 440, 400, 300, 262, 250, 250, 230, 220, 196, 180, 180, 164, 148, 140, 132, 132, 132, 132};
        for (i = 0; i < POM_WIDTH.length; ++i) {
            if (MainCanvas.WIDTH < POM_WIDTH[i]) continue;
            this.playgroundWidth = PLAYGROUND_WIDTH[i];
            break;
        }
        for (i = 0; i < POM_HEIGHT.length; ++i) {
            if (MainCanvas.HEIGHT < POM_HEIGHT[i]) continue;
            this.playgroundHeight = PLAYGROUND_HEIGHT[i];
            break;
        }
        this.playgroundHeight += pomShift;
        this.playgroundWidth += pomShift << 1;
    }

    public void initFonts() {
        Resources.loadGFonts(new int[]{0, 1, 2, 3});
        this.fontBlack = Resources.resGFonts[0];
        this.fontGold = Resources.resGFonts[1];
        this.fontBlackBig = Resources.resGFonts[2];
        this.fontGoldBig = Resources.resGFonts[3];
        this.preparedTextInfo = new PreparedText(this.fontGold);
        this.preparedTextInfoBig = new PreparedText(this.fontGoldBig);
        this.prepText1 = new PreparedText(this.fontGoldBig);
        this.prepText2 = new PreparedText(this.fontGoldBig);
    }

    public void initTexts() {
        strPlayer = Resources.resTexts[0].getHashedString(33);
        STR_ACTION = new String[7];
        ScreenGame.STR_ACTION[0] = "";
        ScreenGame.STR_ACTION[1] = Resources.resTexts[0].getHashedString(50);
        ScreenGame.STR_ACTION[2] = Resources.resTexts[0].getHashedString(51);
        ScreenGame.STR_ACTION[3] = Resources.resTexts[0].getHashedString(52);
        ScreenGame.STR_ACTION[4] = Resources.resTexts[0].getHashedString(53);
        ScreenGame.STR_ACTION[5] = Resources.resTexts[0].getHashedString(54);
        ScreenGame.STR_ACTION[6] = Resources.resTexts[0].getHashedString(55);
        strChooseNumberOfOpponents = Resources.resTexts[0].getHashedString(60) + ":";
        strChooseBlinds = Resources.resTexts[0].getHashedString(61) + ":";
        strWin = Resources.resTexts[0].getHashedString(62);
        strWins = Resources.resTexts[0].getHashedString(63);
        strWinGame = Resources.resTexts[0].getHashedString(64);
        strWinsGame = Resources.resTexts[0].getHashedString(65);
        strLosesGame = Resources.resTexts[0].getHashedString(66);
        strAnd = Resources.resTexts[0].getHashedString(68);
        STR_CARD_VALUE = new String[13];
        ScreenGame.STR_CARD_VALUE[0] = Resources.resTexts[0].getHashedString(80);
        ScreenGame.STR_CARD_VALUE[1] = Resources.resTexts[0].getHashedString(81);
        ScreenGame.STR_CARD_VALUE[2] = Resources.resTexts[0].getHashedString(82);
        ScreenGame.STR_CARD_VALUE[3] = Resources.resTexts[0].getHashedString(83);
        ScreenGame.STR_CARD_VALUE[4] = Resources.resTexts[0].getHashedString(84);
        ScreenGame.STR_CARD_VALUE[5] = Resources.resTexts[0].getHashedString(85);
        ScreenGame.STR_CARD_VALUE[6] = Resources.resTexts[0].getHashedString(86);
        ScreenGame.STR_CARD_VALUE[7] = Resources.resTexts[0].getHashedString(87);
        ScreenGame.STR_CARD_VALUE[8] = Resources.resTexts[0].getHashedString(88);
        ScreenGame.STR_CARD_VALUE[9] = Resources.resTexts[0].getHashedString(89);
        ScreenGame.STR_CARD_VALUE[10] = Resources.resTexts[0].getHashedString(90);
        ScreenGame.STR_CARD_VALUE[11] = Resources.resTexts[0].getHashedString(91);
        ScreenGame.STR_CARD_VALUE[12] = Resources.resTexts[0].getHashedString(92);
        STR_COMBINATION = new String[11];
        ScreenGame.STR_COMBINATION[0] = "";
        ScreenGame.STR_COMBINATION[1] = Resources.resTexts[0].getHashedString(100);
        ScreenGame.STR_COMBINATION[2] = Resources.resTexts[0].getHashedString(101);
        ScreenGame.STR_COMBINATION[3] = Resources.resTexts[0].getHashedString(102);
        ScreenGame.STR_COMBINATION[4] = Resources.resTexts[0].getHashedString(103);
        ScreenGame.STR_COMBINATION[5] = Resources.resTexts[0].getHashedString(104);
        ScreenGame.STR_COMBINATION[6] = Resources.resTexts[0].getHashedString(105);
        ScreenGame.STR_COMBINATION[7] = Resources.resTexts[0].getHashedString(106);
        ScreenGame.STR_COMBINATION[8] = Resources.resTexts[0].getHashedString(107);
        ScreenGame.STR_COMBINATION[9] = Resources.resTexts[0].getHashedString(108);
        ScreenGame.STR_COMBINATION[10] = Resources.resTexts[0].getHashedString(109);
        STR_PAUSE_MENU = new String[3];
        ScreenGame.STR_PAUSE_MENU[0] = Resources.resTexts[0].getHashedString(15);
        ScreenGame.STR_PAUSE_MENU[1] = Resources.resTexts[0].getHashedString(17);
        ScreenGame.STR_PAUSE_MENU[2] = Resources.resTexts[0].getHashedString(26);
        strLevel = Resources.resTexts[0].getHashedString(110);
        strXP = Resources.resTexts[0].getHashedString(111);
        strPot = MainCanvas.HEIGHT < 320 ? "POT" : Resources.resTexts[0].getHashedString(37);
    }

    public void initControls() {
        int y = MainCanvas.HEIGHT - this.sprIcons.getHeight();
        this.rectControls = new Rectangle[2];
        this.rectControls[0] = new Rectangle(0, y, this.sprIcons.getWidth(), this.sprIcons.getHeight());
        this.rectControls[1] = new Rectangle(MainCanvas.WIDTH - this.sprIcons.getWidth(), y, this.sprIcons.getWidth(), this.sprIcons.getHeight());
        this.contextMenuTop = MainCanvas.HEIGHT - this.imgBoxLong.getHeight() - this.cardSpace;
        this.contextMenuY = MainCanvas.HEIGHT;
    }

    public void initMenu() {
        int iMaxHeight;
        int iSpaceY;
        this.iBookedSpaceY = this.imgLogoMenu.getHeight() + this.sprIcons.getHeight();
        this.iLogoY = this.sprIcons.getHeight() >> 1;
        if (MainCanvas.HEIGHT <= 320 || MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640 && MainCanvas.HEIGHT < 800 || this.isSmallAspectRatio()) {
            this.iBookedSpaceY = this.imgLogoMenu.getHeight() + (this.sprIcons.getHeight() >> 1);
            this.iLogoY = this.sprIcons.getHeight() >> 2;
        }
        if ((iSpaceY = ((iMaxHeight = MainCanvas.HEIGHT - this.iBookedSpaceY - this.sprIcons.getHeight() - (this.sprIcons.getHeight() >> 1)) - 3 * this.imgBoxLong.getHeight()) / 6) < 2) {
            iSpaceY = 2;
        }
        int iY = this.iBookedSpaceY + (iSpaceY << 1);
        int iWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        int iX = (MainCanvas.WIDTH >> 1) - (iWidth >> 1);
        this.rectMenu = new Rectangle[3];
        for (int i = 0; i < 3; ++i) {
            this.rectMenu[i] = new Rectangle(iX, iY, iWidth, this.imgBoxLong.getHeight());
            iY += this.imgBoxLong.getHeight() + iSpaceY;
        }
    }

    public void initArrows() {
        int y;
        int arrowsWidth = this.sprArrows.getWidth();
        int arrowsHeight = this.sprArrows.getHeight();
        this.rectArrowsDialog = new Rectangle[2];
        this.rectArrowsDialog[0] = new Rectangle(0, 0, arrowsWidth, arrowsHeight);
        this.rectArrowsDialog[1] = new Rectangle(0, 0, arrowsWidth, arrowsHeight);
        this.rectArrowsContext = new Rectangle[2];
        this.rectArrowsContext[0] = new Rectangle(0, 0, arrowsWidth, arrowsHeight);
        this.rectArrowsContext[1] = new Rectangle(0, 0, arrowsWidth, arrowsHeight);
        int raiseBoxWidth = this.imgRaiseBox.getWidth();
        int raiseBoxHeight = this.imgRaiseBox.getHeight();
        int pomWidth = (this.imgCardPlaceholderPlayer.getWidth() << 1) + (this.cardSpace << 1) + this.imgBoxBig.getWidth();
        int pomLabelRight = (MainCanvas.WIDTH >> 1) + (pomWidth >> 1);
        int x = pomLabelRight + raiseBoxWidth - (raiseBoxWidth >> 2);
        if (x > pomLabelRight + (MainCanvas.WIDTH - pomLabelRight >> 1) - (raiseBoxWidth >> 1)) {
            x = pomLabelRight + (MainCanvas.WIDTH - pomLabelRight >> 1) - (raiseBoxWidth >> 1);
        }
        if ((y = this.contextMenuTop) + raiseBoxHeight > MainCanvas.HEIGHT - this.controlsBarHeight - (this.controlsBarHeight >> 3)) {
            y = MainCanvas.HEIGHT - this.controlsBarHeight - (this.controlsBarHeight >> 3) - raiseBoxHeight;
        }
        if (x + raiseBoxWidth + (raiseBoxWidth >> 2) < MainCanvas.WIDTH - this.sprIcons.getWidth() && (y += this.controlsBarHeight >> 2) < this.playgroundCenterY + (this.playgroundHeight >> 1) + (this.controlsBarHeight >> 2)) {
            y = this.playgroundCenterY + (this.playgroundHeight >> 1) + (this.controlsBarHeight >> 2);
        }
        this.rectArrowsContextRaise = new Rectangle[2];
        this.rectArrowsContextRaise[0] = new Rectangle(x, y + (raiseBoxHeight >> 1) - arrowsHeight, arrowsWidth, arrowsHeight);
        this.rectArrowsContextRaise[1] = new Rectangle(x, y + (raiseBoxHeight >> 1) + 1, arrowsWidth, arrowsHeight);
    }

    public void setArrows() {
        int iTotalTextHeight = this.prepText1.getTextHeight() + this.fontGold.getHeight() + this.prepText2.getTextHeight();
        int y = this.rectDialog.getCenterY() + (iTotalTextHeight >> 1) - (this.fontGold.getHeight() >> 1) - (this.rectArrowsDialog[0].height >> 1);
        this.rectArrowsDialog[0].x = this.rectDialog.x + (this.rectDialog.width >> 2);
        this.rectArrowsDialog[0].y = y;
        this.rectArrowsDialog[1].x = this.rectDialog.getRight() - (this.rectDialog.width >> 2) - this.sprArrows.getWidth();
        this.rectArrowsDialog[1].y = y;
        if (this.step == 1) {
            if (MainCanvas.WIDTH < MainCanvas.HEIGHT) {
                this.rectArrowsDialog[0].x -= this.rectDialog.width >> 3;
                this.rectArrowsDialog[1].x += this.rectDialog.width >> 3;
            } else if (MainCanvas.WIDTH == MainCanvas.HEIGHT) {
                this.rectArrowsDialog[0].x -= this.rectDialog.width >> 4;
                this.rectArrowsDialog[1].x += this.rectDialog.width >> 4;
            }
        }
    }

    public void setArrowsContext() {
        if (this.pPlayer[0] != null) {
            this.rectArrowsContext[0].x = this.pPlayer[0].getContextArrowsX(0);
            this.rectArrowsContext[0].y = this.pPlayer[0].getContextArrowsY();
            this.rectArrowsContext[1].x = this.pPlayer[0].getContextArrowsX(1);
            this.rectArrowsContext[1].y = this.pPlayer[0].getContextArrowsY();
        }
    }

    public void openContextMenu() {
        this.bContextMenuOut = false;
        this.bContextMenuIn = true;
    }

    public void closeContextMenu() {
        this.bContextMenuIn = false;
        this.bContextMenuOut = true;
    }

    public void updateContextMenu() {
        if ((this.bContextMenuIn || this.bContextMenuOut) && this.pPlayer[0] != null) {
            int speed = MainCanvas.WIDTH >> 5;
            if (this.bContextMenuIn) {
                if (this.contextMenuY - speed > this.contextMenuTop) {
                    this.contextMenuY -= speed;
                } else {
                    this.contextMenuY = this.contextMenuTop;
                    this.bContextMenuIn = false;
                }
            }
            if (this.bContextMenuOut) {
                if (this.contextMenuY + speed < MainCanvas.HEIGHT) {
                    this.contextMenuY += speed;
                } else {
                    this.contextMenuY = MainCanvas.HEIGHT;
                    this.bContextMenuOut = false;
                }
            }
            this.pPlayer[0].setUserShiftY(MainCanvas.HEIGHT - this.contextMenuY);
            this.setArrowsContext();
        }
    }

    public void initNumberOfOpponentsDialog() {
        int width = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            width = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 2);
        }
        this.prepText1.prepareText(strChooseNumberOfOpponents, width - (width >> 3));
        this.prepText2.prepareText(this.players - 1 + "", width);
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        int height = this.prepText1.getTextHeight() + this.fontGold.getHeight() + (this.fontGoldBig.getHeight() << 1) + this.sprArrows.getHeight();
        int y = (MainCanvas.HEIGHT >> 1) - (height >> 1);
        this.rectDialog = new Rectangle(x, y, width, height);
        this.setArrows();
        this.openDialog();
    }

    public void initPlayers() {
        byte[] faces = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        int pom = 0;
        PLAYERS_FACE = new byte[this.players];
        ScreenGame.PLAYERS_FACE[0] = -1;
        for (int i = 1; i < this.players; ++i) {
            pom = RandomNum.getRandomUInt(8);
            while (faces[pom] == -1) {
                pom = RandomNum.getRandomUInt(8);
            }
            ScreenGame.PLAYERS_FACE[i] = (byte)pom;
            faces[pom] = -1;
        }
        this.setPlayers();
    }

    public void setPlayers() {
        Resources.loadImage(19);
        int userWidth = this.imgBoxLong.getWidth();
        int rivalWidth = Resources.resImgs[19].getWidth() + (this.cardSpace << 1) + (this.imgCardPlaceholderPlayer.getWidth() << 1);
        int rivalHeight = this.imgBoxShort.getHeight() + this.cardSpace + this.imgCardPlaceholderPlayer.getHeight();
        int rivalShift = MainCanvas.HEIGHT / 160;
        if (rivalShift < 1) {
            rivalShift = 1;
        }
        int betShift = (rivalWidth >> 3) + (rivalWidth >> 5);
        int x0 = (MainCanvas.WIDTH >> 1) - (userWidth >> 1);
        int x1 = (MainCanvas.WIDTH >> 1) - (this.playgroundWidth >> 1) + rivalShift;
        int x2 = (MainCanvas.WIDTH >> 1) - (rivalWidth >> 1) - (this.imgBoxSlimSelected.getWidth() >> 3);
        int x3 = (MainCanvas.WIDTH >> 1) + (this.playgroundWidth >> 1) - rivalWidth - rivalShift;
        int y0 = MainCanvas.HEIGHT - this.cardSpace - this.imgCardPlaceholderPlayer.getHeight();
        int y1 = this.playgroundCenterY + (this.playgroundHeight >> 1) - rivalHeight - rivalShift;
        int y2 = this.playgroundCenterY - (this.playgroundHeight >> 1) + rivalShift;
        int betX0 = (MainCanvas.WIDTH >> 1) - (this.imgBoxSlimSelected.getWidth() >> 1);
        int betX1 = x1 + (rivalWidth >> 1) + betShift - (this.imgBoxSlimSelected.getWidth() >> 1);
        int betX2 = x3 + (rivalWidth >> 1) - betShift - (this.imgBoxSlimSelected.getWidth() >> 1);
        if (betX1 + this.imgBoxSlimSelected.getWidth() >= betX0 - (betShift >> 1)) {
            betX1 = betX0 - this.imgBoxSlimSelected.getWidth() - (betShift >> 1);
        }
        if (betX2 <= betX0 + this.imgBoxSlimSelected.getWidth() + (betShift >> 1)) {
            betX2 = betX0 + this.imgBoxSlimSelected.getWidth() + (betShift >> 1);
        }
        int betY0 = this.playgroundCenterY + (this.imgCardPlaceholderPlayer.getHeight() >> 1) + (y1 - this.playgroundCenterY - (this.imgCardPlaceholderPlayer.getHeight() >> 1) >> 1) - (this.imgBoxSlimSelected.getHeight() >> 1);
        int betY1 = y2 + rivalHeight + (this.playgroundCenterY - (this.imgCardPlaceholderPlayer.getHeight() >> 1) - y2 - rivalHeight >> 1) - (this.imgBoxSlimSelected.getHeight() >> 1);
        if (x1 < this.cardSpace) {
            x1 = this.cardSpace;
        }
        if (x3 > MainCanvas.WIDTH - this.cardSpace - rivalWidth) {
            x3 = MainCanvas.WIDTH - this.cardSpace - rivalWidth;
        }
        if (MainCanvas.WIDTH == MainCanvas.HEIGHT) {
            betX1 += this.imgBoxSlimSelected.getWidth() >> 2;
            betX2 -= this.imgBoxSlimSelected.getWidth() >> 2;
        } else if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            betX1 += this.imgBoxSlimSelected.getWidth() >> 1;
            betX2 -= this.imgBoxSlimSelected.getWidth() >> 1;
        }
        int[] POM_POSITION_X = new int[]{x0, x1, x1, x2, x3, x3};
        int[] POM_POSITION_Y = new int[]{y0, y1, y2, y2, y2, y1};
        int[] position_x = new int[this.players];
        int[] position_y = new int[this.players];
        int[] orientation = new int[this.players];
        int[] bet_x = new int[this.players];
        int[] bet_y = new int[this.players];
        position_x[0] = POM_POSITION_X[0];
        position_y[0] = POM_POSITION_Y[0];
        orientation[0] = -1;
        bet_x[0] = betX0;
        bet_y[0] = betY0;
        switch (this.players) {
            case 2: {
                position_x[1] = POM_POSITION_X[3];
                position_y[1] = POM_POSITION_Y[3];
                orientation[1] = 0;
                bet_x[1] = betX0;
                bet_y[1] = betY1;
                break;
            }
            case 3: {
                position_x[1] = POM_POSITION_X[2];
                position_y[1] = POM_POSITION_Y[2];
                orientation[1] = 0;
                bet_x[1] = betX1;
                bet_y[1] = betY1;
                position_x[2] = POM_POSITION_X[4];
                position_y[2] = POM_POSITION_Y[4];
                orientation[2] = 1;
                bet_x[2] = betX2;
                bet_y[2] = betY1;
                break;
            }
            case 4: {
                position_x[1] = POM_POSITION_X[1];
                position_y[1] = POM_POSITION_Y[1];
                orientation[1] = 0;
                bet_x[1] = betX1;
                bet_y[1] = betY0;
                position_x[2] = POM_POSITION_X[2];
                position_y[2] = POM_POSITION_Y[2];
                orientation[2] = 0;
                bet_x[2] = betX1;
                bet_y[2] = betY1;
                position_x[3] = POM_POSITION_X[4];
                position_y[3] = POM_POSITION_Y[4];
                orientation[3] = 1;
                bet_x[3] = betX2;
                bet_y[3] = betY1;
                break;
            }
            case 5: {
                position_x[1] = POM_POSITION_X[1];
                position_y[1] = POM_POSITION_Y[1];
                orientation[1] = 0;
                bet_x[1] = betX1;
                bet_y[1] = betY0;
                position_x[2] = POM_POSITION_X[2];
                position_y[2] = POM_POSITION_Y[2];
                orientation[2] = 0;
                bet_x[2] = betX1;
                bet_y[2] = betY1;
                position_x[3] = POM_POSITION_X[4];
                position_y[3] = POM_POSITION_Y[4];
                orientation[3] = 1;
                bet_x[3] = betX2;
                bet_y[3] = betY1;
                position_x[4] = POM_POSITION_X[5];
                position_y[4] = POM_POSITION_Y[5];
                orientation[4] = 1;
                bet_x[4] = betX2;
                bet_y[4] = betY0;
                break;
            }
        }
        this.pPlayer = new Player[this.players];
        for (int i = 0; i < this.players; ++i) {
            this.pPlayer[i] = new Player(i, PLAYERS_FACE[i], position_x[i], position_y[i], orientation[i], bet_x[i], bet_y[i]);
            this.pPlayer[i].setDarkenLabel(false);
        }
    }

    public void initCardsPos() {
        CARDS_RIGHT_POS_X = new int[this.players << 1];
        CARDS_RIGHT_POS_Y = new int[this.players << 1];
        for (int i = 0; i < this.players << 1; i += 2) {
            int player = i / 2;
            ScreenGame.CARDS_RIGHT_POS_X[i] = this.pPlayer[player].getCard1X();
            ScreenGame.CARDS_RIGHT_POS_Y[i] = this.pPlayer[player].getCardY();
            ScreenGame.CARDS_RIGHT_POS_X[i + 1] = this.pPlayer[player].getCard2X();
            ScreenGame.CARDS_RIGHT_POS_Y[i + 1] = this.pPlayer[player].getCardY();
        }
    }

    public void initChips() {
        CHIP_X = new int[3];
        CHIP_Y = new int[3];
        for (int i = 0; i < 3; ++i) {
            ScreenGame.CHIP_X[i] = this.cardStackX;
            ScreenGame.CHIP_Y[i] = this.cardStackY;
        }
        this.setChipsPos();
    }

    public void setChipsPos() {
        this.setActivePlayers();
        CHIP_RIGHT_POS_X = new int[3];
        CHIP_RIGHT_POS_Y = new int[3];
        ScreenGame.CHIP_RIGHT_POS_X[0] = this.pPlayer[this.dealer].getChipCenterX() - (this.sprChips.getWidth() >> 1);
        ScreenGame.CHIP_RIGHT_POS_X[1] = this.pPlayer[this.smallBlind].getChipCenterX() - (this.sprChips.getWidth() >> 1);
        ScreenGame.CHIP_RIGHT_POS_X[2] = this.pPlayer[this.bigBlind].getChipCenterX() - (this.sprChips.getWidth() >> 1);
        ScreenGame.CHIP_RIGHT_POS_Y[0] = this.pPlayer[this.dealer].getChipCenterY() - (this.sprChips.getHeight() >> 1);
        ScreenGame.CHIP_RIGHT_POS_Y[1] = this.pPlayer[this.smallBlind].getChipCenterY() - (this.sprChips.getHeight() >> 1);
        ScreenGame.CHIP_RIGHT_POS_Y[2] = this.pPlayer[this.bigBlind].getChipCenterY() - (this.sprChips.getHeight() >> 1);
        if (this.dealer == this.bigBlind) {
            CHIP_RIGHT_POS_X[0] = CHIP_RIGHT_POS_X[0] - (this.sprChips.getWidth() >> 2);
            CHIP_RIGHT_POS_X[2] = CHIP_RIGHT_POS_X[2] + (this.sprChips.getWidth() >> 2);
            if (this.dealer == 0) {
                CHIP_RIGHT_POS_X[0] = CHIP_RIGHT_POS_X[0] + (this.sprChips.getWidth() >> 2);
                CHIP_RIGHT_POS_X[2] = CHIP_RIGHT_POS_X[2] + (this.sprChips.getWidth() >> 2);
            } else if (CHIP_RIGHT_POS_X[0] <= 0) {
                int shiftX = 1 - CHIP_RIGHT_POS_X[0];
                CHIP_RIGHT_POS_X[0] = CHIP_RIGHT_POS_X[0] + shiftX;
                CHIP_RIGHT_POS_X[2] = CHIP_RIGHT_POS_X[2] + shiftX;
            } else if (CHIP_RIGHT_POS_X[2] + this.sprChips.getWidth() >= MainCanvas.WIDTH - 1) {
                int shiftX = CHIP_RIGHT_POS_X[2] + this.sprChips.getWidth() - (MainCanvas.WIDTH - 1);
                CHIP_RIGHT_POS_X[0] = CHIP_RIGHT_POS_X[0] - shiftX;
                CHIP_RIGHT_POS_X[2] = CHIP_RIGHT_POS_X[2] - shiftX;
            }
        }
    }

    public void updateChips() {
        if (this.bMovingChips) {
            if (CHIP_X[0] != CHIP_RIGHT_POS_X[0] || CHIP_Y[0] != CHIP_RIGHT_POS_Y[0]) {
                this.ddaChips(0);
            }
            if (!(this.step < 3 && this.hand <= 0 || CHIP_X[1] == CHIP_RIGHT_POS_X[1] && CHIP_Y[1] == CHIP_RIGHT_POS_Y[1])) {
                this.ddaChips(1);
            }
            if (!(this.step < 4 && this.hand <= 0 || CHIP_X[2] == CHIP_RIGHT_POS_X[2] && CHIP_Y[2] == CHIP_RIGHT_POS_Y[2])) {
                this.ddaChips(2);
            }
            if (CHIP_X[0] == CHIP_RIGHT_POS_X[0] && CHIP_Y[0] == CHIP_RIGHT_POS_Y[0] && CHIP_X[1] == CHIP_RIGHT_POS_X[1] && CHIP_Y[1] == CHIP_RIGHT_POS_Y[1] && CHIP_X[2] == CHIP_RIGHT_POS_X[2] && CHIP_Y[2] == CHIP_RIGHT_POS_Y[2]) {
                this.bMovingChips = false;
            }
        }
    }

    public void initBetsPos() {
        BET_X = new int[this.players];
        BET_Y = new int[this.players];
        BET_RIGHT_POS_X = new int[this.players];
        BET_RIGHT_POS_Y = new int[this.players];
        BETS_X = new int[this.players];
        BETS_Y = new int[this.players];
        for (int i = 0; i < this.players; ++i) {
            ScreenGame.BET_RIGHT_POS_X[i] = this.pPlayer[i].getBetX();
            ScreenGame.BET_RIGHT_POS_Y[i] = this.pPlayer[i].getBetY();
            ScreenGame.BETS_X[i] = BET_RIGHT_POS_X[i];
            ScreenGame.BETS_Y[i] = BET_RIGHT_POS_Y[i];
            ScreenGame.BET_X[i] = this.pPlayer[i].getChipsValueX();
            ScreenGame.BET_Y[i] = this.pPlayer[i].getChipsValueY();
        }
    }

    public void initPotPos() {
        int pomBoxWidth = this.imgBoxShort.getWidth();
        int pomBoxHeight = this.imgBoxShort.getHeight();
        if (this.imgPotBoxBlack != null) {
            pomBoxWidth = this.imgPotBoxBlack.getWidth();
            pomBoxHeight = this.imgPotBoxBlack.getHeight();
        }
        int pomSpaceX = (MainCanvas.WIDTH - this.imgBoxLong.getWidth() - pomBoxWidth) / 3;
        int rightPosX = MainCanvas.WIDTH - pomSpaceX - pomBoxWidth;
        int rightPosY = (this.statusBarHeight >> 1) - (pomBoxHeight >> 1);
        if (MainCanvas.HEIGHT <= 320 || this.isSmallAspectRatio()) {
            --rightPosY;
        }
        this.potX = rightPosX;
        this.potY = rightPosY;
        if (pomSpaceX > this.statusBarHeight >> 1) {
            pomSpaceX = this.statusBarHeight >> 1;
            this.potX = (MainCanvas.WIDTH >> 1) + (this.imgBoxLong.getWidth() + pomBoxWidth + pomSpaceX >> 1) - pomBoxWidth;
        }
        this.pomPotX = this.potX + (pomBoxWidth >> 1) - (this.imgBoxSlimSelected.getWidth() >> 1);
        this.pomPotY = this.potY + (pomBoxHeight >> 1) - (this.imgBoxSlimSelected.getHeight() >> 1);
    }

    public void initBlinds() {
        int i;
        int minChips = CHIPS[0];
        for (i = 0; i < this.players; ++i) {
            if (CHIPS[i] >= minChips) continue;
            minChips = CHIPS[i];
        }
        this.maxBlinds = 0;
        i = 0;
        while (i < GameDefines.BLINDS.length && GameDefines.BLINDS[i] << 1 <= minChips && i <= 6) {
            this.maxBlinds = i++;
        }
        this.raiseBlindsCounter = 0;
        if (this.maxBlinds == 0) {
            this.blindsPointer = 0;
            this.sbValue = GameDefines.BLINDS[this.blindsPointer];
            this.bbValue = this.sbValue << 1;
            this.initNextStep();
        } else {
            this.blindsPointer = 3;
            if (this.blindsPointer > this.maxBlinds) {
                this.blindsPointer = this.maxBlinds;
            }
            this.sbValue = GameDefines.BLINDS[this.blindsPointer];
            this.bbValue = this.sbValue << 1;
            this.initBlindsValuesDialog();
        }
    }

    public void initBlindsValuesDialog() {
        int width = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            width = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 2);
        }
        this.prepText1.prepareText(strChooseBlinds, width - (width >> 3));
        this.prepText2.prepareText(this.sbValue + "/" + this.bbValue, width);
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        int height = this.prepText1.getTextHeight() + this.fontGold.getHeight() + (this.fontGoldBig.getHeight() << 1) + this.sprArrows.getHeight();
        int y = (MainCanvas.HEIGHT >> 1) - (height >> 1);
        this.rectDialog = new Rectangle(x, y, width, height);
        this.setArrows();
        this.openDialog();
    }

    public void initArrays() {
        CARDS = new byte[52];
        COMMUNITY_CARDS = new byte[5];
        HOLE_CARDS = new byte[1];
        for (int i = 0; i < 52; ++i) {
            ScreenGame.CARDS[i] = -1;
        }
        ScreenGame.HOLE_CARDS[0] = -1;
        ACTIVE = new byte[1];
        WINNER = new byte[1];
        PLAYERS_MODE = new byte[1];
        ACTION = new byte[1];
        SHOWN_CARDS = new byte[1];
        CHIPS = new int[1];
        BUY_IN = new int[1];
        BET = new int[1];
        BETS = new int[1];
        POT = new int[1];
        POT_PLAYERS = new byte[1];
        INDIVIDUAL_LIMITS = new int[1];
        LIMITS = new int[1];
        POT_WINNERS = new int[1];
        CARDS_X = new int[1];
        CARDS_Y = new int[1];
        CARDS_RIGHT_POS_X = new int[1];
        CARDS_RIGHT_POS_Y = new int[1];
        COMMUNITY_CARDS_X = new int[5];
        COMMUNITY_CARDS_Y = new int[5];
        COMMUNITY_CARDS_RIGHT_POS_X = new int[5];
        COMMUNITY_CARDS_RIGHT_POS_Y = new int[5];
        BET_X = new int[1];
        BET_Y = new int[1];
        BET_RIGHT_POS_X = new int[1];
        BET_RIGHT_POS_Y = new int[1];
        ScreenGame.ACTION[0] = 0;
        ScreenGame.PLAYERS_MODE[0] = 2;
        ScreenGame.ACTIVE[0] = 1;
        ScreenGame.SHOWN_CARDS[0] = 1;
        ScreenGame.WINNER[0] = -1;
        ScreenGame.CHIPS[0] = 0;
        ScreenGame.BUY_IN[0] = 0;
        ScreenGame.BET[0] = 0;
        ScreenGame.BETS[0] = 0;
        ScreenGame.POT[0] = 0;
        ScreenGame.POT_PLAYERS[0] = 0;
        ScreenGame.INDIVIDUAL_LIMITS[0] = 0;
        ScreenGame.LIMITS[0] = 0;
        ScreenGame.POT_WINNERS[0] = -1;
        ScreenGame.CARDS_X[0] = -1;
        ScreenGame.CARDS_Y[0] = -1;
        ScreenGame.CARDS_RIGHT_POS_X[0] = -1;
        ScreenGame.CARDS_RIGHT_POS_Y[0] = -1;
        ScreenGame.BET_X[0] = -1;
        ScreenGame.BET_Y[0] = -1;
        ScreenGame.BET_RIGHT_POS_X[0] = -1;
        ScreenGame.BET_RIGHT_POS_Y[0] = -1;
        int pomWidth = this.imgCardPlaceholderTable.getWidth();
        int pomHeight = this.imgCardPlaceholderTable.getHeight();
        int shiftX = pomWidth >> 3;
        if (shiftX < 1) {
            shiftX = 1;
        }
        int x = (MainCanvas.WIDTH >> 1) - (pomWidth >> 1);
        int y = this.playgroundCenterY - (pomHeight >> 1);
        int[] POM_X = new int[]{x - (pomWidth << 1) - (shiftX << 1), x - pomWidth - shiftX, x, x + pomWidth + shiftX, x + (pomWidth << 1) + (shiftX << 1)};
        for (int i = 0; i < 5; ++i) {
            ScreenGame.COMMUNITY_CARDS[i] = -1;
            ScreenGame.COMMUNITY_CARDS_X[i] = this.cardStackX;
            ScreenGame.COMMUNITY_CARDS_Y[i] = this.cardStackY;
            ScreenGame.COMMUNITY_CARDS_RIGHT_POS_X[i] = POM_X[i] + (pomWidth >> 1) - (this.cardWidth >> 1);
            ScreenGame.COMMUNITY_CARDS_RIGHT_POS_Y[i] = y + (pomHeight >> 1) - (this.cardHeight >> 1);
        }
        this.potX = 0;
        this.potY = 0;
        this.winChipFrame = 0;
        this.initCardsAnalysis();
    }

    public void initArrays2() {
        int i;
        HOLE_CARDS = new byte[this.players << 1];
        ACTION = new byte[this.players];
        PLAYERS_MODE = new byte[this.players];
        ACTIVE = new byte[this.players];
        SHOWN_CARDS = new byte[this.players];
        BET = new int[this.players];
        BETS = new int[this.players];
        WINNER = new byte[this.players];
        for (i = 0; i < HOLE_CARDS.length; ++i) {
            ScreenGame.HOLE_CARDS[i] = -1;
        }
        if (this.hand == 0) {
            CHIPS = new int[this.players];
            BUY_IN = new int[this.players];
            CARDS_X = new int[this.players << 1];
            CARDS_Y = new int[this.players << 1];
            CARDS_RIGHT_POS_X = new int[this.players << 1];
            CARDS_RIGHT_POS_Y = new int[this.players << 1];
            for (i = 0; i < this.players << 1; ++i) {
                ScreenGame.CARDS_X[i] = this.cardStackX;
                ScreenGame.CARDS_Y[i] = this.cardStackY;
                ScreenGame.CARDS_RIGHT_POS_X[i] = -1;
                ScreenGame.CARDS_RIGHT_POS_Y[i] = -1;
            }
        }
        for (i = 0; i < this.players; ++i) {
            ScreenGame.ACTION[i] = 0;
            ScreenGame.BET[i] = 0;
            ScreenGame.BETS[i] = 0;
            if (i != 0) {
                ScreenGame.PLAYERS_MODE[i] = (byte)RandomNum.getRandomUInt(5);
            }
            ScreenGame.ACTIVE[i] = 1;
            ScreenGame.SHOWN_CARDS[i] = 0;
            ScreenGame.WINNER[i] = -1;
        }
        this.setDarkenLabels();
        ScreenGame.SHOWN_CARDS[0] = 1;
        if (this.hand == 0) {
            ScreenGame.CHIPS[0] = (30 + RandomNum.getRandomUInt(21)) * 100;
            for (i = 1; i < this.players; ++i) {
                ScreenGame.CHIPS[i] = (20 + RandomNum.getRandomUInt(31)) * 100;
            }
        }
        for (i = 0; i < this.players; ++i) {
            ScreenGame.BUY_IN[i] = CHIPS[i];
        }
        this.checkInactivePlayers();
        this.initPotArrays();
    }

    public void addPot(int bet) {
        this.pot += bet;
        int maxPot = 0;
        for (int i = 0; i < LIMITS.length; ++i) {
            maxPot += LIMITS[i];
        }
        if (maxPot > 0 && this.pot > maxPot) {
            this.pot = maxPot;
        }
        int pomPot = this.pot;
        int id = 0;
        while (pomPot > 0) {
            int pom;
            int limit = id < LIMITS.length ? LIMITS[id] : pomPot;
            ScreenGame.POT[id] = pom = pomPot <= limit ? pomPot : limit;
            pomPot -= pom;
            ++id;
        }
    }

    public void initPotArrays() {
        int i;
        int j;
        int i2;
        int i3;
        POT = new int[this.players - 1];
        for (int i4 = 0; i4 < POT.length; ++i4) {
            ScreenGame.POT[i4] = 0;
        }
        int count = 0;
        int[] POM_CHIPS = new int[this.players];
        int pointer = 0;
        for (i3 = 0; i3 < this.players; ++i3) {
            if (CHIPS[i3] < this.bbValue) continue;
            boolean isOk = true;
            for (int j2 = 0; j2 < POM_CHIPS.length; ++j2) {
                if (CHIPS[i3] != POM_CHIPS[j2]) continue;
                isOk = false;
                break;
            }
            if (!isOk) continue;
            ++count;
            POM_CHIPS[pointer] = CHIPS[i3];
            ++pointer;
        }
        INDIVIDUAL_LIMITS = new int[count - 1];
        LIMITS = new int[count - 1];
        for (i3 = 0; i3 < LIMITS.length; ++i3) {
            ScreenGame.INDIVIDUAL_LIMITS[i3] = 0;
            ScreenGame.LIMITS[i3] = 0;
        }
        POT_PLAYERS = new byte[this.players * (this.activePlayers - 1)];
        POT_WINNERS = new int[this.players * (this.activePlayers - 1)];
        for (i3 = 0; i3 < POT_PLAYERS.length; ++i3) {
            ScreenGame.POT_PLAYERS[i3] = -1;
            ScreenGame.POT_WINNERS[i3] = -1;
        }
        int[] POM_BUY_IN = new int[this.players];
        for (i2 = 0; i2 < this.players; ++i2) {
            POM_BUY_IN[i2] = BUY_IN[i2];
        }
        for (i2 = 0; i2 < LIMITS.length; ++i2) {
            int id = 0;
            while (POM_BUY_IN[id] <= 0 || ACTIVE[id] == 0) {
                ++id;
            }
            for (int j3 = 0; j3 < this.players; ++j3) {
                if (ACTIVE[j3] != 1 || POM_BUY_IN[j3] >= POM_BUY_IN[id] || POM_BUY_IN[j3] <= 0) continue;
                id = j3;
            }
            int min = POM_BUY_IN[id];
            if (i2 > 0) {
                for (j = i2 - 1; j >= 0; --j) {
                    min -= INDIVIDUAL_LIMITS[j];
                }
            }
            ScreenGame.INDIVIDUAL_LIMITS[i2] = min;
            ScreenGame.LIMITS[i2] = min * (this.activePlayers - i2);
            POM_BUY_IN[id] = -1;
        }
        POM_BUY_IN = new int[this.players];
        for (i2 = 0; i2 < this.players; ++i2) {
            POM_BUY_IN[i2] = BUY_IN[i2];
        }
        byte[] POM_IDS = new byte[this.players];
        for (i = 0; i < this.players; ++i) {
            POM_IDS[i] = -1;
        }
        for (i = 0; i < this.activePlayers; ++i) {
            int id = 0;
            while (POM_BUY_IN[id] <= 0) {
                ++id;
            }
            for (j = 0; j < this.players; ++j) {
                if (POM_BUY_IN[j] <= POM_BUY_IN[id] || POM_BUY_IN[j] <= 0) continue;
                id = j;
            }
            POM_IDS[i] = (byte)id;
            POM_BUY_IN[id] = -1;
        }
        for (i = 0; i < this.players; ++i) {
            int max = this.activePlayers - i;
            if (max > this.activePlayers - 1) {
                max = this.activePlayers - 1;
            }
            for (j = 0; j < max; ++j) {
                pointer = j * this.players + i;
                ScreenGame.POT_PLAYERS[pointer] = POM_IDS[i];
            }
        }
    }

    public void shuffleCards() {
        int i;
        for (int i2 = 0; i2 < 52; ++i2) {
            ScreenGame.CARDS[i2] = (byte)i2;
        }
        int rand = 0;
        byte[] POM = new byte[52];
        for (i = 0; i < 52; ++i) {
            rand = RandomNum.getRandomUInt(52);
            while (CARDS[rand] == -1) {
                if (rand == 51) {
                    rand = 0;
                    continue;
                }
                ++rand;
            }
            POM[i] = CARDS[rand];
            ScreenGame.CARDS[rand] = -1;
        }
        for (i = 0; i < 52; ++i) {
            ScreenGame.CARDS[i] = POM[i];
        }
        this.cardsPointer = 51;
        this.holeCardsPointer = 0;
        this.communityCardsPointer = 0;
    }

    public void initDealerAndBlinds() {
        this.bigBlind = this.players - 1;
        this.smallBlind = this.bigBlind - 1;
        this.dealer = this.smallBlind - 1;
        if (this.dealer < 0) {
            this.dealer = this.players - 1;
        }
        this.actualPlayer = 0;
        this.startingPlayer = 0;
    }

    public void nextDealer() {
        this.dealer = (this.dealer + 1) % this.players;
        while (ACTIVE[this.dealer] == 0) {
            this.dealer = (this.dealer + 1) % this.players;
        }
        this.smallBlind = (this.dealer + 1) % this.players;
        while (ACTIVE[this.smallBlind] == 0) {
            this.smallBlind = (this.smallBlind + 1) % this.players;
        }
        this.bigBlind = (this.smallBlind + 1) % this.players;
        while (ACTIVE[this.bigBlind] == 0) {
            this.bigBlind = (this.bigBlind + 1) % this.players;
        }
        this.actualPlayer = (this.bigBlind + 1) % this.players;
        while (ACTIVE[this.actualPlayer] == 0) {
            this.actualPlayer = (this.actualPlayer + 1) % this.players;
        }
        this.startingPlayer = this.actualPlayer;
        this.setChipsPos();
        this.bMovingChips = true;
    }

    public void initNextHand() {
        this.iNextHandCounter = 3;
    }

    public void updateNextHand() {
        if (this.iNextHandCounter > 0) {
            --this.iNextHandCounter;
            if (this.iNextHandCounter <= 0) {
                this.nextHand();
            }
        }
    }

    public void nextHand() {
        this.activePlayers = 0;
        for (int i = 0; i < this.players; ++i) {
            if (CHIPS[i] < this.bbValue || ACTIVE[i] == 0) {
                if (ACTIVE[i] != 1) continue;
                ScreenGame.ACTIVE[i] = 0;
                continue;
            }
            ++this.activePlayers;
        }
        this.activePlayingPlayers = this.activePlayers;
        this.raiseValueCounter = 0;
        ++this.hand;
        this.minRaiseValue = 0;
        this.maxRaiseValue = 0;
        this.pot = 0;
        this.highestBet = 0;
        this.pomRaiseValue = 0;
        this.playersSelection = 0;
        this.shownCardsPlayer = -1;
        this.highlightedPlayer = -1;
        this.winnersCount = 0;
        this.movingPotValue = 0;
        this.movingPotPom = 0;
        this.endDialogPointer = 0;
        this.step = 1;
        this.value = 111 + this.step * 1000;
        ++this.raiseBlindsCounter;
        if (this.raiseBlindsCounter >= 5 && this.blindsPointer < this.maxBlinds) {
            boolean bOk = true;
            for (int i = 0; i < this.players; ++i) {
                if (ACTIVE[i] != 1 || CHIPS[i] >= GameDefines.BLINDS[this.blindsPointer + 1] << 1) continue;
                bOk = false;
                break;
            }
            if (bOk) {
                ++this.blindsPointer;
                this.sbValue = GameDefines.BLINDS[this.blindsPointer];
                this.bbValue = this.sbValue << 1;
                this.raiseBlindsCounter = 0;
            }
        }
        this.initParams();
        this.initTime();
        this.initArrays2();
        this.initArrows();
        this.shuffleCards();
        this.nextDealer();
        this.initNextStep();
        this.setDarkenLabels();
        Scores.initWinsSum();
    }

    public void checkInactivePlayers() {
        this.activePlayers = 0;
        for (int i = 0; i < this.players; ++i) {
            if (CHIPS[i] < this.bbValue) {
                ScreenGame.ACTIVE[i] = 0;
                continue;
            }
            ++this.activePlayers;
        }
        this.activePlayingPlayers = this.activePlayers;
        this.setDarkenLabels();
    }

    public void setDarkenLabels() {
        if (this.pPlayer != null) {
            for (int i = 0; i < this.players; ++i) {
                if (ACTIVE[i] == 0 || ACTION[i] == 1) {
                    if (this.pPlayer[i] == null) continue;
                    this.pPlayer[i].setDarkenLabel(true);
                    continue;
                }
                if (this.pPlayer[i] == null) continue;
                this.pPlayer[i].setDarkenLabel(false);
            }
        }
    }

    public void nextStep() {
        ++this.step;
        switch (this.step) {
            case 0: {
                this.initNumberOfOpponentsDialog();
                this.initPotPos();
                this.shuffleCards();
                break;
            }
            case 1: {
                this.initDealerAndBlinds();
                this.initArrays2();
                this.initPlayers();
                this.initCardsPos();
                this.initBetsPos();
                this.setPotsPos();
                this.initBlinds();
                this.initChips();
                break;
            }
            case 2: {
                this.bMovingChips = true;
            }
            case 3: 
            case 4: {
                this.initNextStep();
                break;
            }
            case 5: 
            case 6: {
                this.forcedBet();
                this.initNextStep();
                break;
            }
            case 7: {
                this.initDealingCards();
                break;
            }
            case 8: {
                this.setActualPlayer();
                this.initBetting();
                break;
            }
            case 9: {
                this.setActivePlayingPlayers(false);
                this.initDealingCards();
                break;
            }
            case 10: {
                this.setActualPlayer();
                this.initBetting();
                break;
            }
            case 11: {
                this.setActivePlayingPlayers(false);
                this.initDealingCards();
                break;
            }
            case 12: {
                this.setActualPlayer();
                this.initBetting();
                break;
            }
            case 13: {
                this.setActivePlayingPlayers(false);
                this.initDealingCards();
                break;
            }
            case 14: {
                this.setActualPlayer();
                this.initBetting();
                break;
            }
            case 15: {
                this.setActivePlayingPlayers(false);
                this.initShowCards();
                break;
            }
            case 16: {
                this.initEvaluation();
                break;
            }
            case 17: {
                this.initEndOfGame();
                break;
            }
        }
    }

    public void initBetting() {
        this.highestBet = 0;
        if (this.step == 8) {
            this.bRaise = true;
            this.highestBet = this.bbValue;
        }
        if (this.activePlayingPlayers <= 1) {
            this.initEndOfBettingRound();
        } else {
            this.betting();
        }
    }

    public void setActualPlayer() {
        switch (this.step) {
            case 8: {
                this.startingPlayer = (this.bigBlind + 1) % this.players;
                while (ACTIVE[this.startingPlayer] == 0) {
                    this.startingPlayer = (this.startingPlayer + 1) % this.players;
                }
                this.actualPlayer = this.startingPlayer;
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                this.startingPlayer = (this.dealer + 1) % this.players;
                while (ACTIVE[this.startingPlayer] == 0) {
                    this.startingPlayer = (this.startingPlayer + 1) % this.players;
                }
                this.actualPlayer = this.startingPlayer;
                break;
            }
        }
        this.bRaise = false;
        this.bStartOfBetting = true;
    }

    public void setActivePlayers() {
        this.activePlayers = 0;
        for (int i = 0; i < this.players; ++i) {
            if (ACTIVE[i] != 1) continue;
            ++this.activePlayers;
        }
    }

    public void setActivePlayingPlayers(boolean bNextPlayer) {
        this.activePlayingPlayers = 0;
        for (int i = 0; i < this.players; ++i) {
            if (ACTION[i] == 6 || ACTION[i] == 1 || ACTIVE[i] != 1) continue;
            ++this.activePlayingPlayers;
        }
        if (ACTIVE[this.startingPlayer] == 0 || ACTION[this.startingPlayer] == 1) {
            while (ACTIVE[this.startingPlayer] == 0 || ACTION[this.startingPlayer] == 1) {
                this.startingPlayer = (this.startingPlayer + 1) % this.players;
            }
        }
        if (this.activePlayingPlayers <= 1) {
            this.highlightedPlayer = -1;
            this.initShowCards();
        } else if (bNextPlayer) {
            this.initNextPlayer();
        }
    }

    public void initNextStep() {
        if (!this.bNextStep) {
            this.nextStepCounter = this.activePlayingPlayers <= 1 && this.step < 14 ? 1 : (this.step == 8 || this.step == 9 || this.step == 11 || this.step == 13 || this.step == 10 || this.step == 12 || this.step == 14 ? 15 : (this.step == 15 ? 1 : 10));
            if (this.bSkip && this.nextStepCounter > 3) {
                this.nextStepCounter = 3;
            }
            this.bNextStep = true;
            this.initActions();
        }
    }

    public void updateNextStep() {
        if (!this.bShownCards && this.bNextStep && !this.bDealingCards) {
            if (this.nextStepCounter > 0) {
                --this.nextStepCounter;
            } else {
                this.nextStepCounter = 0;
                this.bNextStep = false;
                this.nextStep();
            }
        }
    }

    public void forcedBet() {
        if (this.step == 5) {
            if (CHIPS[this.smallBlind] > 0) {
                int n = this.smallBlind;
                CHIPS[n] = CHIPS[n] - this.sbValue;
                ScreenGame.BET[this.smallBlind] = this.sbValue;
            } else {
                System.out.println("Exception> Small blind does not have enough chips!");
            }
        } else if (this.step == 6) {
            if (CHIPS[this.bigBlind] > 0) {
                int n = this.bigBlind;
                CHIPS[n] = CHIPS[n] - this.bbValue;
                ScreenGame.BET[this.bigBlind] = this.bbValue;
                if (CHIPS[this.bigBlind] == 0) {
                    ScreenGame.ACTION[this.bigBlind] = 6;
                }
            } else {
                System.out.println("Exception> Big blind does not have enough chips!");
            }
        }
        if (!this.bRaise) {
            this.bRaise = true;
            this.highestBet = this.bbValue;
        }
        this.initMoveBet();
    }

    public void initShowCards() {
        this.shownCardsPlayer = -1;
        this.shownCardsCounter = 5;
        this.bShownCards = true;
    }

    public void updateShowCards() {
        if (this.bShownCards && !this.bMovingBets) {
            if (this.shownCardsCounter > 0) {
                --this.shownCardsCounter;
            } else {
                boolean isShownAction = false;
                if (this.shownCardsPlayer == -1) {
                    if (this.step == 15) {
                        for (int i = 0; i < this.players; ++i) {
                            if (ACTIVE[i] != 1 || ACTION[i] != 6) continue;
                            if (!isShownAction) {
                                isShownAction = true;
                            }
                            ScreenGame.ACTION[i] = 0;
                        }
                    }
                    if (!isShownAction) {
                        this.shownCardsPlayer = this.startingPlayer;
                        while (ACTIVE[this.shownCardsPlayer] == 0 || ACTION[this.shownCardsPlayer] == 1 || SHOWN_CARDS[this.shownCardsPlayer] == 1) {
                            this.shownCardsPlayer = (this.shownCardsPlayer + 1) % this.players;
                            if (this.shownCardsPlayer != this.startingPlayer) continue;
                            this.bShownCards = false;
                            break;
                        }
                    }
                } else {
                    this.shownCardsPlayer = (this.shownCardsPlayer + 1) % this.players;
                    while (ACTIVE[this.shownCardsPlayer] == 0 || ACTION[this.shownCardsPlayer] == 1 || SHOWN_CARDS[this.shownCardsPlayer] == 1) {
                        this.shownCardsPlayer = (this.shownCardsPlayer + 1) % this.players;
                        if (this.shownCardsPlayer != this.startingPlayer) continue;
                        this.bShownCards = false;
                        break;
                    }
                }
                if (isShownAction) {
                    this.shownCardsCounter = 10;
                    if (this.bSkip) {
                        this.shownCardsCounter = 3;
                    }
                } else if (this.bShownCards) {
                    ScreenGame.SHOWN_CARDS[this.shownCardsPlayer] = 1;
                    this.shownCardsCounter = 10;
                    if (this.bSkip) {
                        this.shownCardsCounter = 3;
                    }
                } else {
                    this.initNextStep();
                }
            }
        }
    }

    public void openDialog() {
        this.bDialogActive = true;
    }

    public void closeDialog() {
        this.bDialogActive = false;
    }

    public void initEvaluation() {
        POT_TEMP = null;
        this.evaluationCounter = 15;
        if (this.bSkip) {
            this.evaluationCounter = 3;
            this.bSkip = false;
        }
        this.bEvaluation = true;
    }

    public void updateEvaluation() {
        if (this.bEvaluation) {
            if (this.evaluationCounter > 0) {
                --this.evaluationCounter;
            } else {
                this.bEvaluation = false;
                this.initCardsAnalysis();
                for (int i = 0; i < this.players; ++i) {
                    if (ACTIVE[i] != 1) continue;
                    this.setCombination(i);
                }
                this.identifyWinners(true);
            }
        }
    }

    public void identifyWinners(boolean bContinue) {
        int i;
        if (this.bSkip) {
            this.bSkip = false;
        }
        POT_TEMP = new int[POT.length];
        for (i = 0; i < POT.length; ++i) {
            ScreenGame.POT_TEMP[i] = POT[i];
        }
        for (i = POT.length - 1; i >= 0; --i) {
            if (POT[i] <= 0) continue;
            byte bestComb = 0;
            int position = 0;
            byte player = 0;
            int count = 0;
            byte bestKicker = 1;
            if (!this.bOneActivePlayer) {
                int j;
                for (j = 0; j < this.players; ++j) {
                    position = i * this.players + j;
                    player = POT_PLAYERS[position];
                    if (player == -1 || ACTIVE[player] != 1 || ACTION[player] == 1 || COMBINATION_INFO[player * 2] <= bestComb) continue;
                    bestComb = COMBINATION_INFO[player * 2];
                }
                for (j = 0; j < this.players; ++j) {
                    position = i * this.players + j;
                    player = POT_PLAYERS[position];
                    if (player != -1) {
                        if (ACTIVE[player] != 1 || ACTION[player] == 1) continue;
                        if (COMBINATION_INFO[player * 2] == bestComb) {
                            ++count;
                            ScreenGame.POT_WINNERS[position] = 1;
                            continue;
                        }
                        ScreenGame.POT_WINNERS[position] = -1;
                        continue;
                    }
                    ScreenGame.POT_WINNERS[position] = -1;
                }
                this.winnersCount = 0;
                if (count > 1) {
                    for (j = 0; j < 5; ++j) {
                        int k;
                        bestKicker = 1;
                        for (k = 0; k < this.players; ++k) {
                            byte pomValue;
                            position = i * this.players + k;
                            player = POT_PLAYERS[position];
                            if (POT_WINNERS[position] != 1 || this.compareCards(pomValue = this.getValue(SORTED_CARDS[player * 7 + j]), bestKicker) != 1) continue;
                            bestKicker = pomValue;
                        }
                        this.winnersCount = 0;
                        for (k = 0; k < this.players; ++k) {
                            position = i * this.players + k;
                            player = POT_PLAYERS[position];
                            if (POT_WINNERS[position] != 1) continue;
                            if (this.getValue(SORTED_CARDS[player * 7 + j]) == bestKicker) {
                                ++this.winnersCount;
                                continue;
                            }
                            ScreenGame.POT_WINNERS[position] = -1;
                        }
                        if (this.winnersCount != 1) {
                            continue;
                        }
                        break;
                    }
                } else {
                    this.winnersCount = 1;
                }
                for (j = 0; j < this.players; ++j) {
                    position = i * this.players + j;
                    player = POT_PLAYERS[position];
                    if (player == -1 || POT_WINNERS[position] != 1) continue;
                    ScreenGame.WINNER[player] = 1;
                }
            }
            int pom = 0;
            String s = "";
            if (Resources.langCode.compareTo("es") == 0) {
                s = s + Resources.resTexts[0].getHashedString(69);
            }
            for (int j = 0; j < this.players; ++j) {
                if (WINNER[j] != 1) continue;
                s = j == 0 ? s + strPlayer : s + GameDefines.STR_FACE[PLAYERS_FACE[j]];
                if (this.winnersCount - ++pom > 1) {
                    s = s + ", ";
                    continue;
                }
                if (this.winnersCount - pom != 1) break;
                s = s + " " + strAnd + " ";
            }
            int playersMovingPot = 0;
            if (!this.bOneActivePlayer) {
                this.movingPotPom = POT[i];
                ScreenGame.POT[i] = 0;
                playersMovingPot = this.movingPotPom / this.winnersCount;
            } else {
                playersMovingPot = this.pot;
                for (int j = 0; j < POT.length; ++j) {
                    ScreenGame.POT[i] = 0;
                }
            }
            if (WINNER[0] == 1 && !this.bOneActivePlayer) {
                Scores.checkAchievWinCombination(bestComb);
            }
            s = this.winnersCount > 1 ? s + "\n" + strWin : s + "\n" + strWins;
            s = s + " " + playersMovingPot + "!";
            if (!this.bOneActivePlayer) {
                s = s + "\n \n" + STR_COMBINATION[bestComb];
            }
            int width = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
            this.prepText1.prepareText(s, width - (width >> 3));
            this.prepText2.prepareText("", width);
            this.initEvaluationDialog();
            if (!bContinue) break;
            this.initEndDialog();
            break;
        }
    }

    public void initEvaluationDialog() {
        int width = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            width = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 2);
        }
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        int height = this.prepText1.getTextHeight() + (this.fontGoldBig.getHeight() << 2);
        int y = (MainCanvas.HEIGHT >> 1) - (height >> 1);
        this.rectDialog = new Rectangle(x, y, width, height);
    }

    public void setCombination(int player) {
        byte[] POM = new byte[7];
        POM[0] = HOLE_CARDS[player * 2];
        POM[1] = HOLE_CARDS[player * 2 + 1];
        for (int i = 0; i < 5; ++i) {
            POM[i + 2] = COMMUNITY_CARDS[i];
        }
        this.setCardsAnalysis(player, POM);
        int combType = 0;
        if (this.hasRoyalFlush(player, POM)) {
            combType = 10;
        } else if (this.hasStraightFlush(player, POM)) {
            combType = 9;
        } else if (this.hasFourOfAKind(player, POM)) {
            combType = 8;
        } else if (this.hasFullHouse(player, POM)) {
            combType = 7;
        } else if (this.hasFlush(player, POM)) {
            combType = 6;
        } else if (this.hasStraight(player, POM)) {
            combType = 5;
        } else if (this.hasThreeOfAKind(player, POM)) {
            combType = 4;
        } else if (this.hasTwoPairs(player, POM)) {
            combType = 3;
        } else if (this.hasPair(player, POM)) {
            combType = 2;
        } else if (this.hasHighCard(player, POM)) {
            combType = 1;
        }
        if (combType == 0) {
            byte[] POM_SORTED = this.sortKickers(POM);
            for (int i = 0; i < 7; ++i) {
                ScreenGame.SORTED_CARDS[player * 7 + i] = POM_SORTED[i];
            }
        }
        ScreenGame.COMBINATION_INFO[player * 2] = combType;
        int combSize = 0;
        combSize = combType == 0 ? 0 : (combType == 1 ? 1 : (combType == 2 ? 2 : (combType == 4 ? 3 : (combType == 8 || combType == 3 ? 4 : 5))));
        ScreenGame.COMBINATION_INFO[player * 2 + 1] = combSize;
    }

    public void initCardsAnalysis() {
        int i;
        COMBINATION_INFO = new byte[2 * this.players];
        SORTED_CARDS = new byte[7 * this.players];
        DIVIDED_CARDS = new byte[52 * this.players];
        CARDS_SUITS_COUNT = new byte[4 * this.players];
        CARDS_VALUES_COUNT = new byte[13 * this.players];
        for (i = 0; i < COMBINATION_INFO.length; ++i) {
            ScreenGame.COMBINATION_INFO[i] = -1;
        }
        for (i = 0; i < SORTED_CARDS.length; ++i) {
            ScreenGame.SORTED_CARDS[i] = -1;
        }
        for (i = 0; i < DIVIDED_CARDS.length; ++i) {
            ScreenGame.DIVIDED_CARDS[i] = -1;
        }
        for (i = 0; i < CARDS_SUITS_COUNT.length; ++i) {
            ScreenGame.CARDS_SUITS_COUNT[i] = 0;
        }
        for (i = 0; i < CARDS_VALUES_COUNT.length; ++i) {
            ScreenGame.CARDS_VALUES_COUNT[i] = 0;
        }
    }

    public void setCardsAnalysis(int player, byte[] POM_CARDS) {
        for (int i = 0; i < 7; ++i) {
            byte value = this.getValue(POM_CARDS[i]);
            byte suit = this.getSuit(POM_CARDS[i]);
            ScreenGame.DIVIDED_CARDS[52 * player + value * 4 + suit] = POM_CARDS[i];
            int n = 4 * player + suit;
            CARDS_SUITS_COUNT[n] = (byte)(CARDS_SUITS_COUNT[n] + 1);
            int n2 = 13 * player + value;
            CARDS_VALUES_COUNT[n2] = (byte)(CARDS_VALUES_COUNT[n2] + 1);
        }
    }

    public byte[] sortKickers(byte[] POM) {
        int size = POM.length;
        byte[] SORTED = new byte[size];
        byte[] UNSORTED = new byte[size];
        for (int i = 0; i < size; ++i) {
            SORTED[i] = -1;
            UNSORTED[i] = POM[i];
        }
        int pointer = 0;
        for (int i = 0; i < size; ++i) {
            int highest;
            for (highest = 0; UNSORTED[highest] == -1 && highest < size - 1; ++highest) {
            }
            for (int j = 0; j < size; ++j) {
                if (UNSORTED[j] == -1 || this.compareCards(UNSORTED[j], UNSORTED[highest]) != 1) continue;
                highest = j;
            }
            SORTED[pointer] = UNSORTED[highest];
            UNSORTED[highest] = -1;
            ++pointer;
        }
        return SORTED;
    }

    public int compareCards(byte mCard1, byte mCard2) {
        byte[] VALUES = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 0};
        int[] card = new int[2];
        int[] cardValue = new int[2];
        card[0] = mCard1;
        card[1] = mCard2;
        cardValue[0] = 0;
        cardValue[1] = 0;
        block0: for (int i = 0; i < 2; ++i) {
            cardValue[i] = this.getValue(card[i]);
            for (int j = 0; j < VALUES.length; ++j) {
                if (cardValue[i] != VALUES[j]) continue;
                cardValue[i] = j;
                continue block0;
            }
        }
        if (cardValue[0] > cardValue[1]) {
            return 1;
        }
        if (cardValue[0] < cardValue[1]) {
            return -1;
        }
        return 0;
    }

    public boolean hasRoyalFlush(int player, byte[] POM_CARDS) {
        boolean has = false;
        byte pom = 0;
        for (int i = 0; i < 4; ++i) {
            int count = 0;
            pom = DIVIDED_CARDS[52 * player + 0 + i];
            if (pom != -1) {
                ScreenGame.SORTED_CARDS[7 * player] = pom;
                count = 1;
                for (int j = 12; j >= 9 && (pom = DIVIDED_CARDS[52 * player + j * 4 + i]) != -1; --j) {
                    ScreenGame.SORTED_CARDS[7 * player + (++count - 1)] = pom;
                }
            }
            if (count != 5) continue;
            has = true;
            int pointer = 0;
            byte[] KICKERS = new byte[2];
            for (int j = 0; j < 7; ++j) {
                boolean isOk = true;
                for (int k = 0; k < 5; ++k) {
                    if (POM_CARDS[j] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j];
                ++pointer;
            }
            byte[] SORTED_KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 5] = SORTED_KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = SORTED_KICKERS[1];
            break;
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasStraightFlush(int player, byte[] POM_CARDS) {
        boolean has = false;
        for (int i = 0; i < 4; ++i) {
            int count = 0;
            for (int j = 12; j >= 0; --j) {
                byte pom2;
                byte pom = DIVIDED_CARDS[52 * player + j * 4 + i];
                if (pom == -1 || count >= 5) continue;
                count = j < 12 ? ((pom2 = DIVIDED_CARDS[52 * player + (j + 1) * 4 + i]) != -1 ? ++count : 1) : ++count;
                if (count <= 5) {
                    ScreenGame.SORTED_CARDS[player * 7 + (count - 1)] = pom;
                }
                if (count == 5) break;
            }
            if (count != 5) continue;
            has = true;
            int pointer = 0;
            byte[] KICKERS = new byte[2];
            for (int j = 0; j < 7; ++j) {
                boolean isOk = true;
                for (int k = 0; k < 5; ++k) {
                    if (POM_CARDS[j] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[1];
            break;
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasFourOfAKind(int player, byte[] POM_CARDS) {
        boolean has = false;
        int value = 0;
        if (CARDS_VALUES_COUNT[13 * player + 0] == 4) {
            value = 0;
            has = true;
        } else {
            for (int i = 12; i >= 1; --i) {
                if (CARDS_VALUES_COUNT[13 * player + i] != 4) continue;
                value = i;
                has = true;
                break;
            }
        }
        if (has) {
            int pointer = 0;
            byte pom = 0;
            for (int i = 0; i < 4; ++i) {
                pom = DIVIDED_CARDS[52 * player + value * 4 + i];
                if (pom == -1) continue;
                ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                ++pointer;
            }
            pointer = 0;
            byte[] KICKERS = new byte[3];
            for (int j = 0; j < 7; ++j) {
                boolean isOk = true;
                for (int k = 0; k < 4; ++k) {
                    if (POM_CARDS[j] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 4] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[1];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[2];
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasFullHouse(int player, byte[] POM_CARDS) {
        int value2;
        int value1;
        boolean has;
        block14: {
            int i;
            has = false;
            value1 = 0;
            value2 = 0;
            if (CARDS_VALUES_COUNT[13 * player + 0] >= 3) {
                value1 = 0;
                for (i = 12; i >= 1; --i) {
                    if (CARDS_VALUES_COUNT[13 * player + i] < 2) continue;
                    value2 = i;
                    has = true;
                    break;
                }
            } else {
                for (i = 12; i >= 1; --i) {
                    if (CARDS_VALUES_COUNT[13 * player + i] < 3) continue;
                    value1 = i;
                    if (CARDS_VALUES_COUNT[13 * player + 0] >= 2) {
                        value2 = 0;
                        has = true;
                        break;
                    }
                    for (int j = 12; j >= 1; --j) {
                        if (j == i || CARDS_VALUES_COUNT[13 * player + j] < 2) continue;
                        value2 = j;
                        has = true;
                        break block14;
                    }
                    break;
                }
            }
        }
        if (has) {
            int j;
            int pointer = 0;
            byte pom = 0;
            for (j = 0; j < 4; ++j) {
                pom = DIVIDED_CARDS[52 * player + value1 * 4 + j];
                if (pom != -1) {
                    ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                    ++pointer;
                }
                if (pointer == 3) break;
            }
            for (j = 0; j < 4; ++j) {
                pom = DIVIDED_CARDS[52 * player + value2 * 4 + j];
                if (pom != -1) {
                    ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                    ++pointer;
                }
                if (pointer == 5) break;
            }
            pointer = 0;
            byte[] KICKERS = new byte[2];
            for (int j2 = 0; j2 < 7; ++j2) {
                boolean isOk = true;
                for (int k = 0; k < 5; ++k) {
                    if (POM_CARDS[j2] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j2];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[1];
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasFlush(int player, byte[] POM_CARDS) {
        boolean has = false;
        int suit = 0;
        for (int i = 0; i < 4; ++i) {
            if (CARDS_SUITS_COUNT[4 * player + i] < 5) continue;
            suit = i;
            has = true;
            break;
        }
        if (has) {
            int pointer = 0;
            byte pom = DIVIDED_CARDS[52 * player + 0 + suit];
            if (pom != -1) {
                ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                ++pointer;
            }
            for (int i = 12; i >= 1; --i) {
                pom = DIVIDED_CARDS[52 * player + i * 4 + suit];
                if (pom != -1) {
                    ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                    ++pointer;
                }
                if (pointer == 5) break;
            }
            pointer = 0;
            byte[] KICKERS = new byte[2];
            for (int j = 0; j < 7; ++j) {
                boolean isOk = true;
                for (int k = 0; k < 5; ++k) {
                    if (POM_CARDS[j] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[1];
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasStraight(int player, byte[] POM_CARDS) {
        int j;
        boolean has = false;
        int count = 0;
        if (CARDS_VALUES_COUNT[13 * player + 0] >= 1) {
            count = 1;
            byte pom = 0;
            for (int i = 0; i < 4; ++i) {
                pom = DIVIDED_CARDS[52 * player + 0 + i];
                if (pom == -1) continue;
                ScreenGame.SORTED_CARDS[7 * player + (count - 1)] = pom;
                break;
            }
        }
        for (int i = 12; i >= 0; --i) {
            if (CARDS_VALUES_COUNT[13 * player + i] < 1) continue;
            count = i < 12 ? (CARDS_VALUES_COUNT[13 * player + (i + 1)] >= 1 ? ++count : 1) : ++count;
            if (count <= 5) {
                byte pom = 0;
                for (j = 0; j < 4; ++j) {
                    pom = DIVIDED_CARDS[52 * player + i * 4 + j];
                    if (pom == -1) continue;
                    ScreenGame.SORTED_CARDS[7 * player + (count - 1)] = pom;
                    break;
                }
            }
            if (count == 5) break;
        }
        if (count == 5) {
            has = true;
            int pointer = 0;
            byte[] KICKERS = new byte[2];
            for (j = 0; j < 7; ++j) {
                boolean isOk = true;
                for (int k = 0; k < 5; ++k) {
                    if (POM_CARDS[j] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[1];
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasThreeOfAKind(int player, byte[] POM_CARDS) {
        boolean has = false;
        int value = 0;
        if (CARDS_VALUES_COUNT[13 * player + 0] >= 3) {
            value = 0;
            has = true;
        } else {
            for (int i = 12; i >= 1; --i) {
                if (CARDS_VALUES_COUNT[13 * player + i] < 3) continue;
                value = i;
                has = true;
                break;
            }
        }
        if (has) {
            int pointer = 0;
            byte pom = 0;
            for (int i = 0; i < 4; ++i) {
                pom = DIVIDED_CARDS[52 * player + value * 4 + i];
                if (pom != -1) {
                    ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                    ++pointer;
                }
                if (pointer == 3) break;
            }
            pointer = 0;
            byte[] KICKERS = new byte[4];
            for (int j = 0; j < 7; ++j) {
                boolean isOk = true;
                for (int k = 0; k < 3; ++k) {
                    if (POM_CARDS[j] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 3] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 4] = KICKERS[1];
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[2];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[3];
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasTwoPairs(int player, byte[] POM_CARDS) {
        int value2;
        int value1;
        boolean has;
        block14: {
            int i;
            has = false;
            value1 = 0;
            value2 = 0;
            if (CARDS_VALUES_COUNT[13 * player + 0] >= 2) {
                value1 = 0;
                for (i = 12; i >= 1; --i) {
                    if (CARDS_VALUES_COUNT[13 * player + i] < 2) continue;
                    value2 = i;
                    has = true;
                    break;
                }
            } else {
                for (i = 12; i >= 1; --i) {
                    if (CARDS_VALUES_COUNT[13 * player + i] < 2) continue;
                    value1 = i;
                    if (CARDS_VALUES_COUNT[13 * player + 0] >= 2) {
                        value2 = 0;
                        has = true;
                        break;
                    }
                    for (int j = 12; j >= 1; --j) {
                        if (j == i || CARDS_VALUES_COUNT[13 * player + j] < 2) continue;
                        value2 = j;
                        has = true;
                        break block14;
                    }
                    break;
                }
            }
        }
        if (has) {
            int j;
            int pointer = 0;
            byte pom = 0;
            for (j = 0; j < 4; ++j) {
                pom = DIVIDED_CARDS[52 * player + value1 * 4 + j];
                if (pom != -1) {
                    ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                    ++pointer;
                }
                if (pointer == 2) break;
            }
            for (j = 0; j < 4; ++j) {
                pom = DIVIDED_CARDS[52 * player + value2 * 4 + j];
                if (pom != -1) {
                    ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                    ++pointer;
                }
                if (pointer == 4) break;
            }
            pointer = 0;
            byte[] KICKERS = new byte[3];
            for (int j2 = 0; j2 < 7; ++j2) {
                boolean isOk = true;
                for (int k = 0; k < 4; ++k) {
                    if (POM_CARDS[j2] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j2];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 4] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[1];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[2];
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasPair(int player, byte[] POM_CARDS) {
        boolean has = false;
        int value = 0;
        if (CARDS_VALUES_COUNT[13 * player + 0] >= 2) {
            value = 0;
            has = true;
        } else {
            for (int i = 12; i >= 1; --i) {
                if (CARDS_VALUES_COUNT[13 * player + i] < 2) continue;
                value = i;
                has = true;
                break;
            }
        }
        if (has) {
            int pointer = 0;
            byte pom = 0;
            for (int i = 0; i < 4; ++i) {
                pom = DIVIDED_CARDS[52 * player + value * 4 + i];
                if (pom != -1) {
                    ScreenGame.SORTED_CARDS[player * 7 + pointer] = pom;
                    ++pointer;
                }
                if (pointer == 2) break;
            }
            pointer = 0;
            byte[] KICKERS = new byte[5];
            for (int j = 0; j < 7; ++j) {
                boolean isOk = true;
                for (int k = 0; k < 2; ++k) {
                    if (POM_CARDS[j] != SORTED_CARDS[player * 7 + k]) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                KICKERS[pointer] = POM_CARDS[j];
                ++pointer;
            }
            KICKERS = this.sortKickers(KICKERS);
            ScreenGame.SORTED_CARDS[player * 7 + 2] = KICKERS[0];
            ScreenGame.SORTED_CARDS[player * 7 + 3] = KICKERS[1];
            ScreenGame.SORTED_CARDS[player * 7 + 4] = KICKERS[2];
            ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[3];
            ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[4];
        }
        if (!has) {
            this.initSortedCards(player);
        }
        return has;
    }

    public boolean hasHighCard(int player, byte[] POM_CARDS) {
        byte[] KICKERS = new byte[7];
        KICKERS = this.sortKickers(POM_CARDS);
        ScreenGame.SORTED_CARDS[player * 7] = KICKERS[0];
        ScreenGame.SORTED_CARDS[player * 7 + 1] = KICKERS[1];
        ScreenGame.SORTED_CARDS[player * 7 + 2] = KICKERS[2];
        ScreenGame.SORTED_CARDS[player * 7 + 3] = KICKERS[3];
        ScreenGame.SORTED_CARDS[player * 7 + 4] = KICKERS[4];
        ScreenGame.SORTED_CARDS[player * 7 + 5] = KICKERS[5];
        ScreenGame.SORTED_CARDS[player * 7 + 6] = KICKERS[6];
        return true;
    }

    public void initSortedCards(int player) {
        for (int i = 0; i < 7; ++i) {
            ScreenGame.SORTED_CARDS[player * 7 + i] = -1;
        }
    }

    public byte getValue(int mCard) {
        if (mCard == 13 || mCard == 39 || mCard == 26 || mCard == 0) {
            return 0;
        }
        if (mCard == 14 || mCard == 40 || mCard == 27 || mCard == 1) {
            return 1;
        }
        if (mCard == 15 || mCard == 41 || mCard == 28 || mCard == 2) {
            return 2;
        }
        if (mCard == 16 || mCard == 42 || mCard == 29 || mCard == 3) {
            return 3;
        }
        if (mCard == 17 || mCard == 43 || mCard == 30 || mCard == 4) {
            return 4;
        }
        if (mCard == 18 || mCard == 44 || mCard == 31 || mCard == 5) {
            return 5;
        }
        if (mCard == 19 || mCard == 45 || mCard == 32 || mCard == 6) {
            return 6;
        }
        if (mCard == 20 || mCard == 46 || mCard == 33 || mCard == 7) {
            return 7;
        }
        if (mCard == 21 || mCard == 47 || mCard == 34 || mCard == 8) {
            return 8;
        }
        if (mCard == 22 || mCard == 48 || mCard == 35 || mCard == 9) {
            return 9;
        }
        if (mCard == 23 || mCard == 49 || mCard == 36 || mCard == 10) {
            return 10;
        }
        if (mCard == 24 || mCard == 50 || mCard == 37 || mCard == 11) {
            return 11;
        }
        return 12;
    }

    public byte getSuit(int mCard) {
        return (byte)(mCard / 13);
    }

    public void betting() {
        if (ACTIVE[this.startingPlayer] == 0 || ACTION[this.startingPlayer] == 1) {
            while (ACTIVE[this.startingPlayer] == 0 || ACTION[this.startingPlayer] == 1) {
                this.startingPlayer = (this.startingPlayer + 1) % this.players;
            }
        }
        if (this.actualPlayer == this.startingPlayer && !this.bRaise && !this.bStartOfBetting) {
            this.initEndOfBettingRound();
        } else {
            while (ACTIVE[this.actualPlayer] == 0 || ACTION[this.actualPlayer] == 1) {
                this.actualPlayer = (this.actualPlayer + 1) % this.players;
            }
            if (BETS[this.actualPlayer] + BET[this.actualPlayer] >= this.highestBet) {
                this.bRaise = false;
            }
            if (!(this.actualPlayer != this.startingPlayer || this.bRaise || BETS[this.actualPlayer] <= 0 && this.bStartOfBetting)) {
                this.initEndOfBettingRound();
            } else if (ACTION[this.actualPlayer] == 6) {
                this.actualPlayer = (this.actualPlayer + 1) % this.players;
                this.betting();
            } else {
                ScreenGame.ACTION[this.actualPlayer] = 0;
                if (this.bStartOfBetting) {
                    this.bStartOfBetting = false;
                }
                this.highlightedPlayer = this.actualPlayer;
                this.setRaiseValueInterval();
                if (this.actualPlayer != 0) {
                    this.initMakeChoice();
                } else {
                    this.initContextMenu();
                }
            }
        }
    }

    public void initEndOfBettingRound() {
        this.endOfBettingRoundCounter = this.activePlayingPlayers <= 1 ? 1 : 15;
        if (this.bSkip && this.endOfBettingRoundCounter > 3) {
            this.endOfBettingRoundCounter = 3;
        }
        this.bEndOfBettingRound = true;
    }

    public void updateEndOfBettingRound() {
        if (!this.bShownCards && this.bEndOfBettingRound) {
            if (this.endOfBettingRoundCounter > 0) {
                --this.endOfBettingRoundCounter;
            } else {
                this.bEndOfBettingRound = false;
                this.initMoveBets();
            }
        }
    }

    public void initMakeChoice() {
        this.makeChoiceCounter = 20;
        if (this.bSkip) {
            this.makeChoiceCounter = 3;
        }
        this.bMakeChoice = true;
    }

    public void updateMakeChoice() {
        if (this.bMakeChoice) {
            if (this.makeChoiceCounter > 0) {
                --this.makeChoiceCounter;
            } else {
                this.bMakeChoice = false;
                this.makeChoice();
            }
        }
    }

    public void initMoveBet() {
        boolean bRaised = false;
        for (int i = 0; i < this.players; ++i) {
            if (BET[i] <= 0) continue;
            bRaised = true;
            break;
        }
        if (bRaised) {
            this.bMovingBet = true;
        }
    }

    public void updateBet() {
        if (this.bMovingBet) {
            boolean isOK = true;
            for (int i = 0; i < this.players; ++i) {
                if (BET[i] <= 0) continue;
                if (BET_X[i] != BET_RIGHT_POS_X[i] || BET_Y[i] != BET_RIGHT_POS_Y[i]) {
                    isOK = false;
                    this.ddaBet(i);
                    continue;
                }
                int n = i;
                BETS[n] = BETS[n] + BET[i];
                ScreenGame.BET[i] = 0;
                ScreenGame.BET_X[i] = this.pPlayer[i].getChipsValueX();
                ScreenGame.BET_Y[i] = this.pPlayer[i].getChipsValueY();
            }
            if (isOK) {
                this.bMovingBet = false;
            }
        }
    }

    public void initMoveBets() {
        this.highlightedPlayer = -1;
        this.bMovingBets = true;
        this.initActions();
    }

    public void updateBets() {
        if (!this.bShownCards && this.bMovingBets) {
            boolean isOK = true;
            for (int i = 0; i < this.players; ++i) {
                if (BETS[i] <= 0) continue;
                if (BETS_X[i] != this.pomPotX || BETS_Y[i] != this.pomPotY) {
                    isOK = false;
                    this.ddaBets(i);
                    continue;
                }
                this.addPot(BETS[i]);
                ScreenGame.BETS[i] = 0;
                ScreenGame.BETS_X[i] = BET_RIGHT_POS_X[i];
                ScreenGame.BETS_Y[i] = BET_RIGHT_POS_Y[i];
            }
            if (isOK) {
                this.bMovingBets = false;
                this.activePlayers = 0;
                int pointer = 0;
                for (int i = 0; i < this.players; ++i) {
                    if (ACTIVE[i] != 1 || ACTION[i] == 1) continue;
                    ++this.activePlayers;
                    pointer = i;
                }
                if (this.activePlayers <= 1) {
                    this.bOneActivePlayer = true;
                    ScreenGame.WINNER[pointer] = 1;
                    if (ACTION[pointer] != 0) {
                        ScreenGame.ACTION[pointer] = 0;
                    }
                    this.initCardsAnalysis();
                    this.step = 16;
                    this.value = 999;
                    this.identifyWinners(true);
                } else {
                    this.initNextStep();
                }
            }
        }
    }

    public void initAllActions() {
        for (int i = 0; i < this.players; ++i) {
            ScreenGame.ACTION[i] = 0;
        }
    }

    public void initActions() {
        if (this.step > 7) {
            for (int i = 0; i < this.players; ++i) {
                if (ACTION[i] == 6 || ACTION[i] == 1) continue;
                ScreenGame.ACTION[i] = 0;
            }
        }
    }

    public void makeChoice() {
        int count = 0;
        for (int i = 0; i < this.players; ++i) {
            if (i == this.actualPlayer || ACTIVE[i] != 1 || ACTION[i] == 6 || ACTION[i] == 1) continue;
            ++count;
        }
        if (count > 0) {
            if (this.step == 8 && this.actualPlayer == this.smallBlind && this.highestBet == this.bbValue) {
                int rand = RandomNum.getRandomUInt(10);
                if (rand < 8) {
                    this.call();
                } else if (rand < 9) {
                    this.raise();
                } else if (CHIPS[this.actualPlayer] >= this.bbValue) {
                    this.fold();
                } else {
                    this.call();
                }
            } else {
                this.modeNew();
            }
        } else if (this.bRaise) {
            this.callNew();
        } else {
            this.check();
        }
        this.initNextPlayer();
    }

    public void modeNew() {
        int[] POM;
        switch (PLAYERS_MODE[this.actualPlayer]) {
            case 0: {
                POM = this.NEW_PROBS_1;
                break;
            }
            case 1: {
                POM = this.NEW_PROBS_2;
                break;
            }
            case 2: {
                POM = this.NEW_PROBS_3;
                break;
            }
            case 3: {
                POM = this.NEW_PROBS_4;
                break;
            }
            case 4: {
                POM = this.NEW_PROBS_5;
                break;
            }
            default: {
                POM = this.NEW_PROBS_3;
            }
        }
        int rand = RandomNum.getRandomUInt(this.NEW_PROBS_TOTAL);
        if (this.bRaise) {
            if (rand < POM[2]) {
                this.foldNew();
            } else if (rand < POM[2] + POM[3]) {
                this.callNew();
            } else {
                this.raiseNew();
            }
        } else if (rand < POM[0]) {
            this.check();
        } else {
            this.betNew();
        }
    }

    public void foldNew() {
        if (CHIPS[this.actualPlayer] < this.bbValue) {
            this.call();
        } else {
            this.fold();
        }
    }

    public void raiseNew() {
        if (CHIPS[this.actualPlayer] > this.highestBet - BETS[this.actualPlayer] - BET[this.actualPlayer]) {
            this.raise();
        } else {
            this.callNew();
        }
    }

    public void callNew() {
        if (CHIPS[this.actualPlayer] > 0) {
            this.call();
        } else {
            this.fold();
        }
    }

    public void betNew() {
        if (CHIPS[this.actualPlayer] > 0) {
            this.bet();
        } else {
            this.check();
        }
    }

    public void endOfPlayersTurn() {
        this.bWaitingForPlayer = false;
        this.closeContextMenu();
        this.initNextPlayer();
    }

    public void fold() {
        ScreenGame.ACTION[this.actualPlayer] = 1;
        if (this.actualPlayer == this.startingPlayer) {
            while (ACTIVE[this.startingPlayer] == 0 || ACTION[this.startingPlayer] == 1) {
                this.startingPlayer = (this.startingPlayer + 1) % this.players;
            }
        }
        this.initFoldingCards();
        if (this.actualPlayer == 0) {
            int count = 0;
            for (int i = 0; i < this.players; ++i) {
                if (ACTION[i] == 1 || ACTIVE[i] != 1) continue;
                ++count;
            }
            if (count >= 2) {
                this.bShowSkipButton = true;
            }
            this.endOfPlayersTurn();
        }
        this.setDarkenLabels();
    }

    public void check() {
        ScreenGame.ACTION[this.actualPlayer] = 2;
        if (this.actualPlayer == 0) {
            this.endOfPlayersTurn();
        }
    }

    public void call() {
        int pomRaise = this.highestBet - BETS[this.actualPlayer] - BET[this.actualPlayer];
        ScreenGame.ACTION[this.actualPlayer] = 4;
        if (CHIPS[this.actualPlayer] <= pomRaise) {
            pomRaise = CHIPS[this.actualPlayer];
            ScreenGame.ACTION[this.actualPlayer] = 6;
        }
        int n = this.actualPlayer;
        BET[n] = BET[n] + pomRaise;
        int n2 = this.actualPlayer;
        CHIPS[n2] = CHIPS[n2] - pomRaise;
        this.initMoveBet();
        if (this.actualPlayer == 0) {
            this.endOfPlayersTurn();
        }
    }

    public void raise() {
        int pomBet = 0;
        pomBet = this.actualPlayer == 0 ? this.pomRaiseValue : this.getRaiseValue(this.actualPlayer);
        this.checkMaxRaiseValue();
        int pomRaise = (pomBet += BETS[this.actualPlayer] + BET[this.actualPlayer]) - BETS[this.actualPlayer] - BET[this.actualPlayer];
        if (pomRaise > this.maxRaiseValue) {
            pomRaise = this.maxRaiseValue;
        }
        ScreenGame.ACTION[this.actualPlayer] = 5;
        if (CHIPS[this.actualPlayer] <= pomRaise) {
            pomRaise = CHIPS[this.actualPlayer];
            ScreenGame.ACTION[this.actualPlayer] = 6;
        }
        int n = this.actualPlayer;
        BET[n] = BET[n] + pomRaise;
        int n2 = this.actualPlayer;
        CHIPS[n2] = CHIPS[n2] - pomRaise;
        if (this.highestBet < BETS[this.actualPlayer] + BET[this.actualPlayer]) {
            this.highestBet = BETS[this.actualPlayer] + BET[this.actualPlayer];
        }
        this.bRaise = true;
        this.startingPlayer = this.actualPlayer;
        this.initMoveBet();
        if (this.actualPlayer == 0) {
            this.endOfPlayersTurn();
        }
    }

    public void bet() {
        int pomBet = 0;
        pomBet = this.actualPlayer == 0 ? this.pomRaiseValue : this.getRaiseValue(this.actualPlayer);
        this.checkMaxRaiseValue();
        int pomRaise = (pomBet += BETS[this.actualPlayer] + BET[this.actualPlayer]) - BETS[this.actualPlayer] - BET[this.actualPlayer];
        if (pomRaise > this.maxRaiseValue) {
            pomRaise = this.maxRaiseValue;
        }
        ScreenGame.ACTION[this.actualPlayer] = 3;
        if (CHIPS[this.actualPlayer] <= pomRaise) {
            pomRaise = CHIPS[this.actualPlayer];
            ScreenGame.ACTION[this.actualPlayer] = 6;
        }
        int n = this.actualPlayer;
        BET[n] = BET[n] + pomRaise;
        int n2 = this.actualPlayer;
        CHIPS[n2] = CHIPS[n2] - pomRaise;
        if (this.highestBet < BETS[this.actualPlayer] + BET[this.actualPlayer]) {
            this.highestBet = BETS[this.actualPlayer] + BET[this.actualPlayer];
        }
        this.bRaise = true;
        this.startingPlayer = this.actualPlayer;
        this.initMoveBet();
        if (this.actualPlayer == 0) {
            this.endOfPlayersTurn();
        }
    }

    public int getRaiseValue(int player) {
        int pom2;
        int pom = 0;
        int randPom = RandomNum.getRandomUInt(5);
        switch (randPom) {
            case 0: {
                pom = RandomNum.getRandomUInt(CHIPS[player] >> 4);
                break;
            }
            case 1: {
                pom = RandomNum.getRandomUInt(CHIPS[player] >> 3);
                break;
            }
            case 2: {
                pom = RandomNum.getRandomUInt(CHIPS[player] >> 2);
                break;
            }
            case 3: {
                pom = RandomNum.getRandomUInt(CHIPS[player] >> 1);
                break;
            }
            default: {
                pom = RandomNum.getRandomUInt(CHIPS[player]);
            }
        }
        if (pom < this.sbValue + this.bbValue) {
            pom = this.sbValue + this.bbValue;
        }
        if (pom < this.highestBet + this.sbValue) {
            pom = this.highestBet + this.sbValue;
        }
        if ((pom = (pom2 = pom / this.sbValue) * this.sbValue) < this.sbValue + this.bbValue) {
            pom = this.sbValue + this.bbValue;
        }
        if (pom < this.highestBet + this.sbValue) {
            pom = this.highestBet + this.sbValue;
        }
        return pom;
    }

    public void checkMaxRaiseValue() {
        this.maxRaiseValue = 0;
        for (int i = 0; i < this.players; ++i) {
            int pom;
            if (i == this.actualPlayer || ACTIVE[i] != 1 || ACTION[i] == 1 || ACTION[i] == 6 || (pom = CHIPS[i] + BETS[i] + BET[i] - BETS[this.actualPlayer] - BET[this.actualPlayer]) <= this.maxRaiseValue) continue;
            this.maxRaiseValue = pom;
        }
        if (this.maxRaiseValue > CHIPS[this.actualPlayer]) {
            this.maxRaiseValue = CHIPS[this.actualPlayer];
        }
        if (this.minRaiseValue > this.maxRaiseValue) {
            this.minRaiseValue = this.maxRaiseValue;
        }
    }

    public void initFoldingCards() {
        this.bFoldingCards = true;
    }

    public void updateFoldingCards() {
        if (this.bFoldingCards) {
            boolean isOK = true;
            int player = 0;
            for (int i = 0; i < this.players << 1; ++i) {
                if (HOLE_CARDS[i] == -1 || ACTIVE[player = i / 2] != 1 || ACTION[player] != 1) continue;
                if (CARDS_X[i] != this.cardStackX || CARDS_Y[i] != this.cardStackY) {
                    if (isOK) {
                        isOK = false;
                    }
                    this.ddaFoldingCards(i);
                    continue;
                }
                ScreenGame.HOLE_CARDS[i] = -1;
            }
            if (isOK) {
                this.bFoldingCards = false;
            }
        }
    }

    public void initDropCards() {
        this.bDropingCards = true;
    }

    public void updateDropingCards() {
        if (this.bDropingCards) {
            int i;
            boolean isOK = true;
            for (i = 0; i < this.players << 1; ++i) {
                if (HOLE_CARDS[i] == -1) continue;
                if (CARDS_X[i] != this.cardStackX || CARDS_Y[i] != this.cardStackY) {
                    if (isOK) {
                        isOK = false;
                    }
                    this.ddaFoldingCards(i);
                    continue;
                }
                ScreenGame.HOLE_CARDS[i] = -1;
            }
            for (i = 0; i < 5; ++i) {
                if (COMMUNITY_CARDS[i] == -1) continue;
                if (COMMUNITY_CARDS_X[i] != this.cardStackX || COMMUNITY_CARDS_Y[i] != this.cardStackY) {
                    if (isOK) {
                        isOK = false;
                    }
                    this.ddaFoldingCommunityCards(i);
                    continue;
                }
                ScreenGame.COMMUNITY_CARDS[i] = -1;
            }
            if (isOK) {
                this.bDropingCards = false;
                Scores.addTime(this.pomTime, this.time);
                Scores.addHandsPlayed();
                if (Scores.getWinsSum() > 0) {
                    Scores.addHandsWon();
                    Scores.addXP(20);
                    Scores.checkBiggestWin();
                } else {
                    Scores.initActualHandsWonInRow();
                    Scores.addXP(5);
                }
                if (this.checkPlayersChips() && !this.checkPlayerLose()) {
                    if (Scores.getWinsSum() > 0) {
                        Scores.checkNewLevel();
                    }
                    Scores.initWinsSum();
                    Scores.save();
                    this.initNextHand();
                } else {
                    this.initNextStep();
                }
            }
        }
    }

    public boolean checkPlayerLose() {
        return CHIPS[0] < this.bbValue;
    }

    public void initEndOfGame() {
        int i;
        int count = 0;
        int mostChips = 0;
        int[] winners = new int[this.players];
        for (i = 0; i < this.players; ++i) {
            if (CHIPS[i] <= mostChips) continue;
            mostChips = CHIPS[i];
        }
        for (i = 0; i < this.players; ++i) {
            if (CHIPS[i] == mostChips) {
                winners[i] = 1;
                ++count;
                continue;
            }
            winners[i] = 0;
        }
        if (winners[0] == 1) {
            Scores.setAbsoluteWinner(true);
        } else {
            Scores.setAbsoluteWinner(false);
        }
        int width = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        String s = "";
        if (Resources.langCode.compareTo("es") == 0) {
            s = s + Resources.resTexts[0].getHashedString(69);
        }
        if (winners[0] == 1) {
            s = s + strPlayer + "\n" + strWinsGame;
        } else {
            if (count > 1) {
                int pomCount = 0;
                for (int i2 = 0; i2 < this.players; ++i2) {
                    if (winners[i2] != 1) continue;
                    s = s + GameDefines.STR_FACE[PLAYERS_FACE[i2]];
                    s = ++pomCount == count ? s + "\n" + strWinGame : (pomCount == count - 1 ? s + " " + strAnd + " " : s + ", ");
                }
            } else {
                for (int i3 = 0; i3 < this.players; ++i3) {
                    if (winners[i3] != 1) continue;
                    s = s + GameDefines.STR_FACE[PLAYERS_FACE[i3]] + "\n" + strWinsGame;
                    break;
                }
            }
            s = s + "\n \n";
            if (Resources.langCode.compareTo("es") == 0) {
                s = s + Resources.resTexts[0].getHashedString(69);
            }
            s = s + strPlayer + "\n" + strLosesGame;
        }
        this.prepText1.prepareText(s, width - (width >> 3));
        this.prepText2.prepareText("", width);
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        int height = this.prepText1.getTextHeight() + (this.fontGoldBig.getHeight() << 1);
        int y = (MainCanvas.HEIGHT >> 1) - ((height += this.sprWinChip.getHeight() + (this.fontGoldBig.getHeight() << 1)) >> 1);
        this.rectDialog = new Rectangle(x, y, width, height);
        this.endDialogPointer = 3;
        this.openDialog();
        this.initEndDialog();
    }

    public boolean checkPlayersChips() {
        int count = 0;
        for (int i = 0; i < this.players; ++i) {
            if (CHIPS[i] < this.bbValue) continue;
            ++count;
        }
        return count > 1;
    }

    public void initNextPlayer() {
        if (!this.bNextPlayer) {
            this.initMoveBet();
            this.highlightedPlayer = -1;
            this.nextPlayerCounter = this.activePlayingPlayers <= 1 ? 1 : 5;
            if (this.bSkip && this.nextPlayerCounter > 3) {
                this.nextPlayerCounter = 3;
            }
            this.bNextPlayer = true;
        }
    }

    public void updateNextPlayer() {
        if (this.bNextPlayer) {
            if (this.nextPlayerCounter > 0) {
                --this.nextPlayerCounter;
            } else {
                this.bNextPlayer = false;
                this.actualPlayer = (this.actualPlayer + 1) % this.players;
                this.betting();
            }
        }
    }

    public void initDealingCards() {
        this.dealingCardsCounter = 5;
        this.bDealingCards = true;
    }

    public void updateDealingCards() {
        if (!this.bShownCards && this.bDealingCards) {
            if (this.dealingCardsCounter > 0) {
                --this.dealingCardsCounter;
            } else {
                this.bDealingCards = false;
                if (this.step == 7) {
                    this.dealHoleCard();
                } else {
                    this.dealCommunityCard();
                }
            }
        }
    }

    public void dealHoleCard() {
        int index = (this.holeCardsPointer + this.smallBlind) % this.players << 1;
        if (this.holeCardsPointer >= this.players) {
            ++index;
        }
        int player = index / 2;
        ScreenGame.HOLE_CARDS[index] = CARDS[this.cardsPointer];
        ScreenGame.CARDS[this.cardsPointer] = -1;
        --this.cardsPointer;
        ++this.holeCardsPointer;
        this.bMovingHoleCards = true;
        if (this.holeCardsPointer >= this.players << 1) {
            for (int i = 0; i < HOLE_CARDS.length; ++i) {
                if (HOLE_CARDS[i] == -1 || ACTIVE[player = i / 2] != 0) continue;
                ScreenGame.HOLE_CARDS[i] = -1;
            }
            this.initNextStep();
        } else if (ACTIVE[player] == 0) {
            this.dealHoleCard();
        } else {
            this.initDealingCards();
        }
    }

    public void dealCommunityCard() {
        ScreenGame.COMMUNITY_CARDS[this.communityCardsPointer] = CARDS[this.cardsPointer];
        ScreenGame.CARDS[this.cardsPointer] = -1;
        --this.cardsPointer;
        ++this.communityCardsPointer;
        this.bMovingCommunityCards = true;
        boolean isOK = true;
        if (this.step == 9 && this.communityCardsPointer < 3 || this.step == 11 && this.communityCardsPointer < 4 || this.step == 13 && this.communityCardsPointer < 5) {
            isOK = false;
        }
        if (isOK) {
            this.initNextStep();
        } else {
            this.initDealingCards();
        }
    }

    public void updateHoleCards() {
        if (this.bMovingHoleCards) {
            boolean isOK = true;
            for (int i = 0; i < this.players << 1; ++i) {
                if (HOLE_CARDS[i] == -1 || CARDS_X[i] == CARDS_RIGHT_POS_X[i] && CARDS_Y[i] == CARDS_RIGHT_POS_Y[i]) continue;
                if (isOK) {
                    isOK = false;
                }
                this.ddaHoleCards(i);
            }
            if (this.holeCardsPointer < this.players) {
                isOK = false;
            }
            if (isOK) {
                this.bMovingHoleCards = false;
            }
        }
    }

    public void updateCommunityCards() {
        if (this.bMovingCommunityCards) {
            boolean isOK = true;
            for (int i = 0; i < 5; ++i) {
                if (COMMUNITY_CARDS[i] == -1 || COMMUNITY_CARDS_X[i] == COMMUNITY_CARDS_RIGHT_POS_X[i] && COMMUNITY_CARDS_Y[i] == COMMUNITY_CARDS_RIGHT_POS_Y[i]) continue;
                if (isOK) {
                    isOK = false;
                }
                this.ddaCommunityCards(i);
                this.iCommunityCardsFlipCounter[i] = 5;
            }
            if (this.step == 9 && this.communityCardsPointer < 3 || this.step == 11 && this.communityCardsPointer < 4 || this.step == 13 && this.communityCardsPointer < 5) {
                isOK = false;
            }
            if (isOK) {
                this.bMovingCommunityCards = false;
            }
        }
    }

    public void ddaFoldingCards(int id) {
        int deltaX = this.cardStackX - CARDS_X[id];
        int deltaY = this.cardStackY - CARDS_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(CARDS_X[id], CARDS_Y[id], this.cardStackX, this.cardStackY);
        if (CARDS_X[id] != this.cardStackX || CARDS_Y[id] != this.cardStackY) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 2) / count;
                yAdd = (deltaY << this.ddaShift + 2) / count;
            } else {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            }
        }
        int n = id;
        CARDS_X[n] = CARDS_X[n] + xAdd;
        int n2 = id;
        CARDS_Y[n2] = CARDS_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.CARDS_X[id] = this.cardStackX;
            ScreenGame.CARDS_Y[id] = this.cardStackY;
        }
    }

    public void ddaFoldingCommunityCards(int id) {
        int deltaX = this.cardStackX - COMMUNITY_CARDS_X[id];
        int deltaY = this.cardStackY - COMMUNITY_CARDS_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(COMMUNITY_CARDS_X[id], COMMUNITY_CARDS_Y[id], this.cardStackX, this.cardStackY);
        if (COMMUNITY_CARDS_X[id] != this.cardStackX || COMMUNITY_CARDS_Y[id] != this.cardStackY) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 2) / count;
                yAdd = (deltaY << this.ddaShift + 2) / count;
            } else {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            }
        }
        int n = id;
        COMMUNITY_CARDS_X[n] = COMMUNITY_CARDS_X[n] + xAdd;
        int n2 = id;
        COMMUNITY_CARDS_Y[n2] = COMMUNITY_CARDS_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.COMMUNITY_CARDS_X[id] = this.cardStackX;
            ScreenGame.COMMUNITY_CARDS_Y[id] = this.cardStackY;
        }
    }

    public void ddaHoleCards(int id) {
        int deltaX = CARDS_RIGHT_POS_X[id] - CARDS_X[id];
        int deltaY = CARDS_RIGHT_POS_Y[id] - CARDS_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(CARDS_X[id], CARDS_Y[id], CARDS_RIGHT_POS_X[id], CARDS_RIGHT_POS_Y[id]);
        if (CARDS_X[id] != CARDS_RIGHT_POS_X[id] || CARDS_Y[id] != CARDS_RIGHT_POS_Y[id]) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 2) / count;
                yAdd = (deltaY << this.ddaShift + 2) / count;
            } else {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            }
        }
        int n = id;
        CARDS_X[n] = CARDS_X[n] + xAdd;
        int n2 = id;
        CARDS_Y[n2] = CARDS_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.CARDS_X[id] = CARDS_RIGHT_POS_X[id];
            ScreenGame.CARDS_Y[id] = CARDS_RIGHT_POS_Y[id];
        }
    }

    public void ddaCommunityCards(int id) {
        int deltaX = COMMUNITY_CARDS_RIGHT_POS_X[id] - COMMUNITY_CARDS_X[id];
        int deltaY = COMMUNITY_CARDS_RIGHT_POS_Y[id] - COMMUNITY_CARDS_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(COMMUNITY_CARDS_X[id], COMMUNITY_CARDS_Y[id], COMMUNITY_CARDS_RIGHT_POS_X[id], COMMUNITY_CARDS_RIGHT_POS_Y[id]);
        if (COMMUNITY_CARDS_X[id] != COMMUNITY_CARDS_RIGHT_POS_X[id] || COMMUNITY_CARDS_Y[id] != COMMUNITY_CARDS_RIGHT_POS_Y[id]) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 2) / count;
                yAdd = (deltaY << this.ddaShift + 2) / count;
            } else {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            }
        }
        int n = id;
        COMMUNITY_CARDS_X[n] = COMMUNITY_CARDS_X[n] + xAdd;
        int n2 = id;
        COMMUNITY_CARDS_Y[n2] = COMMUNITY_CARDS_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.COMMUNITY_CARDS_X[id] = COMMUNITY_CARDS_RIGHT_POS_X[id];
            ScreenGame.COMMUNITY_CARDS_Y[id] = COMMUNITY_CARDS_RIGHT_POS_Y[id];
        }
    }

    public void ddaChips(int id) {
        int deltaX = CHIP_RIGHT_POS_X[id] - CHIP_X[id];
        int deltaY = CHIP_RIGHT_POS_Y[id] - CHIP_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(CHIP_X[id], CHIP_Y[id], CHIP_RIGHT_POS_X[id], CHIP_RIGHT_POS_Y[id]);
        if (CHIP_X[id] != CHIP_RIGHT_POS_X[id] || CHIP_Y[id] != CHIP_RIGHT_POS_Y[id]) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 2) / count;
                yAdd = (deltaY << this.ddaShift + 2) / count;
            } else {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            }
        }
        int n = id;
        CHIP_X[n] = CHIP_X[n] + xAdd;
        int n2 = id;
        CHIP_Y[n2] = CHIP_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.CHIP_X[id] = CHIP_RIGHT_POS_X[id];
            ScreenGame.CHIP_Y[id] = CHIP_RIGHT_POS_Y[id];
        }
    }

    public void ddaBet(int id) {
        int deltaX = BET_RIGHT_POS_X[id] - BET_X[id];
        int deltaY = BET_RIGHT_POS_Y[id] - BET_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(BET_X[id], BET_Y[id], BET_RIGHT_POS_X[id], BET_RIGHT_POS_Y[id]);
        if (BET_X[id] != BET_RIGHT_POS_X[id] || BET_Y[id] != BET_RIGHT_POS_Y[id]) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            } else {
                xAdd = (deltaX << this.ddaShift) / count;
                yAdd = (deltaY << this.ddaShift) / count;
            }
        }
        int n = id;
        BET_X[n] = BET_X[n] + xAdd;
        int n2 = id;
        BET_Y[n2] = BET_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.BET_X[id] = BET_RIGHT_POS_X[id];
            ScreenGame.BET_Y[id] = BET_RIGHT_POS_Y[id];
        }
    }

    public void ddaBets(int id) {
        int deltaX = this.pomPotX - BETS_X[id];
        int deltaY = this.pomPotY - BETS_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(BETS_X[id], BETS_Y[id], this.pomPotX, this.pomPotY);
        if (BETS_X[id] != this.pomPotX || BETS_Y[id] != this.pomPotY) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 2) / count;
                yAdd = (deltaY << this.ddaShift + 2) / count;
            } else {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            }
        }
        int n = id;
        BETS_X[n] = BETS_X[n] + xAdd;
        int n2 = id;
        BETS_Y[n2] = BETS_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.BETS_X[id] = this.pomPotX;
            ScreenGame.BETS_Y[id] = this.pomPotY;
            this.initPotBlinkCounter();
        }
    }

    public void ddaPot(int id) {
        int deltaX = POT_RIGHT_POS_X[id] - POT_X[id];
        int deltaY = POT_RIGHT_POS_Y[id] - POT_Y[id];
        int xAdd = 0;
        int yAdd = 0;
        int count = this.hyp(POT_X[id], POT_Y[id], POT_RIGHT_POS_X[id], POT_RIGHT_POS_Y[id]);
        if (POT_X[id] != POT_RIGHT_POS_X[id] || POT_Y[id] != POT_RIGHT_POS_Y[id]) {
            if (this.bSkip) {
                xAdd = (deltaX << this.ddaShift + 2) / count;
                yAdd = (deltaY << this.ddaShift + 2) / count;
            } else {
                xAdd = (deltaX << this.ddaShift + 1) / count;
                yAdd = (deltaY << this.ddaShift + 1) / count;
            }
        }
        int n = id;
        POT_X[n] = POT_X[n] + xAdd;
        int n2 = id;
        POT_Y[n2] = POT_Y[n2] + yAdd;
        if (Math.abs(deltaX) <= Math.abs(xAdd) && Math.abs(deltaY) <= Math.abs(yAdd)) {
            ScreenGame.POT_X[id] = POT_RIGHT_POS_X[id];
            ScreenGame.POT_Y[id] = POT_RIGHT_POS_Y[id];
            this.initChipsBlinkCounter(id);
        }
    }

    public int hyp(int x1, int y1, int x2, int y2) {
        if ((x2 -= x1) < 0) {
            x2 = -x2;
        }
        if ((y2 -= y1) < 0) {
            y2 = -y2;
        }
        return x2 + y2 - ((x2 > y2 ? y2 : x2) >> 1);
    }

    public void initPotBlinkCounter() {
        this.potBlinkCounter = 24;
        this.bPotBlink = true;
    }

    public void updatePotBlinkCounter() {
        if (this.bPotBlink && this.potBlinkCounter > 0) {
            --this.potBlinkCounter;
            if (this.potBlinkCounter <= 0) {
                this.potBlinkCounter = 0;
                this.bPotBlink = false;
            }
        }
    }

    public void initChipsBlink() {
        this.bChipBlink = new boolean[this.players];
        for (int i = 0; i < this.players; ++i) {
            this.bChipBlink[i] = false;
        }
    }

    public void initChipsBlinkCounter(int id) {
        this.bChipBlink[id] = true;
        this.chipsBlinkCounter = 12;
        this.bChipsBlink = true;
    }

    public void updateChipsBlinkCounter() {
        if (this.bChipsBlink && this.chipsBlinkCounter > 0) {
            --this.chipsBlinkCounter;
            if (this.chipsBlinkCounter <= 0) {
                this.chipsBlinkCounter = 0;
                this.bChipsBlink = false;
                this.initChipsBlink();
            }
        }
    }

    public void upText() {
        int textOffsetY = this.preparedTextInfo.getTextOffsetY() - this.fontGold.getHeight();
        if (textOffsetY < 0) {
            textOffsetY = 0;
        }
        this.preparedTextInfo.setTextOffsetY(textOffsetY);
    }

    public void downText() {
        int textOffsetY = this.preparedTextInfo.getTextOffsetY() + this.fontGold.getHeight();
        int maxOffsetY = this.preparedTextInfo.getTextHeight() - this.rectInfo.height;
        if (maxOffsetY < 0) {
            maxOffsetY = 0;
        }
        if (textOffsetY > maxOffsetY) {
            textOffsetY = maxOffsetY;
        }
        this.preparedTextInfo.setTextOffsetY(textOffsetY);
    }

    public void updateText() {
        if (this.screen == 3) {
            if (this.textShift < 0) {
                this.preparedTextInfo.setTextOffsetY(this.preparedTextInfo.getTextOffsetY() + this.textShift);
                if (this.pointerY > -1) {
                    this.textShift = 0;
                } else {
                    this.textShift += MainCanvas.HEIGHT >> 6;
                    if (this.textShift > 0) {
                        this.textShift = 0;
                    }
                }
            }
            if (this.textShift > 0) {
                int textOffsetY = this.preparedTextInfo.getTextOffsetY() + this.textShift;
                int maxOffsetY = this.preparedTextInfo.getTextHeight() - this.rectInfo.height;
                if (maxOffsetY < 0) {
                    maxOffsetY = 0;
                }
                if (textOffsetY > maxOffsetY) {
                    textOffsetY = maxOffsetY;
                }
                this.preparedTextInfo.setTextOffsetY(textOffsetY);
                if (this.pointerY > -1) {
                    this.textShift = 0;
                } else {
                    this.textShift -= MainCanvas.HEIGHT >> 6;
                    if (this.textShift < 0) {
                        this.textShift = 0;
                    }
                }
            }
            if (this.preparedTextInfo.getTextOffsetY() < 0) {
                this.preparedTextInfo.setTextOffsetY(0);
            }
        }
    }

    public void initDdaShift() {
        this.ddaShift = MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640 ? 5 : (MainCanvas.WIDTH >= 360 && MainCanvas.HEIGHT >= 640 ? 5 : (MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480 ? 4 : (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320 ? 4 : (MainCanvas.WIDTH >= 176 && MainCanvas.HEIGHT >= 200 ? 3 : 2))));
    }

    public boolean isSmallAspectRatio() {
        return MainCanvas.WIDTH * 100 / MainCanvas.HEIGHT >= 75;
    }

    public void initParams() {
        this.nextStepCounter = 0;
        this.dealingCardsCounter = 0;
        this.nextPlayerCounter = 0;
        this.shownCardsCounter = 0;
        this.makeChoiceCounter = 0;
        this.endOfBettingRoundCounter = 0;
        this.endDialogCounter = 0;
        this.evaluationCounter = 0;
        this.identifyWinnersCounter = 0;
        this.bNextStep = false;
        this.bMovingChips = false;
        this.bDealingCards = false;
        this.bMovingHoleCards = false;
        this.bMovingCommunityCards = false;
        this.bNextPlayer = false;
        this.bRaise = false;
        this.bWaitingForPlayer = false;
        this.bStartOfBetting = false;
        this.bMovingBets = false;
        this.bMovingBet = false;
        this.bShownCards = false;
        this.bMakeChoice = false;
        this.bEndOfBettingRound = false;
        this.bMovingPot = false;
        this.bFoldingCards = false;
        this.bDropingCards = false;
        this.bEndDialog = false;
        this.bEvaluation = false;
        this.bIdentifyWinners = false;
        this.bContextMenuIn = false;
        this.bContextMenuOut = false;
        this.bOneActivePlayer = false;
        this.bSkip = false;
        this.bShowSkipButton = false;
        this.iCommunityCardsFlipCounter = new int[5];
        for (int i = 0; i < 5; ++i) {
            this.iCommunityCardsFlipCounter[i] = 0;
        }
    }

    public boolean loadGame() {
        System.out.println("loadGame() " + this.step);
        SavedGame.load();
        if (SavedGame.bSaved) {
            int i;
            System.out.println("GAME LOADED");
            this.raiseValueCounter = SavedGame.pInstance.raiseValueCounter;
            this.hand = SavedGame.pInstance.hand;
            this.value = this.step = SavedGame.pInstance.step;
            this.players = SavedGame.pInstance.players;
            this.actualPlayer = SavedGame.pInstance.actualPlayer;
            this.activePlayers = SavedGame.pInstance.activePlayers;
            this.activePlayingPlayers = SavedGame.pInstance.activePlayingPlayers;
            this.startingPlayer = SavedGame.pInstance.startingPlayer;
            this.dealer = SavedGame.pInstance.dealer;
            this.smallBlind = SavedGame.pInstance.smallBlind;
            this.bigBlind = SavedGame.pInstance.bigBlind;
            this.maxBlinds = SavedGame.pInstance.maxBlinds;
            this.blindsPointer = SavedGame.pInstance.blindsPointer;
            this.raiseBlindsCounter = SavedGame.pInstance.raiseBlindsCounter;
            this.sbValue = SavedGame.pInstance.sbValue;
            this.bbValue = SavedGame.pInstance.bbValue;
            this.minRaiseValue = SavedGame.pInstance.minRaiseValue;
            this.maxRaiseValue = SavedGame.pInstance.maxRaiseValue;
            this.pot = SavedGame.pInstance.pot;
            this.highestBet = SavedGame.pInstance.highestBet;
            this.pomRaiseValue = SavedGame.pInstance.pomRaiseValue;
            this.playersSelection = SavedGame.pInstance.playersSelection;
            this.shownCardsPlayer = SavedGame.pInstance.shownCardsPlayer;
            this.highlightedPlayer = SavedGame.pInstance.highlightedPlayer;
            this.winnersCount = SavedGame.pInstance.winnersCount;
            this.movingPotValue = SavedGame.pInstance.movingPotValue;
            this.movingPotPom = SavedGame.pInstance.movingPotPom;
            this.endDialogPointer = SavedGame.pInstance.endDialogPointer;
            this.cardsPointer = SavedGame.pInstance.cardsPointer;
            this.holeCardsPointer = SavedGame.pInstance.holeCardsPointer;
            this.communityCardsPointer = SavedGame.pInstance.communityCardsPointer;
            this.nextStepCounter = SavedGame.pInstance.nextStepCounter;
            this.dealingCardsCounter = SavedGame.pInstance.dealingCardsCounter;
            this.nextPlayerCounter = SavedGame.pInstance.nextPlayerCounter;
            this.shownCardsCounter = SavedGame.pInstance.shownCardsCounter;
            this.makeChoiceCounter = SavedGame.pInstance.makeChoiceCounter;
            this.endOfBettingRoundCounter = SavedGame.pInstance.endOfBettingRoundCounter;
            this.endDialogCounter = SavedGame.pInstance.endDialogCounter;
            this.evaluationCounter = SavedGame.pInstance.evaluationCounter;
            this.identifyWinnersCounter = SavedGame.pInstance.identifyWinnersCounter;
            this.bNextStep = SavedGame.pInstance.bNextStep;
            this.bMovingChips = SavedGame.pInstance.bMovingChips;
            this.bDealingCards = SavedGame.pInstance.bDealingCards;
            this.bMovingHoleCards = SavedGame.pInstance.bMovingHoleCards;
            this.bMovingCommunityCards = SavedGame.pInstance.bMovingCommunityCards;
            this.bNextPlayer = SavedGame.pInstance.bNextPlayer;
            this.bRaise = SavedGame.pInstance.bRaise;
            this.bWaitingForPlayer = SavedGame.pInstance.bWaitingForPlayer;
            this.bStartOfBetting = SavedGame.pInstance.bStartOfBetting;
            this.bMovingBets = SavedGame.pInstance.bMovingBets;
            this.bMovingBet = SavedGame.pInstance.bMovingBet;
            this.bShownCards = SavedGame.pInstance.bShownCards;
            this.bMakeChoice = SavedGame.pInstance.bMakeChoice;
            this.bEndOfBettingRound = SavedGame.pInstance.bEndOfBettingRound;
            this.bMovingPot = SavedGame.pInstance.bMovingPot;
            this.bFoldingCards = SavedGame.pInstance.bFoldingCards;
            this.bDropingCards = SavedGame.pInstance.bDropingCards;
            this.bEndDialog = SavedGame.pInstance.bEndDialog;
            this.bEvaluation = SavedGame.pInstance.bEvaluation;
            this.bIdentifyWinners = SavedGame.pInstance.bIdentifyWinners;
            this.bContextMenuIn = SavedGame.pInstance.bContextMenuIn;
            this.bContextMenuOut = SavedGame.pInstance.bContextMenuOut;
            this.bDialogActive = SavedGame.pInstance.bDialogActive;
            this.bOneActivePlayer = SavedGame.pInstance.bOneActivePlayer;
            this.bSkip = SavedGame.pInstance.bSkip;
            this.bShowSkipButton = SavedGame.pInstance.bShowSkipButton;
            CHIP_X = new int[SavedGame.pInstance.CHIP_X.length];
            CHIP_Y = new int[SavedGame.pInstance.CHIP_X.length];
            for (i = 0; i < SavedGame.pInstance.CHIP_X.length; ++i) {
                ScreenGame.CHIP_X[i] = SavedGame.pInstance.CHIP_X[i];
                ScreenGame.CHIP_Y[i] = SavedGame.pInstance.CHIP_Y[i];
            }
            BET = new int[SavedGame.pInstance.BETS.length];
            BETS = new int[SavedGame.pInstance.BETS.length];
            CHIPS = new int[SavedGame.pInstance.BETS.length];
            BUY_IN = new int[SavedGame.pInstance.BETS.length];
            for (i = 0; i < SavedGame.pInstance.BETS.length; ++i) {
                ScreenGame.BET[i] = SavedGame.pInstance.BET[i];
                ScreenGame.BETS[i] = SavedGame.pInstance.BETS[i];
                ScreenGame.CHIPS[i] = SavedGame.pInstance.CHIPS[i];
                ScreenGame.BUY_IN[i] = SavedGame.pInstance.BUY_IN[i];
            }
            POT = new int[SavedGame.pInstance.POT.length];
            for (i = 0; i < POT.length; ++i) {
                ScreenGame.POT[i] = SavedGame.pInstance.POT[i];
            }
            POT_WINNERS = new int[SavedGame.pInstance.POT_WINNERS.length];
            for (i = 0; i < POT_WINNERS.length; ++i) {
                ScreenGame.POT_WINNERS[i] = SavedGame.pInstance.POT_WINNERS[i];
            }
            INDIVIDUAL_LIMITS = new int[SavedGame.pInstance.INDIVIDUAL_LIMITS.length];
            for (i = 0; i < INDIVIDUAL_LIMITS.length; ++i) {
                ScreenGame.INDIVIDUAL_LIMITS[i] = SavedGame.pInstance.INDIVIDUAL_LIMITS[i];
            }
            LIMITS = new int[SavedGame.pInstance.LIMITS.length];
            for (i = 0; i < LIMITS.length; ++i) {
                ScreenGame.LIMITS[i] = SavedGame.pInstance.LIMITS[i];
            }
            CARDS_X = new int[SavedGame.pInstance.CARDS_X.length];
            CARDS_Y = new int[SavedGame.pInstance.CARDS_X.length];
            for (i = 0; i < SavedGame.pInstance.CARDS_X.length; ++i) {
                ScreenGame.CARDS_X[i] = SavedGame.pInstance.CARDS_X[i];
                ScreenGame.CARDS_Y[i] = SavedGame.pInstance.CARDS_Y[i];
            }
            COMMUNITY_CARDS_X = new int[SavedGame.pInstance.COMMUNITY_CARDS_X.length];
            COMMUNITY_CARDS_Y = new int[SavedGame.pInstance.COMMUNITY_CARDS_X.length];
            for (i = 0; i < SavedGame.pInstance.COMMUNITY_CARDS_X.length; ++i) {
                ScreenGame.COMMUNITY_CARDS_X[i] = SavedGame.pInstance.COMMUNITY_CARDS_X[i];
                ScreenGame.COMMUNITY_CARDS_Y[i] = SavedGame.pInstance.COMMUNITY_CARDS_Y[i];
            }
            BET_X = new int[SavedGame.pInstance.BET_X.length];
            for (i = 0; i < BET_X.length; ++i) {
                ScreenGame.BET_X[i] = SavedGame.pInstance.BET_X[i];
            }
            BET_Y = new int[SavedGame.pInstance.BET_Y.length];
            for (i = 0; i < BET_Y.length; ++i) {
                ScreenGame.BET_Y[i] = SavedGame.pInstance.BET_Y[i];
            }
            BETS_X = new int[SavedGame.pInstance.BETS_X.length];
            for (i = 0; i < BETS_X.length; ++i) {
                ScreenGame.BETS_X[i] = SavedGame.pInstance.BETS_X[i];
            }
            BETS_Y = new int[SavedGame.pInstance.BETS_Y.length];
            for (i = 0; i < BETS_Y.length; ++i) {
                ScreenGame.BETS_Y[i] = SavedGame.pInstance.BETS_Y[i];
            }
            POT_X = new int[SavedGame.pInstance.POT_X.length];
            for (i = 0; i < POT_X.length; ++i) {
                ScreenGame.POT_X[i] = SavedGame.pInstance.POT_X[i];
            }
            POT_Y = new int[SavedGame.pInstance.POT_Y.length];
            for (i = 0; i < POT_Y.length; ++i) {
                ScreenGame.POT_Y[i] = SavedGame.pInstance.POT_Y[i];
            }
            CARDS = new byte[SavedGame.pInstance.CARDS.length];
            for (i = 0; i < SavedGame.pInstance.CARDS.length; ++i) {
                ScreenGame.CARDS[i] = SavedGame.pInstance.CARDS[i];
            }
            COMMUNITY_CARDS = new byte[SavedGame.pInstance.COMMUNITY_CARDS.length];
            for (i = 0; i < SavedGame.pInstance.COMMUNITY_CARDS.length; ++i) {
                ScreenGame.COMMUNITY_CARDS[i] = SavedGame.pInstance.COMMUNITY_CARDS[i];
            }
            HOLE_CARDS = new byte[SavedGame.pInstance.HOLE_CARDS.length];
            for (i = 0; i < HOLE_CARDS.length; ++i) {
                ScreenGame.HOLE_CARDS[i] = SavedGame.pInstance.HOLE_CARDS[i];
            }
            POT_PLAYERS = new byte[SavedGame.pInstance.POT_PLAYERS.length];
            for (i = 0; i < POT_PLAYERS.length; ++i) {
                ScreenGame.POT_PLAYERS[i] = SavedGame.pInstance.POT_PLAYERS[i];
            }
            ACTIVE = new byte[SavedGame.pInstance.ACTIVE.length];
            SHOWN_CARDS = new byte[SavedGame.pInstance.ACTIVE.length];
            ACTION = new byte[SavedGame.pInstance.ACTIVE.length];
            WINNER = new byte[SavedGame.pInstance.ACTIVE.length];
            PLAYERS_MODE = new byte[SavedGame.pInstance.ACTIVE.length];
            for (i = 0; i < SavedGame.pInstance.ACTIVE.length; ++i) {
                ScreenGame.ACTIVE[i] = SavedGame.pInstance.ACTIVE[i];
                ScreenGame.SHOWN_CARDS[i] = SavedGame.pInstance.SHOWN_CARDS[i];
                ScreenGame.ACTION[i] = SavedGame.pInstance.ACTION[i];
                ScreenGame.WINNER[i] = SavedGame.pInstance.WINNER[i];
                ScreenGame.PLAYERS_MODE[i] = SavedGame.pInstance.PLAYERS_MODE[i];
            }
            COMBINATION_INFO = new byte[SavedGame.pInstance.COMBINATION_INFO.length];
            for (i = 0; i < COMBINATION_INFO.length; ++i) {
                ScreenGame.COMBINATION_INFO[i] = SavedGame.pInstance.COMBINATION_INFO[i];
            }
            SORTED_CARDS = new byte[SavedGame.pInstance.SORTED_CARDS.length];
            for (i = 0; i < SORTED_CARDS.length; ++i) {
                ScreenGame.SORTED_CARDS[i] = SavedGame.pInstance.SORTED_CARDS[i];
            }
            DIVIDED_CARDS = new byte[SavedGame.pInstance.DIVIDED_CARDS.length];
            for (i = 0; i < DIVIDED_CARDS.length; ++i) {
                ScreenGame.DIVIDED_CARDS[i] = SavedGame.pInstance.DIVIDED_CARDS[i];
            }
            CARDS_SUITS_COUNT = new byte[SavedGame.pInstance.CARDS_SUITS_COUNT.length];
            for (i = 0; i < CARDS_SUITS_COUNT.length; ++i) {
                ScreenGame.CARDS_SUITS_COUNT[i] = SavedGame.pInstance.CARDS_SUITS_COUNT[i];
            }
            CARDS_VALUES_COUNT = new byte[SavedGame.pInstance.CARDS_VALUES_COUNT.length];
            for (i = 0; i < CARDS_VALUES_COUNT.length; ++i) {
                ScreenGame.CARDS_VALUES_COUNT[i] = SavedGame.pInstance.CARDS_VALUES_COUNT[i];
            }
            PLAYERS_FACE = new byte[SavedGame.pInstance.PLAYERS_FACE.length];
            for (i = 0; i < PLAYERS_FACE.length; ++i) {
                ScreenGame.PLAYERS_FACE[i] = SavedGame.pInstance.PLAYERS_FACE[i];
            }
            this.setPlayers();
            this.initPotPos();
            this.initCardsPos();
            this.initBetsPos();
            this.setPotsPos();
            this.setChipsPos();
            this.setDarkenLabels();
            if (this.bWaitingForPlayer) {
                this.openContextMenu();
            }
            if (this.bEndDialog) {
                this.identifyWinners(false);
            }
            this.closeDialog();
            if (!(this.step != 0 && this.step != 1 && this.step != 16 && this.step != 17 || this.bNextStep)) {
                if (this.step == 0) {
                    this.initNumberOfOpponentsDialog();
                } else if (this.step == 1) {
                    if (this.maxBlinds > 0) {
                        this.initBlindsValuesDialog();
                    }
                } else if (this.step == 16) {
                    this.initEvaluationDialog();
                } else if (this.step == 17) {
                    this.initEndOfGame();
                }
            }
            return true;
        }
        System.out.println("GAME NOT LOADED");
        return false;
    }

    public void saveGame() {
        int i;
        System.out.println("saveGame() " + this.step);
        SavedGame.pInstance.raiseValueCounter = this.raiseValueCounter;
        SavedGame.pInstance.hand = this.hand;
        SavedGame.pInstance.step = this.step;
        this.value = this.step + 500;
        SavedGame.pInstance.players = this.players;
        SavedGame.pInstance.actualPlayer = this.actualPlayer;
        SavedGame.pInstance.activePlayers = this.activePlayers;
        SavedGame.pInstance.activePlayingPlayers = this.activePlayingPlayers;
        SavedGame.pInstance.startingPlayer = this.startingPlayer;
        SavedGame.pInstance.dealer = this.dealer;
        SavedGame.pInstance.smallBlind = this.smallBlind;
        SavedGame.pInstance.bigBlind = this.bigBlind;
        SavedGame.pInstance.maxBlinds = this.maxBlinds;
        SavedGame.pInstance.blindsPointer = this.blindsPointer;
        SavedGame.pInstance.raiseBlindsCounter = this.raiseBlindsCounter;
        SavedGame.pInstance.sbValue = this.sbValue;
        SavedGame.pInstance.bbValue = this.bbValue;
        SavedGame.pInstance.minRaiseValue = this.minRaiseValue;
        SavedGame.pInstance.maxRaiseValue = this.maxRaiseValue;
        SavedGame.pInstance.pot = this.pot;
        SavedGame.pInstance.highestBet = this.highestBet;
        SavedGame.pInstance.pomRaiseValue = this.pomRaiseValue;
        SavedGame.pInstance.playersSelection = this.playersSelection;
        SavedGame.pInstance.shownCardsPlayer = this.shownCardsPlayer;
        SavedGame.pInstance.highlightedPlayer = this.highlightedPlayer;
        SavedGame.pInstance.winnersCount = this.winnersCount;
        SavedGame.pInstance.movingPotValue = this.movingPotValue;
        SavedGame.pInstance.movingPotPom = this.movingPotPom;
        SavedGame.pInstance.endDialogPointer = this.endDialogPointer;
        SavedGame.pInstance.cardsPointer = this.cardsPointer;
        SavedGame.pInstance.holeCardsPointer = this.holeCardsPointer;
        SavedGame.pInstance.communityCardsPointer = this.communityCardsPointer;
        SavedGame.pInstance.nextStepCounter = this.nextStepCounter;
        SavedGame.pInstance.dealingCardsCounter = this.dealingCardsCounter;
        SavedGame.pInstance.nextPlayerCounter = this.nextPlayerCounter;
        SavedGame.pInstance.shownCardsCounter = this.shownCardsCounter;
        SavedGame.pInstance.makeChoiceCounter = this.makeChoiceCounter;
        SavedGame.pInstance.endOfBettingRoundCounter = this.endOfBettingRoundCounter;
        SavedGame.pInstance.endDialogCounter = this.endDialogCounter;
        SavedGame.pInstance.evaluationCounter = this.evaluationCounter;
        SavedGame.pInstance.identifyWinnersCounter = this.identifyWinnersCounter;
        SavedGame.pInstance.bNextStep = this.bNextStep;
        SavedGame.pInstance.bMovingChips = this.bMovingChips;
        SavedGame.pInstance.bDealingCards = this.bDealingCards;
        SavedGame.pInstance.bMovingHoleCards = this.bMovingHoleCards;
        SavedGame.pInstance.bMovingCommunityCards = this.bMovingCommunityCards;
        SavedGame.pInstance.bNextPlayer = this.bNextPlayer;
        SavedGame.pInstance.bRaise = this.bRaise;
        SavedGame.pInstance.bWaitingForPlayer = this.bWaitingForPlayer;
        SavedGame.pInstance.bStartOfBetting = this.bStartOfBetting;
        SavedGame.pInstance.bMovingBets = this.bMovingBets;
        SavedGame.pInstance.bMovingBet = this.bMovingBet;
        SavedGame.pInstance.bShownCards = this.bShownCards;
        SavedGame.pInstance.bMakeChoice = this.bMakeChoice;
        SavedGame.pInstance.bEndOfBettingRound = this.bEndOfBettingRound;
        SavedGame.pInstance.bMovingPot = this.bMovingPot;
        SavedGame.pInstance.bFoldingCards = this.bFoldingCards;
        SavedGame.pInstance.bDropingCards = this.bDropingCards;
        SavedGame.pInstance.bEndDialog = this.bEndDialog;
        SavedGame.pInstance.bEvaluation = this.bEvaluation;
        SavedGame.pInstance.bIdentifyWinners = this.bIdentifyWinners;
        SavedGame.pInstance.bContextMenuIn = this.bContextMenuIn;
        SavedGame.pInstance.bContextMenuOut = this.bContextMenuOut;
        SavedGame.pInstance.bDialogActive = this.bDialogActive;
        SavedGame.pInstance.bOneActivePlayer = this.bOneActivePlayer;
        SavedGame.pInstance.bSkip = this.bSkip;
        SavedGame.pInstance.bShowSkipButton = this.bShowSkipButton;
        SavedGame.pInstance.CHIP_X = new int[CHIP_X.length];
        SavedGame.pInstance.CHIP_Y = new int[CHIP_X.length];
        for (i = 0; i < CHIP_X.length; ++i) {
            SavedGame.pInstance.CHIP_X[i] = CHIP_X[i];
            SavedGame.pInstance.CHIP_Y[i] = CHIP_Y[i];
        }
        SavedGame.pInstance.BET = new int[BETS.length];
        SavedGame.pInstance.BETS = new int[BETS.length];
        SavedGame.pInstance.CHIPS = new int[BETS.length];
        SavedGame.pInstance.BUY_IN = new int[BETS.length];
        for (i = 0; i < BETS.length; ++i) {
            SavedGame.pInstance.BET[i] = BET[i];
            SavedGame.pInstance.BETS[i] = BETS[i];
            SavedGame.pInstance.CHIPS[i] = CHIPS[i];
            SavedGame.pInstance.BUY_IN[i] = BUY_IN[i];
        }
        SavedGame.pInstance.POT = new int[POT.length];
        for (i = 0; i < POT.length; ++i) {
            SavedGame.pInstance.POT[i] = POT[i];
        }
        SavedGame.pInstance.POT_WINNERS = new int[POT_WINNERS.length];
        for (i = 0; i < POT_WINNERS.length; ++i) {
            SavedGame.pInstance.POT_WINNERS[i] = POT_WINNERS[i];
        }
        SavedGame.pInstance.INDIVIDUAL_LIMITS = new int[INDIVIDUAL_LIMITS.length];
        for (i = 0; i < INDIVIDUAL_LIMITS.length; ++i) {
            SavedGame.pInstance.INDIVIDUAL_LIMITS[i] = INDIVIDUAL_LIMITS[i];
        }
        SavedGame.pInstance.LIMITS = new int[LIMITS.length];
        for (i = 0; i < LIMITS.length; ++i) {
            SavedGame.pInstance.LIMITS[i] = LIMITS[i];
        }
        SavedGame.pInstance.CARDS_X = new int[CARDS_X.length];
        SavedGame.pInstance.CARDS_Y = new int[CARDS_X.length];
        for (i = 0; i < CARDS_X.length; ++i) {
            SavedGame.pInstance.CARDS_X[i] = CARDS_X[i];
            SavedGame.pInstance.CARDS_Y[i] = CARDS_Y[i];
        }
        SavedGame.pInstance.COMMUNITY_CARDS_X = new int[COMMUNITY_CARDS_X.length];
        SavedGame.pInstance.COMMUNITY_CARDS_Y = new int[COMMUNITY_CARDS_X.length];
        for (i = 0; i < COMMUNITY_CARDS_X.length; ++i) {
            SavedGame.pInstance.COMMUNITY_CARDS_X[i] = COMMUNITY_CARDS_X[i];
            SavedGame.pInstance.COMMUNITY_CARDS_Y[i] = COMMUNITY_CARDS_Y[i];
        }
        SavedGame.pInstance.BET_X = new int[BET_X.length];
        for (i = 0; i < BET_X.length; ++i) {
            SavedGame.pInstance.BET_X[i] = BET_X[i];
        }
        SavedGame.pInstance.BET_Y = new int[BET_Y.length];
        for (i = 0; i < BET_Y.length; ++i) {
            SavedGame.pInstance.BET_Y[i] = BET_Y[i];
        }
        SavedGame.pInstance.BETS_X = new int[BETS_X.length];
        for (i = 0; i < BETS_X.length; ++i) {
            SavedGame.pInstance.BETS_X[i] = BETS_X[i];
        }
        SavedGame.pInstance.BETS_Y = new int[BETS_Y.length];
        for (i = 0; i < BETS_Y.length; ++i) {
            SavedGame.pInstance.BETS_Y[i] = BETS_Y[i];
        }
        SavedGame.pInstance.POT_X = new int[POT_X.length];
        for (i = 0; i < POT_X.length; ++i) {
            SavedGame.pInstance.POT_X[i] = POT_X[i];
        }
        SavedGame.pInstance.POT_Y = new int[POT_Y.length];
        for (i = 0; i < POT_Y.length; ++i) {
            SavedGame.pInstance.POT_Y[i] = POT_Y[i];
        }
        SavedGame.pInstance.CARDS = new byte[CARDS.length];
        for (i = 0; i < CARDS.length; ++i) {
            SavedGame.pInstance.CARDS[i] = CARDS[i];
        }
        SavedGame.pInstance.COMMUNITY_CARDS = new byte[COMMUNITY_CARDS.length];
        for (i = 0; i < COMMUNITY_CARDS.length; ++i) {
            SavedGame.pInstance.COMMUNITY_CARDS[i] = COMMUNITY_CARDS[i];
        }
        SavedGame.pInstance.HOLE_CARDS = new byte[HOLE_CARDS.length];
        for (i = 0; i < HOLE_CARDS.length; ++i) {
            SavedGame.pInstance.HOLE_CARDS[i] = HOLE_CARDS[i];
        }
        SavedGame.pInstance.POT_PLAYERS = new byte[POT_PLAYERS.length];
        for (i = 0; i < POT_PLAYERS.length; ++i) {
            SavedGame.pInstance.POT_PLAYERS[i] = POT_PLAYERS[i];
        }
        SavedGame.pInstance.ACTIVE = new byte[ACTIVE.length];
        SavedGame.pInstance.SHOWN_CARDS = new byte[ACTIVE.length];
        SavedGame.pInstance.ACTION = new byte[ACTIVE.length];
        SavedGame.pInstance.WINNER = new byte[ACTIVE.length];
        SavedGame.pInstance.PLAYERS_MODE = new byte[ACTIVE.length];
        for (i = 0; i < ACTIVE.length; ++i) {
            SavedGame.pInstance.ACTIVE[i] = ACTIVE[i];
            SavedGame.pInstance.SHOWN_CARDS[i] = SHOWN_CARDS[i];
            SavedGame.pInstance.ACTION[i] = ACTION[i];
            SavedGame.pInstance.WINNER[i] = WINNER[i];
            SavedGame.pInstance.PLAYERS_MODE[i] = PLAYERS_MODE[i];
        }
        SavedGame.pInstance.COMBINATION_INFO = new byte[COMBINATION_INFO.length];
        for (i = 0; i < COMBINATION_INFO.length; ++i) {
            SavedGame.pInstance.COMBINATION_INFO[i] = COMBINATION_INFO[i];
        }
        SavedGame.pInstance.SORTED_CARDS = new byte[SORTED_CARDS.length];
        for (i = 0; i < SORTED_CARDS.length; ++i) {
            SavedGame.pInstance.SORTED_CARDS[i] = SORTED_CARDS[i];
        }
        SavedGame.pInstance.DIVIDED_CARDS = new byte[DIVIDED_CARDS.length];
        for (i = 0; i < DIVIDED_CARDS.length; ++i) {
            SavedGame.pInstance.DIVIDED_CARDS[i] = DIVIDED_CARDS[i];
        }
        SavedGame.pInstance.CARDS_SUITS_COUNT = new byte[CARDS_SUITS_COUNT.length];
        for (i = 0; i < CARDS_SUITS_COUNT.length; ++i) {
            SavedGame.pInstance.CARDS_SUITS_COUNT[i] = CARDS_SUITS_COUNT[i];
        }
        SavedGame.pInstance.CARDS_VALUES_COUNT = new byte[CARDS_VALUES_COUNT.length];
        for (i = 0; i < CARDS_VALUES_COUNT.length; ++i) {
            SavedGame.pInstance.CARDS_VALUES_COUNT[i] = CARDS_VALUES_COUNT[i];
        }
        SavedGame.pInstance.PLAYERS_FACE = new byte[PLAYERS_FACE.length];
        for (i = 0; i < PLAYERS_FACE.length; ++i) {
            SavedGame.pInstance.PLAYERS_FACE[i] = PLAYERS_FACE[i];
        }
        SavedGame.save();
    }
}

