/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Pom;
import sk.inlogic.Resources;
import sk.inlogic.Scores;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Rectangle;

public class Profile {
    GFont fontGold;
    GFont fontGoldBig;
    Sprite sprArrows;
    Sprite sprArrowsInactive;
    Sprite sprIcons;
    Rectangle rectDialog;
    Rectangle rectInfo;
    Rectangle[] rectArrowsDialog;
    PreparedText preparedTextInfo;
    int iSite = 0;
    String strLevel;
    String strXP;
    String strGamesPlayed;
    String strGamesWon;
    String strHandsPlayed;
    String strHandsWon;
    String strBiggestWin;
    String strTimePlayed;
    String strAchievements;
    String strWinWith;
    String strWinsInRow;
    String[] STR_COMBINATION;
    String strHands;
    String strGames;

    public Profile(GFont fontGold, GFont fontGoldBig, String[] STR_COMBINATION) {
        this.fontGold = fontGold;
        this.fontGoldBig = fontGoldBig;
        this.STR_COMBINATION = STR_COMBINATION;
        Resources.loadSprites(new int[]{3, 4, 2});
        this.sprArrows = Resources.resSprs[3];
        this.sprArrowsInactive = Resources.resSprs[4];
        this.sprIcons = Resources.resSprs[2];
        this.strLevel = Resources.resTexts[0].getHashedString(110);
        this.strXP = Resources.resTexts[0].getHashedString(111);
        this.strGamesPlayed = Resources.resTexts[0].getHashedString(112);
        this.strGamesWon = Resources.resTexts[0].getHashedString(113);
        this.strHandsPlayed = Resources.resTexts[0].getHashedString(114);
        this.strHandsWon = Resources.resTexts[0].getHashedString(115);
        this.strBiggestWin = Resources.resTexts[0].getHashedString(117);
        this.strTimePlayed = Resources.resTexts[0].getHashedString(118);
        this.strAchievements = Resources.resTexts[0].getHashedString(119);
        this.strWinWith = Resources.resTexts[0].getHashedString(120);
        this.strWinsInRow = Resources.resTexts[0].getHashedString(121);
        this.strHands = Resources.resTexts[0].getHashedString(35);
        this.strGames = Resources.resTexts[0].getHashedString(34);
    }

    public void set(Rectangle rectDialog, Rectangle rectInfo, Rectangle[] rectArrowsDialog, PreparedText preparedTextInfo) {
        this.rectDialog = rectDialog;
        this.rectInfo = rectInfo;
        this.rectArrowsDialog = rectArrowsDialog;
        this.preparedTextInfo = preparedTextInfo;
        if (MainCanvas.WIDTH <= 176) {
            rectInfo.width += 4;
            rectInfo.x = (MainCanvas.WIDTH >> 1) - (rectInfo.width >> 1);
        } else if (MainCanvas.HEIGHT < 200) {
            rectInfo.width += (rectArrowsDialog[0].width << 1) + (rectArrowsDialog[0].width >> 1);
            rectInfo.x = (MainCanvas.WIDTH >> 1) - (rectInfo.width >> 1);
        }
        if (Resources.langCode.compareTo("it") == 0) {
            rectInfo.width += 3;
            rectInfo.x = (MainCanvas.WIDTH >> 1) - (rectInfo.width >> 1) + 1;
        }
        int pom = 0;
        pom = MainCanvas.WIDTH >= 480 && MainCanvas.HEIGHT >= 640 ? 480 : (MainCanvas.WIDTH >= 360 && MainCanvas.HEIGHT >= 640 ? 360 : (MainCanvas.WIDTH >= 320 && MainCanvas.HEIGHT >= 480 ? 320 : (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320 ? 240 : (MainCanvas.WIDTH >= 176 && MainCanvas.HEIGHT >= 200 ? 176 : 128))));
        if (MainCanvas.WIDTH <= MainCanvas.HEIGHT) {
            if (MainCanvas.WIDTH > pom) {
                int shiftX = MainCanvas.WIDTH - pom;
                rectInfo.width -= shiftX - (shiftX >> 2);
                rectInfo.x = (MainCanvas.WIDTH >> 1) - (rectInfo.width >> 1);
            }
        } else if (MainCanvas.HEIGHT > pom) {
            int shiftX = MainCanvas.HEIGHT - pom;
            rectInfo.width -= shiftX - (shiftX >> 2);
            rectInfo.x = (MainCanvas.WIDTH >> 1) - (rectInfo.width >> 1);
        }
        this.iSite = 0;
    }

    public void initSite() {
        this.iSite = 0;
    }

    public void nextSite() {
        if (this.iSite < 2) {
            ++this.iSite;
        }
    }

    public void previousSite() {
        if (this.iSite > 0) {
            --this.iSite;
        }
    }

    public void paint(Graphics g) {
        if (this.preparedTextInfo != null) {
            int iShiftX = 0;
            if (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320) {
                iShiftX = this.fontGold.getSpaceWidth() << 1;
            }
            String str = "";
            int iLinesCount = 14;
            if (MainCanvas.HEIGHT < 220) {
                iLinesCount = 12;
            } else if (MainCanvas.HEIGHT < 320) {
                iLinesCount = 13;
            }
            double iLinesBigCount = 1.0;
            int iHeight = (int)((double)(this.fontGold.getHeight() * iLinesCount) + (double)this.fontGoldBig.getHeight() * iLinesBigCount);
            int iY = this.rectInfo.getCenterY() - (iHeight >> 1);
            if (this.iSite == 0) {
                str = "";
                int iStringWidth = 0;
                str = this.strLevel + " " + (Scores.level + 1);
                iStringWidth = this.fontGoldBig.stringWidth(str.toCharArray());
                this.fontGoldBig.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY, 20);
                str = Scores.xp + " " + this.strXP;
                iStringWidth = this.fontGoldBig.stringWidth(str.toCharArray());
                this.fontGoldBig.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY += this.fontGoldBig.getHeight() + (this.fontGold.getHeight() >> 1), 20);
                iY += this.fontGoldBig.getHeight() + (this.fontGold.getHeight() << 1);
                String[] strLabels = new String[]{this.strGamesPlayed, this.strGamesWon, this.strHandsPlayed, this.strHandsWon, this.strBiggestWin};
                int[] iValues = new int[]{Scores.gamesPlayed, Scores.gamesWon, Scores.handsPlayed, Scores.handsWon, Scores.biggestWin};
                int iX1 = this.rectInfo.x + iShiftX;
                int iX2 = this.rectInfo.getRight() - iShiftX;
                for (int i = 0; i < strLabels.length; ++i) {
                    this.fontGold.drawString(g, (strLabels[i] + ":").toCharArray(), iX1, iY, 20);
                    this.fontGold.drawString(g, (iValues[i] + "").toCharArray(), iX2, iY, 24);
                    iY += this.fontGold.getHeight();
                }
                str = this.strTimePlayed + ":";
                iStringWidth = this.fontGold.stringWidth(str.toCharArray());
                this.fontGold.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY += this.fontGold.getHeight() << 1, 20);
                str = Pom.getFormatedTime(Scores.playedTime);
                iStringWidth = this.fontGold.stringWidth(str.toCharArray());
                this.fontGold.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY += this.fontGold.getHeight(), 20);
            } else if (this.iSite == 1) {
                str = "";
                int iStringWidth = 0;
                str = this.strAchievements;
                iStringWidth = this.fontGoldBig.stringWidth(str.toCharArray());
                this.fontGoldBig.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY, 20);
                iY += this.fontGoldBig.getHeight();
                iY = MainCanvas.HEIGHT < 220 ? (iY += this.fontGold.getHeight() - (this.fontGold.getHeight() >> 2)) : (MainCanvas.HEIGHT < 320 ? (iY += this.fontGold.getHeight() + (this.fontGold.getHeight() >> 2)) : (iY += this.fontGold.getHeight() << 1));
                str = this.strWinWith + ":";
                iStringWidth = this.fontGold.stringWidth(str.toCharArray());
                this.fontGold.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY, 20);
                iY += this.fontGold.getHeight();
                iY = MainCanvas.HEIGHT < 220 ? (iY += (this.fontGold.getHeight() >> 2) + (this.fontGold.getHeight() >> 3)) : (MainCanvas.HEIGHT < 320 ? (iY += this.fontGold.getHeight() - (this.fontGold.getHeight() >> 2)) : (iY += this.fontGold.getHeight()));
                boolean[] bAchievs = new boolean[]{Scores.bAchievementWinWithHighCard, Scores.bAchievementWinWithPair, Scores.bAchievementWinWithTwoPairs, Scores.bAchievementWinWithThreeOfAKind, Scores.bAchievementWinWithStraight, Scores.bAchievementWinWithFlush, Scores.bAchievementWinWithFullHouse, Scores.bAchievementWinWithFourOfAKind, Scores.bAchievementWinWithStraightFlush, Scores.bAchievementWinWithRoyalFlush};
                int iX1 = this.rectInfo.x + iShiftX;
                int iX2 = this.rectInfo.getRight() - this.sprIcons.getWidth() - iShiftX;
                for (int i = 0; i < bAchievs.length; ++i) {
                    str = this.STR_COMBINATION[i + 1];
                    this.fontGold.drawString(g, str.toCharArray(), iX1, iY, 20);
                    if (bAchievs[i]) {
                        this.sprIcons.setFrame(0);
                    } else {
                        this.sprIcons.setFrame(1);
                    }
                    this.sprIcons.setPosition(iX2, iY + (this.fontGold.getHeight() >> 1) - (this.sprIcons.getHeight() >> 1));
                    this.sprIcons.paint(g);
                    iY += this.fontGold.getHeight();
                }
            } else if (this.iSite == 2) {
                str = "";
                int iStringWidth = 0;
                str = this.strAchievements;
                iStringWidth = this.fontGoldBig.stringWidth(str.toCharArray());
                this.fontGoldBig.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY, 20);
                iY += this.fontGoldBig.getHeight();
                iY = MainCanvas.HEIGHT < 220 ? (iY += this.fontGold.getHeight() - (this.fontGold.getHeight() >> 2)) : (MainCanvas.HEIGHT < 320 ? (iY += this.fontGold.getHeight() + (this.fontGold.getHeight() >> 2)) : (iY += this.fontGold.getHeight() << 1));
                str = this.strWinsInRow + ":";
                iStringWidth = this.fontGold.stringWidth(str.toCharArray());
                this.fontGold.drawString(g, str.toCharArray(), this.rectInfo.getCenterX() - (iStringWidth >> 1), iY, 20);
                iY += this.fontGold.getHeight() << 1;
                boolean[] bAchievs = new boolean[]{Scores.bAchievementHandsWonInRow0, Scores.bAchievementHandsWonInRow1, Scores.bAchievementHandsWonInRow2, Scores.bAchievementHandsWonInRow3, Scores.bAchievementHandsWonInRow4};
                int iX1 = this.rectInfo.x + iShiftX;
                int iX2 = this.rectInfo.getRight() - this.sprIcons.getWidth() - iShiftX;
                for (int i = 0; i < bAchievs.length; ++i) {
                    str = Scores.HANDS_WON_IN_ROW[i] + " " + this.strHands;
                    this.fontGold.drawString(g, str.toCharArray(), iX1, iY, 20);
                    if (bAchievs[i]) {
                        this.sprIcons.setFrame(0);
                    } else {
                        this.sprIcons.setFrame(1);
                    }
                    this.sprIcons.setPosition(iX2, iY + (this.fontGold.getHeight() >> 1) - (this.sprIcons.getHeight() >> 1));
                    this.sprIcons.paint(g);
                    iY += this.fontGold.getHeight();
                }
                iY = MainCanvas.HEIGHT < 220 ? (iY += this.fontGold.getHeight() >> 1) : (MainCanvas.HEIGHT < 320 ? (iY += this.fontGold.getHeight() - (this.fontGold.getHeight() >> 2)) : (iY += this.fontGold.getHeight()));
                boolean[] bAchievs2 = new boolean[]{Scores.bAchievementGamesWonInRow0, Scores.bAchievementGamesWonInRow1, Scores.bAchievementGamesWonInRow2};
                iX1 = this.rectInfo.x + iShiftX;
                iX2 = this.rectInfo.getRight() - this.sprIcons.getWidth() - iShiftX;
                for (int i = 0; i < bAchievs2.length; ++i) {
                    str = Scores.GAMES_WON_IN_ROW[i] + " " + this.strGames;
                    this.fontGold.drawString(g, str.toCharArray(), iX1, iY, 20);
                    if (bAchievs2[i]) {
                        this.sprIcons.setFrame(0);
                    } else {
                        this.sprIcons.setFrame(1);
                    }
                    this.sprIcons.setPosition(iX2, iY + (this.fontGold.getHeight() >> 1) - (this.sprIcons.getHeight() >> 1));
                    this.sprIcons.paint(g);
                    iY += this.fontGold.getHeight();
                }
            }
            this.paintSite(g);
            if (this.iSite > 0) {
                this.paintArrow(g, 0, 2, true);
            } else {
                this.paintArrow(g, 0, 2, false);
            }
            if (this.iSite < 2) {
                this.paintArrow(g, 1, 3, true);
            } else {
                this.paintArrow(g, 1, 3, false);
            }
        }
    }

    public void paintSite(Graphics g) {
        String str = this.iSite + 1 + "/3";
        int shift = this.rectDialog.width >> 5;
        int x = this.rectDialog.getRight() - shift;
        int y = this.rectDialog.y + shift;
        this.fontGold.drawString(g, str.toCharArray(), x, y, 24);
    }

    public void paintArrow(Graphics g, int id, int iFrame, boolean bActive) {
        if (bActive) {
            this.sprArrows.setFrame(iFrame);
            this.sprArrows.setPosition(this.rectArrowsDialog[id].x, this.rectArrowsDialog[id].y);
            this.sprArrows.paint(g);
        } else {
            this.sprArrowsInactive.setFrame(iFrame);
            this.sprArrowsInactive.setPosition(this.rectArrowsDialog[id].x, this.rectArrowsDialog[id].y);
            this.sprArrowsInactive.paint(g);
        }
    }
}

