/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    public static final int IMG_RES_ROTATION = 0;
    public static final int IMG_LOGO_INLOGIC = 1;
    public static final int IMG_SPLASH = 2;
    public static final int IMG_BG = 3;
    public static final int IMG_LOGO_MENU = 4;
    public static final int IMG_BOX_BLACK_LONG = 6;
    public static final int IMG_BOX_GOLD_LONG = 7;
    public static final int IMG_BOX_BLACK_SHORT = 8;
    public static final int IMG_BOX_GOLD_SHORT = 9;
    public static final int IMG_BOX_BLACK_BIG = 10;
    public static final int IMG_BOX_GOLD_BIG = 11;
    public static final int IMG_BOX_GOLD_SLIM = 13;
    public static final int IMG_CARD_BACK = 14;
    public static final int IMG_CARD_SELECTOR = 15;
    public static final int IMG_CARD_PLACEHOLDER_TABLE = 16;
    public static final int IMG_CARD_PLACEHOLDER_PLAYER = 17;
    public static final int IMG_TABLE = 18;
    public static final int IMG_FACE_1 = 19;
    public static final int IMG_FACE_2 = 20;
    public static final int IMG_FACE_3 = 21;
    public static final int IMG_FACE_4 = 22;
    public static final int IMG_FACE_5 = 23;
    public static final int IMG_FACE_6 = 24;
    public static final int IMG_FACE_7 = 25;
    public static final int IMG_FACE_8 = 26;
    public static final int IMG_FACE_SELECTOR = 27;
    public static final int IMG_PLAYER_BOX_SELECTOR = 28;
    public static final int IMG_BG_SHADOW = 29;
    public static final int IMG_RAISE_BOX_BLACK = 30;
    public static final int IMG_POT_BOX_BLACK = 31;
    public static final int IMG_POT_BOX_GOLD = 32;
    public static final int TOTAL_IMGS = 40;
    public static Image[] resImgs = new Image[40];
    public static final int SPR_LANGUAGES = 0;
    public static final int SPR_ICONS = 1;
    public static final int SPR_ICONS_ACHIEVEMENTS = 2;
    public static final int SPR_ARROWS = 3;
    public static final int SPR_ARROWS_INACTIVE = 4;
    public static final int SPR_CARDS = 5;
    public static final int SPR_CHIPS = 6;
    public static final int SPR_DIALOG = 7;
    public static final int SPR_WIN_CHIP = 8;
    public static final int TOTAL_SPRS = 10;
    public static Sprite[] resSprs = new Sprite[10];
    public static final int GFONT_BLACK = 0;
    public static final int GFONT_GOLD = 1;
    public static final int GFONT_BLACK_BIG = 2;
    public static final int GFONT_GOLD_BIG = 3;
    public static final int TOTAL_GFONTS = 4;
    public static GFont[] resGFonts = new GFont[4];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    private static String langDir = "/";
    public static String langCode = "";
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static final int TEXT_MAIN_LOADING = 3;
    public static final int TEXT_MAIN_EXIT_QUESTION = 4;
    public static final int TEXT_MAIN_ENABLE_MUSIC_QUESTION = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_MAIN_BB_MENU = 8;
    public static final int TEXT_MAIN_BB_BACK = 9;
    public static final int TEXT_MAIN_VERSION = 10;
    public static final int TEXT_MAIN_ON = 11;
    public static final int TEXT_MAIN_OFF = 12;
    public static final int TEXT_MAIN_CONTINUE_QUESTION = 13;
    public static final int TEXT_MAIN_PLAY = 14;
    public static final int TEXT_MAIN_PROFILE = 15;
    public static final int TEXT_MAIN_SETTINGS = 16;
    public static final int TEXT_MAIN_INSTRUCTIONS = 17;
    public static final int TEXT_MAIN_ABOUT = 18;
    public static final int TEXT_MAIN_MORE_GAMES = 19;
    public static final int TEXT_MAIN_SOUND = 20;
    public static final int TEXT_MAIN_RESET = 21;
    public static final int TEXT_MAIN_RESET_QUESTION = 22;
    public static final int TEXT_MAIN_RESUME = 23;
    public static final int TEXT_MAIN_NEW_GAME = 24;
    public static final int TEXT_MAIN_NEW_GAME_QUESTION = 25;
    public static final int TEXT_MAIN_QUIT_TO_MENU = 26;
    public static final int TEXT_MAIN_QUIT_TO_MENU_QUESTION = 27;
    public static final int TEXT_MAIN_MORE_GAMES_QUESTION = 28;
    public static final int TEXT_MAIN_HOURS = 30;
    public static final int TEXT_MAIN_MINUTES = 31;
    public static final int TEXT_MAIN_SECONDS = 32;
    public static final int TEXT_MAIN_GAME_PLAYER = 33;
    public static final int TEXT_MAIN_GAME_GAMES = 34;
    public static final int TEXT_MAIN_GAME_HANDS = 35;
    public static final int TEXT_MAIN_GAME_POT = 37;
    public static final int TEXT_MAIN_INSTRUCTIONS_AIM = 45;
    public static final int TEXT_MAIN_INSTRUCTIONS_CONTROLS_TOUCH = 46;
    public static final int TEXT_MAIN_INSTRUCTIONS_CONTROLS_KEYBOARD = 47;
    public static final int TEXT_MAIN_INSTRUCTIONS_GAME_ACTIONS = 48;
    public static final int TEXT_MAIN_FOLD = 50;
    public static final int TEXT_MAIN_CHECK = 51;
    public static final int TEXT_MAIN_BET = 52;
    public static final int TEXT_MAIN_CALL = 53;
    public static final int TEXT_MAIN_RAISE = 54;
    public static final int TEXT_MAIN_ALLIN = 55;
    public static final int TEXT_MAIN_CHOOSE_NUMBER_OF_OPPONENTS = 60;
    public static final int TEXT_MAIN_CHOOSE_BLINDS = 61;
    public static final int TEXT_MAIN_WIN = 62;
    public static final int TEXT_MAIN_WINS = 63;
    public static final int TEXT_MAIN_WIN_GAME = 64;
    public static final int TEXT_MAIN_WINS_GAME = 65;
    public static final int TEXT_MAIN_LOSES_GAME = 66;
    public static final int TEXT_MAIN_WITH_KICKER = 67;
    public static final int TEXT_MAIN_AND = 68;
    public static final int TEXT_MAIN_ES_INVERTED_EXCLAMATION_MARK = 69;
    public static final int TEXT_MAIN_CARD_ACE = 80;
    public static final int TEXT_MAIN_CARD_TWO = 81;
    public static final int TEXT_MAIN_CARD_THREE = 82;
    public static final int TEXT_MAIN_CARD_FOUR = 83;
    public static final int TEXT_MAIN_CARD_FIVE = 84;
    public static final int TEXT_MAIN_CARD_SIX = 85;
    public static final int TEXT_MAIN_CARD_SEVEN = 86;
    public static final int TEXT_MAIN_CARD_EIGHT = 87;
    public static final int TEXT_MAIN_CARD_NINE = 88;
    public static final int TEXT_MAIN_CARD_TEN = 89;
    public static final int TEXT_MAIN_CARD_JACK = 90;
    public static final int TEXT_MAIN_CARD_QUEEN = 91;
    public static final int TEXT_MAIN_CARD_KING = 92;
    public static final int TEXT_MAIN_COMBINATION_HIGH_CARD = 100;
    public static final int TEXT_MAIN_COMBINATION_PAIR = 101;
    public static final int TEXT_MAIN_COMBINATION_TWO_PAIRS = 102;
    public static final int TEXT_MAIN_COMBINATION_THREE_OF_A_KIND = 103;
    public static final int TEXT_MAIN_COMBINATION_STRAIGHT = 104;
    public static final int TEXT_MAIN_COMBINATION_FLUSH = 105;
    public static final int TEXT_MAIN_COMBINATION_FULL_HOUSE = 106;
    public static final int TEXT_MAIN_COMBINATION_FOUR_OF_A_KIND = 107;
    public static final int TEXT_MAIN_COMBINATION_STRAIGHT_FLUSH = 108;
    public static final int TEXT_MAIN_COMBINATION_ROYAL_FLUSH = 109;
    public static final int TEXT_MAIN_PROFILE_LEVEL = 110;
    public static final int TEXT_MAIN_PROFILE_XP = 111;
    public static final int TEXT_MAIN_PROFILE_GAMES_PLAYED = 112;
    public static final int TEXT_MAIN_PROFILE_GAMES_WON = 113;
    public static final int TEXT_MAIN_PROFILE_HANDS_PLAYED = 114;
    public static final int TEXT_MAIN_PROFILE_HANDS_WON = 115;
    public static final int TEXT_MAIN_PROFILE_BIGGEST_WIN = 117;
    public static final int TEXT_MAIN_PROFILE_TIME_PLAYED = 118;
    public static final int TEXT_MAIN_PROFILE_ACHIEVEMENTS = 119;
    public static final int TEXT_MAIN_PROFILE_WIN_WITH = 120;
    public static final int TEXT_MAIN_PROFILE_WINS_IN_ROW = 121;
    public static boolean sysFont;
    public static boolean allFonts;

    public static void initFonts(int width, int height) {
        allFonts = true;
        if (height < 320) {
            allFonts = false;
        }
    }

    public static void initGraphicsDirs(int width, int height) {
        graphicsBaseDir = "/";
    }

    public static Image createImage(String imgName) {
        System.out.println(imgName);
        Image image = null;
        try {
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (image == null) {
            System.out.println("null");
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "logo.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "splash.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "menu_bg.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "menu_poker.png";
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "mnu_button_black.png";
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "mnu_button_gold.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "button_black.png";
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "button_gold.png";
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "player_box_black.png";
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "player_box_gold.png";
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "button_gold_slim.png";
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "cardback.png";
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "card_selector.png";
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "menu_placeholder.png";
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "cardholder.png";
                break;
            }
            case 18: {
                imgPath = graphicsBaseDir + "menu_border.png";
                break;
            }
            case 19: {
                imgPath = graphicsBaseDir + "face1.png";
                break;
            }
            case 20: {
                imgPath = graphicsBaseDir + "face2.png";
                break;
            }
            case 21: {
                imgPath = graphicsBaseDir + "face3.png";
                break;
            }
            case 22: {
                imgPath = graphicsBaseDir + "face4.png";
                break;
            }
            case 23: {
                imgPath = graphicsBaseDir + "face5.png";
                break;
            }
            case 24: {
                imgPath = graphicsBaseDir + "face6.png";
                break;
            }
            case 25: {
                imgPath = graphicsBaseDir + "face7.png";
                break;
            }
            case 26: {
                imgPath = graphicsBaseDir + "face8.png";
                break;
            }
            case 27: {
                imgPath = graphicsBaseDir + "fs.png";
                break;
            }
            case 28: {
                imgPath = graphicsBaseDir + "pb.png";
                break;
            }
            case 29: {
                imgPath = graphicsBaseDir + "bg_shadow.png";
                break;
            }
            case 30: {
                imgPath = graphicsBaseDir + "raise_box_black.png";
                break;
            }
            case 31: {
                imgPath = graphicsBaseDir + "pot_box_black.png";
                break;
            }
            case 32: {
                imgPath = graphicsBaseDir + "pot_box_gold.png";
                break;
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "language.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "icons.png";
                slicesX = 15;
                slicesY = 1;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "icons_2.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "arrows.png";
                slicesX = 4;
                slicesY = 1;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "arrows2.png";
                slicesX = 4;
                slicesY = 1;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "cards.png";
                slicesX = 13;
                slicesY = 4;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "dsb.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "info_bar.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "win.png";
                slicesX = 10;
                slicesY = 1;
                break;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFont(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '\u02c6', '.', ',', ':', ';', '\"', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\'', '/', ' '};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 8: {
                spaceBetweenChars = 0;
                fontCharsWidth = new short[]{7, 6, 6, 5, 5, 5, 6, 6, 2, 5, 6, 4, 7, 6, 6, 5, 6, 5, 5, 6, 6, 7, 9, 6, 6, 6, 7, 7, 7, 7, 7, 7, 6, 6, 5, 5, 5, 5, 5, 5, 3, 3, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 6, 6, 5, 6, 6, 5, 7, 3, 6, 3, 3, 8, 4, 4, 4, 6, 4, 4, 2, 2, 2, 2, 4, 2, 4, 2, 4, 5, 3, 5, 3, 5, 5, 5, 5, 5, 5, 6, 5, 2, 3, 4};
                break;
            }
            case 14: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{8, 7, 7, 7, 6, 6, 7, 7, 3, 7, 8, 6, 8, 7, 7, 6, 7, 8, 6, 7, 7, 8, 10, 8, 9, 6, 8, 8, 8, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 6, 4, 4, 4, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 8, 8, 6, 6, 7, 6, 7, 6, 7, 8, 8, 4, 8, 4, 4, 9, 4, 7, 6, 7, 7, 6, 3, 3, 3, 3, 6, 3, 7, 3, 7, 6, 4, 6, 5, 6, 6, 8, 6, 6, 6, 6, 6, 3, 4, 5};
                break;
            }
            case 17: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{12, 10, 10, 10, 9, 8, 11, 11, 4, 9, 12, 8, 12, 11, 11, 9, 11, 11, 9, 10, 11, 12, 16, 12, 12, 9, 12, 12, 12, 12, 12, 12, 10, 10, 10, 9, 9, 9, 9, 9, 5, 4, 6, 7, 8, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 9, 9, 10, 9, 8, 8, 9, 11, 11, 5, 10, 6, 6, 13, 4, 9, 8, 8, 9, 7, 4, 4, 4, 4, 8, 4, 9, 4, 9, 8, 5, 8, 7, 8, 8, 10, 8, 8, 8, 8, 8, 4, 5, 7};
                break;
            }
            case 27: {
                spaceBetweenChars = 2;
                fontCharsWidth = new short[]{18, 15, 16, 15, 14, 13, 17, 15, 6, 14, 17, 13, 18, 15, 17, 14, 18, 16, 15, 16, 15, 18, 24, 18, 18, 15, 18, 18, 18, 18, 18, 18, 16, 16, 15, 14, 14, 14, 14, 14, 7, 6, 9, 9, 13, 15, 15, 17, 17, 17, 17, 17, 15, 15, 15, 15, 15, 18, 16, 16, 15, 15, 16, 15, 14, 15, 15, 19, 17, 7, 15, 8, 8, 21, 7, 12, 13, 14, 13, 9, 6, 6, 6, 6, 12, 6, 13, 6, 13, 12, 8, 14, 11, 14, 14, 16, 14, 14, 14, 14, 14, 6, 7, 10};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[fontCharsWidth.length - 1]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fnt_b.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fnt_g.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 2: {
                gFontImg = allFonts ? Resources.createImage(graphicsBaseDir + "menu_fnt_b.png") : Resources.createImage(graphicsBaseDir + "fnt_b.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
            case 3: {
                gFontImg = allFonts ? Resources.createImage(graphicsBaseDir + "menu_fnt_g.png") : Resources.createImage(graphicsBaseDir + "fnt_g.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFont(gFontImg);
                break;
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        Resources.langCode = langCode;
        langDir = "/lang/" + langCode + "/";
        sysFont = langCode == "ru";
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    public static void freeAllResources() {
        int i;
        for (i = 0; i < resImgs.length; ++i) {
            Resources.resImgs[i] = null;
        }
        for (i = 0; i < resSprs.length; ++i) {
            Resources.resSprs[i] = null;
        }
        for (i = 0; i < resGFonts.length; ++i) {
            Resources.resGFonts[i] = null;
        }
    }
}

