/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenAbout
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int TOTAL_COMP_IDS = 1;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[4];
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[1];
    private Rectangle rectDialog;
    private Rectangle rectScreen;
    private Rectangle rectBack;
    private Rectangle rectLogo;
    private Rectangle rectFK;
    private Image imgLogo;
    private Image imgGameBorder;
    private Image imgBlueTile;
    private Image imgLight;
    private Sprite sprIcon;
    private Sprite sprWheelsMini;
    private Sprite sprMenuIcons;
    private Sprite sprBut;
    private Sprite sprWheels;
    private PreparedText preparedTextAbout;
    private GFont fontBig;
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];
    public int _iInteruption = 0;
    public int _iCycle;
    public int _iMusicControler;

    public ScreenAbout(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
    }

    public void beforeShow() {
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.loadResources();
        this.initSprites();
        this.initImages();
        this.initFonts();
        this.initBack();
        this.initLogo();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        Common.initScreen(this.rectScreen, this.sprBut, this.sprWheels);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 3, 33, 32, 34});
        Resources.loadSprites(new int[]{64, 62, 65, 61, 63});
        Resources.loadGFont(1);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 3, 33, 32, 34});
        Resources.freeSprites(new int[]{64, 62, 65, 61, 63});
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initSprites() {
        this.sprIcon = Resources.resSprs[64];
        this.sprWheelsMini = Resources.resSprs[62];
        this.sprMenuIcons = Resources.resSprs[65];
        this.sprBut = Resources.resSprs[61];
        this.sprWheels = Resources.resSprs[63];
    }

    private void initImages() {
        this.imgLogo = Resources.resImgs[3];
        this.imgGameBorder = Resources.resImgs[33];
        this.imgBlueTile = Resources.resImgs[32];
        this.imgLight = Resources.resImgs[34];
    }

    private void initFonts() {
        this.fontBig = Resources.resGFonts[1];
        this.preparedTextAbout = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
    }

    private void initAnimationComponents() {
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectDialog, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
    }

    private void freeGraphics() {
        this.imgLogo = null;
    }

    private void calculatePositions() {
        int _iBorder = this.rectScreen.width >> 3;
        int _iWidth = this.rectScreen.width - (this.rectScreen.width >> 2);
        this.preparedTextAbout.prepareText("\n" + X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + "\n" + X.singleton.getAppProperty("MIDlet-Version"), _iWidth - _iBorder);
        int height = (_iBorder << 1) + this.imgLogo.getHeight() + this.preparedTextAbout.getTextHeight();
        this.rectDialog = new Rectangle(_iBorder, this._HEIGHT - this.rectBack.height - (height += this.fontBig.getHeight()) >> 1, _iWidth, height);
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this.rectBack.width << 1), MainCanvas.HEIGHT - (this.rectBack.height << 1), this.rectBack.width << 1, this.rectBack.height << 1);
        int offset = this.sprBut.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.sprBut.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.sprBut.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.sprBut.getWidth() >> 1), yCenterFK - (this.sprBut.getHeight() >> 1), this.sprBut.getWidth(), this.sprBut.getHeight());
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        this.animationController();
        this.animationComponentsUpdate();
        Common.updateWheels(lastRunLenght, this.mainCanvas);
    }

    private void updateSoundInterupt() {
        if (MainCanvas.interuption_nokia == 0) {
            if (this._iCycle > 0) {
                --this._iCycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                if (this._iMusicControler == 1) {
                    this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                    this._iMusicControler = 0;
                }
                this._iCycle = 10;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        if (this._iSequence == this._iSequenceHide) {
            this._iSequence = this._iSequenceShow;
            this._bChangeSequence = true;
            this.mainCanvas.repaint();
            this.startNextScreen(this._iNextMode);
        } else if (this._iSequence == this._iSequenceShow) {
            this._iSequence = this._iSequenceStop;
            this.mainCanvas.repaint();
        }
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 2));
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintBody(Graphics g) {
        Common.paintTopPanel(g, this.imgLight, this.sprBut, this.sprWheelsMini, this.sprMenuIcons, this.fontBig, Resources.resTexts[0].getHashedString(23), Common.MENU_IC_ABOUT);
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        g.drawImage(this.imgLogo, this.rectLogo.getCenterX(), this.rectLogo.getCenterY(), 33);
        this.preparedTextAbout.drawText(g, Common.rectArea, this.preparedTextAbout.getTextHeight(), 33);
    }

    private void paintFK(Graphics g) {
        this.sprBut.setFrame(0);
        this.sprBut.setPosition(this.rectScreen.width - this.sprBut.getWidth(), this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprIcon.setFrame(Common.IC_BACK);
        this.sprIcon.setPosition(this.rectScreen.width - (this.imgGameBorder.getHeight() >> 1) - this.sprIcon.getWidth(), this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (this._rectItems[i] == null || !this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }

    private void initBack() {
        int width = this.sprBut.getWidth();
        int height = this.sprBut.getHeight();
        int x = this.rectScreen.width - (width + (width >> 2));
        int y = this.rectScreen.height - (height + (height >> 2));
        this.rectBack = new Rectangle(x, y, width, height);
    }

    private void initLogo() {
        int width = this.imgLogo.getWidth();
        int height = this.imgLogo.getHeight();
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int y = this.rectScreen.getCenterY() - (height >> 1);
        if (MainCanvas.HEIGHT < 300) {
            y += Resources.resGFonts[1].getHeight();
        }
        this.rectLogo = new Rectangle(x, y, width, height);
    }
}

