/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Block;
import sk.inlogic.Common;
import sk.inlogic.Game;
import sk.inlogic.Jewel;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    public static boolean noMoves;
    private MainCanvas mainCanvas;
    private boolean _bNeedRepaint;
    private int iStatus = -1;
    private int _iGameMode;
    private int highScore;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_STARTSCREEN = 5;
    private static final int STATUS_RESTARTSCREEN = 6;
    private static final int STATUS_LAST_MESSAGE = 7;
    private static final int STATUS_REALY_QUIT = 8;
    private static final int STATUS_MAIN_MENU = 9;
    private static final int STATUS_MAIN_LEVEL_SELECT = 9;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESTART = 2;
    private static final int COMP_ID_INSTRUCTIONS = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_ARR_UP = 6;
    private static final int COMP_ID_ARR_DOWN = 7;
    private static final int CENTER_BUTTON = 8;
    private static final int TOTAL_COMP_IDS = 9;
    private Rectangle[] _rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    private Rectangle rectLogo;
    private Rectangle _rectTop;
    private Rectangle rectDialogInstr;
    private Rectangle rectGameBar;
    private int _iOffsetY;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private Rectangle rectStartGameText;
    private Rectangle rectExitGameText;
    private Rectangle rectInstrGameText;
    private Rectangle rectStartTextUp;
    private Rectangle rectStartTextDown;
    private Rectangle rectScreen;
    private boolean _bChangeSequence = false;
    private Image imgGameLogo;
    private Image imgGameBorder;
    private Image imgBlueTile;
    private Image imgLight;
    private Sprite sprCup;
    private Sprite sprGameMode;
    private Sprite sprArrow;
    private Sprite sprBut;
    private Sprite sprIcon;
    private Sprite sprWheels;
    private Sprite sprMenuIcons;
    private Sprite sprWheelsMini;
    private PreparedText _ptInstructions;
    private PreparedText _ptGameTutorial;
    private PreparedText _ptGameTxts;
    private PreparedText _ptGameTxts2;
    private PreparedText _ptGameScore;
    private PreparedText _ptMoves;
    private GFont fontBig;
    private GFont fontSmall;
    private int[][] _animationSequence = new int[9][13];
    private AnimationComponent[] _animationComponents = new AnimationComponent[13];
    private int _iSelectedCompId;
    private int icount;
    private int _iTextOffsetY;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    int level = 0;
    private int actualLevel;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    public int interuption = 0;
    public int _iCycle;
    public int _iMusicControler;
    int _iBw;
    private int score = 0;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    boolean bDragInstructions = false;

    public ScreenGame(MainCanvas mC, int gameMode, int level) {
        System.out.println("SCREEN GAME");
        this.mainCanvas = mC;
        this._iGameMode = gameMode;
        this.actualLevel = level;
        Level.getLevel(this.actualLevel);
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.initData();
        this.calculatePositions();
        this.preapreTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.loadLevel();
        this.loadData();
        if (Level._bIsTutorial) {
            this.startAnimation(true, 5);
        } else {
            this.startAnimation(true, 5);
        }
        Common.initScreen(this.rectScreen, this.sprBut, this.sprWheels);
    }

    public void afterHide() {
        RMSObjects.freeRMSConnect(this.getRMSConnectIdByGameType(this._iGameMode));
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 4, 33, 32, 36, 34});
        Resources.loadSprites(new int[]{22, 14, 19, 37, 54, 61, 64, 63, 66, 67, 68, 69, 65, 62, 70, 71});
        Resources.loadGFonts(new int[]{0, 1});
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 4, 33, 32, 36, 34});
        Resources.freeSprites(new int[]{22, 19, 37, 54, 61, 64, 63, 66, 67, 68, 69, 65, 62, 70, 71});
        Resources.freeGFonts(new int[]{0, 1});
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.rectScreen = new Rectangle(0, 0, this._WIDTH, this._HEIGHT);
    }

    private void initImages() {
        this.imgGameLogo = Resources.resImgs[4];
        this.imgGameBorder = Resources.resImgs[33];
        this.imgBlueTile = Resources.resImgs[32];
        this.imgLight = Resources.resImgs[34];
    }

    private void initSprites() {
        this.sprGameMode = Resources.resSprs[37];
        this.sprArrow = Resources.resSprs[54];
        this.sprWheels = Resources.resSprs[63];
        this.sprBut = Resources.resSprs[61];
        this.sprIcon = Resources.resSprs[64];
        this.sprMenuIcons = Resources.resSprs[65];
        this.sprWheelsMini = Resources.resSprs[62];
        this.sprCup = Resources.resSprs[70];
    }

    private void initFonts() {
        this.fontBig = Resources.resGFonts[1];
        this.fontSmall = Resources.resGFonts[0];
        this._ptInstructions = new PreparedText(this.fontBig);
        this._ptGameScore = new PreparedText(this.fontSmall);
        this._ptMoves = new PreparedText(this.fontBig);
        this._ptGameTutorial = new PreparedText(this.fontBig);
        this._ptGameTxts = new PreparedText(this.fontBig);
        this._ptGameTxts2 = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 5;
        this._animationSequence[0][1] = 10;
        this._animationSequence[0][2] = 11;
        this._animationSequence[0][3] = 12;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[1][0] = 4;
        this._animationSequence[1][1] = 6;
        this._animationSequence[1][2] = 7;
        this._animationSequence[1][3] = 8;
        this._animationSequence[1][4] = 9;
        this._animationSequence[1][5] = 10;
        this._animationSequence[3][0] = 1;
        this._animationSequence[3][1] = 3;
        this._animationSequence[3][2] = 5;
        this._animationSequence[3][3] = 10;
        this._animationSequence[3][4] = -1;
        this._animationSequence[3][5] = -1;
        this._animationSequence[7][0] = 1;
        this._animationSequence[7][1] = 3;
        this._animationSequence[7][2] = 10;
        this._animationSequence[7][3] = -1;
        this._animationSequence[7][4] = -1;
        this._animationSequence[7][5] = -1;
        this._animationSequence[8][0] = 1;
        this._animationSequence[8][1] = 3;
        this._animationSequence[8][2] = 10;
        this._animationSequence[8][3] = 11;
        this._animationSequence[8][4] = -1;
        this._animationSequence[8][5] = -1;
        this._animationSequence[6][0] = 1;
        this._animationSequence[6][1] = 3;
        this._animationSequence[6][2] = 10;
        this._animationSequence[6][3] = 11;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[2][0] = 1;
        this._animationSequence[2][1] = 3;
        this._animationSequence[2][2] = 10;
        this._animationSequence[2][3] = 11;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[5][0] = 1;
        this._animationSequence[5][1] = 3;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = -1;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[4][0] = 1;
        this._animationSequence[4][1] = 3;
        this._animationSequence[4][2] = 11;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = this.iStatus == 5 || this.iStatus == 4 ? new AnimationComponent(this.mainCanvas, this.rectStartGameText, this._WIDTH, this._HEIGHT) : (this.iStatus == 6 || this.iStatus == 8 || this.iStatus == 7 ? new AnimationComponent(this.mainCanvas, this.rectExitGameText, this._WIDTH, this._HEIGHT) : (this.iStatus == 3 ? new AnimationComponent(this.mainCanvas, this.rectInstrGameText, this._WIDTH, this._HEIGHT) : new AnimationComponent(this.mainCanvas, this.rectStartGameText, this._WIDTH, this._HEIGHT)));
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectLogo, this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this._rectItems[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this._rectItems[4], this._WIDTH, this._HEIGHT);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this._rectItems[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectItems[5], this._WIDTH, this._HEIGHT);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectGameArea, this._WIDTH, this._HEIGHT);
        this.showAnimationComponent();
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[2].startShowAnimation(2);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(2);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(0);
        this._animationComponents[10].startShowAnimation(1);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[2].startHideAnimation(2);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(2);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(0);
        this._animationComponents[10].startHideAnimation(1);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(3);
    }

    private void preapreTxt() {
        String _sTmpControls = Resources.resTexts[0].getHashedString(16);
        this._ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + _sTmpControls, this.rectInstrGameText.width);
        this._ptInstructions.setLineHeightCorrection(-2);
        this._ptGameScore.prepareText("0", this._rectTop.width);
        this._ptMoves.prepareText("0", this._rectTop.width);
    }

    private void loadLevel() {
        this.lvl = this._iGameMode == Level.TYPE_BLOCKER || this._iGameMode == Level.TYPE_MIXED_TIME_AND_BLOCKS ? Level._iBlockScheme : 1;
        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
    }

    private void loadData() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        RMSObjects.createRMSConnect(rmsConnectId);
        RMSObjects.createRMSConnect(0);
        RMSObjects.rmsConnects[0].load();
    }

    private void freeGraphics() {
        this.imgGameLogo = null;
        this._ptInstructions = null;
        this.sprGameMode = null;
    }

    private void addScoreToTable() {
        if (RMSObjects.game.getScore() < Level._iScoreMin) {
            return;
        }
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = this.actualLevel;
        scoreItem.userName = Integer.toString(this.actualLevel);
        scoreItem.scoreValue = RMSObjects.game.getScore() >= Level._iScoreHig ? 3 : (RMSObjects.game.getScore() >= Level._iScoreMid ? 2 : (RMSObjects.game.getScore() >= Level._iScoreMin ? 1 : 0));
        if (this.score > this.highScore) {
            this.highScore = this.score;
        }
        scoreItem.highScore = this.highScore;
        RMSObjects.localScores.userName = Integer.toString(this.actualLevel);
        System.out.println("RMSObjects.localScores.userName: " + RMSObjects.localScores.userName);
        RMSObjects.localScores.insertScoreItem(scoreItem, this.actualLevel);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
    }

    private int getRMSConnectIdByGameType(int gameType) {
        switch (0) {
            case 20: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
        }
        return 0;
    }

    public void beforeInteruption() {
        System.out.println("before interuption");
        if (this.iStatus == 0) {
            this.setGameMenuStatus();
        }
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        System.out.println("after interuption");
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        Jewel.SHIFT_HORIZONTAL_SEL = 0;
        Jewel.SHIFT_VERTICAL_SEL = 0;
        Jewel.BLOCKSIZE = Resources.resImgs[32].getWidth();
        Jewel.SHIFT_HORIZONTAL = (Resources.resImgs[32].getWidth() >> 1) - (Resources.resSprs[66].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL = (Resources.resImgs[32].getHeight() >> 1) - (Resources.resSprs[66].getHeight() >> 1);
        Jewel.SHIFT_HORIZONTAL_FALL = (Resources.resImgs[32].getWidth() >> 1) - (Resources.resSprs[66].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_FALL = (Resources.resImgs[32].getHeight() >> 1) - 1;
        Jewel.SHIFT_HORIZONTAL_ESCAPE = (Resources.resImgs[32].getWidth() >> 1) - (Resources.resSprs[71].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_ESCAPE = (Resources.resImgs[32].getHeight() >> 1) - (Resources.resSprs[71].getHeight() >> 1);
        this._iOffsetY >>= 4;
        int _iTmpY = (MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1) - Common.rectTopPanel.height >> 1;
        this._rectTop = new Rectangle(this._iOffsetXDefault, _iTmpY, this._WIDTH - (this._iOffsetXDefault << 1), Common.rectTopPanel.height);
        this.rectLogo = new Rectangle(this._WIDTH >> 1, this.imgGameLogo.getHeight() >> 2, this.imgGameLogo.getWidth(), this.imgGameLogo.getHeight());
        this.rectDialogInstr = Common.rectArea;
        int yDiff = (this.rectScreen.height - this.rectLogo.getBottom() - (this.sprWheelsMini.getHeight() << 2) - this.sprBut.getHeight()) / 5;
        int y = this.rectLogo.getBottom() + yDiff;
        int width = (this.rectScreen.width - this.imgGameBorder.getHeight()) / this.sprBut.getWidth() * this.sprBut.getWidth();
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int index = 2;
        while (index < 6) {
            this._rectItems[index] = new Rectangle(x, y, width, this.sprWheelsMini.getHeight());
            ++index;
            y += this.sprWheelsMini.getHeight() + yDiff;
        }
        y = Common.rectTopPanel.getBottom() + (MainCanvas.HEIGHT - Common.rectTopPanel.getBottom() - (Jewel.BLOCKSIZE << 3) >> 1);
        this.rectGameArea = new Rectangle(this.rectScreen.getCenterX() - (Jewel.BLOCKSIZE << 2), y, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        RMSObjects.game.setGameArea(this.rectGameArea);
        Jewel.MOVE_VELOCITY = (this.rectGameArea.width << 8) / 48;
        Jewel.DSP_BNSBOMB = Resources.resSprs[69].getWidth() - Jewel.BLOCKSIZE >> 1;
        Jewel.DSP_BNSCROSS = Resources.resSprs[67].getWidth() - Jewel.BLOCKSIZE >> 1;
        this.rectStartGameText = Common.rectArea;
        this.rectExitGameText = Common.rectArea;
        int heightArrow = this.sprArrow.getHeight();
        int widthArrow = this.sprArrow.getWidth();
        this.rectInstrGameText = new Rectangle(this.rectDialogInstr.x + (heightArrow >> 1), this.rectDialogInstr.y + heightArrow + (heightArrow >> 2), this.rectDialogInstr.width - heightArrow, this.rectDialogInstr.height - (heightArrow + (heightArrow >> 2) << 1));
        this._rectItems[6] = new Rectangle(this.rectScreen.getCenterX() - (widthArrow >> 1), this.rectDialogInstr.y + (this.imgGameBorder.getHeight() >> 1), widthArrow, heightArrow);
        this._rectItems[7] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectDialogInstr.getBottom() - heightArrow - (this.imgGameBorder.getHeight() >> 1), widthArrow, heightArrow);
        int widthBtn = MainCanvas.WIDTH / 3;
        this._rectItems[0] = new Rectangle(0, this.rectScreen.getBottom() - (this.sprBut.getHeight() << 1), widthBtn, this.sprBut.getHeight() << 1);
        this._rectItems[1] = new Rectangle(MainCanvas.WIDTH - widthBtn, this.rectScreen.getBottom() - (this.sprBut.getHeight() << 1), widthBtn, this.sprBut.getHeight() << 1);
        this._rectItems[8] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthBtn >> 1), this._rectItems[1].y, widthBtn, this.sprBut.getHeight() << 1);
        width = this.rectStartGameText.width;
        int height = (this.rectStartGameText.height >> 1) - (this.sprGameMode.getHeight() >> 1);
        this.rectStartTextUp = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.y, width, height);
        this.rectStartTextDown = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.getBottom() - height, width, height);
        this.initGameBar();
    }

    public void update(long lastRunLenght) {
        if (this.iStatus == 5) {
            this.reset();
        }
        if (this.iStatus == 0 && this._iNextMode != 2) {
            RMSObjects.game.update(lastRunLenght);
            if (this.score > this.highScore) {
                this.highScore = this.score;
            }
            if (RMSObjects.game.isLevelDone()) {
                this.startAnimation(true, 2);
                this.addScoreToTable();
            } else if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
                this.icount = -1;
                if (this.getTopScore() < this.score) {
                    this.icount = 0;
                }
            }
        }
        if (this.iStatus == 2 && this.icount >= 0) {
            ++this.icount;
            this.icount %= 10;
        }
        if (this.iStatus == 3) {
            this._bNeedRepaint = false;
            this.textMove();
        }
        this.animationController();
        this.animationComponentsUpdate();
        Common.updateWheels(lastRunLenght, this.mainCanvas);
        this.mainCanvas.repaint();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == 4 ? this._iSequenceHide : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        if (this.iStatus != -1) {
            for (int i = 0; i < this._animationSequence[this.iStatus].length; ++i) {
                if (i >= this._animationSequence[this.iStatus].length || this._animationSequence[this.iStatus][i] == -1 || this._animationComponents[this._animationSequence[this.iStatus][i]] == null || this._animationComponents[this._animationSequence[this.iStatus][i]].isComponentAnimated()) continue;
                this._animationComponents[this._animationSequence[this.iStatus][i]].update();
                this.mainCanvas.repaint();
                _return = true;
            }
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 9) {
                    this.startMenuScreen();
                }
                if (this._iNextMode == 9) {
                    this.startSelectLevel();
                }
                this._iSequence = this._iSequenceShow;
                this.iStatus = this._iNextMode;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this.mainCanvas, 0);
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        this.mainCanvas.changeLastActiveScreen(sg);
    }

    private void startSelectLevel() {
        this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
        this.mainCanvas.getSoundManager().Stop();
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void reset() {
        this.score = 0;
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.iStatus) {
            case 0: {
                this.paintGame(g);
                break;
            }
            case 1: {
                this.paintGameMenuScreen(g);
                break;
            }
            case 3: {
                this.paintInstructionsScreen(g);
                break;
            }
            case 7: {
                this.paintLastMessageScreen(g);
                break;
            }
            case 8: {
                this.paintRealyQuitScreen(g);
                break;
            }
            case 6: {
                this.paintRestartScreen(g);
                break;
            }
            case 2: {
                this.paintResultScreen(g);
                break;
            }
            case 5: {
                this.paintLevelGoalScreen(g);
                break;
            }
            case 4: {
                this.paintTutorialScreen(g);
            }
        }
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintGame(Graphics g) {
        RMSObjects.game.paint(g);
        this.paintGameProgressBar(g);
    }

    private void paintGameMenuScreen(Graphics g) {
        this.paintLogo(g);
        this.paintDialog(g);
    }

    private void paintInstructionsScreen(Graphics g) {
        Common.paintTopPanel(g, this.imgLight, this.sprBut, this.sprWheelsMini, this.sprMenuIcons, this.fontBig, Resources.resTexts[0].getHashedString(22), Common.MENU_IC_INSTR);
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintInstructionsTxt(g);
        this.paintArrows(g);
    }

    private void paintLastMessageScreen(Graphics g) {
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintLastMessageTxt(g);
    }

    private void paintRealyQuitScreen(Graphics g) {
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintRealyQuitMessageTxt(g);
    }

    private void paintRestartScreen(Graphics g) {
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintRestartTxt(g);
    }

    private void paintResultScreen(Graphics g) {
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintResultTxt(g);
    }

    private void paintLevelGoalScreen(Graphics g) {
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintLevelGoalTxt(g);
    }

    private void paintTutorialScreen(Graphics g) {
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintTutorialTxt(g);
    }

    private void paintLogo(Graphics g) {
        g.drawImage(this.imgGameLogo, this.rectLogo.x, this.rectLogo.y, 17);
    }

    private void paintDialog(Graphics g) {
        for (int index = 2; index < 6; ++index) {
            Common.paintButton(g, this.sprBut, this._rectItems[index]);
        }
        if (this._iSelectedCompId == 2) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, Common.MENU_IC_PLAY, this._rectItems[2], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, Common.MENU_IC_PLAY, this._rectItems[2], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(25).toCharArray(), this._rectItems[2].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this._rectItems[2].getCenterY(), 6);
        if (this._iSelectedCompId == 3) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, Common.MENU_IC_INSTR, this._rectItems[3], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, Common.MENU_IC_INSTR, this._rectItems[3], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(22).toCharArray(), this._rectItems[3].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this._rectItems[3].getCenterY(), 6);
        int frame = Common.MENU_IC_MUSIC_OFF;
        String text = "";
        if (Settings.musicOn) {
            frame = Common.MENU_IC_MUSIC_ON;
            text = text + Resources.resTexts[0].getHashedString(26);
        } else {
            text = text + Resources.resTexts[0].getHashedString(27);
        }
        if (this._iSelectedCompId == 4) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, frame, this._rectItems[4], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, frame, this._rectItems[4], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, text.toCharArray(), this._rectItems[4].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this._rectItems[4].getCenterY(), 6);
        if (this._iSelectedCompId == 5) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, Common.MENU_IC_MENU, this._rectItems[5], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, Common.MENU_IC_MENU, this._rectItems[5], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(19).toCharArray(), this._rectItems[5].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this._rectItems[5].getCenterY(), 6);
    }

    private void paintScore(Graphics g) {
        this.score = RMSObjects.game.getScore();
        String scoreNumbers = String.valueOf(this.score);
        int count = scoreNumbers.length() / 3;
        int x = this.rectGameBar.getRight() - (this.sprBut.getWidth() >> 2);
        int y = this.rectGameBar.getCenterY();
        this.fontSmall.drawString(g, this.addWhitespace(scoreNumbers, count).toCharArray(), x, y, 10);
    }

    private void paintGameProgressBar(Graphics g) {
        int frame = 0;
        Common.paintButton(g, this.sprBut, this.rectGameBar);
        switch (this._iGameMode) {
            case 0: {
                frame = 0;
                break;
            }
            case 1: {
                frame = 1;
                break;
            }
            case 2: {
                frame = 3;
                break;
            }
            case 3: {
                frame = 2;
                break;
            }
            case 4: {
                frame = 4;
                break;
            }
            case 5: {
                frame = 4;
                break;
            }
            case 6: {
                frame = 1;
                break;
            }
            case 7: {
                frame = 0;
            }
        }
        Common.paintMiniWheel(g, this.sprWheelsMini, this.sprGameMode, 1, frame, this.rectGameBar, this.sprGameMode.getHeight() >> 3, true);
        this.paintScore(g);
        this.paintTopLeft(g);
    }

    private void paintArrows(Graphics g) {
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            System.out.println("nothing");
        } else {
            if (this._bScrollUP) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setTransform(3);
                this.sprArrow.setPosition(this._rectItems[6].x, this._rectItems[6].y);
                this.sprArrow.paint(g);
            }
            this.sprArrow.setTransform(0);
            if (this._bScrollDOWN) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setPosition(this._rectItems[7].x, this._rectItems[7].y);
                this.sprArrow.paint(g);
            }
        }
    }

    private void paintInstructionsTxt(Graphics g) {
        this._ptInstructions.drawText(g, this.rectInstrGameText, this._iTextOffsetY, 17);
    }

    private void paintTutorialTxt(Graphics g) {
        String _sTutotialTxt = "";
        if (MainCanvas.controlsTut == 0 && this.level == 0) {
            _sTutotialTxt = Resources.resTexts[0].getHashedString(30);
        } else {
            switch (this._iGameMode) {
                case 0: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(31);
                    break;
                }
                case 1: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(35);
                    break;
                }
                case 2: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(33);
                    break;
                }
                case 3: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(34);
                    break;
                }
                case 5: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(32);
                }
            }
        }
        boolean _bShitDevice = false;
        if (this._WIDTH == 176 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 176 && this._HEIGHT == 220) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 208 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (MainCanvas._bFranceLang) {
            _bShitDevice = true;
        }
        if (_bShitDevice) {
            this._ptGameTutorial.prepareText(_sTutotialTxt, this.rectStartGameText.width);
            Rectangle _rectTmp = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.getCenterY() - (this._ptGameTutorial.getTextHeight() >> 1), this.rectStartGameText.width, this._ptGameTutorial.getTextHeight());
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, _rectTmp, 0, 17);
        } else {
            this._ptGameTutorial.prepareText(_sTutotialTxt, this.rectStartGameText.width);
            Rectangle _rectTmp = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.getCenterY() - (this._ptGameTutorial.getTextHeight() >> 1), this.rectStartGameText.width, this._ptGameTutorial.getTextHeight());
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, _rectTmp, 0, 17);
        }
    }

    private void paintLevelGoalTxt(Graphics g) {
        String _sGoalsTxt = "";
        switch (this._iGameMode) {
            case 0: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 1: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46);
                break;
            }
            case 2: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 3: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(41) + " " + Level._iDownfallObjCount + " " + Resources.resTexts[0].getHashedString(42) + " " + Resources.resTexts[0].getHashedString(47) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 4: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 5: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + "\n" + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 6: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 7: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
            }
        }
        this._ptGameTxts.prepareText(_sGoalsTxt, this.rectStartGameText.width);
        this._ptGameTxts2.prepareText(Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1), this.rectStartGameText.width);
        this._ptGameTxts2.setLineHeightCorrection(-2);
        this._ptGameTxts2.drawText(g, this.rectStartTextUp, 0, 3);
        int y = this.rectStartGameText.getCenterY() - (this.sprGameMode.getHeight() >> 1);
        int yOffset = this.rectStartTextUp.getBottom() + (Common.rectArea.getBottom() - this.rectStartTextUp.getBottom() - this._ptGameTxts.getTextHeight() >> 1);
        Rectangle rect = new Rectangle(this.rectStartTextDown);
        rect.y = yOffset;
        rect.height = this._ptGameTxts.getTextHeight();
        if (y + this.sprGameMode.getHeight() > rect.y) {
            y = rect.y - this.sprGameMode.getHeight();
        }
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, rect, 0, 17);
    }

    private void paintLastMessageTxt(Graphics g) {
        String _sLastLevelGameMessge = "";
        _sLastLevelGameMessge = MainCanvas.totalStars == 180 ? Resources.resTexts[0].getHashedString(73) + " " + Resources.resTexts[0].getHashedString(74) : Resources.resTexts[0].getHashedString(72);
        this._ptGameTxts.prepareText(_sLastLevelGameMessge, Common.rectArea.width);
        Rectangle _rectTmp = new Rectangle(this.rectExitGameText.x, this.rectExitGameText.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1), this.rectExitGameText.width, this._ptGameTxts.getTextHeight());
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, _rectTmp, 0, 17);
    }

    private void paintRealyQuitMessageTxt(Graphics g) {
        String _sQuitQuestion = Resources.resTexts[0].getHashedString(77);
        this._ptGameTxts.prepareText(_sQuitQuestion, Common.rectArea.width);
        int iLinesCount = this._ptGameTxts.getTextLines();
        int iY = Common.rectArea.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1);
        if (iLinesCount >= 7) {
            iY -= this.fontSmall.getHeight() >> 1;
        } else if (iLinesCount >= 5) {
            iY -= this.fontSmall.getHeight() >> 2;
        } else if (iLinesCount >= 3) {
            iY -= this.fontSmall.getHeight() >> 3;
        }
        for (int i = 0; i < iLinesCount; ++i) {
            this.fontBig.drawString(g, this._ptGameTxts.getText(i).toCharArray(), Common.rectArea.getCenterX(), iY, 17);
            iY += this.fontBig.getHeight();
        }
    }

    private void paintRestartTxt(Graphics g) {
        String _sRestart = Resources.resTexts[0].getHashedString(78);
        this._ptGameTxts.prepareText(_sRestart, Common.rectArea.width);
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, Common.rectArea, 0, 3);
    }

    private void paintResultTxt(Graphics g) {
        if (RMSObjects.game.isLevelDone()) {
            this.paintNewWin(g);
        } else if (RMSObjects.game.isGameOver()) {
            this.paintNewLose(g);
        }
    }

    private void paintFK(Graphics g) {
        if (this.iStatus == 0) {
            this.paintRightFK(Common.IC_PAUSE, g);
        } else if (this.iStatus == 2) {
            if (RMSObjects.game.isGameOver()) {
                this.paintLeftFK(Common.IC_RESTART, g);
                this.paintRightFK(Common.IC_MENU, g);
            } else if (RMSObjects.game.isLevelDone()) {
                this.paintLeftFK(Common.IC_YES, g);
            }
        } else if (this.iStatus == 3) {
            this.paintRightFK(Common.IC_BACK, g);
        } else if (this.iStatus == 1) {
            this.paintRightFK(Common.IC_BACK, g);
        } else if (this.iStatus == 4) {
            this.paintLeftFK(Common.IC_YES, g);
        } else if (this.iStatus == 5) {
            this.paintLeftFK(Common.IC_YES, g);
        } else if (this.iStatus == 7) {
            this.paintRightFK(Common.IC_BACK, g);
        } else if (this.iStatus == 6) {
            this.paintLeftFK(Common.IC_YES, g);
            this.paintRightFK(Common.IC_NO, g);
        } else if (this.iStatus == 8) {
            this.paintLeftFK(Common.ICON_YES, g);
            this.paintRightFK(Common.ICON_NO, g);
        }
    }

    private void paintLeftFK(int frame, Graphics g) {
        this.sprBut.setFrame(2);
        this.sprBut.setPosition(0, this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprIcon.setFrame(frame);
        this.sprIcon.setPosition(this.imgGameBorder.getHeight() >> 2, this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    private void paintRightFK(int frame, Graphics g) {
        this.sprBut.setFrame(0);
        this.sprBut.setPosition(this.rectScreen.width - this.sprBut.getWidth(), this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprIcon.setFrame(frame);
        this.sprIcon.setPosition(this.rectScreen.width - (this.imgGameBorder.getHeight() >> 2) - this.sprIcon.getWidth(), this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    private int getTopScore() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        int scoresCount = 0;
        if (scores != null) {
            scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            return scoreItem.scoreValue;
        }
        return 0;
    }

    public void keyPressed(int keyCode) {
        if (this.iStatus != 1 || !Keys.isActionPressed(5) && !Keys.isKeyPressed(53) || this._iSelectedCompId == 4) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.iStatus) {
            case 5: {
                this.startAnimation(true, 0);
                break;
            }
            case 8: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.startAnimation(true, 1);
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.startAnimation(true, 9);
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                    return;
                }
                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.controlsTut == 0) {
                    this.startAnimation(true, 5);
                    ++MainCanvas.controlsTut;
                    break;
                }
                if (MainCanvas.controlsTut != 1) break;
                this.startAnimation(true, 5);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                    break;
                }
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.showHint();
                    break;
                }
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.moveLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.moveRight();
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.moveUp();
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    RMSObjects.game.moveDown();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                Game.pressed = true;
                RMSObjects.game.DragOrDrop();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isFKRightCode(keyCode)) {
                    this.startAnimation(true, 1);
                    this._iTextOffsetY = 0;
                    this._bScrollUP = false;
                    this._bScrollDOWN = true;
                    this._iSelectedCompId = 3;
                    break;
                }
                if (keyCode == 50) {
                    this.dragUp();
                    break;
                }
                if (keyCode != 56) break;
                this.dragDown();
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    Level.getLevel(this.actualLevel);
                    MainCanvas.moveCounter = 0;
                    if (this._iGameMode == 4 || this._iGameMode == 5) {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    } else {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    }
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
    }

    private void setGameMenuStatus() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        if (!RMSObjects.rmsConnects[rmsConnectId].isExist()) {
            RMSObjects.rmsConnects[rmsConnectId].create();
        }
        RMSObjects.rmsConnects[rmsConnectId].save();
        this.startAnimation(true, 1);
        this._iSelectedCompId = 2;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this._iSelectedCompId) {
            case 2: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                    this.mainCanvas.getSoundManager().SetSoundOn(false);
                    Settings.musicOn = false;
                    this.mainCanvas.getSoundManager().Stop();
                    break;
                }
                this.mainCanvas.getSoundManager().SetSoundOn(true);
                Settings.musicOn = true;
                this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 2;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 2;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 8);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.startSelectLevel();
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.startAnimation(true, 5);
                RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                if (Settings.musicOn) {
                    this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            this.startSelectLevel();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.iStatus == 0 && this.rectGameArea.contains(x, y)) {
            Game.bhint = false;
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        if (this.iStatus == 3) {
            if (this.rectInstrGameText.contains(x, y)) {
                MainCanvas.lastPointerPressedY = y;
                this.bDragInstructions = true;
                return;
            }
            if (this._rectItems[6].contains(x, y)) {
                this._iSelectedCompId = 6;
                Keys.keyPressed(50);
                return;
            }
            if (this._rectItems[7].contains(x, y)) {
                this._iSelectedCompId = 7;
                Keys.keyPressed(56);
                return;
            }
        }
        block6: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.iStatus) || !this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    continue block6;
                }
                case 4: {
                    continue block6;
                }
                case 8: {
                    continue block6;
                }
                default: {
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int _iStatus) {
        if (_iStatus == 0) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 8) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (_iStatus == 3) {
            if (i == 1) {
                return true;
            }
        } else if (_iStatus == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
            if (i == 8) {
                return true;
            }
        } else if (_iStatus == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 3 ? i == 1 : (_iStatus == 5 ? i == 0 : _iStatus == 4 && i == 0)) {
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.iStatus == 0) {
            if (this.rectGameArea.contains(x, y)) {
                RMSObjects.game.pointerPressed(x, y);
            }
            return;
        }
        if (this.iStatus == 3 && this.bDragInstructions) {
            int iTextShiftY;
            if (!this.rectInstrGameText.contains(x, y)) {
                this.bDragInstructions = false;
            }
            if ((iTextShiftY = MainCanvas.lastPointerPressedY - y) > 0) {
                this.dragDown();
            } else if (iTextShiftY < 0) {
                this.dragUp();
            }
            MainCanvas.lastPointerPressedY = y;
        }
        if (this._iSelectedCompId > -1 && !this._rectItems[this._iSelectedCompId].contains(x, y)) {
            System.out.println("retardace");
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 1: {
                    if (this.iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        break;
                    }
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                    if (this.iStatus != 1) break;
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.iStatus == 0) {
            Game.pressed = true;
        }
        if (this.iStatus == 2 && RMSObjects.game.isLevelDone()) {
            this.keyReleasedResult(-1);
            return;
        }
        if (this.iStatus == 5) {
            this.keyReleased(-1);
            return;
        }
        block14: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.iStatus) || !this._rectItems[i].contains(x, y)) continue;
            switch (this._iSelectedCompId) {
                case 0: {
                    if (this.iStatus != 1) {
                        Keys.keyPressed(-6);
                        continue block14;
                    }
                    Keys.keyPressed(-6);
                    continue block14;
                }
                case 1: {
                    if (this.iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block14;
                    }
                    Keys.keyPressed(-7);
                    continue block14;
                }
                case 4: {
                    if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                        this.mainCanvas.getSoundManager().SetSoundOn(false);
                        this.mainCanvas.getSoundManager().Stop();
                        Settings.musicOn = false;
                    } else {
                        this.mainCanvas.getSoundManager().SetSoundOn(true);
                        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                        Settings.musicOn = true;
                    }
                    this.mainCanvas.repaint();
                    continue block14;
                }
                case 8: {
                    continue block14;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
        if (this.iStatus == 3) {
            if (this.bDragInstructions) {
                this.bDragInstructions = false;
            }
            switch (this._iSelectedCompId) {
                case 6: {
                    if (!Keys.isKeyPressed(50)) break;
                    this.keyReleased(50);
                    Keys.keyReleased(50);
                    break;
                }
                case 7: {
                    if (!Keys.isKeyPressed(56)) break;
                    this.keyReleased(56);
                    Keys.keyReleased(56);
                    break;
                }
            }
        }
        switch (this._iSelectedCompId) {
            case 0: {
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (this.iStatus == 3) {
                    this.startAnimation(true, 1);
                    this._iTextOffsetY = 0;
                    this._bScrollUP = false;
                    this._bScrollDOWN = true;
                    break;
                }
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.iStatus != 1) break;
                this._iSelectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
        this._iSelectedCompId = -1;
    }

    public void textMove() {
        this._bNeedRepaint = false;
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= this.fontSmall.getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstructions.getTextHeight() - this.rectInstrGameText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += this.fontSmall.getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
        if (this._bNeedRepaint) {
            this.mainCanvas.repaint();
        }
    }

    public void dragUp() {
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            return;
        }
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= this.fontSmall.getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            return;
        }
        int maxOffsetY = this._ptInstructions.getTextHeight() - this.rectInstrGameText.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += this.fontSmall.getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    private void paintNewWin(Graphics g) {
        int width = this.sprCup.getWidth();
        int height = this.sprCup.getHeight();
        int yDiff = (Common.rectArea.getCenterY() - (height >> 1) - Common.rectArea.y) / 3;
        int y = Common.rectArea.y + yDiff;
        this.fontBig.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this.rectScreen.getCenterX(), y, 3);
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(9).toCharArray(), this.rectScreen.getCenterX(), y += yDiff, 3);
        if (this.score >= Level._iScoreMin) {
            this.sprCup.setFrame(2);
            if (this.score >= Level._iScoreHig) {
                this.sprCup.setFrame(0);
            } else if (this.score >= Level._iScoreMid) {
                this.sprCup.setFrame(1);
            }
            this.sprCup.setPosition(Common.rectArea.getCenterX() - (width >> 1), Common.rectArea.getCenterY() - (height >> 1));
            this.sprCup.paint(g);
        }
        y = Common.rectArea.getBottom() - (Common.rectArea.getBottom() - (Common.rectArea.getCenterY() + (height >> 1)) >> 1);
        this.fontBig.drawString(g, (Resources.resTexts[0].getHashedString(10) + ": " + this.score).toCharArray(), this.rectScreen.getCenterX(), y, 3);
    }

    private void paintNewLose(Graphics g) {
        this.fontBig.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this.rectScreen.getCenterX(), Common.rectArea.getCenterY() - (Common.rectArea.height >> 2), 3);
        if (noMoves) {
            this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(12).toCharArray(), this.rectScreen.getCenterX(), Common.rectArea.getCenterY() - (Common.rectArea.height >> 2) + this.fontBig.getHeight(), 3);
        }
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(79).toCharArray(), this.rectScreen.getCenterX(), Common.rectArea.getCenterY(), 3);
        this.fontBig.drawString(g, (Resources.resTexts[0].getHashedString(10) + ": " + this.score).toCharArray(), this.rectScreen.getCenterX(), Common.rectArea.getCenterY() + (Common.rectArea.height >> 2), 3);
    }

    private String addWhitespace(String string, int count) {
        if (count == 0) {
            return string;
        }
        int pos = count * 3;
        String first = string.substring(0, string.length() - pos);
        String second = string.substring(string.length() - pos);
        string = first + " " + second;
        return this.addWhitespace(string, --count);
    }

    private void paintTopLeft(Graphics g) {
        int x = this.rectGameBar.x + (this.sprBut.getWidth() >> 2);
        int y = this.rectGameBar.getCenterY();
        if (this._iGameMode == 0) {
            String scoreNumbers = String.valueOf(Level._iMoves - MainCanvas.moveCounter);
            int count = scoreNumbers.length() / 3;
            this.fontSmall.drawString(g, ("m" + this.addWhitespace(scoreNumbers, count)).toCharArray(), x, y, 6);
        } else if (this._iGameMode == 1) {
            this.fontSmall.drawString(g, (Integer.toString((int)Level._lTime - RMSObjects.game.getTimeInSec() < 0 ? 0 : (int)Level._lTime - RMSObjects.game.getTimeInSec()) + "").toCharArray(), x, y, 6);
        } else if (this._iGameMode == 2) {
            String scoreNumbers = String.valueOf(Integer.toString(Level._iEscapeObjCount - Game._iProgressSecondary < 0 ? 0 : Level._iEscapeObjCount - Game._iProgressSecondary));
            int count = scoreNumbers.length() / 3;
            this.fontSmall.drawString(g, ("m" + (Level._iMoves - MainCanvas.moveCounter) + " d" + this.addWhitespace(scoreNumbers, count)).toCharArray(), x, y, 6);
        } else if (this._iGameMode == 3) {
            String scoreNumbers = String.valueOf(Integer.toString(Level._iDownfallObjCount - Game._iProgressSecondary < 0 ? 0 : Level._iDownfallObjCount - Game._iProgressSecondary));
            int count = scoreNumbers.length() / 3;
            this.fontSmall.drawString(g, ("m" + (Level._iMoves - MainCanvas.moveCounter) + " d" + this.addWhitespace(scoreNumbers, count)).toCharArray(), x, y, 6);
        } else if (this._iGameMode == 4) {
            String scoreNumbers = String.valueOf(Integer.toString((int)(Level._lTime - (long)RMSObjects.game.getTimeInSec()) < 0 ? 0 : (int)(Level._lTime - (long)RMSObjects.game.getTimeInSec())));
            this.fontSmall.drawString(g, ("" + scoreNumbers + " d" + Block.count()).toCharArray(), x, y, 6);
        } else if (this._iGameMode == 5) {
            this.fontSmall.drawString(g, ("m" + (Level._iMoves - MainCanvas.moveCounter) + "d" + Block.count()).toCharArray(), x, y, 6);
        } else if (this._iGameMode == 7) {
            String scoreNumbers = String.valueOf(Integer.toString((int)(Level._lTime - (long)RMSObjects.game.getTimeInSec()) < 0 ? 0 : (int)(Level._lTime - (long)RMSObjects.game.getTimeInSec())));
            this.fontSmall.drawString(g, ("m" + (Level._iMoves - MainCanvas.moveCounter) + " " + scoreNumbers).toCharArray(), x, y, 6);
        }
    }

    private void initData() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        if (scores != null) {
            PowV2ScoreItem scoreItem = null;
            if (scores.size() > this.actualLevel) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(this.actualLevel);
                this.highScore = scoreItem.highScore;
            } else {
                this.highScore = 0;
            }
        }
    }

    private void initGameBar() {
        int width = (this.rectScreen.width - this.imgGameBorder.getHeight()) / this.sprBut.getWidth() * this.sprBut.getWidth();
        int height = this.sprWheelsMini.getHeight();
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int y = height >> 3;
        if (this._HEIGHT <= 320) {
            y = 0;
        }
        this.rectGameBar = new Rectangle(x, y, width, height);
    }
}

