/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSplash;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenLanguage
implements IScreen {
    private MainCanvas _mainCanvas;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private boolean _bChangeScreen = false;
    private static String[] _sLangCodes = new String[]{"en", "de", "fr", "es", "it", "pt"};
    private Rectangle[] rectFlags = new Rectangle[6];
    private AnimationComponent[] _animationComponents = new AnimationComponent[6];
    private Sprite _sprLanguage;

    public ScreenLanguage(MainCanvas mC) {
        this._mainCanvas = mC;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this._iSelectedCompId = 0;
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadSprites(new int[]{23, 24});
    }

    private void freeResources() {
        Resources.freeSprites(new int[]{23, 24});
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initImages() {
    }

    private void initSprites() {
        this._sprLanguage = Resources.resSprs[24];
    }

    private void freeGraphics() {
        this._sprLanguage = null;
    }

    private void showAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this.rectFlags[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(4);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this.rectFlags[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[1].startShowAnimation(5);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this.rectFlags[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this._mainCanvas, this.rectFlags[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this._mainCanvas, this.rectFlags[4], this._WIDTH, this._HEIGHT);
        this._animationComponents[4].startShowAnimation(6);
        this._animationComponents[5] = new AnimationComponent(this._mainCanvas, this.rectFlags[5], this._WIDTH, this._HEIGHT);
        this._animationComponents[5].startShowAnimation(7);
    }

    private void hideAnimationComponents() {
        this._animationComponents[0].startHideAnimation(4);
        this._animationComponents[1].startHideAnimation(5);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(6);
        this._animationComponents[5].startHideAnimation(7);
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        int btnWidth = this._sprLanguage.getWidth();
        int btnHeight = this._sprLanguage.getHeight();
        int spaceX = (this._WIDTH - btnWidth * 2) / 3;
        int spaceY = (this._HEIGHT - btnHeight * 3) / 4;
        for (int i = 0; i < 6; ++i) {
            this.rectFlags[i] = new Rectangle(spaceX + i % 2 * (btnWidth + spaceX), spaceY + i / 2 * (btnHeight + spaceY), btnWidth, btnHeight);
        }
        this.showAnimationComponents();
    }

    public void update(long lastRunLenght) {
        this.animationComponentsUpdate();
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (this._bChangeScreen && !_return) {
            this.changeScreen();
        }
    }

    private void hideLanguage() {
        if (this._iSelectedCompId == 5 && this._WIDTH < 320) {
            MainCanvas._bFranceLang = true;
        }
        this._bChangeScreen = true;
        this.hideAnimationComponents();
    }

    private void changeScreen() {
        Resources.initLangDirs(_sLangCodes[this._iSelectedCompId]);
        this._mainCanvas.changeLastActiveScreen(new ScreenSplash(this._mainCanvas));
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintLanguage(g);
    }

    private void paintLanguage(Graphics g) {
        int _iDx = 1;
        for (int index = 0; index < this.rectFlags.length; ++index) {
            this._sprLanguage.setFrame(_iDx);
            this._sprLanguage.setPosition(this.rectFlags[index].x, this.rectFlags[index].y);
            if (!this._mainCanvas.isTouchActivated() && this._iSelectedCompId == index) {
                this._sprLanguage.setFrame(index * 2);
            }
            this._sprLanguage.paint(g);
            _iDx += 2;
        }
    }

    private void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void keyPressed(int keyCode) {
        this._mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this._iSelectedCompId % 2 == 1) {
                    --this._iSelectedCompId;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this._iSelectedCompId % 2 == 0) {
                    ++this._iSelectedCompId;
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this._iSelectedCompId / 2 > 0) {
                    this._iSelectedCompId -= 2;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this._iSelectedCompId != 5 && this._iSelectedCompId != 4 && this._iSelectedCompId / 2 < 3) {
                    this._iSelectedCompId += 2;
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.hideLanguage();
            } else if (Keys.isActionGeneratedByKey(-6, keyCode)) {
                Resources.initLangDirs(_sLangCodes[this._iSelectedCompId]);
            } else if (Keys.isActionGeneratedByKey(-7, keyCode)) {
                Resources.initLangDirs(_sLangCodes[this._iSelectedCompId]);
            }
        }
        this._mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectFlags.length; ++i) {
            if (!this.rectFlags[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                default: 
            }
            Keys.keyPressed(53);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectFlags[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                default: 
            }
            Keys.keyReleased(53);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            default: 
        }
        if (Keys.isKeyPressed(53)) {
            this.keyReleased(53);
            Keys.keyReleased(53);
        }
    }
}

