/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenInstructions
implements IScreen {
    private MainCanvas _mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int TOTAL_COMP_IDS = 3;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iTextOffsetY;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iCycle = 10;
    private int _iInteruption = 0;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[6];
    private boolean _bChangeSequence = false;
    private boolean _bNeedRepaint;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    private Rectangle[] _rectItems = new Rectangle[3];
    private Rectangle _rectText;
    private Rectangle rectDialogInstr;
    private Rectangle rectFK;
    private Rectangle rectScreen;
    private Rectangle _rectTop;
    private Image imgGameBorder;
    private Image imgBlueTile;
    private Image imgLight;
    private Sprite sprArrow;
    private Sprite sprIcon;
    private Sprite sprWheelsMini;
    private Sprite sprMenuIcons;
    private Sprite sprBut;
    private Sprite sprWheels;
    private PreparedText _ptTitle;
    private PreparedText _ptInstructions;
    private GFont fontBig;
    private AnimationComponent[] _animationComponents = new AnimationComponent[5];
    int a;
    boolean bDragInstructions = false;

    public ScreenInstructions(MainCanvas mC) {
        this._mainCanvas = mC;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        Common.initScreen(this.rectScreen, this.sprBut, this.sprWheels);
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        this._iTextOffsetY = 0;
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 33, 32, 34});
        Resources.loadSprites(new int[]{54, 64, 62, 65, 61, 63});
        Resources.loadGFont(0);
        Resources.loadGFont(1);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 33, 32, 34});
        Resources.freeSprites(new int[]{54, 64, 62, 65, 61, 63});
        Resources.freeGFont(0);
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.rectScreen = new Rectangle(0, 0, this._WIDTH, this._HEIGHT);
    }

    private void initImages() {
        this.imgGameBorder = Resources.resImgs[33];
        this.imgBlueTile = Resources.resImgs[32];
        this.imgLight = Resources.resImgs[34];
    }

    private void initSprites() {
        this.sprArrow = Resources.resSprs[54];
        this.sprIcon = Resources.resSprs[64];
        this.sprWheelsMini = Resources.resSprs[62];
        this.sprMenuIcons = Resources.resSprs[65];
        this.sprBut = Resources.resSprs[61];
        this.sprWheels = Resources.resSprs[63];
    }

    private void initFonts() {
        this.fontBig = Resources.resGFonts[1];
        this._ptTitle = new PreparedText(this.fontBig);
        this._ptInstructions = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
        this._animationSequence[3] = 3;
        this._animationSequence[4] = 4;
        this._animationSequence[5] = 5;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this._rectText, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this._rectItems[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this._mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this._mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(3);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(3);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(3);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(1);
    }

    private void prepareTxt() {
        String _sTmpControls = Resources.resTexts[0].getHashedString(16);
        this._ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + _sTmpControls, this._rectText.width);
        this._ptInstructions.setLineHeightCorrection(-2);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(22), this._rectTop.width);
    }

    private void freeGraphics() {
        this._ptTitle = null;
        this._ptInstructions = null;
    }

    public void beforeInteruption() {
        this._mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        this._rectTop = new Rectangle(this._iOffsetXDefault, this.sprIcon.getHeight() - this.sprIcon.getHeight(), this._WIDTH - (this._iOffsetXDefault << 1), this.sprIcon.getHeight());
        this.rectDialogInstr = Common.rectArea;
        int heightArrow = this.sprArrow.getHeight();
        int widthArrow = this.sprArrow.getWidth();
        this._rectText = new Rectangle(this.rectDialogInstr.x + (heightArrow >> 1), this.rectDialogInstr.y + heightArrow + (heightArrow >> 2), this.rectDialogInstr.width - heightArrow, this.rectDialogInstr.height - (heightArrow + (heightArrow >> 2) << 1));
        this._rectItems[1] = new Rectangle(this.rectScreen.getCenterX() - (widthArrow >> 1), this.rectDialogInstr.y + (this.imgGameBorder.getHeight() >> 1), widthArrow, heightArrow);
        this._rectItems[2] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectDialogInstr.getBottom() - heightArrow - (this.imgGameBorder.getHeight() >> 1), widthArrow, heightArrow);
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this.sprBut.getWidth() << 1), MainCanvas.HEIGHT - (this.sprBut.getHeight() << 1), this.sprBut.getWidth() << 1, this.sprBut.getHeight() << 1);
        int offset = this.sprBut.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.sprBut.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.sprBut.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.sprBut.getWidth() >> 1), yCenterFK - (this.sprBut.getHeight() >> 1), this.sprBut.getWidth(), this.sprBut.getHeight());
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        if (Keys.isKeyPressed(-7)) {
            this._bScrollDOWN = false;
            this._bScrollUP = false;
            this._mainCanvas.repaint();
        }
        if (this._bNeedRepaint) {
            this._mainCanvas.repaint();
        }
        this.animationController();
        this.animationComponentsUpdate();
        Common.updateWheels(lastRunLenght, this._mainCanvas);
    }

    private void updateSoundInterupt() {
        if (MainCanvas.interuption_nokia == 0) {
            if (this._iCycle > 0) {
                --this._iCycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                if (!this._mainCanvas.getSoundManager().IsPlaying(Sounds.SOUND_MENU)) {
                    this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                }
                this._iCycle = 10;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this._mainCanvas.changeLastActiveScreen(new ScreenMenu(this._mainCanvas, 1));
    }

    private void textMove() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= this.fontBig.getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += this.fontBig.getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintBody(Graphics g) {
        Common.paintTopPanel(g, this.imgLight, this.sprBut, this.sprWheelsMini, this.sprMenuIcons, this.fontBig, Resources.resTexts[0].getHashedString(22), Common.MENU_IC_INSTR);
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintInstructions(g);
        this.paintArrows(g);
    }

    private void paintInstructions(Graphics g) {
        this._ptInstructions.drawText(g, this._rectText, this._iTextOffsetY, 17);
    }

    private void paintFK(Graphics g) {
        this.sprBut.setFrame(0);
        this.sprBut.setPosition(this.rectScreen.width - this.sprBut.getWidth(), this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprIcon.setFrame(Common.IC_YES);
        this.sprIcon.setPosition(this.rectScreen.width - (this.imgGameBorder.getHeight() >> 1) - this.sprIcon.getWidth(), this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    private void paintArrows(Graphics g) {
        if (this._bChangeSequence || this._animationComponents[2]._iDefaultY - this._animationComponents[2]._defaultRectangle.y != 0) {
            return;
        }
        if (this._ptInstructions.getTextHeight() >= this._rectText.height) {
            if (this._bScrollUP) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setTransform(3);
                this.sprArrow.setPosition(this._rectItems[1].x, this._rectItems[1].y);
                this.sprArrow.paint(g);
            }
            this.sprArrow.setTransform(0);
            if (this._bScrollDOWN) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setPosition(this._rectItems[2].x, this._rectItems[2].y);
                this.sprArrow.paint(g);
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
        if (keyCode == 50 || keyCode == 56) {
            // empty if block
        }
        this._mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55 && Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
            this._mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this._rectText.contains(x, y)) {
            MainCanvas.lastPointerPressedY = y;
            this.bDragInstructions = true;
        }
        block5: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 1: {
                    Keys.keyPressed(50);
                    continue block5;
                }
                case 2: {
                    Keys.keyPressed(56);
                    continue block5;
                }
                default: {
                    this._mainCanvas.keyPressed(53);
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
        if (this.bDragInstructions) {
            int iTextShiftY;
            if (!this._rectText.contains(x, y)) {
                this.bDragInstructions = false;
            }
            if ((iTextShiftY = MainCanvas.lastPointerPressedY - y) > 0) {
                this.dragDown();
            } else if (iTextShiftY < 0) {
                this.dragUp();
            }
            MainCanvas.lastPointerPressedY = y;
        }
    }

    public void dragUp() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= this.fontBig.getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
    }

    public void dragDown() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += this.fontBig.getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
    }

    public void pointerReleased(int x, int y) {
        if (this.bDragInstructions) {
            this.bDragInstructions = false;
        }
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(50)) break;
                this.keyReleased(50);
                Keys.keyReleased(50);
                break;
            }
            case 2: {
                if (!Keys.isKeyPressed(56)) break;
                this.keyReleased(56);
                Keys.keyReleased(56);
                break;
            }
            default: {
                if (Keys.isKeyPressed(50)) {
                    this.keyReleased(50);
                    Keys.keyReleased(50);
                }
                if (Keys.isKeyPressed(56)) {
                    this.keyReleased(56);
                    Keys.keyReleased(56);
                }
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

