/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private MainCanvas _mainCanvas;
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_MENU = 3;
    private static final int MODE_TIME = 1500;
    private static final int _COMP_ID_YES = 0;
    private static final int _COMP_ID_NO = 1;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iMode;
    private int _iKcode;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode;
    private int _iInteruption = 0;
    private int[][] _animationSequence = new int[3][3];
    private long _iModeDelay;
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle rectScreen;
    private Rectangle rectNo;
    private Rectangle rectYes;
    private Image imgGameBorder;
    private Image imgLogo;
    private Image imgSplash;
    private Image imgSound;
    private Image imgBlueTile;
    private Image imgLight;
    private Sprite sprBut;
    private Sprite sprWheels;
    private Sprite sprWheelsMini;
    private Sprite sprIcon;
    private Sprite sprMenuIcons;
    private PreparedText _ptTitle;
    private GFont fontBig;
    private AnimationComponent[] _animationComponents = new AnimationComponent[3];

    public ScreenSplash(MainCanvas mC) {
        this._mainCanvas = mC;
        this._iMode = 0;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this._iModeDelay = 1500L;
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.initBottomButtons();
        Common.initScreen(this.rectScreen, this.sprBut, this.sprWheels);
        this.prepareTxt();
        this.calculatePosition();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, 0);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 3, 1, 32, 31, 33, 34});
        Resources.loadSprites(new int[]{62, 61, 63, 64, 65});
        Resources.loadGFont(1);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{3, 32, 31, 1, 31, 33, 34});
        Resources.freeSprites(new int[]{62, 61, 63, 64, 65});
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void initSprites() {
        this.sprBut = Resources.resSprs[61];
        this.sprWheels = Resources.resSprs[63];
        this.sprWheelsMini = Resources.resSprs[62];
        this.sprIcon = Resources.resSprs[64];
        this.sprMenuIcons = Resources.resSprs[65];
    }

    private void initImages() {
        this.imgSplash = Resources.resImgs[1];
        this.imgLogo = Resources.resImgs[3];
        this.imgSound = Resources.resImgs[31];
        this.imgBlueTile = Resources.resImgs[32];
        this.imgGameBorder = Resources.resImgs[33];
        this.imgLight = Resources.resImgs[34];
    }

    private void initFonts() {
        this.fontBig = Resources.resGFonts[1];
        this._ptTitle = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[2][0] = 0;
        this._animationSequence[2][1] = 2;
        this._animationSequence[2][2] = 1;
    }

    private void initAnimationComponents() {
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this.rectNo, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this.rectYes, this._WIDTH, this._HEIGHT);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
    }

    private void prepareTxt() {
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(5), this._mainCanvas.getWidth());
    }

    private void freeGraphics() {
        this.imgSplash = null;
        this.imgLogo = null;
        this._ptTitle = null;
    }

    public void calculatePosition() {
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - (this.sprBut.getHeight() << 1), this.sprBut.getWidth() << 1, this.sprBut.getHeight() << 1);
        this._rectItems[1] = new Rectangle(this._WIDTH - (this.sprBut.getWidth() << 1), MainCanvas.HEIGHT - (this.sprBut.getHeight() << 1), this.sprBut.getWidth() << 1, this.sprBut.getHeight() << 1);
    }

    public void beforeInteruption() {
        if (this._iMode == 0) {
            this._mainCanvas.getSoundManager().Stop();
        }
        this._mainCanvas.getSoundManager().Stop();
        this._iInteruption = 1;
    }

    public void afterInteruption() {
        if (this._iInteruption == 0 && this._mainCanvas.getSoundManager().IsSoundOn() && !this._mainCanvas.getSoundManager().IsPlaying(Sounds.SOUND_MENU)) {
            this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        if (this._iMode == 0) {
            this._mainCanvas.getSoundManager().Stop();
        }
    }

    public void update(long lastRunLenght) {
        switch (this._iMode) {
            case 1: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 1500L;
                this.nextMode();
                break;
            }
            case 2: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 1500L;
                this.nextMode();
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(this._iKcode)) {
                    MainCanvas.music = false;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    break;
                }
                if (!Keys.isFKLeftCode(this._iKcode)) break;
                MainCanvas.music = true;
                Settings.musicOn = true;
                this._mainCanvas.getSoundManager().SetSoundOn(true);
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
        Common.updateWheels(lastRunLenght, this._mainCanvas);
    }

    private void nextMode() {
        switch (this._iMode) {
            case 0: {
                this.startAnimation(true, 1);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
                break;
            }
            case 1: {
                this.startAnimation(true, 2);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
                break;
            }
            case 2: {
                this.startAnimation(true, 3);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this._iMode].length; ++i) {
            if (this._animationSequence[this._iMode][i] == -1 || this._animationComponents[this._animationSequence[this._iMode][i]] == null || this._animationComponents[this._animationSequence[this._iMode][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this._iMode][i]].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 3) {
                    this.startMenuScreen();
                }
                this._iSequence = this._iSequenceShow;
                this._iMode = this._iNextMode;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this._mainCanvas, 0);
        if (this._mainCanvas.getSoundManager().IsSoundOn()) {
            this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        this._mainCanvas.changeLastActiveScreen(sg);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this._iMode) {
            case 0: {
                this.paintMusic(g);
                break;
            }
            case 1: {
                this.paintCorpLogo(g);
                break;
            }
            case 2: {
                this.paintSplash(g);
            }
        }
    }

    private void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintMusic(Graphics g) {
        this.paintMusicBody(g);
        this.paintMusicFk(g);
    }

    private void paintCorpLogo(Graphics g) {
        g.drawImage(this.imgLogo, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
    }

    private void paintSplash(Graphics g) {
        g.drawImage(this.imgSplash, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
    }

    private void paintMusicBody(Graphics g) {
        Common.paintTopPanel(g, this.imgLight, this.sprBut, this.sprWheelsMini, this.sprMenuIcons, this.fontBig, Resources.resTexts[0].getHashedString(28), Common.MENU_IC_MUSIC_ON);
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.paintMid(g);
    }

    private void paintMid(Graphics g) {
        g.drawImage(this.imgSound, Common.rectArea.getCenterX(), Common.rectArea.getCenterY(), 3);
    }

    private void paintMusicFk(Graphics g) {
        this.sprBut.setFrame(2);
        this.sprBut.setPosition(0, this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprBut.setFrame(0);
        this.sprBut.setPosition(this.rectScreen.width - this.sprBut.getWidth(), this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprIcon.setFrame(Common.IC_YES);
        this.sprIcon.setPosition(this.imgGameBorder.getHeight() >> 2, this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
        this.sprIcon.setFrame(Common.IC_NO);
        this.sprIcon.setPosition(this.rectScreen.width - (this.imgGameBorder.getHeight() >> 2) - this.sprIcon.getWidth(), this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this._iMode) {
            case 0: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this._iKcode = keyCode;
                    Settings.musicOn = true;
                    this._mainCanvas.getSoundManager().SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this._iKcode = keyCode;
                Settings.musicOn = false;
                this._mainCanvas.getSoundManager().SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 1: 
            case 2: {
                if (this._iModeDelay >= 1500L || !Keys.isActionGeneratedByKey(5, keyCode) || this._iModeDelay <= 100L) break;
                this._iModeDelay = 1500L;
                this.nextMode();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == 0) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != 1) continue;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                this._iModeDelay = 0L;
                if (this._iModeDelay >= 1500L) break;
                Keys.keyPressed(53);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == 0) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != 1) continue;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                if (this._iModeDelay >= 1500L || !Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }

    private void initBottomButtons() {
        int width = this.sprBut.getWidth();
        int height = this.sprBut.getHeight();
        int x = width >> 2;
        int y = this.rectScreen.height - (height + (height >> 2));
        this.rectYes = new Rectangle(x, y, width, height);
        x = this.rectScreen.width - (width + (width >> 2));
        this.rectNo = new Rectangle(x, y, width, height);
    }
}

