/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenRealyQuit
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_YES = 0;
    private static final int COMP_ID_NO = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int interuption = 0;
    private int _iSelectedCompId;
    private int _iCycle = 10;
    private int _iFinalHeight;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private Sprite sprBut;
    private Sprite sprWheels;
    private int[] _animationSequence = new int[4];
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle _rectDialog;
    private Rectangle _rectTop;
    private Rectangle rectWindow;
    private Rectangle rectYes;
    private Rectangle rectNo;
    private Rectangle rectScreen;
    private Image imgGameBorder;
    private Image imgLight;
    private Image imgBlueTile;
    private Sprite sprMenuIcons;
    private Sprite sprWheelsMini;
    private Sprite sprIcon;
    private PreparedText preparedTextQuit;
    private PreparedText _ptTitle;
    private GFont fontBig;
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];

    public ScreenRealyQuit(MainCanvas mC, int selectedItem) {
        this.mainCanvas = mC;
        this.initDimensions();
    }

    public void beforeShow() {
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.loadResources();
        this.initSprites();
        this.initImages();
        this.initFonts();
        this.initBottomButtons();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        Common.initScreen(this.rectScreen, this.sprBut, this.sprWheels);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{33, 32, 34});
        Resources.loadSprites(new int[]{64, 62, 65, 61, 63});
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{33, 32, 34});
        Resources.freeSprites(new int[]{64, 62, 65, 61, 63});
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initSprites() {
        this.sprIcon = Resources.resSprs[64];
        this.sprWheelsMini = Resources.resSprs[62];
        this.sprMenuIcons = Resources.resSprs[65];
        this.sprBut = Resources.resSprs[61];
        this.sprWheels = Resources.resSprs[63];
    }

    private void initImages() {
        this.imgGameBorder = Resources.resImgs[33];
        this.imgBlueTile = Resources.resImgs[32];
        this.imgLight = Resources.resImgs[34];
    }

    private void initFonts() {
        Resources.loadGFont(1);
        this.fontBig = Resources.resGFonts[1];
        this.preparedTextQuit = new PreparedText(this.fontBig);
        this._ptTitle = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
        this._animationSequence[3] = 3;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectWindow, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectNo, this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectYes, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(0);
    }

    private void prepareTxt() {
        this.preparedTextQuit.prepareText(Resources.resTexts[0].getHashedString(2), this._rectDialog.width);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(2), this._rectDialog.width);
    }

    private void freeGraphics() {
    }

    private void calculatePositions() {
        this._rectTop = new Rectangle(this._iOffsetXDefault, this.sprIcon.getHeight() - this.sprIcon.getHeight(), this._WIDTH - (this._iOffsetXDefault << 1), this.sprIcon.getHeight());
        this.rectWindow = Common.rectArea;
        int _windowWidth = this._WIDTH >> 1;
        int _offsetX = _windowWidth % this.rectWindow.width > 0 ? _windowWidth % this.rectWindow.width : this.rectWindow.width;
        _offsetX >>= 1;
        System.out.println(1);
        int _offsetTopY = (this.sprIcon.getHeight() - this.sprIcon.getHeight() << 1) + this.sprIcon.getHeight();
        int _offsetBottomY = this.sprIcon.getHeight() + (this.sprIcon.getHeight() - this.sprIcon.getHeight());
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        this._iFinalHeight = _panelHeight % this.rectWindow.width == 0 ? _panelHeight : _panelHeight - _panelHeight % this.rectWindow.width;
        System.out.println(1);
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, this._WIDTH - (_offsetX << 1), this._iFinalHeight);
        System.out.println(1);
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - (this.sprBut.getHeight() << 1), this.sprBut.getWidth() << 1, this.sprBut.getHeight() << 1);
        System.out.println(1);
        this._rectItems[1] = new Rectangle(MainCanvas.WIDTH - (this.sprBut.getWidth() << 1), MainCanvas.HEIGHT - (this.sprBut.getHeight() << 1), this.sprBut.getWidth() << 1, this.sprBut.getHeight() << 1);
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && this.mainCanvas.getSoundManager().IsSoundOn() && !this.mainCanvas.getSoundManager().IsPlaying(Sounds.SOUND_MENU)) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void update(long lastRunLenght) {
        if (MainCanvas.interuption_nokia == 0) {
            if (this._iCycle > 0) {
                --this._iCycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                if (!this.mainCanvas.getSoundManager().IsPlaying(Sounds.SOUND_MENU)) {
                    this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                }
                this._iCycle = 10;
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
        Common.updateWheels(lastRunLenght, this.mainCanvas);
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintBody(Graphics g) {
        Common.paintTopPanel(g, this.imgLight, this.sprBut, this.sprWheelsMini, this.sprMenuIcons, this.fontBig, Resources.resTexts[0].getHashedString(80), Common.MENU_IC_ABOUT);
        Common.paintBottomAnimWheel(g, this.sprWheels, this.rectScreen);
        Common.paintMidArea(g, this.imgGameBorder, this.rectScreen, this.imgBlueTile);
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(2).toCharArray(), Common.rectArea.getCenterX(), Common.rectArea.getCenterY(), 3);
    }

    private void paintFK(Graphics g) {
        this.sprBut.setFrame(2);
        this.sprBut.setPosition(0, this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprBut.setFrame(0);
        this.sprBut.setPosition(this.rectScreen.width - this.sprBut.getWidth(), this.rectScreen.height - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprIcon.setFrame(Common.IC_YES);
        this.sprIcon.setPosition(this.imgGameBorder.getHeight() >> 1, this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
        this.sprIcon.setFrame(Common.IC_NO);
        this.sprIcon.setPosition(this.rectScreen.width - (this.imgGameBorder.getHeight() >> 1) - this.sprIcon.getWidth(), this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKLeftCode(keyCode)) {
            X.quitApp();
        } else if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(-6);
                    break;
                }
                case 1: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 1: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
            this.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }

    private void initBottomButtons() {
        int width = this.sprBut.getWidth();
        int height = this.sprBut.getHeight();
        int x = width >> 2;
        int y = this.rectScreen.height - (height + (height >> 2));
        this.rectYes = new Rectangle(x, y, width, height);
        x = this.rectScreen.width - (width + (width >> 2));
        this.rectNo = new Rectangle(x, y, width, height);
    }
}

