/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenAbout;
import sk.inlogic.screen.ScreenInstructions;
import sk.inlogic.screen.ScreenRealyQuit;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas _mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_ABOUT = 2;
    public static final int COMP_ID_SOUND = 3;
    public static final int COMP_ID_SETTINGS = 4;
    public static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_NONE = 6;
    private static final int TOTAL_COMP_IDS = 7;
    private int[] _arrImages;
    private int[] _arrSprites;
    private int[] _arrFonts;
    private final int _iNextScreenPack;
    private final int _iNextScreenInst;
    private final int _iNextScreenAbou;
    private final int _iNextScreenQuit;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iSelectorCompId;
    private int _interuption = 0;
    private int _iCycle = 10;
    private int _iMusicControler = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int sel;
    private int selectedButton = -1;
    private int force;
    private boolean _bCheck = false;
    private boolean _bChangeSequence = false;
    private boolean _bActiveButton = true;
    private Rectangle[] rectButtons = new Rectangle[7];
    private Rectangle rectGameName;
    private Rectangle rectScreen;
    private Rectangle rectFK;
    private AnimationComponent[] _animationComponents = new AnimationComponent[7];
    private Image imgGameName;
    private Image imgGameBorder;
    private Sprite sprBut;
    private Sprite sprWheelsMini;
    private Sprite sprMenuIcons;
    private Sprite sprIcon;
    private GFont fontBig;
    private PreparedText _ptItemName;

    public ScreenMenu(MainCanvas mC, int selectedItem) {
        this._iNextScreenPack = 0;
        this._iNextScreenInst = 1;
        this._iNextScreenAbou = 2;
        this._iNextScreenQuit = 3;
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this._mainCanvas = mC;
        this._iSelectedCompId = selectedItem;
        this._iSelectorCompId = selectedItem;
        this.initDimensions();
    }

    public void beforeShow() {
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.initGameName();
        this.calculatePositions();
        this.prepareTxt();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void prepareResources() {
        this._arrImages = new int[]{4, 33};
        this._arrSprites = new int[]{61, 62, 65, 64};
        this._arrFonts = new int[]{0, 1};
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.freeSprites(this._arrSprites);
        Resources.freeGFonts(this._arrFonts);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void initImages() {
        this.imgGameName = Resources.resImgs[4];
        this.imgGameBorder = Resources.resImgs[33];
    }

    private void initSprites() {
        this.sprBut = Resources.resSprs[61];
        this.sprWheelsMini = Resources.resSprs[62];
        this.sprMenuIcons = Resources.resSprs[65];
        this.sprIcon = Resources.resSprs[64];
    }

    private void initFonts() {
        this._ptItemName = new PreparedText(Resources.resGFonts[0]);
        this.fontBig = Resources.resGFonts[1];
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this.rectGameName, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this.rectButtons[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this.rectButtons[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this._mainCanvas, this.rectButtons[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this._mainCanvas, this.rectButtons[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this._mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(2);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(2);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(2);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(1);
    }

    private void prepareTxt() {
        this._ptItemName.prepareText("PLAY", this.rectButtons[0].width);
    }

    private void freeGraphics() {
        this.imgGameName = null;
        this._ptItemName = null;
    }

    public void beforeInteruption() {
        this._bCheck = this._mainCanvas.getSoundManager().IsSoundOn();
        this._mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        this._iMusicControler = 0;
    }

    private void calculatePositions() {
        int yDiff = (this.rectScreen.height - this.rectGameName.getBottom() - (this.sprWheelsMini.getHeight() << 2)) / 5;
        int y = this.rectGameName.getBottom() + (yDiff << 1);
        int width = (this.rectScreen.width - this.imgGameBorder.getHeight()) / this.sprBut.getWidth() * this.sprBut.getWidth();
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int index = 0;
        while (index < 4) {
            this.rectButtons[index] = new Rectangle(x, y, width, this.sprWheelsMini.getHeight() - (this.sprWheelsMini.getHeight() >> 2));
            ++index;
            y += this.sprWheelsMini.getHeight() + (yDiff >> 2);
        }
        this.rectButtons[5] = new Rectangle(this._WIDTH - (this.sprBut.getWidth() << 1), this._HEIGHT - (this.sprBut.getHeight() << 1), this.sprBut.getWidth() << 1, this.sprBut.getHeight() << 1);
        int offset = this.sprBut.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.sprBut.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.sprBut.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.sprBut.getWidth() >> 1), yCenterFK - (this.sprBut.getHeight() >> 1), this.sprBut.getWidth(), this.sprBut.getHeight());
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        this.animationController();
        this.animationComponentsUpdate();
        Common.updateWheels(lastRunLenght, this._mainCanvas);
    }

    private void updateSoundInterupt() {
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _iNextScreen) {
        switch (_iNextScreen) {
            case 0: {
                this._mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this._mainCanvas, 0));
                break;
            }
            case 1: {
                this._mainCanvas.changeLastActiveScreen(new ScreenInstructions(this._mainCanvas));
                break;
            }
            case 2: {
                this._mainCanvas.changeLastActiveScreen(new ScreenAbout(this._mainCanvas));
                break;
            }
            case 3: {
                this._mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this._mainCanvas, this._iSelectorCompId));
            }
        }
        this._mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintDialog(g);
        this.paintGameName(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintGameName(Graphics g) {
        g.drawImage(this.imgGameName, this.rectGameName.getCenterX(), this.rectGameName.getCenterY(), 3);
    }

    private void paintDialog(Graphics g) {
        for (int index = 0; index < 4; ++index) {
            Common.paintButton(g, this.sprBut, this.rectButtons[index]);
        }
        if (this._iSelectorCompId == 0) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, Common.MENU_IC_PLAY, this.rectButtons[0], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, Common.MENU_IC_PLAY, this.rectButtons[0], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(21).toCharArray(), this.rectButtons[0].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this.rectButtons[0].getCenterY(), 6);
        if (this._iSelectorCompId == 1) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, Common.MENU_IC_INSTR, this.rectButtons[1], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, Common.MENU_IC_INSTR, this.rectButtons[1], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(22).toCharArray(), this.rectButtons[1].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this.rectButtons[1].getCenterY(), 6);
        if (this._iSelectorCompId == 2) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, Common.MENU_IC_ABOUT, this.rectButtons[2], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, Common.MENU_IC_ABOUT, this.rectButtons[2], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, Resources.resTexts[0].getHashedString(23).toCharArray(), this.rectButtons[2].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this.rectButtons[2].getCenterY(), 6);
        int frame = Common.MENU_IC_MUSIC_OFF;
        String text = "";
        if (Settings.musicOn) {
            frame = Common.MENU_IC_MUSIC_ON;
            text = text + Resources.resTexts[0].getHashedString(26);
        } else {
            text = text + Resources.resTexts[0].getHashedString(27);
        }
        if (this._iSelectorCompId == 3) {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, -1, frame, this.rectButtons[3], this.imgGameBorder.getHeight() >> 1, false);
        } else {
            Common.paintMiniWheel(g, this.sprWheelsMini, this.sprMenuIcons, 0, frame, this.rectButtons[3], this.imgGameBorder.getHeight() >> 1, false);
        }
        this.fontBig.drawString(g, text.toCharArray(), this.rectButtons[3].x + (this.sprWheelsMini.getWidth() >> 2) + this.sprWheelsMini.getWidth(), this.rectButtons[3].getCenterY(), 6);
    }

    private void paintFK(Graphics g) {
        this.sprBut.setFrame(0);
        this.sprBut.setPosition(this.rectScreen.getRight() - this.sprBut.getWidth(), this.rectScreen.getBottom() - this.sprBut.getHeight());
        this.sprBut.paint(g);
        this.sprIcon.setFrame(Common.IC_POWER);
        this.sprIcon.setPosition(this.rectScreen.getRight() - this.sprIcon.getWidth(), this.rectScreen.getBottom() - (this.sprBut.getHeight() >> 1) - (this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void keyPressed(int keyCode) {
        if ((Keys.isActionPressed(5) || Keys.isKeyPressed(53)) && this._iSelectedCompId == 3) {
            this.selectedButton = 3;
        }
    }

    public void keyReleased(int keyCode) {
        if ((Keys.isActionPressed(5) || Keys.isKeyPressed(53)) && this.selectedButton == 3) {
            this.selectedButton = -1;
        }
        if (this._bActiveButton) {
            if (Keys.isFKLeftCode(keyCode)) {
                switch (this._iSelectedCompId) {
                    case 0: {
                        this.startAnimation(true, 0);
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 1);
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 2);
                        break;
                    }
                    case 3: {
                        if (this._mainCanvas.getSoundManager().IsSoundOn()) {
                            this._mainCanvas.getSoundManager().SetSoundOn(false);
                            Settings.musicOn = false;
                            this._mainCanvas.getSoundManager().Stop();
                            break;
                        }
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        Settings.musicOn = true;
                        this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                        break;
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.selectedButton = 5;
                this.startAnimation(true, 3);
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this._iSelectedCompId) {
                        case 0: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.startAnimation(true, 0);
                            break;
                        }
                        case 1: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.selectedButton = 1;
                            this.startAnimation(true, 1);
                            break;
                        }
                        case 2: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.selectedButton = 2;
                            this.startAnimation(true, 2);
                            break;
                        }
                        case 3: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            if (this._mainCanvas.getSoundManager().IsSoundOn()) {
                                this._mainCanvas.getSoundManager().SetSoundOn(false);
                                this._mainCanvas.getSoundManager().Stop();
                                Settings.musicOn = false;
                                break;
                            }
                            this._mainCanvas.getSoundManager().SetSoundOn(true);
                            this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                            Settings.musicOn = true;
                        }
                    }
                }
                this._iSelectorCompId = this._iSelectedCompId;
                this.force = this._iSelectedCompId;
            }
            this._mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectButtons.length; ++i) {
            if (i == 6) {
                this._iSelectorCompId = this._iSelectedCompId = 6;
                this._mainCanvas.repaint();
                break;
            }
            if (i == 6 || this.rectButtons[i] == null || !this.rectButtons[i].contains(x, y)) continue;
            this.selectedButton = i;
            this.sel = i <= 4 ? i : this.sel;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 4: {
                    break;
                }
                case 5: {
                    Keys.keyPressed(-22);
                    break;
                }
                default: {
                    this._iSelectorCompId = i;
                    Keys.keyPressed(53);
                    this._mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._iSelectedCompId != 6) {
            if (!this.rectButtons[this._iSelectedCompId].contains(x, y)) {
                switch (this._iSelectedCompId) {
                    case 4: {
                        break;
                    }
                    case 5: {
                        Keys.keyReleased(-22);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this._iSelectorCompId = this._iSelectedCompId = 6;
            this._mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        this.selectedButton = -1;
        if (this._iSelectedCompId != 6) {
            switch (this._iSelectedCompId) {
                case 5: {
                    this._mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this._mainCanvas, this._iSelectorCompId));
                    if (!Keys.isKeyPressed(-22)) break;
                    this.keyReleased(-22);
                    Keys.keyReleased(-22);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    this._bActiveButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this._iSelectorCompId = this._iSelectedCompId = 6;
        this._mainCanvas.repaint();
    }

    private void initGameName() {
        int width = this.imgGameName.getWidth();
        int height = this.imgGameName.getHeight();
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int y = height >> 3;
        this.rectGameName = new Rectangle(x, y, width, height);
    }
}

