/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.graphics.GFont;
import sk.inlogic.util.Rectangle;

public class Common {
    public static int SMALL_QUIT = 0;
    public static int SMALL_ARROW = 1;
    public static int SMALL_PAUSE = 2;
    public static int MIDDLE_YES = 0;
    public static int MIDDLE_NO = 1;
    public static int BIG_START = 0;
    public static int BIG_RESTART = 1;
    public static int BIG_NEXT = 2;
    public static int MIDDLE_PREV = 0;
    public static int MIDDLE_RESTART = 1;
    public static int MIDDLE_INSTRUCTIONS = 2;
    public static int MIDDLE_SOUND_OFF = 3;
    public static int MIDDLE_SOUND_ON = 4;
    public static int MIDDLE_ABOUT = 5;
    public static int MIDDLE_MENU = 6;
    public static int ICON_PLAY = 0;
    public static int ICON_YES = 1;
    public static int ICON_NO = 2;
    public static int ICON_RESTART = 3;
    public static int ICON_MENU = 4;
    public static int ICON_PAUSE = 5;
    public static int ICON_SETTING = 6;
    public static int ICON_POWER = 7;
    public static int ICON_INSTR = 8;
    public static int ICON_SOUND_OFF = 9;
    public static int ICON_SOUND_ON = 10;
    public static int ICON_LEVELS = 11;
    public static int ICON_BACK = 12;
    public static int ICON_ABOUT = 13;
    public static int IC_RESTART = 0;
    public static int IC_YES = 1;
    public static int IC_NO = 2;
    public static int IC_PAUSE = 4;
    public static int IC_MENU = 5;
    public static int IC_POWER = 6;
    public static int IC_UP = 7;
    public static int IC_DOWN = 8;
    public static int IC_BACK = 9;
    public static int IC_PLAY = 10;
    public static int MENU_IC_PLAY = 0;
    public static int MENU_IC_INSTR = 1;
    public static int MENU_IC_ABOUT = 2;
    public static int MENU_IC_MUSIC_ON = 3;
    public static int MENU_IC_MUSIC_OFF = 4;
    public static int MENU_IC_RESTART = 5;
    public static int MENU_IC_MENU = 6;
    public static long timer;
    public static int frameWheel;
    public static int frameWheelMini;
    public static Rectangle rectArea;
    public static Rectangle rectTopPanel;

    public static String scoreToPrint(int score) {
        String s = "";
        while (score >= 1000) {
            s = score % 1000 < 10 ? ".00" + Integer.toString(score % 1000) + s : (score % 1000 < 100 ? ".0" + Integer.toString(score % 1000) + s : "." + Integer.toString(score % 1000) + s);
            score /= 1000;
        }
        s = Integer.toString(score) + s;
        return s;
    }

    public static String secToTime(int sec) {
        int minutes;
        String time = "";
        int hours = sec / 3600;
        if (hours > 0) {
            time = Integer.toString(hours) + ":";
        }
        time = (minutes = sec % 3600 / 60) > 9 ? time + Integer.toString(minutes) + ":" : (minutes > 0 ? time + "0" + Integer.toString(minutes) + ":" : time + "00:");
        int seconds = sec % 60;
        time = seconds > 9 ? time + Integer.toString(seconds) : (seconds > 0 ? time + "0" + Integer.toString(seconds) : time + "00");
        return time;
    }

    public static void trace(String s) {
        System.out.println(s);
    }

    public static void trace(int i) {
        System.out.println(i);
    }

    public static void trace(boolean b) {
        System.out.println(b);
    }

    public static Rectangle getMenuArea(int width, int height) {
        int marginTop = 0;
        int marginBottom = 0;
        if (height <= 130) {
            marginTop = 30;
            marginBottom = 5;
        } else if (height <= 149) {
            marginTop = 45;
            marginBottom = 10;
        } else if (height <= 160) {
            marginTop = 50;
            marginBottom = 25;
        } else if (height <= 176) {
            marginTop = 65;
            marginBottom = 15;
        } else if (height <= 208) {
            marginTop = 65;
            marginBottom = 20;
        } else if (height <= 220) {
            marginTop = 70;
            marginBottom = 20;
        } else if (height <= 240) {
            marginTop = 80;
            marginBottom = 27;
        } else if (height <= 260) {
            marginTop = 85;
            marginBottom = 20;
        } else if (height <= 287) {
            marginTop = 85;
            marginBottom = 20;
        } else if (height <= 320) {
            if (width == 480) {
                marginTop = 120;
                marginBottom = 5;
            } else {
                marginTop = 100;
                marginBottom = 20;
            }
        } else if (height <= 348) {
            marginTop = 100;
            marginBottom = 25;
        } else if (height <= 360) {
            marginTop = 120;
            marginBottom = 40;
        } else if (height <= 416) {
            marginTop = 125;
            marginBottom = 75;
        } else if (height <= 432) {
            marginTop = 100;
            marginBottom = 132;
        } else if (height <= 480) {
            marginTop = 140;
            marginBottom = 25;
        } else if (height <= 640) {
            if (width == 480) {
                marginTop = 180;
                marginBottom = 40;
            } else {
                marginTop = 200;
                marginBottom = 140;
            }
        } else if (height <= 696) {
            marginTop = 240;
            marginBottom = 70;
        } else if (height <= 854) {
            marginTop = 260;
            marginBottom = 140;
        } else if (height <= 960) {
            marginTop = 260;
            marginBottom = 170;
        }
        return new Rectangle(0, 0 + marginTop, width, height - marginTop - marginBottom);
    }

    public static void initScreen(Rectangle rectScreen, Sprite sprBut, Sprite sprWheels) {
        int width = (rectScreen.width - sprBut.getHeight() / 3) / sprBut.getWidth() * sprBut.getWidth();
        int x = rectScreen.getCenterX() - (width >> 1);
        int y = sprBut.getHeight() / 3;
        rectTopPanel = new Rectangle(x, y, width, sprBut.getHeight());
        y = rectTopPanel.getBottom() + (sprBut.getHeight() / 3 << 1);
        int height = rectScreen.height - y - sprWheels.getHeight();
        rectArea = new Rectangle(0, y, MainCanvas.WIDTH, height);
    }

    public static void paintTopPanel(Graphics g, Image imgLight, Sprite sprBut, Sprite sprWheelsMini, Sprite sprMenuIcons, GFont fontBig, String text, int frameMenuIcon) {
        g.drawImage(imgLight, rectArea.getCenterX(), imgLight.getHeight() >> 1, 3);
        Common.paintButton(g, sprBut, rectTopPanel);
        Common.paintMiniWheel(g, sprWheelsMini, sprMenuIcons, -1, frameMenuIcon, rectTopPanel, sprBut.getHeight() / 6 >> 1, false);
        g.drawImage(imgLight, rectArea.getCenterX(), (imgLight.getHeight() >> 1) + rectTopPanel.getBottom(), 3);
        fontBig.drawString(g, text.toCharArray(), Common.rectTopPanel.x + (sprWheelsMini.getWidth() >> 2) + sprWheelsMini.getWidth(), rectTopPanel.getCenterY(), 6);
    }

    public static void paintButton(Graphics g, Sprite sprBut, Rectangle rect) {
        int y = rect.getCenterY() - (sprBut.getHeight() >> 1);
        sprBut.setFrame(0);
        sprBut.setPosition(rect.x, y);
        sprBut.paint(g);
        for (int x = rect.x + sprBut.getWidth(); x < rect.getRight() - sprBut.getWidth(); x += sprBut.getWidth()) {
            sprBut.setFrame(1);
            sprBut.setPosition(x, y);
            sprBut.paint(g);
        }
        sprBut.setFrame(2);
        sprBut.setPosition(rect.getRight() - sprBut.getWidth(), y);
        sprBut.paint(g);
    }

    public static void paintMiniWheel(Graphics g, Sprite sprWheelsMini, Sprite sprMenuIcons, int frame, int frameIcon, Rectangle rect, int yOffset, boolean isCenter) {
        if (frame < 0) {
            frame = frameWheelMini;
        }
        int x = rect.x + (sprWheelsMini.getWidth() >> 2);
        int y = rect.getCenterY() - (sprWheelsMini.getHeight() >> 1) + yOffset;
        if (isCenter) {
            x = rect.getCenterX() - (sprWheelsMini.getWidth() >> 1);
            y = rect.getCenterY() - (sprWheelsMini.getHeight() >> 1);
        }
        sprWheelsMini.setFrame(frame);
        sprWheelsMini.setPosition(x, y);
        sprWheelsMini.paint(g);
        y = rect.getCenterY() - (sprMenuIcons.getHeight() >> 1) - yOffset;
        sprMenuIcons.setFrame(frameIcon);
        sprMenuIcons.setPosition(x += (sprWheelsMini.getWidth() >> 2) + (sprMenuIcons.getWidth() >> 2), y);
        sprMenuIcons.paint(g);
    }

    public static void paintBottomAnimWheel(Graphics g, Sprite sprWheels, Rectangle rect) {
        sprWheels.setFrame(frameWheel);
        sprWheels.setPosition(rect.getCenterX() - (sprWheels.getWidth() >> 1), rect.getBottom() - sprWheels.getHeight());
        sprWheels.paint(g);
    }

    public static void updateWheels(long time, MainCanvas mainCanvas) {
        if ((timer += time) > 100L) {
            ++frameWheelMini;
            timer -= 100L;
            if (++frameWheel > 2) {
                frameWheel = 0;
            }
            if (frameWheelMini > 6) {
                frameWheelMini = 1;
            }
            mainCanvas.repaint();
        }
    }

    public static void paintMidArea(Graphics g, Image imgGameBorder, Rectangle rectScreen, Image imgBlueTile) {
        g.setClip(Common.rectArea.x, Common.rectArea.y - (imgGameBorder.getHeight() >> 1), Common.rectArea.width, Common.rectArea.height + imgGameBorder.getHeight());
        for (int x = 0; x <= rectScreen.width; x += imgBlueTile.getWidth()) {
            int y;
            for (y = Common.rectArea.y; y <= rectArea.getBottom(); y += imgBlueTile.getHeight()) {
                g.drawImage(imgBlueTile, x, y, 20);
            }
            y = Common.rectArea.y;
        }
        g.setClip(rectScreen.x, rectScreen.y, rectScreen.width, rectScreen.height);
        g.drawImage(imgGameBorder, rectArea.getCenterX(), Common.rectArea.y, 3);
        g.drawImage(imgGameBorder, rectArea.getCenterX(), rectArea.getBottom(), 3);
    }
}

