/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Ball {
    public static final int BONUS_PROBABILITY = 21;
    public static final int BONUS_ANY_PROBABILITY = 10;
    public static final int BONUS_NONE = 0;
    public static final int BONUS_GLYPH = 1;
    public static final int BONUS_BOMB = 2;
    public static final int BONUS_STAR = 3;
    public static final int BONUS_DIM = 4;
    public static final int BONUS_ANY = 5;
    public static final int COLOR_RED = 1;
    public static final int COLOR_YELLOW = 2;
    public static final int COLOR_PURPLE = 3;
    public static final int COLOR_GREEN = 4;
    public static final int COLOR_BLUE = 5;
    public int position;
    public short color;
    public short bonus;
    public short flyAngle;
    public short flyPos;
    public static short[] availColors = new short[5];
    public boolean refresh;
    public int anim_start;
    public static short numPoints;
    public static short[][] positions;

    public void setRefresh() {
        if (this.position >= 0) {
            this.refresh = true;
            this.anim_start = ChM.iAnimationIndex;
        }
    }

    public static void loadPositions(DataInputStream dis) {
        try {
            numPoints = dis.readShort();
            positions = new short[numPoints][2];
            for (int i = 0; i < numPoints; ++i) {
                Ball.positions[i][0] = dis.readShort();
                Ball.positions[i][1] = dis.readShort();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Ball(DataInputStream dis) throws IOException {
        this.position = dis.readInt();
        this.color = dis.readShort();
        this.bonus = dis.readShort();
        this.flyAngle = dis.readShort();
        this.flyPos = dis.readShort();
        this.refresh = dis.readBoolean();
        this.anim_start = dis.readInt();
    }

    public Ball(boolean isInSnake) {
        if (isInSnake) {
            this.color = (short)(Game.rnd(5) + 1);
            this.position = 0;
            this.bonus = Game.rnd(100) < 21 ? (short)(Game.rnd(4) + 1) : (short)0;
        } else {
            this.color = Game.ballsLeft > 0 || Game.ballsLeft <= 0 && availColors.length == 0 ? (short)(Game.rnd(5) + 1) : availColors[Game.rnd(availColors.length)];
            this.flyPos = 0;
            this.bonus = Game.rnd(100) < 10 ? (short)5 : (short)0;
        }
    }

    public void drawBall(Graphics g, short[] coords) {
        this.drawBall(g, coords[0], coords[1]);
    }

    public void drawBall(Graphics g) {
        if (this.position >= 0 && this.position < numPoints) {
            this.drawBall(g, positions[this.position][0], positions[this.position][1]);
        }
    }

    public void drawBall(Graphics g, int x, int y) {
        if (!this.refresh) {
            if (this.bonus == 0) {
                int idAnim = 19;
                switch (this.color) {
                    case 5: {
                        idAnim = 4;
                        break;
                    }
                    case 4: {
                        idAnim = 3;
                        break;
                    }
                    case 3: {
                        idAnim = 2;
                        break;
                    }
                    case 1: {
                        idAnim = 0;
                        break;
                    }
                    case 2: {
                        idAnim = 1;
                    }
                }
                if (Game.isStopped) {
                    ChM.renderAnimImage(g, idAnim, x, y, 0, 50, false, Game.RC);
                } else if (Game.isSlowed) {
                    ChM.renderAnimImage(g, idAnim, x, y, 0, 3, false, Game.RC);
                } else {
                    ChM.renderAnimImage(g, idAnim, x, y, 0, false, Game.RC);
                }
            } else {
                int idSub = 15;
                switch (this.bonus) {
                    case 1: {
                        idSub = 47;
                        break;
                    }
                    case 2: {
                        idSub = 48;
                        break;
                    }
                    case 3: {
                        idSub = 49;
                        break;
                    }
                    case 4: {
                        idSub = 50;
                        break;
                    }
                    case 5: {
                        idSub = 51;
                    }
                }
                ChM.renderSubImage(g, idSub, x, y, 3, Game.RC, false);
            }
        }
    }

    public boolean drawExpl(Graphics g) {
        int curAnim = 0;
        if (this.position < 0) {
            return false;
        }
        if (this.bonus != 0) {
            curAnim = 10;
        } else {
            switch (this.color) {
                case 5: {
                    curAnim = 9;
                    break;
                }
                case 4: {
                    curAnim = 8;
                    break;
                }
                case 3: {
                    curAnim = 7;
                    break;
                }
                case 1: {
                    curAnim = 5;
                    break;
                }
                case 2: {
                    curAnim = 6;
                }
            }
        }
        if (!ChM.isAnimationFinished(curAnim, this.anim_start)) {
            ChM.renderAnimImage(g, curAnim, positions[this.position][0], positions[this.position][1], this.anim_start, false, Game.RC);
            return true;
        }
        return false;
    }

    public int compare(Ball rhs) {
        if (rhs.bonus != 0) {
            return 0;
        }
        if (this.color == rhs.color) {
            return 1;
        }
        return -1;
    }
}

