/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Fairy {
    public static final int TIME_FREE_FLIGHT = 5000;
    public static final int TIME_DIRECTION_CHANGE = 500;
    public static final int TIME_TO_FLY = 200;
    public static final int STEP_LINE = 9;
    public static final int STEP_DIAG = 6;
    private static final String[] Directions = new String[]{"R", "RD", "D", "LD", "L", "LU", "U", "RU"};
    private static final int[] Animations = new int[]{13, 16, 11, 15, 14, 18, 12, 17};
    private static final int[] MainRC = new int[]{0, 0, Menu.W, Menu.H};
    private long startTime;
    private long endTime;
    private long prevChangeTime;
    private long prevFlight;
    private int X;
    private int Y;
    private int flyDirection;
    private int magnetDirection;
    private boolean freeFlight;
    public boolean active;

    public void save(DataOutputStream dos) throws IOException {
        long Time = System.currentTimeMillis();
        dos.writeLong(Time - this.startTime);
        dos.writeLong(Time - this.endTime);
        dos.writeLong(Time - this.prevChangeTime);
        dos.writeLong(Time - this.prevFlight);
        dos.writeInt(this.X);
        dos.writeInt(this.Y);
        dos.writeInt(this.flyDirection);
        dos.writeInt(this.magnetDirection);
        dos.writeBoolean(this.freeFlight);
        dos.writeBoolean(this.active);
    }

    public Fairy(DataInputStream dis) throws IOException {
        long Time = System.currentTimeMillis();
        this.startTime = Time - dis.readLong();
        this.endTime = Time - dis.readLong();
        this.prevChangeTime = Time - dis.readLong();
        this.prevFlight = Time - dis.readLong();
        this.X = dis.readInt();
        this.Y = dis.readInt();
        this.flyDirection = dis.readInt();
        this.magnetDirection = dis.readInt();
        this.freeFlight = dis.readBoolean();
        this.active = dis.readBoolean();
    }

    public Fairy(int _X, int _Y) {
        this.X = _X;
        this.Y = _Y;
        this.prevChangeTime = this.startTime = System.currentTimeMillis();
        this.prevFlight = this.startTime;
        this.endTime = this.startTime + 5000L;
        this.active = true;
        this.freeFlight = true;
        this.flyDirection = this.random(8);
    }

    private void drawFairy(Graphics g) {
        ChM.renderAnimImage(g, Animations[this.flyDirection], this.X, this.Y, 0, false, MainRC);
        ChM.renderAnimImage(g, 19, this.X, this.Y, 0, false, MainRC);
    }

    private void moveFairy() {
        switch (this.flyDirection) {
            case 0: {
                this.X += 9;
                break;
            }
            case 1: {
                this.X += 6;
                this.Y += 6;
                break;
            }
            case 2: {
                this.Y += 9;
                break;
            }
            case 3: {
                this.X -= 6;
                this.Y += 6;
                break;
            }
            case 4: {
                this.X -= 9;
                break;
            }
            case 5: {
                this.X -= 6;
                this.Y -= 6;
                break;
            }
            case 6: {
                this.Y -= 9;
                break;
            }
            case 7: {
                this.Y -= 6;
                this.X += 6;
            }
        }
    }

    private int max4(int top, int bot, int left, int right) {
        if (top >= bot && top >= left && top >= right) {
            return 6;
        }
        if (bot >= left && bot >= right) {
            return 2;
        }
        if (left >= right) {
            return 4;
        }
        return 0;
    }

    private int random(int n) {
        return Game.rnd(n);
    }

    private void defDirection() {
        this.magnetDirection = this.max4(this.Y, Menu.H - this.Y, this.X, Menu.W - this.X);
    }

    private void changeDirection() {
        if (!this.freeFlight && this.flyDirection != this.magnetDirection) {
            if (this.random(1) == 1) {
                this.flyDirection = this.magnetDirection;
            }
        } else {
            this.flyDirection = this.flyDirection + this.random(2) - 1;
            if (this.flyDirection >= Animations.length) {
                this.flyDirection = 0;
            } else if (this.flyDirection < 0) {
                this.flyDirection = Animations.length - 1;
            }
        }
    }

    public void process(Graphics g) {
        if (!this.active) {
            return;
        }
        if (this.X < -10 || this.X > Menu.W + 10 || this.Y < -10 || this.Y > Menu.H + 10) {
            this.active = false;
            return;
        }
        long Time = System.currentTimeMillis();
        if (this.freeFlight && Time > this.endTime) {
            this.freeFlight = false;
            this.defDirection();
        }
        if (Time - this.prevFlight > 200L) {
            this.moveFairy();
            this.prevFlight = Time;
            if (Time - this.prevChangeTime > 500L) {
                this.changeDirection();
                this.prevChangeTime = Time;
            }
        }
        this.drawFairy(g);
    }
}

