/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FuguFont {
    public static final int CHAR_LEFT = 0;
    public static final int CHAR_TOP = 1;
    public static final int CHAR_WIDTH = 2;
    public static final int CHAR_HEIGHT = 3;
    public static final int CHAR_Y_OFFSET = 4;
    private Image img_font;
    private int[][] location;
    private int c_separ = 1;
    private int height;

    private FuguFont(String FileName, int size) throws IOException {
        this.height = size;
        InputStream is = this.getClass().getResourceAsStream(FileName);
        if (is == null) {
            throw new IOException();
        }
        int len = 0;
        try {
            len = is.available();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        byte[] temp = new byte[len];
        try {
            is.read(temp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.location = new int[255][];
        int i = 0;
        while ((temp[i] & 0xFF) != 137 || (temp[i + 1] & 0xFF) != 80 || (temp[i + 2] & 0xFF) != 78 || (temp[i + 3] & 0xFF) != 71) {
            this.location[temp[i]] = new int[5];
            this.location[temp[i]][0] = temp[i + 1] & 0xFF;
            this.location[temp[i]][1] = temp[i + 2] & 0xFF;
            this.location[temp[i]][2] = temp[i + 3] & 0xFF;
            this.location[temp[i]][3] = temp[i + 4] & 0xFF;
            this.location[temp[i]][4] = temp[i + 5] & 0xFF;
            i += 6;
        }
        byte[] PNGbyte = new byte[len - i];
        System.arraycopy(temp, i, PNGbyte, 0, len - i);
        this.img_font = Image.createImage((byte[])PNGbyte, (int)0, (int)PNGbyte.length);
    }

    public static FuguFont factory(String FileName, int size) throws IOException {
        return new FuguFont(FileName, size);
    }

    public void drawString(Graphics g, String string, int x, int y, int Anchor) {
        this.drawString(g, string, x, y, Anchor, this.c_separ);
    }

    public void drawString(Graphics g, String string, int x, int y, int Anchor, int separ) {
        try {
            this.testAnchor(Anchor);
            this.drawSLT(g, string, x + this.getDX(this.getWidth(string), Anchor), y + this.getDY(this.height, Anchor), separ);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void drawSLT(Graphics g, String string, int x, int y, int separ) throws NullPointerException {
        int[] oc = new int[]{g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight()};
        int stringW = 0;
        for (int i = 0; i < string.length(); ++i) {
            try {
                int height = this.location[string.charAt(i) & Integer.MAX_VALUE][3];
                int width = this.location[string.charAt(i) & Integer.MAX_VALUE][2];
                this.setClip(g, this.getAnd(oc[0], oc[1], oc[2], oc[3], x + stringW, y + this.location[string.charAt(i) & Integer.MAX_VALUE][4], width, height));
                g.drawImage(this.img_font, x + stringW - this.location[string.charAt(i) & Integer.MAX_VALUE][0], y - this.location[string.charAt(i) & Integer.MAX_VALUE][1] + this.location[string.charAt(i) & Integer.MAX_VALUE][4], 20);
                stringW += this.location[string.charAt(i) & Integer.MAX_VALUE][2] + separ;
                if ((string.charAt(i) & Integer.MAX_VALUE) != 32) continue;
                stringW += 3;
                continue;
            }
            catch (NullPointerException e) {
                System.out.println("'" + string.charAt(i) + "'" + "(" + i + ")" + " cannot be found in the font.");
            }
        }
        g.setClip(oc[0], oc[1], oc[2], oc[3]);
    }

    public int[] getAnd(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int[] res = new int[4];
        res[0] = x1 > x2 ? x1 : x2;
        res[1] = y1 > y2 ? y1 : y2;
        int i = x1 + w1;
        int j = x2 + w2;
        res[2] = (i < j ? i : j) - res[0];
        i = y1 + h1;
        j = y2 + h2;
        res[3] = (i < j ? i : j) - res[1];
        return res;
    }

    public void setClip(Graphics g, int[] a) {
        g.setClip(a[0], a[1], a[2], a[3]);
    }

    public int getDX(int x2, int Anchor) {
        int dx = 0;
        if ((Anchor & 8) != 0) {
            dx = -x2;
        } else if ((Anchor & 1) != 0) {
            dx = -(x2 >> 1);
        }
        return dx;
    }

    public int getDY(int y2, int Anchor) {
        int dy = 0;
        if ((Anchor & 0x20) != 0) {
            dy = -y2;
        } else if ((Anchor & 2) != 0) {
            dy = -(y2 >> 1);
        }
        return dy;
    }

    public int getCharWidth(char c) {
        try {
            if (c == ' ') {
                return this.location[c][2] + this.c_separ + 3;
            }
            return this.location[c][2] + this.c_separ;
        }
        catch (Exception e) {
            System.out.println("c = " + c);
            return 0;
        }
    }

    public int getWidth(String s) {
        int width = 0;
        for (int i = 0; i < s.length(); ++i) {
            try {
                width += this.location[s.charAt(i) & Integer.MAX_VALUE][2] + this.c_separ;
                continue;
            }
            catch (NullPointerException e) {
                System.out.println("'" + s.charAt(i) + "' cannot be found in the font.");
            }
        }
        return width - this.c_separ;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSpear(int spear) {
        this.c_separ = spear;
    }

    public int getSepar() {
        return this.c_separ;
    }

    public void testAnchor(int Anchor) {
        int temp = Anchor & 8 | Anchor & 4 | Anchor & 1;
        switch (temp) {
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        temp = Anchor & 0x10 | Anchor & 0x20 | Anchor & 2;
        switch (temp) {
            case 2: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

