/*
 * Decompiled with CFR 0.152.
 */
public class ColorProcessor {
    public static int[] crc_table;

    public static byte[] getImage(byte[] data, int offset, int colorLen) {
        int checksum = ColorProcessor.checksum(data, offset - 4, colorLen + 4);
        data[offset + colorLen] = (byte)(checksum >> 24 & 0xFF);
        data[offset + colorLen + 1] = (byte)(checksum >> 16 & 0xFF);
        data[offset + colorLen + 2] = (byte)(checksum >> 8 & 0xFF);
        data[offset + colorLen + 3] = (byte)(checksum & 0xFF);
        return data;
    }

    private static int checksum(byte[] buf, int off, int len) {
        return ~ColorProcessor.update_crc(buf, off, len);
    }

    private static int update_crc(byte[] buf, int off, int len) {
        int c = -1;
        if (crc_table == null) {
            ColorProcessor.make_crc_table();
        }
        for (int n = off; n < len + off; ++n) {
            c = crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
        }
        return c;
    }

    private static void make_crc_table() {
        crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) == 1) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            ColorProcessor.crc_table[n] = c;
        }
    }

    public static byte[] ChangeColor(byte[] ImageData, int[] color) throws IndexOutOfBoundsException {
        int i;
        int i2;
        int offset = 0;
        int colorLen = 0;
        byte[] res = null;
        for (i2 = 0; i2 < ImageData.length; ++i2) {
            if (ImageData[i2] != 80 || ImageData[i2 + 1] != 76 || ImageData[i2 + 2] != 84 || ImageData[i2 + 3] != 69) continue;
            offset = i2 + 4;
            break;
        }
        for (i2 = 3; i2 >= 0; --i2) {
            colorLen |= (ImageData[offset - 5 - i2] & 0xFF) << (i2 << 3);
        }
        if (colorLen / 3 != color.length) {
            throw new IndexOutOfBoundsException();
        }
        int[] oldColor = new int[color.length];
        for (int j = 0; j < color.length; ++j) {
            oldColor[j] = (ImageData[offset + j * 3] & 0xFF) << 16 | (ImageData[offset + j * 3 + 1] & 0xFF) << 8 | ImageData[offset + j * 3 + 2] & 0xFF;
        }
        boolean notChange = true;
        for (i = 0; i < color.length; ++i) {
            notChange &= oldColor[i] == color[i];
        }
        if (!notChange) {
            for (i = 0; i < color.length; ++i) {
                ImageData[offset + i * 3] = (byte)(color[i] >> 16 & 0xFF);
                ImageData[offset + i * 3 + 1] = (byte)(color[i] >> 8 & 0xFF);
                ImageData[offset + i * 3 + 2] = (byte)(color[i] & 0xFF);
            }
            res = ColorProcessor.getImage(ImageData, offset, colorLen);
        } else {
            res = ImageData;
        }
        return res;
    }
}

