/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class SndLG {
    public static int iQuerySoundId = -1;
    private static final int AMR = 0;
    private static final int MIDI = 1;
    private static final int EMPTY = 2;
    private static final short[] massSoundTypes = new short[]{1, 1, 2};
    private static Player[] players = new Player[1];

    public static final void load_sounds() {
        SndLG.loadMidi();
    }

    private static final void loadMidi() {
        for (int i = 0; i < 1; ++i) {
            if (massSoundTypes[i] != 1) continue;
            SndLG.sndLoadMidi(i);
        }
    }

    private static final void sndLoadMidi(int i) {
        try {
            if (players[i] == null) {
                InputStream is = ((Object)((Object)Mid.ins)).getClass().getResourceAsStream(i + ".mid");
                if (is == null) {
                    return;
                }
                SndLG.players[i] = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                SndLG.players[i].realize();
                players[i].prefetch();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void sndPlay(int iSound) {
        SndLG.playSound(iSound);
    }

    public static final void playSound(int iSound) {
        block7: {
            try {
                if (iSound != 0) {
                    return;
                }
                if (!SndLG.isEnabled() || players[iSound] == null) break block7;
                Thread.yield();
                try {
                    players[iSound].realize();
                    players[iSound].prefetch();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    players[iSound].start();
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void playVibra() {
        if (SndLG.isEnabledVibra()) {
            try {
                Display.getDisplay((MIDlet)Mid.ins).vibrate(100);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void stopAllSounds() {
        try {
            players[0].stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized boolean isEnabled() {
        return Data.isSoundOn;
    }

    public static final void setEnabled(boolean a_bEnabled) {
        SndLG.stopAllSounds();
        Data.isSoundOn = a_bEnabled;
    }

    public static final boolean isEnabledVibra() {
        return Data.isVibraOn;
    }

    public static final void setEnabledVibra(boolean a_bNewValue) {
        Data.isVibraOn = a_bNewValue;
    }
}

