/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;
import javax.microedition.midlet.MIDlet;

public class SoundPlayer {
    static Sound explSound;
    static Sound pickSound;
    static Sound missionSound;
    static Sound bgSound;

    public SoundPlayer(MIDlet mIDlet) {
        try {
            byte[] byArray = new byte[1000];
            pickSound = SoundPlayer.GameSound(mIDlet, "/pick.ott", byArray);
            explSound = SoundPlayer.GameSound(mIDlet, "/exp.ott", byArray);
            missionSound = SoundPlayer.GameSound(mIDlet, "/hit.ott", byArray);
            bgSound = SoundPlayer.GameSound(mIDlet, "/bg.ott", byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Sound GameSound(MIDlet mIDlet, String string, byte[] byArray) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
        int n = dataInputStream.read(byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        Sound sound = new Sound(byArray2, 1);
        dataInputStream.close();
        return sound;
    }

    public void stopSounds() {
        missionSound.stop();
        explSound.stop();
        pickSound.stop();
        bgSound.stop();
    }

    public void playExplosion() {
        this.play(explSound, 1);
    }

    public void playPickup() {
        this.play(pickSound, 1);
    }

    public void playMissionComplete() {
        this.stopSounds();
        this.play(missionSound, 1);
    }

    public void playBg() {
        this.play(bgSound, 0);
    }

    public void play(Sound sound, int n) {
        try {
            sound.setGain(64);
            if (sound.getState() != 0) {
                sound.play(n);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

