/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

final class GLLibPlayer
implements Runnable {
    int posX;
    int posY;
    int curFlags;
    ASprite sprite;
    int curAnim;
    int curFrame;
    private int curTime;
    private int nbLoop;
    private boolean animIsOver;
    private static int k_animBaseFrameTime = 66;
    private static final int k_snd_nbChannel = 2;
    static int s_snd_masterVolume;
    private static int s_snd_maxNbSoundSlot;
    private static boolean s_snd_isSoundEngineInitialized;
    private static byte[][] s_snd_sndSlot;
    private static int[] s_snd_sndType;
    private static boolean s_snd_IgnoreSoundsOnInterrupt;
    private static Player[] s_snd_Player;
    private static Player[] s_snd_PlayerSlot;
    private static int[] s_snd_index;
    private static int[] s_snd_priority;
    private static int[] s_snd_state;
    private static int[] s_snd_volume;
    private static int[] s_snd_loop;
    private static Thread s_pThread;
    private static GLLibPlayer s_pSoundPlayerIns;
    private static int[] s_snd_queue;
    private static int[] s_snd_queue_pointer;
    private static int[] s_snd_queue_size;
    private static boolean s_bTilesetPlayerInitialized;
    private static int s_TilesetMaxLayerCount;
    private static int s_TilesetEffectLayer;
    private static int s_TilesetAlphaLayer;
    private static int s_TilesetEffectType;
    private static int[] s_TilesetInfo;
    static int[][] s_TilesetLayerInfo;
    private static byte[][][] s_TilesetLayerData;
    private static Image[][] s_TilesetLayerImage;
    private static Graphics[][] s_TilesetLayerGraphics;
    private static ASprite[] s_TilesetSprite;

    GLLibPlayer() {
        this.Reset();
    }

    GLLibPlayer(ASprite aSprite, int n, int n2) {
        this.Reset();
        this.posX = n;
        this.posY = n2;
        v0.sprite = aSprite;
        this.SetAnim(-1, -1);
    }

    private void Reset() {
        this.posX = 0;
        this.posY = 0;
        this.curAnim = -1;
        this.curFrame = 0;
        this.sprite = null;
        this.curFlags = 0;
        this.curTime = 0;
        this.nbLoop = 1;
        this.animIsOver = true;
    }

    final void SetAnim(int n, int n2) {
        if (this.animIsOver || n != this.curAnim) {
            this.curAnim = n;
            this.SetFrame(0);
            this.nbLoop = n2 - 1;
            this.animIsOver = false;
        }
    }

    final int SetFrame(int n) {
        if (this.curAnim < 0) {
            return -1;
        }
        int n2 = this.GetNbFrame();
        while (n > n2) {
            n -= n2;
        }
        this.curFrame = n;
        this.curTime = 0;
        return n;
    }

    final int GetNbFrame() {
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrames(this.curAnim);
        }
        return -1;
    }

    private int GetDuration() {
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrameTime(this.curAnim, this.curFrame) * k_animBaseFrameTime;
        }
        return 0;
    }

    final boolean IsAnimOver() {
        if (this.curAnim < 0) {
            return true;
        }
        if (this.nbLoop < 0) {
            return false;
        }
        return this.animIsOver;
    }

    final void Render() {
        if (this.curAnim < 0) {
            return;
        }
        this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
    }

    final void Update() {
        this.Update(GLLib.s_game_frameDT);
    }

    final void Update(int n) {
        if (this.animIsOver || this.curAnim < 0) {
            return;
        }
        this.curTime += n;
        n = this.GetDuration();
        while (this.curTime >= n) {
            this.curTime -= n;
            if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                ++this.curFrame;
            } else {
                if (this.nbLoop == 0) {
                    this.animIsOver = true;
                    return;
                }
                if (this.nbLoop > 0) {
                    --this.nbLoop;
                }
                this.curFrame = 0;
            }
            n = this.GetDuration();
        }
    }

    private static int SndQueue_NormalizeIndex(int n) {
        while (n >= 7) {
            n -= 7;
        }
        while (n < 0) {
            n += 7;
        }
        return n;
    }

    private static final int SndQueue_GetIndex(int n, int n2) {
        return n * 7 * 5 + n2 * 5;
    }

    private static final int SndQueue_GetData(int n, int n2) {
        return s_snd_queue[GLLibPlayer.SndQueue_GetIndex(n, s_snd_queue_pointer[n]) + n2];
    }

    private static void SndQueue_Push(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        int n8 = s_snd_queue_pointer[n];
        int n9 = s_snd_queue_size[n];
        n8 = GLLibPlayer.SndQueue_NormalizeIndex(n8 + n9);
        for (int i = 0; i < n9; ++i) {
            n7 = GLLibPlayer.SndQueue_NormalizeIndex(n8 - i - 1);
            if (s_snd_queue[n7 = GLLibPlayer.SndQueue_GetIndex(n, n7)] != n2 || (n2 == 3 || n2 == 1) && s_snd_queue[n7 + 2] < n4) continue;
            GLLibPlayer.s_snd_queue[n7] = 0;
        }
        n7 = GLLibPlayer.SndQueue_GetIndex(n, n8);
        GLLibPlayer.s_snd_queue[n7] = n2;
        GLLibPlayer.s_snd_queue[n7 + 1] = n3;
        GLLibPlayer.s_snd_queue[n7 + 2] = n4;
        GLLibPlayer.s_snd_queue[n7 + 3] = n5;
        GLLibPlayer.s_snd_queue[n7 + 4] = n6;
        int n10 = n;
        s_snd_queue_size[n10] = s_snd_queue_size[n10] + 1;
    }

    private static final void SndQueue_Push(int n, int n2) {
        GLLibPlayer.SndQueue_Push(n, n2, -1, -1, -1, -1);
    }

    static void Snd_Init(int n) throws Exception {
        s_snd_Player = new Player[k_snd_nbChannel];
        s_snd_PlayerSlot = new Player[17];
        s_snd_index = new int[k_snd_nbChannel];
        s_snd_priority = new int[k_snd_nbChannel];
        s_snd_state = new int[k_snd_nbChannel];
        s_snd_volume = new int[k_snd_nbChannel];
        s_snd_loop = new int[k_snd_nbChannel];
        s_snd_queue = new int[k_snd_nbChannel * 7 * 5];
        s_snd_queue_pointer = new int[k_snd_nbChannel];
        s_snd_queue_size = new int[k_snd_nbChannel];
        for (n = 0; n < k_snd_nbChannel; ++n) {
            GLLibPlayer.s_snd_index[n] = -1;
            GLLibPlayer.s_snd_queue_pointer[n] = 0;
            GLLibPlayer.s_snd_queue_size[n] = 0;
        }
        s_snd_maxNbSoundSlot = 17;
        s_snd_sndSlot = new byte[17][];
        s_snd_sndType = new int[s_snd_maxNbSoundSlot];
        s_snd_masterVolume = 100;
        s_snd_isSoundEngineInitialized = true;
        s_pSoundPlayerIns = new GLLibPlayer();
        s_pThread = new Thread(s_pSoundPlayerIns);
        s_pThread.start();
    }

    static void Snd_LoadSound(String object, int n, boolean bl) throws Exception {
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (n < 0) {
            return;
        }
        GLLib.Pack_Open((String)object);
        byte[] byArray = GLLib.Pack_ReadData(n);
        object = byArray;
        boolean bl2 = true;
        int n2 = n;
        n = GLLib.s_pack_lastDataReadMimeType;
        object = byArray;
        if (s_snd_isSoundEngineInitialized) {
            GLLibPlayer.s_snd_sndSlot[n2] = (byte[])object;
            GLLibPlayer.s_snd_sndType[n2] = n;
            if (bl2) {
                GLLibPlayer.s_snd_PlayerSlot[n2] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
                s_snd_PlayerSlot[n2].realize();
                s_snd_PlayerSlot[n2].prefetch();
                GLLibPlayer.s_snd_sndSlot[n2] = null;
            }
        }
    }

    static void Snd_Play(int n, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return;
        }
        GLLibPlayer.SndQueue_Push(n, 3, n2, n5, 100, n3);
    }

    static final void Snd_Stop(int n) {
        GLLibPlayer.SndQueue_Push(n, 4);
    }

    static final void Snd_Pause(int n) {
        GLLibPlayer.SndQueue_Push(n, 5);
    }

    static final void Snd_Resume(int n) {
        GLLibPlayer.SndQueue_Push(n, 6);
    }

    private static void Snd_PrepareExec(int n) throws Exception {
        int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
        int n3 = GLLibPlayer.SndQueue_GetData(n, 2);
        if (s_snd_state[n] == 2 && s_snd_priority[n] < n3) {
            return;
        }
        if (s_snd_index[n] == n2 && s_snd_state[n] != 0) {
            return;
        }
        GLLibPlayer.Snd_FreeChannelExec(n);
        GLLibPlayer.s_snd_Player[n] = s_snd_PlayerSlot[n2];
        if (s_snd_Player[n] == null) {
            if (s_snd_sndSlot[n2] == null) {
                return;
            }
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        GLLibPlayer.s_snd_state[n] = 1;
        GLLibPlayer.s_snd_index[n] = n2;
    }

    static void Snd_SetMasterVolume(int n) throws Exception {
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        s_snd_masterVolume = n;
        try {
            for (n = 0; n < k_snd_nbChannel; ++n) {
                if (s_snd_Player[n] == null || s_snd_Player[n] == null) continue;
                ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(s_snd_volume[n] * s_snd_masterVolume * 100 / 10000);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void Snd_Update() {
        if (s_pThread != null && !s_pThread.isAlive()) {
            s_pThread.start();
        }
    }

    private static void Snd_Update_Exec() {
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            int n;
            if (s_snd_queue_size[i] > 0 && s_snd_state[i] == 2) {
                try {
                    n = i;
                    n = !s_snd_isSoundEngineInitialized ? 0 : (s_snd_Player[n] == null ? 0 : (s_snd_Player[n].getState() != 400 ? 0 : 1));
                }
                catch (Exception exception) {
                    n = 0;
                }
                if (n == 0) {
                    GLLibPlayer.s_snd_state[i] = 1;
                }
            }
            while (s_snd_queue_size[i] > 0) {
                try {
                    n = GLLibPlayer.SndQueue_GetData(i, 0);
                    switch (n) {
                        case 1: {
                            GLLibPlayer.Snd_PrepareExec(i);
                            break;
                        }
                        case 2: {
                            GLLibPlayer.Snd_FreeChannelExec(i);
                            break;
                        }
                        case 3: {
                            n = i;
                            if (!GLLib.s_game_isPaused) {
                                GLLibPlayer.Snd_PrepareExec(n);
                                if (!GLLib.s_game_isPaused && s_snd_state[n] == 1) {
                                    if (s_snd_Player[n] == null) break;
                                    int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
                                    int n3 = GLLibPlayer.SndQueue_GetData(n, 2);
                                    int n4 = GLLibPlayer.SndQueue_GetData(n, 4);
                                    int n5 = GLLibPlayer.SndQueue_GetData(n, 3);
                                    if (n4 == 0) {
                                        s_snd_Player[n].setLoopCount(-1);
                                    } else {
                                        s_snd_Player[n].setLoopCount(n4);
                                    }
                                    ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(n5 * s_snd_masterVolume * 100 / 10000);
                                    s_snd_Player[n].setMediaTime(0L);
                                    s_snd_Player[n].start();
                                    GLLibPlayer.s_snd_state[n] = 2;
                                    GLLibPlayer.s_snd_volume[n] = n5;
                                    GLLibPlayer.s_snd_loop[n] = n4;
                                    GLLibPlayer.s_snd_priority[n] = n3;
                                    GLLibPlayer.s_snd_index[n] = n2;
                                }
                            }
                            break;
                        }
                        case 4: {
                            n = i;
                            if (s_snd_Player[n] != null) {
                                s_snd_Player[n].stop();
                                GLLibPlayer.s_snd_state[n] = 1;
                            }
                            break;
                        }
                        case 5: {
                            n = i;
                            if (s_snd_state[n] == 2 && s_snd_Player[n] != null) {
                                s_snd_Player[n].stop();
                                GLLibPlayer.s_snd_state[n] = 3;
                            }
                            break;
                        }
                        case 6: {
                            n = i;
                            if (s_snd_state[n] == 3 && s_snd_Player[n] != null) {
                                s_snd_Player[n].start();
                                GLLibPlayer.s_snd_state[n] = 2;
                            } else {
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {}
                n = i;
                GLLibPlayer.s_snd_queue_pointer[n] = GLLibPlayer.SndQueue_NormalizeIndex(s_snd_queue_pointer[n] + 1);
                int n6 = n;
                s_snd_queue_size[n6] = s_snd_queue_size[n6] - 1;
            }
        }
    }

    public final void run() {
        while (s_pThread != null) {
            GLLibPlayer.Snd_Update_Exec();
            try {
                Thread.sleep(66);
            }
            catch (Exception exception) {}
        }
    }

    private static void Snd_FreeChannelExec(int n) throws Exception {
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (s_snd_Player[n] != null) {
            s_snd_Player[n].stop();
            int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
            if (n2 < 0 || s_snd_PlayerSlot[n2] == null) {
                s_snd_Player[n].close();
            }
            GLLibPlayer.s_snd_Player[n] = null;
            System.gc();
        }
        GLLibPlayer.s_snd_state[n] = 0;
    }

    static void Snd_PauseNotify() {
        try {
            int n = 0;
            while (n < k_snd_nbChannel) {
                int n2 = n++;
                GLLibPlayer.SndQueue_Push(n2, 4);
            }
            if (GLLib.s_game_isPaused) {
                GLLibPlayer.Snd_Update_Exec();
            }
            if (GLLib.s_game_isPaused) {
                GLLibPlayer.Snd_Update_Exec();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void Tileset_Init(int n, int n2, int n3, int n4) {
        s_TilesetInfo = new int[8];
        s_TilesetLayerInfo = new int[s_TilesetMaxLayerCount][15];
        s_TilesetLayerData = new byte[s_TilesetMaxLayerCount][2][];
        s_TilesetLayerImage = new Image[s_TilesetMaxLayerCount][1];
        s_TilesetLayerGraphics = new Graphics[s_TilesetMaxLayerCount][1];
        s_TilesetSprite = new ASprite[s_TilesetMaxLayerCount];
        GLLibPlayer.s_TilesetInfo[0] = 640;
        GLLibPlayer.s_TilesetInfo[1] = 304;
        GLLibPlayer.s_TilesetInfo[2] = 24;
        GLLibPlayer.s_TilesetInfo[4] = 0;
        GLLibPlayer.s_TilesetInfo[5] = 24;
        GLLibPlayer.s_TilesetInfo[7] = 0;
        s_bTilesetPlayerInitialized = true;
    }

    private static final boolean isFlag(int n, int n2) {
        return (s_TilesetLayerInfo[n][14] & n2) != 0;
    }

    private static final void setFlag(int n, int n2, boolean bl) {
        if (bl) {
            int[] nArray = s_TilesetLayerInfo[n];
            nArray[14] = nArray[14] | n2;
            return;
        }
        int[] nArray = s_TilesetLayerInfo[n];
        nArray[14] = nArray[14] & ~n2;
    }

    static void Tileset_LoadLayer(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, ASprite aSprite, int n2, int n3, int n4, int n5) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.Tileset_Destroy(1, false);
        GLLibPlayer.s_TilesetLayerData[1][0] = byArray2;
        GLLibPlayer.s_TilesetLayerData[1][1] = byArray3;
        GLLibPlayer.s_TilesetLayerInfo[1][2] = GLLib.Mem_GetShort(byArray, 0);
        GLLibPlayer.s_TilesetLayerInfo[1][3] = GLLib.Mem_GetShort(byArray, 2);
        GLLibPlayer.s_TilesetLayerInfo[1][4] = s_TilesetLayerInfo[1][2] * s_TilesetInfo[2];
        GLLibPlayer.s_TilesetLayerInfo[1][5] = s_TilesetLayerInfo[1][3] * s_TilesetInfo[5];
        GLLibPlayer.s_TilesetSprite[1] = aSprite;
        try {
            n = s_TilesetInfo[0] % s_TilesetInfo[2];
            int n6 = 1 + (n != 0 ? 1 : 0);
            GLLibPlayer.s_TilesetLayerInfo[1][6] = s_TilesetInfo[0] - n + n6 * s_TilesetInfo[2];
            n = s_TilesetInfo[1] % s_TilesetInfo[5];
            n6 = 1 + (n != 0 ? 1 : 0);
            GLLibPlayer.s_TilesetLayerInfo[1][7] = s_TilesetInfo[1] - n + n6 * s_TilesetInfo[5];
            if (s_TilesetLayerImage[1][0] == null || s_TilesetLayerImage[1][0].getWidth() != s_TilesetLayerInfo[1][6] || s_TilesetLayerImage[1][0].getHeight() != s_TilesetLayerInfo[1][7]) {
                GLLibPlayer.s_TilesetLayerImage[1][0] = Image.createImage((int)s_TilesetLayerInfo[1][6], (int)s_TilesetLayerInfo[1][7]);
                GLLibPlayer.s_TilesetLayerGraphics[1][0] = s_TilesetLayerImage[1][0].getGraphics();
            }
            GLLibPlayer.setFlag(1, 4, true);
        }
        catch (Exception exception) {}
        GLLibPlayer.s_TilesetLayerInfo[1][8] = -1;
        GLLibPlayer.s_TilesetLayerInfo[1][9] = -1;
        GLLibPlayer.s_TilesetLayerInfo[1][10] = -1;
        GLLibPlayer.s_TilesetLayerInfo[1][11] = -1;
        GLLibPlayer.s_TilesetLayerInfo[1][0] = 1;
        GLLibPlayer.s_TilesetLayerInfo[1][1] = 1;
        GLLibPlayer.s_TilesetLayerInfo[1][12] = 0;
        GLLibPlayer.s_TilesetLayerInfo[1][13] = 0;
        GLLibPlayer.setFlag(1, 1, n4 == 1);
        GLLibPlayer.setFlag(1, 2, false);
        GLLibPlayer.setFlag(1, 8, false);
    }

    static void Tileset_Destroy(int n) {
        GLLibPlayer.Tileset_Destroy(n, true);
    }

    private static void Tileset_Destroy(int n, boolean bl) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n] = new int[15];
        if (bl) {
            GLLibPlayer.s_TilesetLayerImage[n] = new Image[1];
            GLLibPlayer.s_TilesetLayerGraphics[n] = new Graphics[1];
        }
        GLLibPlayer.s_TilesetLayerData[n] = new byte[2][];
        GLLibPlayer.s_TilesetSprite[n] = null;
    }

    static void Tileset_Draw(Graphics graphics, int n, int n2, int n3) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (graphics != null) {
            n4 = graphics.getClipX();
            n5 = graphics.getClipY();
            n6 = graphics.getClipWidth();
            n7 = graphics.getClipHeight();
        }
        int n8 = s_TilesetInfo[0];
        int n9 = s_TilesetInfo[1];
        if (n3 == -1) {
            for (int i = 0; i < s_TilesetMaxLayerCount; ++i) {
                if (i == s_TilesetAlphaLayer) continue;
                GLLibPlayer.Tileset_Draw(graphics, n, n2, i);
            }
            return;
        }
        if (s_TilesetLayerInfo[n3][0] != 1 || s_TilesetLayerInfo[n3][1] != 1) {
            return;
        }
        int n10 = s_TilesetLayerInfo[n3][12];
        int n11 = s_TilesetLayerInfo[n3][13];
        if (GLLibPlayer.isFlag(n3, 4)) {
            int n12 = n10;
            int n13 = n11;
            if (n12 < 0) {
                n12 -= s_TilesetInfo[2];
            }
            if (n13 < 0) {
                n13 -= s_TilesetInfo[5];
            }
            int n14 = n12 / s_TilesetInfo[2];
            int n15 = n13 / s_TilesetInfo[5];
            int n16 = n14 + s_TilesetLayerInfo[n3][6] / s_TilesetInfo[2] - 1;
            int n17 = n15 + s_TilesetLayerInfo[n3][7] / s_TilesetInfo[5] - 1;
            if (s_TilesetLayerInfo[n3][8] != n14 || s_TilesetLayerInfo[n3][10] != n16) {
                if (s_TilesetLayerInfo[n3][8] < n14 || s_TilesetLayerInfo[n3][10] < n16) {
                    if (s_TilesetLayerInfo[n3][10] < n14) {
                        n12 = n14;
                        n13 = n16;
                    } else {
                        n12 = s_TilesetLayerInfo[n3][10] + 1;
                        n13 = n16;
                    }
                } else if (s_TilesetLayerInfo[n3][8] > n16) {
                    n12 = n14;
                    n13 = n16;
                } else {
                    n12 = n14;
                    n13 = s_TilesetLayerInfo[n3][8] - 1;
                }
                GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n12, n15, n13 - n12, n17 - n15, 0, 0);
                GLLibPlayer.s_TilesetLayerInfo[n3][8] = n14;
                GLLibPlayer.s_TilesetLayerInfo[n3][10] = n16;
            }
            if (s_TilesetLayerInfo[n3][9] != n15 || s_TilesetLayerInfo[n3][11] != n17) {
                if (s_TilesetLayerInfo[n3][9] < n15 || s_TilesetLayerInfo[n3][11] < n17) {
                    if (s_TilesetLayerInfo[n3][11] < n15) {
                        n12 = n15;
                        n13 = n17;
                    } else {
                        n12 = s_TilesetLayerInfo[n3][11] + 1;
                        n13 = n17;
                    }
                } else if (s_TilesetLayerInfo[n3][9] > n17) {
                    n12 = n15;
                    n13 = n17;
                } else {
                    n12 = n15;
                    n13 = s_TilesetLayerInfo[n3][9] - 1;
                }
                GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n14, n12, n16 - n14, n13 - n12, 0, 0);
                GLLibPlayer.s_TilesetLayerInfo[n3][9] = n15;
                GLLibPlayer.s_TilesetLayerInfo[n3][11] = n17;
            }
            if (graphics != null) {
                while (n10 < 0) {
                    n10 += s_TilesetLayerInfo[n3][6];
                }
                while (n11 < 0) {
                    n11 += s_TilesetLayerInfo[n3][7];
                }
                n14 = n10 % s_TilesetLayerInfo[n3][6];
                n15 = n11 % s_TilesetLayerInfo[n3][7];
                n10 = (n10 + n8) % s_TilesetLayerInfo[n3][6];
                n11 = (n11 + n9) % s_TilesetLayerInfo[n3][7];
                if (n10 > n14) {
                    if (n11 > n15) {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n14, n15, n8, n9, n + 0, n2 + 0);
                    } else {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n14, n15, n8, n9 - n11, n + 0, n2 + 0);
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n14, 0, n8, n11, n + 0, n9 - n11 + n2);
                    }
                } else if (n11 > n15) {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n14, n15, n8 - n10, n9, n + 0, n2 + 0);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n15, n10, n9, n8 - n10 + n, n2 + 0);
                } else {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n14, n15, n8 - n10, n9 - n11, n + 0, n2 + 0);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n14, 0, n8 - n10, n11, n + 0, n9 - n11 + n2);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n15, n10, n9 - n11, n8 - n10 + n, n2 + 0);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, 0, n10, n11, n8 - n10 + n, n9 - n11 + n2);
                }
            }
        } else {
            int n18;
            int n19 = n10;
            int n20 = n11;
            if (n19 < 0) {
                n19 -= s_TilesetInfo[2];
            }
            if (n20 < 0) {
                n20 -= s_TilesetInfo[5];
            }
            n19 /= s_TilesetInfo[2];
            n20 /= s_TilesetInfo[5];
            int n21 = n8 / s_TilesetInfo[2];
            if (n21 * s_TilesetInfo[2] < n8) {
                ++n21;
            }
            if ((n18 = n9 / s_TilesetInfo[5]) * s_TilesetInfo[5] < n9) {
                ++n18;
            }
            int n22 = n19 * s_TilesetInfo[2] - n10;
            int n23 = n20 * s_TilesetInfo[5] - n11;
            GLLibPlayer.Tileset_UpdateBuffer(graphics, n3, n19, n20, n21, n18, n22 + n, n23 + n2);
        }
        if (graphics != null) {
            graphics.setClip(n4, n5, n6, n7);
        }
    }

    private static void Tileset_Draw2Screen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.setClip(n6, n7, n4, n5);
        graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
    }

    private static void Tileset_UpdateBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl = GLLibPlayer.isFlag(n, 4);
        boolean bl2 = GLLibPlayer.isFlag(n, 1);
        boolean bl3 = GLLibPlayer.isFlag(n, 2);
        int n8 = s_TilesetLayerInfo[n][2];
        int n9 = s_TilesetLayerInfo[n][3];
        byte[] byArray = s_TilesetLayerData[n][0];
        byte[] byArray2 = s_TilesetLayerData[n][1];
        int n10 = s_TilesetInfo[2];
        int n11 = s_TilesetInfo[5];
        if (bl) {
            n6 = n2 * s_TilesetInfo[2] % s_TilesetLayerInfo[n][6] + n6;
            n7 = n3 * s_TilesetInfo[5] % s_TilesetLayerInfo[n][7] + n7;
            if (n6 < 0) {
                n6 += s_TilesetLayerInfo[n][6];
            }
            if (n7 < 0) {
                n7 += s_TilesetLayerInfo[n][7];
            }
        }
        if (bl2) {
            while (n2 < 0) {
                n2 += n8;
            }
            while (n2 >= n8) {
                n2 -= n8;
            }
        } else {
            if (n2 < 0) {
                n4 += n2;
                n2 = 0;
            }
            if (n2 + n4 >= n8) {
                n4 = n8 - n2;
            }
        }
        if (bl3) {
            while (n3 < 0) {
                n3 += n9;
            }
            while (n3 >= n9) {
                n3 -= n9;
            }
        } else {
            if (n3 < 0) {
                n5 += n3;
                n3 = 0;
            }
            if (n3 + n5 >= n9 && (n5 = n9 - n3) == 0) {
                return;
            }
        }
        while (n5-- >= 0) {
            int n12 = n6;
            int n13 = n4;
            int n14 = n2;
            while (n13-- >= 0) {
                int n15;
                int n16;
                int n17 = n14 + n3 * n8;
                if (n17 << 1 < byArray.length && (n16 = (n15 = GLLib.Mem_GetShort(byArray, n17 << 1) & 0xFFFF) == 65535 ? 1 : 0) == 0) {
                    n17 = byArray2 == null ? 0 : byArray2[n17] & 0xFF;
                    if (s_TilesetSprite[n].GetFrameCount() == 0) {
                        s_TilesetSprite[n].PaintModule(graphics, n15, n12, n7, n17);
                    } else {
                        n16 = n12;
                        int n18 = n7;
                        if ((n17 & 1) != 0) {
                            n16 += s_TilesetInfo[2];
                        }
                        if ((n17 & 2) != 0) {
                            n18 += s_TilesetInfo[5];
                        }
                        int n19 = n17;
                        int n20 = n18;
                        n18 = n16;
                        n16 = n15;
                        Graphics graphics2 = graphics;
                        ASprite aSprite = s_TilesetSprite[n];
                        aSprite.PaintFrame(graphics2, n16, n18, n20, n19, 0, 0);
                    }
                }
                if (++n14 >= n8) {
                    if (!bl2) break;
                    n14 = 0;
                }
                if (!bl || (n12 += n10) < s_TilesetLayerInfo[n][6]) continue;
                n12 = 0;
            }
            if (++n3 >= n9) {
                if (!bl3) break;
                n3 = 0;
            }
            if (!bl || (n7 += n11) < s_TilesetLayerInfo[n][7]) continue;
            n7 = 0;
        }
    }

    private static final int Tileset_GetTranslatedOriginY(int n, int n2) {
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][5] - s_TilesetInfo[1] - n2;
        }
        return n2;
    }

    static final void Tileset_SetCamera(int n, int n2, int n3) {
        GLLibPlayer.s_TilesetLayerInfo[1][12] = n2;
        GLLibPlayer.s_TilesetLayerInfo[1][13] = GLLibPlayer.Tileset_GetTranslatedOriginY(1, n3);
        if (!GLLibPlayer.isFlag(1, 1)) {
            if (s_TilesetLayerInfo[1][12] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[1][12] = 0;
            } else if (s_TilesetLayerInfo[1][12] + s_TilesetInfo[0] > s_TilesetLayerInfo[1][4]) {
                GLLibPlayer.s_TilesetLayerInfo[1][12] = s_TilesetLayerInfo[1][4] - s_TilesetInfo[0];
            }
        }
        if (!GLLibPlayer.isFlag(1, 2)) {
            if (s_TilesetLayerInfo[1][13] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[1][13] = 0;
                return;
            }
            if (s_TilesetLayerInfo[1][13] + s_TilesetInfo[1] > s_TilesetLayerInfo[1][5]) {
                GLLibPlayer.s_TilesetLayerInfo[1][13] = s_TilesetLayerInfo[1][5] - s_TilesetInfo[1];
            }
        }
    }

    static final int Tileset_GetCameraY(int n) {
        if (GLLibPlayer.isFlag(1, 8)) {
            return s_TilesetLayerInfo[1][5] - s_TilesetInfo[1] - s_TilesetLayerInfo[1][13];
        }
        return s_TilesetLayerInfo[1][13];
    }

    static final int Tileset_GetTile(int n, int n2, int n3) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(1, n3);
        return GLLib.Mem_GetShort(s_TilesetLayerData[1][0], n3 * s_TilesetLayerInfo[1][2] + n2 << 1) & 0xFFFF;
    }

    static final int Tileset_GetTileFlags(int n, int n2, int n3) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(1, n3);
        if (s_TilesetLayerData[1][1] == null) {
            return 0;
        }
        return s_TilesetLayerData[1][1][n3 * s_TilesetLayerInfo[1][2] + n2] & 0xFF;
    }

    static {
        s_snd_IgnoreSoundsOnInterrupt = false;
        s_bTilesetPlayerInitialized = false;
        s_TilesetMaxLayerCount = 4;
        s_TilesetEffectLayer = -1;
        s_TilesetAlphaLayer = -1;
        s_TilesetEffectType = 0;
    }
}

