/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.Level;
import sk.inlogic.Level2;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.util.Common;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;

public class Game {
    private ScreenMain screen;
    private int iCirclePriemer;
    private int iCirclePolomer;
    private int iOffY;
    private int iCircleMidX;
    private int iCircleMidY;
    private int iDotPriemer;
    private int iDotPolomer;
    private int iDotsMidX;
    private int iDotsMidY;
    private int iDotsRadius;
    private int[][] iDotsPositions;
    private int[] dots;
    private int[] dotsColors;
    private int iThrowDotsStartY;
    private int iOffThrowY;
    private int iThrowingIndex;
    private boolean isThrowing;
    private boolean isMerging;
    private int mergingCounter;
    private int posThrowingDotY;
    private int throwSpeed;
    private int iThrowAnimDotsOff;
    private int iThrowAnimDotsOffStep;
    private int iSpeedTimeCounter;
    private int iSpeedIdx;
    private int iCurrentCircleColor;
    private int dotsBgDecorY;
    private boolean isWin;
    private boolean gameOverComming;
    private int gameOverCounter;
    public boolean isInited;
    public boolean isEndless;
    private int[] dotsEndless;
    private int[] dotsColorsEndless;
    public boolean bPause;
    private int[] mergingDots;
    private int mergingDot;
    private float[] mergingSpeeds;
    private boolean[] around;
    private boolean getSpeed;
    private int rainbowDot;
    private boolean changeRainbowDot = false;
    private boolean rainbowDotColor = false;
    private boolean isDoubleMerge = false;
    public int score;
    private int addScore = 0;
    private int shakeX = 0;
    private int shakeFailX = 0;
    private boolean bShake = false;
    private int shakeCounter = 2;
    private int shakeFail = -1;
    private boolean bScreenFlash = false;
    private int shake = 0;
    private int colorDiff = 0;

    public Game(ScreenMain screen) {
        this.screen = screen;
        this.iOffY = screen.fontMain.getHeight() << 1;
        this.iCirclePriemer = ScreenMain.imgCircle.getWidth();
        this.iCirclePolomer = this.iCirclePriemer >> 1;
        this.iCircleMidX = MainCanvas.WIDTH >> 1;
        this.iCircleMidY = MainCanvas.HEIGHT > 320 ? (MainCanvas.HEIGHT >> 1) - (ScreenMain.imgCircle.getHeight() >> 1) : this.iOffY + ScreenMain.sprCover45.getHeight();
        this.iDotPriemer = (this.iCirclePriemer >> 2) - (this.iCirclePriemer >> 4);
        this.iDotPolomer = this.iDotPriemer >> 1;
        this.iDotsMidX = this.iCircleMidX - this.iDotPolomer;
        this.iDotsMidY = this.iCircleMidY - this.iDotPolomer;
        this.iDotsRadius = ScreenMain.sprCover0.getHeight() - this.iDotPriemer;
        this.iDotsPositions = new int[360][2];
        this.iThrowDotsStartY = MainCanvas.HEIGHT > 320 ? this.iCircleMidY + this.iDotPolomer + (ScreenMain.sprCover0.getHeight() << 1) - ScreenMain.sprCover45.getHeight() : this.iOffY + (ScreenMain.sprCover0.getHeight() << 1) + this.iDotPolomer;
        this.posThrowingDotY = this.iThrowDotsStartY;
        this.throwSpeed = ScreenMain.sprCover0.getHeight() >> 3;
        this.iThrowAnimDotsOffStep = this.iDotPolomer + this.iDotPriemer >> 2;
        this.iSpeedTimeCounter = 0;
        this.colorDiff = 0;
        if (this.iThrowAnimDotsOffStep == 0) {
            this.iThrowAnimDotsOffStep = 1;
        }
        for (int i = 0; i < this.iDotsPositions.length; ++i) {
            this.iDotsPositions[i][0] = this.iDotsMidX + (this.iDotsRadius * Common.COS(i) >> 8);
            this.iDotsPositions[i][1] = this.iDotsMidY + (this.iDotsRadius * Common.SIN(i) >> 8);
        }
        this.iCurrentCircleColor = 1844266;
    }

    public void init(int lvl) {
        int tmp;
        int i;
        this.isInited = false;
        if (lvl > Level.LAST_LEVEL) {
            Level2.loadLevel(lvl);
        } else {
            Level.loadLevel(lvl);
        }
        this.bPause = false;
        this.gameOverComming = false;
        this.gameOverCounter = 0;
        this.iThrowingIndex = 100;
        this.isThrowing = false;
        this.iThrowAnimDotsOff = 0;
        this.posThrowingDotY = this.iThrowDotsStartY;
        this.isWin = false;
        this.iSpeedTimeCounter = 0;
        this.iSpeedIdx = 0;
        this.iCurrentCircleColor = 1844266;
        this.colorDiff = 0;
        this.dotsBgDecorY = 0;
        this.shake = 0;
        this.shakeX = 0;
        this.shakeFailX = 0;
        this.bShake = false;
        this.shakeCounter = 2;
        this.shakeFail = -1;
        this.bScreenFlash = false;
        this.dots = new int[30];
        this.dotsColors = new int[30];
        for (i = 0; i < this.dots.length; ++i) {
            this.dots[i] = -100;
        }
        if (lvl > Level.LAST_LEVEL) {
            for (i = 0; i < Level2.throwDots.length; ++i) {
                this.dots[i] = -1 - i;
                this.dotsColors[i] = Level2.throwDots[i];
            }
        } else {
            for (i = 0; i < Level.throwDots.length; ++i) {
                this.dots[i] = -1 - i;
                this.dotsColors[i] = Level.throwDots[i];
            }
        }
        if (lvl > Level.LAST_LEVEL) {
            if (Level2.circleDots != null) {
                tmp = 0;
                for (int i2 = Level2.throwDots.length; i2 < Level2.circleDots.length + Level2.throwDots.length; ++i2) {
                    this.dots[i2] = Level2.circleDots[tmp++];
                    this.dotsColors[i2] = 1844266;
                }
            }
        } else if (Level.circleDots != null) {
            tmp = 0;
            for (int i3 = Level.throwDots.length; i3 < Level.circleDots.length + Level.throwDots.length; ++i3) {
                this.dots[i3] = Level.circleDots[tmp++];
                this.dotsColors[i3] = 1844266;
            }
        }
        this.isInited = true;
    }

    public void initEndless() {
        int i;
        int randomNum;
        this.isInited = false;
        this.bPause = false;
        this.gameOverComming = false;
        this.gameOverCounter = 0;
        this.iThrowingIndex = 100;
        this.isThrowing = false;
        this.isMerging = false;
        this.mergingCounter = 0;
        this.iThrowAnimDotsOff = 0;
        this.posThrowingDotY = this.iThrowDotsStartY;
        this.isWin = false;
        this.iSpeedTimeCounter = 0;
        this.iSpeedIdx = 0;
        this.iCurrentCircleColor = 1844266;
        this.colorDiff = 0;
        this.dotsBgDecorY = 0;
        this.dots = new int[20];
        this.dotsEndless = new int[30];
        this.dotsColors = new int[20];
        this.dotsColorsEndless = new int[30];
        this.score = 0;
        this.shake = 0;
        this.shakeX = 0;
        this.shakeFailX = 0;
        this.bShake = false;
        this.shakeCounter = 2;
        this.shakeFail = -1;
        this.bScreenFlash = false;
        Level.colors = null;
        Level2.colors = null;
        Level.covers = null;
        Level2.covers = null;
        int[] randColors = new int[]{16766720, 52224, 0x88CCFF, 0xFF0000};
        this.rainbowDot = randomNum = RandomNum.getRandomUInt(11) + 10;
        for (i = 0; i < this.dots.length; ++i) {
            this.dots[i] = -1 - i;
            if (this.dots[i] == -this.rainbowDot) {
                this.dotsColors[i] = 0;
                continue;
            }
            randomNum = RandomNum.getRandomUInt(4);
            this.dotsColors[i] = randColors[randomNum];
        }
        randomNum = RandomNum.getRandomUInt(11) + 10;
        this.rainbowDot += randomNum;
        for (i = 0; i < this.dotsEndless.length; ++i) {
            this.dotsEndless[i] = -100;
            this.dotsColorsEndless[i] = -100;
        }
        this.isInited = true;
    }

    public void pause() {
        if (!this.gameOverComming) {
            this.bPause = true;
            this.screen.playMusic(Sounds.MUSIC_MENU, -1);
            this.screen.getClass();
            this.screen.getClass();
            this.screen.nextScreen(1, 0);
        }
    }

    public void update(long ltick) {
        if (this.isInited) {
            if (this.isEndless) {
                this.endless(ltick);
            } else {
                if (this.gameOverComming) {
                    this.gameOverCounter = (int)((long)this.gameOverCounter + ltick);
                    if (!this.isWin) {
                        this.shakeFailX = this.shakeUpdate();
                    } else if (this.isWin) {
                        if (this.gameOverCounter < 600) {
                            for (int j = 0; j < 50; ++j) {
                                for (int i = 0; i < this.dots.length; ++i) {
                                    if (this.dots[i] <= -1) continue;
                                    int n = i;
                                    this.dots[n] = this.dots[n] - 1;
                                    if (this.dots[i] >= 360) {
                                        this.dots[i] = this.dots[i] - 360;
                                    }
                                    if (this.dots[i] >= 0) continue;
                                    this.dots[i] = 360 + this.dots[i];
                                }
                            }
                        } else if (this.gameOverCounter < 800) {
                            this.shakeX = this.shakeUpdate();
                        } else {
                            this.bScreenFlash = this.gameOverCounter < 900;
                        }
                    }
                    if (this.gameOverCounter > 250) {
                        this.screen.getClass();
                        this.screen.nextScreen(2, 1);
                    }
                    return;
                }
                if (this.screen.iSelectedLevel > Level.LAST_LEVEL) {
                    if (Level2.times == null) {
                        for (int i = 0; i < this.dots.length; ++i) {
                            if (this.dots[i] <= -1) continue;
                            int n = i;
                            this.dots[n] = this.dots[n] - Level2.speeds[this.iSpeedIdx];
                            if (this.dots[i] >= 360) {
                                this.dots[i] = this.dots[i] - 360;
                            }
                            if (this.dots[i] >= 0) continue;
                            this.dots[i] = 360 + this.dots[i];
                        }
                    } else {
                        this.iSpeedTimeCounter = (int)((long)this.iSpeedTimeCounter + ltick);
                        if (this.iSpeedTimeCounter > Level2.times[this.iSpeedIdx]) {
                            this.iSpeedTimeCounter = 0;
                            ++this.iSpeedIdx;
                            if (this.iSpeedIdx >= Level2.times.length) {
                                this.iSpeedIdx = 0;
                            }
                        }
                        for (int i = 0; i < this.dots.length; ++i) {
                            if (this.dots[i] <= -1) continue;
                            int n = i;
                            this.dots[n] = this.dots[n] - Level2.speeds[this.iSpeedIdx];
                            if (this.dots[i] >= 360) {
                                this.dots[i] = this.dots[i] - 360;
                            }
                            if (this.dots[i] >= 0) continue;
                            this.dots[i] = 360 + this.dots[i];
                        }
                    }
                } else if (Level.times == null) {
                    for (int i = 0; i < this.dots.length; ++i) {
                        if (this.dots[i] <= -1) continue;
                        int n = i;
                        this.dots[n] = this.dots[n] - Level.speeds[this.iSpeedIdx];
                        if (this.dots[i] >= 360) {
                            this.dots[i] = this.dots[i] - 360;
                        }
                        if (this.dots[i] >= 0) continue;
                        this.dots[i] = 360 + this.dots[i];
                    }
                } else {
                    this.iSpeedTimeCounter = (int)((long)this.iSpeedTimeCounter + ltick);
                    if (this.iSpeedTimeCounter > Level.times[this.iSpeedIdx]) {
                        this.iSpeedTimeCounter = 0;
                        ++this.iSpeedIdx;
                        if (this.iSpeedIdx >= Level.times.length) {
                            this.iSpeedIdx = 0;
                        }
                    }
                    for (int i = 0; i < this.dots.length; ++i) {
                        if (this.dots[i] <= -1) continue;
                        int n = i;
                        this.dots[n] = this.dots[n] - Level.speeds[this.iSpeedIdx];
                        if (this.dots[i] >= 360) {
                            this.dots[i] = this.dots[i] - 360;
                        }
                        if (this.dots[i] >= 0) continue;
                        this.dots[i] = 360 + this.dots[i];
                    }
                }
                if (this.screen.iSelectedLevel > Level.LAST_LEVEL) {
                    this.updateColorCircle(Level2.speeds);
                } else {
                    this.updateColorCircle(Level.speeds);
                }
                if (this.isThrowing) {
                    this.posThrowingDotY -= this.throwSpeed;
                    this.iThrowAnimDotsOff = this.iThrowAnimDotsOff < this.iDotPolomer + this.iDotPriemer ? (this.iThrowAnimDotsOff += this.iThrowAnimDotsOffStep) : this.iDotPolomer + this.iDotPriemer;
                    if (this.posThrowingDotY <= this.iDotsPositions[90][1]) {
                        if (!this.isCollision()) {
                            if (this.dotsColors[this.iThrowingIndex] == this.iCurrentCircleColor) {
                                this.dots[this.iThrowingIndex] = 90;
                                this.isThrowing = false;
                                this.posThrowingDotY = this.iThrowDotsStartY;
                                if (this.isLast()) {
                                    this.isWin = true;
                                    if (Profile.iLevel < Level2.LAST_LEVEL && Profile.iLevel == this.screen.iSelectedLevel) {
                                        this.screen.iSelectedLevel = ++Profile.iLevel;
                                        Profile.save();
                                    } else if (this.screen.iSelectedLevel < Profile.iLevel) {
                                        ++this.screen.iSelectedLevel;
                                    }
                                    this.bPause = false;
                                    this.gameOverComming = true;
                                } else if (this.screen.iSelectedLevel > Level.LAST_LEVEL) {
                                    if (Level2.changeSpeedOnInput) {
                                        ++this.iSpeedIdx;
                                        if (this.iSpeedIdx >= Level2.speeds.length) {
                                            this.iSpeedIdx = 0;
                                        }
                                    }
                                } else if (this.screen.iSelectedLevel < Level.LAST_LEVEL && Level.changeSpeedOnInput) {
                                    ++this.iSpeedIdx;
                                    if (this.iSpeedIdx >= Level.speeds.length) {
                                        this.iSpeedIdx = 0;
                                    }
                                }
                            } else {
                                this.dots[this.iThrowingIndex] = 90;
                                this.isThrowing = false;
                                this.isWin = false;
                                this.bPause = false;
                                this.gameOverComming = true;
                            }
                        } else {
                            this.isWin = false;
                            this.bPause = false;
                            this.gameOverComming = true;
                        }
                    }
                }
            }
        }
    }

    public void endless(long ltick) {
        int i;
        if (this.gameOverComming) {
            this.gameOverCounter = (int)((long)this.gameOverCounter + ltick);
            if (!this.isWin) {
                this.shakeFailX = this.shakeUpdate();
            }
            if (this.gameOverCounter > 250) {
                this.screen.getClass();
                this.screen.nextScreen(2, 1);
            }
            return;
        }
        if (this.isMerging) {
            if (this.dotsColorsEndless[this.mergingDot] == 0 && this.changeRainbowDot) {
                this.rainbowDotColor = this.mergingSpeeds[0] < this.mergingSpeeds[1];
                this.changeRainbowDot = false;
                this.isDoubleMerge = true;
            }
            if (this.getSpeed) {
                for (i = 0; i < this.mergingDots.length; ++i) {
                    this.mergingSpeeds[i] = this.dotsEndless[this.mergingDots[i]] > this.dotsEndless[this.mergingDot] && (this.dotsEndless[this.mergingDots[i]] < 270 && !this.around[i] || this.dotsEndless[this.mergingDots[i]] >= 270 && this.around[i]) ? 4.0f + this.mergingSpeeds[i] : (this.dotsEndless[this.mergingDots[i]] < this.dotsEndless[this.mergingDot] && this.dotsEndless[this.mergingDots[i]] < 90 && this.around[i] ? 4.0f + this.mergingSpeeds[i] : 4.0f - this.mergingSpeeds[i]);
                }
                this.getSpeed = false;
            }
            for (i = 0; i < this.dotsEndless.length; ++i) {
                if (this.dotsEndless[i] <= -1) continue;
                boolean inMergingDots = false;
                for (int j = 0; j < this.mergingDots.length; ++j) {
                    if (i != this.mergingDots[j]) continue;
                    int n = this.mergingDots[j];
                    this.dotsEndless[n] = (int)((float)this.dotsEndless[n] - this.mergingSpeeds[j]);
                    inMergingDots = true;
                    break;
                }
                if (!inMergingDots) {
                    int n = i;
                    this.dotsEndless[n] = this.dotsEndless[n] - 4;
                }
                if (this.dotsEndless[i] >= 360) {
                    this.dotsEndless[i] = this.dotsEndless[i] - 360;
                }
                if (this.dotsEndless[i] >= 0) continue;
                this.dotsEndless[i] = 360 + this.dotsEndless[i];
            }
        } else {
            for (int j = 0; j < 4; ++j) {
                for (int i2 = 0; i2 < this.dotsEndless.length; ++i2) {
                    if (this.dotsEndless[i2] <= -1) continue;
                    int n = i2;
                    this.dotsEndless[n] = this.dotsEndless[n] - 1;
                    if (this.dotsEndless[i2] >= 360) {
                        this.dotsEndless[i2] = this.dotsEndless[i2] - 360;
                    }
                    if (this.dotsEndless[i2] >= 0) continue;
                    this.dotsEndless[i2] = 360 + this.dotsEndless[i2];
                }
            }
        }
        if (this.isThrowing && !this.isMerging) {
            this.posThrowingDotY -= this.throwSpeed;
            this.iThrowAnimDotsOff = this.iThrowAnimDotsOff < this.iDotPolomer + this.iDotPriemer ? (this.iThrowAnimDotsOff += this.iThrowAnimDotsOffStep) : this.iDotPolomer + this.iDotPriemer;
            if (this.posThrowingDotY <= this.iDotsPositions[90][1]) {
                if (!this.isCollision()) {
                    ++this.score;
                    for (i = 0; i < this.dotsEndless.length; ++i) {
                        if (this.dotsEndless[i] != -100) continue;
                        this.dotsEndless[i] = 90;
                        this.dotsColorsEndless[i] = this.dotsColors[this.iThrowingIndex];
                        break;
                    }
                    this.merge();
                    for (i = 0; i < this.dots.length; ++i) {
                        if (i + 1 == this.dots.length) {
                            int randomNum;
                            this.dots[i] = this.dots[i - 1] - 1;
                            if (this.dots[i] == -this.rainbowDot) {
                                this.dotsColors[i] = 0;
                                int randomNum2 = RandomNum.getRandomUInt(11) + 10;
                                this.rainbowDot += randomNum2;
                                break;
                            }
                            if (this.dots[i] >= -25) {
                                int[] randColors = new int[]{16766720, 52224, 0x88CCFF, 0xFF0000};
                                randomNum = RandomNum.getRandomUInt(4);
                                this.dotsColors[i] = randColors[randomNum];
                                break;
                            }
                            if (this.dots[i] >= -50) {
                                int[] randColors = new int[]{16766720, 52224, 0x88CCFF, 0xFF0000, 0x800080};
                                randomNum = RandomNum.getRandomUInt(5);
                                this.dotsColors[i] = randColors[randomNum];
                                break;
                            }
                            if (this.dots[i] >= -75) {
                                int[] randColors = new int[]{16766720, 52224, 0x88CCFF, 0xFF0000, 0x800080, 16738740};
                                randomNum = RandomNum.getRandomUInt(6);
                                this.dotsColors[i] = randColors[randomNum];
                                break;
                            }
                            int[] randColors = new int[]{16766720, 52224, 0x88CCFF, 0xFF0000, 0x800080, 16738740, 139};
                            randomNum = RandomNum.getRandomUInt(7);
                            this.dotsColors[i] = randColors[randomNum];
                            break;
                        }
                        this.dots[i] = this.dots[i + 1];
                        this.dotsColors[i] = this.dotsColors[i + 1];
                    }
                    this.isThrowing = false;
                    this.posThrowingDotY = this.iThrowDotsStartY;
                } else {
                    this.isWin = false;
                    this.bPause = false;
                    this.gameOverComming = true;
                    if (this.score > Profile.endlessHighScore) {
                        Profile.endlessHighScore = this.score;
                        Profile.save();
                    }
                }
            }
        } else if (this.isMerging) {
            this.mergingCounter = (int)((long)this.mergingCounter + ltick);
            if (this.mergingCounter > 200) {
                if (this.dotsColorsEndless[this.mergingDot] == 0) {
                    this.dotsColorsEndless[this.mergingDot] = this.rainbowDotColor ? this.dotsColorsEndless[this.mergingDots[0]] : this.dotsColorsEndless[this.mergingDots[1]];
                }
                for (i = 0; i < this.mergingDots.length; ++i) {
                    this.dotsEndless[this.mergingDots[i]] = -100;
                    this.dotsColorsEndless[this.mergingDots[i]] = -100;
                }
                this.mergingCounter = 0;
                this.score += this.addScore;
                this.addScore = 0;
                this.isThrowing = false;
                this.isMerging = false;
                if (this.isDoubleMerge) {
                    this.merge();
                    this.isDoubleMerge = false;
                }
            }
        }
    }

    private void merge() {
        int length = 0;
        for (int i = 0; i < this.dotsEndless.length; ++i) {
            if (this.dotsEndless[i] <= -100) continue;
            ++length;
        }
        int[] dotsNonSorted = new int[length];
        int[] colorsNonSorted = new int[length];
        int temp = 0;
        for (int i = 0; i < this.dotsEndless.length; ++i) {
            if (this.dotsEndless[i] <= -100) continue;
            dotsNonSorted[temp] = this.dotsEndless[i];
            colorsNonSorted[temp] = this.dotsColorsEndless[i];
            ++temp;
        }
        int[][] endlessSorted = new int[2][length];
        endlessSorted = this.sortArray(dotsNonSorted, colorsNonSorted, length);
        if (length >= 3 && !this.isMerging) {
            for (int i = 0; i < length; ++i) {
                if (endlessSorted[0][i] == 90 && endlessSorted[1][i] != 0 && !this.isDoubleMerge) {
                    this.around = new boolean[]{false, false};
                    this.mergingDots = new int[2];
                    if (i == 0 && endlessSorted[1][i] == endlessSorted[1][length - 1] && endlessSorted[1][i] == endlessSorted[1][length - 2]) {
                        if (endlessSorted[1][i] != endlessSorted[1][i + 1]) {
                            if (endlessSorted[0][length - 1] <= 270) {
                                this.around[0] = true;
                            }
                            if (endlessSorted[0][length - 2] <= 270) {
                                this.around[1] = true;
                            }
                        }
                        this.mergingDots[0] = endlessSorted[0][length - 1];
                        this.mergingDots[1] = endlessSorted[0][length - 2];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i == 1 && endlessSorted[1][i] == endlessSorted[1][length - 1] && endlessSorted[1][i] == endlessSorted[1][0]) {
                        if (endlessSorted[1][i] != endlessSorted[1][i + 1] && endlessSorted[0][length - 1] <= 270) {
                            this.around[1] = true;
                        }
                        this.mergingDots[0] = endlessSorted[0][0];
                        this.mergingDots[1] = endlessSorted[0][length - 1];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i != 0 && i != 1 && endlessSorted[1][i] == endlessSorted[1][i - 1] && endlessSorted[1][i] == endlessSorted[1][i - 2]) {
                        this.mergingDots[0] = endlessSorted[0][i - 1];
                        this.mergingDots[1] = endlessSorted[0][i - 2];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i == length - 1 && endlessSorted[1][i] == endlessSorted[1][0] && endlessSorted[1][i] == endlessSorted[1][1]) {
                        if (endlessSorted[1][i] != endlessSorted[1][i - 1]) {
                            if (endlessSorted[0][0] >= 270 || endlessSorted[0][0] < 90) {
                                this.around[0] = true;
                            }
                            if (endlessSorted[0][1] >= 270 || endlessSorted[0][1] < 90) {
                                this.around[1] = true;
                            }
                        }
                        this.mergingDots[0] = endlessSorted[0][0];
                        this.mergingDots[1] = endlessSorted[0][1];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i == length - 2 && endlessSorted[1][i] == endlessSorted[1][length - 1] && endlessSorted[1][i] == endlessSorted[1][0]) {
                        if (endlessSorted[1][i] != endlessSorted[1][i - 1]) {
                            if (endlessSorted[0][length - 1] >= 270 || endlessSorted[0][length - 1] < 90) {
                                this.around[0] = true;
                            }
                            if (endlessSorted[0][0] >= 270 || endlessSorted[0][0] < 90) {
                                this.around[1] = true;
                            }
                        }
                        this.mergingDots[0] = endlessSorted[0][length - 1];
                        this.mergingDots[1] = endlessSorted[0][0];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i != length - 1 && i != length - 2 && endlessSorted[1][i] == endlessSorted[1][i + 1] && endlessSorted[1][i] == endlessSorted[1][i + 2]) {
                        if (i == 0) {
                            if (endlessSorted[1][i] != endlessSorted[1][length - 1]) {
                                if (endlessSorted[0][i + 1] >= 270 || endlessSorted[0][i + 1] < 90) {
                                    this.around[0] = true;
                                }
                                if (endlessSorted[0][i + 2] >= 270 || endlessSorted[0][i + 2] < 90) {
                                    this.around[1] = true;
                                }
                            }
                        } else if (endlessSorted[1][i] != endlessSorted[1][i - 1]) {
                            if (endlessSorted[0][i + 1] >= 270 || endlessSorted[0][i + 1] < 90) {
                                this.around[0] = true;
                            }
                            if (endlessSorted[0][i + 2] >= 270 || endlessSorted[0][i + 2] < 90) {
                                this.around[1] = true;
                            }
                        }
                        this.mergingDots[0] = endlessSorted[0][i + 1];
                        this.mergingDots[1] = endlessSorted[0][i + 2];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i == 0 && endlessSorted[1][i] == endlessSorted[1][length - 1] && endlessSorted[1][i] == endlessSorted[1][i + 1]) {
                        if (endlessSorted[1][i] != endlessSorted[1][i + 2]) {
                            if (endlessSorted[0][length - 1] <= 270) {
                                this.around[0] = true;
                            }
                            if (endlessSorted[0][i + 1] >= 270) {
                                this.around[1] = true;
                            }
                        }
                        this.mergingDots[0] = endlessSorted[0][length - 1];
                        this.mergingDots[1] = endlessSorted[0][i + 1];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i == length - 1 && endlessSorted[1][i] == endlessSorted[1][i - 1] && endlessSorted[1][i] == endlessSorted[1][0]) {
                        if (endlessSorted[1][i] != endlessSorted[1][i - 2]) {
                            this.around[1] = true;
                        }
                        this.mergingDots[0] = endlessSorted[0][i - 1];
                        this.mergingDots[1] = endlessSorted[0][0];
                        this.mergeDots(this.mergingDots, this.around);
                        break;
                    }
                    if (i == 0 || i == length - 1 || endlessSorted[1][i] != endlessSorted[1][i - 1] || endlessSorted[1][i] != endlessSorted[1][i + 1]) break;
                    if (i == length - 2) {
                        if (endlessSorted[1][i] != endlessSorted[1][i - 2] && endlessSorted[0][i + 1] >= 270) {
                            this.around[1] = true;
                        }
                    } else if (endlessSorted[1][i] != endlessSorted[1][i + 2] && endlessSorted[0][i + 1] >= 270) {
                        this.around[1] = true;
                    }
                    this.mergingDots[0] = endlessSorted[0][i - 1];
                    this.mergingDots[1] = endlessSorted[0][i + 1];
                    this.mergeDots(this.mergingDots, this.around);
                    break;
                }
                if (endlessSorted[0][i] == 90 && endlessSorted[1][i] == 0 && !this.isDoubleMerge) {
                    this.around = new boolean[]{false, false};
                    this.mergingDots = new int[2];
                    if (i == 0) {
                        if (endlessSorted[0][length - 1] <= 270) {
                            this.around[0] = true;
                        }
                        if (endlessSorted[0][i + 1] >= 270 || endlessSorted[0][i + 1] < 90) {
                            this.around[1] = true;
                        }
                        this.mergingDots[0] = endlessSorted[0][length - 1];
                        this.mergingDots[1] = endlessSorted[0][i + 1];
                        this.mergeDots(this.mergingDots, this.around);
                    } else if (i == length - 1) {
                        this.around[1] = true;
                        this.mergingDots[0] = endlessSorted[0][i - 1];
                        this.mergingDots[1] = endlessSorted[0][0];
                        this.mergeDots(this.mergingDots, this.around);
                    } else if (i != 0 && i != length - 1) {
                        if (endlessSorted[0][i + 1] >= 270 || endlessSorted[0][i + 1] < 90) {
                            this.around[1] = true;
                        }
                        this.mergingDots[0] = endlessSorted[0][i - 1];
                        this.mergingDots[1] = endlessSorted[0][i + 1];
                        this.mergeDots(this.mergingDots, this.around);
                    }
                    this.changeRainbowDot = true;
                    break;
                }
                if (endlessSorted[0][i] != this.dotsEndless[this.mergingDot] || !this.isDoubleMerge) continue;
                this.around = new boolean[]{false, false, false, false};
                int[] mergingDotsTemp = new int[4];
                int k = 0;
                if (i == 0) {
                    if (endlessSorted[1][i] == endlessSorted[1][length - 2] && endlessSorted[1][i] == endlessSorted[1][length - 1]) {
                        if (endlessSorted[0][length - 2] <= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][length - 2];
                        ++k;
                        if (endlessSorted[0][length - 1] <= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][length - 1];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][length - 1]) {
                        if (endlessSorted[0][length - 1] <= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][length - 1];
                        ++k;
                    }
                    if (endlessSorted[1][i] == endlessSorted[1][i + 1] && endlessSorted[1][i] == endlessSorted[1][i + 2]) {
                        if (endlessSorted[0][i + 1] >= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 1];
                        ++k;
                        if (endlessSorted[0][i + 2] >= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 2];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][i + 1]) {
                        if (endlessSorted[0][i + 1] >= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 1];
                        ++k;
                    }
                    if (k >= 2) {
                        this.mergingDots = new int[k];
                        for (int j = 0; j < this.mergingDots.length; ++j) {
                            this.mergingDots[j] = mergingDotsTemp[j];
                        }
                        this.mergeDots(this.mergingDots, this.around);
                    }
                } else if (i == 1) {
                    if (endlessSorted[1][i] == endlessSorted[1][0] && endlessSorted[1][i] == endlessSorted[1][length - 1]) {
                        if (endlessSorted[0][length - 1] <= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][length - 1];
                        mergingDotsTemp[++k] = endlessSorted[0][0];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][0]) {
                        mergingDotsTemp[k] = endlessSorted[0][0];
                        ++k;
                    }
                    if (endlessSorted[1][i] == endlessSorted[1][i + 1] && endlessSorted[1][i] == endlessSorted[1][i + 2]) {
                        if (endlessSorted[0][i + 1] >= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 1];
                        ++k;
                        if (endlessSorted[0][i + 2] >= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 2];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][i + 1]) {
                        if (endlessSorted[0][i + 1] >= 270) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 1];
                        ++k;
                    }
                    if (k >= 2) {
                        this.mergingDots = new int[k];
                        for (int j = 0; j < this.mergingDots.length; ++j) {
                            this.mergingDots[j] = mergingDotsTemp[j];
                        }
                        this.mergeDots(this.mergingDots, this.around);
                    }
                } else if (i == length - 1) {
                    if (endlessSorted[1][i] == endlessSorted[1][i - 1] && endlessSorted[1][i] == endlessSorted[1][i - 2]) {
                        mergingDotsTemp[k] = endlessSorted[0][i - 1];
                        mergingDotsTemp[++k] = endlessSorted[0][i - 2];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][i - 1]) {
                        mergingDotsTemp[k] = endlessSorted[0][i - 1];
                        ++k;
                    }
                    if (endlessSorted[1][i] == endlessSorted[1][0] && endlessSorted[1][i] == endlessSorted[1][1]) {
                        if (endlessSorted[0][0] >= 270 || endlessSorted[0][0] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][0];
                        ++k;
                        if (endlessSorted[0][1] >= 270 || endlessSorted[0][1] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][1];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][0]) {
                        if (endlessSorted[0][0] >= 270 || endlessSorted[0][0] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][0];
                        ++k;
                    }
                    if (k >= 2) {
                        this.mergingDots = new int[k];
                        for (int j = 0; j < this.mergingDots.length; ++j) {
                            this.mergingDots[j] = mergingDotsTemp[j];
                        }
                        this.mergeDots(this.mergingDots, this.around);
                    }
                } else if (i == length - 2) {
                    if (endlessSorted[1][i] == endlessSorted[1][i - 1] && endlessSorted[1][i] == endlessSorted[1][i - 2]) {
                        mergingDotsTemp[k] = endlessSorted[0][i - 1];
                        mergingDotsTemp[++k] = endlessSorted[0][i - 2];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][i - 1]) {
                        mergingDotsTemp[k] = endlessSorted[0][i - 1];
                        ++k;
                    }
                    if (endlessSorted[1][i] == endlessSorted[1][0] && endlessSorted[1][i] == endlessSorted[1][length - 1]) {
                        if (endlessSorted[0][length - 1] >= 270 || endlessSorted[0][length - 1] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][length - 1];
                        ++k;
                        if (endlessSorted[0][0] >= 270 || endlessSorted[0][0] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][0];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][length - 1]) {
                        if (endlessSorted[0][length - 1] >= 270 || endlessSorted[0][length - 1] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][length - 1];
                        ++k;
                    }
                    if (k >= 2) {
                        this.mergingDots = new int[k];
                        for (int j = 0; j < this.mergingDots.length; ++j) {
                            this.mergingDots[j] = mergingDotsTemp[j];
                        }
                        this.mergeDots(this.mergingDots, this.around);
                    }
                } else if (i != 0 && i != 1 && i != length - 1 && i != length - 2) {
                    if (endlessSorted[1][i] == endlessSorted[1][i - 1] && endlessSorted[1][i] == endlessSorted[1][i - 2]) {
                        mergingDotsTemp[k] = endlessSorted[0][i - 1];
                        mergingDotsTemp[++k] = endlessSorted[0][i - 2];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][i - 1]) {
                        mergingDotsTemp[k] = endlessSorted[0][i - 1];
                        ++k;
                    }
                    if (endlessSorted[1][i] == endlessSorted[1][i + 1] && endlessSorted[1][i] == endlessSorted[1][i + 2]) {
                        if (endlessSorted[0][i + 1] >= 270 || endlessSorted[0][i + 1] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 1];
                        ++k;
                        if (endlessSorted[0][i + 2] >= 270 || endlessSorted[0][i + 2] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 2];
                        ++k;
                    } else if (endlessSorted[1][i] == endlessSorted[1][i + 1]) {
                        if (endlessSorted[0][i + 1] >= 270 || endlessSorted[0][i + 1] < 90) {
                            this.around[k] = true;
                        }
                        mergingDotsTemp[k] = endlessSorted[0][i + 1];
                        ++k;
                    }
                    if (k >= 2) {
                        this.mergingDots = new int[k];
                        for (int j = 0; j < this.mergingDots.length; ++j) {
                            this.mergingDots[j] = mergingDotsTemp[j];
                        }
                        this.mergeDots(this.mergingDots, this.around);
                    }
                }
                this.isDoubleMerge = false;
                break;
            }
        }
    }

    private void mergeDots(int[] dots, boolean[] around) {
        int i;
        int i2;
        int angle = 90;
        this.isMerging = true;
        this.getSpeed = true;
        this.addScore = dots.length;
        this.mergingSpeeds = new float[dots.length];
        if (this.isDoubleMerge) {
            for (i2 = 0; i2 < this.dotsEndless.length; ++i2) {
                if (i2 != this.mergingDot) continue;
                angle = this.dotsEndless[this.mergingDot];
            }
        } else {
            for (i2 = 0; i2 < this.dotsEndless.length; ++i2) {
                if (this.dotsEndless[i2] != 90) continue;
                angle = 90;
            }
        }
        for (i2 = 0; i2 < this.mergingDots.length; ++i2) {
            this.mergingSpeeds[i2] = dots[i2] > 90 && dots[i2] < 270 && around[i2] ? ((float)dots[i2] - (float)angle + (float)((360 - angle - dots[i2]) * 2)) / 200.0f * 40.0f : (dots[i2] > 90 && dots[i2] < 270 ? ((float)dots[i2] - (float)angle) / 200.0f * 40.0f : (dots[i2] >= 270 && around[i2] ? ((float)(360 + angle) - (float)dots[i2] + (float)((dots[i2] - 360 + angle) * 2)) / 200.0f * 40.0f : (dots[i2] >= 270 ? ((float)(360 + angle) - (float)dots[i2]) / 200.0f * 40.0f : (around[i2] ? ((float)angle - (float)dots[i2] + (float)(-(-angle - dots[i2]) * 2)) / 200.0f * 40.0f : ((float)angle - (float)dots[i2]) / 200.0f * 40.0f))));
        }
        int[] tempField = new int[dots.length];
        for (i = 0; i < dots.length; ++i) {
            tempField[i] = dots[i];
        }
        for (i = 0; i < this.dotsEndless.length; ++i) {
            for (int j = 0; j < tempField.length; ++j) {
                if (this.dotsEndless[i] != tempField[j]) continue;
                this.mergingDots[j] = i;
                break;
            }
            if (this.dotsEndless[i] != 90) continue;
            this.mergingDot = i;
        }
    }

    private int shakeUpdate() {
        if (!this.bShake) {
            if (this.shakeCounter == 3) {
                this.bShake = true;
                this.shakeCounter = 0;
            } else {
                this.shake += MainCanvas.WIDTH / 120;
                ++this.shakeCounter;
            }
        } else if (this.shakeCounter == 3) {
            this.bShake = false;
            this.shakeCounter = 0;
        } else {
            this.shake -= MainCanvas.WIDTH / 120;
            ++this.shakeCounter;
        }
        return this.shake;
    }

    private int[][] sortArray(int[] dots, int[] colors, int length) {
        int[][] sortedArray = new int[2][length];
        for (int j = 0; j < length - 1; ++j) {
            for (int i = 0; i < length - 1; ++i) {
                if (dots[i] <= dots[i + 1]) continue;
                int temp = dots[i];
                dots[i] = dots[i + 1];
                dots[i + 1] = temp;
                temp = colors[i];
                colors[i] = colors[i + 1];
                colors[i + 1] = temp;
            }
        }
        for (int i = 0; i < length; ++i) {
            sortedArray[0][i] = dots[i];
            sortedArray[1][i] = colors[i];
        }
        return sortedArray;
    }

    private void updateColorCircle(int[] speeds) {
        this.colorDiff += speeds[this.iSpeedIdx];
        if (this.colorDiff > 360) {
            this.colorDiff -= 360;
        } else if (this.colorDiff < 0) {
            this.colorDiff = 360 + this.colorDiff;
        }
        if (this.screen.iSelectedLevel > Level.LAST_LEVEL) {
            this.getCircleColorOnThrow(Level2.colors);
        } else {
            this.getCircleColorOnThrow(Level.colors);
        }
    }

    private void getCircleColorOnThrow(int[] colors) {
        if (colors.length > 1) {
            if (colors.length == 2) {
                this.iCurrentCircleColor = this.colorDiff <= 90 || this.colorDiff >= 270 ? colors[1] : colors[0];
            } else if (colors.length == 3) {
                this.iCurrentCircleColor = this.colorDiff <= 30 || this.colorDiff >= 270 ? colors[2] : (this.colorDiff <= 150 ? colors[1] : colors[0]);
            } else if (colors.length == 4) {
                this.iCurrentCircleColor = this.colorDiff <= 90 ? colors[2] : (this.colorDiff <= 180 ? colors[1] : (this.colorDiff <= 270 ? colors[0] : colors[3]));
            } else if (colors.length == 6) {
                this.iCurrentCircleColor = this.colorDiff <= 30 || this.colorDiff >= 330 ? colors[4] : (this.colorDiff <= 90 ? colors[3] : (this.colorDiff <= 150 ? colors[2] : (this.colorDiff <= 210 ? colors[1] : (this.colorDiff <= 270 ? colors[0] : colors[5]))));
            }
        } else {
            this.iCurrentCircleColor = 1844266;
        }
    }

    private boolean isCollision() {
        if (this.isEndless) {
            for (int i = 0; i < this.dotsEndless.length; ++i) {
                if (this.dotsEndless[i] < 80 || this.dotsEndless[i] > 100) continue;
                this.shakeFail = this.dotsEndless[i];
                return true;
            }
        } else {
            for (int i = 0; i < this.dots.length; ++i) {
                if (this.dots[i] < 0 || this.dots[i] < 80 || this.dots[i] > 100) continue;
                this.shakeFail = this.dots[i];
                return true;
            }
        }
        return false;
    }

    public boolean isWin() {
        return this.isWin;
    }

    private boolean isLast() {
        for (int i = 0; i < this.dots.length; ++i) {
            if (this.dots[i] >= 0 || this.dots[i] <= -100) continue;
            return false;
        }
        return true;
    }

    public void paint(Graphics g) {
        if (this.bScreenFlash) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        } else {
            if (this.isEndless) {
                this.screen.strTextPom[0] = Resources.resTexts[0].getHashedString(57) + " " + this.score;
                this.screen.fontMain.drawString(g, this.screen.strTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, this.screen.fontMain.getHeight(), 3);
            } else {
                this.screen.fontMain.drawString(g, this.screen.strTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, this.screen.fontMain.getHeight(), 3);
            }
            g.setColor(0);
            g.drawImage(ScreenMain.imgCircleBg, this.iCircleMidX - (ScreenMain.imgCircleBg.getWidth() >> 1) + this.shakeX, this.iCircleMidY - (ScreenMain.imgCircleBg.getHeight() >> 1), 20);
            this.paintDots(g);
            this.paintThrowing(g);
            if (this.isThrowing) {
                this.paintThrowingDot(g);
            }
            g.drawImage(ScreenMain.imgCircle, this.iCircleMidX - (ScreenMain.imgCircle.getWidth() >> 1) + this.shakeX, this.iCircleMidY - (ScreenMain.imgCircle.getHeight() >> 1), 20);
            this.paintColorCircle(g);
            if (!this.gameOverComming) {
                this.paintCover(g);
            }
        }
    }

    private void paintColorCircle(Graphics g) {
        int[] colors = this.screen.iSelectedLevel > Level.LAST_LEVEL ? Level2.colors : Level.colors;
        if (colors == null) {
            return;
        }
        if (colors.length == 1 && colors[0] != 1844266) {
            g.setColor(colors[0]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 0, 360);
        } else if (colors.length == 2) {
            g.setColor(colors[0]);
            int draw = this.colorDiff;
            if (draw + 180 > 360) {
                draw -= 360;
            }
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, draw, 180);
            g.setColor(colors[1]);
            draw = 180 + this.colorDiff;
            if (draw + 180 > 360) {
                draw -= 360;
            }
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, draw, 180);
        } else if (colors.length == 3) {
            g.setColor(colors[0]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 0 + this.colorDiff, 120);
            g.setColor(colors[1]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 120 + this.colorDiff, 120);
            g.setColor(colors[2]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 240 + this.colorDiff, 120);
        } else if (colors.length == 4) {
            g.setColor(colors[0]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 0 + this.colorDiff, 90);
            g.setColor(colors[1]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 90 + this.colorDiff, 90);
            g.setColor(colors[2]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 180 + this.colorDiff, 90);
            g.setColor(colors[3]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 270 + this.colorDiff, 90);
        } else if (colors.length == 6) {
            g.setColor(colors[0]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 0 + this.colorDiff, 60);
            g.setColor(colors[1]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 60 + this.colorDiff, 60);
            g.setColor(colors[2]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 120 + this.colorDiff, 60);
            g.setColor(colors[3]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 180 + this.colorDiff, 60);
            g.setColor(colors[4]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 240 + this.colorDiff, 60);
            g.setColor(colors[5]);
            g.fillArc(this.iCircleMidX - this.iCirclePolomer + this.shakeX, this.iCircleMidY - this.iCirclePolomer, this.iCirclePriemer, this.iCirclePriemer, 300 + this.colorDiff, 60);
        }
    }

    private void paintThrowingDot(Graphics g) {
        if (this.isEndless) {
            this.drawDot(g, this.iDotsMidX + this.shakeFailX, this.posThrowingDotY, this.dotsColors[this.iThrowingIndex]);
        } else {
            this.drawDotArcade(g, this.iDotsMidX + this.shakeFailX, this.posThrowingDotY, this.dotsColors[this.iThrowingIndex]);
        }
    }

    private void paintThrowing(Graphics g) {
        this.dotsBgDecorY = this.iThrowDotsStartY - this.iDotPriemer;
        ScreenMain.sprDotsBg.setPosition((MainCanvas.WIDTH >> 1) - (ScreenMain.sprDotsBg.getWidth() >> 1), this.dotsBgDecorY);
        ScreenMain.sprDotsBg.setFrame(0);
        ScreenMain.sprDotsBg.paint(g);
        while (this.dotsBgDecorY < MainCanvas.HEIGHT) {
            this.dotsBgDecorY += ScreenMain.sprDotsBg.getHeight();
            ScreenMain.sprDotsBg.setPosition((MainCanvas.WIDTH >> 1) - (ScreenMain.sprDotsBg.getWidth() >> 1), this.dotsBgDecorY);
            ScreenMain.sprDotsBg.setFrame(1);
            ScreenMain.sprDotsBg.paint(g);
        }
        if (this.isEndless) {
            if (!this.isThrowing) {
                this.iOffThrowY = 0;
                for (int i = 0; i < this.dots.length; ++i) {
                    if (this.dots[i] >= 0) continue;
                    this.drawDot(g, this.iDotsMidX, this.iThrowDotsStartY + this.iOffThrowY, this.dotsColors[i]);
                    this.iOffThrowY += this.iDotPriemer + this.iDotPolomer;
                }
            } else {
                this.iOffThrowY = this.iDotPriemer + this.iDotPolomer;
                for (int i = 0; i < this.dots.length; ++i) {
                    if (this.dots[i] >= 0 || i == this.iThrowingIndex) continue;
                    this.drawDot(g, this.iDotsMidX, this.iThrowDotsStartY + this.iOffThrowY - this.iThrowAnimDotsOff, this.dotsColors[i]);
                    this.iOffThrowY += this.iDotPriemer + this.iDotPolomer;
                }
            }
        } else if (!this.isThrowing) {
            this.iOffThrowY = 0;
            for (int i = 0; i < this.dots.length; ++i) {
                if (this.dots[i] >= 0 || this.dots[i] <= -100) continue;
                this.drawDotArcade(g, this.iDotsMidX, this.iThrowDotsStartY + this.iOffThrowY, this.dotsColors[i]);
                this.iOffThrowY += this.iDotPriemer + this.iDotPolomer;
            }
        } else {
            this.iOffThrowY = this.iDotPriemer + this.iDotPolomer;
            for (int i = 0; i < this.dots.length; ++i) {
                if (this.dots[i] >= 0 || this.dots[i] <= -100 || i == this.iThrowingIndex) continue;
                this.drawDotArcade(g, this.iDotsMidX, this.iThrowDotsStartY + this.iOffThrowY - this.iThrowAnimDotsOff, this.dotsColors[i]);
                this.iOffThrowY += this.iDotPriemer + this.iDotPolomer;
            }
        }
    }

    private void drawDot(Graphics g, int x, int y, int color) {
        switch (color) {
            case 16766720: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(1);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            case 52224: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(2);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            case 0x88CCFF: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(4);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            case 0xFF0000: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(5);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            case 0x800080: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(6);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            case 16738740: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(3);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            case 139: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(7);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            case 0: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(8);
                ScreenMain.sprPinsEndless.paint(g);
                break;
            }
            default: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(0);
                ScreenMain.sprPinsEndless.paint(g);
            }
        }
    }

    private void drawDotArcade(Graphics g, int x, int y, int color) {
        switch (color) {
            case 41430: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(0);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 114623: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(1);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 146652: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(2);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 209237: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(3);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 217739: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(4);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 1651269: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(5);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 2725694: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(6);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 5949655: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(7);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 7602246: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(8);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 0x8228C8: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(9);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 11197500: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(10);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 12464642: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(11);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 13237721: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(12);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 15097770: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(13);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 16550699: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(14);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 16576883: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(15);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 16630528: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(16);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 16742656: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(17);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 16766750: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(18);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            case 0xFFFFFF: {
                ScreenMain.sprPinsArcade.setPosition(x, y);
                ScreenMain.sprPinsArcade.setFrame(19);
                ScreenMain.sprPinsArcade.paint(g);
                break;
            }
            default: {
                ScreenMain.sprPinsEndless.setPosition(x, y);
                ScreenMain.sprPinsEndless.setFrame(0);
                ScreenMain.sprPinsEndless.paint(g);
            }
        }
    }

    private void paintDots(Graphics g) {
        if (this.isEndless) {
            for (int i = 0; i < this.dotsEndless.length; ++i) {
                if (this.dotsEndless[i] <= -1) continue;
                g.setColor(0);
                if (this.dotsEndless[i] == this.shakeFail || this.dotsEndless[i] == 90) {
                    g.drawLine(this.iCircleMidX, this.iCircleMidY, this.iDotsPositions[this.dotsEndless[i]][0] + this.iDotPolomer + this.shakeFailX, this.iDotsPositions[this.dotsEndless[i]][1] + this.iDotPolomer);
                } else {
                    g.drawLine(this.iCircleMidX, this.iCircleMidY, this.iDotsPositions[this.dotsEndless[i]][0] + this.iDotPolomer + this.shakeX, this.iDotsPositions[this.dotsEndless[i]][1] + this.iDotPolomer);
                }
                if (this.dotsEndless[i] == this.shakeFail || this.dotsEndless[i] == 90) {
                    this.drawDot(g, this.iDotsPositions[this.dotsEndless[i]][0] + this.shakeFailX, this.iDotsPositions[this.dotsEndless[i]][1], this.dotsColorsEndless[i]);
                    continue;
                }
                this.drawDot(g, this.iDotsPositions[this.dotsEndless[i]][0] + this.shakeX, this.iDotsPositions[this.dotsEndless[i]][1], this.dotsColorsEndless[i]);
            }
        } else {
            for (int i = 0; i < this.dots.length; ++i) {
                if (this.dots[i] <= -1) continue;
                g.setColor(0);
                if (this.dots[i] == this.shakeFail || this.dots[i] == 90) {
                    g.drawLine(this.iCircleMidX, this.iCircleMidY, this.iDotsPositions[this.dots[i]][0] + this.iDotPolomer + this.shakeFailX, this.iDotsPositions[this.dots[i]][1] + this.iDotPolomer);
                } else {
                    g.drawLine(this.iCircleMidX, this.iCircleMidY, this.iDotsPositions[this.dots[i]][0] + this.iDotPolomer + this.shakeX, this.iDotsPositions[this.dots[i]][1] + this.iDotPolomer);
                }
                if (this.dots[i] == this.shakeFail || this.dots[i] == 90) {
                    this.drawDotArcade(g, this.iDotsPositions[this.dots[i]][0] + this.shakeFailX, this.iDotsPositions[this.dots[i]][1], this.dotsColors[i]);
                    continue;
                }
                this.drawDotArcade(g, this.iDotsPositions[this.dots[i]][0] + this.shakeX, this.iDotsPositions[this.dots[i]][1], this.dotsColors[i]);
            }
        }
    }

    private void paintCover(Graphics g) {
        boolean[] covers = this.screen.iSelectedLevel > Level.LAST_LEVEL ? Level2.covers : Level.covers;
        if (covers != null) {
            if (covers[0]) {
                ScreenMain.sprCover0.setTransform(0);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX - (ScreenMain.sprCover0.getWidth() >> 1), this.iCircleMidY - ScreenMain.sprCover0.getHeight());
                ScreenMain.sprCover0.paint(g);
            }
            if (covers[1]) {
                ScreenMain.sprCover45.setTransform(6);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX - ScreenMain.sprCover45.getWidth(), this.iCircleMidY - ScreenMain.sprCover45.getHeight());
                ScreenMain.sprCover45.paint(g);
            }
            if (covers[2]) {
                ScreenMain.sprCover0.setTransform(7);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX, this.iCircleMidY - (ScreenMain.sprCover0.getHeight() >> 1));
                ScreenMain.sprCover0.paint(g);
            }
            if (covers[3]) {
                ScreenMain.sprCover45.setTransform(3);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX - ScreenMain.sprCover45.getWidth(), this.iCircleMidY);
                ScreenMain.sprCover45.paint(g);
            }
            if (covers[4]) {
                ScreenMain.sprCover0.setTransform(3);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX - (ScreenMain.sprCover0.getWidth() >> 1), this.iCircleMidY);
                ScreenMain.sprCover0.paint(g);
            }
            if (covers[5]) {
                ScreenMain.sprCover45.setTransform(5);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX, this.iCircleMidY);
                ScreenMain.sprCover45.paint(g);
            }
            if (covers[6]) {
                ScreenMain.sprCover0.setTransform(4);
                ScreenMain.sprCover0.setPosition(this.iCircleMidX - ScreenMain.sprCover0.getWidth(), this.iCircleMidY - (ScreenMain.sprCover0.getHeight() >> 1));
                ScreenMain.sprCover0.paint(g);
            }
            if (covers[7]) {
                ScreenMain.sprCover45.setTransform(0);
                ScreenMain.sprCover45.setPosition(this.iCircleMidX, this.iCircleMidY - ScreenMain.sprCover45.getHeight());
                ScreenMain.sprCover45.paint(g);
            }
        }
    }

    public void keyPressed(int keycode) {
        if (this.isInited && (Keys.isKeyPressed(53) || Keys.isActionPressed(5))) {
            this.Throw();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.isInited && !this.screen.isRightButtonPressed(x, y) && !this.screen.isLeftButtonPressed(x, y)) {
            this.Throw();
        }
    }

    private void Throw() {
        block4: {
            if (this.isThrowing || this.gameOverComming) break block4;
            if (this.isEndless) {
                for (int i = 0; i < this.dots.length; ++i) {
                    if (this.dots[i] >= 0) continue;
                    this.iThrowingIndex = i;
                    this.isThrowing = true;
                    this.iThrowAnimDotsOff = 0;
                    break;
                }
            } else {
                for (int i = 0; i < this.dots.length; ++i) {
                    if (this.dots[i] >= 0 || this.dots[i] <= -100) continue;
                    this.iThrowingIndex = i;
                    this.isThrowing = true;
                    this.iThrowAnimDotsOff = 0;
                    break;
                }
            }
        }
    }
}

