/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Level2;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.game.Game;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    public GFont fontMain;
    private Game game;
    public final byte SCREEN_INTRO;
    public final byte SCREEN_MENU;
    public final byte SCREEN_GAME = (byte)2;
    public final byte INTRO_INIT_GRAPHICS;
    public final byte INTRO_INIT;
    public final byte INTRO_LOGO_INLOGIC = (byte)2;
    public final byte INTRO_LANGUAGE = (byte)3;
    public final byte INTRO_ENABLE_MUSIC = (byte)4;
    public final byte MENU_MAIN;
    public final byte MENU_PLAY;
    public final byte MENU_INSTRUCTIONS = (byte)2;
    public final byte MENU_ABOUT = (byte)3;
    public final byte MENU_QUIT = (byte)4;
    public final byte MENU_LEVEL_SELECT = (byte)5;
    public static final byte GAME_MAIN = 0;
    public static final byte GAME_OVER = 1;
    final byte ID_MENU_INSTRUCTIONS;
    final byte ID_MENU_ABOUT;
    final byte ID_MENU_SOUND = (byte)2;
    final byte ID_MENU_BACK = (byte)3;
    final byte ID_MENU_ITEMS_TOTAL = (byte)4;
    private int iMenuItemsTotal;
    final byte ID_BUTTON_ENDLESS;
    final byte ID_BUTTON_ARCADE;
    final byte ID_BUTTON_SETTINGS = (byte)2;
    final byte ID_BUTTONS_TOTAL = (byte)3;
    private int screen;
    public int subScreen;
    public int iSelectedMenuItem;
    public int iSelectedButton = 1;
    public int iSelectedLevel;
    private int iButtonsTotal;
    public boolean bLoading = false;
    Rectangle[] rectMenuItems;
    Rectangle rectButtonCenter;
    Rectangle rectPlayButton;
    Rectangle[] rectMenuButtons;
    Rectangle[] rectLevelSelect;
    public boolean bDragInstructions = false;
    public boolean bDragLevelSelect = false;
    private int iTextLines = 1;
    public String strTextBody;
    public String strTextBodyType;
    String[] strTextMenu = new String[4];
    public String[] strTextPom = new String[3];
    PreparedText prepText;
    private int iInstructionsCenterY;
    private int iInstructionsWidth;
    private int iInstructionsHeight;
    private int iTextShiftY = 0;
    private int iShiftY = 0;
    private int iMaxShiftY = 0;
    private int iAboutCenterY;
    private int iAboutWidth;
    private int iAboutHeight;
    private int iMainX = 0;
    private int iMainClickStep = 0;
    private boolean bMainIn = false;
    private boolean bMainOut = false;
    private boolean bMainClick = false;
    private boolean bMainMenu = false;
    private static final int DELAY_TIME = 3000;
    private int delay;
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt", "it"};
    private static final int[] LANGUAGES = new int[]{2, 3, 7, 10, 6, 11};
    private static final int[] LANGUAGES_SELECTED = new int[]{0, 1, 5, 8, 4, 9};
    private static final int MAX_LANGUAGES = 6;
    private Rectangle[] rectLanguages = new Rectangle[6];
    private int iSelectedLanguage;
    private boolean waitForMusic = false;
    private int counterForMusic = 0;
    private boolean start = false;
    private int iShiftDirection;
    public int iShiftX = 0;
    private int iShiftStep;
    private int updateCounter = 0;
    private int iFlash;
    private boolean bLastShiftUp = false;
    private boolean bLastShiftDown = false;
    private boolean isButtonPressed = false;
    private boolean bOddShiftNeeded = false;
    private int lastShiftCountDown = 0;
    private int lastShiftCountUp = 0;
    private int buttonPressedCounter = 0;
    private int iOddShiftY = 0;
    private int iSelectedLevelX;
    private int iSelectedLevelY;
    boolean bPause = false;
    public static Image imgSplash;
    public static Image imgInlogic;
    public static Image imgFail;
    public static Image imgWin;
    public static Image imgBg;
    public static Image imgPause;
    public static Image imgCircle;
    public static Image imgCircleBg;
    public static Image imgMenuBg;
    public static Sprite sprCover0;
    public static Sprite sprCover45;
    public static Sprite sprLanguage;
    public static Sprite sprButtonsBg;
    public static Sprite sprFKIcons;
    public static Sprite sprArrows;
    public static Sprite sprIconsBig;
    public static Sprite sprDialogBg;
    public static Sprite sprDialogRed;
    public static Sprite sprDialogGreen;
    public static Sprite sprMenuBtn;
    public static Sprite sprDotsBg;
    public static Sprite sprButtons;
    public static Sprite sprPinsEndless;
    public static Sprite sprPinsArcade;
    public static Sprite sprLevelButtons;
    private Rectangle rectTitleCenter;
    private int iHeaderHeight;
    private int iTitlePosY;
    private int iGameOverW;
    private int iGameOverH;
    private int iGameOverCenterY;

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_MAIN = 0;
        this.MENU_PLAY = 1;
        this.ID_MENU_INSTRUCTIONS = 0;
        this.ID_MENU_ABOUT = 1;
        this.ID_BUTTON_ENDLESS = 0;
        this.ID_BUTTON_ARCADE = 1;
        this.mainCanvas = mainCanvas;
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (this.waitForMusic) {
            this.counterForMusic = (int)((long)this.counterForMusic + lTick);
            if (this.counterForMusic > 600) {
                this.counterForMusic = 0;
                this.waitForMusic = false;
            }
            return;
        }
        if (this.iFlash > 0) {
            this.iFlash = (int)((long)this.iFlash - lTick);
        } else if (this.iFlash < 0) {
            this.iFlash = 0;
        }
        if (this.bPause) {
            return;
        }
        if (!this.bLoading) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 0: {
                            this.initGraphics();
                            break block0;
                        }
                        case 1: {
                            this.initIntro();
                            break block0;
                        }
                        case 2: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            this.nextScreen(0, 3);
                            break block0;
                        }
                        case 3: {
                            this.updateShift();
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            this.updateMainX();
                            break block0;
                        }
                        case 1: {
                            this.updateMainX();
                            break block0;
                        }
                        case 2: {
                            this.updateInstructions();
                            break block0;
                        }
                        case 5: {
                            this.updateLevelSelect();
                            break block0;
                        }
                        case 4: {
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.subScreen) {
                        case 0: {
                            this.game.update(lTick);
                            break block0;
                        }
                        case 1: {
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.mainCanvas.repaint();
        }
    }

    public void initMainX() {
        this.iMainX = MainCanvas.WIDTH;
        if (this.iMainClickStep == 0) {
            this.iMainClickStep = MainCanvas.WIDTH / 120;
        }
        this.bMainIn = true;
        this.bMainOut = false;
        this.bMainClick = false;
        this.bMainMenu = false;
        this.start = true;
    }

    public void updateMainX() {
        if (this.bMainClick) {
            if (this.iMainX == 0) {
                this.iMainX = this.bMainMenu ? (this.iMainX += this.iMainClickStep) : (this.iMainX -= this.iMainClickStep);
            } else {
                this.iMainX = 0;
                this.bMainClick = false;
            }
        } else {
            if (this.bMainIn) {
                if (this.iMainX != 0) {
                    this.iMainX = this.bMainMenu ? (this.iMainX -= MainCanvas.WIDTH >> 2) : (this.iMainX += MainCanvas.WIDTH >> 2);
                    if (this.iMainX < 0 && this.bMainMenu) {
                        this.iMainX = 0;
                    }
                    if (this.iMainX > 0 && !this.bMainMenu) {
                        this.iMainX = 0;
                    }
                    if (this.iMainX == 0) {
                        this.bMainIn = false;
                        if (!this.start) {
                            this.bMainClick = true;
                        } else {
                            this.start = false;
                        }
                    }
                }
                return;
            }
            if (this.bMainOut) {
                if (this.bMainMenu) {
                    if (this.iMainX != -MainCanvas.WIDTH) {
                        this.iMainX -= MainCanvas.WIDTH >> 2;
                        if (this.iMainX < -MainCanvas.WIDTH) {
                            this.iMainX = -MainCanvas.WIDTH;
                        }
                    } else if (this.iMainX == -MainCanvas.WIDTH) {
                        this.bMainOut = false;
                        this.nextScreen(1, 0);
                        this.bMainIn = true;
                        this.iMainX = MainCanvas.WIDTH;
                    }
                }
                if (!this.bMainMenu) {
                    if (this.iMainX != MainCanvas.WIDTH) {
                        this.iMainX += MainCanvas.WIDTH >> 2;
                        if (this.iMainX > MainCanvas.WIDTH) {
                            this.iMainX = MainCanvas.WIDTH;
                        }
                    } else if (this.iMainX == MainCanvas.WIDTH) {
                        this.bMainOut = false;
                        this.nextScreen(1, 1);
                        this.bMainIn = true;
                        this.iMainX = -MainCanvas.WIDTH;
                    }
                }
                return;
            }
        }
    }

    public void initNextScreen() {
        this.bMainMenu = !this.bMainMenu;
        this.bMainIn = false;
        this.bMainOut = true;
        this.bMainClick = true;
    }

    public void updateShift() {
        ++this.updateCounter;
        if (this.updateCounter > 1) {
            this.updateCounter = 0;
            if (this.iShiftDirection > 0) {
                this.iShiftX += this.iShiftStep;
                if (this.iShiftX >= this.iShiftStep << 1) {
                    this.iShiftDirection = -1;
                }
            } else {
                this.iShiftX -= this.iShiftStep;
                if (this.iShiftX <= -(this.iShiftStep << 1)) {
                    this.iShiftDirection = 1;
                }
            }
        }
    }

    public void gameContinue() {
        if (this.screen != 0) {
            if (this.screen == 2 && this.subScreen == 0) {
                this.playMusic(Sounds.MUSIC_GAME, -1);
            } else {
                this.playMusic(Sounds.MUSIC_MENU, -1);
            }
        }
        this.setTexts();
        this.bPause = false;
    }

    public void paintContinue(Graphics g) {
        this.paintBg(g);
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, this.rectTitleCenter.width, this.rectTitleCenter.height << 1);
        this.paintTextInRectangle(g, this.rectTitleCenter);
        this.paintLeftButton(g, 2, 6);
    }

    public void paint(Graphics g) {
        if (this.iFlash > 0) {
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            return;
        }
        if (this.bPause) {
            this.paintContinue(g);
            return;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        this.paintBg(g);
                        this.paintLogoInlogic(g);
                        break block0;
                    }
                    case 3: {
                        this.paintBg(g);
                        this.paintLanguages(g);
                        break block0;
                    }
                    case 4: {
                        this.paintBg(g);
                        this.paintEnableMusic(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintBg(g);
                        this.paintMainMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintBg(g);
                        this.paintMenuPlay(g);
                        break block0;
                    }
                    case 2: {
                        this.paintBg(g);
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 3: {
                        this.paintBg(g);
                        this.paintAbout(g);
                        break block0;
                    }
                    case 4: {
                        this.paintBg(g);
                        this.paintQuit(g);
                        break block0;
                    }
                    case 5: {
                        this.paintBg(g);
                        this.paintHeader(g);
                        this.paintLevelSelect(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintBg(g);
                        this.game.paint(g);
                        break block0;
                    }
                    case 1: {
                        this.paintBg(g);
                        this.paintGameOver(g);
                        break block0;
                    }
                }
                break;
            }
        }
        this.paintControls(g);
    }

    private void paintBg(Graphics g) {
        g.drawImage(imgBg, 0, 0, 20);
    }

    private void paintGameOver(Graphics g) {
        if (this.game.isWin()) {
            this.fontMain.drawString(g, this.strTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, this.fontMain.getHeight(), 3);
            this.fontMain.drawString(g, this.strTextPom[1].toCharArray(), MainCanvas.WIDTH >> 1, this.rectButtonCenter.y - this.fontMain.getHeight(), 3);
            sprIconsBig.setFrame(0);
            sprIconsBig.setPosition(this.rectPlayButton.x, this.rectPlayButton.y);
            sprIconsBig.paint(g);
            this.paintTable(g, sprDialogGreen, MainCanvas.WIDTH >> 1, this.iGameOverCenterY, this.iGameOverW, this.iGameOverH);
            g.drawImage(imgWin, MainCanvas.WIDTH >> 1, this.iGameOverCenterY, 3);
        } else {
            this.fontMain.drawString(g, this.strTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, this.fontMain.getHeight(), 3);
            int lineY = 0;
            for (int i = 0; i < this.iTextLines; ++i) {
                lineY = this.iTextLines > 1 ? this.rectButtonCenter.y - this.fontMain.getHeight() - (this.fontMain.getHeight() >> 2) + i * this.fontMain.getHeight() : this.rectButtonCenter.y - this.fontMain.getHeight() - i * this.fontMain.getHeight();
                this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 3);
            }
            sprIconsBig.setFrame(1);
            sprIconsBig.setPosition(this.rectPlayButton.x, this.rectPlayButton.y);
            sprIconsBig.paint(g);
            this.paintTable(g, sprDialogRed, MainCanvas.WIDTH >> 1, this.iGameOverCenterY, this.iGameOverW, this.iGameOverH);
            g.drawImage(imgFail, MainCanvas.WIDTH >> 1, this.iGameOverCenterY, 3);
        }
    }

    public void paintControls(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 3: {
                        this.paintLeftButton(g, 2, 6);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, 2, 6);
                        this.paintRightButton(g, 1, 7);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (!this.game.bPause) {
                            this.paintMenuButtons(g);
                            break block0;
                        }
                        this.paintLeftButton(g, 2, 6);
                        this.paintRightButton(g, 1, 2);
                        break block0;
                    }
                    case 1: {
                        this.paintMenuButtons(g);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.paintRightButton(g, 1, 2);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, 2, 6);
                        this.paintRightButton(g, 1, 7);
                        break block0;
                    }
                    case 5: {
                        this.paintLeftButton(g, 2, 6);
                        this.paintRightButton(g, 1, 7);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 1: {
                        this.paintRightButton(g, 0, 1);
                        break block0;
                    }
                    case 0: {
                        this.paintPause(g);
                        break block0;
                    }
                }
            }
        }
    }

    public void paintLevelSelect(Graphics g) {
        int offY = MainCanvas.HEIGHT - sprFKIcons.getHeight() - sprLevelButtons.getHeight() * 5 >> 1;
        int offX = MainCanvas.WIDTH - sprLevelButtons.getWidth() * 5 >> 1;
        int k = 1;
        for (int i = 0; i < Level2.LAST_LEVEL / 5 + 1; ++i) {
            for (int j = 0; j < 5 && k != Level2.LAST_LEVEL + 1; ++k, ++j) {
                this.rectLevelSelect[k] = new Rectangle(offX + j * sprLevelButtons.getWidth(), offY + i * sprLevelButtons.getHeight() - this.iShiftY, sprLevelButtons.getWidth(), sprLevelButtons.getHeight());
            }
            if (k == Level2.LAST_LEVEL + 1) break;
        }
        g.setClip(0, offY, MainCanvas.WIDTH, sprLevelButtons.getHeight() * 5);
        for (int i = 1; i < Level2.LAST_LEVEL + 1; ++i) {
            if (this.rectLevelSelect[i].y - this.iShiftY < offY - sprLevelButtons.getHeight() || this.rectLevelSelect[i].y - this.iShiftY > offY + sprLevelButtons.getHeight() * 6) continue;
            if (i == Profile.iLevel) {
                sprLevelButtons.setFrame(2);
                sprLevelButtons.setPosition(this.rectLevelSelect[i].x, this.rectLevelSelect[i].y - this.iShiftY);
                sprLevelButtons.paint(g);
            } else if (i < Profile.iLevel) {
                sprLevelButtons.setFrame(1);
                sprLevelButtons.setPosition(this.rectLevelSelect[i].x, this.rectLevelSelect[i].y - this.iShiftY);
                sprLevelButtons.paint(g);
            } else {
                sprLevelButtons.setFrame(0);
                sprLevelButtons.setPosition(this.rectLevelSelect[i].x, this.rectLevelSelect[i].y - this.iShiftY);
                sprLevelButtons.paint(g);
            }
            if (i == this.iSelectedLevel) {
                sprLevelButtons.setFrame(3);
                sprLevelButtons.setPosition(this.rectLevelSelect[i].x, this.rectLevelSelect[i].y - this.iShiftY);
                sprLevelButtons.paint(g);
            }
            String str = i + "";
            this.fontMain.drawString(g, str.toCharArray(), (sprLevelButtons.getWidth() >> 1) + this.rectLevelSelect[i].x, (sprLevelButtons.getHeight() >> 1) + this.rectLevelSelect[i].y - this.iShiftY, 3);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintMenuButtons(Graphics g) {
        g.drawImage(imgMenuBg, MainCanvas.WIDTH - imgMenuBg.getWidth() >> 1, MainCanvas.HEIGHT - imgMenuBg.getHeight(), 20);
        int offX = MainCanvas.WIDTH - sprButtons.getWidth() * this.iButtonsTotal >> 1;
        for (int i = 0; i < this.iButtonsTotal; ++i) {
            if (i == this.iSelectedButton) {
                sprButtons.setFrame(i);
                sprButtons.setPosition(offX + i * sprButtons.getWidth(), MainCanvas.HEIGHT - sprButtonsBg.getHeight());
                sprButtons.paint(g);
                continue;
            }
            sprButtons.setFrame(i);
            sprButtons.setPosition(offX + i * sprButtons.getWidth(), MainCanvas.HEIGHT - (sprButtonsBg.getHeight() >> 2) * 3);
            sprButtons.paint(g);
        }
    }

    public void paintLeftButton(Graphics g, int bgFrame, int frame) {
        sprButtonsBg.setFrame(bgFrame);
        sprButtonsBg.setPosition(0, MainCanvas.HEIGHT - sprButtonsBg.getHeight());
        sprButtonsBg.paint(g);
        sprFKIcons.setFrame(frame);
        sprFKIcons.setPosition((sprButtonsBg.getWidth() >> 1) - (sprFKIcons.getWidth() >> 1), MainCanvas.HEIGHT - (sprButtonsBg.getHeight() >> 1) - (sprFKIcons.getHeight() >> 1));
        sprFKIcons.paint(g);
    }

    public void paintPause(Graphics g) {
        g.drawImage(imgPause, MainCanvas.WIDTH - imgPause.getWidth(), MainCanvas.HEIGHT - imgPause.getHeight(), 20);
    }

    public void paintRightButton(Graphics g, int bgFrame, int frame) {
        sprButtonsBg.setFrame(bgFrame);
        sprButtonsBg.setPosition(MainCanvas.WIDTH - sprButtonsBg.getWidth(), MainCanvas.HEIGHT - sprButtonsBg.getHeight());
        sprButtonsBg.paint(g);
        sprFKIcons.setFrame(frame);
        sprFKIcons.setPosition(MainCanvas.WIDTH - (sprButtonsBg.getWidth() >> 1) - (sprFKIcons.getWidth() >> 1), MainCanvas.HEIGHT - (sprButtonsBg.getHeight() >> 1) - (sprFKIcons.getHeight() >> 1));
        sprFKIcons.paint(g);
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (imgInlogic.getHeight() >> 1), 20);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 6; ++i) {
            if (i == this.iSelectedLanguage) {
                sprLanguage.setFrame(LANGUAGES_SELECTED[i]);
                sprLanguage.setPosition(this.rectLanguages[i].x + this.iShiftX, this.rectLanguages[i].y);
                sprLanguage.paint(g);
                continue;
            }
            sprLanguage.setFrame(LANGUAGES[i]);
            sprLanguage.setPosition(this.rectLanguages[i].x, this.rectLanguages[i].y);
            sprLanguage.paint(g);
        }
    }

    public void paintEnableMusic(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, this.rectTitleCenter.width, this.rectTitleCenter.height << 1);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintTitle(Graphics g) {
        g.drawImage(imgSplash, this.iMainX + (MainCanvas.WIDTH >> 1) - (imgSplash.getWidth() >> 1), this.iTitlePosY, 20);
    }

    public void paintMenuPlay(Graphics g) {
        this.paintTitle(g);
        if (this.iSelectedButton == 0) {
            sprIconsBig.setFrame(2);
        } else if (this.iSelectedButton == 1) {
            sprIconsBig.setFrame(3);
        }
        sprIconsBig.setPosition(this.iMainX + this.rectButtonCenter.x, this.rectButtonCenter.y);
        sprIconsBig.paint(g);
        if (MainCanvas.HEIGHT > 221) {
            this.fontMain.drawString(g, this.strTextBody.toCharArray(), this.iMainX + (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextBody.toCharArray()) >> 1), MainCanvas.HEIGHT - sprButtons.getHeight() - (this.fontMain.getHeight() << 1), 20);
            this.fontMain.drawString(g, this.strTextBodyType.toCharArray(), this.iMainX + (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextBodyType.toCharArray()) >> 1), MainCanvas.HEIGHT - sprButtons.getHeight() - this.fontMain.getHeight(), 20);
        } else {
            this.fontMain.drawString(g, this.strTextBody.toCharArray(), this.iMainX + (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextBody.toCharArray()) >> 1), MainCanvas.HEIGHT - sprButtons.getHeight() - (this.fontMain.getHeight() << 1), 20);
            this.fontMain.drawString(g, this.strTextBodyType.toCharArray(), this.iMainX + (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextBodyType.toCharArray()) >> 1), MainCanvas.HEIGHT - sprButtons.getHeight() - this.fontMain.getHeight(), 20);
        }
    }

    public void paintMainMenu(Graphics g) {
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectMenuItems[i], this.strTextMenu[i], true);
                continue;
            }
            this.paintMenuButton(g, this.rectMenuItems[i], this.strTextMenu[i], false);
        }
    }

    private void paintMenuButton(Graphics g, Rectangle bounds, String text, boolean selected) {
        if (!selected) {
            sprMenuBtn.setFrame(1);
            sprMenuBtn.setPosition(this.iMainX + bounds.x, bounds.y);
            sprMenuBtn.paint(g);
            this.fontMain.drawString(g, text.toCharArray(), this.iMainX + bounds.x + (bounds.width >> 1), bounds.getCenterY(), 3);
        } else {
            sprMenuBtn.setFrame(0);
            sprMenuBtn.setPosition(this.iMainX + bounds.x, bounds.y);
            sprMenuBtn.paint(g);
            this.fontMain.drawString(g, text.toCharArray(), this.iMainX + bounds.x + (bounds.width >> 1), bounds.getCenterY(), 3);
        }
    }

    public void paintInstructions(Graphics g) {
        this.paintHeader(g);
        if (!this.bLoading) {
            this.paintInstructionsText(g);
        }
    }

    public void paintHeader(Graphics g) {
        if (MainCanvas.HEIGHT < 220) {
            this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, 0, this.rectTitleCenter.width, this.iHeaderHeight);
            this.fontMain.drawString(g, this.strTextBody.toCharArray(), MainCanvas.WIDTH >> 1, this.fontMain.getHeight() >> 1, 3);
        } else {
            this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, 0, this.rectTitleCenter.width, this.iHeaderHeight << 1);
            this.fontMain.drawString(g, this.strTextBody.toCharArray(), MainCanvas.WIDTH >> 1, this.fontMain.getHeight(), 3);
        }
    }

    public void initLevelSelect() {
        this.bLastShiftUp = false;
        this.bLastShiftDown = false;
        this.isButtonPressed = false;
        this.lastShiftCountDown = 0;
        this.lastShiftCountUp = 0;
        this.buttonPressedCounter = 0;
        if (sprLevelButtons.getHeight() % 2 == 1) {
            this.iOddShiftY = 1;
            this.bOddShiftNeeded = true;
        } else {
            this.iOddShiftY = 0;
        }
    }

    public void updateLevelSelect() {
        boolean isDivisibleBy5;
        if (this.isButtonPressed) {
            ++this.buttonPressedCounter;
            if (this.buttonPressedCounter == 3) {
                this.buttonPressedCounter = 0;
                this.isButtonPressed = false;
            }
        }
        if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && !this.isButtonPressed) {
            this.isButtonPressed = true;
            if (this.iSelectedLevel > 5) {
                this.iSelectedLevel -= 5;
            }
            int i = 9;
            if (Level2.LAST_LEVEL % 5 != 0) {
                i = 5 + Level2.LAST_LEVEL % 5 - 1;
            }
            if (this.iSelectedLevel > 0 && this.iSelectedLevel < Level2.LAST_LEVEL - i) {
                if (!this.bLastShiftUp || this.lastShiftCountDown == 1) {
                    this.lastShiftCountDown = 0;
                    ++this.lastShiftCountUp;
                    if (this.lastShiftCountUp == 2) {
                        this.bLastShiftUp = true;
                        this.bLastShiftDown = false;
                        this.lastShiftCountUp = 0;
                    }
                } else {
                    this.iShiftY -= sprLevelButtons.getHeight() >> 1;
                    if (this.iOddShiftY == 1 && this.bOddShiftNeeded) {
                        --this.iShiftY;
                        this.iOddShiftY = 0;
                    } else if (this.bOddShiftNeeded) {
                        ++this.iOddShiftY;
                    }
                }
            }
            if (this.iShiftY < 0) {
                this.iShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && !this.isButtonPressed) {
            this.isButtonPressed = true;
            if (this.iSelectedLevel < Level2.LAST_LEVEL - 4) {
                this.iSelectedLevel += 5;
            }
            if (this.iSelectedLevel > 10 && this.iSelectedLevel < Level2.LAST_LEVEL) {
                if (!this.bLastShiftDown || this.lastShiftCountUp == 1) {
                    this.lastShiftCountUp = 0;
                    ++this.lastShiftCountDown;
                    if (this.lastShiftCountDown == 2) {
                        this.bLastShiftDown = true;
                        this.bLastShiftUp = false;
                        this.lastShiftCountDown = 0;
                    }
                } else {
                    this.iShiftY += sprLevelButtons.getHeight() >> 1;
                    if (this.iOddShiftY == 1 && this.bOddShiftNeeded) {
                        ++this.iShiftY;
                        this.iOddShiftY = 0;
                    } else if (this.bOddShiftNeeded) {
                        ++this.iOddShiftY;
                    }
                }
            }
            if (this.iShiftY > this.iMaxShiftY) {
                this.iShiftY = this.iMaxShiftY;
            }
        }
        if ((Keys.isActionPressed(3) || Keys.isKeyPressed(52)) && !this.isButtonPressed) {
            this.isButtonPressed = true;
            boolean bl = isDivisibleBy5 = (this.iSelectedLevel - 1) % 5 == 0;
            if (this.iSelectedLevel > 1) {
                --this.iSelectedLevel;
            }
            if (this.iSelectedLevel > 0 && this.iSelectedLevel < Level2.LAST_LEVEL - 5 && isDivisibleBy5) {
                if (!this.bLastShiftUp || this.lastShiftCountDown == 1) {
                    this.lastShiftCountDown = 0;
                    ++this.lastShiftCountUp;
                    if (this.lastShiftCountUp == 2) {
                        this.bLastShiftUp = true;
                        this.bLastShiftDown = false;
                        this.lastShiftCountUp = 0;
                    }
                } else {
                    this.iShiftY -= sprLevelButtons.getHeight() >> 1;
                    if (this.iOddShiftY == 1 && this.bOddShiftNeeded) {
                        --this.iShiftY;
                        this.iOddShiftY = 0;
                    } else if (this.bOddShiftNeeded) {
                        ++this.iOddShiftY;
                    }
                }
            }
            if (this.iShiftY < 0) {
                this.iShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(4) || Keys.isKeyPressed(54)) && !this.isButtonPressed) {
            this.isButtonPressed = true;
            boolean bl = isDivisibleBy5 = this.iSelectedLevel % 5 == 0;
            if (this.iSelectedLevel < Level2.LAST_LEVEL) {
                ++this.iSelectedLevel;
            }
            if (this.iSelectedLevel > 10 && this.iSelectedLevel < Level2.LAST_LEVEL && isDivisibleBy5) {
                if (!this.bLastShiftDown || this.lastShiftCountUp == 1) {
                    this.lastShiftCountUp = 0;
                    ++this.lastShiftCountDown;
                    if (this.lastShiftCountDown == 2) {
                        this.bLastShiftDown = true;
                        this.bLastShiftUp = false;
                        this.lastShiftCountDown = 0;
                    }
                } else {
                    this.iShiftY += sprLevelButtons.getHeight() >> 1;
                    if (this.iOddShiftY == 1 && this.bOddShiftNeeded) {
                        ++this.iShiftY;
                        this.iOddShiftY = 0;
                    } else if (this.bOddShiftNeeded) {
                        ++this.iOddShiftY;
                    }
                }
            }
            if (this.iShiftY > this.iMaxShiftY) {
                this.iShiftY = this.iMaxShiftY;
            }
        }
    }

    public void updateInstructions() {
        if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && this.iShiftY > 0) {
            this.iShiftY -= this.fontMain.getHeight();
            if (this.iShiftY < 0) {
                this.iShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && this.iShiftY < this.iMaxShiftY) {
            this.iShiftY += this.fontMain.getHeight();
            if (this.iShiftY > this.iMaxShiftY) {
                this.iShiftY = this.iMaxShiftY;
            }
        }
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iInstructionsWidth >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iInstructionsWidth >> 1) && y > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && y < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
    }

    public boolean isPressedLevelSelect(int x, int y) {
        int offY = MainCanvas.HEIGHT - sprFKIcons.getHeight() - sprLevelButtons.getHeight() * 5 >> 1;
        return x >= 0 && x <= MainCanvas.WIDTH && y > offY && y < offY + sprLevelButtons.getHeight() * 5;
    }

    public void paintInstructionsText(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, this.iInstructionsCenterY, this.iInstructionsWidth, this.iInstructionsHeight);
        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + (sprArrows.getHeight() << 1);
        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - (sprArrows.getHeight() << 1);
        if (this.iShiftY > 0) {
            sprArrows.setFrame(1);
            sprArrows.setPosition((MainCanvas.WIDTH >> 1) - (sprArrows.getWidth() >> 1), iTextYUp - sprArrows.getHeight() - (sprArrows.getHeight() >> 1));
            sprArrows.paint(g);
        }
        if (this.iShiftY < this.iMaxShiftY) {
            sprArrows.setFrame(0);
            sprArrows.setPosition((MainCanvas.WIDTH >> 1) - (sprArrows.getWidth() >> 1), iTextYDown + (sprArrows.getHeight() >> 1));
            sprArrows.paint(g);
        }
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            lineY = iTextYUp + (i + 1) * this.fontMain.getHeight() - this.iShiftY;
            if (lineY <= this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) || lineY + this.fontMain.getHeight() >= this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) continue;
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintAbout(Graphics g) {
        this.paintHeader(g);
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, this.iAboutCenterY, this.iAboutWidth, this.iAboutHeight);
        if (this.iAboutCenterY - (this.iAboutHeight >> 1) < this.iAboutCenterY - imgInlogic.getHeight()) {
            g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), this.iAboutCenterY - imgInlogic.getHeight(), 20);
            int pomY = this.iAboutCenterY + (this.iAboutHeight >> 2) - (this.fontMain.getHeight() >> 1) - this.fontMain.getHeight();
            this.fontMain.drawString(g, this.strTextPom[0].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[0].toCharArray()) >> 1), pomY, 20);
            this.fontMain.drawString(g, this.strTextPom[1].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[1].toCharArray()) >> 1), pomY += this.fontMain.getHeight(), 20);
        } else {
            g.drawImage(imgInlogic, (MainCanvas.WIDTH >> 1) - (imgInlogic.getWidth() >> 1), this.iAboutCenterY - (this.iAboutHeight >> 1) + (this.fontMain.getHeight() >> 1), 20);
            int pomY = this.iAboutCenterY + this.fontMain.getHeight();
            this.fontMain.drawString(g, this.strTextPom[0].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[0].toCharArray()) >> 1), pomY, 20);
            this.fontMain.drawString(g, this.strTextPom[1].toCharArray(), (MainCanvas.WIDTH >> 1) - (this.fontMain.stringWidth(this.strTextPom[1].toCharArray()) >> 1), pomY += this.fontMain.getHeight(), 20);
        }
    }

    public void paintQuit(Graphics g) {
        this.paintTable(g, sprDialogBg, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, this.rectTitleCenter.width, this.rectTitleCenter.height << 1);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintTextInRectangle(Graphics g, Rectangle rect) {
        int iCenterY = MainCanvas.HEIGHT >> 1;
        int textHeight = this.fontMain.getHeight() * this.iTextLines;
        int pomY = iCenterY - (textHeight >> 1) - 1;
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), rect.getCenterX(), pomY, 17);
            pomY += this.fontMain.getHeight();
        }
    }

    public void setTitleCenter(String s) {
        this.rectTitleCenter.height = this.fontMain.getHeight() + (this.fontMain.getHeight() >> 1);
        int textMaxWidth = this.rectTitleCenter.width - (this.rectTitleCenter.width >> 3);
        this.prepText = new PreparedText(this.fontMain);
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
        if (this.iTextLines > 1) {
            this.rectTitleCenter.height += (this.iTextLines - 1) * this.fontMain.getHeight() + 1;
        }
    }

    public void keyPressed(int keyCode) {
        if (!(this.bMainIn || this.bMainOut || this.bMainClick || this.waitForMusic || this.screen != 2 || this.subScreen != 0)) {
            this.game.keyPressed(keyCode);
        }
    }

    public void soundOn() {
        Profile.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public void soundOff() {
        Profile.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage > 1) {
                    this.iSelectedLanguage -= 2;
                    break;
                }
                if (this.iSelectedLanguage == 0) {
                    this.iSelectedLanguage = 4;
                    break;
                }
                this.iSelectedLanguage = 5;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage == 4) {
                    this.iSelectedLanguage = 0;
                    break;
                }
                if (this.iSelectedLanguage == 5) {
                    this.iSelectedLanguage = 1;
                    break;
                }
                this.iSelectedLanguage += 2;
                break;
            }
            case 2: {
                if (this.iSelectedLanguage > 0) {
                    --this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 5;
                break;
            }
            case 3: {
                if (this.iSelectedLanguage < 5) {
                    ++this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 0;
                break;
            }
        }
    }

    public void changeSound() {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            this.soundOn();
            this.playMusic(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.setTexts();
    }

    public void changeSelectedMenuItem(int iShift) {
        this.iSelectedMenuItem = iShift > 0 ? (this.iSelectedMenuItem < this.iMenuItemsTotal - 1 ? ++this.iSelectedMenuItem : 0) : (this.iSelectedMenuItem > 0 ? --this.iSelectedMenuItem : this.iMenuItemsTotal - 1);
    }

    public void changeSelectedButton(int iShift) {
        this.iSelectedButton = iShift > 0 ? (this.iSelectedButton < this.iButtonsTotal - 1 ? ++this.iSelectedButton : 0) : (this.iSelectedButton > 0 ? --this.iSelectedButton : this.iButtonsTotal - 1);
        this.setTexts();
    }

    public void keyReleased(int keyCode) {
        if (this.bPause) {
            if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                this.bPause = false;
                this.gameContinue();
            }
            return;
        }
        if (!(this.bMainIn || this.bMainOut || this.bMainClick || this.waitForMusic)) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 2: {
                            if (this.delay <= 100) break block0;
                            this.delay = 100;
                            break block0;
                        }
                        case 3: {
                            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                this.changeLanguage(0);
                                return;
                            }
                            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                this.changeLanguage(1);
                                return;
                            }
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                this.changeLanguage(2);
                                return;
                            }
                            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                this.changeLanguage(3);
                                return;
                            }
                            if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            this.nextScreen(0, 4);
                            return;
                        }
                        case 4: {
                            if (Keys.isFKLeftCode(keyCode)) {
                                this.soundOn();
                                this.init();
                                return;
                            }
                            if (!Keys.isFKRightCode(keyCode)) break block0;
                            this.soundOff();
                            this.init();
                            return;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                this.changeSelectedMenuItem(1);
                                return;
                            }
                            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                this.changeSelectedMenuItem(-1);
                                return;
                            }
                            if (Keys.isFKRightCode(keyCode)) {
                                if (this.game.bPause) {
                                    this.nextScreen(2, 0);
                                }
                                return;
                            }
                            if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                                this.iFlash = 150;
                                switch (this.iSelectedMenuItem) {
                                    case 0: {
                                        this.nextScreen(1, 2);
                                        break;
                                    }
                                    case 1: {
                                        this.nextScreen(1, 3);
                                        break;
                                    }
                                    case 2: {
                                        this.changeSound();
                                        break;
                                    }
                                    case 3: {
                                        if (this.game.bPause) {
                                            this.game.bPause = false;
                                            this.nextScreen(1, 1);
                                            break;
                                        }
                                        this.nextScreen(1, 4);
                                        break;
                                    }
                                }
                                return;
                            }
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                if (!this.game.bPause) {
                                    this.changeSelectedButton(-1);
                                    if (this.iSelectedButton != 2) {
                                        this.iFlash = 0;
                                        this.initNextScreen();
                                    }
                                }
                                return;
                            }
                            if (!Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) break block0;
                            if (!this.game.bPause) {
                                this.changeSelectedButton(1);
                                if (this.iSelectedButton != 2) {
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                }
                            }
                            return;
                        }
                        case 1: {
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                this.changeSelectedButton(-1);
                                if (this.iSelectedButton == 2) {
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                }
                                return;
                            }
                            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                this.changeSelectedButton(1);
                                if (this.iSelectedButton == 2) {
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                }
                                return;
                            }
                            if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            if (this.iSelectedButton == 0) {
                                this.game.isEndless = true;
                                this.nextScreen(2, 0);
                            }
                            if (this.iSelectedButton == 1) {
                                this.game.isEndless = false;
                                this.initLevelSelect();
                                this.nextScreen(1, 5);
                            }
                            return;
                        }
                        case 2: {
                            if (!Keys.isFKRightCode(keyCode)) break block0;
                            this.nextScreen(1, 0);
                            return;
                        }
                        case 3: {
                            if (!Keys.isFKRightCode(keyCode)) break block0;
                            this.nextScreen(1, 0);
                            return;
                        }
                        case 4: {
                            if (Keys.isFKLeftCode(keyCode)) {
                                this.quit();
                                return;
                            }
                            if (!Keys.isFKRightCode(keyCode)) break block0;
                            this.nextScreen(1, 0);
                            this.setTexts();
                            return;
                        }
                        case 5: {
                            if (Keys.isFKRightCode(keyCode)) {
                                this.nextScreen(1, 1);
                                return;
                            }
                            if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            if (this.iSelectedLevel <= Profile.iLevel) {
                                this.nextScreen(2, 0);
                            }
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.subScreen) {
                        case 0: {
                            if (!Keys.isFKRightCode(keyCode)) break block0;
                            this.game.pause();
                            return;
                        }
                        case 1: {
                            if (Keys.isFKRightCode(keyCode)) {
                                this.nextScreen(1, 1);
                                return;
                            }
                            if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            this.nextScreen(2, 0);
                            return;
                        }
                    }
                    break;
                }
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (!(this.bMainIn || this.bMainOut || this.bMainClick || this.waitForMusic)) {
            if (this.screen == 1 && this.subScreen == 2) {
                if (this.isPressedInstructionsText(x, y)) {
                    this.bDragInstructions = true;
                }
            } else if (this.screen == 1 && this.subScreen == 5) {
                if (this.isPressedLevelSelect(x, y)) {
                    this.iSelectedLevelX = x;
                    this.iSelectedLevelY = y;
                    this.bDragLevelSelect = true;
                }
            } else if (this.screen == 2 && this.subScreen == 0) {
                this.game.pointerPressed(x, y);
            }
        }
    }

    public void quit() {
        X.quitApp();
    }

    public boolean isMiddleButtonPressed(int x, int y) {
        return this.rectButtonCenter.contains(x, y);
    }

    public boolean isGameOverPressed(int x, int y) {
        return this.rectPlayButton.contains(x, y);
    }

    public boolean isLeftButtonPressed(int x, int y) {
        return x <= sprButtonsBg.getWidth() && y >= MainCanvas.HEIGHT - sprButtonsBg.getHeight();
    }

    public boolean isRightButtonPressed(int x, int y) {
        return x >= MainCanvas.WIDTH - sprButtonsBg.getWidth() && y >= MainCanvas.HEIGHT - sprButtonsBg.getHeight();
    }

    public void pointerDragged(int x, int y) {
        if (!(this.bMainIn || this.bMainOut || this.bMainClick || this.waitForMusic)) {
            if (this.screen == 1 && this.subScreen == 2 && this.bDragInstructions) {
                if (!this.isPressedInstructionsText(x, y)) {
                    this.bDragInstructions = false;
                }
                this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
            if (this.screen == 1 && this.subScreen == 5 && this.bDragLevelSelect) {
                if (!this.isPressedLevelSelect(x, y)) {
                    this.bDragLevelSelect = false;
                }
                this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.bPause) {
            this.bPause = false;
            this.gameContinue();
            return;
        }
        if (!(this.bMainIn || this.bMainOut || this.bMainClick || this.waitForMusic)) {
            if (this.screen == 1 && this.subScreen == 2 && this.bDragInstructions) {
                this.bDragInstructions = false;
            }
            if (this.screen == 1 && this.subScreen == 5 && this.bDragLevelSelect) {
                this.bDragLevelSelect = false;
            }
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 2: {
                            if (this.delay <= 100) break;
                            this.delay = 100;
                            break;
                        }
                        case 3: {
                            for (int i = 0; i < 6; ++i) {
                                if (!this.rectLanguages[i].contains(x, y)) continue;
                                this.iSelectedLanguage = i;
                                this.nextScreen(0, 4);
                                return;
                            }
                            break block0;
                        }
                        case 4: {
                            if (this.isLeftButtonPressed(x, y)) {
                                this.soundOn();
                                this.init();
                                return;
                            }
                            if (!this.isRightButtonPressed(x, y)) break;
                            this.soundOff();
                            this.init();
                            return;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            int i;
                            if (this.game.bPause && this.isRightButtonPressed(x, y)) {
                                if (this.game.bPause) {
                                    this.nextScreen(2, 0);
                                }
                                return;
                            }
                            for (i = 0; i < this.iMenuItemsTotal; ++i) {
                                if (!this.rectMenuItems[i].contains(x, y)) continue;
                                this.iSelectedMenuItem = i;
                                switch (this.iSelectedMenuItem) {
                                    case 0: {
                                        this.nextScreen(1, 2);
                                        break;
                                    }
                                    case 1: {
                                        this.nextScreen(1, 3);
                                        break;
                                    }
                                    case 2: {
                                        this.changeSound();
                                        break;
                                    }
                                    case 3: {
                                        if (this.game.bPause) {
                                            this.game.bPause = false;
                                            this.game.isInited = false;
                                            this.nextScreen(1, 1);
                                            break;
                                        }
                                        this.nextScreen(1, 4);
                                        break;
                                    }
                                }
                                return;
                            }
                            if (this.game.bPause) break;
                            for (i = 0; i < this.iButtonsTotal; ++i) {
                                if (this.rectMenuButtons[i].contains(x, y)) {
                                    this.iSelectedButton = i;
                                }
                                switch (this.iSelectedButton) {
                                    case 0: {
                                        this.initNextScreen();
                                        return;
                                    }
                                    case 1: {
                                        this.initNextScreen();
                                        return;
                                    }
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            if (!this.isRightButtonPressed(x, y)) break;
                            this.nextScreen(1, 0);
                            return;
                        }
                        case 1: {
                            if (this.isMiddleButtonPressed(x, y)) {
                                if (this.iSelectedButton == 0) {
                                    this.game.isEndless = true;
                                    this.nextScreen(2, 0);
                                }
                                if (this.iSelectedButton == 1) {
                                    this.game.isEndless = false;
                                    this.nextScreen(1, 5);
                                }
                                return;
                            }
                            for (int i = 0; i < this.iButtonsTotal; ++i) {
                                if (this.rectMenuButtons[i].contains(x, y)) {
                                    this.iSelectedButton = i;
                                }
                                if (this.iSelectedButton == 2) {
                                    this.initNextScreen();
                                    return;
                                }
                                this.setTexts();
                            }
                            break block0;
                        }
                        case 3: {
                            if (!this.isRightButtonPressed(x, y)) break;
                            this.nextScreen(1, 0);
                            return;
                        }
                        case 4: {
                            if (this.isLeftButtonPressed(x, y)) {
                                this.quit();
                                return;
                            }
                            if (!this.isRightButtonPressed(x, y)) break;
                            this.nextScreen(1, 0);
                            this.setTexts();
                            return;
                        }
                        case 5: {
                            for (int i = 1; i < Level2.LAST_LEVEL + 1; ++i) {
                                if (!this.rectLevelSelect[i].contains(x, y + this.iShiftY) || x != this.iSelectedLevelX || y + this.iShiftY != this.iSelectedLevelY + this.iShiftY) continue;
                                if (i <= Profile.iLevel) {
                                    this.iSelectedLevel = i;
                                }
                                return;
                            }
                            if (this.isRightButtonPressed(x, y)) {
                                this.nextScreen(1, 1);
                                return;
                            }
                            if (!this.isLeftButtonPressed(x, y)) break;
                            this.nextScreen(2, 0);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    if (this.subScreen == 0) {
                        if (!this.isRightButtonPressed(x, y)) break;
                        this.game.pause();
                        return;
                    }
                    if (this.subScreen != 1) break;
                    if (this.isRightButtonPressed(x, y)) {
                        this.nextScreen(1, 1);
                        return;
                    }
                    if (!this.isGameOverPressed(x, y)) break;
                    this.nextScreen(2, 0);
                    return;
                }
            }
        }
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.screen = 0;
        this.subScreen = 0;
    }

    public void beforeInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            this.bPause = true;
            this.strTextBody = Resources.resTexts[0].getHashedString(19);
            this.setTitleCenter(this.strTextBody);
            if (this.screen == 2 && this.subScreen == 0) {
                this.game.bPause = true;
                this.nextScreen(1, 0);
                this.iFlash = 0;
            }
        }
    }

    public void afterInteruption() {
    }

    public void initGraphics() {
        this.bLoading = true;
        Resources.loadGFonts(new int[]{0});
        this.fontMain = Resources.resGFonts[0];
        Resources.loadImages(new int[]{9, 1, 7, 8, 2, 3, 4, 5, 6});
        imgPause = Resources.resImgs[6];
        imgBg = Resources.resImgs[5];
        imgSplash = Resources.resImgs[1];
        imgInlogic = Resources.resImgs[2];
        imgCircle = Resources.resImgs[7];
        imgCircleBg = Resources.resImgs[8];
        imgFail = Resources.resImgs[3];
        imgWin = Resources.resImgs[4];
        imgMenuBg = Resources.resImgs[9];
        Resources.loadSprites(new int[]{15, 14, 12, 13, 1, 11, 6, 7, 8, 10, 9, 2, 3, 5, 4, 0});
        sprMenuBtn = Resources.resSprs[10];
        sprDotsBg = Resources.resSprs[11];
        sprButtonsBg = Resources.resSprs[9];
        sprLanguage = Resources.resSprs[0];
        sprIconsBig = Resources.resSprs[4];
        sprDialogBg = Resources.resSprs[1];
        sprDialogGreen = Resources.resSprs[2];
        sprDialogRed = Resources.resSprs[3];
        sprFKIcons = Resources.resSprs[5];
        sprArrows = Resources.resSprs[6];
        sprCover0 = Resources.resSprs[7];
        sprCover45 = Resources.resSprs[8];
        sprButtons = Resources.resSprs[12];
        sprPinsEndless = Resources.resSprs[13];
        sprPinsArcade = Resources.resSprs[14];
        sprLevelButtons = Resources.resSprs[15];
        this.nextScreen(0, 1);
        this.bLoading = false;
    }

    public void initIntro() {
        this.bLoading = true;
        this.iShiftDirection = 1;
        this.iShiftX = 0;
        this.iShiftStep = MainCanvas.WIDTH / 120;
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iShiftStep = MainCanvas.HEIGHT / 160;
        }
        this.iSelectedLanguage = 0;
        this.rectLanguages[0] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth(), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1) - sprLanguage.getHeight(), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[1] = new Rectangle(MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1) - sprLanguage.getHeight(), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[2] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth(), (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[3] = new Rectangle(MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) - (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[4] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLanguage.getWidth(), (MainCanvas.HEIGHT >> 1) + (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        this.rectLanguages[5] = new Rectangle(MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + (sprLanguage.getHeight() >> 1), sprLanguage.getWidth(), sprLanguage.getHeight());
        int pomMenuButtonHeight = (this.fontMain.getHeight() << 2) + (this.fontMain.getHeight() >> 1);
        int pomMenuButtonWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        this.rectTitleCenter = MainCanvas.HEIGHT < 241 ? new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), MainCanvas.HEIGHT >> 4, pomMenuButtonWidth, pomMenuButtonHeight >> 2) : new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), (MainCanvas.HEIGHT >> 1) - (pomMenuButtonHeight >> 1), pomMenuButtonWidth, pomMenuButtonHeight);
        this.nextScreen(0, 2);
        this.bLoading = false;
    }

    public void init() {
        this.bLoading = true;
        this.game = new Game(this);
        this.nextScreen(1, 1);
        Resources.freeSprites(new int[]{0});
        sprLanguage = null;
        System.gc();
        this.iTitlePosY = MainCanvas.HEIGHT >> 3;
        this.rectButtonCenter = new Rectangle((MainCanvas.WIDTH >> 1) - (sprIconsBig.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (sprIconsBig.getHeight() >> 1), sprIconsBig.getWidth(), sprIconsBig.getHeight());
        this.iHeaderHeight = this.fontMain.getHeight() << 1;
        this.rectMenuItems = new Rectangle[this.iMenuItemsTotal];
        this.rectMenuButtons = new Rectangle[this.iButtonsTotal];
        this.rectLevelSelect = new Rectangle[Level2.LAST_LEVEL + 1];
        int menuItemW = sprMenuBtn.getWidth();
        int menuItemH = sprMenuBtn.getHeight();
        int iMenuItemOff = MainCanvas.HEIGHT < 221 ? this.fontMain.getHeight() >> 1 : this.fontMain.getHeight();
        int menuAreaH = MainCanvas.HEIGHT - sprButtons.getHeight();
        int offY = menuAreaH - this.iMenuItemsTotal * menuItemH - (this.iMenuItemsTotal - 1) * (iMenuItemOff >> 3) >> 1;
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            this.rectMenuItems[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (menuItemW >> 1), offY + i * menuItemH + i * (iMenuItemOff >> 3), menuItemW, menuItemH);
        }
        int offX = MainCanvas.WIDTH - sprButtons.getWidth() * this.iButtonsTotal >> 1;
        for (int i = 0; i < this.iButtonsTotal; ++i) {
            this.rectMenuButtons[i] = new Rectangle(offX + i * sprButtons.getWidth(), MainCanvas.HEIGHT - (sprButtonsBg.getHeight() >> 2) * 3, sprButtons.getWidth(), sprButtons.getHeight());
        }
        this.iInstructionsHeight = MainCanvas.HEIGHT - this.iHeaderHeight - this.fontMain.getHeight() - sprButtonsBg.getHeight();
        this.iInstructionsCenterY = (this.iInstructionsHeight >> 1) + this.iHeaderHeight + this.fontMain.getHeight();
        this.iInstructionsWidth = this.rectTitleCenter.width;
        this.iAboutHeight = this.iInstructionsHeight;
        this.iAboutCenterY = (this.iAboutHeight >> 1) + this.iHeaderHeight + this.fontMain.getHeight();
        this.iAboutWidth = this.rectTitleCenter.width;
        this.iGameOverH = MainCanvas.HEIGHT <= 160 ? MainCanvas.HEIGHT - (this.fontMain.getHeight() << 2) - (sprIconsBig.getHeight() >> 1) - (sprFKIcons.getHeight() >> 2) : (MainCanvas.HEIGHT <= 480 ? MainCanvas.HEIGHT - (this.fontMain.getHeight() << 2) - sprIconsBig.getHeight() - (sprFKIcons.getHeight() >> 2) : (MainCanvas.HEIGHT <= 640 && MainCanvas.WIDTH >= 480 ? MainCanvas.HEIGHT - (this.fontMain.getHeight() << 2) - sprIconsBig.getHeight() - (sprFKIcons.getHeight() >> 2) : MainCanvas.HEIGHT - (this.fontMain.getHeight() << 2) - (sprIconsBig.getHeight() << 1) - (sprFKIcons.getHeight() >> 2)));
        this.iGameOverCenterY = (this.fontMain.getHeight() << 1) + (this.iGameOverH >> 1);
        this.iGameOverW = this.iInstructionsWidth;
        offY = MainCanvas.HEIGHT - this.iGameOverH - this.fontMain.getHeight() >> 1;
        this.rectPlayButton = new Rectangle((MainCanvas.WIDTH >> 1) - (sprIconsBig.getWidth() >> 1), MainCanvas.HEIGHT - offY - (sprIconsBig.getHeight() >> 1), sprIconsBig.getWidth(), sprIconsBig.getHeight());
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.initMainX();
        this.bLoading = false;
    }

    public void initTexts() {
        Resources.initLangDirs(langCodes[this.iSelectedLanguage]);
        Resources.loadText(0);
        this.iSelectedMenuItem = 0;
        this.iMenuItemsTotal = 4;
        this.iButtonsTotal = 3;
    }

    public void setTexts() {
        block0 : switch (this.screen) {
            case 0: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 4: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(2);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 0: {
                        this.strTextMenu[0] = Resources.resTexts[0].getHashedString(36);
                        this.strTextMenu[1] = Resources.resTexts[0].getHashedString(10);
                        this.strTextMenu[2] = Resources.resTexts[0].getHashedString(9);
                        this.strTextMenu[2] = Profile.bMusic ? this.strTextMenu[2] + " " + Resources.resTexts[0].getHashedString(15) : this.strTextMenu[2] + " " + Resources.resTexts[0].getHashedString(16);
                        if (!this.game.bPause) {
                            this.strTextMenu[3] = Resources.resTexts[0].getHashedString(50);
                            break block0;
                        }
                        this.strTextMenu[3] = Resources.resTexts[0].getHashedString(13);
                        break block0;
                    }
                    case 1: {
                        switch (this.iSelectedButton) {
                            case 0: {
                                this.strTextBody = Resources.resTexts[0].getHashedString(56);
                                this.strTextBodyType = Resources.resTexts[0].getHashedString(60) + " " + Profile.endlessHighScore;
                                break block0;
                            }
                            case 1: {
                                this.strTextBody = Resources.resTexts[0].getHashedString(58);
                                this.strTextBodyType = Resources.resTexts[0].getHashedString(52) + " " + Profile.iLevel;
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(36);
                        this.bLoading = true;
                        this.setTitleCenter(this.strTextBody);
                        this.strTextPom[0] = Resources.resTexts[0].getHashedString(8) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        int textMaxWidth = this.iInstructionsWidth - (this.iInstructionsWidth >> 3);
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.strTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + (sprArrows.getHeight() << 1);
                        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - (sprArrows.getHeight() << 1);
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iShiftY = 0;
                        this.iMaxShiftY = this.prepText.getTextHeight() - iTextHeight + this.fontMain.getHeight();
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 3: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(10);
                        this.setTitleCenter(this.strTextBody);
                        this.strTextPom[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
                        this.strTextPom[1] = Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                        break block0;
                    }
                    case 4: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(12);
                        this.setTitleCenter(this.strTextBody);
                        break block0;
                    }
                    case 5: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(52);
                        this.bDragLevelSelect = false;
                        this.iTextShiftY = 0;
                        if (this.iSelectedLevel > 10 && this.iSelectedLevel < Level2.LAST_LEVEL - 10) {
                            this.iShiftY = (sprLevelButtons.getHeight() >> 1) * (this.iSelectedLevel / 5 - 2);
                            this.lastShiftCountDown = 1;
                            this.lastShiftCountUp = 1;
                        } else {
                            this.iShiftY = this.iSelectedLevel >= Level2.LAST_LEVEL - 10 ? (sprLevelButtons.getHeight() >> 1) * (Level2.LAST_LEVEL / 5 - 4) : 0;
                        }
                        this.iMaxShiftY = Level2.LAST_LEVEL % 5 == 0 ? Level2.LAST_LEVEL / 5 * sprLevelButtons.getHeight() - sprLevelButtons.getHeight() * 5 >> 1 : (Level2.LAST_LEVEL / 5 + 1) * sprLevelButtons.getHeight() - sprLevelButtons.getHeight() * 5 >> 1;
                        this.bLoading = false;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 0: {
                        if (this.game.isEndless) break block0;
                        this.strTextPom[0] = Resources.resTexts[0].getHashedString(52) + " " + this.iSelectedLevel;
                        break block0;
                    }
                    case 1: {
                        if (this.game.isWin()) {
                            int lvl = this.iSelectedLevel;
                            if (this.iSelectedLevel < Level2.LAST_LEVEL) {
                                this.strTextPom[0] = Resources.resTexts[0].getHashedString(52) + " " + --lvl;
                                this.strTextPom[1] = Resources.resTexts[0].getHashedString(53);
                                break block0;
                            }
                            this.strTextPom[0] = Resources.resTexts[0].getHashedString(52) + " " + lvl;
                            this.strTextPom[1] = Resources.resTexts[0].getHashedString(55);
                            break block0;
                        }
                        this.strTextPom[0] = this.game.isEndless ? Resources.resTexts[0].getHashedString(57) + " " + this.game.score : Resources.resTexts[0].getHashedString(52) + " " + this.iSelectedLevel;
                        this.strTextPom[1] = Resources.resTexts[0].getHashedString(54);
                        int textMaxWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 8);
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.strTextPom[1], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void nextScreen(int nextScreen, int nextSubScreen) {
        this.screen = nextScreen;
        this.subScreen = nextSubScreen;
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.initTexts();
                        break block0;
                    }
                    case 2: {
                        this.delay = 3000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.iSelectedMenuItem = 0;
                        break block0;
                    }
                    case 5: {
                        this.iSelectedLevel = Profile.iLevel;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.iFlash = 0;
                if (this.subScreen == 1) {
                    this.waitForMusic = true;
                    this.playMusic(Sounds.MUSIC_MENU, -1);
                    this.game.isInited = false;
                    break;
                }
                if (this.subScreen != 0) break;
                this.playMusic(Sounds.MUSIC_GAME, -1);
                if (this.game.bPause) break;
                if (!this.game.isEndless) {
                    this.game.init(this.iSelectedLevel);
                    break;
                }
                this.game.initEndless();
                break;
            }
        }
        this.setTexts();
    }

    public void playMusic(int type, int times) {
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.Play(type, times);
    }

    public void paintTable(Graphics g, Sprite spr, int centerX, int centerY, int width, int height) {
        int i;
        if (height < spr.getHeight() << 1) {
            height = spr.getHeight() << 1;
        }
        int left = centerX - (width >> 1);
        int top = centerY - (height >> 1);
        int countX = (width - (spr.getWidth() << 1)) / spr.getWidth() + 1;
        int countY = (height - (spr.getHeight() << 1)) / spr.getHeight() + 1;
        int iHeight2 = height - (spr.getHeight() << 1);
        int iWidth2 = width - (spr.getWidth() << 1);
        int iX = left;
        int iY = top;
        spr.setFrame(0);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(3);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iY = top + height - spr.getHeight();
        spr.setFrame(6);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX + spr.getWidth(), top, iWidth2, MainCanvas.HEIGHT);
        for (i = 0; i < countX; ++i) {
            iY = top;
            spr.setFrame(1);
            spr.setPosition(iX += spr.getWidth(), iY);
            spr.paint(g);
            for (int j = 0; j < countY; ++j) {
                spr.setFrame(4);
                spr.setPosition(iX, iY += spr.getHeight());
                spr.paint(g);
            }
            iY = top + height - spr.getHeight();
            spr.setFrame(7);
            spr.setPosition(iX, iY);
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iX = left + width - spr.getWidth();
        iY = top;
        spr.setFrame(2);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(5);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        spr.setFrame(8);
        spr.setPosition(iX, iY);
        spr.paint(g);
    }
}

