/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

class Player {
    boolean playerMovingLeft;
    boolean playerMovingRight;
    boolean playerMovingUp;
    boolean playerMovingDown;
    boolean playerPressingAttack;
    int playerXPx;
    int playerYPx;
    int playerAngle;
    int playerMode;
    int playerFrame;
    int playerPointer;
    int playerPointerDelay;
    int playerBounces;
    int perlBaseXPx;
    int perlBaseYPx;
    int perlX;
    int perlXPx;
    int perlY;
    int perlYPx;
    int perlAngle;
    int perlSpd;
    int perlSpdX;
    int perlSpdY;
    int perlType;
    int iScore;
    int iTargetLeft;
    int iTargetRight;

    Player() {
    }

    void reset() {
        this.initPlayerPos();
        this.playerMode = 0;
        this.playerFrame = 0;
        this.playerAngle = 90;
        this.playerPointer = 8;
        this.perlType = -1979;
        this.iScore = 0;
        this.iTargetLeft = C.level.perls.iLeft + Resources.sprPerlsWidth / 2;
        this.iTargetRight = C.level.perls.iRight - Resources.sprPerlsWidth / 2;
        this.playerPointerDelay = 3000;
    }

    void initPlayerPos() {
        this.playerXPx = 115;
        this.playerYPx = 230;
        int n = 3;
        int n2 = 5;
        this.perlBaseXPx = this.playerXPx - n;
        this.perlBaseYPx = this.playerYPx + n2;
    }

    void initPerl(int n) {
        this.perlXPx = this.perlBaseXPx;
        this.perlX = this.perlXPx << 4;
        this.perlYPx = this.perlBaseYPx;
        this.perlY = this.perlYPx << 4;
        this.perlSpdX = 0;
        this.perlSpdY = 0;
        this.perlSpd = 0;
        this.perlType = n;
    }

    void save(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(this.playerXPx);
            dataOutputStream.writeInt(this.playerYPx);
            dataOutputStream.writeInt(this.playerAngle);
            dataOutputStream.writeInt(this.playerMode);
            dataOutputStream.writeInt(this.playerFrame);
            dataOutputStream.writeInt(this.playerPointer);
            dataOutputStream.writeInt(this.playerPointerDelay);
            dataOutputStream.writeInt(this.playerBounces);
            dataOutputStream.writeInt(this.perlX);
            dataOutputStream.writeInt(this.perlXPx);
            dataOutputStream.writeInt(this.perlY);
            dataOutputStream.writeInt(this.perlYPx);
            dataOutputStream.writeInt(this.perlAngle);
            dataOutputStream.writeInt(this.perlSpd);
            dataOutputStream.writeInt(this.perlSpdX);
            dataOutputStream.writeInt(this.perlSpdY);
            dataOutputStream.writeInt(this.perlType);
            dataOutputStream.writeInt(this.iScore);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void load(DataInputStream dataInputStream) {
        try {
            this.playerXPx = dataInputStream.readInt();
            this.playerYPx = dataInputStream.readInt();
            this.playerAngle = dataInputStream.readInt();
            this.playerMode = dataInputStream.readInt();
            this.playerFrame = dataInputStream.readInt();
            this.playerPointer = dataInputStream.readInt();
            this.playerPointerDelay = dataInputStream.readInt();
            this.playerBounces = dataInputStream.readInt();
            this.perlX = dataInputStream.readInt();
            this.perlXPx = dataInputStream.readInt();
            this.perlY = dataInputStream.readInt();
            this.perlYPx = dataInputStream.readInt();
            this.perlAngle = dataInputStream.readInt();
            this.perlSpd = dataInputStream.readInt();
            this.perlSpdX = dataInputStream.readInt();
            this.perlSpdY = dataInputStream.readInt();
            this.perlType = dataInputStream.readInt();
            this.iScore = dataInputStream.readInt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void incScore(int n) {
        this.iScore += n;
        if (this.iScore < 0) {
            this.iScore = 0;
        }
        C.level.bRefreshStatusScore = true;
    }

    void updatePerlMovement() {
        block17: {
            block16: {
                if (this.perlType == -1979) {
                    if (C.level.perls.bNextPerlReady) {
                        C.level.nextPerl();
                    }
                    return;
                }
                if (this.perlSpd == 0) {
                    return;
                }
                this.perlX += this.perlSpdX;
                this.perlY += this.perlSpdY;
                this.perlXPx = this.perlX >> 4;
                this.perlYPx = this.perlY >> 4;
                int n = Resources.sprPerlsWidth / 2;
                if (this.perlXPx - n <= C.level.perls.iLeft) {
                    if (this.perlType != 15) {
                        ++this.playerBounces;
                    }
                    M.canvas.createScoreLabelMul(this.perlXPx, this.perlYPx, this.playerBounces + 1);
                    this.perlSpdX = -this.perlSpdX;
                    this.perlXPx = C.level.perls.iLeft + n;
                    this.perlX = this.perlXPx << 4;
                    M.canvas.createExplosion(this.perlXPx - n, this.perlYPx, Resources.sprStars);
                    C.sounds.playSound_Bounce();
                    return;
                }
                if (this.perlXPx + n >= C.level.perls.iRight) {
                    if (this.perlType != 15) {
                        ++this.playerBounces;
                    }
                    M.canvas.createScoreLabelMul(this.perlXPx, this.perlYPx, this.playerBounces + 1);
                    this.perlSpdX = -this.perlSpdX;
                    this.perlXPx = C.level.perls.iRight - n;
                    this.perlX = this.perlXPx << 4;
                    M.canvas.createExplosion(this.perlXPx + n, this.perlYPx, Resources.sprStars);
                    C.sounds.playSound_Bounce();
                    return;
                }
                if (this.perlYPx + n < 0) {
                    if (this.perlType != 15) {
                        this.incScore(-2);
                        M.canvas.createScoreLabel(this.perlXPx, 3 * Resources.sprPerlsWidth, -2);
                        C.sounds.playSound(1, 9, 10);
                        C.level.figState[C.level.idx_octopus] = 2;
                        C.level.figRes5[C.level.idx_octopus] = 300;
                    }
                    this.perlType = -1979;
                    C.level.nextPerl();
                    return;
                }
                if (this.perlYPx + n > C.level.perls.getBottom() && this.perlSpdY > 0) {
                    M.canvas.createBubbles(this.perlXPx, this.perlYPx);
                    this.perlType = -1979;
                    C.level.nextPerl();
                    return;
                }
                if (C.level.testFigureHit(this.perlXPx, this.perlYPx) != -1) {
                    this.perlType = -1979;
                    C.level.nextPerl();
                }
                if (C.level.iLevelNum <= 22) break block16;
                if (C.level.iLevelNum < 25) break block17;
            }
            if (C.level.perls.testPerl(this.perlX, this.perlY, this.perlSpdX / 6, this.perlSpdY / 6, this.perlType)) {
                this.perlType = -1979;
                this.perlSpd = 0;
                return;
            }
        }
        if (C.level.perls.testPerl(this.perlX, this.perlY, this.perlSpdX * 2 / 6, this.perlSpdY * 2 / 6, this.perlType)) {
            this.perlType = -1979;
            this.perlSpd = 0;
        }
    }

    void update() {
        this.playerMovingLeft = (C.keyStates & 4) != 0;
        this.playerMovingRight = (C.keyStates & 0x20) != 0;
        this.playerMovingUp = (C.keyStates & 2) != 0;
        this.playerMovingDown = (C.keyStates & 0x40) != 0;
        boolean bl = this.playerPressingAttack = (C.keyStates & 0x100) != 0;
        if (this.playerMovingRight && this.playerAngle < 170) {
            this.playerAngle += 2;
        }
        if (this.playerMovingLeft && this.playerAngle > 10) {
            this.playerAngle -= 2;
        }
        if (this.playerPressingAttack && this.perlType != -1979 && this.perlSpd == 0) {
            this.playerMode = 1;
        }
        if (this.playerPointer > 10) {
            if (this.playerPointerDelay > 0) {
                this.playerPointerDelay -= 30;
            } else {
                this.playerPointerDelay = 3000;
                --this.playerPointer;
            }
        }
        this.updatePerlMovement();
    }

    void drawCircle(Graphics graphics, int n, int n2, int n3) {
        graphics.fillArc(n - n3 / 2, n2 - n3 / 2, n3, n3, 0, 360);
    }

    int getMaxPlayerFrames() {
        if (this.playerMode == 1) {
            return 14;
        }
        return 9;
    }

    int getRealPerlYPos() {
        int n = Resources.sprPerlsWidth / 2;
        int n2 = this.perlBaseYPx - n;
        if (this.playerMode == 1) {
            switch (this.playerFrame / 3) {
                case 2: 
                case 4: {
                    ++n2;
                    break;
                }
                case 3: {
                    n2 += 4;
                }
            }
        }
        return n2;
    }

    void paintPlayerCharacter(Graphics graphics) {
        Sprite sprite = Resources.sprSas1;
        if (this.playerMode == 1) {
            sprite.setFrame(this.playerFrame / 3);
        } else {
            sprite.setFrame(this.playerFrame / 5);
        }
        sprite.setPosition(this.playerXPx - sprite.getWidth() / 2, this.playerYPx);
        sprite.paint(graphics);
    }

    void paintTargeting(Graphics graphics) {
        int n = Resources.sprPerlsWidth / 2;
        int n2 = 240 - n;
        int n3 = Resources.sprPointerWidth / 2;
        Sprite sprite = Resources.sprPointer;
        int n4 = C.level.perls.getPerlVal(this.perlType);
        if (n4 < 0 || n4 > 6) {
            n4 = 7;
        }
        sprite.setFrame(n4);
        int n5 = this.perlBaseYPx;
        for (int i = 0; i < this.playerPointer && n5 > 0; ++i) {
            int n6 = this.perlBaseXPx - (Common.COS(this.playerAngle) * ((i + 1) * 12) >> 8);
            n5 = this.perlBaseYPx - (Common.SIN(this.playerAngle) * ((i + 1) * 12) >> 8);
            if (n6 < this.iTargetLeft) {
                n6 = this.iTargetLeft - (n6 - this.iTargetLeft);
            }
            if (n6 > this.iTargetRight) {
                n6 = this.iTargetRight - (n6 - this.iTargetRight);
            }
            if (n6 < this.iTargetLeft) {
                n6 = this.iTargetLeft - (n6 - this.iTargetLeft);
            }
            if (n6 > this.iTargetRight) {
                n6 = this.iTargetRight - (n6 - this.iTargetRight);
            }
            if (n6 < this.iTargetLeft) {
                n5 = -100;
            }
            sprite.setPosition(n6 - n3, n5 - n3);
            sprite.paint(graphics);
        }
    }

    void paintPerl(Graphics graphics) {
        int n = this.getRealPerlYPos();
        if (this.playerFrame < this.getMaxPlayerFrames()) {
            ++this.playerFrame;
        } else {
            if (this.playerMode == 1) {
                this.playerMode = 0;
                this.perlYPx = this.perlBaseYPx;
                this.perlY = this.perlYPx << 4;
                this.perlSpd = 2;
                this.perlAngle = this.playerAngle;
                this.perlSpdX = -Common.COS(this.perlAngle) / 2;
                this.perlSpdY = -Common.SIN(this.perlAngle) / 2;
            }
            this.playerFrame = 0;
        }
        if (this.perlType != -1979) {
            int n2 = Resources.sprPerlsWidth / 2;
            int n3 = this.perlYPx - n2;
            if (this.playerMode == 1) {
                n3 = n;
            }
            int n4 = C.level.perls.getPerlVal(this.perlType);
            boolean bl = this.perlType >= 600 && this.perlType < 700;
            boolean bl2 = this.perlType >= 700 && this.perlType < 800;
            boolean bl3 = this.perlType >= 800 && this.perlType < 900;
            Sprite sprite = Resources.sprPerls;
            sprite.setFrame(n4);
            sprite.setPosition(this.perlXPx - n2, n3);
            sprite.paint(graphics);
            if (bl) {
                Sprite sprite2 = Resources.sprPtr;
                sprite2.setPosition(this.perlXPx - n2, n3);
                sprite2.setFrame(Math.abs((int)(C.lRunCounter % 12L) / 4));
                sprite2.paint(graphics);
            }
            if (bl2) {
                sprite.setFrame(14);
                sprite.paint(graphics);
            }
            if (bl3) {
                sprite.setFrame(12);
                sprite.paint(graphics);
            }
            if (this.perlType == 15) {
                M.canvas.createBubbles(this.perlXPx, this.perlYPx);
            }
        }
    }

    void paint(Graphics graphics) {
        this.paintTargeting(graphics);
        this.paintPlayerCharacter(graphics);
    }
}

