/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class Level {
    boolean bArcadeMode;
    int iLevelNum;
    int iLevelTimer;
    int iTimeToAction;
    int iTimeToActionInit;
    int iTimeToActionDelay;
    boolean bRefreshStatusBar;
    boolean bRefreshStatusScore;
    boolean bRefreshStatusPerls;
    Player player;
    Perls perls;
    int iPerlWidth;
    int iPerlWidth2;
    int[] figType = new int[25];
    byte[] figState;
    byte[] figRes1;
    byte[] figRes2;
    byte[] figRes3;
    byte[] figRes4;
    int[] figRes5;
    int[] figRes6;
    int[] figRes7;
    int[] figRes8;
    int idx_star;
    int idx_hedgegog;
    int idx_octopus;
    int idx_fish;
    int iSelectedFlag;
    int iSelectedLevel;
    int[] iaLevelScore = null;
    int[] iaLevelBonus = null;
    int[] iaLevelTime = null;
    int[] iaLevelPerls = null;
    byte[] baLevelLock = null;
    byte[] baLevelMedal = null;
    byte[] baLevelPlayed = null;
    byte[] baAchievements = null;
    int iLastPerlsTop;
    boolean bFinaleNextRow;
    long lArcadeTotalTime;
    long lArcadeBubbles;
    long lArcadeTotalBubbles;
    int iArcadePlayedTimes;
    int iArcadeTopScore;
    long lStoryTotalTime;
    boolean bStoryCompleted;
    int iShrimpHits;
    int iArcadePerlsLeft;
    int iArcadeLevel;
    Vector vecStatsLeft;
    Vector vecStatsRight;
    RecordStore rsobj_loadsave = null;
    int iStatusColor1;
    int iStatusColor2;
    int iStatusColor3;
    int iStatusColor4;
    int[] iaTimeBarColors = new int[]{14510384, 15956289, 0xF9966F};
    boolean bRefreshStatusBarOverride = true;
    int[] mapX = new int[]{120, 154, 161, 172, 177, 190, 173, 147, 123, 105, 87, 74, 55, 38, 19, 4};
    int[] mapY = new int[]{2, 39, 64, 84, 116, 114, 144, 154, 167, 200, 219, 219, 190, 161, 135, 84};
    int buoyDepth = 0;

    Level() {
        this.iaLevelScore = new int[40];
        this.iaLevelBonus = new int[40];
        this.iaLevelTime = new int[40];
        this.iaLevelPerls = new int[40];
        this.baLevelLock = new byte[40];
        this.baLevelMedal = new byte[40];
        this.baLevelPlayed = new byte[40];
        this.baAchievements = new byte[12];
        this.vecStatsLeft = M.canvas.vecStatsLeft;
        this.vecStatsRight = M.canvas.vecStatsRight;
        this.createObjects();
        this.bArcadeMode = false;
        this.loadGame("STATS", true);
        this.updateLevelLocks();
    }

    void createObjects() {
        this.player = new Player();
        this.perls = new Perls();
        this.figType = new int[25];
        this.figState = new byte[25];
        this.figRes1 = new byte[25];
        this.figRes2 = new byte[25];
        this.figRes3 = new byte[25];
        this.figRes4 = new byte[25];
        this.figRes5 = new int[25];
        this.figRes6 = new int[25];
        this.figRes7 = new int[25];
        this.figRes8 = new int[25];
    }

    void resetStory() {
        int n;
        this.iSelectedFlag = 0;
        this.iSelectedLevel = 0;
        for (n = this.iaLevelScore.length - 1; n >= 0; --n) {
            this.iaLevelScore[n] = 0;
            this.iaLevelBonus[n] = 0;
            this.iaLevelTime[n] = -1;
            this.iaLevelPerls[n] = 0;
            this.baLevelLock[n] = 0;
            this.baLevelMedal[n] = -1;
            this.baLevelPlayed[n] = 0;
        }
        for (n = this.baAchievements.length - 1; n >= 0; --n) {
            this.baAchievements[n] = 0;
        }
        this.updateLevelLocks();
        this.lStoryTotalTime = 0L;
        this.bStoryCompleted = false;
        this.saveGame("STATS", true);
    }

    void resetStats() {
        this.resetStory();
        this.lArcadeBubbles = 0L;
        this.lArcadeTotalBubbles = 0L;
        this.lArcadeTotalTime = 0L;
        this.iArcadePlayedTimes = 0;
        this.iArcadeTopScore = 0;
        this.saveGame("STATS", true);
    }

    void updateLevelLocks() {
        int n;
        int n2 = 0;
        for (n = 0; n < 10; ++n) {
            if (this.baLevelPlayed[n] <= 0 || this.baLevelPlayed[n] >= 100) continue;
            ++n2;
        }
        for (n = 7; n >= 3; --n) {
            this.baLevelLock[n] = (byte)(n2 < 3 ? 1 : 0);
        }
        for (n = 9; n >= 8; --n) {
            this.baLevelLock[n] = (byte)(n2 < 8 ? 1 : 0);
        }
        n2 = 0;
        for (n = 0; n < 10; ++n) {
            if (this.baLevelPlayed[n + 10] <= 0 || this.baLevelPlayed[n + 10] >= 100) continue;
            ++n2;
        }
        for (n = 5; n >= 4; --n) {
            this.baLevelLock[n + 10] = (byte)(n2 < 4 ? 1 : 0);
        }
        for (n = 7; n >= 6; --n) {
            this.baLevelLock[n + 10] = (byte)(n2 < 6 ? 1 : 0);
        }
        for (n = 9; n >= 8; --n) {
            this.baLevelLock[n + 10] = (byte)(n2 < 8 ? 1 : 0);
        }
        n2 = 0;
        for (n = 0; n < 10; ++n) {
            if (this.baLevelPlayed[n + 20] <= 0 || this.baLevelPlayed[n + 20] >= 100) continue;
            ++n2;
        }
        for (n = 5; n >= 3; --n) {
            this.baLevelLock[n + 20] = (byte)(n2 < 3 ? 1 : 0);
        }
        for (n = 9; n >= 6; --n) {
            this.baLevelLock[n + 20] = (byte)(n2 < 6 ? 1 : 0);
        }
        n2 = 0;
        for (n = 0; n < 10; ++n) {
            if (this.baLevelPlayed[n + 30] <= 0 || this.baLevelPlayed[n + 30] >= 100) continue;
            ++n2;
        }
        this.baLevelLock[32] = (byte)(n2 < 2 ? 1 : 0);
        for (n = 5; n >= 3; --n) {
            this.baLevelLock[n + 30] = (byte)(n2 < 3 ? 1 : 0);
        }
        this.baLevelLock[36] = (byte)(n2 < 6 ? 1 : 0);
        this.baLevelLock[37] = (byte)(n2 < 7 ? 1 : 0);
        for (n = 9; n >= 8; --n) {
            this.baLevelLock[n + 30] = (byte)(n2 < 8 ? 1 : 0);
        }
    }

    void destroy() {
        this.saveGame("STATS", true);
        this.figType = null;
        this.figState = null;
        this.figRes1 = null;
        this.figRes2 = null;
        this.figRes3 = null;
        this.figRes4 = null;
        this.figRes5 = null;
        this.figRes6 = null;
        this.figRes7 = null;
        this.figRes8 = null;
        this.iaLevelScore = null;
        this.iaLevelBonus = null;
        this.iaLevelTime = null;
        this.iaLevelPerls = null;
        this.baLevelLock = null;
        this.baLevelMedal = null;
        this.baLevelPlayed = null;
        this.baAchievements = null;
        this.player = null;
        this.perls.destroy();
        this.perls = null;
        System.gc();
    }

    void incPoppedBubbles(int n) {
        if (this.bArcadeMode) {
            ++this.lArcadeBubbles;
            ++this.lArcadeTotalBubbles;
        } else {
            int n2 = this.iLevelNum;
            this.iaLevelPerls[n2] = this.iaLevelPerls[n2] + n;
        }
    }

    void saveGameStats(DataOutputStream dataOutputStream) {
        try {
            int n;
            dataOutputStream.writeLong(this.lArcadeTotalTime);
            dataOutputStream.writeLong(this.lArcadeTotalBubbles);
            dataOutputStream.writeInt(this.iArcadePlayedTimes);
            dataOutputStream.writeInt(this.iArcadeTopScore);
            dataOutputStream.writeLong(this.lStoryTotalTime);
            dataOutputStream.writeBoolean(this.bStoryCompleted);
            dataOutputStream.writeInt(this.iSelectedFlag);
            dataOutputStream.writeInt(this.iSelectedLevel);
            for (n = this.iaLevelScore.length - 1; n >= 0; --n) {
                System.out.println("" + n + " : " + this.iaLevelScore[n]);
                dataOutputStream.writeInt(this.iaLevelScore[n]);
                dataOutputStream.writeInt(this.iaLevelBonus[n]);
                dataOutputStream.writeInt(this.iaLevelTime[n]);
                dataOutputStream.writeInt(this.iaLevelPerls[n]);
                dataOutputStream.writeByte(this.baLevelLock[n]);
                dataOutputStream.writeByte(this.baLevelMedal[n]);
                dataOutputStream.writeByte(this.baLevelPlayed[n]);
            }
            for (n = this.baAchievements.length - 1; n >= 0; --n) {
                dataOutputStream.writeByte(this.baAchievements[n]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void saveGameArcade(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(this.iLevelNum);
            dataOutputStream.writeInt(this.iLevelTimer);
            dataOutputStream.writeInt(this.iTimeToActionInit);
            dataOutputStream.writeInt(this.iTimeToAction);
            dataOutputStream.writeInt(this.iTimeToActionDelay);
            for (int i = 0; i < 25; ++i) {
                dataOutputStream.writeInt(this.figType[i]);
                dataOutputStream.writeByte(this.figState[i]);
                dataOutputStream.writeByte(this.figRes1[i]);
                dataOutputStream.writeByte(this.figRes2[i]);
                dataOutputStream.writeByte(this.figRes3[i]);
                dataOutputStream.writeByte(this.figRes4[i]);
                dataOutputStream.writeInt(this.figRes5[i]);
                dataOutputStream.writeInt(this.figRes6[i]);
                dataOutputStream.writeInt(this.figRes7[i]);
                dataOutputStream.writeInt(this.figRes8[i]);
            }
            dataOutputStream.writeInt(this.idx_star);
            dataOutputStream.writeInt(this.idx_hedgegog);
            dataOutputStream.writeInt(this.idx_octopus);
            dataOutputStream.writeInt(this.idx_fish);
            dataOutputStream.writeInt(this.iLastPerlsTop);
            dataOutputStream.writeInt(this.iShrimpHits);
            this.perls.save(dataOutputStream);
            this.player.save(dataOutputStream);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void loadGameArcade(DataInputStream dataInputStream) {
        try {
            this.iLevelNum = dataInputStream.readInt();
            this.iLevelTimer = dataInputStream.readInt();
            this.iTimeToActionInit = dataInputStream.readInt();
            this.iTimeToAction = dataInputStream.readInt();
            this.iTimeToActionDelay = dataInputStream.readInt();
            for (int i = 0; i < 25; ++i) {
                this.figType[i] = dataInputStream.readInt();
                this.figState[i] = dataInputStream.readByte();
                this.figRes1[i] = dataInputStream.readByte();
                this.figRes2[i] = dataInputStream.readByte();
                this.figRes3[i] = dataInputStream.readByte();
                this.figRes4[i] = dataInputStream.readByte();
                this.figRes5[i] = dataInputStream.readInt();
                this.figRes6[i] = dataInputStream.readInt();
                this.figRes7[i] = dataInputStream.readInt();
                this.figRes8[i] = dataInputStream.readInt();
            }
            this.idx_star = dataInputStream.readInt();
            this.idx_hedgegog = dataInputStream.readInt();
            this.idx_octopus = dataInputStream.readInt();
            this.idx_fish = dataInputStream.readInt();
            this.iLastPerlsTop = dataInputStream.readInt();
            this.iShrimpHits = dataInputStream.readInt();
            this.perls.load(dataInputStream);
            this.player.load(dataInputStream);
        }
        catch (Throwable throwable) {
            this.resetStats();
        }
    }

    void loadGameStats(DataInputStream dataInputStream) {
        try {
            int n;
            this.lArcadeTotalTime = dataInputStream.readLong();
            this.lArcadeTotalBubbles = dataInputStream.readLong();
            this.iArcadePlayedTimes = dataInputStream.readInt();
            this.iArcadeTopScore = dataInputStream.readInt();
            this.lStoryTotalTime = dataInputStream.readLong();
            this.bStoryCompleted = dataInputStream.readBoolean();
            this.iSelectedFlag = dataInputStream.readInt();
            this.iSelectedLevel = dataInputStream.readInt();
            for (n = this.iaLevelScore.length - 1; n >= 0; --n) {
                this.iaLevelScore[n] = dataInputStream.readInt();
                this.iaLevelBonus[n] = dataInputStream.readInt();
                this.iaLevelTime[n] = dataInputStream.readInt();
                this.iaLevelPerls[n] = dataInputStream.readInt();
                this.baLevelLock[n] = dataInputStream.readByte();
                this.baLevelMedal[n] = dataInputStream.readByte();
                this.baLevelPlayed[n] = dataInputStream.readByte();
            }
            for (n = this.baAchievements.length - 1; n >= 0; --n) {
                this.baAchievements[n] = dataInputStream.readByte();
            }
        }
        catch (Throwable throwable) {
            this.resetStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(String string, boolean bl) {
        Level.deleteSavedGame(string);
        try {
            this.rsobj_loadsave = RecordStore.openRecordStore((String)string, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (bl) {
                this.saveGameStats(dataOutputStream);
            } else {
                this.saveGameArcade(dataOutputStream);
            }
            this.rsobj_loadsave.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            this.rsobj_loadsave.closeRecordStore();
        }
        catch (Exception exception) {
            Level.deleteSavedGame(string);
        }
        finally {
            if (this.rsobj_loadsave != null) {
                try {
                    this.rsobj_loadsave.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void deleteSavedGame(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadGame(String string, boolean bl) {
        boolean bl2 = false;
        try {
            this.rsobj_loadsave = RecordStore.openRecordStore((String)string, (boolean)false);
            RecordEnumeration recordEnumeration = this.rsobj_loadsave.enumerateRecords(null, null, false);
            int n = recordEnumeration.nextRecordId();
            byte[] byArray = this.rsobj_loadsave.getRecord(n);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            if (bl) {
                this.loadGameStats(dataInputStream);
            } else {
                this.loadGameArcade(dataInputStream);
            }
            this.rsobj_loadsave.closeRecordStore();
        }
        catch (Exception exception) {
            this.resetStats();
        }
        finally {
            if (this.rsobj_loadsave != null) {
                try {
                    this.rsobj_loadsave.closeRecordStore();
                }
                catch (Exception exception) {}
            }
            this.rsobj_loadsave = null;
            System.gc();
        }
        return bl2;
    }

    int getTrophyScore(int n) {
        switch (n) {
            case 0: {
                return 100;
            }
            case 1: {
                return 500;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 200;
            }
            case 4: {
                return 100;
            }
            case 5: {
                return 200;
            }
            case 6: {
                return 500;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 250;
            }
            case 9: {
                return 500;
            }
            case 10: {
                return 500;
            }
            case 11: {
                return 1000;
            }
        }
        return 0;
    }

    int totalScore() {
        int n;
        int n2 = 0;
        for (n = 39; n >= 0; --n) {
            n2 += this.iaLevelScore[n];
        }
        if (this.bStoryCompleted) {
            n = M.canvas.iaRadiusTrophies.length;
            for (int i = 0; i < n; ++i) {
                if (this.baAchievements[i] != 1) continue;
                n2 += this.getTrophyScore(i);
            }
        }
        return n2;
    }

    int totalTime() {
        int n = 0;
        for (int i = 39; i >= 0; --i) {
            n += this.iaLevelTime[i];
        }
        return n;
    }

    int totalPerls() {
        int n = 0;
        for (int i = 39; i >= 0; --i) {
            n += this.iaLevelPerls[i];
        }
        return n;
    }

    int getMedals(int n) {
        int n2 = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.baLevelMedal[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    int getFinishedLevels() {
        int n = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.baLevelPlayed[i] <= 0 || this.baLevelPlayed[i] >= 100) continue;
            ++n;
        }
        return n;
    }

    int getCompletition() {
        int n = 0;
        for (int i = 39; i >= 0; --i) {
            if (this.iaLevelScore[i] <= 0) continue;
            ++n;
        }
        return 10 * n / 4;
    }

    boolean testAchievement(int n) {
        if (this.bArcadeMode) {
            return false;
        }
        if (this.baAchievements[n] != 1) {
            this.baAchievements[n] = 1;
            this.saveGame("STATS", true);
            M.canvas.iAchievementDelay = 1000;
            M.canvas.iAchievementIdx = n;
            M.canvas.sAchievementTitle = Texts.getString("34");
            return true;
        }
        return false;
    }

    void init() {
        this.lArcadeBubbles = 0L;
        this.iTimeToActionInit = 0;
        this.perls.init();
        this.reset();
    }

    void reset() {
        this.perls.reset();
        this.player.reset();
        this.iPerlWidth = Resources.sprPerlsWidth;
        this.iPerlWidth2 = Resources.sprPerlsWidth / 2;
        M.canvas.resetScoreLabels();
        M.canvas.resetParticles();
        this.bRefreshStatusBar = true;
    }

    void initTime() {
        if (this.bArcadeMode) {
            this.iLevelTimer = 0;
            this.setTimeToAction(this.getTimeToAction());
            return;
        }
        this.iTimeToActionInit = 1000;
        switch (this.iLevelNum) {
            case 3: 
            case 4: {
                this.iLevelTimer = 60000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.iLevelTimer = 90000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.iLevelTimer = 0;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                this.iLevelTimer = 60000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 23: 
            case 24: 
            case 36: {
                this.iLevelTimer = 30000;
                this.setTimeToAction(this.getTimeToAction());
                break;
            }
            case 38: {
                this.iLevelTimer = 180000;
                this.setTimeToAction(5000);
                break;
            }
            case 39: {
                this.iLevelTimer = 240000;
                this.setTimeToAction(7000);
                break;
            }
            default: {
                this.iLevelTimer = 0;
            }
        }
    }

    void initFigures() {
        int n;
        int n2;
        Common.resetIntsArray(this.figType);
        this.idx_fish = -1979;
        this.idx_star = Common.addIntToArray(this.figType, 4);
        this.idx_octopus = Common.addIntToArray(this.figType, 2);
        this.figRes6[this.idx_star] = 0;
        this.figRes1[this.idx_star] = 0;
        this.figState[this.idx_star] = 0;
        this.figState[this.idx_octopus] = 0;
        this.figRes1[this.idx_octopus] = 0;
        if (this.iLevelNum > 22 && this.iLevelNum < 25) {
            n2 = 480 / (Resources.sprFishBlueWidth + Resources.sprFishBlueWidth / 5);
            int n3 = 200 / n2;
            int n4 = n3 / 2;
            for (int i = -100; i < 100; i += n3) {
                n = Common.addIntToArray(this.figType, 16);
                this.figRes2[n] = (byte)i;
                this.figRes5[n] = 10;
                this.figRes7[n] = 2;
                this.figRes1[n] = 0;
                n = Common.addIntToArray(this.figType, 17);
                this.figRes2[n] = (byte)i;
                this.figRes5[n] = 10 + Resources.sprFishBlueHeight * 3 / 2;
                this.figRes7[n] = 1;
                this.figRes1[n] = 0;
                if (this.iLevelNum != 24) continue;
                n = Common.addIntToArray(this.figType, 13);
                this.figRes1[n] = 0;
                this.figRes2[n] = (byte)i;
                this.figRes5[n] = 10 + Resources.sprFishBlueHeight * 4;
                this.figRes7[n] = -1;
            }
        }
        if (this.iLevelNum == 25) {
            for (n2 = 0; n2 < 360; n2 += 90) {
                n = Common.addIntToArray(this.figType, 23);
                this.figRes2[n] = (byte)n2;
                this.figRes6[n] = n2;
                this.figRes7[n] = 1;
                this.figRes1[n] = 0;
            }
        }
    }

    void prepareBackround(int n) {
        switch (n) {
            case 0: {
                this.iStatusColor1 = 9952004;
                this.iStatusColor2 = 9417984;
                this.iStatusColor3 = 5865984;
                this.iStatusColor4 = 0xFEFBFB;
                Resources.loadBackgroundImage("/b1.png");
                break;
            }
            case 1: {
                this.iStatusColor1 = 16571172;
                this.iStatusColor2 = 16560932;
                this.iStatusColor3 = 14716441;
                this.iStatusColor4 = 0xFCFAFA;
                Resources.loadBackgroundImage("/b2.png");
                break;
            }
            case 2: {
                this.iStatusColor1 = 16546190;
                this.iStatusColor2 = 15096433;
                this.iStatusColor3 = 13389924;
                this.iStatusColor4 = 0xFCFAFA;
                Resources.loadBackgroundImage("/b3.png");
                break;
            }
            case 3: {
                this.iStatusColor1 = 16548691;
                this.iStatusColor2 = 16277299;
                this.iStatusColor3 = 13582103;
                this.iStatusColor4 = 0xFCFAFA;
                Resources.loadBackgroundImage("/b4.png");
            }
        }
    }

    void prepareLevel() {
        this.iLevelNum = this.iSelectedFlag * 10 + this.iSelectedLevel;
        this.iShrimpHits = 0;
        this.bFinaleNextRow = false;
        this.prepareBackround(this.iLevelNum / 10);
        this.perls.prepareLevel(this.iLevelNum);
        this.initTime();
        this.initFigures();
        M.canvas.resetScoreLabels();
        M.canvas.resetCongratLabels();
        this.iaLevelScore[this.iLevelNum] = 0;
        this.iaLevelBonus[this.iLevelNum] = 0;
        this.iaLevelTime[this.iLevelNum] = 0;
        this.iaLevelPerls[this.iLevelNum] = 0;
        this.baLevelMedal[this.iLevelNum] = -1;
    }

    void prepareArcade() {
        this.iLevelNum = 0;
        this.iShrimpHits = 0;
        this.bFinaleNextRow = false;
        this.iArcadePerlsLeft = 50;
        this.iArcadeLevel = 0;
        this.prepareBackround(0);
        this.perls.prepareArcade();
        this.initTime();
        this.initFigures();
        M.canvas.resetScoreLabels();
        M.canvas.resetCongratLabels();
    }

    int getTimeToAction() {
        if (this.bArcadeMode) {
            int n = 2;
            n += (this.iLevelNum + 1) / 2;
            int n2 = 4;
            if ((n2 -= (this.iLevelNum + 1) / 5) < 2) {
                n2 = 2;
            }
            if (this.perls.iPerlsLeft < n * this.perls.iPerlsInLine && this.perls.getLastRowForAdd() < this.perls.iTotalLines - n2) {
                return 100;
            }
            int n3 = 15000 - this.iLevelNum / 10 * 300 - this.iLevelNum % 10 * 150;
            return n3;
        }
        if (this.perls.iLevelType == 5) {
            return 18000;
        }
        switch (this.iLevelNum) {
            case 3: {
                return 10000;
            }
            case 4: {
                return 15000;
            }
            case 5: 
            case 6: {
                return 25000;
            }
            case 10: 
            case 11: {
                return 15000;
            }
            case 12: 
            case 13: {
                return 25000;
            }
            case 38: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 3 && this.perls.iPerlsLeft < this.perls.iTotalLines / 6 * 5 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 12000;
            }
            case 39: {
                if (this.perls.bFailed) {
                    return 20000;
                }
                if (this.perls.getLastRowForAdd() < this.perls.iTotalLines - 2 && this.perls.iPerlsLeft < this.perls.iTotalLines / 5 * 4 * this.perls.iPerlsInLine) {
                    return 200;
                }
                return 18000;
            }
        }
        return 20000;
    }

    void setTimeToAction(int n) {
        this.iTimeToActionInit = this.iTimeToAction = n;
        this.iLastPerlsTop = this.perls.iTop;
        this.iTimeToActionDelay = 0;
    }

    void incTimeToAction(int n) {
        this.iTimeToAction += n;
        if (this.iTimeToAction > this.iTimeToActionInit) {
            this.iTimeToAction = this.iTimeToActionInit;
        }
    }

    void updateFigures() {
        block8: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 5: {
                    if (this.figRes2[i] < 125) {
                        int n = i;
                        this.figRes2[n] = (byte)(this.figRes2[n] + this.figRes7[i]);
                        continue block8;
                    }
                    this.figType[i] = -1979;
                    continue block8;
                }
                case 23: {
                    if (this.figRes6[i] < 360) {
                        int n = i;
                        this.figRes6[n] = this.figRes6[n] + this.figRes7[i];
                        continue block8;
                    }
                    this.figRes6[i] = 0;
                    continue block8;
                }
                case 16: 
                case 17: {
                    if (this.figRes2[i] < 100) {
                        int n = i;
                        this.figRes2[n] = (byte)(this.figRes2[n] + this.figRes7[i]);
                        continue block8;
                    }
                    this.figRes2[i] = -100;
                    continue block8;
                }
                case 13: {
                    if (this.figRes2[i] > -100) {
                        int n = i;
                        this.figRes2[n] = (byte)(this.figRes2[n] + this.figRes7[i]);
                        continue block8;
                    }
                    this.figRes2[i] = 100;
                    continue block8;
                }
                case 6: 
                case 7: {
                    if (!this.perls.bFailed) {
                        this.perls.addPerlOnTop(this.figRes3[i]);
                        if (this.iLevelNum > 37) {
                            this.perls.addPerlOnTop(this.figRes3[i]);
                        }
                    }
                    if (this.figRes2[i] < 100) {
                        int n = i;
                        this.figRes2[n] = (byte)(this.figRes2[n] + 3);
                        continue block8;
                    }
                    this.perls.bNoScoreForShakenPerls = true;
                    this.perls.shakePerls();
                    this.figType[i] = -1979;
                    this.idx_fish = -1979;
                    continue block8;
                }
                case 2: {
                    if (this.perls.bDangerousState) {
                        if (this.figState[this.idx_octopus] != 0) continue block8;
                        C.sounds.playSound(1, 7, 10);
                        this.figState[this.idx_octopus] = 2;
                        this.figRes5[this.idx_octopus] = 1000;
                        continue block8;
                    }
                    if (this.figState[this.idx_octopus] != 2) continue block8;
                    this.figState[this.idx_octopus] = 0;
                }
            }
        }
    }

    void paintFiguresBackground(Graphics graphics) {
        Sprite sprite = null;
        for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 2: {
                    sprite = Resources.sprOct1;
                    if (this.figState[i] == 1) {
                        sprite = Resources.sprOct2;
                        sprite.setFrame(Math.abs(this.figRes5[i] % 19 / 5));
                        if (this.figRes5[i] > 0) {
                            int n = i;
                            this.figRes5[n] = this.figRes5[n] - 1;
                        } else {
                            this.figState[i] = 0;
                        }
                    } else if (this.figState[i] == 2 && Resources.sprOct3 != null) {
                        sprite = Resources.sprOct3;
                        sprite.setFrame(Math.abs(this.figRes5[i] % 14 / 5));
                        if (this.figRes5[i] > 0) {
                            int n = i;
                            this.figRes5[n] = this.figRes5[n] - 1;
                        } else {
                            this.figState[i] = 0;
                        }
                    } else {
                        sprite.setFrame(Math.abs(this.figRes1[i] / 5));
                        if (this.figRes1[i] < 14) {
                            int n = i;
                            this.figRes1[n] = (byte)(this.figRes1[n] + 1);
                        } else {
                            this.figRes1[i] = -14;
                        }
                    }
                    sprite.setPosition(41, 233 + Math.abs(this.figRes1[i] / 5));
                    sprite.paint(graphics);
                }
            }
        }
    }

    int testFigureHit(int n, int n2) {
        block5: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 5: {
                    int n3;
                    int n4;
                    int n5;
                    int n6 = Resources.sprShrimpWidth;
                    int n7 = Resources.sprShrimpHeight;
                    int n8 = (this.figRes2[i] << 8 << 8) / 25600 * 61440 >> 8 >> 8;
                    int n9 = n8 - this.iPerlWidth2;
                    int n10 = n - (n8 -= n6 - this.iPerlWidth / 4 * 3);
                    if (n10 < this.iPerlWidth2 || n10 > n6 - this.iPerlWidth2 || (n5 = n2 - (n4 = this.figRes5[i])) < this.iPerlWidth2 || n5 > n7 - this.iPerlWidth2) continue block5;
                    int n11 = 20;
                    if (this.figRes6[i] != -1979) {
                        M.canvas.createBubbles(n9, n2);
                        M.canvas.createBubbles(n9, n2);
                        this.figRes6[i] = -1979;
                        n3 = M.canvas.createParticle(n9, n2, 0, 4, 0, 1, 0, 0);
                        if (n3 != -1) {
                            M.canvas.partSprite[n3] = Resources.sprPerls;
                            M.canvas.partFrame[n3] = 16;
                            M.canvas.partLife[n3] = 14;
                        }
                        n11 *= 2;
                    }
                    ++this.iShrimpHits;
                    if (this.iShrimpHits == 5) {
                        this.testAchievement(6);
                    }
                    this.figRes7[i] = 3;
                    C.sounds.playSound(1, 8, 10);
                    this.player.incScore(n11);
                    M.canvas.createScoreLabel(n, n2, n11);
                    return i;
                }
                case 23: {
                    int n5;
                    int n6 = Resources.sprHed1Width;
                    int n7 = Resources.sprHed1Height;
                    int n8 = 120 + (Common.COS(this.figRes6[i]) * ((240 - Resources.sprHed1Width) / 2) >> 8) - Resources.sprHed1Width / 2;
                    int n4 = Common.SIN(this.figRes6[i]) * 120 >> 8;
                    int n10 = n - n8;
                    if (n10 < this.iPerlWidth2 || n10 > n6 - this.iPerlWidth2 || (n5 = n2 - n4) < this.iPerlWidth2 || n5 > n7 - this.iPerlWidth2) continue block5;
                    M.canvas.createBubbles(n, n2);
                    this.player.incScore(-5);
                    M.canvas.createScoreLabel(n, n2, -5);
                    C.vibrate(60);
                    return i;
                }
                case 6: 
                case 7: 
                case 13: 
                case 16: 
                case 17: {
                    int n10;
                    int n8;
                    int n3 = this.figType[i] == 6 || this.figType[i] == 16 ? 1 : 0;
                    int n4 = this.figRes5[i];
                    if (this.figType[i] == 13) {
                        n4 += Math.abs(this.figRes1[i] / 3);
                    }
                    int n7 = Resources.sprFishBlueHeight;
                    int n6 = Resources.sprFishBlueWidth;
                    if (this.figType[i] == 13) {
                        n6 = Resources.sprHed1Width;
                        n7 = Resources.sprHed1Height;
                    }
                    int n12 = n7 / 2;
                    int n13 = n6 / 2;
                    int n5 = n2 - (n4 + n12);
                    if (n5 > this.iPerlWidth2 || n5 < -this.iPerlWidth2 || (n10 = n - ((n8 = this.figRes8[i]) + n13)) > n13 || n10 < -n13) continue block5;
                    M.canvas.createBubbles(n, n2);
                    if (this.figType[i] == 13) {
                        C.vibrate(60);
                        this.player.incScore(-5);
                        M.canvas.createScoreLabel(n, n2, -5);
                    } else {
                        int n14;
                        this.incPoppedBubbles(1);
                        C.vibrate(30);
                        this.perls.incMultiplier();
                        for (n14 = 0; n14 < n6; n14 += 4) {
                            M.canvas.createBubbles(n + n14, n2 + Common.getRandomInt(4));
                        }
                        n14 = 2;
                        if (this.figType[i] == 6 || this.figType[i] == 16) {
                            n14 = 5;
                        }
                        if (this.perls.iMultiplierVal > 1) {
                            M.canvas.createScoreLabel(n, n2, this.perls.iMultiplierVal, n14);
                        } else {
                            M.canvas.createScoreLabel(n, n2, n14);
                        }
                        this.player.incScore(n14 * this.perls.iMultiplierVal);
                        this.figType[i] = -1979;
                        int n15 = 0;
                        int n16 = this.figType.length;
                        for (int j = n16 - 1; j >= 0 && n15 == 0; --j) {
                            if (this.figType[j] == -1979 || this.figType[j] != 17 && this.figType[j] != 16) continue;
                            ++n15;
                        }
                        if (n15 == 0) {
                            this.testAchievement(10);
                        }
                    }
                    return i;
                }
            }
        }
        return -1;
    }

    void paintFiguresForeground(Graphics graphics) {
        Sprite sprite = null;
        block14: for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            switch (this.figType[i]) {
                case 23: {
                    sprite = Resources.sprHed1;
                    int n8 = 120 + (Common.COS(this.figRes6[i]) * ((240 - Resources.sprHed1Width) / 2) >> 8) - Resources.sprHed1Width / 2;
                    int n2 = Common.SIN(this.figRes6[i]) * 120 >> 8;
                    sprite.setPosition(n8, n2);
                    sprite.paint(graphics);
                    continue block14;
                }
                case 5: {
                    int n = (this.figRes2[i] << 8 << 8) / 25600 * 61440 >> 8 >> 8;
                    int n3 = C.level.perls.iLeft - this.iPerlWidth2;
                    int n4 = (n - n3) / this.iPerlWidth;
                    if (n4 == this.figRes3[i] && this.figRes6[i] != -1979) {
                        graphics.setColor(0xFF0000);
                        if (C.level.perls.canAddPerl(this.figRes4[i] + 1, this.figRes3[i])) {
                            C.level.perls.addPerl(this.figRes4[i] + 1, this.figRes3[i], this.figRes6[i]);
                            this.figRes6[i] = -1979;
                        }
                    }
                    sprite = Resources.sprShrimp;
                    sprite.setFrame(Math.abs(this.figRes1[i] / 2));
                    sprite.setPosition(n - Resources.sprShrimpWidth + this.iPerlWidth / 4 * 3, this.figRes5[i]);
                    sprite.paint(graphics);
                    if (this.figRes2[i] % 4 == 0) {
                        M.canvas.createBubbles(n - Resources.sprShrimpWidth / 2, this.figRes5[i] + 30);
                    }
                    if (this.figRes6[i] != -1979) {
                        sprite = Resources.sprPerls;
                        sprite.setFrame(this.figRes6[i]);
                        sprite.setPosition(n - this.iPerlWidth2, this.figRes5[i]);
                        sprite.paint(graphics);
                    }
                    if (this.figRes1[i] < 7) {
                        int n5 = i;
                        this.figRes1[n5] = (byte)(this.figRes1[n5] + 1);
                        continue block14;
                    }
                    this.figRes1[i] = -7;
                    continue block14;
                }
                case 6: 
                case 7: 
                case 13: 
                case 16: 
                case 17: {
                    boolean bl = this.figType[i] == 6 || this.figType[i] == 16;
                    int n = (this.figRes2[i] << 8 << 8) / 25600 * 61440 >> 8 >> 8;
                    int n6 = this.figRes5[i];
                    if (bl) {
                        n = 240 - n;
                    }
                    int n3 = C.level.perls.iLeft - this.iPerlWidth2;
                    this.figRes3[i] = (byte)((n - n3) / this.iPerlWidth);
                    if (this.figType[i] == 13) {
                        sprite = Resources.sprHed1;
                        sprite.setFrame(0);
                        n6 += Math.abs(this.figRes1[i] / 3);
                    } else {
                        sprite = bl ? Resources.sprFishBlue : Resources.sprFishRed;
                        sprite.setFrame(Math.abs(this.figRes1[i] / 3));
                    }
                    this.figRes8[i] = n -= bl ? Resources.sprFishBlueWidth : 0;
                    sprite.setPosition(n, n6);
                    sprite.paint(graphics);
                    if (this.figRes1[i] < 5) {
                        int n7 = i;
                        this.figRes1[n7] = (byte)(this.figRes1[n7] + 1);
                        continue block14;
                    }
                    this.figRes1[i] = -5;
                    continue block14;
                }
                case 4: {
                    int n = this.figRes1[i] / 2;
                    int n8 = 240 - Resources.sprStar1Width;
                    int n2 = C.HEIGHT_REAL - Resources.sprStar1Height;
                    sprite = Resources.sprStar1;
                    sprite.setPosition(n8, n2 += 20);
                    sprite.setFrame(n);
                    sprite.paint(graphics);
                    this.perls.updatePreparedPerl();
                    sprite = Resources.sprPerls;
                    int n9 = C.level.perls.iPreparedPerl;
                    boolean bl = n9 >= 600 && n9 < 700;
                    boolean bl2 = n9 >= 700 && n9 < 800;
                    boolean bl3 = n9 >= 800 && n9 < 900;
                    n9 = C.level.perls.getPerlVal(C.level.perls.iPreparedPerl);
                    sprite.setFrame(n9);
                    if (this.figState[i] == 0 || this.figState[i] == 3) {
                        switch (n) {
                            case 0: {
                                n8 += 54;
                                n2 -= 9;
                                break;
                            }
                            case 1: {
                                n8 += 54;
                                n2 -= 9;
                                break;
                            }
                            case 2: {
                                n8 += 38;
                                n2 += 3;
                                break;
                            }
                            case 3: {
                                n8 += 25;
                                n2 += 20;
                                break;
                            }
                            case 4: {
                                n8 += 18;
                                n2 += 33;
                                break;
                            }
                            case 5: {
                                n8 += 2;
                                n2 += 39;
                            }
                        }
                        sprite.setPosition(n8, n2);
                        sprite.paint(graphics);
                        if (bl) {
                            Sprite sprite2 = Resources.sprPtr;
                            sprite2.setPosition(n8, n2);
                            sprite2.setFrame(Math.abs((int)(C.lRunCounter % 12L) / 4));
                            sprite2.paint(graphics);
                        }
                        if (bl2) {
                            sprite.setFrame(14);
                            sprite.paint(graphics);
                        }
                        if (bl3) {
                            sprite.setFrame(12);
                            sprite.paint(graphics);
                        }
                        if (this.figState[i] != 3) continue block14;
                        M.canvas.createBubbles(n8 + this.iPerlWidth2, n2 + this.iPerlWidth2);
                        if (this.figRes1[i] < 11) {
                            int n10 = i;
                            this.figRes1[n10] = (byte)(this.figRes1[n10] + 1);
                            continue block14;
                        }
                        this.figState[i] = 4;
                        continue block14;
                    }
                    if (this.figState[i] != 4) continue block14;
                    n8 = 170 + (Common.COS(this.figRes6[i]) * 67 >> 8);
                    n2 = 249 + (Common.SIN(this.figRes6[i]) * 45 >> 8);
                    sprite.setPosition(n8, n2);
                    sprite.paint(graphics);
                    M.canvas.createBubbles(n8 + this.iPerlWidth2, n2 + this.iPerlWidth2);
                    if (this.figRes6[i] < 180) {
                        int n11 = i;
                        this.figRes6[n11] = this.figRes6[n11] + 20;
                        continue block14;
                    }
                    this.figRes1[i] = 0;
                    this.figState[i] = 0;
                    C.level.player.initPerl(C.level.perls.iPreparedPerl);
                    C.level.perls.prepareNextPerl();
                }
            }
        }
    }

    int statItemToShow(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 38: 
            case 39: {
                return 0;
            }
            case 23: 
            case 24: {
                return 2;
            }
        }
        return 1;
    }

    boolean objectiveCompleted() {
        if (this.bArcadeMode) {
            return false;
        }
        switch (this.iLevelNum) {
            case 0: 
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: {
                return this.perls.iActivePerlsCount == 0 && this.perls.iStackedPerlsCount == 0 && M.canvas.iActiveScoreLabels == 0 && !this.perls.bFailed;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 38: 
            case 39: {
                return this.iLevelTimer <= 0;
            }
            case 23: 
            case 24: {
                int n = 0;
                int n2 = this.figType.length;
                for (int i = n2 - 1; i >= 0 && n == 0; --i) {
                    if (this.figType[i] == -1979 || this.figType[i] != 17 && this.figType[i] != 16) continue;
                    ++n;
                }
                return this.iLevelTimer <= 0 || n == 0;
            }
            case 33: 
            case 34: 
            case 35: {
                return this.perls.iZumaPerlsCount == 0 && this.perls.iStackedPerlsCount == 0 && M.canvas.iActiveScoreLabels == 0;
            }
        }
        return false;
    }

    boolean objectiveFailed() {
        if (this.perls.bFailed) {
            return M.canvas.activeParticles() == 0;
        }
        return false;
    }

    void updateTime() {
        if (this.bArcadeMode) {
            this.iLevelTimer += 30;
            return;
        }
        switch (this.iLevelNum) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 39: {
                this.iLevelTimer -= 30;
                break;
            }
            default: {
                this.iLevelTimer += 30;
            }
        }
    }

    void updateActions() {
        if (this.iTimeToActionDelay > 0) {
            this.iTimeToActionDelay -= 30;
            return;
        }
        if (this.bArcadeMode) {
            this.iTimeToAction -= 30;
            if (this.iTimeToAction < 0 && this.player.perlSpd == 0) {
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlRowOnTop();
            }
            if (this.iArcadePerlsLeft <= 0 && !this.perls.bFailed) {
                this.iArcadePerlsLeft = 50 + this.iLevelNum * 10;
                M.canvas.createCongratLabel(0, 0, Resources.sprLabelLevelUp);
                ++this.iLevelNum;
                C.level.bRefreshStatusPerls = true;
                int n = 4 + this.iLevelNum % 10 / 3;
                Common.resetIntsArray(this.perls.iaPerlsInGame);
                Common.resetIntsArray(this.perls.iaPerlsOnStart);
                for (int i = 0; i < n; ++i) {
                    Common.addIntToArray(this.perls.iaPerlsInGame, i);
                    Common.addIntToArray(this.perls.iaPerlsOnStart, i);
                }
            }
            return;
        }
        switch (this.iLevelNum) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 38: 
            case 39: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction >= 0 || this.player.perlSpd != 0) break;
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlRowOnTop();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction < 0 && this.player.perlSpd == 0) {
                    this.setTimeToAction(this.getTimeToAction());
                    break;
                }
                this.perls.iTop = this.iLastPerlsTop + ((this.getTimeToAction() - this.iTimeToAction << 8 << 8) / (this.getTimeToAction() << 8) * (this.perls.iPerlWidth << 8) >> 8 >> 8);
                if (C.lRunCounter % 3L != 0L) break;
                this.perls.updateDangerousState();
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 37: {
                this.iTimeToAction -= 30;
                if (this.iTimeToAction >= 0 || this.player.perlSpd != 0) break;
                this.setTimeToAction(this.getTimeToAction());
                this.addPerlOnBottom();
            }
        }
    }

    byte getMedal(int n) {
        switch (n) {
            case 0: {
                if (this.iaLevelScore[n] >= 750) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 1: {
                if (this.iaLevelScore[n] >= 650) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 2: {
                if (this.iaLevelScore[n] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 3: {
                if (this.iaLevelScore[n] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 4: {
                if (this.iaLevelScore[n] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 5: {
                if (this.iaLevelScore[n] >= 350) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 250) {
                    return 1;
                }
                return 2;
            }
            case 6: {
                if (this.iaLevelScore[n] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 7: {
                if (this.iaLevelScore[n] >= 550) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 8: {
                if (this.iaLevelScore[n] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 9: {
                if (this.iaLevelScore[n] >= 900) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 700) {
                    return 1;
                }
                return 2;
            }
            case 10: {
                if (this.iaLevelScore[n] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 11: {
                if (this.iaLevelScore[n] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 12: {
                if (this.iaLevelScore[n] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 13: {
                if (this.iaLevelScore[n] >= 400) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 300) {
                    return 1;
                }
                return 2;
            }
            case 14: {
                if (this.iaLevelScore[n] >= 650) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 15: {
                if (this.iaLevelScore[n] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 16: {
                if (this.iaLevelScore[n] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 450) {
                    return 1;
                }
                return 2;
            }
            case 17: {
                if (this.iaLevelScore[n] >= 550) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 18: {
                if (this.iaLevelScore[n] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 19: {
                if (this.iaLevelScore[n] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 180) {
                    return 1;
                }
                return 2;
            }
            case 20: {
                if (this.iaLevelScore[n] >= 600) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 21: {
                if (this.iaLevelScore[n] >= 430) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 370) {
                    return 1;
                }
                return 2;
            }
            case 22: {
                if (this.iaLevelScore[n] >= 450) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 370) {
                    return 1;
                }
                return 2;
            }
            case 23: {
                if (this.iaLevelScore[n] >= 140) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 110) {
                    return 1;
                }
                return 2;
            }
            case 24: {
                if (this.iaLevelScore[n] >= 150) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 115) {
                    return 1;
                }
                return 2;
            }
            case 25: {
                if (this.iaLevelScore[n] >= 250) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 200) {
                    return 1;
                }
                return 2;
            }
            case 26: {
                if (this.iaLevelScore[n] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 180) {
                    return 1;
                }
                return 2;
            }
            case 27: {
                if (this.iaLevelScore[n] >= 300) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 250) {
                    return 1;
                }
                return 2;
            }
            case 28: {
                if (this.iaLevelScore[n] >= 290) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 240) {
                    return 1;
                }
                return 2;
            }
            case 29: {
                if (this.iaLevelScore[n] >= 250) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 200) {
                    return 1;
                }
                return 2;
            }
            case 30: {
                if (this.iaLevelScore[n] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 400) {
                    return 1;
                }
                return 2;
            }
            case 31: {
                if (this.iaLevelScore[n] >= 500) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 380) {
                    return 1;
                }
                return 2;
            }
            case 32: {
                if (this.iaLevelScore[n] >= 450) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 350) {
                    return 1;
                }
                return 2;
            }
            case 33: {
                if (this.iaLevelScore[n] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 180) {
                    return 1;
                }
                return 2;
            }
            case 34: {
                if (this.iaLevelScore[n] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 140) {
                    return 1;
                }
                return 2;
            }
            case 35: {
                if (this.iaLevelScore[n] >= 220) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 140) {
                    return 1;
                }
                return 2;
            }
            case 36: {
                if (this.iaLevelScore[n] >= 900) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 600) {
                    return 1;
                }
                return 2;
            }
            case 37: {
                if (this.iaLevelScore[n] >= 700) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 500) {
                    return 1;
                }
                return 2;
            }
            case 38: {
                if (this.iaLevelScore[n] >= 1000) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 700) {
                    return 1;
                }
                return 2;
            }
            case 39: {
                if (this.iaLevelScore[n] >= 800) {
                    return 0;
                }
                if (this.iaLevelScore[n] >= 600) {
                    return 1;
                }
                return 2;
            }
        }
        return 2;
    }

    int timeBonus(int n) {
        switch (n) {
            case 0: {
                if (this.iaLevelTime[n] >= 50000) break;
                return 150;
            }
            case 1: {
                if (this.iaLevelTime[n] >= 80000) break;
                return 150;
            }
            case 2: {
                if (this.iaLevelTime[n] >= 80000) break;
                return 150;
            }
            case 8: {
                if (this.iaLevelTime[n] >= 55000) break;
                return 150;
            }
            case 9: {
                if (this.iaLevelTime[n] >= 65000) break;
                return 150;
            }
            case 10: {
                if (this.iaLevelTime[n] >= 60000) break;
                return 150;
            }
            case 11: {
                if (this.iaLevelTime[n] >= 60000) break;
                return 150;
            }
            case 12: {
                if (this.iaLevelTime[n] >= 120000) break;
                return 150;
            }
            case 13: {
                if (this.iaLevelTime[n] >= 90000) break;
                return 150;
            }
            case 14: {
                if (this.iaLevelTime[n] >= 90000) break;
                return 150;
            }
            case 15: {
                if (this.iaLevelTime[n] >= 60000) break;
                return 150;
            }
            case 16: {
                if (this.iaLevelTime[n] >= 65000) break;
                return 150;
            }
            case 17: {
                if (this.iaLevelTime[n] >= 70000) break;
                return 150;
            }
            case 18: {
                if (this.iaLevelTime[n] >= 60000) break;
                return 150;
            }
            case 19: {
                if (this.iaLevelTime[n] >= 50000) break;
                return 150;
            }
            case 20: {
                if (this.iaLevelTime[n] >= 200000) break;
                return 150;
            }
            case 21: {
                if (this.iaLevelTime[n] >= 120000) break;
                return 150;
            }
            case 22: {
                if (this.iaLevelTime[n] >= 120000) break;
                return 150;
            }
            case 23: {
                if (this.iaLevelTime[n] >= 50000) break;
                return 150;
            }
            case 25: {
                if (this.iaLevelTime[n] >= 100000) break;
                return 150;
            }
            case 26: {
                if (this.iaLevelTime[n] >= 60000) break;
                return 150;
            }
            case 27: {
                if (this.iaLevelTime[n] >= 50000) break;
                return 150;
            }
            case 28: {
                if (this.iaLevelTime[n] >= 50000) break;
                return 150;
            }
            case 29: {
                if (this.iaLevelTime[n] >= 50000) break;
                return 150;
            }
            case 30: {
                if (this.iaLevelTime[n] >= 60000) break;
                return 150;
            }
            case 31: {
                if (this.iaLevelTime[n] >= 140000) break;
                return 150;
            }
            case 32: {
                if (this.iaLevelTime[n] >= 110000) break;
                return 150;
            }
            case 33: {
                if (this.iaLevelTime[n] >= 90000) break;
                return 150;
            }
            case 34: {
                if (this.iaLevelTime[n] >= 120000) break;
                return 150;
            }
            case 35: {
                if (this.iaLevelTime[n] >= 120000) break;
                return 150;
            }
            case 37: {
                if (this.iaLevelTime[n] >= 50000) break;
                return 150;
            }
        }
        return 0;
    }

    void onArcadeRestart() {
        this.lArcadeTotalTime += (long)this.iLevelTimer;
        ++this.iArcadePlayedTimes;
        this.saveGame("STATS", true);
        Level.deleteSavedGame("ARCADE");
    }

    void onStoryRestart(boolean bl) {
        this.iaLevelPerls[this.iLevelNum] = 0;
        this.iaLevelScore[this.iLevelNum] = 0;
        if (bl) {
            this.baLevelPlayed[this.iLevelNum] = 100;
        } else if (this.baLevelPlayed[this.iLevelNum] == 100) {
            this.baLevelPlayed[this.iLevelNum] = 2;
        } else {
            int n = this.iLevelNum;
            this.baLevelPlayed[n] = (byte)(this.baLevelPlayed[n] + 1);
        }
        this.saveGame("STATS", true);
    }

    void update() {
        if (this.objectiveFailed()) {
            if (this.bArcadeMode) {
                if (this.player.iScore > this.iArcadeTopScore) {
                    this.iArcadeTopScore = this.player.iScore;
                }
                this.onArcadeRestart();
                M.canvas.setMode(19);
                return;
            }
            this.onStoryRestart(true);
            M.canvas.setMode(22);
            return;
        }
        if (this.objectiveCompleted()) {
            int n;
            this.iaLevelBonus[this.iLevelNum] = 0;
            this.iaLevelScore[this.iLevelNum] = this.player.iScore;
            this.iaLevelTime[this.iLevelNum] = this.iLevelTimer;
            this.baLevelMedal[this.iLevelNum] = this.getMedal(this.iLevelNum);
            int n2 = this.iLevelNum;
            this.baLevelPlayed[n2] = (byte)(this.baLevelPlayed[n2] + 1);
            if (this.baLevelPlayed[this.iLevelNum] == 1) {
                int n3 = this.iLevelNum;
                this.iaLevelScore[n3] = this.iaLevelScore[n3] + 100;
                int n4 = this.iLevelNum;
                this.iaLevelBonus[n4] = this.iaLevelBonus[n4] + 100;
            }
            if ((n = this.timeBonus(this.iLevelNum)) > 0) {
                int n5 = this.iLevelNum;
                this.iaLevelScore[n5] = this.iaLevelScore[n5] + n;
                int n6 = this.iLevelNum;
                this.iaLevelBonus[n6] = this.iaLevelBonus[n6] + n;
            }
            this.updateLevelLocks();
            ++this.iSelectedLevel;
            if (this.iSelectedLevel > 9) {
                this.iSelectedLevel = 0;
                ++this.iSelectedFlag;
                if (this.iSelectedFlag > 3) {
                    this.iSelectedFlag = 3;
                    this.bStoryCompleted = true;
                }
            }
            this.saveGame("STATS", true);
            M.canvas.setMode(21);
            return;
        }
        this.player.update();
        this.perls.update();
        this.updateFigures();
        this.updateActions();
        this.updateTime();
    }

    void nextPerl() {
        this.player.playerBounces = 0;
        this.figRes6[this.idx_star] = 105;
        this.figState[this.idx_star] = 3;
        this.figRes1[this.idx_star] = 0;
        C.level.perls.bNextPerlReady = false;
    }

    void addPerlRowOnTop() {
        for (int i = 24; i >= 0; --i) {
            if (this.figType[i] == -1979) continue;
            if (this.figType[i] == 6) {
                return;
            }
            if (this.figType[i] != 7) continue;
            return;
        }
        if (this.iLevelNum > 37) {
            this.idx_fish = this.bFinaleNextRow ? Common.addIntToArray(this.figType, 6) : Common.addIntToArray(this.figType, 7);
            this.bFinaleNextRow = !this.bFinaleNextRow;
        } else {
            this.idx_fish = Common.addIntToArray(this.figType, Common.getRandomUInt(100) % 2 == 0 ? 6 : 7);
        }
        this.figRes2[this.idx_fish] = 0;
        this.figRes3[this.idx_fish] = -1;
        this.figRes1[this.idx_fish] = 0;
        this.figRes5[this.idx_fish] = Resources.sprFishBlueHeight / 4;
        C.level.perls.resetPerlAdd();
    }

    void addPerlOnBottom() {
        int n;
        for (n = 24; n >= 0; --n) {
            if (this.figType[n] == -1979 || this.figType[n] != 5) continue;
            return;
        }
        n = Common.addIntToArray(this.figType, 5);
        this.figRes1[n] = 0;
        this.figRes2[n] = 0;
        this.figRes4[n] = (byte)C.level.perls.getLastRowForAdd();
        if (this.figRes4[n] < 0) {
            this.figType[n] = -1979;
            return;
        }
        this.figRes5[n] = (this.figRes4[n] + 1) * this.iPerlWidth + C.level.perls.iTop;
        this.figRes3[n] = (byte)C.level.perls.getColForAdd(this.figRes4[n]);
        this.figRes6[n] = Common.intInArray(this.perls.iaPerlsInGame, Common.getRandomUInt(Common.intsInArray(this.perls.iaPerlsInGame)));
        if (this.iLevelNum == 37 && Common.getRandomUInt(100) < 60) {
            this.figRes6[n] = 9;
        }
        this.figRes7[n] = 1;
    }

    int paintStatusBarNumbers(Graphics graphics, int n, boolean bl) {
        int n2 = (C.stringBuffer.length() + 2) * Resources.imgScoreFontWidth - 2;
        if (bl) {
            n -= n2;
        }
        graphics.setClip(0, 0, 240, C.HEIGHT_REAL);
        graphics.setColor(16776173);
        graphics.fillRect(n, 1, n2, Resources.imgScoreFontHeight + 1);
        graphics.setColor(this.iStatusColor3);
        graphics.drawRect(n, 1, 1, Resources.imgScoreFontHeight + 1);
        graphics.drawRect(n + n2 - 1, 1, 1, Resources.imgScoreFontHeight + 1);
        Texts.drawNumbers(graphics, Resources.imgScoreFont, C.stringBuffer.toString(), n + Resources.imgScoreFontWidth, 2);
        return n2;
    }

    int paintStatusBarTime(Graphics graphics, int n, boolean bl) {
        int n2 = (C.stringBuffer.length() + 2) * Resources.imgScoreFontWidth - 2;
        if (bl) {
            n -= n2;
        }
        graphics.setClip(0, 0, 240, C.HEIGHT_REAL);
        graphics.setColor(16776173);
        graphics.fillRect(n, 1, n2, Resources.imgScoreFontHeight + 1);
        if (this.iTimeToActionDelay > 0) {
            graphics.setColor(65280);
            graphics.fillRect(n, 1, n2, Resources.imgScoreFontHeight + 1);
        } else if (this.perls.iLevelType == 1) {
            if (this.iTimeToActionInit > 3000) {
                int n3 = (this.iTimeToAction << 8 << 8) / (this.iTimeToActionInit << 8) * 512 >> 8 >> 8;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 > 2) {
                    n3 = 2;
                }
                graphics.setColor(this.iaTimeBarColors[n3]);
            }
            graphics.fillRect(n, 1, (this.iTimeToAction << 8 << 8) / (this.iTimeToActionInit << 8) * (n2 << 8) >> 8 >> 8, Resources.imgScoreFontHeight + 1);
        }
        graphics.setColor(this.iStatusColor3);
        graphics.drawRect(n, 1, 1, Resources.imgScoreFontHeight + 1);
        graphics.drawRect(n + n2 - 1, 1, 1, Resources.imgScoreFontHeight + 1);
        Texts.drawNumbers(graphics, Resources.imgScoreFont, C.stringBuffer.toString(), n + Resources.imgScoreFontWidth, 2);
        return n2;
    }

    void timeToStringBuffer(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        C.stringBuffer.setLength(0);
        C.stringBuffer.append(l2 %= 60L);
        if (C.stringBuffer.length() < 2) {
            C.stringBuffer.insert(0, '0');
        }
        C.stringBuffer.insert(0, ':');
        C.stringBuffer.insert(0, l3);
        if (l3 < 10L) {
            C.stringBuffer.insert(0, '0');
        }
    }

    boolean flagCanBeSelected() {
        return this.getFinishedLevels() >= this.iSelectedFlag * 10;
    }

    void paintStatusBar(Graphics graphics) {
        int n;
        if (!(this.bRefreshStatusBarOverride || C.lRunCounter % 3L == 0L || C.mode != 18 && C.mode != 20)) {
            return;
        }
        this.bRefreshStatusBarOverride = false;
        if (this.bRefreshStatusBar) {
            n = 0;
            graphics.setColor(this.iStatusColor1);
            graphics.fillRect(0, 0, 240, Resources.iStatusHeight);
            graphics.setColor(this.iStatusColor2);
            graphics.fillRect(0, Resources.iStatusHeight32, 240, Resources.iStatusHeight3);
            graphics.setColor(this.iStatusColor4);
            graphics.fillRect(0, 3, 240, 1);
            graphics.setColor(this.iStatusColor3);
            graphics.drawRect(0, 0, 240, Resources.iStatusHeight);
        }
        n = 0;
        if (this.bRefreshStatusScore || this.bRefreshStatusBar) {
            C.stringBuffer.setLength(0);
            C.stringBuffer.append(this.player.iScore);
            while (C.stringBuffer.length() < 6) {
                C.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            n = 4 + this.paintStatusBarNumbers(graphics, 4, false);
            this.bRefreshStatusScore = false;
        }
        if (this.bRefreshStatusBar || C.lRunCounter % 5L == 0L) {
            this.timeToStringBuffer(this.iLevelTimer);
            n = this.iTimeToActionInit > 0 ? (n += 4 + this.paintStatusBarTime(graphics, n + 4, false)) : (n += 4 + this.paintStatusBarNumbers(graphics, n + 4, false));
        }
        if (this.bArcadeMode && (this.bRefreshStatusPerls || this.bRefreshStatusBar)) {
            C.stringBuffer.setLength(0);
            C.stringBuffer.append(this.iArcadePerlsLeft);
            while (C.stringBuffer.length() < 5) {
                C.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            n += 4 + this.paintStatusBarNumbers(graphics, 4 + n, false);
            C.stringBuffer.setLength(0);
            C.stringBuffer.append(this.iLevelNum + 1);
            while (C.stringBuffer.length() < 2) {
                C.stringBuffer.insert(0, 'O');
            }
            Texts.NUMBERS = "0123456789:O";
            n += 4 + this.paintStatusBarNumbers(graphics, 4 + n, false);
            this.bRefreshStatusPerls = false;
        }
        int n2 = n + 4;
        C.stringBuffer.setLength(0);
        C.stringBuffer.append(this.perls.iMultiplierVal);
        if (C.stringBuffer.length() < 2) {
            C.stringBuffer.insert(0, '0');
        }
        n = 232 - this.paintStatusBarNumbers(graphics, 236, true);
        if (this.perls.iLevelType != 3) {
            graphics.setClip(0, 0, 240, C.HEIGHT_REAL);
            int n3 = n - n2;
            int n4 = Resources.imgScoreFontHeight;
            int n5 = 2;
            graphics.setColor(26973);
            graphics.fillRect(n -= n3, n5, n3, n4);
            int n6 = (this.perls.iMultiplierTime << 8 << 8) / (this.perls.getMultiplierTime() << 8) * (n3 << 8) >> 8 >> 8;
            graphics.setColor(7208935);
            graphics.fillRect(n, n5, n6, n4);
            graphics.setColor(16710636);
            graphics.fillRect(n, n5 + 2, n6, n4 - 2);
            graphics.setColor(this.iStatusColor3);
            graphics.drawRect(n, n5, n3, n4 - 1);
        }
    }

    void paintGame(Graphics graphics) {
        int n = Resources.iStatusHeight + 1;
        graphics.setClip(0, n, 240, C.HEIGHT_REAL - n);
        if (Resources.imgBackground != null) {
            graphics.drawImage(Resources.imgBackground, 120, C.HEIGHT_REAL, 33);
        } else {
            int n2 = 230 + Resources.sprSas1Height / 3;
            graphics.setColor(Resources.iBackColor);
            graphics.fillRect(0, n2, 240, C.HEIGHT_REAL - n2);
        }
        this.paintBorders(graphics);
        this.paintFiguresBackground(graphics);
        this.player.paint(graphics);
        this.perls.paint(graphics);
        this.player.paintPerl(graphics);
        this.paintFiguresForeground(graphics);
        M.canvas.paintParticles(graphics);
        M.canvas.paintScoreLabels(graphics);
        M.canvas.paintCongratLabels(graphics);
        this.paintStatusBar(graphics);
    }

    void paintLevelSelection(Graphics graphics) {
        if (Resources.imgMap != null) {
            graphics.drawImage(Resources.imgMap, 0, 0, 20);
        } else {
            graphics.setColor(7208423);
            graphics.fillRect(0, 0, 240, C.HEIGHT_REAL);
        }
        Sprite sprite = Resources.sprFlags;
        Sprite sprite2 = Resources.sprBuoys;
        int n = this.mapX.length;
        int n2 = this.getFinishedLevels();
        for (int i = 0; i < n; ++i) {
            if (i % 5 == 0) {
                if (n2 < i / 5 * 10) {
                    sprite.setFrame(0);
                } else {
                    sprite.setFrame(i / 5 + 1);
                }
                sprite.setPosition(this.mapX[i], this.mapY[i]);
                sprite.paint(graphics);
                if (i / 5 == this.iSelectedFlag && this.buoyDepth < 0) {
                    graphics.drawImage(Resources.imgFlagFr, this.mapX[i] - 2, this.mapY[i] - 2, 20);
                }
            } else {
                int n3 = 0;
                if (n2 < i) {
                    sprite2.setFrame(0);
                } else {
                    if (i < 10) {
                        sprite2.setFrame(2);
                    } else {
                        sprite2.setFrame(1);
                    }
                    n3 = Math.abs(this.buoyDepth / 40) * (i % 2 == 0 ? 1 : -1);
                }
                sprite2.setPosition(this.mapX[i], this.mapY[i] + n3);
                sprite2.paint(graphics);
            }
            if (this.buoyDepth < 120) {
                ++this.buoyDepth;
                continue;
            }
            this.buoyDepth = -120;
        }
    }

    void updateLevelInfo() {
        int n = this.iSelectedFlag * 10;
        int n2 = n + this.iSelectedLevel;
        this.vecStatsLeft.removeAllElements();
        this.vecStatsRight.removeAllElements();
        if (this.baLevelPlayed[n2] == 100) {
            this.vecStatsLeft.addElement(Texts.getString("52"));
            this.vecStatsRight.addElement("");
        } else if (this.baLevelPlayed[n2] > 0) {
            this.vecStatsLeft.addElement(Texts.getString("1"));
            this.vecStatsRight.addElement("" + this.iaLevelScore[n2]);
            int n3 = this.statItemToShow(n2);
            if (n3 == 0) {
                this.vecStatsLeft.addElement(Texts.getString("3"));
                this.vecStatsRight.addElement("" + this.iaLevelPerls[n2]);
            } else if (n3 == 2) {
                this.vecStatsLeft.addElement(Texts.getString("4"));
                this.vecStatsRight.addElement("" + this.iaLevelPerls[n2]);
            } else {
                this.timeToStringBuffer(this.iaLevelTime[n2]);
                this.vecStatsLeft.addElement(Texts.getString("5"));
                this.vecStatsRight.addElement(C.stringBuffer.toString());
            }
            if (this.iaLevelScore[n2] > 0) {
                this.vecStatsLeft.addElement(Texts.getString("6"));
                this.vecStatsRight.addElement("#m" + this.baLevelMedal[n2]);
            }
        } else {
            this.vecStatsLeft.addElement(Texts.getString("21"));
            this.vecStatsRight.addElement("");
        }
        this.vecStatsLeft.addElement(Texts.getString("17"));
        this.vecStatsRight.addElement("" + this.totalScore());
        M.canvas.calculateStatsWidths();
    }

    void paintLevelDetails(Graphics graphics) {
        int n;
        Texts.setFontSize(8);
        int n2 = 3;
        int n3 = Texts.iFontHeight + 2;
        int n4 = Resources.sprBtnRed.getWidth();
        int n5 = Resources.sprBtnRed.getWidth();
        int n6 = 2;
        int n7 = 3;
        int n8 = 5 * Resources.imgBtnSqrWidth + 6 * n7 + 2 * n4;
        int n9 = 2 * Resources.imgBtnSqrWidth + 2 * n5 + 3 * n6;
        int n10 = (240 - n8) / 2;
        int n11 = this.iSelectedFlag * 10;
        int n12 = n10;
        int n13 = 240 - 2 * n10;
        if (M.canvas.menuState != 0) {
            n12 -= n10 + n9 - ((M.canvas.iarrElasticMovement[M.canvas.menuAnimOffs] << 8 << 8) / 25600 * (n10 + n9 << 8) >> 8 >> 8);
        }
        graphics.setColor(15128735);
        M.canvas.paintGuiRect(graphics, Resources.sprBtnRed, n10, n12, n8, n9);
        graphics.setClip(0, 0, 240, C.HEIGHT_REAL);
        int n14 = n12 + n5 + n7;
        int n15 = n10 + n4 + n7;
        for (n = 0; n < 5; ++n) {
            if (this.baLevelLock[n11 + n] != 0) {
                graphics.drawImage(Resources.imgBtnSqrGr, n15, n14, 20);
            } else {
                graphics.drawImage(Resources.imgBtnSqr, n15, n14, 20);
                this.paintLevelIcon(graphics, n15, n14, n11 + n);
            }
            if (n == this.iSelectedLevel && this.buoyDepth < 0) {
                graphics.drawImage(Resources.imgBtnSqrFr, n15 - 1, n14 - 1, 20);
            }
            n15 += Resources.imgBtnSqrWidth + n7;
        }
        n14 += Resources.imgBtnSqrWidth + n7;
        n15 = n10 + n4 + n7;
        for (n = 0; n < 5; ++n) {
            if (this.baLevelLock[n11 + 5 + n] != 0) {
                graphics.drawImage(Resources.imgBtnSqrGr, n15, n14, 20);
            } else {
                graphics.drawImage(Resources.imgBtnSqr, n15, n14, 20);
                this.paintLevelIcon(graphics, n15, n14, n11 + 5 + n);
            }
            if (n + 5 == this.iSelectedLevel && this.buoyDepth < 0) {
                graphics.drawImage(Resources.imgBtnSqrFr, n15 - 1, n14 - 1, 20);
            }
            n15 += Resources.imgBtnSqrWidth + n7;
        }
        n2 = 3;
        n12 = n10 + n9 + 3;
        n9 = M.canvas.calcStatsHeight();
        if (M.canvas.menuState != 0) {
            n12 += n9 - ((M.canvas.iarrElasticMovement[M.canvas.menuAnimOffs] << 8 << 8) / 25600 * (n9 << 8) >> 8 >> 8);
        }
        graphics.setColor(15128735);
        M.canvas.paintGuiRect(graphics, Resources.sprBtnRed, n10, n12, n8, n9);
        n = Resources.sprBtnRed.getWidth();
        if (M.canvas.menuState == 0) {
            int n16 = Resources.sprBtnRed.getWidth();
            int n17 = n12 + Resources.sprBtnRed.getHeight();
            int n18 = this.vecStatsLeft.size();
            for (int i = 0; i < n18; ++i) {
                n17 += M.canvas.paintStatsLine(graphics, this.vecStatsLeft.elementAt(i).toString(), this.vecStatsRight.elementAt(i).toString(), n10 + n16, n17, n8 - 2 * n16, n3) + n6;
            }
        }
    }

    void paintLevelIcon(Graphics graphics, int n, int n2, int n3) {
        int n4 = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsBgWidth) / 2;
        int n5 = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsBgHeight) / 2;
        int n6 = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlWidth) / 2;
        int n7 = (Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlHeight) / 2;
        int n8 = Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlWidth;
        int n9 = Resources.imgBtnSqrWidth - Resources.sprBtnIcnsSmlHeight;
        Sprite sprite = Resources.sprBtnIcnsBg;
        Sprite sprite2 = Resources.sprBtnIcnsSml;
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 8: 
            case 9: {
                sprite.setFrame(1);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                sprite.setFrame(0);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                sprite.setFrame(3);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 14: 
            case 15: {
                sprite2.setFrame(2);
                sprite2.setPosition(n + n6, n2 + n7);
                sprite2.paint(graphics);
                break;
            }
            case 16: 
            case 17: {
                sprite.setFrame(6);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 18: 
            case 19: {
                sprite.setFrame(7);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 37: {
                sprite.setFrame(4);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 23: 
            case 24: {
                sprite.setFrame(9);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                sprite.setFrame(10);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                sprite.setFrame(2);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                sprite.setFrame(5);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
                break;
            }
            case 38: 
            case 39: {
                sprite.setFrame(8);
                sprite.setPosition(n + n4, n2 + n5);
                sprite.paint(graphics);
            }
        }
        switch (n3) {
            case 26: 
            case 27: {
                sprite2.setFrame(4);
                sprite2.setPosition(n + n6, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 28: {
                sprite2.setFrame(4);
                sprite2.setPosition(n + n6, n2 + n7);
                sprite2.paint(graphics);
                break;
            }
            case 36: {
                sprite2.setFrame(4);
                sprite2.setPosition(n, n2 + Resources.sprBtnIcnsSmlHeight / 3);
                sprite2.paint(graphics);
                sprite2.setPosition(n + n8, n2);
                sprite2.paint(graphics);
            }
        }
        switch (n3) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 27: 
            case 28: 
            case 31: 
            case 35: 
            case 39: {
                sprite2.setFrame(0);
                sprite2.setPosition(n + n9, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 24: {
                sprite2.setFrame(1);
                sprite2.setPosition(n + n9, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 34: {
                sprite2.setFrame(6);
                sprite2.setPosition(n + n9, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 12: {
                sprite2.setFrame(7);
                sprite2.setPosition(n + n7, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 10: 
            case 36: {
                sprite2.setFrame(5);
                sprite2.setPosition(n + n7, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 32: {
                sprite2.setFrame(8);
                sprite2.setPosition(n + n7, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 11: {
                sprite2.setFrame(5);
                sprite2.setPosition(n + n7, n2 + n9);
                sprite2.paint(graphics);
                sprite2.setFrame(0);
                sprite2.setPosition(n + n9, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 13: {
                sprite2.setFrame(9);
                sprite2.setPosition(n + n7, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 21: 
            case 29: 
            case 37: {
                sprite2.setFrame(3);
                sprite2.setPosition(n + n9, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 22: {
                sprite2.setFrame(2);
                sprite2.setPosition(n + n9, n2 + n9);
                sprite2.paint(graphics);
            }
        }
        switch (n3) {
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 28: 
            case 29: {
                sprite2.setFrame(0);
                sprite2.setPosition(n, n2 + n9);
                sprite2.paint(graphics);
                break;
            }
            case 25: {
                sprite2.setFrame(4);
                sprite2.setPosition(n + n6, n2 + n7);
                sprite2.paint(graphics);
                sprite2.setFrame(1);
                sprite2.setPosition(n + n7, n2);
                sprite2.paint(graphics);
                sprite2.setPosition(n + n9, n2 + n9);
                sprite2.paint(graphics);
                sprite2.setPosition(n, n2 + n9);
                sprite2.paint(graphics);
            }
        }
    }

    void paintBorders(Graphics graphics) {
        int n = Resources.iStatusHeight + 1;
        graphics.setClip(0, n, 240, C.HEIGHT_REAL - n);
        Sprite sprite = Resources.sprBorders;
        int n2 = sprite.getWidth();
        int n3 = sprite.getHeight();
        int n4 = this.perls.iLeft - n2;
        n4 = n4 > 0 ? 0 : n4;
        int n5 = this.perls.iRight;
        n5 = n5 + n2 < 240 ? 240 - n2 : n5;
        int n6 = 0;
        do {
            sprite.setFrame(0);
            sprite.setPosition(n4, n6);
            sprite.paint(graphics);
            sprite.setFrame(1);
            sprite.setPosition(n5, n6);
            sprite.paint(graphics);
        } while ((n6 += n3) < C.HEIGHT_REAL);
    }

    void paint(Graphics graphics) {
        switch (C.mode) {
            case 11: {
                this.paintLevelSelection(graphics);
                M.canvas.updateMenuAnimation();
                M.canvas.paintLeftButton(graphics, Resources.sprBtnRed, Texts.getHashedString("0"));
                break;
            }
            case 12: {
                this.paintLevelSelection(graphics);
                this.paintLevelDetails(graphics);
                M.canvas.updateMenuAnimation();
                M.canvas.paintLeftButton(graphics, Resources.sprBtnRed, Texts.getHashedString("44"));
                if (this.baLevelLock[this.iSelectedFlag * 10 + this.iSelectedLevel] != 0) break;
                M.canvas.paintRightButton(graphics, Resources.sprBtnRed, Texts.getHashedString("58"));
                break;
            }
            case 13: {
                this.paintLevelSelection(graphics);
                M.canvas.paintSimpleText(graphics, Resources.sprBtnRed);
                M.canvas.updateMenuAnimation();
                M.canvas.paintLeftButton(graphics, Resources.sprBtnRed, Texts.getHashedString("44"));
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                this.paintGame(graphics);
            }
        }
    }
}

