/*
 * Decompiled with CFR 0.152.
 */
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Menu
implements Constants {
    public static final int MENU_MAIN = 0;
    public static final int MENU_GAME = 1;
    public static final int MENU_CONFIRM_NEW_GAME = 2;
    public static final int MENU_OPTIONS = 3;
    public static final int MENU_ABOUT = 4;
    public static final int MENU_HELP = 5;
    public static final int MENU_GAME_HELP = 6;
    public static final int MENU_ACTIVITIES_HELP = 7;
    public static final int MENU_PAUSE = 8;
    public static final int MENU_MINI_PAUSE = 9;
    public static final int MENU_MINI_HELP = 10;
    public static final int MENU_CONFIRM_EXIT = 11;
    public static final int MENU_CONFIRM_RESET = 12;
    public static final int MENU_GENDER_SELECT = 13;
    public static final int MENU_MINIGAMES = 14;
    public static final int MENU_MOREGAMES = 15;
    public static final int MENU_CREATION = 16;
    public static final int MENU_CREATION_TEXT = 17;
    public static final int MENU_CREATION_CLOTHES_TYPE = 18;
    public static final int MENU_SLEEP = 19;
    public static final int MENU_SIMS = 20;
    public static final int MENU_HOME = 21;
    public static final int MENU_MORE_GAMES_STATIC = 22;
    public static final int MENU_MOREGAMES_CONFIRM_EXIT = 23;
    public static final int MENU_WAP_ERROR = 24;
    public static final int MENU_CONFIRM_QUIT = 25;
    public static final int MENU_LANGUAGE = 26;
    public static final int MENU_HIGHSCORES = 27;
    public static final int MENU_FINAL_RESULTS = 28;
    public static final int ITEM_ENGLISH = 0;
    public static final int ITEM_FRENCH = 1;
    public static final int ITEM_ITALIAN = 2;
    public static final int ITEM_GERMAN = 3;
    public static final int ITEM_SPANISH = 4;
    public static final int NUM_LANGUAGE_OPTIONS = 5;
    public static final int TYPE_FLAT = 0;
    public static final int TYPE_MESSAGEBOX = 1;
    public static final int TYPE_SOUND = 2;
    public static final int TYPE_MORE_GAMES = 3;
    public static final int TYPE_HIGHSCORES = 4;
    public static final int TYPE_FINAL_RESULTS = 5;
    public static final int TYPE_CREATION = 6;
    public static final int TYPE_SIMS = 7;
    public static final int TYPE_SPLASH = 8;
    public static final int TYPE_QUICK_TRAVEL = 9;
    public static final int TYPE_TAB = 10;
    public static final int SUBTYPE_MESSAGEBOX_CONFIRM = 0;
    public static final int SUBTYPE_MESSAGEBOX_TEXT = 1;
    public static final int ITEM_FEMALE = 0;
    public static final int ITEM_MALE = 1;
    public static final int NUM_GENDER_ITEMS = 2;
    public static final int ITEM_GAME = 0;
    public static final int ITEM_OPTIONS = 1;
    public static final int ITEM_HELP = 2;
    public static final int ITEM_ABOUT = 3;
    public static final int ITEM_HIGHSCORES = 4;
    public static final int ITEM_MORE_GAMES = 5;
    public static final int ITEM_EXIT = 6;
    public static int NUM_MAIN_ITEMS = 7;
    public static final int ITEM_LEI = 0;
    public static final int NUM_MINIGAME_ITEMS = 1;
    public static final int ITEM_ARROWS = -2;
    public static final int ITEM_VIBRATION = -1;
    public static final int ITEM_SOUND = 0;
    public static final int ITEM_OPTIONS_LANGUAGE = 1;
    public static final int ITEM_RESETGAME = 2;
    public static final int NUM_OPTION_ITEMS = 3;
    public static final int ITEM_SHIRT_PANTS = 0;
    public static final int ITEM_ONE_PEICE = 1;
    public static final int NUM_CLOTHES_ITEMS = 2;
    public static final int CREATION_SCREEN_BODY = 0;
    public static final int CREATION_SCREEN_FACE = 1;
    public static final int CREATION_SCREEN_HAIR = 2;
    public static final int CREATION_SCREEN_CLOTHES = 3;
    public static final int NUM_CREATION_SCREENS = 4;
    public static final int CREATE_INFO = -1;
    public static final int CREATE_STATE_GENDER = 0;
    public static final int CREATE_STATE_SKIN = 1;
    public static final int CREATE_STATE_EYE_STYLE = 2;
    public static final int CREATE_STATE_EYE_COLOR = 3;
    public static final int CREATE_STATE_HAIR_STYLE = 4;
    public static final int CREATE_STATE_HAIR_COLOR = 5;
    public static final int CREATE_STATE_SHIRT_STYLE = 6;
    public static final int CREATE_STATE_SHIRT_COLOR = 7;
    public static final int CREATE_STATE_PANT_STYLE = 8;
    public static final int CREATE_STATE_PANT_COLOR = 9;
    public static final int CREATE_STATE_DONE = 10;
    public static final int CREATE_STATE_NAME = 11;
    public static final int BUTTON_UNSELECTED = 0;
    public static final int BUTTON_SELECTED = 1;
    public static final int BUTTON_HIGHLIGHTED = 2;
    public static final int NUM_BUTTON_SELECTIONS = 3;
    public static final int MENU_STACK_CUR_MENU = 0;
    public static final int MENU_STACK_HIGHLIGHT = 1;
    public static final int MENU_STACK_TYPE = 2;
    public static final int MENU_STACK_SUBTYPE = 3;
    public static final int MENU_STACK_NUM_ITEMS = 4;
    public static final int MENU_STACK_START_STRING = 5;
    public static final int MENU_STACK_TITLE = 6;
    public static final int MENU_STACK_ROW = 7;
    public static final int MENU_STACK_COL = 8;
    public static final int NUM_MENU_STACK_ITEMS = 9;
    public static final int PAUSE_ITEM_ARROWS = -2;
    public static final int PAUSE_ITEM_VIBRATION = -1;
    public static final int PAUSE_ITEM_CONTINUE = 0;
    public static final int PAUSE_ITEM_MAIN_MENU = 1;
    public static final int PAUSE_ITEM_HELP = 2;
    public static final int PAUSE_ITEM_SOUND = 3;
    public static final int NUM_MINI_PAUSE_ITEMS = 4;
    public static final int HELP_ITEM_GAME = 0;
    public static final int HELP_ITEM_ACTIVITIES = 1;
    public static final int NUM_HELP_ITEMS = 2;
    public static final int SPLASH_EA = 0;
    public static final int SPLASH_DIAMOND_UP = 1;
    public static final int SPLASH_DIAMOND_DOWN = 2;
    public static final int SPLASH_WAIT = 3;
    public static final int ITEM_CLOTHES = 0;
    public static final int ITEM_TROPHY_ROOM = 1;
    public static final int NUM_HOME_ITEMS = 2;
    public static final int MENU_GROW_INIT = 0;
    public static final int MENU_SHRINK = 1;
    public static final int MENU_GROW_2 = 2;
    public static final int MENU_SHRINK_2 = 3;
    public static final int SIMS_STATE_IDLE = 0;
    public static final int SIMS_STATE_ENTERING = 1;
    public static final int SIMS_STATE_LEAVING = 2;
    public static final int SIMS_STATE_MENU = 3;
    public static final int SIMS_MOVE_LEFT = 0;
    public static final int SIMS_MOVE_RIGHT = 1;
    public static final int NUM_PAUSE_ITEMS = 4;
    public static final int TIME_OK_PRESS = 400;
    public static final int TAB_MAP = 0;
    public static final int TAB_ITEMS = 1;
    public static final int TAB_CHARACTERS = 2;
    public static final int TAB_FISH = 3;
    public static final int TAB_QUESTS = 4;
    public static final int NUM_TABS = 5;
    public static final int MG_BUTTON_NONE = 0;
    public static final int BUY_WAP = 1;
    public static final int MORE_STATIC = 2;
    public static final int MORE_WAP = 3;
    Game game;
    int type;
    int subType;
    int curMenu;
    int stringWidth;
    int numRows;
    int numColumns;
    int highlight;
    int highlightCol;
    int messageHeight;
    int stringHeight;
    int menuFlatTop;
    int title;
    int returnMenu;
    int numPages;
    int pageNum;
    int outfitsUnlocked;
    int animState;
    int lastW;
    int lastH;
    GraphicFont font;
    GraphicFont highlightFont;
    String strMessage;
    Stack prevMenus;
    int[] menuItems;
    boolean backedOut;
    boolean simCreation;
    Image imgBg;
    Image imgDPad;
    Position posBg;
    Image imgLogo;
    PackedSprite sprGender;
    PackedSprite sprGenderOn;
    int lastGameState;
    int menuSoftkeyL;
    int menuSoftkeyR;
    int curCreationScreen;
    int selRow;
    int selCol;
    int[][] curScreenTable;
    int[] curColorArray;
    int pressed;
    long keyPressTime;
    long anim_time;
    PackedSprite[] body;
    PackedSprite[] faces;
    PackedSprite[] shirts;
    PackedSprite[] pants;
    PackedSprite[] hairs;
    PackedSprite sprLogo;
    PackedSprite pedestal;
    PackedSprite topIcon;
    PackedSprite gridClothesTypes;
    PackedSprite selectorArrows;
    PackedSprite gridHairTypes;
    PackedSprite gridEyeTypes;
    PackedSprite topButton;
    PackedSprite sprItemButton;
    Image imgCreationBox;
    Image imgColorSelection;
    Image imgColorSelected;
    int curCreationState;
    int curStateRowStart;
    int curStateRowEnd;
    int gridHeight;
    int gridWidth;
    int state;
    int sims_state;
    int sim_direction;
    int curBodyColor;
    int curFaceColor;
    int curShirtColor;
    int curPantColor;
    int curHairColor;
    int faceFrame;
    int hairFrame;
    long entryTime;
    String curEntry;
    int entryIndex;
    int SIMS_ITEM_START_GAME;
    int SIMS_ITEM_NEW_EDIT;
    int SIMS_ITEM_CHOOSE;
    int SIMS_ITEM_DELETE;
    Vector simsItems;
    int simsHighlight;
    int lastItemSelected;
    Image[] imgBoxes;
    Image imgBevel;
    Image imgNameBadge;
    Image imgSpotlight;
    Image imgTravelBg;
    PackedSprite sprHudTiles;
    PackedSprite sprDots;
    PackedSprite sprDiamond;
    PackedSprite charIcons;
    PackedSprite travelIcons;
    PackedSprite sprTravelMap;
    int curTravelIcon;
    boolean mapIntro;
    int ITEM_NEW_GAME;
    int ITEM_CONTINUE;
    int ITEM_SIMS;
    int ITEM_ACTIVITIES;
    Sim currentSim;
    int curTab;
    int numFish;
    int numTabItems;
    int numTotalItems;
    int numItemsOnPage;
    int tabScrollY;
    int bagHelpText;
    int tabEndY;
    PackedSprite friendMeter;
    PackedSprite friendFaces;
    PackedSprite sprMenuTabs;
    PackedSprite sprTabArrows;
    Image imgTabBg;
    long wait_time;
    public int prevBodyColor;
    public int prevFaceColor;
    public int prevHairColor;
    public int prevShirtColor;
    public int prevPantColor;
    public int prevShirtType;
    public int prevPantType;
    public int prevFaceFrame;
    public int prevHairFrame;
    public boolean prevIsFemale;
    String prevName;
    Image[] mgImages;
    String[] mgTitles;
    int highlightButton;
    int[][] buttons;
    String exitURI;

    public Menu(Game game) {
        this.game = game;
        this.highlightFont = game.highlightFont;
        this.prevMenus = new Stack();
        this.returnMenu = -1;
        this.bagHelpText = -1;
    }

    void initMenuSytem(int n) {
        this.setBg(148);
        this.loadTabRes();
        this.sprDiamond = new PackedSprite(213, 191);
        this.sprDiamond.position = new Position(30720, 44544);
        this.sprDiamond.speed = 100;
        this.imgLogo = Game.createImage(149);
        this.anim_time = -1L;
        this.sprLogo = new PackedSprite(238, 226);
        this.sprLogo.num_loops = 1;
        this.sprLogo.speed = 100;
        this.sprTabArrows = new PackedSprite(315, 269);
    }

    void loadTabRes() {
        this.imgTravelBg = Game.createImage(189);
        this.sprTravelMap = new PackedSprite(this.imgTravelBg, 273);
        this.friendFaces = new PackedSprite(294, 254);
        this.charIcons = new PackedSprite(287, 251);
        this.sprMenuTabs = new PackedSprite(292, 252);
    }

    void freeTabRes() {
        this.imgTravelBg = null;
        this.imgTabBg = null;
        this.friendMeter = null;
        this.friendFaces = null;
        this.charIcons = null;
        this.sprMenuTabs = null;
        this.sprTravelMap = null;
    }

    void setBg(int n) {
        this.setBg(n, null);
    }

    void setBg(int n, int[] nArray) {
        this.imgBg = Game.createImage(n, nArray);
        this.posBg = new Position(0, 0);
        this.posBg.moveTo(-this.imgBg.getWidth(), -this.imgBg.getHeight(), 0, 600);
    }

    void initMessageBox(int n, int n2, int n3, boolean bl) {
        this.game.softkeyR = 2;
        if (!(this.type != 0 && this.type != 3 || this.backedOut)) {
            this.pushMenu();
        }
        this.highlight = 0;
        this.curMenu = n;
        if (this.returnMenu == -1) {
            this.returnMenu = n;
        }
        this.type = 1;
        this.subType = n3;
        this.menuItems = new int[2];
        this.menuItems[0] = n2;
        this.menuItems[1] = n2;
        this.pageNum = 0;
        String string = "";
        this.messageHeight = (348 - this.game.sprSoftkeys.frameHeight - 10) / this.game.fontTiny.leading * this.game.fontTiny.leading;
        this.appendText(string);
        this.game.softkeyL = this.numPages > 1 ? 3 : (n3 == 0 ? 0 : -1);
        this.backedOut = false;
    }

    void initMoreGamesMenu() {
        if (this.type != 1) {
            this.pushMenu();
        }
        this.backedOut = false;
        this.selectorArrows = new PackedSprite(168, 192);
        this.type = 3;
        this.subType = -1;
        this.menuItems = new int[this.game.NUM_MORE_GAMES];
        this.mgImages = new Image[this.game.NUM_MORE_GAMES];
        this.mgTitles = new String[this.game.NUM_MORE_GAMES];
        this.buttons = new int[this.game.NUM_MORE_GAMES][];
        for (int i = 0; i < this.game.NUM_MORE_GAMES; ++i) {
            int n = -1;
            if (this.game.gameURIs[i][2].equals("TETRIS")) {
                n = 0;
            } else if (this.game.gameURIs[i][2].equals("MONYHN")) {
                n = 1;
            } else if (this.game.gameURIs[i][2].equals("SBBLOX")) {
                n = 2;
            }
            this.mgImages[i] = Game.createImage(303 + n);
            this.mgTitles[i] = this.game.strings[114 + n];
            this.menuItems[i] = n;
            this.buttons[i] = new int[2];
            this.buttons[i][0] = 0;
            this.buttons[i][1] = 0;
            if (this.game.mg_wap && !this.game.mg_static) {
                if (this.game.gameURIs[i][0] != null) {
                    this.buttons[i][0] = 1;
                    if (this.game.gameURIs[i][1] == null) continue;
                    this.buttons[i][1] = 3;
                    continue;
                }
                if (this.game.gameURIs[i][1] == null) continue;
                this.buttons[i][0] = 3;
                continue;
            }
            if (this.game.mg_wap && this.game.mg_static) {
                if (this.game.gameURIs[i][0] != null) {
                    this.buttons[i][0] = 1;
                    this.buttons[i][1] = 2;
                    if (this.game.gameURIs[i][1] == null) continue;
                    this.buttons[i][1] = 3;
                    continue;
                }
                if (this.game.gameURIs[i][1] != null) {
                    this.buttons[i][0] = 3;
                    continue;
                }
                this.buttons[i][0] = 2;
                continue;
            }
            this.buttons[i][0] = 2;
        }
        this.highlightButton = 0;
        this.highlight = 0;
        this.setMoreGamesSoftkeys();
    }

    void releaseMoreGamesAssets() {
        this.mgImages = null;
        this.mgTitles = null;
        this.selectorArrows = null;
    }

    void setMoreGamesSoftkeys() {
        this.game.softkeyL = this.buttons[this.highlight][0] == 0 && this.buttons[this.highlight][1] == 0 ? -1 : 0;
        this.game.softkeyR = 2;
    }

    void pushMenu() {
        int n;
        int[] nArray = new int[9];
        nArray[0] = this.curMenu;
        nArray[3] = this.subType;
        nArray[1] = this.highlight;
        nArray[2] = this.type;
        nArray[4] = n = this.menuItems.length;
        nArray[5] = this.menuItems[0];
        nArray[6] = this.title;
        nArray[7] = this.selRow;
        nArray[8] = this.selCol;
        this.prevMenus.push(nArray);
    }

    void appendText(String string) {
        String string2 = this.game.strings[this.menuItems[1]] + string;
        char[] cArray = this.game.fontTiny.wrap(string2, 216);
        this.strMessage = new String(cArray);
        this.stringHeight = this.game.fontTiny.getStringHeight(cArray);
        this.stringWidth = this.game.fontTiny.getStringWidth(cArray, 0);
        this.numPages = this.stringHeight / this.messageHeight;
        if (this.stringHeight % this.messageHeight != 0) {
            ++this.numPages;
        }
    }

    void initFlat(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.game.softkeyL = 0;
        this.game.softkeyR = 2;
        if (this.type != 1 && this.menuItems != null && !this.backedOut && this.curMenu != 8) {
            this.pushMenu();
        }
        this.title = n4;
        this.curMenu = n;
        this.type = 0;
        this.subType = -1;
        this.menuItems = new int[n2];
        this.backedOut = false;
        this.highlight = 0;
        if (n == 0) {
            n6 = 0;
            this.menuItems[n6++] = 7;
            this.menuItems[n6++] = 8;
            this.menuItems[n6++] = 9;
            this.menuItems[n6++] = 10;
            this.menuItems[n6++] = 11;
            if (this.game.moreGamesEnabled()) {
                this.menuItems[n6++] = 12;
            }
            this.menuItems[n6++] = 13;
        } else if (n == 8) {
            if (this.game.state != 4) {
                this.lastGameState = this.game.state;
            }
            n6 = 0;
            this.menuItems[n6++] = 19;
            this.menuItems[n6++] = 6;
            this.menuItems[n6++] = 9;
            this.menuItems[n6++] = 14;
            --n6;
        } else if (n == 9) {
            if (this.game.state != 4) {
                this.lastGameState = this.game.state;
            }
            this.menuItems[0] = 19;
            this.menuItems[1] = 100;
            this.menuItems[2] = 9;
            this.menuItems[3] = 14;
        } else if (n == 5) {
            this.menuItems[0] = 7;
            this.menuItems[1] = 40;
        } else if (n == 1) {
            n6 = 0;
            n2 = this.game.prefs.townName.compareTo("") != 0 ? 4 : 3;
            this.menuItems = new int[n2];
            this.ITEM_CONTINUE = -1;
            if (this.game.prefs.townName.compareTo("") != 0) {
                this.menuItems[n6] = 38;
                this.ITEM_CONTINUE = n6++;
            }
            this.menuItems[n6] = 37;
            this.ITEM_NEW_GAME = n6++;
            this.menuItems[n6] = 39;
            this.ITEM_SIMS = n6++;
            this.menuItems[n6] = 40;
            this.ITEM_ACTIVITIES = n6;
        } else if (n == 14 || n == 7) {
            n6 = 0;
            int[] nArray = new int[6];
            for (n5 = 0; n5 < 6; ++n5) {
                if (!this.game.prefs.minigames[n5]) continue;
                nArray[n6] = Constants.gameString[n5];
                ++n6;
            }
            this.menuItems = new int[n6];
            System.arraycopy(nArray, 0, this.menuItems, 0, n6);
            this.numRows = n6;
        } else if (n == 3) {
            for (n6 = 0; n6 < n2; ++n6) {
                if (n3 + n6 == 15) {
                    ++n3;
                }
                if (n3 + n6 == 16) {
                    ++n3;
                }
                this.menuItems[n6] = n3 + n6;
            }
        } else {
            for (n6 = 0; n6 < n2; ++n6) {
                this.menuItems[n6] = n3 + n6;
            }
        }
        this.stringWidth = 0;
        for (n6 = 0; n6 < this.menuItems.length; ++n6) {
            this.stringWidth = Math.max(this.font.getLineWidth(this.game.strings[this.menuItems[n6]].toCharArray(), 0), this.stringWidth);
        }
        this.numItemsOnPage = this.numTotalItems = this.menuItems.length;
        int n7 = this.curMenu != 0 ? this.font.height * 3 >> 1 : 0;
        n5 = this.numTotalItems * this.font.height + n7 + 10;
        if (n5 > (n6 = 348 - this.imgLogo.getHeight() - 8 - 10)) {
            this.numItemsOnPage = ((n6 -= (this.sprTabArrows.frameHeight << 1) + 8) - n7) / this.font.height;
        }
        this.animState = 0;
        this.lastW = 0;
        this.lastH = 0;
        this.anim_time = System.currentTimeMillis() + (long)Constants.BOX_SQUISH[this.animState][1];
        if (n == 0) {
            this.game.softkeyL = 0;
            this.game.softkeyR = 4;
            if (this.game.playing != 247) {
                this.game.play(247, true);
            }
        }
        this.menuSoftkeyL = this.game.softkeyL;
        this.menuSoftkeyR = this.game.softkeyR;
    }

    void initSimsFlat(boolean bl) {
        this.updateSimsOptions();
        if (this.type != 6 && !bl) {
            this.pushMenu();
        }
        this.type = 7;
        this.subType = -1;
        this.curMenu = 20;
        this.highlight = 0;
        this.selRow = 0;
        this.selCol = 0;
        if (!bl) {
            this.loadSimsScreen();
        } else {
            this.sims_state = 3;
            this.simsHighlight = 0;
        }
    }

    void initHighScores(int n, int n2) {
        int n3;
        this.game.softkeyL = -1;
        this.game.softkeyR = 2;
        this.pushMenu();
        this.title = n2;
        this.curMenu = n;
        this.type = 4;
        this.subType = -1;
        this.backedOut = false;
        this.highlight = 0;
        int n4 = 0;
        int[] nArray = new int[6];
        for (n3 = 0; n3 < 6; ++n3) {
            if (!this.game.prefs.minigames[n3]) continue;
            nArray[n4] = Constants.gameString[n3];
            ++n4;
        }
        this.menuItems = new int[n4];
        System.arraycopy(nArray, 0, this.menuItems, 0, n4);
        this.numRows = n4;
        this.numItemsOnPage = this.numTotalItems = this.menuItems.length;
        n3 = 330;
        int n5 = this.curMenu != 0 ? this.font.height * 3 >> 1 : 0;
        int n6 = this.numTotalItems * this.font.height + n5 + 10;
        if (n6 > n3) {
            this.numItemsOnPage = ((n3 -= (this.sprTabArrows.frameHeight << 1) + 8) - n5) / this.font.height;
        }
        this.animState = 0;
        this.lastW = 0;
        this.lastH = 0;
        this.anim_time = System.currentTimeMillis() + (long)Constants.BOX_SQUISH[this.animState][1];
    }

    void initResultsMenu(int n) {
        int[] nArray = this.game.findPalette(139);
        this.setBg(269, nArray);
        this.curMenu = n;
        this.type = 5;
        this.subType = -1;
        this.backedOut = false;
        this.highlight = 0;
        this.menuSoftkeyL = -1;
        this.menuSoftkeyR = -1;
        this.currentSim.load(this.game);
        this.currentSim.setAnim(19, -1);
        this.animState = 0;
        this.lastW = 0;
        this.lastH = 0;
        this.anim_time = System.currentTimeMillis() + (long)Constants.BOX_SQUISH[this.animState][1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean process(int n, long l) {
        block183: {
            block184: {
                if (this.type == 0) {
                    switch (n) {
                        case 1: {
                            --this.highlight;
                            if (this.highlight < 0) {
                                this.highlight = this.numTotalItems - 1;
                            }
                            this.pressed = 2;
                            this.keyPressTime = System.currentTimeMillis() + 300L;
                            return true;
                        }
                        case 6: {
                            ++this.highlight;
                            this.highlight %= this.numTotalItems;
                            this.pressed = 4;
                            this.keyPressTime = System.currentTimeMillis() + 300L;
                            return true;
                        }
                        case -6: 
                        case 8: {
                            switch (this.curMenu) {
                                case 0: {
                                    switch (this.highlight) {
                                        case 0: {
                                            int n2 = this.game.prefs.townName.compareTo("") != 0 ? 4 : 3;
                                            int n3 = 0;
                                            for (int i = 0; i < 6; ++i) {
                                                if (!this.game.prefs.minigames[i]) continue;
                                                ++n3;
                                            }
                                            if (n3 == 0 && this.game.prefs.townName.compareTo("") != 0) {
                                                --n2;
                                            }
                                            this.initFlat(1, n2, 37, 7);
                                            return true;
                                        }
                                        case 1: {
                                            this.initFlat(3, 3, 14, 8);
                                            return true;
                                        }
                                        case 2: {
                                            this.initFlat(5, 2, 7, 9);
                                            return true;
                                        }
                                        case 3: {
                                            this.initMessageBox(4, 47, 1, false);
                                            return true;
                                        }
                                        case 4: {
                                            this.initHighScores(27, 11);
                                            return true;
                                        }
                                        case 5: {
                                            if (this.game.moreGamesEnabled()) {
                                                this.initMoreGamesMenu();
                                                return true;
                                            }
                                            this.initMessageBox(11, 22, 0, false);
                                            return true;
                                        }
                                        case 6: {
                                            this.initMessageBox(11, 22, 0, false);
                                        }
                                    }
                                    return true;
                                }
                                case 1: {
                                    if (this.highlight == this.ITEM_NEW_GAME && this.game.prefs.townName.compareTo("") != 0) {
                                        this.initMessageBox(2, 41, 0, false);
                                        return true;
                                    }
                                    if (this.highlight == this.ITEM_ACTIVITIES) {
                                        this.initFlat(14, 6, -1, 40);
                                        return true;
                                    }
                                    this.lastItemSelected = this.highlight;
                                    this.initSimsFlat(false);
                                    return true;
                                }
                                case 14: {
                                    switch (this.menuItems[this.highlight]) {
                                        case 31: {
                                            this.game.isMini = true;
                                            this.game.state = 7;
                                            return true;
                                        }
                                        case 32: {
                                            this.game.isMini = true;
                                            this.game.state = 9;
                                            return true;
                                        }
                                        case 33: {
                                            this.game.isMini = true;
                                            this.game.state = 6;
                                            return true;
                                        }
                                        case 34: {
                                            this.game.isMini = true;
                                            this.game.state = 8;
                                            this.game.paraglidingType = 0;
                                            return true;
                                        }
                                        case 35: {
                                            this.game.isMini = true;
                                            this.game.state = 10;
                                            return true;
                                        }
                                        case 36: {
                                            this.game.isMini = true;
                                            this.game.state = 11;
                                        }
                                    }
                                    return true;
                                }
                                case 5: {
                                    switch (this.highlight) {
                                        case 0: {
                                            this.initMessageBox(6, 130, 1, false);
                                            return true;
                                        }
                                        case 1: {
                                            this.initFlat(7, 6, -1, 9);
                                        }
                                    }
                                    return true;
                                }
                                case 7: {
                                    switch (this.menuItems[this.highlight]) {
                                        case 31: {
                                            this.initMessageBox(10, 94, 1, false);
                                            return true;
                                        }
                                        case 32: {
                                            this.initMessageBox(10, 95, 1, false);
                                            return true;
                                        }
                                        case 33: {
                                            this.initMessageBox(10, 96, 1, false);
                                            return true;
                                        }
                                        case 34: {
                                            this.initMessageBox(10, 97, 1, false);
                                            return true;
                                        }
                                        case 35: {
                                            this.initMessageBox(10, 98, 1, false);
                                            return true;
                                        }
                                        case 36: {
                                            this.initMessageBox(10, 99, 1, false);
                                        }
                                    }
                                    return true;
                                }
                                case 3: {
                                    switch (this.highlight) {
                                        case 0: {
                                            ++this.game.prefs.volume;
                                            this.game.prefs.volume %= 2;
                                            this.game.stop();
                                            this.game.play(247, true);
                                            this.game.prefs.save();
                                            return true;
                                        }
                                        case -1: {
                                            boolean bl = this.game.prefs.vibration = !this.game.prefs.vibration;
                                            if (this.game.prefs.vibration) {
                                                this.game.vibrate(200);
                                            }
                                            this.game.prefs.save();
                                            return true;
                                        }
                                        case 1: {
                                            if (this.game.prefs.language.compareTo("en") == 0) {
                                                this.game.prefs.language = "fr";
                                            } else if (this.game.prefs.language.compareTo("fr") == 0) {
                                                this.game.prefs.language = "it";
                                            } else if (this.game.prefs.language.compareTo("it") == 0) {
                                                this.game.prefs.language = "de";
                                            } else if (this.game.prefs.language.compareTo("de") == 0) {
                                                this.game.prefs.language = "es";
                                            } else if (this.game.prefs.language.compareTo("es") == 0) {
                                                this.game.prefs.language = "en";
                                            }
                                            this.game.loadStrings(this.game.prefs.language);
                                            this.game.prefs.save();
                                            return true;
                                        }
                                        case 2: {
                                            this.initMessageBox(12, 21, 0, false);
                                        }
                                    }
                                    return true;
                                }
                                case 8: {
                                    switch (this.highlight) {
                                        case 0: {
                                            this.game.state = this.lastGameState;
                                            if (this.lastGameState == 13) return false;
                                            this.game.enterAdvState = 3;
                                            if (this.game.inGameState != 1) return false;
                                            this.game.softkeyL = -1;
                                            this.game.softkeyR = 6;
                                            return false;
                                        }
                                        case 1: {
                                            this.initMessageBox(25, 22, 0, true);
                                            return true;
                                        }
                                        case 2: {
                                            this.initMessageBox(5, 130, 1, false);
                                            return true;
                                        }
                                        case 3: {
                                            ++this.game.prefs.volume;
                                            this.game.prefs.volume %= 2;
                                            this.game.stop();
                                            this.game.play(244, false);
                                            this.game.prefs.save();
                                            return true;
                                        }
                                        case -1: {
                                            boolean bl = this.game.prefs.vibration = !this.game.prefs.vibration;
                                            if (this.game.prefs.vibration) {
                                                this.game.vibrate(200);
                                            }
                                            this.game.prefs.save();
                                        }
                                    }
                                    return true;
                                }
                                case 9: {
                                    switch (this.highlight) {
                                        case 0: {
                                            if (this.game.isMini) {
                                                this.back();
                                            }
                                            if (this.lastGameState == 11) {
                                                this.game.stop();
                                            }
                                            this.game.state = this.lastGameState;
                                            return true;
                                        }
                                        case 1: {
                                            this.initMessageBox(25, 22, 0, true);
                                            return true;
                                        }
                                        case 2: {
                                            switch (this.lastGameState) {
                                                case 11: {
                                                    this.initMessageBox(10, 99, 1, false);
                                                    return true;
                                                }
                                                case 7: {
                                                    this.initMessageBox(10, 94, 1, false);
                                                    return true;
                                                }
                                                case 8: {
                                                    this.initMessageBox(10, 97, 1, false);
                                                    return true;
                                                }
                                                case 6: {
                                                    this.initMessageBox(10, 96, 1, false);
                                                    return true;
                                                }
                                                case 10: {
                                                    this.initMessageBox(10, 98, 1, false);
                                                    return true;
                                                }
                                                case 9: {
                                                    this.initMessageBox(10, 95, 1, false);
                                                }
                                            }
                                            return true;
                                        }
                                        case 3: {
                                            ++this.game.prefs.volume;
                                            this.game.prefs.volume %= 2;
                                            this.game.stop();
                                            this.game.playMiniMusic(this.lastGameState);
                                            this.game.prefs.save();
                                            return true;
                                        }
                                        case -1: {
                                            boolean bl = this.game.prefs.vibration = !this.game.prefs.vibration;
                                            if (this.game.prefs.vibration) {
                                                this.game.vibrate(200);
                                            }
                                            this.game.prefs.save();
                                        }
                                    }
                                    return true;
                                }
                                case 26: {
                                    this.game.loadStrings((short)this.highlight);
                                    this.game.prefs.save();
                                    this.game.softkeyL = -1;
                                    this.game.softkeyR = -1;
                                    this.type = 8;
                                    this.subType = -1;
                                    this.state = 0;
                                    this.sprLogo.num_loops = 1;
                                }
                            }
                            return true;
                        }
                        case -7: {
                            if (this.game.softkeyR == -1) return true;
                            if (this.curMenu == 8 || this.curMenu == 9) {
                                if (this.curMenu == 9 && this.game.isMini) {
                                    this.back();
                                }
                                this.game.state = this.lastGameState;
                                this.game.enterAdvState = 3;
                                if (this.game.inGameState != 1) return false;
                                this.game.softkeyL = -1;
                                this.game.softkeyR = 6;
                                return false;
                            }
                            if (this.curMenu == 21) {
                                this.game.state = 2;
                                this.game.enterAdvState = 2;
                                return true;
                            }
                            if (this.curMenu != 0) {
                                this.back();
                                return false;
                            }
                            this.initMessageBox(11, 22, 0, false);
                            return false;
                        }
                    }
                    return true;
                }
                if (this.type != 1) break block183;
                switch (this.subType) {
                    case 1: {
                        switch (n) {
                            case -6: 
                            case 8: {
                                if (this.numPages <= 1) return true;
                                ++this.pageNum;
                                if (this.pageNum >= this.numPages - 1) {
                                    this.game.softkeyL = 0;
                                }
                                if (this.pageNum < this.numPages) return true;
                                this.back();
                                return true;
                            }
                            case -7: {
                                --this.pageNum;
                                if (this.pageNum <= this.numPages - 1 && this.pageNum >= 0) {
                                    this.game.softkeyL = 3;
                                }
                                if (this.pageNum >= 0) return true;
                                this.back();
                                this.pageNum = 0;
                            }
                        }
                        return true;
                    }
                    case 0: {
                        switch (n) {
                            case -6: 
                            case 8: {
                                ++this.pageNum;
                                if (this.pageNum >= this.numPages - 1) {
                                    this.game.softkeyL = 0;
                                }
                                if (this.pageNum < this.numPages) return true;
                                switch (this.curMenu) {
                                    case 25: {
                                        if (this.lastGameState >= 6 && this.lastGameState <= 11) {
                                            if (this.game.isMini) {
                                                while (this.curMenu != 14) {
                                                    this.back();
                                                }
                                            } else {
                                                this.game.stop();
                                                this.game.state = 2;
                                            }
                                            this.game.backedOutOfMini = true;
                                            this.game.exitState(this.lastGameState);
                                            this.game.isMini = false;
                                            break;
                                        }
                                        if (this.game.wasInGame) {
                                            this.game.releaseInGame();
                                        }
                                        if (this.lastGameState == 13) {
                                            this.game.exitState(13);
                                        }
                                        this.game.wasInGame = false;
                                        while (this.curMenu != 0) {
                                            this.back();
                                        }
                                        this.setBg(148);
                                        break;
                                    }
                                    case 11: {
                                        this.game.running = false;
                                        break;
                                    }
                                    case 2: {
                                        this.game.resetInGame();
                                        this.game.prefs.townName = "";
                                        this.game.prefs.resetGame();
                                        this.game.resetInGame();
                                        this.game.saveInGame();
                                        this.game.starState = 0;
                                        this.game.prefs.save();
                                        this.back();
                                        this.lastItemSelected = this.ITEM_NEW_GAME;
                                        this.initSimsFlat(false);
                                        break;
                                    }
                                    case 12: {
                                        this.game.prefs.reset();
                                        this.game.resetInGame();
                                        this.game.saveInGame();
                                        this.game.prefs.save();
                                        this.back();
                                        break;
                                    }
                                    case 23: {
                                        boolean bl = true;
                                        this.game.pauseSounds();
                                        try {
                                            this.game.parent.platformRequest(this.exitURI);
                                        }
                                        catch (Exception exception) {
                                            bl = false;
                                            this.back();
                                            this.initMessageBox(24, 125, 1, false);
                                        }
                                        if (!bl) return true;
                                        this.game.running = false;
                                        break;
                                    }
                                    default: {
                                        this.back();
                                        break;
                                    }
                                }
                                break block184;
                            }
                            case -7: {
                                --this.pageNum;
                                if (this.pageNum <= this.numPages - 1 && this.pageNum >= 0) {
                                    this.game.softkeyL = 3;
                                }
                                if (this.pageNum >= 0) return true;
                                this.back();
                                this.pageNum = 0;
                            }
                        }
                    }
                }
            }
            return true;
        }
        if (this.type == 4) {
            switch (n) {
                case 1: {
                    --this.highlight;
                    if (this.highlight < 0) {
                        this.highlight = this.numTotalItems - this.numItemsOnPage;
                    }
                    this.pressed = 2;
                    this.keyPressTime = System.currentTimeMillis() + 300L;
                    return true;
                }
                case 6: {
                    ++this.highlight;
                    this.highlight %= this.numTotalItems - this.numItemsOnPage + 1;
                    this.pressed = 4;
                    this.keyPressTime = System.currentTimeMillis() + 300L;
                    return true;
                }
                case -7: {
                    this.back();
                }
            }
            return true;
        } else if (this.type == 3) {
            switch (n) {
                case 5: {
                    ++this.highlight;
                    this.highlight %= this.game.NUM_MORE_GAMES;
                    this.pressed = n;
                    this.keyPressTime = System.currentTimeMillis() + 300L;
                    for (int i = 0; i < this.buttons[this.highlight].length && this.buttons[this.highlight][this.highlightButton] == 0; ++i) {
                        ++this.highlightButton;
                        this.highlightButton %= this.buttons[this.highlight].length;
                    }
                    this.setMoreGamesSoftkeys();
                    return true;
                }
                case 2: {
                    --this.highlight;
                    if (this.highlight < 0) {
                        this.highlight = this.game.NUM_MORE_GAMES - 1;
                    }
                    this.pressed = n;
                    this.keyPressTime = System.currentTimeMillis() + 300L;
                    for (int i = 0; i < this.buttons[this.highlight].length && this.buttons[this.highlight][this.highlightButton] == 0; ++i) {
                        ++this.highlightButton;
                        this.highlightButton %= this.buttons[this.highlight].length;
                    }
                    this.setMoreGamesSoftkeys();
                    return true;
                }
                case 1: {
                    for (int i = 0; i < this.buttons[this.highlight].length; ++i) {
                        --this.highlightButton;
                        if (this.highlightButton < 0) {
                            this.highlightButton = this.buttons[this.highlight].length - 1;
                        }
                        if (this.buttons[this.highlight][this.highlightButton] != 0) return true;
                    }
                    return true;
                }
                case 6: {
                    for (int i = 0; i < this.buttons[this.highlight].length; ++i) {
                        ++this.highlightButton;
                        this.highlightButton %= this.buttons[this.highlight].length;
                        if (this.buttons[this.highlight][this.highlightButton] != 0) return true;
                    }
                    return true;
                }
                case -6: 
                case 8: {
                    if (this.buttons[this.highlight][this.highlightButton] == 1) {
                        this.exitURI = this.game.gameURIs[this.highlight][0];
                        this.initMessageBox(23, 129, 0, false);
                        return true;
                    }
                    if (this.buttons[this.highlight][this.highlightButton] == 3) {
                        this.exitURI = this.game.gameURIs[this.highlight][1];
                        this.initMessageBox(23, 129, 0, false);
                        return true;
                    }
                    if (this.buttons[this.highlight][this.highlightButton] != 2) return true;
                    this.initMessageBox(22, 124, 1, false);
                    return true;
                }
                case -7: {
                    this.releaseMoreGamesAssets();
                    this.back();
                }
            }
            return true;
        } else if (this.type == 2) {
            this.game.anmTimmy.nextFrame(System.currentTimeMillis());
            if (this.game.softkeyL != -1 && this.game.softkeyR != -1) {
                switch (n) {
                    case -7: 
                    case -6: 
                    case 8: {
                        this.game.prefs.volume = n == -7 ? 0 : 1;
                        this.anim_time = System.currentTimeMillis() + 500L;
                        this.game.softkeyL = -1;
                        this.game.softkeyR = -1;
                        this.game.anmTimmy.num_loops = 1;
                        this.game.anmTimmy.setAnim(1);
                    }
                }
            }
            if (this.game.anmTimmy.animation != 1 || this.game.anmTimmy.loop != 0) return true;
            this.initFlat(0, NUM_MAIN_ITEMS, 7, 6);
            return true;
        } else if (this.type == 8) {
            long l2 = System.currentTimeMillis();
            this.sprLogo.nextFrame(l2);
            this.sprDiamond.nextFrame(l2);
            this.sprDiamond.position.tick();
            switch (this.state) {
                case 0: {
                    if (this.sprLogo.loop != 0) return true;
                    this.state = 1;
                    this.sprDiamond.position = new Position(30720, 44544);
                    this.sprDiamond.position.moveTo(120, this.sprDiamond.frameHeight, 2, 24);
                    return true;
                }
                case 1: {
                    if (this.sprDiamond.position.moving) return true;
                    this.sprDiamond.position.moveTo(120, 174 - (this.sprLogo.frameHeight >> 1), 2, 24);
                    this.state = 2;
                    return true;
                }
                case 2: {
                    if (this.sprDiamond.position.moving) return true;
                    this.state = 3;
                    this.anim_time = l2 + 3000L;
                    this.game.strings[55] = new String(this.game.fontTiny.wrap(this.game.strings[55], 240));
                    return true;
                }
                case 3: {
                    if (System.currentTimeMillis() <= this.anim_time) return true;
                    this.sprLogo = null;
                    this.type = 2;
                    this.subType = -1;
                    this.game.softkeyL = 0;
                    this.game.softkeyR = 1;
                    this.anim_time = -1L;
                    this.game.anmTimmy = new Animation(112, 112);
                    this.game.anmTimmy.speed = 200;
                    this.game.anmTimmy.setAnim(2);
                }
            }
            return true;
        } else if (this.type == 5) {
            this.currentSim.body.nextFrame(l);
            switch (n) {
                case 8: {
                    while (this.curMenu != 0) {
                        this.back();
                    }
                    this.setBg(148);
                }
            }
            return true;
        } else if (this.type == 6) {
            this.processCreationScreen(n);
            return true;
        } else if (this.type == 7) {
            this.processSimsScreen(n);
            return true;
        } else {
            if (this.type != 10) return true;
            this.processTabs(n);
        }
        return true;
    }

    void render(Graphics graphics) {
        int n;
        int n2;
        if (this.type < 7) {
            this.posBg.tick();
            if (!this.posBg.moving) {
                this.posBg.x = 0;
                this.posBg.y = 0;
                this.posBg.moveTo(-this.imgBg.getWidth(), -this.imgBg.getHeight(), 0, 600);
            }
            n2 = this.posBg.x >> 8;
            for (n = this.posBg.y >> 8; n < 348 + this.imgBg.getHeight(); n += this.imgBg.getHeight()) {
                for (n2 = this.posBg.x >> 8; n2 < 240 + this.imgBg.getWidth(); n2 += this.imgBg.getWidth()) {
                    graphics.drawImage(this.imgBg, n2, n, 20);
                }
            }
        }
        if (this.type == 0) {
            graphics.drawImage(this.imgLogo, 120, 0, 17);
            n2 = 120;
            int n3 = n = this.curMenu != 0 ? (this.font.height >> 1) * 3 : 0;
            if (this.numItemsOnPage < this.numTotalItems) {
                n += (this.sprTabArrows.frameHeight << 1) + 8;
            }
            GraphicFont graphicFont = this.font;
            GraphicFont graphicFont2 = this.highlightFont;
            int n4 = this.numItemsOnPage * graphicFont.height + n + 10 + 4;
            int n5 = (348 + this.imgLogo.getHeight() >> 1) + 2;
            int n6 = n5 - (n4 >> 1);
            this.drawSquishyBox(graphics, n6, n4);
            if (this.curMenu != 0) {
                this.font.print(graphics, this.game.strings[this.title], n2, n6, 17);
                this.drawTitleLine(graphics, n2, n6 += this.font.height);
                n6 += this.font.height >> 1;
            }
            int n7 = 0;
            int n8 = this.numItemsOnPage;
            if (this.numItemsOnPage < this.numTotalItems) {
                n7 = Math.max(this.highlight - (this.numItemsOnPage >> 1), 0);
                if (n7 > this.numTotalItems - this.numItemsOnPage) {
                    n7 = this.numTotalItems - this.numItemsOnPage;
                }
                n8 = Math.min(n7 + this.numItemsOnPage, this.numTotalItems);
            }
            if (this.numItemsOnPage < this.numTotalItems) {
                if (n7 > 0) {
                    if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 2) {
                        this.sprTabArrows.render(graphics, 120, n6, 0, 1, 17);
                    } else {
                        this.sprTabArrows.render(graphics, 120, n6, 0, 0, 17);
                    }
                }
                n6 += 2 + this.sprTabArrows.frameHeight;
            }
            for (int i = n7; i < n8; ++i) {
                String string = this.game.strings[this.menuItems[i]];
                string = string + this.getOptionString(this.curMenu, i);
                int n9 = this.font.getLineWidth(string.toCharArray(), 0) + 1;
                GraphicFont graphicFont3 = graphicFont;
                if (i == this.highlight) {
                    graphicFont3 = graphicFont2;
                }
                graphicFont3.printPointer(graphics, string, n2, n6, 17, 2, i);
                n6 += graphicFont3.height;
            }
            if (n7 + this.numItemsOnPage < this.numTotalItems) {
                if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 4) {
                    this.sprTabArrows.render(graphics, 120, n6 + 2, 1, 1, 17);
                } else {
                    this.sprTabArrows.render(graphics, 120, n6 + 2, 1, 0, 17);
                }
            }
        } else if (this.type == 4) {
            n2 = 120;
            n = (this.font.height >> 1) * 3;
            if (this.numItemsOnPage < this.numTotalItems) {
                n += (this.sprTabArrows.frameHeight << 1) + 8;
            }
            int n10 = this.numItemsOnPage * this.font.height + n + 10 + 4;
            int n11 = 174;
            int n12 = n11 - (n10 >> 1);
            this.drawSquishyBox(graphics, n12, n10);
            this.font.print(graphics, this.game.strings[this.title], n2, n12, 17);
            this.drawTitleLine(graphics, n2, n12 += this.font.height);
            n12 += this.font.height >> 1;
            int n13 = Math.min(this.highlight, this.numTotalItems - this.numItemsOnPage);
            int n14 = Math.min(n13 + this.numItemsOnPage, this.numTotalItems);
            if (this.numItemsOnPage < this.numTotalItems) {
                if (n13 > 0) {
                    if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 2) {
                        this.sprTabArrows.render(graphics, 120, n12, 0, 1, 17);
                    } else {
                        this.sprTabArrows.render(graphics, 120, n12, 0, 0, 17);
                    }
                }
                n12 += 2 + this.sprTabArrows.frameHeight;
            }
            for (int i = n13; i < n14; ++i) {
                n2 = 24;
                this.game.fontTiny.print(graphics, this.game.strings[this.menuItems[i]], n2, n12, 20);
                n2 = 240 - n2;
                this.game.fontTiny.print(graphics, this.game.formatScore(this.game.prefs.highscores[i]), n2, n12, 24);
                n12 += this.font.height;
            }
            if (n13 + this.numItemsOnPage < this.numTotalItems) {
                if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 4) {
                    this.sprTabArrows.render(graphics, 120, n12 + 2, 1, 1, 17);
                } else {
                    this.sprTabArrows.render(graphics, 120, n12 + 2, 1, 0, 17);
                }
            }
        } else if (this.type == 1) {
            n2 = 6;
            if (this.numPages > 1) {
                Menu.drawMenuBox(graphics, 7, n2 - 5, 226, this.messageHeight + 10);
                graphics.setClip(12, n2, 216, this.messageHeight);
                this.game.fontTiny.print(graphics, this.strMessage, 120, n2 - this.pageNum * this.messageHeight, 17);
                graphics.setClip(0, 0, 240, 348);
            } else {
                n = this.game.fontTiny.getStringHeight(this.strMessage.toCharArray());
                Menu.drawMenuBox(graphics, 0, (348 - this.game.sprSoftkeys.frameHeight >> 1) - (n >> 1) - 5, 240, n + 10);
                this.game.fontTiny.print(graphics, this.strMessage, 120, 348 - this.game.sprSoftkeys.frameHeight >> 1, 3);
            }
        } else if (this.type == 3) {
            int n15;
            int n16;
            n2 = 2;
            char[] cArray = this.game.fontTinyBlack.wrap(this.game.strings[117 + this.menuItems[this.highlight]], 236);
            int n17 = this.game.fontTinyBlack.getStringHeight(cArray);
            char[] cArray2 = this.font.wrap(this.mgTitles[this.highlight], 232 - (this.selectorArrows.frameWidth << 1));
            char[][] cArrayArray = new char[this.buttons[this.highlight].length][];
            int n18 = 0;
            for (n16 = 0; n16 < this.buttons[this.highlight].length; ++n16) {
                if (this.buttons[this.highlight][n16] == 1) {
                    cArrayArray[n16] = this.font.wrap(this.game.strings[123], 236);
                    n18 += this.font.getStringHeight(cArrayArray[n16]);
                    continue;
                }
                if (this.buttons[this.highlight][n16] != 2 && this.buttons[this.highlight][n16] != 3) continue;
                cArrayArray[n16] = this.font.wrap(this.game.strings[120 + this.menuItems[this.highlight]], 236);
                n18 += this.font.getStringHeight(cArrayArray[n16]);
            }
            n16 = this.mgImages[this.highlight].getHeight();
            int n19 = this.mgImages[this.highlight].getWidth();
            int n20 = n16 + n17 + n18 + 4;
            this.font.print(graphics, this.game.strings[113], 120, n2, 17);
            n2 = 174 - (n20 >> 1);
            graphics.drawImage(this.mgImages[this.highlight], 120, n2, 17);
            if (this.game.NUM_MORE_GAMES > 1) {
                n15 = 120 - (n19 >> 1) - 2;
                int n21 = 120 + (n19 >> 1) + 2;
                int n22 = n2 + (n16 >> 1);
                if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 2) {
                    this.selectorArrows.render(graphics, n15, n22, 1, 0, 10);
                } else {
                    this.selectorArrows.renderPointer(graphics, n15, n22, 0, 0, 10, -3);
                }
                if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 5) {
                    this.selectorArrows.render(graphics, n21, n22, 3, 0, 6);
                } else {
                    this.selectorArrows.renderPointer(graphics, n21, n22, 2, 0, 6, -4);
                }
            }
            this.game.fontTinyBlack.print(graphics, cArray, 120, n2 += n16 + 2, 17);
            n2 += n17 + 2;
            for (n15 = 0; n15 < this.buttons[this.highlight].length; ++n15) {
                GraphicFont graphicFont = this.font;
                if (this.highlightButton == n15) {
                    graphicFont = this.highlightFont;
                }
                if (cArrayArray[n15] == null) continue;
                graphicFont.printPointer(graphics, cArrayArray[n15], 120, n2, 17, 7, n15);
                n2 += this.font.getStringHeight(cArrayArray[n15]);
            }
        } else if (this.type == 2) {
            n2 = this.imgLogo.getHeight() + this.game.anmTimmy.frameHeight + this.font.height;
            int n23 = n = (348 - this.game.sprSoftkeys.frameHeight >> 1) - (n2 >> 1);
            if (this.anim_time > 0L) {
                int n24 = (int)(this.anim_time - System.currentTimeMillis());
                n23 = Math.max(n * n24 / 500, 0);
            }
            graphics.drawImage(this.imgLogo, 120, n23, 17);
            this.game.anmTimmy.render(graphics, 120, n += this.imgLogo.getHeight(), this.game.anmTimmy.frame, this.game.anmTimmy.animation, 17);
            n += this.game.anmTimmy.frameHeight;
            if (this.game.anmTimmy.animation != 1) {
                GraphicFont graphicFont = this.font;
                Menu.drawMenuBox(graphics, 0, n - 5, 240, graphicFont.getStringHeight(this.game.strings[54].toCharArray()) + 10);
                graphicFont.print(graphics, this.game.strings[54], 120, n, 17);
            }
        } else if (this.type == 8) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, 240, 348);
            if (this.state >= 1) {
                this.sprDiamond.render(graphics, this.sprDiamond.position.x >> 8, this.sprDiamond.position.y >> 8, this.sprDiamond.frame, 0, 33);
            }
            this.sprLogo.render(graphics, 120, 174, this.sprLogo.frame, 0, 3);
            if (this.state == 3) {
                this.game.fontTiny.print(graphics, this.game.strings[55], 120, 348 - this.game.sprSoftkeys.frameHeight, 33);
            }
        } else if (this.type == 6) {
            this.renderCreationScreen(graphics);
        } else if (this.type == 5) {
            this.renderFinalResults(graphics);
        } else if (this.type != 9) {
            if (this.type == 7) {
                this.renderSimsScreen(graphics);
            } else if (this.type == 10) {
                this.renderTabs(graphics);
            }
        }
        graphics.setClip(0, 0, 240, 348);
    }

    String getOptionString(int n, int n2) {
        String string = new String();
        block0 : switch (n) {
            case 3: {
                switch (n2) {
                    case 0: {
                        string = string + this.game.strings[23 + this.game.prefs.volume];
                        break;
                    }
                    case -1: {
                        int n3 = this.game.prefs.vibration ? 24 : 23;
                        string = string + this.game.strings[n3];
                        break;
                    }
                    case 1: {
                        if (this.game.prefs.language.equals("en")) {
                            string = string + this.game.strings[1];
                            break;
                        }
                        if (this.game.prefs.language.equals("fr")) {
                            string = string + this.game.strings[2];
                            break;
                        }
                        if (this.game.prefs.language.equals("it")) {
                            string = string + this.game.strings[3];
                            break;
                        }
                        if (this.game.prefs.language.equals("de")) {
                            string = string + this.game.strings[4];
                            break;
                        }
                        if (!this.game.prefs.language.equals("es")) break;
                        string = string + this.game.strings[5];
                    }
                }
                break;
            }
            case 8: 
            case 9: {
                switch (n2) {
                    case 3: {
                        string = string + this.game.strings[23 + this.game.prefs.volume];
                        break block0;
                    }
                    case -1: {
                        int n4 = this.game.prefs.vibration ? 24 : 23;
                        string = string + this.game.strings[n4];
                    }
                }
            }
        }
        return string;
    }

    public static void drawMenuBox(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        boolean bl = n3 >= 0;
        n3 = n3 < 0 ? -n3 : n3;
        for (n5 = 0; n5 < 5; ++n5) {
            graphics.setColor(Constants.BORDER_COLORS[n5]);
            graphics.fillRoundRect(n + n5, n2 + n5, n3 - (n5 << 1), n4 - (n5 << 1), 12, 12);
        }
        graphics.clipRect(n + 5, n2 + 5, n3 - 10, n4 - 10);
        graphics.setColor(4499677);
        if (bl) {
            n5 = 10;
            int n10 = 360 / (n5 << 1);
            int n11 = (n10 << 1) - (int)(System.currentTimeMillis() % 1000L) * (n10 << 1) / 1000;
            for (int i = 0; i < n5; ++i) {
                graphics.fillArc(n - (n3 >> 1), n2 - (n4 >> 1), n3 << 1, n4 << 1, n11 % 360, n10);
                n11 += n10 << 1;
            }
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    void drawSquishyBox(Graphics graphics, int n, int n2) {
        int n3 = n + 5 - (this.font.height >> 1);
        int n4 = n2 - 2;
        int n5 = Math.max(this.stringWidth, 120) + 20;
        if (this.curMenu == 3 || this.curMenu == 8 || this.curMenu == 9 || this.curMenu == 27) {
            n5 = 216;
        }
        if (this.animState <= 3) {
            n5 = Constants.BOX_SQUISH[this.animState][0] * n5 / 100;
            n2 = Constants.BOX_SQUISH[this.animState][0] * n2 / 100;
            if (this.anim_time > System.currentTimeMillis()) {
                int n6 = Constants.BOX_SQUISH[this.animState][1] - (int)(this.anim_time - System.currentTimeMillis());
                n5 = Math.max(0, this.lastW + n6 * (n5 - this.lastW) / Constants.BOX_SQUISH[this.animState][1]);
                n2 = Math.max(0, this.lastH + n6 * (n2 - this.lastH) / Constants.BOX_SQUISH[this.animState][1]);
            } else {
                this.lastW = Constants.BOX_SQUISH[this.animState][0] * n5 / 100;
                this.lastH = Constants.BOX_SQUISH[this.animState][0] * n2 / 100;
                ++this.animState;
                if (this.animState <= 3) {
                    this.anim_time = System.currentTimeMillis() + (long)Constants.BOX_SQUISH[this.animState][1];
                }
            }
        }
        graphics.setClip(120 - (n5 >> 1), n3 + (n4 >> 1) - (n2 >> 1), n5, n2);
        Menu.drawMenuBox(graphics, 120 - (n5 >> 1), n3 + (n4 >> 1) - (n2 >> 1), n5, n2);
        graphics.setClip(120 - (n5 >> 1) + 5, n3 + (n4 >> 1) - (n2 >> 1) + 5, n5 - 10, n2 - 10);
    }

    void drawTitleLine(Graphics graphics, int n, int n2) {
        graphics.setColor(7052519);
        graphics.drawRect(n - 60, n2, 121, 4);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(n - 60, n2 + 2, n + 60, n2 + 2);
        graphics.setColor(4883662);
        graphics.drawRect(n - 60, n2 + 1, 121, 2);
    }

    void back() {
        this.backedOut = true;
        int[] nArray = (int[])this.prevMenus.pop();
        if (nArray[2] == 0) {
            this.initFlat(nArray[0], nArray[4], nArray[5], nArray[6]);
        } else if (nArray[2] == 7) {
            this.type = 7;
            this.subType = -1;
            this.curMenu = 20;
            this.highlight = nArray[1];
            this.loadSimsScreen();
            this.selRow = nArray[7];
            this.selCol = nArray[8];
        } else if (nArray[2] == 3) {
            this.initMoreGamesMenu();
        } else {
            this.initMessageBox(nArray[0], nArray[5], nArray[3], false);
        }
        this.highlight = nArray[1];
    }

    void release() {
    }

    void loadPants() {
        int n;
        this.game.updateLoading();
        int n2 = this.currentSim.isFemale ? 4 : 2;
        int n3 = 4 * n2;
        this.currentSim.curPantType = Math.min(n2 - 1, this.currentSim.curPantType);
        this.pants = new PackedSprite[n3];
        int n4 = 0;
        for (n = 0; n < 4; ++n) {
            this.pants[n4] = new PackedSprite(154, 157, this.game.findPalette(56 + n));
            ++n4;
            this.game.updateLoading();
        }
        if (!this.currentSim.isFemale) {
            for (n = 0; n < 4; ++n) {
                this.pants[n4] = new PackedSprite(162, 165, this.game.findPalette(60 + n));
                ++n4;
                this.game.updateLoading();
            }
        } else {
            for (n = 0; n < 4; ++n) {
                this.pants[n4] = new PackedSprite(164, 167, this.game.findPalette(64 + n));
                ++n4;
                this.game.updateLoading();
            }
            for (n = 0; n < 4; ++n) {
                this.pants[n4] = new PackedSprite(164, 167, this.game.findPalette(116 + n));
                ++n4;
                this.game.updateLoading();
            }
            for (n = 0; n < 4; ++n) {
                this.pants[n4] = new PackedSprite(164, 167, this.game.findPalette(101 + n));
                ++n4;
                this.game.updateLoading();
            }
        }
    }

    void loadCreationScreen() {
        int n;
        int n2;
        this.game.updateLoading();
        this.setBg(181);
        this.game.updateLoading();
        this.body = new PackedSprite[8];
        for (n2 = 0; n2 < 8; ++n2) {
            this.body[n2] = new PackedSprite(150, 153, this.game.findPalette(68 + n2));
            this.game.updateLoading();
        }
        this.shirts = new PackedSprite[48];
        n2 = 0;
        for (n = 0; n < 8; ++n) {
            this.shirts[n2] = new PackedSprite(158, 161, this.game.findPalette(0 + n));
            this.game.updateLoading();
            ++n2;
        }
        for (n = 0; n < 8; ++n) {
            this.shirts[n2] = new PackedSprite(158, 161, this.game.findPalette(108 + n));
            this.game.updateLoading();
            ++n2;
        }
        for (n = 0; n < 8; ++n) {
            this.shirts[n2] = new PackedSprite(157, 160, this.game.findPalette(8 + n));
            this.game.updateLoading();
            ++n2;
        }
        for (n = 0; n < 8; ++n) {
            this.shirts[n2] = new PackedSprite(159, 162, this.game.findPalette(16 + n));
            this.game.updateLoading();
            ++n2;
        }
        for (n = 0; n < 8; ++n) {
            this.shirts[n2] = new PackedSprite(157, 160, this.game.findPalette(24 + n));
            this.game.updateLoading();
            ++n2;
        }
        for (n = 0; n < 8; ++n) {
            this.shirts[n2] = new PackedSprite(157, 160, this.game.findPalette(32 + n));
            this.game.updateLoading();
            ++n2;
        }
        this.faces = new PackedSprite[8];
        for (n = 0; n < 8; ++n) {
            this.faces[n] = new PackedSprite(151, 154, this.game.findPalette(40 + n));
            this.game.updateLoading();
        }
        this.loadPants();
        this.hairs = new PackedSprite[8];
        for (n = 0; n < 8; ++n) {
            this.hairs[n] = new PackedSprite(153, 156, this.game.findPalette(48 + n));
            this.game.updateLoading();
        }
        this.game.updateLoading();
        this.pedestal = new PackedSprite(155, 158);
        this.topButton = new PackedSprite(166, 228);
        this.topButton.setFraming(2, this.topButton.framesWide - 1);
        this.topButton.speed = 250;
        this.game.updateLoading();
        this.imgColorSelection = Game.createImage(167);
        this.imgColorSelected = Game.createImage(226);
        this.imgDPad = Game.createImage(325);
        this.sprItemButton = new PackedSprite(251, 229);
        this.sprItemButton.setFraming(2, this.sprItemButton.framesWide - 1);
        this.sprItemButton.speed = 250;
        this.topIcon = new PackedSprite(165, 168);
        this.selectorArrows = new PackedSprite(168, 192);
        this.game.updateLoading();
        this.gridHairTypes = new PackedSprite(212, 190);
        this.gridEyeTypes = new PackedSprite(211, 189);
        this.gridClothesTypes = new PackedSprite(210, 188);
        this.game.updateLoading();
        this.sprGender = new PackedSprite(208, 186);
        this.sprGenderOn = new PackedSprite(209, 187);
        this.game.updateLoading();
        this.gridHeight = 28;
        this.gridWidth = 34;
        this.posBg = new Position(0, 0);
        this.game.softkeyL = 0;
        this.game.softkeyR = 2;
        this.menuSoftkeyL = this.game.softkeyL;
        this.menuSoftkeyR = this.game.softkeyR;
    }

    void processCreationScreen(int n) {
        this.topButton.nextFrame(System.currentTimeMillis());
        this.sprItemButton.nextFrame(System.currentTimeMillis());
        int n2 = this.selRow;
        if (this.selRow < 0) {
            n2 = 0;
        }
        int n3 = this.curScreenTable[n2][this.selCol];
        if (this.selRow >= 0) {
            if (n3 >= 0 && n3 <= 7) {
                this.curBodyColor = n3 - 0;
            } else if (n3 >= 8 && n3 <= 15) {
                this.curFaceColor = n3 - 8;
            } else if (n3 >= 16 && n3 <= 23) {
                this.curHairColor = n3 - 16;
            } else if (n3 >= 24 && n3 <= 31) {
                this.curShirtColor = n3 - 24;
            } else if (n3 >= 32 && n3 <= 35) {
                this.curPantColor = n3 - 32;
            } else if (n3 >= 37 && n3 <= 40) {
                this.faceFrame = (this.selCol >> 1) + this.selRow * 2;
            } else if (n3 >= 41 && n3 <= 44) {
                this.hairFrame = (this.selCol >> 1) + this.selRow * 2;
            }
        }
        if (this.curCreationState == 11) {
            boolean bl = this.processTextEntry(n, 10);
            if (bl) {
                return;
            }
            if (n == 10) {
                n = 8;
            }
        }
        switch (n) {
            case -7: {
                if (this.game.wasInGame && this.curCreationState != 10) {
                    this.restorePreviousSimState();
                    this.game.prefs.save();
                    this.releaseCreationAssets();
                    System.gc();
                    this.game.state = 2;
                    this.game.enterAdvState = 2;
                    break;
                }
                if (this.curCreationState - 1 >= 0) {
                    this.enterCreationState(this.curCreationState - 1, false);
                    break;
                }
                if (!this.simCreation) break;
                if (!this.currentSim.isCreated) {
                    this.currentSim.reset();
                    this.game.prefs.save();
                } else {
                    this.restorePreviousSimState();
                }
                this.back();
                this.releaseCreationAssets();
                this.initSimsFlat(false);
                this.simCreation = false;
                break;
            }
            case 1: {
                if (this.curCreationState >= 10) break;
                --this.selRow;
                if (this.selRow >= this.curStateRowStart) break;
                if (this.curCreationState == 0 || this.curCreationState == 2 || this.curCreationState == 4 || this.curCreationState == 6) {
                    if (this.game.wasInGame) {
                        this.selRow = 0;
                        break;
                    }
                    this.selRow = -1;
                    break;
                }
                this.enterCreationState(this.curCreationState - 1, false);
                break;
            }
            case 6: {
                if (this.curCreationState >= 10) break;
                ++this.selRow;
                while (this.selRow < this.curStateRowStart) {
                    ++this.selRow;
                }
                if (this.selRow <= this.curStateRowEnd) break;
                if (this.curCreationState == 1 || this.curCreationState == 3 || this.curCreationState == 5 || this.curCreationState == 9) {
                    --this.selRow;
                    break;
                }
                this.enterCreationState(this.curCreationState + 1, false);
                break;
            }
            case 5: {
                if (this.curCreationState > 10) break;
                if (this.selRow >= 0) {
                    this.pressed = n;
                    this.keyPressTime = System.currentTimeMillis() + 300L;
                    if (n3 < 36) {
                        ++this.selCol;
                        this.selCol %= 4;
                        break;
                    }
                    if (n3 >= 45 && n3 <= 46) {
                        this.selCol += 2;
                        this.selCol %= 4;
                        this.currentSim.isFemale = this.selCol != 0;
                        this.loadPants();
                        if (this.currentSim.isFemale || this.currentSim.curShirtType >= 2) break;
                        this.currentSim.curShirtType = 2;
                        break;
                    }
                    if (n3 >= 37 && n3 <= 40) {
                        this.selCol += 2;
                        this.selCol %= 4;
                        break;
                    }
                    if (n3 >= 41 && n3 <= 44) {
                        this.selCol += 2;
                        this.selCol %= 4;
                        break;
                    }
                    if (n3 == 47) {
                        ++this.currentSim.curShirtType;
                        if (this.currentSim.isFemale) {
                            this.currentSim.curShirtType %= 6;
                            break;
                        }
                        if (this.currentSim.curShirtType < 6) break;
                        this.currentSim.curShirtType = 2;
                        break;
                    }
                    if (n3 != 48) break;
                    if (this.currentSim.isFemale) {
                        ++this.currentSim.curPantType;
                        this.currentSim.curPantType %= 4;
                        break;
                    }
                    ++this.currentSim.curPantType;
                    this.currentSim.curPantType %= 2;
                    break;
                }
                ++this.curCreationScreen;
                switch (this.curCreationScreen) {
                    case 0: {
                        this.enterCreationState(0, false);
                        break;
                    }
                    case 1: {
                        this.enterCreationState(2, false);
                        break;
                    }
                    case 2: {
                        this.enterCreationState(4, false);
                        break;
                    }
                    case 3: {
                        this.enterCreationState(6, false);
                        break;
                    }
                    default: {
                        this.curCreationScreen = 3;
                        this.enterCreationState(10, false);
                    }
                }
                this.selRow = -1;
                break;
            }
            case 2: {
                if (this.curCreationState > 10) break;
                if (this.selRow >= 0) {
                    this.pressed = n;
                    this.keyPressTime = System.currentTimeMillis() + 300L;
                    if (n3 < 36) {
                        --this.selCol;
                        if (this.selCol >= 0) break;
                        this.selCol = 3;
                        break;
                    }
                    if (n3 >= 45 && n3 <= 46) {
                        this.selCol -= 2;
                        if (this.selCol < 0) {
                            this.selCol = 2;
                        }
                        this.currentSim.isFemale = this.selCol != 0;
                        this.loadPants();
                        if (this.currentSim.isFemale || this.currentSim.curShirtType >= 2) break;
                        this.currentSim.curShirtType = 2;
                        break;
                    }
                    if (n3 >= 37 && n3 <= 40) {
                        this.selCol -= 2;
                        if (this.selCol >= 0) break;
                        this.selCol = 2;
                        break;
                    }
                    if (n3 >= 41 && n3 <= 44) {
                        this.selCol -= 2;
                        if (this.selCol >= 0) break;
                        this.selCol = 2;
                        break;
                    }
                    if (n3 == 47) {
                        --this.currentSim.curShirtType;
                        if ((!this.currentSim.isFemale || this.currentSim.curShirtType >= 0) && (this.currentSim.isFemale || this.currentSim.curShirtType >= 2)) break;
                        this.currentSim.curShirtType = 5;
                        break;
                    }
                    if (n3 != 48) break;
                    --this.currentSim.curPantType;
                    if (this.currentSim.curPantType >= 0) break;
                    if (this.currentSim.isFemale) {
                        this.currentSim.curPantType = 3;
                        break;
                    }
                    this.currentSim.curPantType = 1;
                    break;
                }
                --this.curCreationScreen;
                if (this.curCreationState == 10) {
                    this.curCreationScreen = 3;
                }
                if (this.curCreationScreen < 0) {
                    this.curCreationScreen = 0;
                }
                switch (this.curCreationScreen) {
                    case 0: {
                        this.enterCreationState(0, false);
                        break;
                    }
                    case 1: {
                        this.enterCreationState(2, false);
                        break;
                    }
                    case 2: {
                        this.enterCreationState(4, false);
                        break;
                    }
                    case 3: {
                        this.enterCreationState(6, false);
                    }
                }
                this.selRow = -1;
                break;
            }
            case -6: 
            case 8: {
                if (this.curCreationState == 11 && this.game.pureKey != 53 || this.curCreationState == 10 && this.game.wasInGame) {
                    if (this.curCreationState == 11) {
                        if (this.curEntry.indexOf(95, 0) >= 0) {
                            this.curEntry = this.curEntry.substring(0, Math.max(this.curEntry.length() - 1, 0));
                        }
                        this.currentSim.name = this.curEntry.compareTo("") == 0 ? this.game.strings[45] : this.curEntry;
                    }
                    if (this.simCreation) {
                        this.currentSim.isCreated = true;
                        this.releaseCreationAssets();
                        this.currentSim.load(this.game);
                        this.currentSim.setAnim(19, -1);
                        this.game.prefs.save();
                        this.initSimsFlat(false);
                        this.simCreation = false;
                        break;
                    }
                    this.game.prefs.save();
                    this.releaseCreationAssets();
                    this.game.playerSim = this.currentSim;
                    this.game.state = 2;
                    this.game.enterAdvState = 2;
                    break;
                }
                this.enterCreationState(this.curCreationState + 1, true);
            }
        }
    }

    public boolean processTextEntry(int n, int n2) {
        long l = System.currentTimeMillis();
        if (l >= this.entryTime && n == 0 && this.entryIndex != -1 && this.curEntry.length() < n2) {
            this.entryIndex = -1;
            this.curEntry = this.curEntry + "_";
            this.game.lastPressed = 0;
        }
        if (this.game.pureKey >= 65 && this.game.pureKey <= 90 || this.game.pureKey >= 97 && this.game.pureKey <= 122 || this.game.pureKey == 32) {
            this.entryIndex = -1;
            if (this.game.pureKey >= 97) {
                this.game.pureKey -= 32;
            }
            this.entryIndex = 0;
            if (this.curEntry.length() < n2 && this.curEntry.indexOf(95, 0) < 0) {
                this.curEntry = this.curEntry + "_";
            }
            if (this.curEntry.length() > 0) {
                this.curEntry = this.curEntry.substring(0, this.curEntry.length() - 1);
            }
            this.curEntry = this.curEntry + (char)this.game.pureKey;
            this.game.lastPressed = this.game.pureKey;
            return true;
        }
        if (n == 2 || this.game.pureKey == -8) {
            if (this.curEntry.compareTo("") != 0) {
                if (this.curEntry.length() > 1) {
                    this.entryIndex = 0;
                    int n3 = 1;
                    if (this.curEntry.indexOf(95, 0) >= 0) {
                        n3 = 2;
                    }
                    this.curEntry = this.curEntry.substring(0, this.curEntry.length() - n3);
                } else if (this.curEntry.indexOf(95, 0) < 0) {
                    this.curEntry = "";
                }
                this.game.lastPressed = 0;
                this.entryTime = 0L;
            }
            return true;
        }
        return false;
    }

    void renderCreationScreen(Graphics graphics) {
        this.pedestal.render(graphics, 2, 188, 0, 0, 36);
        this.body[this.curBodyColor].render(graphics, 2, 188, 0, 0, 36);
        this.pants[this.currentSim.curPantType * 4 + this.curPantColor].render(graphics, 2, 188, 0, 0, 36);
        this.shirts[this.currentSim.curShirtType * 8 + this.curShirtColor].render(graphics, 2, 188, 0, 0, 36);
        this.faces[this.curFaceColor].render(graphics, 2, 188, this.currentSim.isFemale ? this.faceFrame + (this.faces[0].framesWide >> 1) : this.faceFrame, 0, 36);
        this.hairs[this.curHairColor].render(graphics, 2, 188, this.currentSim.isFemale ? this.hairFrame + (this.hairs[0].framesWide >> 1) : this.hairFrame, 0, 36);
        Menu.drawMenuBox(graphics, 87, 34, 147, 154);
        if (this.curCreationState < 10) {
            int n;
            int n2;
            int n3;
            int n4 = 120 - (this.topIcon.framesWide * this.topButton.frameWidth >> 1);
            if (!this.game.wasInGame) {
                for (n3 = 0; n3 < this.topIcon.framesWide; ++n3) {
                    if (this.curCreationScreen == n3 && this.selRow >= 0) {
                        this.topButton.renderPointer(graphics, n4, 0, 1, 0, 20, 10, n3);
                    } else if (this.curCreationScreen == n3 && this.selRow < 0) {
                        this.topButton.renderPointer(graphics, n4, 0, this.topButton.frame, 0, 20, 10, n3);
                    } else {
                        this.topButton.renderPointer(graphics, n4, 0, 0, 0, 20, 10, n3);
                    }
                    this.topIcon.render(graphics, n4 + (this.topButton.frameWidth >> 1), 0, 0 + n3, 0, 17);
                    n4 += this.topButton.frameWidth;
                }
            }
            n4 = 92;
            int n5 = 39;
            int n6 = 0;
            for (n2 = 0; n2 < 5; ++n2) {
                n = -1;
                switch (this.curCreationScreen) {
                    case 0: {
                        n = Constants.BODY_GRID[n2][0];
                        break;
                    }
                    case 1: {
                        n = Constants.FACE_GRID[n2][0];
                        break;
                    }
                    case 2: {
                        n = Constants.HAIR_GRID[n2][0];
                        break;
                    }
                    case 3: {
                        n = Constants.CLOTHES_GRID[n2][0];
                    }
                }
                if (n == -1 || n >= 0 || n2 > this.selRow) continue;
                n6 = n2;
            }
            for (n2 = 0; n2 < 5; ++n2) {
                block29: for (n = 0; n < 4; ++n) {
                    boolean bl;
                    n3 = -1;
                    switch (this.curCreationScreen) {
                        case 0: {
                            n3 = Constants.BODY_GRID[n2][n];
                            break;
                        }
                        case 1: {
                            n3 = Constants.FACE_GRID[n2][n];
                            break;
                        }
                        case 2: {
                            n3 = Constants.HAIR_GRID[n2][n];
                            break;
                        }
                        case 3: {
                            n3 = Constants.CLOTHES_GRID[n2][n];
                        }
                    }
                    if (n3 == -1) continue;
                    int n7 = n4 + n * this.gridWidth + (this.gridWidth >> 1);
                    int n8 = n5 + n2 * this.gridHeight + (this.gridHeight >> 1);
                    boolean bl2 = bl = n2 == this.selRow && n == this.selCol;
                    if (n3 == 49) {
                        this.drawDivider(graphics, n7, n8);
                    }
                    if (n3 >= 0 && n3 <= 7) {
                        this.drawColorSwatchPointer(graphics, n7, n8, Constants.BODY_COLORS[n3 - 0], bl, this.currentSim.curBodyColor == n3 - 0, 12, (n2 - 3) * 4 + n);
                        continue;
                    }
                    if (n3 >= 16 && n3 <= 23) {
                        this.drawColorSwatchPointer(graphics, n7, n8, Constants.HAIR_COLORS[n3 - 16], bl, this.currentSim.curHairColor == n3 - 16, 16, (n2 - 3) * 4 + n);
                        continue;
                    }
                    if (n3 >= 8 && n3 <= 15) {
                        this.drawColorSwatchPointer(graphics, n7, n8, Constants.FACE_COLORS[n3 - 8], bl, this.currentSim.curFaceColor == n3 - 8, 14, (n2 - 3) * 4 + n);
                        continue;
                    }
                    if (n3 >= 24 && n3 <= 31) {
                        switch (this.currentSim.curShirtType) {
                            case 0: 
                            case 1: 
                            case 4: {
                                this.drawColorSwatchPointer(graphics, n7, n8, Constants.SHIRT_OTHER_COLORS[n3 - 24], bl, this.currentSim.curShirtColor == n3 - 24, 18, (n2 - 1) * 4 + n);
                                break;
                            }
                            default: {
                                this.drawColorSwatchPointer(graphics, n7, n8, Constants.SHIRT_MAIN_COLORS[n3 - 24], bl, this.currentSim.curShirtColor == n3 - 24, 18, (n2 - 1) * 4 + n);
                                break;
                            }
                        }
                        continue;
                    }
                    if (n3 >= 32 && n3 <= 35) {
                        switch (this.currentSim.curPantType) {
                            case 0: {
                                this.drawColorSwatchPointer(graphics, n7, n8, Constants.JEAN_COLORS[n3 - 32], bl, this.currentSim.curPantColor == n3 - 32, 20, n);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                if (this.currentSim.isFemale) {
                                    this.drawColorSwatchPointer(graphics, n7, n8, Constants.SKIRT_COLORS[n3 - 32], bl, this.currentSim.curPantColor == n3 - 32, 20, n);
                                    break;
                                }
                                this.drawColorSwatchPointer(graphics, n7, n8, Constants.SHORTS_COLORS[n3 - 32], bl, this.currentSim.curPantColor == n3 - 32, 20, n);
                                break;
                            }
                            default: {
                                this.drawColorSwatchPointer(graphics, n7, n8, Constants.SHIRT_OTHER_COLORS[n3 - 32], bl, this.currentSim.curPantColor == n3 - 32, 20, n);
                                break;
                            }
                        }
                        continue;
                    }
                    int n9 = 0;
                    switch (n3) {
                        case 45: 
                        case 46: {
                            int n10 = n9 = n3 == 46 ? 2 : 0;
                            if (bl) {
                                this.sprGenderOn.renderPointer(graphics, n7 + (this.gridWidth >> 1), n8 + (this.gridHeight >> 1), n3 - 45, 0, 3, 11, n9);
                                continue block29;
                            }
                            this.sprGender.renderPointer(graphics, n7 + (this.gridWidth >> 1), n8 + (this.gridHeight >> 1), n3 - 45, 0, 3, 11, n9);
                            continue block29;
                        }
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: {
                            if (!bl) {
                                if (this.currentSim.faceFrame == n3 - 37) {
                                    this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, true, false);
                                } else {
                                    this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, false, false);
                                }
                            } else {
                                this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, true, true);
                            }
                            n9 = n3 == 37 ? 0 : (n3 == 38 ? 1 : (n3 == 39 ? 2 : (n3 == 40 ? 3 : 0)));
                            this.gridEyeTypes.renderPointer(graphics, n7 + (this.gridWidth >> 1), n8, n3 - 37, 0, 3, 13, n9);
                            continue block29;
                        }
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: {
                            int n11;
                            int n12 = n11 = this.currentSim.isFemale ? this.gridHairTypes.framesWide >> 1 : 0;
                            if (!bl) {
                                if (this.currentSim.hairFrame == n3 - 41) {
                                    this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, true, false);
                                } else {
                                    this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, false, false);
                                }
                            } else {
                                this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, true, true);
                            }
                            n9 = n3 == 41 ? 0 : (n3 == 42 ? 1 : (n3 == 43 ? 2 : (n3 == 44 ? 3 : 0)));
                            this.gridHairTypes.renderPointer(graphics, n7 + (this.gridWidth >> 1), n8, n3 - 41 + n11, 0, 3, 15, n9);
                            continue block29;
                        }
                        case 47: 
                        case 48: {
                            if (this.selRow != n2) {
                                this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, false, false);
                            } else {
                                this.drawItemButton(graphics, n7 + (this.gridWidth >> 1), n8, true, true);
                            }
                            this.gridClothesTypes.render(graphics, n7 + (this.gridWidth >> 1), n8, n3 - 47, 0, 3);
                            continue block29;
                        }
                        case 36: {
                            int n13 = n9 = n2 == 0 ? 17 : 19;
                            if (this.selRow == n2 && this.keyPressTime > System.currentTimeMillis() && this.pressed == 2) {
                                this.selectorArrows.render(graphics, n7, n8, 1, 0, 3);
                            } else {
                                this.selectorArrows.renderPointer(graphics, n7, n8, 0, 0, 3, n9, 0);
                            }
                            if (this.selRow == n2 && this.keyPressTime > System.currentTimeMillis() && this.pressed == 5) {
                                this.selectorArrows.render(graphics, n7 + this.selectorArrows.frameWidth, n8, 3, 0, 3);
                                continue block29;
                            }
                            this.selectorArrows.renderPointer(graphics, n7 + this.selectorArrows.frameWidth, n8, 2, 0, 3, n9, 1);
                        }
                    }
                }
            }
            n2 = 180 - (this.imgDPad.getWidth() >> 1);
            n = 174 - (this.imgDPad.getHeight() >> 1) + 100;
            graphics.drawImage(this.imgDPad, n2, n, 20);
            Game.addPointer(n2 + 24, n, 24, 24, -1);
            Game.addPointer(n2, n + 24, 24, 24, -3);
            Game.addPointer(n2 + 24, n + 24, 24, 24, -5);
            Game.addPointer(n2 + 48, n + 24, 24, 24, -4);
            Game.addPointer(n2 + 24, n + 48, 24, 24, -2);
        } else if (this.curCreationState == 11) {
            this.font.print(graphics, this.font.wrap(this.game.strings[44], 137), 160, 72, 3);
            this.game.drawKeyboardScreen(graphics);
            this.game.fontTiny.print(graphics, this.game.fontTiny.wrap(this.curEntry, 133), 160, 116, 3);
        } else {
            this.font.print(graphics, this.font.wrap(this.game.strings[50], 133), 160, 111, 3);
        }
    }

    void drawDivider(Graphics graphics, int n, int n2) {
        graphics.setColor(2789059);
        graphics.fillRect((n -= this.gridWidth >> 1) + 1, (n2 -= this.gridHeight >> 1) + 1, this.gridWidth * 4 - 2, 5);
        graphics.setColor(16769280);
        graphics.fillRect(n + 2, n2 + 2, this.gridWidth * 4 - 4, 3);
        graphics.setColor(2789059);
        graphics.fillRect(n + 1, n2 + this.gridHeight - 5 - 2, this.gridWidth * 4 - 2, 5);
        graphics.setColor(16769280);
        graphics.fillRect(n + 2, n2 + this.gridHeight - 5 - 1, this.gridWidth * 4 - 4, 3);
    }

    void drawColorSwatch(Graphics graphics, int n, int n2, int n3, boolean bl, boolean bl2) {
        this.drawColorSwatchPointer(graphics, n, n2, n3, bl, bl2, -1, -1);
    }

    void drawColorSwatchPointer(Graphics graphics, int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5) {
        graphics.setColor(16764490);
        graphics.fillRoundRect(n - 8, n2 - 9, 16, 18, 5, 5);
        graphics.setColor(n3);
        graphics.fillRoundRect(n - 8 + 1, n2 - 9 + 1, 14, 16, 5, 5);
        if (n4 != -1) {
            Game.addPointer(n - (this.imgColorSelection.getWidth() >> 1), n2 - (this.imgColorSelection.getHeight() >> 1), this.imgColorSelection.getWidth(), this.imgColorSelection.getHeight(), -5, n4, n5);
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        if (bl) {
            graphics.drawImage(this.imgColorSelection, n, n2, 3);
        } else if (bl2) {
            graphics.drawImage(this.imgColorSelected, n, n2, 3);
        }
    }

    void enterCreationState(int n, boolean bl) {
        int n2 = -1;
        switch (n) {
            case 0: {
                this.curStateRowStart = 0;
                this.curStateRowEnd = 0;
                this.selCol = this.currentSim.isFemale ? 2 : 0;
                this.selRow = this.curStateRowStart;
                this.curCreationScreen = 0;
                break;
            }
            case 11: {
                this.curEntry = "";
                this.entryTime = 0L;
                this.entryIndex = 0;
            }
            case 10: {
                this.selRow = -1;
                break;
            }
            case 1: {
                this.curStateRowStart = 3;
                this.curStateRowEnd = 4;
                this.selCol = 0 + this.currentSim.curBodyColor % 4;
                this.selRow = this.curStateRowStart + this.currentSim.curBodyColor / 4;
                this.curCreationScreen = 0;
                break;
            }
            case 2: {
                this.curStateRowStart = 0;
                this.curStateRowEnd = 1;
                this.selCol = 0 + (this.faceFrame % 2 << 1);
                this.selRow = 0 + this.faceFrame / 2;
                this.curCreationScreen = 1;
                break;
            }
            case 3: {
                this.curStateRowStart = 3;
                this.curStateRowEnd = 4;
                this.selCol = 0 + this.currentSim.curFaceColor % 4;
                this.selRow = this.curStateRowStart + this.currentSim.curFaceColor / 4;
                this.curCreationScreen = 1;
                break;
            }
            case 4: {
                this.curStateRowStart = 0;
                this.curStateRowEnd = 1;
                this.selCol = 0 + (this.hairFrame % 2 << 1);
                this.selRow = 0 + this.hairFrame / 2;
                this.curCreationScreen = 2;
                break;
            }
            case 5: {
                this.curStateRowStart = 3;
                this.curStateRowEnd = 4;
                this.selCol = 0 + this.currentSim.curHairColor % 4;
                this.selRow = this.curStateRowStart + this.currentSim.curHairColor / 4;
                this.curCreationScreen = 2;
                break;
            }
            case 6: {
                this.curStateRowStart = 0;
                this.curStateRowEnd = 0;
                this.selCol = 0;
                this.selRow = this.curStateRowStart;
                this.curCreationScreen = 3;
                break;
            }
            case 7: {
                this.curStateRowStart = 1;
                this.curStateRowEnd = 2;
                this.selCol = 0 + this.currentSim.curShirtColor % 4;
                this.selRow = this.curStateRowStart + this.currentSim.curShirtColor / 4;
                this.curCreationScreen = 3;
                break;
            }
            case 8: {
                this.curStateRowStart = 3;
                this.curStateRowEnd = 3;
                this.selCol = 0;
                this.selRow = this.curStateRowStart;
                this.curCreationScreen = 3;
                break;
            }
            case 9: {
                this.curStateRowStart = 4;
                this.curStateRowEnd = 4;
                this.selCol = 0 + this.currentSim.curPantColor % 4;
                this.selRow = this.curStateRowStart + this.currentSim.curPantColor / 4;
                this.curCreationScreen = 3;
            }
        }
        this.curCreationState = n;
        if (bl) {
            this.currentSim.curBodyColor = this.curBodyColor;
            this.currentSim.curFaceColor = this.curFaceColor;
            this.currentSim.curHairColor = this.curHairColor;
            this.currentSim.curShirtColor = this.curShirtColor;
            this.currentSim.curPantColor = this.curPantColor;
            this.currentSim.faceFrame = this.faceFrame;
            this.currentSim.hairFrame = this.hairFrame;
        } else {
            this.curBodyColor = this.currentSim.curBodyColor;
            this.curFaceColor = this.currentSim.curFaceColor;
            this.curHairColor = this.currentSim.curHairColor;
            this.curShirtColor = this.currentSim.curShirtColor;
            this.curPantColor = this.currentSim.curPantColor;
            this.faceFrame = this.currentSim.faceFrame;
            this.hairFrame = this.currentSim.hairFrame;
        }
        switch (this.curCreationScreen) {
            case 0: {
                this.curScreenTable = Constants.BODY_GRID;
                break;
            }
            case 1: {
                this.curScreenTable = Constants.FACE_GRID;
                break;
            }
            case 2: {
                this.curScreenTable = Constants.HAIR_GRID;
                break;
            }
            case 3: {
                this.curScreenTable = Constants.CLOTHES_GRID;
            }
        }
    }

    void releaseCreationAssets() {
        int n;
        this.game.prefs.save();
        for (n = 0; n < this.body.length; ++n) {
            this.body[n] = null;
        }
        for (n = 0; n < this.faces.length; ++n) {
            this.faces[n] = null;
        }
        for (n = 0; n < this.shirts.length; ++n) {
            this.shirts[n] = null;
        }
        for (n = 0; n < this.pants.length; ++n) {
            this.pants[n] = null;
        }
        for (n = 0; n < this.hairs.length; ++n) {
            this.hairs[n] = null;
        }
        this.pedestal = null;
        this.topIcon = null;
        this.selectorArrows = null;
        this.topButton = null;
        this.imgColorSelected = null;
        this.imgColorSelection = null;
        this.imgDPad = null;
        this.sprItemButton = null;
        this.sprGender = null;
        this.sprGenderOn = null;
        this.gridHairTypes = null;
        this.gridEyeTypes = null;
        this.gridClothesTypes = null;
    }

    void processTravelScreen(int n) {
        this.sprDiamond.nextFrame(System.currentTimeMillis());
        if (this.mapIntro) {
            if (n == 8 || n == -7) {
                if (this.bagHelpText == -1) {
                    this.game.state = 2;
                    this.game.enterAdvState = 3;
                    this.game.softkeyL = -1;
                    this.game.softkeyR = -1;
                    this.game.envokeNextQuestItem(this.game.introQuestID);
                } else {
                    this.bagHelpText = -1;
                }
                return;
            }
        } else {
            this.game.softkeyL = -1;
            if (n == -7) {
                this.game.softkeyL = 5;
                this.game.softkeyR = 6;
                this.game.state = 2;
                this.game.enterAdvState = 3;
            }
        }
        switch (n) {
            case 1: {
                int n2;
                --this.curTravelIcon;
                if (this.curTravelIcon < 0) {
                    this.curTravelIcon = this.charIcons.framesWide - 1;
                }
                for (n2 = 0; (this.game.npcs[DeviceConstants.MAP_CHAR_FRAMES[this.curTravelIcon] - 1].locked || !this.game.npcs[DeviceConstants.MAP_CHAR_FRAMES[this.curTravelIcon] - 1].active) && n2 < this.charIcons.framesWide; ++n2) {
                    --this.curTravelIcon;
                    if (this.curTravelIcon >= 0) continue;
                    this.curTravelIcon = this.charIcons.framesWide - 1;
                }
                if (n2 != this.charIcons.framesWide) break;
                this.curTravelIcon = -1;
                break;
            }
            case 6: {
                int n3;
                ++this.curTravelIcon;
                this.curTravelIcon %= this.charIcons.framesWide;
                for (n3 = 0; (this.game.npcs[DeviceConstants.MAP_CHAR_FRAMES[this.curTravelIcon] - 1].locked || !this.game.npcs[DeviceConstants.MAP_CHAR_FRAMES[this.curTravelIcon] - 1].active) && n3 < this.charIcons.framesWide; ++n3) {
                    ++this.curTravelIcon;
                    this.curTravelIcon %= this.charIcons.framesWide;
                }
                if (n3 != this.charIcons.framesWide) break;
                this.curTravelIcon = -1;
                break;
            }
            case 8: {
                if (this.curTravelIcon < 0) break;
                this.game.state = 2;
                this.game.enterAdvState = 3;
                int n4 = DeviceConstants.MAP_CHAR_FRAMES[this.curTravelIcon];
                if (DeviceConstants.MAP_CHAR_FRAMES[this.curTravelIcon] != 5 && DeviceConstants.MAP_CHAR_FRAMES[this.curTravelIcon] != 6) {
                    if (this.game.curMap != 114) {
                        this.game.lastPoints.removeAllElements();
                        this.game.curNpc = null;
                        this.game.loadEnvironment(114, 114, 117, 116, null, 2, 0);
                    }
                } else if (this.game.curMap != 318) {
                    this.game.lastPoints.removeAllElements();
                    this.game.curNpc = null;
                    this.game.loadEnvironment(318, 270, 272, 271, null, 2, 0);
                }
                MovePoint movePoint = this.game.findNode(n4);
                this.game.isMovingBack = false;
                int n5 = 0;
                if (n5 < movePoint.nextNodes.size()) {
                    short[] sArray = (short[])movePoint.nextNodes.elementAt(n5);
                    int n6 = sArray[2] - 1;
                    movePoint = (MovePoint)this.game.movePoints.elementAt(Math.abs(sArray[2]) - 1);
                }
                this.game.playerSim.position.moveTo(movePoint.X, movePoint.Y, 2, 0);
                this.game.waitForInput = true;
                this.game.curPoint = movePoint;
                this.game.getDirArrows();
                this.game.cameraX = Math.min(Math.max((this.game.playerSim.position.x >> 8) - 120, 0), this.game.camera_x_max);
                this.game.cameraY = Math.min(Math.max((this.game.playerSim.position.y >> 8) - 232, 0), this.game.camera_y_max);
                this.game.camera.x = this.game.cameraX << 8;
                this.game.camera.y = this.game.cameraY << 8;
                this.game.key = 0;
                this.game.keyDown = false;
            }
        }
    }

    void loadSimsScreen() {
        int n;
        this.sims_state = 3;
        this.simsHighlight = 0;
        this.game.updateLoading();
        this.imgBg = Game.createImage(261);
        this.imgDPad = Game.createImage(321);
        this.sprHudTiles = new PackedSprite(266, 239);
        this.imgBoxes = new Image[3];
        this.imgBoxes[0] = Game.createImage(262, this.game.findPalette(138));
        this.imgBoxes[1] = Game.createImage(262, this.game.findPalette(137));
        this.imgBoxes[2] = Game.createImage(262, this.game.findPalette(136));
        this.imgBevel = Game.createImage(267);
        this.sprDots = new PackedSprite(263, 238);
        this.imgSpotlight = Game.createImage(265);
        this.imgNameBadge = Game.createImage(264);
        for (n = 0; n < 24; ++n) {
            this.game.prefs.sims[n].isLoaded = false;
        }
        for (n = 0; n < 6; ++n) {
            int n2 = this.highlight * 6 + n;
            Sim sim = this.game.prefs.sims[n2];
            int n3 = 348 - this.sprHudTiles.frameHeight - this.game.sprSoftkeys.frameHeight - this.imgNameBadge.getHeight();
            int n4 = n / 3;
            int n5 = n % 3;
            int n6 = 240 * (n5 + 1) / 4;
            int n7 = this.sprHudTiles.frameHeight + this.imgNameBadge.getHeight() + n3 * (n4 + 1) / 2;
            this.game.updateLoading();
            sim.position.x = n6 << 8;
            sim.position.y = n7 << 8;
            sim.position.dx = sim.position.x;
            sim.position.dy = sim.position.y;
            if (!sim.isCreated || sim.isLoaded) continue;
            sim.load(this.game);
            sim.setAnim(21, -1);
        }
    }

    void processSimsScreen(int n) {
        block39: {
            long l;
            block38: {
                int n2;
                block40: {
                    l = System.currentTimeMillis();
                    if (this.sims_state == 3) {
                        switch (n) {
                            case 1: {
                                --this.simsHighlight;
                                if (this.simsHighlight >= 0) break;
                                this.simsHighlight = this.simsItems.size() - 1;
                                break;
                            }
                            case 6: {
                                ++this.simsHighlight;
                                this.simsHighlight %= this.simsItems.size();
                                break;
                            }
                            case -6: 
                            case 8: 
                            case 53: {
                                if (this.simsHighlight == this.SIMS_ITEM_START_GAME) {
                                    this.releaseSimsScreen();
                                    this.game.prefs.townName = "";
                                    this.game.playerSim = this.game.autoGenerateSim();
                                    if (this.game.SIM_HEIGHT == 0) {
                                        this.game.playerSim.load(this.game);
                                        this.game.playerSim.release();
                                    }
                                    for (int i = 0; i < this.game.prefs.sims.length; ++i) {
                                        if (this.game.prefs.sims[i].isCreated) continue;
                                        this.game.prefs.sims[i] = this.game.playerSim;
                                        this.game.prefs.sims[i].isCreated = true;
                                        this.game.playerSim.name = this.game.strings[45];
                                        this.game.prefs.save();
                                        break;
                                    }
                                    this.game.state = 2;
                                    this.game.enterAdvState = 0;
                                    return;
                                }
                                this.sims_state = 0;
                                n = 0;
                                break;
                            }
                            case -7: {
                                this.releaseSimsScreen();
                                this.setBg(148);
                                this.back();
                            }
                        }
                    }
                    if (this.sims_state != 1 && this.sims_state != 2) break block38;
                    boolean bl = false;
                    for (n2 = 0; n2 < 24; ++n2) {
                        Sim sim = this.game.prefs.sims[n2];
                        sim.process(l);
                        if (!sim.isLoaded) continue;
                        if (sim.position.moving) {
                            bl = true;
                            continue;
                        }
                        if (sim.body.animation == 21) continue;
                        sim.setAnim(21, -1);
                    }
                    if (bl) break block39;
                    if (this.sims_state != 1) break block40;
                    this.sims_state = 0;
                    break block39;
                }
                if (this.sims_state != 2) break block39;
                this.highlight = this.highlightCol;
                for (n2 = 0; n2 < 24; ++n2) {
                    this.game.prefs.sims[n2].release();
                }
                System.gc();
                for (n2 = 0; n2 < 6; ++n2) {
                    int n3 = this.highlight * 6 + n2;
                    Sim sim = this.game.prefs.sims[n3];
                    int n4 = 348 - this.sprHudTiles.frameHeight - this.game.sprSoftkeys.frameHeight - this.imgNameBadge.getHeight();
                    int n5 = n2 / 3;
                    int n6 = n2 % 3;
                    int n7 = 240 * (n6 + 1) / 4;
                    int n8 = this.sprHudTiles.frameHeight + this.imgNameBadge.getHeight() + n4 * (n5 + 1) / 2;
                    sim.position.x = n7 << 8;
                    sim.position.y = n8 << 8;
                    if (!sim.isCreated || sim.isLoaded) continue;
                    this.game.updateLoading();
                    sim.load(this.game);
                    if (this.sim_direction == 1) {
                        sim.position.x = 240 + n7 << 8;
                        sim.setAnim(7, -1);
                    } else {
                        sim.position.x = -(240 - n7 << 8);
                        sim.setAnim(5, -1);
                    }
                    sim.position.moveTo(n7, n8, 0, 1000);
                }
                this.sims_state = 1;
                break block39;
            }
            if (this.sims_state == 0) {
                int n9;
                for (n9 = 0; n9 < 24; ++n9) {
                    Sim sim = this.game.prefs.sims[n9];
                    sim.process(l);
                    if (!sim.isLoaded) continue;
                    int n10 = this.highlight * 6 + this.selRow * 3 + this.selCol;
                    if (n9 == n10 && sim.body.animation != 19) {
                        sim.setAnim(19, -1);
                    }
                    if (n9 == n10 || sim.body.animation != 19 || !sim.body.finishedLoop) continue;
                    sim.setAnim(21, -1);
                }
                boolean bl = false;
                switch (n) {
                    case -7: {
                        if (this.highlight > 0) {
                            this.highlightCol = this.highlight - 1;
                            bl = true;
                            this.sim_direction = 0;
                            break;
                        }
                        this.initSimsFlat(true);
                        break;
                    }
                    case -6: 
                    case 8: 
                    case 53: {
                        if (this.selRow >= 0) {
                            n9 = this.highlight * 6 + this.selCol + this.selRow * 3;
                            this.currentSim = this.game.prefs.sims[n9];
                            if (this.simsHighlight == this.SIMS_ITEM_CHOOSE && this.currentSim.isCreated) {
                                this.releaseSimsScreen();
                                this.game.playerSim = this.currentSim;
                                this.game.state = 2;
                                if (this.lastItemSelected == this.ITEM_NEW_GAME) {
                                    this.game.enterAdvState = 0;
                                    break;
                                }
                                this.game.enterAdvState = 1;
                                break;
                            }
                            if (this.simsHighlight == this.SIMS_ITEM_DELETE && this.currentSim.isCreated) {
                                Position position = this.game.prefs.sims[n9].position;
                                this.game.prefs.sims[n9].reset();
                                this.game.prefs.sims[n9].position = position;
                                this.game.prefs.save();
                                break;
                            }
                            if (this.simsHighlight != this.SIMS_ITEM_NEW_EDIT) break;
                            this.type = 6;
                            this.subType = -1;
                            this.curMenu = 16;
                            this.setPreviousSimState();
                            this.simCreation = true;
                            this.releaseSimsScreen();
                            this.loadCreationScreen();
                            this.enterCreationState(0, false);
                            break;
                        }
                        if (this.highlightCol > this.highlight) {
                            bl = true;
                            this.sim_direction = 1;
                            break;
                        }
                        if (this.highlightCol >= this.highlight) break;
                        bl = true;
                        this.sim_direction = 0;
                        break;
                    }
                    case 2: 
                    case 52: {
                        if (this.selRow >= 0 && --this.selCol < 0) {
                            int n11 = this.selCol = this.highlight > 0 ? 2 : 0;
                            if (this.highlight <= 0) break;
                            this.highlightCol = this.highlight - 1;
                            bl = true;
                            this.sim_direction = 0;
                            break;
                        }
                        if (this.selRow >= 0 || this.highlightCol <= 0) break;
                        --this.highlightCol;
                        break;
                    }
                    case 5: 
                    case 54: {
                        if (this.selRow >= 0 && ++this.selCol >= 3) {
                            int n12 = this.selCol = this.highlight < 3 ? 0 : 2;
                            if (this.highlight >= 3) break;
                            this.highlightCol = this.highlight + 1;
                            bl = true;
                            this.sim_direction = 1;
                            break;
                        }
                        if (this.selRow >= 0 || this.highlightCol >= 3) break;
                        ++this.highlightCol;
                        break;
                    }
                    case 1: 
                    case 50: {
                        if (this.selRow <= -1) break;
                        this.highlightCol = this.highlight;
                        --this.selRow;
                        break;
                    }
                    case 6: 
                    case 56: {
                        if (this.selRow >= 1) break;
                        ++this.selRow;
                    }
                }
                if (bl) {
                    this.sims_state = 2;
                    for (int i = 0; i < 6; ++i) {
                        n9 = this.highlight * 6 + i;
                        Sim sim = this.game.prefs.sims[n9];
                        if (!sim.isCreated || !sim.isLoaded) continue;
                        if (this.sim_direction == 1) {
                            sim.position.moveTo(-sim.body.frameWidth, sim.position.y >> 8, 0, 1000);
                            sim.setAnim(7, -1);
                            continue;
                        }
                        sim.position.moveTo(240 + sim.body.frameWidth, sim.position.y >> 8, 0, 1000);
                        sim.setAnim(5, -1);
                    }
                }
            }
        }
        this.setSimsSoftkeys();
    }

    void setSimsSoftkeys() {
        this.game.softkeyL = -1;
        this.game.softkeyR = -1;
        switch (this.sims_state) {
            case 3: {
                this.game.softkeyL = 0;
                this.game.softkeyR = 2;
                break;
            }
            case 0: {
                if (this.selRow < 0) {
                    if (this.highlight != this.highlightCol) {
                        this.game.softkeyL = 0;
                    }
                } else if (this.simsHighlight == this.SIMS_ITEM_NEW_EDIT) {
                    this.game.softkeyL = 0;
                } else {
                    int n = this.highlight * 6 + this.selCol + this.selRow * 3;
                    Sim sim = this.game.prefs.sims[n];
                    if (sim.isCreated) {
                        this.game.softkeyL = 0;
                    }
                }
                this.game.softkeyR = 2;
            }
        }
    }

    void updateSimsOptions() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.game.prefs.sims.length; ++n) {
            if (!this.game.prefs.sims[n].isCreated) continue;
            ++n2;
        }
        this.SIMS_ITEM_DELETE = -1;
        this.SIMS_ITEM_START_GAME = -1;
        this.SIMS_ITEM_NEW_EDIT = -1;
        this.SIMS_ITEM_CHOOSE = -1;
        this.simsItems = new Vector();
        n = 0;
        if (n2 > 0 && this.lastItemSelected != this.ITEM_SIMS) {
            this.simsItems.addElement(new Integer(110));
            this.SIMS_ITEM_CHOOSE = n++;
        }
        if (this.lastItemSelected == this.ITEM_NEW_GAME) {
            this.game.prefs.townName = "";
            this.simsItems.addElement(new Integer(109));
            this.SIMS_ITEM_START_GAME = n++;
        }
        this.SIMS_ITEM_NEW_EDIT = n++;
        this.simsItems.addElement(new Integer(111));
        if (n2 > 0) {
            this.SIMS_ITEM_DELETE = n++;
            this.simsItems.addElement(new Integer(112));
        }
        this.stringWidth = 0;
        for (int i = 0; i < this.simsItems.size(); ++i) {
            this.stringWidth = Math.max(this.font.getLineWidth(this.game.strings[(Integer)this.simsItems.elementAt(i)].toCharArray(), 0), this.stringWidth);
        }
    }

    void renderSimsScreen(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        graphics.drawImage(this.imgBg, 0, 0, 20);
        int n5 = this.selRow * 3 + this.selCol;
        for (n4 = 0; n4 < 6; ++n4) {
            Sim sim = this.game.prefs.sims[this.highlight * 6 + n4];
            int n6 = n3 = n4 == n5 && this.selRow >= 0 && this.sims_state == 0 ? 1 : 0;
            if (n3 != 0) {
                graphics.drawImage(this.imgSpotlight, sim.position.x >> 8, sim.position.y >> 8, 33);
            }
            if (this.sims_state == 0) {
                Game.addPointer((sim.position.x >> 8) - (this.imgSpotlight.getWidth() >> 1), (sim.position.y >> 8) - 40, this.imgSpotlight.getWidth(), 40, -5, 9, n4);
            }
            sim.render(graphics, sim.position.x >> 8, sim.position.y >> 8, 33);
            if (!sim.isLoaded || n4 != n5) continue;
            n2 = this.imgNameBadge.getWidth() >> 2;
            int n7 = this.game.fontTiny.getStringWidth(sim.name.toCharArray(), 0);
            int n8 = (sim.position.x >> 8) - (n7 >> 1) - n2;
            int n9 = (sim.position.y >> 8) - sim.body.frameHeight;
            graphics.setClip(n8, 0, n2, 348);
            graphics.drawImage(this.imgNameBadge, n8, n9, 6);
            n8 += n2;
            while (n8 <= (sim.position.x >> 8) + (n7 >> 1)) {
                graphics.setClip(n8, 0, n2, 348);
                graphics.drawImage(this.imgNameBadge, n8 - n2, n9, 6);
                n8 += n2;
            }
            n8 = (sim.position.x >> 8) + (n7 >> 1);
            graphics.setClip(n8, 0, n2, 348);
            graphics.drawImage(this.imgNameBadge, n8 - n2 * 3, n9, 6);
            n8 = (sim.position.x >> 8) - (n2 >> 1);
            graphics.setClip(n8, 0, n2, 348);
            graphics.drawImage(this.imgNameBadge, n8 - (n2 << 1), n9, 6);
            graphics.setClip(0, 0, 240, 348);
            int n10 = 0;
            if (this.game.fontTiny.height < 20) {
                n10 = 2;
            }
            this.game.fontTiny.print(graphics, sim.name, sim.position.x >> 8, n9 - (this.imgNameBadge.getHeight() >> 1) + n10, 17);
        }
        n4 = 0;
        this.sprHudTiles.render(graphics, n4, 0, 0, 0, 20);
        n4 += this.sprHudTiles.frameWidth;
        while (n4 < 240 - this.sprHudTiles.frameWidth) {
            this.sprHudTiles.render(graphics, n4, 0, 1, 0, 20);
            n4 += this.sprHudTiles.frameWidth;
        }
        this.sprHudTiles.render(graphics, 240, 0, 2, 0, 24);
        for (n = 0; n < 4; ++n) {
            n4 = 240 * (n + 1) / 5;
            graphics.drawImage(this.imgBevel, n4, this.sprHudTiles.frameHeight >> 1, 3);
            n3 = 0;
            if (this.highlight == n) {
                n3 = 1;
            }
            if (this.highlightCol == n && this.selRow < 0) {
                n3 = 2;
            }
            graphics.drawImage(this.imgBoxes[n3], n4, this.sprHudTiles.frameHeight >> 1, 3);
            if (this.sims_state == 0) {
                Game.addPointer(n4 - (this.imgBoxes[n3].getWidth() >> 1), this.sprHudTiles.frameHeight - this.imgBoxes[n3].getHeight() >> 1, this.imgBoxes[n3].getWidth(), this.imgBoxes[n3].getHeight(), -5, 8, n);
            }
            for (n2 = 0; n2 < 6; ++n2) {
                if (!this.game.prefs.sims[n * 6 + n2].isCreated) continue;
                this.sprDots.render(graphics, n4, this.sprHudTiles.frameHeight >> 1, 0, n2, 3);
            }
        }
        if (this.sims_state == 3) {
            n = this.simsItems.size() * this.font.height;
            n3 = 174 - (n >> 1);
            for (n2 = 0; n2 < this.simsItems.size(); ++n2) {
                GraphicFont graphicFont = this.font;
                if (n2 == this.simsHighlight) {
                    graphicFont = this.highlightFont;
                }
                graphicFont.printPointer(graphics, this.game.strings[(Integer)this.simsItems.elementAt(n2)], 120, n3, 17, 3, n2);
                n3 += this.font.height;
            }
        }
        if (this.sims_state == 0) {
            n = 240 - this.imgDPad.getWidth() >> 1;
            n3 = 348 - this.imgDPad.getHeight() - 4;
            graphics.drawImage(this.imgDPad, n, n3, 20);
            Game.addPointer(n, n3, 24, 24, -3);
            Game.addPointer(n + 24, n3, 24, 24, -5);
            Game.addPointer(n + 48, n3, 24, 24, -4);
        }
    }

    void releaseSimsScreen() {
        this.imgBg = null;
        this.sprHudTiles = null;
        this.imgBoxes = null;
        this.imgBevel = null;
        this.sprDots = null;
        this.imgNameBadge = null;
        this.imgSpotlight = null;
        for (int i = 0; i < 24; ++i) {
            this.game.prefs.sims[i].release();
        }
        System.gc();
    }

    void renderFinalResults(Graphics graphics) {
        graphics.setClip(0, 0, 240, 348);
        int n = this.font.leading + 10;
        int n2 = this.font.leading * 6 + 12 + 4 + 10;
        int n3 = 4;
        int n4 = (348 - this.game.sprSoftkeys.frameHeight >> 1) - (n2 + 2 + n >> 1);
        int n5 = this.font.leading;
        int n6 = 240 - (n3 << 1);
        Menu.drawMenuBox(graphics, n3, n4, n6, n);
        int n7 = n6 - 10 - 4;
        this.font.setScrollText(this.game.prefs.townName, n7);
        graphics.setClip(n3 + 5 + 2, n4 + 5, n7, n - 10);
        this.font.printScrollText(graphics, this.game.prefs.townName, 120, n4 + 5, 17);
        graphics.setClip(0, 0, 240, 348);
        Menu.drawMenuBox(graphics, n3, n4 += n + 2, 240 - (n3 << 1), n2);
        this.font.print(graphics, this.game.strings[139], 120, n4 += 7, 17);
        this.font.print(graphics, this.game.strings[138], n3 += 9, n4 += n5 + 4, 20);
        this.font.print(graphics, this.game.questsCompleted + "/" + this.game.totalQuests, 240 - n3, n4, 24);
        this.font.print(graphics, this.game.strings[141], n3, n4 += n5, 20);
        this.font.print(graphics, this.game.bffCompleted + "/" + 16, 240 - n3, n4, 24);
        this.font.print(graphics, this.game.strings[136], n3, n4 += n5, 20);
        this.font.print(graphics, this.game.fishCaught + "/" + 10, 240 - n3, n4, 24);
        this.currentSim.render(graphics, 120, n4 += n5, 33);
        this.font.print(graphics, this.game.strings[137], n3, n4, 20);
        this.font.print(graphics, this.game.medalsWon + "/" + 6, 240 - n3, n4, 24);
        int n8 = (this.game.questsCompleted + this.game.bffCompleted + this.game.fishCaught + this.game.medalsWon) * 100 / (this.game.totalQuests + 16 + 10 + 6);
        this.font.print(graphics, this.game.strings[140] + n8 + "/100%", 120, n4 += n5 + 4, 17);
    }

    void renderTabs(Graphics graphics) {
        int n;
        this.drawTabsBg(graphics);
        this.drawTabs(graphics);
        switch (this.curTab) {
            case 0: {
                this.renderQuickMap(graphics);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int n2;
                int n3 = 0;
                if (this.curTab == 1) {
                    n3 = this.numTabItems;
                } else if (this.curTab == 3) {
                    n3 = this.numFish;
                } else if (this.curTab == 4) {
                    for (n = 0; n < this.game.activeQuests.size(); ++n) {
                        n2 = (Integer)this.game.activeQuests.elementAt(n);
                        if (this.game.quests[n2].helpString <= -1 || !this.game.quests[n2].helpActive) continue;
                        ++n3;
                    }
                } else if (this.curTab == 2) {
                    for (n = 0; n < this.game.npcs.length; ++n) {
                        if (this.game.npcs[n].locked || !this.game.npcs[n].active || DeviceConstants.FRIEND_FRAME[n] < 0) continue;
                        ++n3;
                    }
                }
                this.numTotalItems = n3;
                n = n3 * 42;
                int n4 = 40 - 42 * this.tabScrollY;
                n2 = 206;
                int n5 = 120 - (n2 >> 1);
                int n6 = n4 + 20 + 2;
                int n7 = this.tabEndY - 40;
                this.drawScrollBar(graphics, 216, 40, n7);
                graphics.setClip(10, 40, n2, n7);
                int n8 = 0;
                int n9 = 0;
                while (n8 < n3) {
                    int n10;
                    int n11 = n5 + 12;
                    graphics.setColor(0xFFA5A5);
                    graphics.drawLine(n11, n4, n11, n4 + n);
                    graphics.setColor(9756415);
                    graphics.drawLine(n5, n6 + 20, n5 + n2, n6 + 20);
                    if (this.curTab == 1) {
                        if (n9 < this.game.inventory.length && this.game.inventory[n9] > 0 && n9 >= 12) {
                            n10 = n9 - 12;
                            int n12 = this.game.inventory[n9];
                            if (DefaultConstants.ITEM_ICONS[n10] != -1) {
                                if (n10 == 11) {
                                    n10 = 50;
                                    n12 = this.game.tradeTable[11][0][1];
                                }
                                int n13 = 160 - (this.game.rewardItems.frameWidth >> 1);
                                int n14 = n13 + this.game.rewardItems.packedData[5][DefaultConstants.ITEM_ICONS[n9 - 12]] - (n11 += 8) - 2;
                                this.game.fontTinyBlack.print(graphics, this.game.fontTinyBlack.wrap(this.game.strings[this.game.itemNames[n10]], n14), n11, n6, 6);
                                this.game.rewardItems.render(graphics, n13 - 10, n6, DefaultConstants.ITEM_ICONS[n9 - 12], 0, 6);
                                this.game.fontTinyBlack.print(graphics, " x" + Integer.toString(n12), 216, n6, 10);
                                n6 += 42;
                                ++n8;
                            }
                        }
                    } else if (this.curTab == 2) {
                        if (!this.game.npcs[n9].locked && this.game.npcs[n9].active && DeviceConstants.FRIEND_FRAME[n9] >= 0) {
                            this.game.fontTinyBlack.print(graphics, this.game.strings[this.game.npcs[n9].name], n11 + 8, n6, 6);
                            n11 += 16 + this.game.fontTinyBlack.getStringWidth(this.game.strings[this.game.npcs[n9].name].toCharArray(), 0);
                            n11 = 105;
                            this.friendFaces.render(graphics, n11, n6, DeviceConstants.FRIEND_FRAME[n9], 0, 6);
                            this.drawFriendMeter(graphics, n9, n6);
                            graphics.setClip(10, 40, n2, this.tabEndY - 40);
                            n6 += 42;
                            ++n8;
                        }
                    } else if (this.curTab == 4) {
                        n10 = (Integer)this.game.activeQuests.elementAt(n9);
                        if (this.game.quests[n10].helpString > -1 && this.game.quests[n10].helpActive) {
                            this.game.fontTinyBlack.print(graphics, this.game.fontTiny.wrap(this.game.strings[this.game.quests[n10].helpString], 216 - (n11 += 8)), n11, n6, 6);
                            ++n8;
                            n6 += 42;
                        }
                    } else {
                        this.game.fontTinyBlack.print(graphics, this.game.fontTinyBlack.wrap(this.game.strings[79 + n9], 60), n11 + 8, n6, 6);
                        n11 = 120;
                        if (this.game.prefs.fish[n9][0] > 0) {
                            this.game.sprFishPrize.render(graphics, n11, n6, n9, 0, 6);
                            this.game.fontTinyBlack.print(graphics, "x" + Integer.toString(this.game.prefs.fish[n9][1]), 216, n6, 40);
                            this.game.fontTinyBlack.print(graphics, Integer.toString(this.game.prefs.fish[n9][0]) + this.game.strings[93], 216, n6, 24);
                        } else {
                            this.game.sprFishPrize.render(graphics, n11, n6, this.game.sprFishPrize.framesWide - 1, 0, 6);
                        }
                        ++n8;
                        n6 += 42;
                    }
                    ++n9;
                }
                break;
            }
        }
        if (this.bagHelpText >= 0) {
            graphics.setClip(0, 0, 240, 348);
            char[] cArray = this.game.fontTiny.wrap(this.game.strings[this.bagHelpText], 195);
            n = this.game.fontTiny.getStringHeight(cArray) + 10 + 4;
            Menu.drawMenuBox(graphics, 15, 348 - this.game.sprSoftkeys.frameHeight - n, 210, n);
            this.game.fontTiny.print(graphics, cArray, 120, 348 - this.game.sprSoftkeys.frameHeight - (n >> 1), 3);
        }
    }

    void drawTabsBg(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 348);
        int n = 20;
        int n2 = 0;
        graphics.setColor(14006670);
        graphics.fillRoundRect(n2, n, 240 - (n2 << 1), 348 - n, 10, 10);
        int n3 = 206;
        n2 = 120 - (n3 >> 1);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n2, 40, n3, 308 - this.game.sprSoftkeys.frameHeight);
    }

    void drawTabs(Graphics graphics) {
        int n = this.sprMenuTabs.frameWidth + 4;
        int n2 = 5 * n + 16;
        int n3 = 120 - (n2 >> 1);
        int n4 = 0;
        for (int i = 0; i < 5; ++i) {
            if (i == 4 && !this.game.hasNotebook) continue;
            graphics.setClip(n3, n4, n + 4, 20);
            graphics.setColor(i == this.curTab ? 14006670 : 8743230);
            graphics.fillRoundRect(n3 + 2, n4 + 2, n, 20, 6, 6);
            if (i == this.curTab) {
                graphics.fillRect(n3, n4 + 20 - 6, n + 4, 6);
                graphics.setColor(0);
                graphics.fillRoundRect(n3, n4, 2, 20, 10, 10);
                graphics.fillRoundRect(n3 + 2 + n, n4, 2, 20, 10, 10);
                graphics.setClip(0, 0, 240, 348);
            }
            if (!(this.curTab == 0 && this.mapIntro || this.bagHelpText != -1)) {
                this.sprMenuTabs.renderPointer(graphics, n3 + 2 + (n >> 1), n4 + 4, i, 0, 17, 5, i);
            } else {
                this.sprMenuTabs.render(graphics, n3 + 2 + (n >> 1), n4 + 4, i, 0, 17);
            }
            n3 += n + 4;
        }
        graphics.setClip(0, 0, 240, 348);
    }

    void drawFriendMeter(Graphics graphics, int n, int n2) {
        int n3 = 152;
        int n4 = 0;
        graphics.setColor(13484544);
        graphics.fillRoundRect(n3 + n4, n2 - 9 + n4, 64 - (n4 << 1), 18 - (n4 << 1), 10, 10);
        graphics.setColor(15594758);
        graphics.fillRoundRect(n3 + ++n4, n2 - 9 + n4, 64 - (n4 << 1), 18 - (n4 << 1), 10, 10);
        graphics.setColor(13484544);
        graphics.fillRoundRect(n3 + ++n4, n2 - 9 + n4, 64 - (n4 << 1), 18 - (n4 << 1), 10, 10);
        graphics.setColor(5378064);
        graphics.fillRoundRect(n3 + ++n4, n2 - 9 + n4, 64 - (n4 << 1), 18 - (n4 << 1), 10, 10);
        if (this.game.npcs[n].friendshipLevel > 0) {
            graphics.setColor(0xFF2332);
            int n5 = Math.min(3, this.game.npcs[n].friendshipLevel) * ((64 - (n4 << 1)) / 3);
            graphics.fillRoundRect(n3 + n4, n2 - 9 + n4, n5 += (64 - (n4 << 1)) % 3, 18 - (n4 << 1), 10, 10);
            graphics.setColor(16676736);
            graphics.fillRoundRect(n3 + n4 + 2, n2 - 9 + n4 + 2, n5 - 4, 9 - (n4 << 1), 10, 10);
        }
    }

    void drawScrollBar(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.numTotalItems - this.numItemsOnPage;
        if (n4 > 0) {
            int n5 = n3 - 4 - (this.sprTabArrows.frameHeight << 1);
            int n6 = n5 / (n4 + 1);
            int n7 = n5 - n6 * (n4 + 1);
            int n8 = n2 + 2 + this.sprTabArrows.frameHeight + (n7 >> 1);
            int n9 = n + 2;
            graphics.setColor(0xAAAAAA);
            graphics.fillRect(n9 + (this.sprTabArrows.frameWidth >> 1) - 1, n8, 2, n5 -= n7);
            Game.addPointer(n9 - 10, n8 - this.sprTabArrows.frameHeight - 10, this.sprTabArrows.frameWidth + 20, this.sprTabArrows.frameHeight + 30, -1);
            Game.addPointer(n9 - 10, n8 + n5 - 20, this.sprTabArrows.frameWidth + 20, this.sprTabArrows.frameHeight + 30, -2);
            graphics.setColor(15594758);
            graphics.fillRect(n9 + (this.sprTabArrows.frameWidth >> 1) - 4, n8 + n6 * this.tabScrollY, 8, n6);
            graphics.setColor(0);
            graphics.drawRect(n9 + (this.sprTabArrows.frameWidth >> 1) - 4, n8 + n6 * this.tabScrollY, 7, n6 - 1);
            if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 2) {
                this.sprTabArrows.render(graphics, n9, n8, 0, 1, 36);
            } else {
                this.sprTabArrows.render(graphics, n9, n8, 0, 0, 36);
            }
            if (this.keyPressTime > System.currentTimeMillis() && this.pressed == 4) {
                this.sprTabArrows.render(graphics, n9, n8 + n5, 1, 1, 20);
            } else {
                this.sprTabArrows.render(graphics, n9, n8 + n5, 1, 0, 20);
            }
        }
    }

    void setPreviousSimState() {
        this.prevBodyColor = this.currentSim.curBodyColor;
        this.prevFaceColor = this.currentSim.curFaceColor;
        this.prevHairColor = this.currentSim.curHairColor;
        this.prevShirtColor = this.currentSim.curShirtColor;
        this.prevPantColor = this.currentSim.curPantColor;
        this.prevShirtType = this.currentSim.curShirtType;
        this.prevPantType = this.currentSim.curPantType;
        this.prevFaceFrame = this.currentSim.faceFrame;
        this.prevHairFrame = this.currentSim.hairFrame;
        this.prevIsFemale = this.currentSim.isFemale;
        this.prevName = this.currentSim.name;
    }

    void restorePreviousSimState() {
        this.currentSim.curBodyColor = this.prevBodyColor;
        this.currentSim.curFaceColor = this.prevFaceColor;
        this.currentSim.curHairColor = this.prevHairColor;
        this.currentSim.curShirtColor = this.prevShirtColor;
        this.currentSim.curPantColor = this.prevPantColor;
        this.currentSim.curShirtType = this.prevShirtType;
        this.currentSim.curPantType = this.prevPantType;
        this.currentSim.faceFrame = this.prevFaceFrame;
        this.currentSim.hairFrame = this.prevHairFrame;
        this.currentSim.isFemale = this.prevIsFemale;
        this.currentSim.name = this.prevName;
    }

    void processTabs(int n) {
        long l = System.currentTimeMillis();
        this.game.softkeyL = -1;
        this.game.softkeyR = 2;
        this.tabEndY = 348 - this.game.sprSoftkeys.frameHeight;
        if (!(this.curTab == 0 && this.mapIntro || this.bagHelpText != -1)) {
            switch (n) {
                case 2: {
                    this.curTab = Math.max(0, this.curTab - 1);
                    this.numTotalItems = 0;
                    this.tabScrollY = 0;
                    break;
                }
                case 5: {
                    if (!this.game.hasNotebook && this.curTab == 3) {
                        return;
                    }
                    this.curTab = Math.min(4, this.curTab + 1);
                    this.numTotalItems = 0;
                    this.tabScrollY = 0;
                }
            }
        }
        if (this.curTab == 0) {
            this.processTravelScreen(n);
        } else {
            if ((this.game.key_held & 2) != 0 && this.tabScrollY > 0 && l > this.wait_time) {
                --this.tabScrollY;
                this.wait_time = l + 500L;
                this.pressed = 2;
                this.keyPressTime = l + 300L;
            }
            this.numItemsOnPage = this.tabEndY / 42 - 1;
            if ((this.game.key_held & 4) != 0 && this.tabScrollY < this.numTotalItems - this.numItemsOnPage && l > this.wait_time) {
                ++this.tabScrollY;
                this.wait_time = l + 500L;
                this.pressed = 4;
                this.keyPressTime = l + 300L;
            }
            if (n == -7 || this.bagHelpText >= 0 && this.game.key == 8) {
                this.bagHelpText = -1;
                this.game.softkeyL = 5;
                this.game.softkeyR = 6;
                this.game.state = 2;
                this.game.enterAdvState = 3;
            }
        }
    }

    void renderQuickMap(Graphics graphics) {
        boolean bl;
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        if (this.game.curMap == 114) {
            n3 = 0;
            n4 = 1;
        } else if (this.game.curMap == 318) {
            n3 = 1;
            n4 = 0;
        }
        for (n2 = 0; n2 < this.sprTravelMap.framesWide; ++n2) {
            this.sprTravelMap.render(graphics, 120, 174, n2, 0, 3);
        }
        n2 = this.game.fontTiny.getLineWidth(this.game.prefs.townName);
        int n5 = 120 - (n2 >> 1);
        int n6 = 6;
        if (n5 + n2 > 240 - this.game.sprSoftkeys.frameWidth) {
            n5 = 240 - this.game.sprSoftkeys.frameWidth;
            n6 = 10;
        }
        this.game.fontTiny.print(graphics, this.game.prefs.townName, n5, 348 - (this.game.sprSoftkeys.frameHeight >> 1), n6);
        for (n = 0; n < this.charIcons.framesWide; ++n) {
            if (this.game.npcs[DeviceConstants.MAP_CHAR_FRAMES[n] - 1].locked) continue;
            int n7 = 0;
            if (n == this.curTravelIcon) {
                n7 = 1;
            }
            if (!this.game.npcs[DeviceConstants.MAP_CHAR_FRAMES[n] - 1].active) {
                this.charIcons.render(graphics, 120, 174, n, n7, 3);
                continue;
            }
            this.charIcons.renderPointer(graphics, 120, 174, n, n7, 3, 6, n);
        }
        if (this.game.treasures_marked) {
            for (n = 0; n < this.game.townDigPoints.size(); ++n) {
                int n8;
                MovePoint movePoint = (MovePoint)this.game.townDigPoints.elementAt(n);
                bl = false;
                for (n8 = 0; n8 < this.game.placesDug.size(); ++n8) {
                    int[] nArray = (int[])this.game.placesDug.elementAt(n8);
                    if (318 != nArray[0] || movePoint.X != nArray[1] || movePoint.Y != nArray[2]) continue;
                    bl = true;
                }
                if (movePoint.action == 68 || bl) continue;
                graphics.setColor(0xFF0000);
                n8 = this.charIcons.packedData[2][0] >> 1;
                int n9 = this.sprTravelMap.packedData[5][1] + 120 - (this.sprTravelMap.frameWidth >> 1) - (n8 >> 1) + movePoint.X * this.sprTravelMap.packedData[2][1] / (this.game.forestTilesWide * 8);
                int n10 = this.sprTravelMap.packedData[4][1] + 174 - (this.sprTravelMap.frameHeight >> 1) - (n8 >> 1) + movePoint.Y * this.sprTravelMap.packedData[3][1] / (this.game.forestTilesTall * 8);
                graphics.drawLine(n9 - (n8 >> 1), n10 - (n8 >> 1), n9 + (n8 >> 1), n10 + (n8 >> 1));
                graphics.drawLine(n9 - (n8 >> 1) - 1, n10 - (n8 >> 1), n9 + (n8 >> 1) - 1, n10 + (n8 >> 1));
                graphics.drawLine(n9 - (n8 >> 1) - 2, n10 - (n8 >> 1), n9 + (n8 >> 1) - 2, n10 + (n8 >> 1));
                graphics.drawLine(n9 + (n8 >> 1), n10 - (n8 >> 1), n9 - (n8 >> 1), n10 + (n8 >> 1));
                graphics.drawLine(n9 + (n8 >> 1) - 1, n10 - (n8 >> 1), n9 - (n8 >> 1) - 1, n10 + (n8 >> 1));
                graphics.drawLine(n9 + (n8 >> 1) - 2, n10 - (n8 >> 1), n9 - (n8 >> 1) - 2, n10 + (n8 >> 1));
            }
        }
        n = 0;
        int n11 = 0;
        bl = false;
        if (this.game.curMap == 114 || this.game.curMap == 318) {
            bl = true;
            n = this.sprTravelMap.packedData[5][n3] + (this.game.playerSim.position.x >> 8) * this.sprTravelMap.packedData[2][n3] / (this.game.tilesWide * 8);
            n11 = this.sprTravelMap.packedData[4][n3] + (this.game.playerSim.position.y >> 8) * this.sprTravelMap.packedData[3][n3] / (this.game.tilesTall * 8);
        }
        if (bl) {
            this.sprDiamond.render(graphics, 120 - (this.sprTravelMap.frameWidth >> 1) + n, 174 - (this.sprTravelMap.frameHeight >> 1) + n11, this.sprDiamond.frame, 0, 33);
        }
    }

    void drawPedestal(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n5 - (n4 >> 1);
        graphics.setColor(n7);
        graphics.fillArc(n - (n3 >> 1), n2 + n8, n3, n4, 0, 360);
        graphics.fillRect(n - (n3 >> 1), n2 + (n8 -= n5 - (n4 >> 1)), n3, n5);
        graphics.setColor(n6);
        graphics.fillArc(n - (n3 >> 1), n2 + (n8 -= n4 >> 1), n3, n4, 0, 360);
    }

    void drawItemButton(Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
        if (bl2) {
            this.sprItemButton.render(graphics, n, n2, this.sprItemButton.frame, 0, 3);
        } else if (bl) {
            this.sprItemButton.render(graphics, n, n2, 1, 0, 3);
        } else {
            this.sprItemButton.render(graphics, n, n2, 0, 0, 3);
        }
    }
}

