/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sushi
implements Constants {
    public static final int SUSHI_BUTTON_ON = 0;
    public static final int SUSHI_BUTTON_OFF = 1;
    public static final int NUM_SUSHI_BUTTONS = 2;
    public static final int SUSHI_TYPE = 0;
    public static final int SUSHI_STATE = 1;
    public static final int SUSHI_X_POS = 2;
    public static final int NUM_SUSHI_ITEMS = 3;
    public static final int ORANGE_FISH = 0;
    public static final int RED_FISH = 1;
    public static final int CRUSTATION = 2;
    public static final int ROLLS = 3;
    public static final int TYPE_WRONG = 4;
    public static final int NUM_SUSHI_TYPES = 4;
    public static final int SUSHI_STATE_UNPREPARED = 0;
    public static final int SUSHI_STATE_PREPARED_CORRECT = 1;
    public static final int SUSHI_STATE_PREPARED_WRONG = 2;
    public static final int SUSHI_STATE_DONE = 3;
    public static final int SUSHI_STATE_WRONG = 4;
    public static final int STATE_INTRO = 0;
    public static final int STATE_STOP = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_GO = 3;
    public static final int STATE_LEVEL_TEXT = 4;
    public static final int STATE_GAME = 5;
    public static final int STATE_RESULTS = 6;
    public static final int SUSHI_REGULAR_POINT = 100;
    public static final int SUSHI_BONUS_POINTS = 100;
    public static final int SUSHI_BONUS_FREQUENCY = 5;
    public static final int BONUS_COIN_TIME = 1500;
    public Game game;
    public int spacing;
    public int[][] items;
    public int[] randTypes;
    public Image imgIntro;
    public Image imgBgTop;
    public Image imgBgBottom;
    public Image imgGrooves;
    public Image imgCounter;
    public Image imgMarkers;
    public Image imgMenu;
    public Image imgArrowUpDown;
    public Image imgTimer;
    public Image imgCounterFill;
    public Image imgDPad;
    public PackedSprite[] button;
    public PackedSprite coin;
    public PackedSprite food;
    public PackedSprite poof;
    public Animation player;
    public Animation playerEyes;
    public Animation playerHair;
    public Animation sushiShirt;
    public Position sticksLeftPos;
    public Position sticksRightPos;
    public Position itemPos;
    public Position conveyerPos;
    public Position coinPos;
    public GraphicFont timeNumbers;
    public long now;
    public long last_tick;
    public long time;
    public long bonusTime;
    public int numCorrect;
    public int numWrong;
    public int correctNeeded;
    public int level;
    public int numOnScreen;
    public int curOffScreen;
    public int numPerLevel;
    public int score;
    public int speed;
    public int state;
    public boolean bonus;
    public boolean newItemOnScreen;

    public Sushi(Game game) {
        this.game = game;
    }

    public void loadRes() {
        this.game.defaultFont = new GraphicFont(115, 115, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz?\u00bf.\u00c0\u00c1\u00c4\u00c8\u00c9\u00ca\u00d3\u00d6\u00dc\u00df\u00e0\u00e1\u00e4\u00e7\u00e8\u00e9\u00ea\u00ec\u00ed\u00ee\u00f1\u00f2\u00f3\u00f4\u00f6\u00f9\u00fa\u00fb\u00fc0123456789%/':", -1);
        this.player = new Animation(122, 128, this.game.findPalette(68 + this.game.playerSim.curBodyColor));
        this.playerEyes = new Animation(126 + (!this.game.playerSim.isFemale ? this.game.playerSim.faceFrame + 4 : this.game.playerSim.faceFrame), 132 + (!this.game.playerSim.isFemale ? this.game.playerSim.faceFrame + 4 : this.game.playerSim.faceFrame), this.game.findPalette(40 + this.game.playerSim.curFaceColor));
        this.playerHair = new Animation(134 + (!this.game.playerSim.isFemale ? this.game.playerSim.hairFrame + 4 : this.game.playerSim.hairFrame), 140 + (!this.game.playerSim.isFemale ? this.game.playerSim.hairFrame + 4 : this.game.playerSim.hairFrame), this.game.findPalette(48 + this.game.playerSim.curHairColor));
        this.player.setAnim(10);
        this.player.frame = this.player.defaultFrame;
        this.player.speed = 100;
        this.player.loop = 1;
        this.sushiShirt = new Animation(199, 180);
        this.imgBgTop = Game.createImage(192);
        this.imgBgBottom = Game.createImage(191);
        this.imgGrooves = Game.createImage(190);
        this.imgCounter = Game.createImage(193);
        this.imgMarkers = Game.createImage(194);
        this.imgMenu = Game.createImage(195);
        this.imgArrowUpDown = Game.createImage(250);
        this.imgTimer = Game.createImage(196);
        this.imgCounterFill = Game.createImage(202);
        this.imgDPad = Game.createImage(324);
        this.game.sprStopLight = new PackedSprite(258, 235);
        this.food = new PackedSprite(206, 185);
        this.food.startFrame = 0;
        this.food.speed = 250;
        this.poof = new PackedSprite(198, 179);
        this.poof.speed = 150;
        this.poof.loop = 4;
        this.poof.disappear = true;
        this.poof.numTimes = 1;
        this.coin = new PackedSprite(197, 178);
        this.coin.speed = 150;
        this.coin.loop = 2;
        this.coinPos = new Position(0, this.imgBgTop.getHeight() - 7 * this.player.frameHeight / 10 << 8);
        this.timeNumbers = new GraphicFont(201, 182, "abcdefghijklmnopqrstuvwxyz1234567890/=:.", 1);
        this.spacing = this.food.frameWidth + (this.imgMarkers.getWidth() << 1);
        this.sticksRightPos = new Position(160 + (this.food.frameWidth >> 1), 0);
        this.conveyerPos = new Position(0, 0);
        this.conveyerPos.moveTo(this.imgGrooves.getWidth(), 0, 0, 300);
        this.level = 0;
        this.reset();
        this.state = 0;
        this.imgIntro = Game.createImage(289);
    }

    public void reset() {
        int n;
        this.randTypes = new int[4];
        for (n = 0; n < 4; ++n) {
            this.randTypes[n] = n;
        }
        for (n = 0; n < 4; ++n) {
            int n2 = this.randTypes[n];
            int n3 = Math.abs(this.game.rand.nextInt() % 4);
            this.randTypes[n] = this.randTypes[n3];
            this.randTypes[n3] = n2;
        }
        this.curOffScreen = 0;
        this.numPerLevel = DefaultConstants.SUSHI_LEVELS[Math.min(this.level, 4)][0];
        this.correctNeeded = DefaultConstants.SUSHI_LEVELS[Math.min(this.level, 4)][1];
        this.speed = this.level >= 5 ? this.speed * 125 / 100 : DefaultConstants.SUSHI_LEVELS[this.level][2];
        this.items = new int[this.numPerLevel][];
        for (n = 0; n < this.items.length; ++n) {
            this.items[n] = new int[3];
            this.items[n][0] = Math.abs(this.game.rand.nextInt() % DefaultConstants.SUSHI_LEVELS[Math.min(this.level, 4)][3]);
            this.items[n][1] = 0;
            this.items[n][2] = -this.food.frameWidth - n * this.spacing;
        }
        this.sticksLeftPos = new Position(40960, 0);
        this.itemPos = new Position(0, 0);
        this.itemPos.moveTo(this.spacing, 0, 0, this.speed);
        this.numCorrect = 0;
        this.bonus = false;
        this.newItemOnScreen = false;
        this.state = 4;
    }

    public void process(int n, long l) {
        if (this.last_tick > 0L) {
            this.now += l - this.last_tick;
        }
        this.last_tick = l;
        switch (this.state) {
            case 0: {
                if (n != 8) break;
                this.state = 4;
                break;
            }
            case 4: {
                if (n != 8) break;
                this.time = this.now + 1000L;
                this.state = 1;
                break;
            }
            case 1: {
                if (this.now <= this.time) break;
                this.state = 2;
                this.time = this.now + 1000L;
                break;
            }
            case 2: {
                if (this.now <= this.time) break;
                this.state = 3;
                this.time = this.now + 500L;
                break;
            }
            case 3: {
                if (this.now <= this.time) break;
                this.state = 5;
                this.time = this.now;
                break;
            }
            case 5: {
                int n2;
                this.sticksLeftPos.tick();
                this.poof.nextFrame(this.now);
                this.coin.nextFrame(this.now);
                if (!this.bonus && this.numCorrect > 0 && this.numCorrect % 5 == 0) {
                    this.bonus = true;
                    this.sticksLeftPos.moveTo((this.sticksLeftPos.x >> 8) + (this.food.frameWidth >> 2), 0, 0, 500);
                } else if (this.bonus && this.numCorrect % 5 != 0) {
                    this.bonus = false;
                    this.sticksLeftPos.moveTo(160, 0, 0, 500);
                }
                this.conveyerPos.tick();
                this.itemPos.tick();
                this.food.nextFrame(this.now);
                this.player.nextFrame(this.now);
                this.coinPos.tick();
                if (!this.conveyerPos.moving) {
                    this.conveyerPos = new Position(0, 0);
                    this.conveyerPos.moveTo(this.imgGrooves.getWidth(), 0, 0, this.speed);
                }
                if (!this.itemPos.moving) {
                    this.itemPos = new Position(0, 0);
                    this.itemPos.moveTo(this.spacing, 0, 0, this.speed);
                    for (n2 = 0; n2 < this.items.length; ++n2) {
                        int[] nArray = this.items[n2];
                        nArray[2] = nArray[2] + this.spacing;
                    }
                }
                for (n2 = 0; n2 < this.items.length; ++n2) {
                    int n3 = -1;
                    switch (n) {
                        case 2: {
                            n3 = 1;
                            break;
                        }
                        case 5: {
                            n3 = 0;
                            break;
                        }
                        case 1: {
                            n3 = 2;
                            break;
                        }
                        case 6: {
                            n3 = 3;
                        }
                    }
                    if (n3 >= DefaultConstants.SUSHI_LEVELS[Math.min(this.level, 4)][3]) {
                        n3 = -1;
                    }
                    if (n3 != -1 && this.items[n2][2] + (this.itemPos.x >> 8) + this.food.packedData[5][0] + this.food.packedData[2][0] >= this.sticksLeftPos.x >> 8 && this.items[n2][2] + (this.itemPos.x >> 8) + this.food.packedData[5][0] <= this.sticksRightPos.x && this.items[n2][1] == 0 && this.numCorrect < this.correctNeeded) {
                        this.player.setAnim(10);
                        this.poof.frame = 0;
                        this.poof.disappear = false;
                        if (this.randTypes[this.items[n2][0]] == this.randTypes[n3]) {
                            this.items[n2][1] = 1;
                            this.food.loop = 1;
                            this.food.setFraming(3, 5);
                            this.food.frame = 3;
                            ++this.numCorrect;
                            this.score += 100;
                            if (this.bonus) {
                                this.score += 100;
                                this.bonusTime = this.now + 1500L;
                                this.coinPos = new Position(0, this.imgBgTop.getHeight() - 7 * this.player.frameHeight / 10 << 8);
                                this.coinPos.moveTo(0, -this.coin.frameHeight, 0, 700);
                            }
                        } else {
                            this.food.loop = 1;
                            this.food.setFraming(3, 5);
                            this.food.frame = 3;
                            this.items[n2][1] = 2;
                            ++this.numWrong;
                            this.score = Math.max(0, this.score - 10);
                        }
                    }
                    if (this.curOffScreen == n2 && this.items[n2][2] + (this.itemPos.x >> 8) + this.food.frameWidth > 0) {
                        ++this.curOffScreen;
                        this.newItemOnScreen = true;
                    }
                    if (n2 == this.numPerLevel - 1 && this.items[n2][2] + (this.itemPos.x >> 8) > 240 && this.numCorrect < this.correctNeeded) {
                        this.state = 6;
                        this.game.setResultScreen(1, this.score);
                    }
                    if (this.items[n2][1] == 1 && this.food.frame == 5) {
                        this.items[n2][1] = 3;
                    } else if (this.items[n2][1] == 2 && this.food.frame == 5) {
                        this.items[n2][1] = 4;
                    }
                    if (this.items[n2][2] + (this.itemPos.x >> 8) <= this.sticksRightPos.x || this.items[n2][1] != 0) continue;
                    this.items[n2][1] = 4;
                    ++this.numWrong;
                    this.score = Math.max(0, this.score - 10);
                }
                if (this.numCorrect < this.correctNeeded || this.player.frame != this.player.endFrame) break;
                ++this.level;
                this.reset();
                break;
            }
            case 6: {
                switch (n) {
                    case 8: {
                        this.game.state = this.game.isMini ? 4 : 2;
                    }
                }
            }
        }
    }

    public void render(Graphics graphics) {
        int n;
        for (int i = 0; i < 240; i += this.imgBgTop.getWidth()) {
            graphics.drawImage(this.imgBgTop, i, 0, 20);
        }
        this.player.render(graphics, this.sticksRightPos.x - (this.food.frameWidth >> 2), this.imgBgTop.getHeight() - 7 * this.player.frameHeight / 10, this.player.frame, this.player.animation, 17);
        this.playerEyes.render(graphics, this.sticksRightPos.x - (this.food.frameWidth >> 2), this.imgBgTop.getHeight() - 7 * this.player.frameHeight / 10, 0, 1, 17);
        this.playerHair.render(graphics, this.sticksRightPos.x - (this.food.frameWidth >> 2), this.imgBgTop.getHeight() - 7 * this.player.frameHeight / 10, 0, 1, 17);
        this.sushiShirt.render(graphics, this.sticksRightPos.x - (this.food.frameWidth >> 2), this.imgBgTop.getHeight() - 7 * this.player.frameHeight / 10, this.player.frame, 0, 17);
        Game.drawSplitImage(graphics, this.imgBgBottom, 0, 348, 36);
        if (this.bonusTime > this.now) {
            this.coin.render(graphics, this.sticksRightPos.x - (this.food.frameWidth >> 2), this.coinPos.y >> 8, this.coin.frame, 0, 3);
        }
        graphics.drawImage(this.imgTimer, 0, 5, 20);
        this.timeNumbers.print(graphics, this.game.strings[48] + Integer.toString(this.level + 1), this.imgTimer.getWidth() >> 1, 5 + (this.imgTimer.getHeight() >> 1), 3);
        graphics.drawImage(this.imgTimer, 240, 5, 24);
        this.timeNumbers.print(graphics, this.game.strings[49] + this.game.formatScore(this.score), 240 - (this.imgTimer.getWidth() >> 1), 5 + (this.imgTimer.getHeight() >> 1), 3);
        graphics.drawImage(this.imgCounter, 0, 348, 36);
        graphics.setClip(0, 348 - this.imgCounter.getHeight(), this.curOffScreen * this.imgCounterFill.getWidth() / this.numPerLevel, this.imgCounter.getHeight());
        graphics.drawImage(this.imgCounterFill, 0, 348, 36);
        graphics.setClip(0, 0, 240, 348);
        this.timeNumbers.print(graphics, Integer.toString(this.numCorrect) + "/" + Integer.toString(this.correctNeeded), this.imgCounterFill.getWidth() + 2, 348 - (this.imgCounter.getHeight() >> 1), 6);
        int n2 = 0;
        int n3 = (this.imgBgTop.getHeight() >> 1) - (this.imgMenu.getHeight() >> 1);
        Game.drawSplitImage(graphics, this.imgMenu, n2, n3, 20);
        int n4 = DefaultConstants.SUSHI_LEVELS[Math.min(this.level, 4)][3];
        if (DefaultConstants.SUSHI_LEVELS[Math.min(this.level, 4)][3] >= 3) {
            n = n4 > 3 ? this.imgArrowUpDown.getWidth() : this.imgArrowUpDown.getWidth() >> 1;
            graphics.drawRegion(this.imgArrowUpDown, 0, 0, n, this.imgArrowUpDown.getHeight(), 0, n2, n3 + this.imgMenu.getHeight(), 36);
        }
        for (n = 0; n < n4; ++n) {
            this.food.render(graphics, n2 + DeviceConstants.SUSHI_OFFSET[n << 1], n3 + DeviceConstants.SUSHI_OFFSET[(n << 1) + 1], 0, this.randTypes[n], 33);
        }
        for (n = -this.imgGrooves.getWidth(); n < 348; n += this.imgGrooves.getWidth()) {
            graphics.drawImage(this.imgGrooves, n + (this.conveyerPos.x >> 8), this.imgBgTop.getHeight(), 20);
        }
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n][1] == 0) {
                this.food.render(graphics, this.items[n][2] + (this.itemPos.x >> 8), this.imgBgTop.getHeight() + this.imgGrooves.getHeight(), 0, this.randTypes[this.items[n][0]], 36);
                continue;
            }
            if (this.items[n][1] == 1) {
                this.food.render(graphics, this.items[n][2] + (this.itemPos.x >> 8), this.imgBgTop.getHeight() + this.imgGrooves.getHeight(), this.food.frame, this.randTypes[this.items[n][0]], 36);
                continue;
            }
            if (this.items[n][1] == 2) {
                this.food.render(graphics, this.items[n][2] + (this.itemPos.x >> 8), this.imgBgTop.getHeight() + this.imgGrooves.getHeight(), this.food.frame, 4, 36);
                continue;
            }
            if (this.items[n][1] == 3) {
                this.food.render(graphics, this.items[n][2] + (this.itemPos.x >> 8), this.imgBgTop.getHeight() + this.imgGrooves.getHeight(), 5, this.randTypes[this.items[n][0]], 36);
                continue;
            }
            if (this.items[n][1] != 4) continue;
            this.food.render(graphics, this.items[n][2] + (this.itemPos.x >> 8), this.imgBgTop.getHeight() + this.imgGrooves.getHeight(), 5, 4, 36);
        }
        this.poof.render(graphics, this.sticksRightPos.x - (this.food.frameWidth >> 1), this.imgBgTop.getHeight(), this.poof.frame, 0, 3);
        graphics.drawImage(this.imgMarkers, this.sticksLeftPos.x >> 8, this.imgBgTop.getHeight(), 17);
        graphics.drawImage(this.imgMarkers, this.sticksRightPos.x, this.imgBgTop.getHeight(), 17);
        if (this.state <= 3) {
            this.game.drawStoplight(graphics, this.state);
        }
        switch (this.state) {
            case 0: {
                this.drawIntroScreen(graphics);
                break;
            }
            case 4: {
                graphics.setColor(0);
                graphics.fillRect(60, 174 - this.timeNumbers.height, 120, this.timeNumbers.height << 1);
                graphics.setColor(9069416);
                graphics.fillRect(61, 174 - this.timeNumbers.height + 1, 118, (this.timeNumbers.height << 1) - 2);
                this.timeNumbers.print(graphics, this.game.strings[48] + Integer.toString(this.level + 1), 120, 174, 3);
                Game.addPointer(0, 0, 240, 348, -5);
                break;
            }
            case 6: {
                this.game.renderResultScreen(graphics, 1, this.score);
            }
        }
        if (this.state != 0 && this.state != 6 && this.state != 4) {
            n = n2;
            int n5 = n3;
            int n6 = this.imgMenu.getWidth() >> 1;
            int n7 = this.imgMenu.getHeight() >> 1;
            Game.addPointer(n + 2, n5 + 2, n6 - 4, n7 - 4, -3);
            Game.addPointer(n + n6 + 4, n5 + 2, n6 - 4, n7 - 4, -4);
            Game.addPointer(n + 2, n5 + n7 + 4, n6 - 4, n7 - 4, -1);
            Game.addPointer(n + n6 + 4, n5 + n7 + 4, n6 - 4, n7 - 4, -2);
            n = 240 - this.imgDPad.getWidth() >> 1;
            n5 = 348 - this.imgDPad.getHeight() - 4;
            graphics.drawImage(this.imgDPad, n, n5, 20);
            Game.addPointer(n + 24, n5, 24, 24, -1);
            Game.addPointer(n, n5 + 24, 24, 24, -3);
            Game.addPointer(n + 48, n5 + 24, 24, 24, -4);
            Game.addPointer(n + 24, n5 + 48, 24, 24, -2);
        }
    }

    void drawIntroScreen(Graphics graphics) {
        char[] cArray = this.game.fontTiny.wrap(this.game.strings[95], 222);
        int n = this.imgIntro.getWidth() + 10 + 8;
        int n2 = this.imgIntro.getHeight() + this.game.defaultFont.height + 10 + 8;
        int n3 = 120 - (n >> 1);
        int n4 = 174 - (n2 >> 1);
        Menu.drawMenuBox(graphics, n3, n4, n, n2);
        Game.addPointer(0, 0, 240, 348, -5);
        graphics.drawImage(this.imgIntro, n3 + (n >> 1), n4 + this.game.defaultFont.height + 5 + 4, 17);
        this.game.defaultFont.print(graphics, this.game.strings[32], n3 + (n >> 1), n4 + 2 + 5, 17);
    }
}

