/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Paragliding
implements Constants {
    public static final int DIAMOND_BLUE = 0;
    public static final int DIAMOND_PINK = 1;
    public static final int DIAMOND_RED = 2;
    public static final int BIRD = 3;
    public static final int BIRD_SMART = 4;
    public static final int POP = 5;
    public static final int NUM_OBJECTS = 6;
    public static final int STATE_INTRO = 0;
    public static final int STATE_STOP = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_GO = 3;
    public static final int STATE_PLAYING = 4;
    public static final int STATE_CRASH = 5;
    public static final int STATE_RESULTS = 6;
    public static final int NUM_DIAMOND_COLORS = 3;
    public static final int PARAGLIDING_SPEED = 25;
    public static final int PARAGLIDING_GRAVITY = 24;
    public static final int PARAGLIDING_MAX_VELOCITY = 400;
    public static final int PARAGLIDING_UPDRAFT = 20;
    public static final int PARAGLIDING_DOWNDRAFT = 160;
    public static final int PARAGLIDING_DIAMOND_PTS = 200;
    public static final int DIAMOND_SPAWN_MIN = 6;
    public static final int DIAMOND_SPAWN_MAX = 10;
    public static final int SCROLL_SPEED_MIN = 3000;
    public static final int SCROLL_SPEED_MAX = 7000;
    public static final int SCROLL_SPEED_NORMAL = 5000;
    public static final int SCROLL_SPEED_INC = 200;
    public static final int CLOUD_SPEED = 120;
    public static final int CLOUD_PARALLAX = 225;
    public static final int FOREGROUND_SPEED = 300;
    public static final int BACKGROUND_SPEED = 75;
    public static final int BIRD_SCROLL_SPEED = 300;
    public static final int DIAMOND_SPEED = 300;
    public static final int PRECISION = 10;
    public static final int PTS_PER_METER = 10;
    public static final int SEC_PER_M = 3000;
    public static final int BIRD_HOMING_AMT = 1240;
    public static final int BIRD_HOMING_SPEED = 1080;
    public static final int BIRD_SPEED = 750;
    public static final int BIRD_SPAWN = 5000;
    public static final int BIRD_FREQUENCY = 20000;
    public static final int BIRD_INC = 500;
    public static final int BIRD_MIN = 1000;
    public static final int DIRECTION_RIGHT = 0;
    public static final int DIRECTION_LEFT = 1;
    public Game game;
    public Animation player;
    public PackedSprite sprButton;
    public Image imgIntro;
    public Image imgPop;
    public Image imgBirdPop;
    public Image imgScore;
    public Image imgMeters;
    public Image imgTime;
    public Image imgForeground;
    public Image imgBackground;
    public Image imgBird;
    public Image imgPigeon;
    public Image imgPigeonPop;
    public Image[] imgCloud;
    public Image[] imgDiamond;
    public Image imgDPad;
    public GraphicFont font;
    public Vector objects;
    public Vector clouds;
    public Random rand;
    public Position diamondSpawn;
    public Position foreground;
    public Position background;
    public int playarea_h;
    public int offset_y;
    public int distance;
    public int meters;
    public int cm;
    public int combo;
    public int score;
    public int distanceScore;
    public int state;
    public int last_y;
    public int warning;
    public int num_hits;
    public int scroll_speed;
    public int acceleration_up;
    public int acceleration_down;
    public int scrollDirection;
    public long spin_time;
    public long wait_time;
    public long spawn_time;
    public long update_time;
    public long anim_time;
    public long bird_spawn;
    public long game_time;
    public long bird_time;
    public long start_time;
    public long last_tick;
    public boolean direction;

    public Paragliding(Game game, int n) {
        this.game = game;
        this.scrollDirection = n;
    }

    public void init() {
        this.objects = new Vector();
        this.clouds = new Vector();
        this.rand = new Random(System.currentTimeMillis());
        this.playarea_h = 522;
        this.clouds.removeAllElements();
        for (int i = 3; i >= 0; --i) {
            int n = Math.max(i, 2);
            for (int j = 0; j < n; ++j) {
                int n2 = i % 4;
                int n3 = 240 * j / n;
                int n4 = Math.abs(this.rand.nextInt() >>> 1) % 4;
                int n5 = this.playarea_h / 5 + this.playarea_h * n4 / 6;
                Position position = new Position(this.itofx(n3), this.itofx(n5));
                position.param1 = n2;
                position.moveTo(240, n5, 0, 120 + (4 - n2) * 225);
                this.clouds.addElement(position);
            }
        }
        this.player.timer = -1L;
        this.player.position = new Position(this.itofx(180), this.itofx(174));
        this.player.loop = 2;
        this.player.setAnim(0);
        this.state = 0;
        this.game_time = 0L;
        this.bird_time = 0L;
        this.last_tick = -1L;
        this.spawn_time = -1L;
        this.spin_time = -1L;
        this.bird_spawn = 3000L;
        this.scroll_speed = 5000;
        this.acceleration_up = 1;
        this.acceleration_down = 1;
        this.distance = 0;
        this.score = 0;
        this.distanceScore = 0;
        this.combo = 0;
        this.num_hits = 0;
        this.warning = 3;
        this.sprButton.loop = 0;
        this.foreground = new Position(this.itofx(-this.imgForeground.getWidth() * 4), 0);
        this.foreground.moveTo(0, 0, 0, 300);
        this.background = new Position(this.itofx(-this.imgBackground.getWidth()), 0);
        this.background.moveTo(240, 0, 0, 75);
        this.diamondSpawn = new Position(0, this.itofx(174));
    }

    public int itofx(int n) {
        return n << 8;
    }

    public int fxtoi(int n) {
        return n >> 8;
    }

    public void loadRes() {
        int n;
        this.player = this.scrollDirection == 0 ? new Animation(215, 194) : new Animation(300, 263);
        this.game.defaultFont = new GraphicFont(115, 115, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz?\u00bf.\u00c0\u00c1\u00c4\u00c8\u00c9\u00ca\u00d3\u00d6\u00dc\u00df\u00e0\u00e1\u00e4\u00e7\u00e8\u00e9\u00ea\u00ec\u00ed\u00ee\u00f1\u00f2\u00f3\u00f4\u00f6\u00f9\u00fa\u00fb\u00fc0123456789%/':", -1);
        this.player.speed = 250;
        this.font = new GraphicFont(201, 182, "abcdefghijklmnopqrstuvwxyz1234567890/=:.", 1);
        this.imgDiamond = new Image[3];
        this.imgDiamond[0] = Game.createImage(216);
        for (n = 0; n < 2; ++n) {
            this.imgDiamond[n + 1] = Game.createImage(216, this.game.findPalette(106 + n));
        }
        this.imgCloud = new Image[4];
        for (n = 0; n < 4; ++n) {
            this.imgCloud[n] = Game.createImage(217 + n);
        }
        this.sprButton = new PackedSprite(257, 234);
        this.sprButton.speed = 100;
        this.imgPop = Game.createImage(224);
        this.imgDPad = Game.createImage(322);
        this.imgBird = this.scrollDirection == 0 ? Game.createImage(223) : Game.createImage(301);
        this.imgBirdPop = Game.createImage(282);
        this.imgPigeon = this.scrollDirection == 0 ? Game.createImage(223, this.game.findPalette(141)) : Game.createImage(301, this.game.findPalette(141));
        this.imgPigeonPop = Game.createImage(282, this.game.findPalette(141));
        this.game.sprStopLight = new PackedSprite(258, 235);
        this.imgScore = Game.createImage(230);
        this.imgMeters = Game.createImage(239);
        this.imgTime = Game.createImage(229);
        this.imgForeground = Game.createImage(221);
        this.imgBackground = Game.createImage(222);
        this.imgIntro = Game.createImage(285);
    }

    public void createDiamond(int n) {
        PackedSprite packedSprite = new PackedSprite(this.imgDiamond[n], 195);
        packedSprite.speed = 200;
        packedSprite.type = n;
        int n2 = -packedSprite.frameWidth;
        int n3 = (this.rand.nextInt() >>> 1) % 16;
        int n4 = this.diamondSpawn.y;
        int n5 = 58;
        if (n3 > 3) {
            int n6 = Math.abs(this.rand.nextInt() % 100);
            this.diamondSpawn.y += (this.itofx(this.playarea_h - n5) - this.player.position.y >> 1) * n6 / 100;
        }
        n4 = Math.min(n4, this.itofx(this.playarea_h - n5));
        n4 = Math.max(n4, this.itofx(n5));
        packedSprite.position = new Position(this.itofx(n2), n4);
        packedSprite.position.moveTo(240 + packedSprite.frameWidth, this.fxtoi(n4), 0, 300);
        this.objects.addElement(packedSprite);
    }

    public void createBird(int n, int n2) {
        int n3 = 750;
        int n4 = 3;
        int n5 = Math.abs(this.rand.nextInt() % 100);
        if ((long)n5 <= this.bird_time * 5L / 10000L) {
            n4 = 4;
            n3 = 1080;
        }
        Image image = this.imgBird;
        if (n4 == 4) {
            image = this.imgPigeon;
        }
        int n6 = 196;
        if (this.scrollDirection != 0) {
            n6 = 264;
        }
        PackedSprite packedSprite = new PackedSprite(image, n6);
        packedSprite.speed = 300;
        packedSprite.type = n4;
        int n7 = -packedSprite.frameWidth;
        n5 = (this.rand.nextInt() >>> 1) % 6;
        int n8 = n + n2 / 6 * n5;
        n5 = Math.abs(this.rand.nextInt() % 100);
        if (n5 <= 25) {
            n8 = this.fxtoi(this.player.position.y);
        }
        int n9 = 58;
        n8 = Math.min(n8, this.playarea_h - n9);
        n8 = Math.max(n8, n9);
        n5 = (this.rand.nextInt() >>> 1) % 5;
        int n10 = packedSprite.frameHeight + this.playarea_h / 5 * n5;
        n10 = Math.min(n10, this.playarea_h - n9);
        n10 = Math.max(n10, n9);
        packedSprite.position = new Position(this.itofx(n7), this.itofx(n8));
        packedSprite.position.moveTo(240 + packedSprite.frameWidth, n10, 0, n3);
        this.objects.addElement(packedSprite);
    }

    public void process(int n, int n2, long l) {
        int n3;
        int n4;
        Object object;
        if (this.last_tick > 0L) {
            this.game_time += l - this.last_tick;
            if (this.state >= 4) {
                this.bird_time += l - this.last_tick;
            }
        }
        switch (this.state) {
            case 0: {
                if (n != 8) break;
                this.state = 1;
                this.wait_time = this.game_time + 1000L;
                break;
            }
            case 1: {
                if (this.game_time <= this.wait_time) break;
                this.wait_time = this.game_time + 1000L;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.game_time > this.wait_time) {
                    this.wait_time = this.game_time + 500L;
                    this.state = 3;
                }
            }
            case 3: {
                if (this.game_time <= this.wait_time) break;
                this.start_time = this.game_time;
                this.state = 4;
                break;
            }
            case 4: {
                int n5;
                if (this.game_time > this.anim_time) {
                    if (this.spin_time < 0L) {
                        if ((n2 & 2) != 0) {
                            this.acceleration_up = Math.min(this.acceleration_up + Math.max(this.acceleration_up / 4, 1), 200);
                            this.scroll_speed = Math.max(this.scroll_speed - this.acceleration_up, 3000);
                            this.player.position.dy = Math.max(this.player.position.dy -= 44, -400);
                        } else {
                            this.acceleration_up = 1;
                        }
                        if ((n2 & 4) != 0) {
                            this.acceleration_down = Math.min(this.acceleration_down + Math.max(this.acceleration_down / 4, 1), 200);
                            this.scroll_speed = Math.min(this.scroll_speed + this.acceleration_down, 7000);
                            this.player.position.dy = Math.min(this.player.position.dy += 184, 800);
                        } else {
                            this.acceleration_down = 1;
                        }
                        if ((n2 & 8) != 0) {
                            // empty if block
                        }
                        if ((n2 & 0x10) != 0) {
                            // empty if block
                        }
                    }
                    if (this.last_tick > 0L) {
                        this.distance += this.itofx((int)(l - this.last_tick)) * this.itofx(10) / this.itofx(3000) * this.scroll_speed / 5000;
                    }
                    this.meters = this.fxtoi(this.distance) / 10;
                    this.cm = this.fxtoi(this.distance) % 10;
                    this.distanceScore = this.meters * 10;
                    this.player.position.y += this.player.position.dy;
                    this.player.position.y = Math.max(58, this.player.position.y);
                    if (this.spin_time > 0L || (n2 & 4) == 0) {
                        this.player.position.dy += 24;
                        this.player.position.dy = Math.min(this.player.position.dy, 400);
                    }
                    this.player.position.x += this.player.position.dx;
                    this.player.position.x = Math.max(Math.min(this.player.position.x, this.itofx(182)), this.itofx(58));
                    if (this.scroll_speed > 5000) {
                        this.scroll_speed = Math.max(this.scroll_speed - 20, 5000);
                    } else if (this.scroll_speed < 5000) {
                        this.scroll_speed = Math.min(this.scroll_speed + 20, 5000);
                    }
                    if (this.player.position.dx > 0) {
                        this.player.position.dx = Math.max(this.player.position.dx - 24, 0);
                    } else if (this.player.position.dx < 0) {
                        this.player.position.dx = Math.min(this.player.position.dx + 24, 0);
                    }
                    if (this.direction) {
                        this.diamondSpawn.dy = Math.max(this.diamondSpawn.dy -= 44, -400);
                    }
                    this.diamondSpawn.y += this.diamondSpawn.dy;
                    this.diamondSpawn.y = Math.max(this.itofx(58), this.diamondSpawn.y);
                    this.diamondSpawn.dy += 24;
                    this.diamondSpawn.dy = Math.min(this.diamondSpawn.dy, 400);
                    if (this.diamondSpawn.y <= this.itofx(58)) {
                        this.update_time = this.game_time + 2000L + (long)(Math.abs(this.rand.nextInt() % 4) * 1000);
                        this.direction = false;
                    }
                    if (this.diamondSpawn.y >= this.itofx(this.playarea_h - 58)) {
                        this.update_time = this.game_time + 2000L + (long)(Math.abs(this.rand.nextInt() % 4) * 1000);
                        this.direction = true;
                    }
                    if (this.game_time > this.update_time) {
                        this.update_time = this.game_time + 1000L + (long)(Math.abs(this.rand.nextInt() % 4) * 1000);
                        boolean bl = this.direction = !this.direction;
                    }
                    if (this.player.position.y + this.itofx(this.player.frameHeight >> 1) < this.itofx(this.playarea_h - 30)) {
                        this.sprButton.loop = 0;
                    } else if (this.player.position.y + this.itofx(this.player.frameHeight >> 1) >= this.itofx(this.playarea_h - 30) && this.warning > 0 && this.sprButton.loop == 0) {
                        --this.warning;
                        this.sprButton.loop = 2;
                        this.sprButton.num_loops = 3;
                    }
                    if (this.player.collide(0, this.itofx(this.playarea_h + (this.imgForeground.getHeight() << 1)), this.itofx(240), this.playarea_h, -1, 0)) {
                        this.player.loop = 1;
                        this.player.num_loops = 1;
                        this.player.setAnim(3);
                        this.game.vibrate(200);
                        this.state = 5;
                    } else if (this.spin_time < 0L) {
                        if (this.player.position.dy >= 0 && this.player.animation != 0) {
                            this.player.setAnim(0);
                        } else if (this.player.position.dy < 0 && this.player.animation != 1) {
                            this.player.setAnim(1);
                        }
                    }
                    for (n5 = this.objects.size() - 1; n5 >= 0; --n5) {
                        object = (PackedSprite)this.objects.elementAt(n5);
                        ((PackedSprite)object).nextFrame(this.game_time);
                        if (((PackedSprite)object).type == 4) {
                            if (((PackedSprite)object).position.y < this.player.position.y) {
                                ((PackedSprite)object).position.dy = Math.min(((PackedSprite)object).position.dy + 1240, this.player.position.y);
                            } else if (((PackedSprite)object).position.y > this.player.position.y) {
                                ((PackedSprite)object).position.dy = Math.max(((PackedSprite)object).position.dy - 1240, this.player.position.y);
                            }
                        }
                        ((PackedSprite)object).position.speed = this.scroll_speed * ((PackedSprite)object).position.originalSpeed / 5000;
                        ((PackedSprite)object).position.tick();
                        n4 = this.scrollDirection == 0 ? 0 : 1;
                        n3 = this.player.collide(((PackedSprite)object).position.x + this.itofx(this.player.frameWidth >> 1), ((PackedSprite)object).position.y + this.itofx(this.player.frameHeight >> 1), 1, 1, -1, n4) ? 1 : 0;
                        if (((PackedSprite)object).type <= 2 && !((PackedSprite)object).position.moving) {
                            this.combo = 0;
                        }
                        if (n3 != 0) {
                            PackedSprite packedSprite;
                            if (((PackedSprite)object).type <= 2) {
                                ++this.combo;
                                this.score += 200 * (((PackedSprite)object).type + 1);
                                ((PackedSprite)object).position.moving = false;
                                packedSprite = new PackedSprite(this.imgPop, 197);
                                packedSprite.type = 5;
                                packedSprite.position = new Position(((PackedSprite)object).position.x, ((PackedSprite)object).position.y);
                                packedSprite.position.moveTo(240, this.fxtoi(packedSprite.position.y), 0, ((PackedSprite)object).speed);
                                packedSprite.speed = 200;
                                packedSprite.loop = 1;
                                packedSprite.num_loops = 1;
                                this.objects.addElement(packedSprite);
                            } else if ((((PackedSprite)object).type == 3 || ((PackedSprite)object).type == 4) && this.spin_time < 0L) {
                                ++this.num_hits;
                                this.spin_time = this.game_time + (long)(500 * this.num_hits);
                                this.player.setAnim(2);
                                ((PackedSprite)object).position.moving = false;
                                packedSprite = this.imgBirdPop;
                                if (((PackedSprite)object).type == 4) {
                                    packedSprite = this.imgPigeonPop;
                                }
                                PackedSprite packedSprite2 = new PackedSprite((Image)packedSprite, 249);
                                packedSprite2.type = 5;
                                packedSprite2.position = new Position(((PackedSprite)object).position.x, ((PackedSprite)object).position.y);
                                packedSprite2.position.moveTo(240, this.fxtoi(packedSprite2.position.y), 0, ((PackedSprite)object).speed);
                                packedSprite2.speed = 150;
                                packedSprite2.loop = 1;
                                packedSprite2.num_loops = 1;
                                this.objects.addElement(packedSprite2);
                            }
                        }
                        if (((PackedSprite)object).type == 5) {
                            if (((PackedSprite)object).loop != 0) continue;
                            this.objects.removeElementAt(n5);
                            continue;
                        }
                        if (((PackedSprite)object).position.moving) continue;
                        this.objects.removeElementAt(n5);
                    }
                }
                if ((long)this.fxtoi(this.distance) > this.spawn_time) {
                    n5 = Math.min(this.combo / 5, 2);
                    this.createDiamond(n5);
                    this.spawn_time = this.fxtoi(this.distance) + 6 + Math.abs(this.rand.nextInt() % 4);
                }
                if (this.bird_time > this.bird_spawn) {
                    if (this.bird_time < 180000L) {
                        this.createBird(0, this.playarea_h);
                    } else {
                        this.createBird(0, this.playarea_h >> 1);
                        this.createBird(this.playarea_h >> 1, this.playarea_h >> 1);
                    }
                    long l2 = Math.max(5000L - this.bird_time / 20000L * 500L, 1000L);
                    this.bird_spawn = this.bird_time + l2;
                }
                if (this.spin_time <= 0L || this.game_time <= this.spin_time) break;
                this.spin_time = -1L;
                this.player.setAnim(0);
                break;
            }
            case 5: {
                this.player.nextFrame(this.game_time);
                if (this.player.loop != 0) break;
                this.state = 6;
                this.game.setResultScreen(3, this.score + this.distanceScore);
                break;
            }
            case 6: {
                if (n == 0) break;
                switch (n) {
                    case 8: 
                    case 53: {
                        this.game.state = this.game.isMini ? 4 : 2;
                    }
                }
            }
        }
        this.last_tick = l;
        this.offset_y = -Math.min(Math.max(this.fxtoi(this.player.position.y) - 174, 0), this.playarea_h - 348);
        if (this.state < 5 && this.game_time > this.anim_time) {
            this.anim_time = this.game_time + 25L;
            this.foreground.speed = this.scroll_speed * this.foreground.originalSpeed / 5000;
            this.foreground.tick();
            if (!this.foreground.moving) {
                this.foreground.x = this.itofx(-this.imgForeground.getWidth() * 4);
                this.foreground.moveTo(0, 0, 0, 300);
            }
            this.background.speed = this.scroll_speed * this.background.originalSpeed / 5000;
            this.background.tick();
            if (!this.background.moving) {
                this.background.x = this.itofx(-this.imgBackground.getWidth());
                this.background.moveTo(240, 0, 0, 75);
            }
            for (int i = this.clouds.size() - 1; i >= 0; --i) {
                object = (Position)this.clouds.elementAt(i);
                ((Position)object).speed = this.scroll_speed * ((Position)object).originalSpeed / 5000;
                ((Position)object).tick();
                if (((Position)object).moving) continue;
                n4 = (this.rand.nextInt() >>> 1) % 4;
                n3 = this.playarea_h / 5 + this.playarea_h * n4 / 6;
                ((Position)object).y = this.itofx(n3);
                ((Position)object).x = this.itofx(-this.imgCloud[((Position)object).param1].getWidth());
                ((Position)object).moveTo(240, n3, 0, 120 + (4 - ((Position)object).param1) * 225);
            }
            this.player.nextFrame(this.game_time);
        }
    }

    public void render(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = this.imgBackground.getHeight();
        int n5 = this.playarea_h - n4 + this.offset_y;
        graphics.setClip(0, 0, 240, 348);
        graphics.setColor(1151738);
        graphics.fillRect(0, 0, 240, 348);
        Game.GradientHorizontal(graphics, 0, n5 - 174, 240, 174 - n4, 1151738, 0xFFFFFF);
        int n6 = n5 - 174 + (174 - n4);
        Game.GradientHorizontal(graphics, 0, n6, 240, 348 - n6, 10382121, 15114827);
        for (n3 = 0; n3 < this.clouds.size(); ++n3) {
            Position position = (Position)this.clouds.elementAt(n3);
            if (this.scrollDirection == 0) {
                graphics.drawImage(this.imgCloud[position.param1], this.fxtoi(position.x), this.fxtoi(position.y) + this.offset_y, 6);
                continue;
            }
            graphics.drawImage(this.imgCloud[position.param1], 240 - this.fxtoi(position.x), this.fxtoi(position.y) + this.offset_y, 10);
        }
        if (this.scrollDirection == 0) {
            graphics.drawImage(this.imgBackground, this.fxtoi(this.background.x), this.playarea_h - (n4 << 1) + this.offset_y, 6);
        } else {
            graphics.drawImage(this.imgBackground, 240 - this.fxtoi(this.background.x), this.playarea_h - (n4 << 1) + this.offset_y, 10);
        }
        for (n3 = this.fxtoi(this.foreground.x); n3 < 240; n3 += this.imgForeground.getWidth() * 4) {
            if (this.scrollDirection == 0) {
                graphics.drawImage(this.imgForeground, n3, this.playarea_h - (n4 + this.imgForeground.getHeight()) + this.offset_y, 6);
                continue;
            }
            graphics.drawImage(this.imgForeground, 240 - n3, this.playarea_h - (n4 + this.imgForeground.getHeight()) + this.offset_y, 10);
        }
        for (n2 = 0; n2 < this.objects.size(); ++n2) {
            PackedSprite packedSprite = (PackedSprite)this.objects.elementAt(n2);
            if (packedSprite.type == 5) continue;
            if (this.scrollDirection == 0) {
                packedSprite.render(graphics, this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y) + this.offset_y, packedSprite.frame, 0, 3);
                continue;
            }
            packedSprite.render(graphics, 240 - this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y) + this.offset_y, packedSprite.frame, 0, 6);
        }
        if (this.scrollDirection == 0) {
            if (this.state == 4) {
                graphics.setColor(6766865);
                n2 = this.playarea_h + (this.imgForeground.getHeight() << 1);
                int n7 = (this.fxtoi(this.player.position.y) - this.player.frameHeight) * 2;
                n = n7 * (this.player.frameWidth >> 3) / n2;
                graphics.fillArc(this.fxtoi(this.player.position.x) - n, this.playarea_h - this.imgForeground.getHeight() + this.offset_y - n, n << 1, n << 1, 0, 360);
            }
            this.player.render(graphics, this.fxtoi(this.player.position.x), this.fxtoi(this.player.position.y) + this.offset_y, this.player.frame, this.player.animation, 3);
        } else {
            if (this.state == 4) {
                graphics.setColor(6766865);
                n2 = this.playarea_h + (this.imgForeground.getHeight() << 1);
                int n8 = (this.fxtoi(this.player.position.y) - this.player.frameHeight) * 2;
                n = n8 * (this.player.frameWidth >> 3) / n2;
                graphics.fillArc(240 - this.fxtoi(this.player.position.x) - n, this.playarea_h - this.imgForeground.getHeight() + this.offset_y - n, n << 1, n << 1, 0, 360);
            }
            this.player.render(graphics, 240 - this.fxtoi(this.player.position.x), this.fxtoi(this.player.position.y) + this.offset_y, this.player.frame, this.player.animation, 3);
        }
        for (n2 = 0; n2 < this.objects.size(); ++n2) {
            PackedSprite packedSprite = (PackedSprite)this.objects.elementAt(n2);
            if (packedSprite.type != 5) continue;
            if (this.scrollDirection == 0) {
                packedSprite.render(graphics, this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y) + this.offset_y, packedSprite.frame, 0, 3);
                continue;
            }
            packedSprite.render(graphics, 240 - this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y) + this.offset_y, packedSprite.frame, 0, 3);
        }
        graphics.drawImage(this.imgTime, 0, 0, 20);
        graphics.drawImage(this.imgMeters, 0, 0, 20);
        String string = ".";
        this.font.print(graphics, Integer.toString(this.meters) + string + Integer.toString(this.cm), 26, 2, 20);
        graphics.drawImage(this.imgScore, 240, 0, 24);
        this.font.print(graphics, this.game.formatScore(this.score + this.distanceScore), 236, 2, 24);
        if (this.state == 0) {
            this.drawIntroScreen(graphics);
        } else if (this.state <= 3) {
            this.game.drawStoplight(graphics, this.state);
        } else if (this.state == 6) {
            this.game.renderResultScreen(graphics, 3, this.score + this.distanceScore);
        }
        if (this.state != 0 && this.state != 6) {
            int n9 = 240 - this.imgDPad.getWidth() - 4;
            n = (348 - this.imgDPad.getHeight() >> 1) - 4;
            graphics.drawImage(this.imgDPad, n9, n, 20);
            Game.addPointer(n9, n, 24, 24, -1);
            Game.addPointer(n9, n + 48, 24, 24, -2);
        }
    }

    void drawIntroScreen(Graphics graphics) {
        char[] cArray = this.game.fontTiny.wrap(this.game.strings[97], 222);
        int n = this.imgIntro.getWidth() + 10 + 8;
        int n2 = this.imgIntro.getHeight() + this.game.defaultFont.height + 10 + 8;
        int n3 = 120 - (n >> 1);
        int n4 = 174 - (n2 >> 1);
        Menu.drawMenuBox(graphics, n3, n4, n, n2);
        Game.addPointer(0, 0, 240, 348, -5);
        graphics.drawImage(this.imgIntro, n3 + (n >> 1), n4 + this.game.defaultFont.height + 5 + 4, 17);
        this.game.defaultFont.print(graphics, this.game.strings[34], n3 + (n >> 1), n4 + 2 + 5, 17);
    }
}

